

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Functions
    ( 

 -- * Methods


-- ** boxedCopy #method:boxedCopy#

    boxedCopy                               ,


-- ** boxedFree #method:boxedFree#

    boxedFree                               ,


-- ** boxedTypeRegisterStatic #method:boxedTypeRegisterStatic#

    boxedTypeRegisterStatic                 ,


-- ** clearSignalHandler #method:clearSignalHandler#

    clearSignalHandler                      ,


-- ** enumCompleteTypeInfo #method:enumCompleteTypeInfo#

    enumCompleteTypeInfo                    ,


-- ** enumGetValue #method:enumGetValue#

    enumGetValue                            ,


-- ** enumGetValueByName #method:enumGetValueByName#

    enumGetValueByName                      ,


-- ** enumGetValueByNick #method:enumGetValueByNick#

    enumGetValueByNick                      ,


-- ** enumRegisterStatic #method:enumRegisterStatic#

    enumRegisterStatic                      ,


-- ** enumToString #method:enumToString#

    enumToString                            ,


-- ** flagsCompleteTypeInfo #method:flagsCompleteTypeInfo#

    flagsCompleteTypeInfo                   ,


-- ** flagsGetFirstValue #method:flagsGetFirstValue#

    flagsGetFirstValue                      ,


-- ** flagsGetValueByName #method:flagsGetValueByName#

    flagsGetValueByName                     ,


-- ** flagsGetValueByNick #method:flagsGetValueByNick#

    flagsGetValueByNick                     ,


-- ** flagsRegisterStatic #method:flagsRegisterStatic#

    flagsRegisterStatic                     ,


-- ** flagsToString #method:flagsToString#

    flagsToString                           ,


-- ** gtypeGetType #method:gtypeGetType#

    gtypeGetType                            ,


-- ** paramSpecBoolean #method:paramSpecBoolean#

    paramSpecBoolean                        ,


-- ** paramSpecBoxed #method:paramSpecBoxed#

    paramSpecBoxed                          ,


-- ** paramSpecChar #method:paramSpecChar#

    paramSpecChar                           ,


-- ** paramSpecDouble #method:paramSpecDouble#

    paramSpecDouble                         ,


-- ** paramSpecEnum #method:paramSpecEnum#

    paramSpecEnum                           ,


-- ** paramSpecFlags #method:paramSpecFlags#

    paramSpecFlags                          ,


-- ** paramSpecFloat #method:paramSpecFloat#

    paramSpecFloat                          ,


-- ** paramSpecGtype #method:paramSpecGtype#

    paramSpecGtype                          ,


-- ** paramSpecInt #method:paramSpecInt#

    paramSpecInt                            ,


-- ** paramSpecInt64 #method:paramSpecInt64#

    paramSpecInt64                          ,


-- ** paramSpecLong #method:paramSpecLong#

    paramSpecLong                           ,


-- ** paramSpecObject #method:paramSpecObject#

    paramSpecObject                         ,


-- ** paramSpecParam #method:paramSpecParam#

    paramSpecParam                          ,


-- ** paramSpecPointer #method:paramSpecPointer#

    paramSpecPointer                        ,


-- ** paramSpecString #method:paramSpecString#

    paramSpecString                         ,


-- ** paramSpecUchar #method:paramSpecUchar#

    paramSpecUchar                          ,


-- ** paramSpecUint #method:paramSpecUint#

    paramSpecUint                           ,


-- ** paramSpecUint64 #method:paramSpecUint64#

    paramSpecUint64                         ,


-- ** paramSpecUlong #method:paramSpecUlong#

    paramSpecUlong                          ,


-- ** paramSpecUnichar #method:paramSpecUnichar#

    paramSpecUnichar                        ,


-- ** paramSpecVariant #method:paramSpecVariant#

    paramSpecVariant                        ,


-- ** paramTypeRegisterStatic #method:paramTypeRegisterStatic#

    paramTypeRegisterStatic                 ,


-- ** paramValueConvert #method:paramValueConvert#

    paramValueConvert                       ,


-- ** paramValueDefaults #method:paramValueDefaults#

    paramValueDefaults                      ,


-- ** paramValueIsValid #method:paramValueIsValid#

    paramValueIsValid                       ,


-- ** paramValueSetDefault #method:paramValueSetDefault#

    paramValueSetDefault                    ,


-- ** paramValueValidate #method:paramValueValidate#

    paramValueValidate                      ,


-- ** paramValuesCmp #method:paramValuesCmp#

    paramValuesCmp                          ,


-- ** pointerTypeRegisterStatic #method:pointerTypeRegisterStatic#

    pointerTypeRegisterStatic               ,


-- ** signalAccumulatorFirstWins #method:signalAccumulatorFirstWins#

    signalAccumulatorFirstWins              ,


-- ** signalAccumulatorTrueHandled #method:signalAccumulatorTrueHandled#

    signalAccumulatorTrueHandled            ,


-- ** signalAddEmissionHook #method:signalAddEmissionHook#

    signalAddEmissionHook                   ,


-- ** signalChainFromOverridden #method:signalChainFromOverridden#

    signalChainFromOverridden               ,


-- ** signalConnectClosure #method:signalConnectClosure#

    signalConnectClosure                    ,


-- ** signalConnectClosureById #method:signalConnectClosureById#

    signalConnectClosureById                ,


-- ** signalEmitv #method:signalEmitv#

    signalEmitv                             ,


-- ** signalGetInvocationHint #method:signalGetInvocationHint#

    signalGetInvocationHint                 ,


-- ** signalHandlerBlock #method:signalHandlerBlock#

    signalHandlerBlock                      ,


-- ** signalHandlerDisconnect #method:signalHandlerDisconnect#

    signalHandlerDisconnect                 ,


-- ** signalHandlerFind #method:signalHandlerFind#

    signalHandlerFind                       ,


-- ** signalHandlerIsConnected #method:signalHandlerIsConnected#

    signalHandlerIsConnected                ,


-- ** signalHandlerUnblock #method:signalHandlerUnblock#

    signalHandlerUnblock                    ,


-- ** signalHandlersBlockMatched #method:signalHandlersBlockMatched#

    signalHandlersBlockMatched              ,


-- ** signalHandlersDestroy #method:signalHandlersDestroy#

    signalHandlersDestroy                   ,


-- ** signalHandlersDisconnectMatched #method:signalHandlersDisconnectMatched#

    signalHandlersDisconnectMatched         ,


-- ** signalHandlersUnblockMatched #method:signalHandlersUnblockMatched#

    signalHandlersUnblockMatched            ,


-- ** signalHasHandlerPending #method:signalHasHandlerPending#

    signalHasHandlerPending                 ,


-- ** signalIsValidName #method:signalIsValidName#

    signalIsValidName                       ,


-- ** signalListIds #method:signalListIds#

    signalListIds                           ,


-- ** signalLookup #method:signalLookup#

    signalLookup                            ,


-- ** signalName #method:signalName#

    signalName                              ,


-- ** signalOverrideClassClosure #method:signalOverrideClassClosure#

    signalOverrideClassClosure              ,


-- ** signalOverrideClassHandler #method:signalOverrideClassHandler#

    signalOverrideClassHandler              ,


-- ** signalParseName #method:signalParseName#

    signalParseName                         ,


-- ** signalQuery #method:signalQuery#

    signalQuery                             ,


-- ** signalRemoveEmissionHook #method:signalRemoveEmissionHook#

    signalRemoveEmissionHook                ,


-- ** signalStopEmission #method:signalStopEmission#

    signalStopEmission                      ,


-- ** signalStopEmissionByName #method:signalStopEmissionByName#

    signalStopEmissionByName                ,


-- ** signalTypeCclosureNew #method:signalTypeCclosureNew#

    signalTypeCclosureNew                   ,


-- ** strdupValueContents #method:strdupValueContents#

    strdupValueContents                     ,


-- ** typeAddClassPrivate #method:typeAddClassPrivate#

    typeAddClassPrivate                     ,


-- ** typeAddInstancePrivate #method:typeAddInstancePrivate#

    typeAddInstancePrivate                  ,


-- ** typeAddInterfaceDynamic #method:typeAddInterfaceDynamic#

    typeAddInterfaceDynamic                 ,


-- ** typeAddInterfaceStatic #method:typeAddInterfaceStatic#

    typeAddInterfaceStatic                  ,


-- ** typeCheckClassIsA #method:typeCheckClassIsA#

    typeCheckClassIsA                       ,


-- ** typeCheckInstance #method:typeCheckInstance#

    typeCheckInstance                       ,


-- ** typeCheckInstanceIsA #method:typeCheckInstanceIsA#

    typeCheckInstanceIsA                    ,


-- ** typeCheckInstanceIsFundamentallyA #method:typeCheckInstanceIsFundamentallyA#

    typeCheckInstanceIsFundamentallyA       ,


-- ** typeCheckIsValueType #method:typeCheckIsValueType#

    typeCheckIsValueType                    ,


-- ** typeCheckValue #method:typeCheckValue#

    typeCheckValue                          ,


-- ** typeCheckValueHolds #method:typeCheckValueHolds#

    typeCheckValueHolds                     ,


-- ** typeChildren #method:typeChildren#

    typeChildren                            ,


-- ** typeDefaultInterfaceGet #method:typeDefaultInterfaceGet#

    typeDefaultInterfaceGet                 ,


-- ** typeDefaultInterfacePeek #method:typeDefaultInterfacePeek#

    typeDefaultInterfacePeek                ,


-- ** typeDefaultInterfaceRef #method:typeDefaultInterfaceRef#

    typeDefaultInterfaceRef                 ,


-- ** typeDefaultInterfaceUnref #method:typeDefaultInterfaceUnref#

    typeDefaultInterfaceUnref               ,


-- ** typeDepth #method:typeDepth#

    typeDepth                               ,


-- ** typeEnsure #method:typeEnsure#

    typeEnsure                              ,


-- ** typeFreeInstance #method:typeFreeInstance#

    typeFreeInstance                        ,


-- ** typeFromName #method:typeFromName#

    typeFromName                            ,


-- ** typeFundamental #method:typeFundamental#

    typeFundamental                         ,


-- ** typeFundamentalNext #method:typeFundamentalNext#

    typeFundamentalNext                     ,


-- ** typeGetInstanceCount #method:typeGetInstanceCount#

    typeGetInstanceCount                    ,


-- ** typeGetPlugin #method:typeGetPlugin#

    typeGetPlugin                           ,


-- ** typeGetQdata #method:typeGetQdata#

    typeGetQdata                            ,


-- ** typeGetTypeRegistrationSerial #method:typeGetTypeRegistrationSerial#

    typeGetTypeRegistrationSerial           ,


-- ** typeInit #method:typeInit#

    typeInit                                ,


-- ** typeInitWithDebugFlags #method:typeInitWithDebugFlags#

    typeInitWithDebugFlags                  ,


-- ** typeInterfaces #method:typeInterfaces#

    typeInterfaces                          ,


-- ** typeIsA #method:typeIsA#

    typeIsA                                 ,


-- ** typeName #method:typeName#

    typeName                                ,


-- ** typeNameFromClass #method:typeNameFromClass#

    typeNameFromClass                       ,


-- ** typeNameFromInstance #method:typeNameFromInstance#

    typeNameFromInstance                    ,


-- ** typeNextBase #method:typeNextBase#

    typeNextBase                            ,


-- ** typeParent #method:typeParent#

    typeParent                              ,


-- ** typeQname #method:typeQname#

    typeQname                               ,


-- ** typeQuery #method:typeQuery#

    typeQuery                               ,


-- ** typeRegisterDynamic #method:typeRegisterDynamic#

    typeRegisterDynamic                     ,


-- ** typeRegisterFundamental #method:typeRegisterFundamental#

    typeRegisterFundamental                 ,


-- ** typeRegisterStatic #method:typeRegisterStatic#

    typeRegisterStatic                      ,


-- ** typeSetQdata #method:typeSetQdata#

    typeSetQdata                            ,


-- ** typeTestFlags #method:typeTestFlags#

    typeTestFlags                           ,


-- ** variantGetGtype #method:variantGetGtype#

    variantGetGtype                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumClass as GObject.EnumClass
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsClass as GObject.FlagsClass
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.ParamSpecTypeInfo as GObject.ParamSpecTypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalInvocationHint as GObject.SignalInvocationHint
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalQuery as GObject.SignalQuery
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeFundamentalInfo as GObject.TypeFundamentalInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInstance as GObject.TypeInstance
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeQuery as GObject.TypeQuery
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumClass as GObject.EnumClass
import {-# SOURCE #-} qualified GI.GObject.Structs.EnumValue as GObject.EnumValue
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsClass as GObject.FlagsClass
import {-# SOURCE #-} qualified GI.GObject.Structs.FlagsValue as GObject.FlagsValue
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.ParamSpecTypeInfo as GObject.ParamSpecTypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalInvocationHint as GObject.SignalInvocationHint
import {-# SOURCE #-} qualified GI.GObject.Structs.SignalQuery as GObject.SignalQuery
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeFundamentalInfo as GObject.TypeFundamentalInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInstance as GObject.TypeInstance
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeQuery as GObject.TypeQuery

#endif

-- function variant_get_gtype
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_variant_get_gtype" g_variant_get_gtype :: 
    IO CGType

-- | /No description available in the introspection data./
variantGetGtype ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GType
variantGetGtype  = liftIO $ do
    result <- g_variant_get_gtype
    let result' = GType result
    return result'


-- function type_test_flags
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_test_flags" g_type_test_flags :: 
    CGType ->                               -- type : TBasicType TGType
    Word32 ->                               -- flags : TBasicType TUInt
    IO CInt

-- | /No description available in the introspection data./
typeTestFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -> Word32
    -> m Bool
typeTestFlags type_ flags = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_test_flags type_' flags
    let result' = (/= 0) result
    return result'


-- function type_set_qdata
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark id to identify the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_set_qdata" g_type_set_qdata :: 
    CGType ->                               -- type : TBasicType TGType
    Word32 ->                               -- quark : TBasicType TUInt32
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Attaches arbitrary data to a type.
typeSetQdata ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: a t'GType'
    -> Word32
    -- ^ /@quark@/: a @/GQuark/@ id to identify the data
    -> Ptr ()
    -- ^ /@data@/: the data
    -> m ()
typeSetQdata type_ quark data_ = liftIO $ do
    let type_' = gtypeToCGType type_
    g_type_set_qdata type_' quark data_
    return ()


-- function type_register_static
-- Args: [ Arg
--           { argCName = "parent_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type from which this type will be derived"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "0-terminated string used as the name of the new type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GTypeInfo structure for this type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitwise combination of #GTypeFlags values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_register_static" g_type_register_static :: 
    CGType ->                               -- parent_type : TBasicType TGType
    CString ->                              -- type_name : TBasicType TUTF8
    Ptr GObject.TypeInfo.TypeInfo ->        -- info : TInterface (Name {namespace = "GObject", name = "TypeInfo"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "TypeFlags"})
    IO CGType

-- | Registers /@typeName@/ as the name of a new static type derived from
-- /@parentType@/. The type system uses the information contained in the
-- t'GI.GObject.Structs.TypeInfo.TypeInfo' structure pointed to by /@info@/ to manage the type and its
-- instances (if not abstract). The value of /@flags@/ determines the nature
-- (e.g. abstract or not) of the type.
typeRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@parentType@/: type from which this type will be derived
    -> T.Text
    -- ^ /@typeName@/: 0-terminated string used as the name of the new type
    -> GObject.TypeInfo.TypeInfo
    -- ^ /@info@/: t'GI.GObject.Structs.TypeInfo.TypeInfo' structure for this type
    -> [GObject.Flags.TypeFlags]
    -- ^ /@flags@/: bitwise combination of t'GI.GObject.Flags.TypeFlags' values
    -> m GType
    -- ^ __Returns:__ the new type identifier
typeRegisterStatic parentType typeName info flags = liftIO $ do
    let parentType' = gtypeToCGType parentType
    typeName' <- textToCString typeName
    info' <- unsafeManagedPtrGetPtr info
    let flags' = gflagsToWord flags
    result <- g_type_register_static parentType' typeName' info' flags'
    let result' = GType result
    touchManagedPtr info
    freeMem typeName'
    return result'


-- function type_register_fundamental
-- Args: [ Arg
--           { argCName = "type_id"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a predefined type identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "0-terminated string used as the name of the new type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GTypeInfo structure for this type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "finfo"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "TypeFundamentalInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GTypeFundamentalInfo structure for this type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitwise combination of #GTypeFlags values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_register_fundamental" g_type_register_fundamental :: 
    CGType ->                               -- type_id : TBasicType TGType
    CString ->                              -- type_name : TBasicType TUTF8
    Ptr GObject.TypeInfo.TypeInfo ->        -- info : TInterface (Name {namespace = "GObject", name = "TypeInfo"})
    Ptr GObject.TypeFundamentalInfo.TypeFundamentalInfo -> -- finfo : TInterface (Name {namespace = "GObject", name = "TypeFundamentalInfo"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "TypeFlags"})
    IO CGType

-- | Registers /@typeId@/ as the predefined identifier and /@typeName@/ as the
-- name of a fundamental type. If /@typeId@/ is already registered, or a
-- type named /@typeName@/ is already registered, the behaviour is undefined.
-- The type system uses the information contained in the t'GI.GObject.Structs.TypeInfo.TypeInfo' structure
-- pointed to by /@info@/ and the t'GI.GObject.Structs.TypeFundamentalInfo.TypeFundamentalInfo' structure pointed to by
-- /@finfo@/ to manage the type and its instances. The value of /@flags@/ determines
-- additional characteristics of the fundamental type.
typeRegisterFundamental ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@typeId@/: a predefined type identifier
    -> T.Text
    -- ^ /@typeName@/: 0-terminated string used as the name of the new type
    -> GObject.TypeInfo.TypeInfo
    -- ^ /@info@/: t'GI.GObject.Structs.TypeInfo.TypeInfo' structure for this type
    -> GObject.TypeFundamentalInfo.TypeFundamentalInfo
    -- ^ /@finfo@/: t'GI.GObject.Structs.TypeFundamentalInfo.TypeFundamentalInfo' structure for this type
    -> [GObject.Flags.TypeFlags]
    -- ^ /@flags@/: bitwise combination of t'GI.GObject.Flags.TypeFlags' values
    -> m GType
    -- ^ __Returns:__ the predefined type identifier
typeRegisterFundamental typeId typeName info finfo flags = liftIO $ do
    let typeId' = gtypeToCGType typeId
    typeName' <- textToCString typeName
    info' <- unsafeManagedPtrGetPtr info
    finfo' <- unsafeManagedPtrGetPtr finfo
    let flags' = gflagsToWord flags
    result <- g_type_register_fundamental typeId' typeName' info' finfo' flags'
    let result' = GType result
    touchManagedPtr info
    touchManagedPtr finfo
    freeMem typeName'
    return result'


-- function type_register_dynamic
-- Args: [ Arg
--           { argCName = "parent_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type from which this type will be derived"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "0-terminated string used as the name of the new type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#GTypePlugin structure to retrieve the #GTypeInfo from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bitwise combination of #GTypeFlags values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_register_dynamic" g_type_register_dynamic :: 
    CGType ->                               -- parent_type : TBasicType TGType
    CString ->                              -- type_name : TBasicType TUTF8
    Ptr GObject.TypePlugin.TypePlugin ->    -- plugin : TInterface (Name {namespace = "GObject", name = "TypePlugin"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "TypeFlags"})
    IO CGType

-- | Registers /@typeName@/ as the name of a new dynamic type derived from
-- /@parentType@/.  The type system uses the information contained in the
-- t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure pointed to by /@plugin@/ to manage the type and its
-- instances (if not abstract).  The value of /@flags@/ determines the nature
-- (e.g. abstract or not) of the type.
typeRegisterDynamic ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    GType
    -- ^ /@parentType@/: type from which this type will be derived
    -> T.Text
    -- ^ /@typeName@/: 0-terminated string used as the name of the new type
    -> a
    -- ^ /@plugin@/: t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure to retrieve the t'GI.GObject.Structs.TypeInfo.TypeInfo' from
    -> [GObject.Flags.TypeFlags]
    -- ^ /@flags@/: bitwise combination of t'GI.GObject.Flags.TypeFlags' values
    -> m GType
    -- ^ __Returns:__ the new type identifier or @/G_TYPE_INVALID/@ if registration failed
typeRegisterDynamic parentType typeName plugin flags = liftIO $ do
    let parentType' = gtypeToCGType parentType
    typeName' <- textToCString typeName
    plugin' <- unsafeManagedPtrCastPtr plugin
    let flags' = gflagsToWord flags
    result <- g_type_register_dynamic parentType' typeName' plugin' flags'
    let result' = GType result
    touchManagedPtr plugin
    freeMem typeName'
    return result'


-- function type_query
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType of a static, classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "query"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeQuery" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a user provided structure that is\n    filled in with constant values upon success"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_query" g_type_query :: 
    CGType ->                               -- type : TBasicType TGType
    Ptr GObject.TypeQuery.TypeQuery ->      -- query : TInterface (Name {namespace = "GObject", name = "TypeQuery"})
    IO ()

-- | Queries the type system for information about a specific type.
-- 
-- This function will fill in a user-provided structure to hold
-- type-specific information. If an invalid t'GType' is passed in, the
-- /@type@/ member of the t'GI.GObject.Structs.TypeQuery.TypeQuery' is 0. All members filled into the
-- t'GI.GObject.Structs.TypeQuery.TypeQuery' structure should be considered constant and have to be
-- left untouched.
-- 
-- Since GLib 2.78, this function allows queries on dynamic types. Previously
-- it only supported static types.
typeQuery ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: t'GType' of a static, classed type
    -> m (GObject.TypeQuery.TypeQuery)
typeQuery type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    query <- SP.callocBytes 24 :: IO (Ptr GObject.TypeQuery.TypeQuery)
    g_type_query type_' query
    query' <- (wrapPtr GObject.TypeQuery.TypeQuery) query
    return query'


-- function type_qname
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type to return quark of type name for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_qname" g_type_qname :: 
    CGType ->                               -- type : TBasicType TGType
    IO Word32

-- | Get the corresponding quark of the type IDs name.
typeQname ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type to return quark of type name for
    -> m Word32
    -- ^ __Returns:__ the type names quark or 0
typeQname type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_qname type_'
    return result


-- function type_parent
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the derived type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_parent" g_type_parent :: 
    CGType ->                               -- type : TBasicType TGType
    IO CGType

-- | Return the direct parent type of the passed in type. If the passed
-- in type has no parent, i.e. is a fundamental type, 0 is returned.
typeParent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: the derived type
    -> m GType
    -- ^ __Returns:__ the parent type
typeParent type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_parent type_'
    let result' = GType result
    return result'


-- function type_next_base
-- Args: [ Arg
--           { argCName = "leaf_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "descendant of @root_type and the type to be returned"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "immediate parent of the returned type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_next_base" g_type_next_base :: 
    CGType ->                               -- leaf_type : TBasicType TGType
    CGType ->                               -- root_type : TBasicType TGType
    IO CGType

-- | Given a /@leafType@/ and a /@rootType@/ which is contained in its
-- ancestry, return the type that /@rootType@/ is the immediate parent
-- of. In other words, this function determines the type that is
-- derived directly from /@rootType@/ which is also a base class of
-- /@leafType@/.  Given a root type and a leaf type, this function can
-- be used to determine the types and order in which the leaf type is
-- descended from the root type.
typeNextBase ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@leafType@/: descendant of /@rootType@/ and the type to be returned
    -> GType
    -- ^ /@rootType@/: immediate parent of the returned type
    -> m GType
    -- ^ __Returns:__ immediate child of /@rootType@/ and ancestor of /@leafType@/
typeNextBase leafType rootType = liftIO $ do
    let leafType' = gtypeToCGType leafType
    let rootType' = gtypeToCGType rootType
    result <- g_type_next_base leafType' rootType'
    let result' = GType result
    return result'


-- function type_name_from_instance
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_name_from_instance" g_type_name_from_instance :: 
    Ptr GObject.TypeInstance.TypeInstance -> -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    IO CString

-- | /No description available in the introspection data./
typeNameFromInstance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInstance.TypeInstance
    -> m T.Text
typeNameFromInstance instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    result <- g_type_name_from_instance instance_'
    checkUnexpectedReturnNULL "typeNameFromInstance" result
    result' <- cstringToText result
    touchManagedPtr instance_
    return result'


-- function type_name_from_class
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_name_from_class" g_type_name_from_class :: 
    Ptr GObject.TypeClass.TypeClass ->      -- g_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    IO CString

-- | /No description available in the introspection data./
typeNameFromClass ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeClass.TypeClass
    -> m T.Text
typeNameFromClass gClass = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    result <- g_type_name_from_class gClass'
    checkUnexpectedReturnNULL "typeNameFromClass" result
    result' <- cstringToText result
    touchManagedPtr gClass
    return result'


-- function type_name
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type to return name for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_name" g_type_name :: 
    CGType ->                               -- type : TBasicType TGType
    IO CString

-- | Get the unique name that is assigned to a type ID.
-- 
-- Note that this function (like all other GType API) cannot cope with
-- invalid type IDs. @/G_TYPE_INVALID/@ may be passed to this function, as
-- may be any other validly registered type ID, but randomized type IDs
-- should not be passed in and will most likely lead to a crash.
typeName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type to return name for
    -> m (Maybe T.Text)
    -- ^ __Returns:__ static type name or 'P.Nothing'
typeName type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_name type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function type_is_a
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type to check ancestry for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_a_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "possible ancestor of @type or interface that @type\n    could conform to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_is_a" g_type_is_a :: 
    CGType ->                               -- type : TBasicType TGType
    CGType ->                               -- is_a_type : TBasicType TGType
    IO CInt

-- | If /@isAType@/ is a derivable type, check whether /@type@/ is a
-- descendant of /@isAType@/. If /@isAType@/ is an interface, check
-- whether /@type@/ conforms to it.
typeIsA ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: type to check ancestry for
    -> GType
    -- ^ /@isAType@/: possible ancestor of /@type@/ or interface that /@type@/
    --     could conform to
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@type@/ is a /@isAType@/
typeIsA type_ isAType = liftIO $ do
    let type_' = gtypeToCGType type_
    let isAType' = gtypeToCGType isAType
    result <- g_type_is_a type_' isAType'
    let result' = (/= 0) result
    return result'


-- function type_interfaces
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type to list interface types for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_interfaces"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the length of\n    the returned array, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_interfaces"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "location to store the length of\n    the returned array, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TGType))
-- throws : False
-- Skip return : False

foreign import ccall "g_type_interfaces" g_type_interfaces :: 
    CGType ->                               -- type : TBasicType TGType
    Ptr Word32 ->                           -- n_interfaces : TBasicType TUInt
    IO (Ptr CGType)

-- | Return a newly allocated and 0-terminated array of type IDs, listing
-- the interface types that /@type@/ conforms to.
typeInterfaces ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: the type to list interface types for
    -> m [GType]
    -- ^ __Returns:__ Newly allocated
    --     and 0-terminated array of interface types, free with 'GI.GLib.Functions.free'
typeInterfaces type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    nInterfaces <- allocMem :: IO (Ptr Word32)
    result <- g_type_interfaces type_' nInterfaces
    nInterfaces' <- peek nInterfaces
    checkUnexpectedReturnNULL "typeInterfaces" result
    result' <- (unpackMapStorableArrayWithLength GType nInterfaces') result
    freeMem result
    freeMem nInterfaces
    return result'


-- function type_init_with_debug_flags
-- Args: [ Arg
--           { argCName = "debug_flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeDebugFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "bitwise combination of #GTypeDebugFlags values for\n    debugging purposes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_init_with_debug_flags" g_type_init_with_debug_flags :: 
    CUInt ->                                -- debug_flags : TInterface (Name {namespace = "GObject", name = "TypeDebugFlags"})
    IO ()

{-# DEPRECATED typeInitWithDebugFlags ["(Since version 2.36)","the type system is now initialised automatically"] #-}
-- | This function used to initialise the type system with debugging
-- flags.  Since GLib 2.36, the type system is initialised automatically
-- and this function does nothing.
-- 
-- If you need to enable debugging features, use the @GOBJECT_DEBUG@
-- environment variable.
typeInitWithDebugFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GObject.Flags.TypeDebugFlags]
    -- ^ /@debugFlags@/: bitwise combination of t'GI.GObject.Flags.TypeDebugFlags' values for
    --     debugging purposes
    -> m ()
typeInitWithDebugFlags debugFlags = liftIO $ do
    let debugFlags' = gflagsToWord debugFlags
    g_type_init_with_debug_flags debugFlags'
    return ()


-- function type_init
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_init" g_type_init :: 
    IO ()

{-# DEPRECATED typeInit ["(Since version 2.36)","the type system is now initialised automatically"] #-}
-- | This function used to initialise the type system.  Since GLib 2.36,
-- the type system is initialised automatically and this function does
-- nothing.
typeInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
typeInit  = liftIO $ do
    g_type_init
    return ()


-- function type_get_type_registration_serial
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_get_type_registration_serial" g_type_get_type_registration_serial :: 
    IO Word32

-- | Returns an opaque serial number that represents the state of the set
-- of registered types. Any time a type is registered this serial changes,
-- which means you can cache information based on type lookups (such as
-- 'GI.GObject.Functions.typeFromName') and know if the cache is still valid at a later
-- time by comparing the current serial with the one at the type lookup.
-- 
-- /Since: 2.36/
typeGetTypeRegistrationSerial ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ An unsigned int, representing the state of type registrations
typeGetTypeRegistrationSerial  = liftIO $ do
    result <- g_type_get_type_registration_serial
    return result


-- function type_get_qdata
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark id to identify the data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_get_qdata" g_type_get_qdata :: 
    CGType ->                               -- type : TBasicType TGType
    Word32 ->                               -- quark : TBasicType TUInt32
    IO (Ptr ())

-- | Obtains data which has previously been attached to /@type@/
-- with 'GI.GObject.Functions.typeSetQdata'.
-- 
-- Note that this does not take subtyping into account; data
-- attached to one type with 'GI.GObject.Functions.typeSetQdata' cannot
-- be retrieved from a subtype using 'GI.GObject.Functions.typeGetQdata'.
typeGetQdata ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: a t'GType'
    -> Word32
    -- ^ /@quark@/: a @/GQuark/@ id to identify the data
    -> m (Ptr ())
    -- ^ __Returns:__ the data, or 'P.Nothing' if no data was found
typeGetQdata type_ quark = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_get_qdata type_' quark
    return result


-- function type_get_plugin
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType to retrieve the plugin for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "TypePlugin" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_get_plugin" g_type_get_plugin :: 
    CGType ->                               -- type : TBasicType TGType
    IO (Ptr GObject.TypePlugin.TypePlugin)

-- | Returns the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure for /@type@/.
typeGetPlugin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: t'GType' to retrieve the plugin for
    -> m GObject.TypePlugin.TypePlugin
    -- ^ __Returns:__ the corresponding plugin
    --     if /@type@/ is a dynamic type, 'P.Nothing' otherwise
typeGetPlugin type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_get_plugin type_'
    checkUnexpectedReturnNULL "typeGetPlugin" result
    result' <- (newPtr GObject.TypePlugin.TypePlugin) result
    return result'


-- function type_get_instance_count
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_get_instance_count" g_type_get_instance_count :: 
    CGType ->                               -- type : TBasicType TGType
    IO Int32

-- | Returns the number of instances allocated of the particular type;
-- this is only available if GLib is built with debugging support and
-- the @instance-count@ debug flag is set (by setting the @GOBJECT_DEBUG@
-- variable to include @instance-count@).
-- 
-- /Since: 2.44/
typeGetInstanceCount ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: a t'GType'
    -> m Int32
    -- ^ __Returns:__ the number of instances allocated of the given type;
    --   if instance counts are not available, returns 0.
typeGetInstanceCount type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_get_instance_count type_'
    return result


-- function type_fundamental_next
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_fundamental_next" g_type_fundamental_next :: 
    IO CGType

-- | Returns the next free fundamental type id which can be used to
-- register a new fundamental type with 'GI.GObject.Functions.typeRegisterFundamental'.
-- The returned type ID represents the highest currently registered
-- fundamental type identifier.
typeFundamentalNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GType
    -- ^ __Returns:__ the next available fundamental type ID to be registered,
    --     or 0 if the type system ran out of fundamental type IDs
typeFundamentalNext  = liftIO $ do
    result <- g_type_fundamental_next
    let result' = GType result
    return result'


-- function type_fundamental
-- Args: [ Arg
--           { argCName = "type_id"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "valid type ID" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_fundamental" g_type_fundamental :: 
    CGType ->                               -- type_id : TBasicType TGType
    IO CGType

-- | Internal function, used to extract the fundamental type ID portion.
-- Use @/G_TYPE_FUNDAMENTAL()/@ instead.
typeFundamental ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@typeId@/: valid type ID
    -> m GType
    -- ^ __Returns:__ fundamental type ID
typeFundamental typeId = liftIO $ do
    let typeId' = gtypeToCGType typeId
    result <- g_type_fundamental typeId'
    let result' = GType result
    return result'


-- function type_from_name
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type name to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_from_name" g_type_from_name :: 
    CString ->                              -- name : TBasicType TUTF8
    IO CGType

-- | Look up the type ID from a given type name, returning 0 if no type
-- has been registered under this name (this is the preferred method
-- to find out by name whether a specific type has been registered
-- yet).
typeFromName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: type name to look up
    -> m GType
    -- ^ __Returns:__ corresponding type ID or 0
typeFromName name = liftIO $ do
    name' <- textToCString name
    result <- g_type_from_name name'
    let result' = GType result
    freeMem name'
    return result'


-- function type_free_instance
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an instance of a type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_free_instance" g_type_free_instance :: 
    Ptr GObject.TypeInstance.TypeInstance -> -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    IO ()

-- | Frees an instance of a type, returning it to the instance pool for
-- the type, if there is one.
-- 
-- Like @/g_type_create_instance()/@, this function is reserved for
-- implementors of fundamental types.
typeFreeInstance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInstance.TypeInstance
    -- ^ /@instance@/: an instance of a type
    -> m ()
typeFreeInstance instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    g_type_free_instance instance_'
    touchManagedPtr instance_
    return ()


-- function type_ensure
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_ensure" g_type_ensure :: 
    CGType ->                               -- type : TBasicType TGType
    IO ()

-- | Ensures that the indicated /@type@/ has been registered with the
-- type system, and its @/_class_init()/@ method has been run.
-- 
-- In theory, simply calling the type\'s @/_get_type()/@ method (or using
-- the corresponding macro) is supposed take care of this. However,
-- @/_get_type()/@ methods are often marked @/G_GNUC_CONST/@ for performance
-- reasons, even though this is technically incorrect (since
-- @/G_GNUC_CONST/@ requires that the function not have side effects,
-- which @/_get_type()/@ methods do on the first call). As a result, if
-- you write a bare call to a @/_get_type()/@ macro, it may get optimized
-- out by the compiler. Using 'GI.GObject.Functions.typeEnsure' guarantees that the
-- type\'s @/_get_type()/@ method is called.
-- 
-- /Since: 2.34/
typeEnsure ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: a t'GType'
    -> m ()
typeEnsure type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    g_type_ensure type_'
    return ()


-- function type_depth
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_depth" g_type_depth :: 
    CGType ->                               -- type : TBasicType TGType
    IO Word32

-- | Returns the length of the ancestry of the passed in type. This
-- includes the type itself, so that e.g. a fundamental type has depth 1.
typeDepth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: a t'GType'
    -> m Word32
    -- ^ __Returns:__ the depth of /@type@/
typeDepth type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_depth type_'
    return result


-- function type_default_interface_unref
-- Args: [ Arg
--           { argCName = "g_iface"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInterface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the default vtable\n    structure for an interface, as returned by g_type_default_interface_ref()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_default_interface_unref" g_type_default_interface_unref :: 
    Ptr GObject.TypeInterface.TypeInterface -> -- g_iface : TInterface (Name {namespace = "GObject", name = "TypeInterface"})
    IO ()

{-# DEPRECATED typeDefaultInterfaceUnref ["(Since version 2.84)","Interface reference counting has been removed and","  interface types now cannot be finalized. This function no longer does","  anything."] #-}
-- | Decrements the reference count for the type corresponding to the
-- interface default vtable /@gIface@/.
-- 
-- If the type is dynamic, then when no one is using the interface and all
-- references have been released, the finalize function for the interface\'s
-- default vtable (the /@classFinalize@/ member of t'GI.GObject.Structs.TypeInfo.TypeInfo') will be called.
-- 
-- /Since: 2.4/
typeDefaultInterfaceUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInterface.TypeInterface
    -- ^ /@gIface@/: the default vtable
    --     structure for an interface, as returned by 'GI.GObject.Functions.typeDefaultInterfaceRef'
    -> m ()
typeDefaultInterfaceUnref gIface = liftIO $ do
    gIface' <- unsafeManagedPtrGetPtr gIface
    g_type_default_interface_unref gIface'
    touchManagedPtr gIface
    return ()


-- function type_default_interface_ref
-- Args: [ Arg
--           { argCName = "g_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "TypeInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_default_interface_ref" g_type_default_interface_ref :: 
    CGType ->                               -- g_type : TBasicType TGType
    IO (Ptr GObject.TypeInterface.TypeInterface)

{-# DEPRECATED typeDefaultInterfaceRef ["(Since version 2.84)","Use 'GI.GObject.Functions.typeDefaultInterfaceGet' instead"] #-}
-- | Increments the reference count for the interface type /@gType@/,
-- and returns the default interface vtable for the type.
-- 
-- If the type is not currently in use, then the default vtable
-- for the type will be created and initialized by calling
-- the base interface init and default vtable init functions for
-- the type (the /@baseInit@/ and /@classInit@/ members of t'GI.GObject.Structs.TypeInfo.TypeInfo').
-- Calling 'GI.GObject.Functions.typeDefaultInterfaceRef' is useful when you
-- want to make sure that signals and properties for an interface
-- have been installed.
-- 
-- /Since: 2.4/
typeDefaultInterfaceRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gType@/: an interface type
    -> m GObject.TypeInterface.TypeInterface
    -- ^ __Returns:__ the default
    --   vtable for the interface; call 'GI.GObject.Functions.typeDefaultInterfaceUnref'
    --   when you are done using the interface.
typeDefaultInterfaceRef gType = liftIO $ do
    let gType' = gtypeToCGType gType
    result <- g_type_default_interface_ref gType'
    checkUnexpectedReturnNULL "typeDefaultInterfaceRef" result
    result' <- (newPtr GObject.TypeInterface.TypeInterface) result
    return result'


-- function type_default_interface_peek
-- Args: [ Arg
--           { argCName = "g_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "TypeInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_default_interface_peek" g_type_default_interface_peek :: 
    CGType ->                               -- g_type : TBasicType TGType
    IO (Ptr GObject.TypeInterface.TypeInterface)

-- | If the interface type /@gType@/ is currently in use, returns its
-- default interface vtable.
-- 
-- /Since: 2.4/
typeDefaultInterfacePeek ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gType@/: an interface type
    -> m GObject.TypeInterface.TypeInterface
    -- ^ __Returns:__ the default
    --   vtable for the interface, or 'P.Nothing' if the type is not currently
    --   in use
typeDefaultInterfacePeek gType = liftIO $ do
    let gType' = gtypeToCGType gType
    result <- g_type_default_interface_peek gType'
    checkUnexpectedReturnNULL "typeDefaultInterfacePeek" result
    result' <- (newPtr GObject.TypeInterface.TypeInterface) result
    return result'


-- function type_default_interface_get
-- Args: [ Arg
--           { argCName = "g_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an interface type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "TypeInterface" })
-- throws : False
-- Skip return : False

foreign import ccall "g_type_default_interface_get" g_type_default_interface_get :: 
    CGType ->                               -- g_type : TBasicType TGType
    IO (Ptr GObject.TypeInterface.TypeInterface)

-- | Returns the default interface vtable for the given /@gType@/.
-- 
-- If the type is not currently in use, then the default vtable
-- for the type will be created and initialized by calling
-- the base interface init and default vtable init functions for
-- the type (the /@baseInit@/ and /@classInit@/ members of t'GI.GObject.Structs.TypeInfo.TypeInfo').
-- 
-- If you don\'t want to create the interface vtable, you should use
-- 'GI.GObject.Functions.typeDefaultInterfacePeek' instead.
-- 
-- Calling 'GI.GObject.Functions.typeDefaultInterfaceGet' is useful when you
-- want to make sure that signals and properties for an interface
-- have been installed.
-- 
-- /Since: 2.84/
typeDefaultInterfaceGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gType@/: an interface type
    -> m GObject.TypeInterface.TypeInterface
    -- ^ __Returns:__ the default
    --   vtable for the interface.
typeDefaultInterfaceGet gType = liftIO $ do
    let gType' = gtypeToCGType gType
    result <- g_type_default_interface_get gType'
    checkUnexpectedReturnNULL "typeDefaultInterfaceGet" result
    result' <- (newPtr GObject.TypeInterface.TypeInterface) result
    return result'


-- function type_children
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_children"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the length of\n    the returned array, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_children"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "location to store the length of\n    the returned array, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TGType))
-- throws : False
-- Skip return : False

foreign import ccall "g_type_children" g_type_children :: 
    CGType ->                               -- type : TBasicType TGType
    Ptr Word32 ->                           -- n_children : TBasicType TUInt
    IO (Ptr CGType)

-- | Return a newly allocated and 0-terminated array of type IDs, listing
-- the child types of /@type@/.
typeChildren ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@type@/: the parent type
    -> m [GType]
    -- ^ __Returns:__ Newly allocated
    --     and 0-terminated array of child types, free with 'GI.GLib.Functions.free'
typeChildren type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    nChildren <- allocMem :: IO (Ptr Word32)
    result <- g_type_children type_' nChildren
    nChildren' <- peek nChildren
    checkUnexpectedReturnNULL "typeChildren" result
    result' <- (unpackMapStorableArrayWithLength GType nChildren') result
    freeMem result
    freeMem nChildren
    return result'


-- function type_check_value_holds
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_value_holds" g_type_check_value_holds :: 
    Ptr GValue ->                           -- value : TGValue
    CGType ->                               -- type : TBasicType TGType
    IO CInt

-- | /No description available in the introspection data./
typeCheckValueHolds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -> GType
    -> m Bool
typeCheckValueHolds value type_ = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    let type_' = gtypeToCGType type_
    result <- g_type_check_value_holds value' type_'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'


-- function type_check_value
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_value" g_type_check_value :: 
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | /No description available in the introspection data./
typeCheckValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -> m Bool
typeCheckValue value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- g_type_check_value value'
    let result' = (/= 0) result
    touchManagedPtr value
    return result'


-- function type_check_is_value_type
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_is_value_type" g_type_check_is_value_type :: 
    CGType ->                               -- type : TBasicType TGType
    IO CInt

-- | /No description available in the introspection data./
typeCheckIsValueType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -> m Bool
typeCheckIsValueType type_ = liftIO $ do
    let type_' = gtypeToCGType type_
    result <- g_type_check_is_value_type type_'
    let result' = (/= 0) result
    return result'


-- function type_check_instance_is_fundamentally_a
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fundamental_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_instance_is_fundamentally_a" g_type_check_instance_is_fundamentally_a :: 
    Ptr GObject.TypeInstance.TypeInstance -> -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    CGType ->                               -- fundamental_type : TBasicType TGType
    IO CInt

-- | /No description available in the introspection data./
typeCheckInstanceIsFundamentallyA ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInstance.TypeInstance
    -> GType
    -> m Bool
typeCheckInstanceIsFundamentallyA instance_ fundamentalType = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    let fundamentalType' = gtypeToCGType fundamentalType
    result <- g_type_check_instance_is_fundamentally_a instance_' fundamentalType'
    let result' = (/= 0) result
    touchManagedPtr instance_
    return result'


-- function type_check_instance_is_a
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_instance_is_a" g_type_check_instance_is_a :: 
    Ptr GObject.TypeInstance.TypeInstance -> -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    CGType ->                               -- iface_type : TBasicType TGType
    IO CInt

-- | /No description available in the introspection data./
typeCheckInstanceIsA ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInstance.TypeInstance
    -> GType
    -> m Bool
typeCheckInstanceIsA instance_ ifaceType = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    let ifaceType' = gtypeToCGType ifaceType
    result <- g_type_check_instance_is_a instance_' ifaceType'
    let result' = (/= 0) result
    touchManagedPtr instance_
    return result'


-- function type_check_instance
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GTypeInstance structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_instance" g_type_check_instance :: 
    Ptr GObject.TypeInstance.TypeInstance -> -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    IO CInt

-- | Private helper function to aid implementation of the
-- @/G_TYPE_CHECK_INSTANCE()/@ macro.
typeCheckInstance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeInstance.TypeInstance
    -- ^ /@instance@/: a valid t'GI.GObject.Structs.TypeInstance.TypeInstance' structure
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@instance@/ is valid, 'P.False' otherwise
typeCheckInstance instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    result <- g_type_check_instance instance_'
    let result' = (/= 0) result
    touchManagedPtr instance_
    return result'


-- function type_check_class_is_a
-- Args: [ Arg
--           { argCName = "g_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_a_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_check_class_is_a" g_type_check_class_is_a :: 
    Ptr GObject.TypeClass.TypeClass ->      -- g_class : TInterface (Name {namespace = "GObject", name = "TypeClass"})
    CGType ->                               -- is_a_type : TBasicType TGType
    IO CInt

-- | /No description available in the introspection data./
typeCheckClassIsA ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.TypeClass.TypeClass
    -> GType
    -> m Bool
typeCheckClassIsA gClass isAType = liftIO $ do
    gClass' <- unsafeManagedPtrGetPtr gClass
    let isAType' = gtypeToCGType isAType
    result <- g_type_check_class_is_a gClass' isAType'
    let result' = (/= 0) result
    touchManagedPtr gClass
    return result'


-- function type_add_interface_static
-- Args: [ Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType value of an instantiatable type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType value of an interface type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "InterfaceInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "#GInterfaceInfo structure for this\n       (@instance_type, @interface_type) combination"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_add_interface_static" g_type_add_interface_static :: 
    CGType ->                               -- instance_type : TBasicType TGType
    CGType ->                               -- interface_type : TBasicType TGType
    Ptr GObject.InterfaceInfo.InterfaceInfo -> -- info : TInterface (Name {namespace = "GObject", name = "InterfaceInfo"})
    IO ()

-- | Adds /@interfaceType@/ to the static /@instanceType@/.
-- The information contained in the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure
-- pointed to by /@info@/ is used to manage the relationship.
typeAddInterfaceStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@instanceType@/: t'GType' value of an instantiatable type
    -> GType
    -- ^ /@interfaceType@/: t'GType' value of an interface type
    -> GObject.InterfaceInfo.InterfaceInfo
    -- ^ /@info@/: t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' structure for this
    --        (/@instanceType@/, /@interfaceType@/) combination
    -> m ()
typeAddInterfaceStatic instanceType interfaceType info = liftIO $ do
    let instanceType' = gtypeToCGType instanceType
    let interfaceType' = gtypeToCGType interfaceType
    info' <- unsafeManagedPtrGetPtr info
    g_type_add_interface_static instanceType' interfaceType' info'
    touchManagedPtr info
    return ()


-- function type_add_interface_dynamic
-- Args: [ Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType value of an instantiatable type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GType value of an interface type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "plugin"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypePlugin" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#GTypePlugin structure to retrieve the #GInterfaceInfo from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_add_interface_dynamic" g_type_add_interface_dynamic :: 
    CGType ->                               -- instance_type : TBasicType TGType
    CGType ->                               -- interface_type : TBasicType TGType
    Ptr GObject.TypePlugin.TypePlugin ->    -- plugin : TInterface (Name {namespace = "GObject", name = "TypePlugin"})
    IO ()

-- | Adds /@interfaceType@/ to the dynamic /@instanceType@/. The information
-- contained in the t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure pointed to by /@plugin@/
-- is used to manage the relationship.
typeAddInterfaceDynamic ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.TypePlugin.IsTypePlugin a) =>
    GType
    -- ^ /@instanceType@/: t'GType' value of an instantiatable type
    -> GType
    -- ^ /@interfaceType@/: t'GType' value of an interface type
    -> a
    -- ^ /@plugin@/: t'GI.GObject.Interfaces.TypePlugin.TypePlugin' structure to retrieve the t'GI.GObject.Structs.InterfaceInfo.InterfaceInfo' from
    -> m ()
typeAddInterfaceDynamic instanceType interfaceType plugin = liftIO $ do
    let instanceType' = gtypeToCGType instanceType
    let interfaceType' = gtypeToCGType interfaceType
    plugin' <- unsafeManagedPtrCastPtr plugin
    g_type_add_interface_dynamic instanceType' interfaceType' plugin'
    touchManagedPtr plugin
    return ()


-- function type_add_instance_private
-- Args: [ Arg
--           { argCName = "class_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_add_instance_private" g_type_add_instance_private :: 
    CGType ->                               -- class_type : TBasicType TGType
    FCT.CSize ->                            -- private_size : TBasicType TSize
    IO Int32

-- | /No description available in the introspection data./
typeAddInstancePrivate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -> FCT.CSize
    -> m Int32
typeAddInstancePrivate classType privateSize = liftIO $ do
    let classType' = gtypeToCGType classType
    result <- g_type_add_instance_private classType' privateSize
    return result


-- function type_add_class_private
-- Args: [ Arg
--           { argCName = "class_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "GType of a classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "size of private structure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_type_add_class_private" g_type_add_class_private :: 
    CGType ->                               -- class_type : TBasicType TGType
    FCT.CSize ->                            -- private_size : TBasicType TSize
    IO ()

-- | Registers a private class structure for a classed type;
-- when the class is allocated, the private structures for
-- the class and all of its parent types are allocated
-- sequentially in the same memory block as the public
-- structures, and are zero-filled.
-- 
-- This function should be called in the
-- type\'s @/get_type()/@ function after the type is registered.
-- The private structure can be retrieved using the
-- @/G_TYPE_CLASS_GET_PRIVATE()/@ macro.
-- 
-- /Since: 2.24/
typeAddClassPrivate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@classType@/: GType of a classed type
    -> FCT.CSize
    -- ^ /@privateSize@/: size of private structure
    -> m ()
typeAddClassPrivate classType privateSize = liftIO $ do
    let classType' = gtypeToCGType classType
    g_type_add_class_private classType' privateSize
    return ()


-- function strdup_value_contents
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GValue which contents are to be described."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_strdup_value_contents" g_strdup_value_contents :: 
    Ptr GValue ->                           -- value : TGValue
    IO CString

-- | Return a newly allocated string, which describes the contents of a
-- t'GI.GObject.Structs.Value.Value'.  The main purpose of this function is to describe t'GI.GObject.Structs.Value.Value'
-- contents for debugging output, the way in which the contents are
-- described may change between different GLib versions.
strdupValueContents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: t'GI.GObject.Structs.Value.Value' which contents are to be described.
    -> m T.Text
    -- ^ __Returns:__ Newly allocated string.
strdupValueContents value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- g_strdup_value_contents value'
    checkUnexpectedReturnNULL "strdupValueContents" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr value
    return result'


-- function signal_type_cclosure_new
-- Args: [ Arg
--           { argCName = "itype"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GType identifier of an interface or classed type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "struct_offset"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the offset of the member function of @itype's class\n structure which is to be invoked by the new closure"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGClosure Nothing)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_type_cclosure_new" g_signal_type_cclosure_new :: 
    CGType ->                               -- itype : TBasicType TGType
    Word32 ->                               -- struct_offset : TBasicType TUInt
    IO (Ptr (GClosure ()))

-- | Creates a new closure which invokes the function found at the offset
-- /@structOffset@/ in the class structure of the interface or classed type
-- identified by /@itype@/.
signalTypeCclosureNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@itype@/: the t'GType' identifier of an interface or classed type
    -> Word32
    -- ^ /@structOffset@/: the offset of the member function of /@itype@/\'s class
    --  structure which is to be invoked by the new closure
    -> m (GClosure a)
    -- ^ __Returns:__ a floating reference to a new t'GI.GObject.Structs.CClosure.CClosure'
signalTypeCclosureNew itype structOffset = liftIO $ do
    let itype' = gtypeToCGType itype
    result <- g_signal_type_cclosure_new itype' structOffset
    checkUnexpectedReturnNULL "signalTypeCclosureNew" result
    result' <- (B.GClosure.newGClosureFromPtr . FP.castPtr) result
    return result'


-- function signal_stop_emission_by_name
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the object whose signal handlers you wish to stop."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string of the form \"signal-name::detail\"."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_stop_emission_by_name" g_signal_stop_emission_by_name :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CString ->                              -- detailed_signal : TBasicType TUTF8
    IO ()

-- | Stops a signal\'s current emission.
-- 
-- This is just like 'GI.GObject.Functions.signalStopEmission' except it will look up the
-- signal id for you.
signalStopEmissionByName ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the object whose signal handlers you wish to stop.
    -> T.Text
    -- ^ /@detailedSignal@/: a string of the form \"signal-name[detail](#g:signal:detail)\".
    -> m ()
signalStopEmissionByName instance_ detailedSignal = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    detailedSignal' <- textToCString detailedSignal
    g_signal_stop_emission_by_name instance_' detailedSignal'
    touchManagedPtr instance_
    freeMem detailedSignal'
    return ()


-- function signal_stop_emission
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the object whose signal handlers you wish to stop."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the signal identifier, as returned by g_signal_lookup()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detail which the signal was emitted with."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_stop_emission" g_signal_stop_emission :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    IO ()

-- | Stops a signal\'s current emission.
-- 
-- This will prevent the default method from running, if the signal was
-- 'GI.GObject.Flags.SignalFlagsRunLast' and you connected normally (i.e. without the \"after\"
-- flag).
-- 
-- Prints a warning if used on a signal which isn\'t being emitted.
signalStopEmission ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the object whose signal handlers you wish to stop.
    -> Word32
    -- ^ /@signalId@/: the signal identifier, as returned by 'GI.GObject.Functions.signalLookup'.
    -> Word32
    -- ^ /@detail@/: the detail which the signal was emitted with.
    -> m ()
signalStopEmission instance_ signalId detail = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_signal_stop_emission instance_' signalId detail
    touchManagedPtr instance_
    return ()


-- function signal_remove_emission_hook
-- Args: [ Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id of the signal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hook_id"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the id of the emission hook, as returned by\n g_signal_add_emission_hook()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_remove_emission_hook" g_signal_remove_emission_hook :: 
    Word32 ->                               -- signal_id : TBasicType TUInt
    FCT.CULong ->                           -- hook_id : TBasicType TULong
    IO ()

-- | Deletes an emission hook.
signalRemoveEmissionHook ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@signalId@/: the id of the signal
    -> FCT.CULong
    -- ^ /@hookId@/: the id of the emission hook, as returned by
    --  'GI.GObject.Functions.signalAddEmissionHook'
    -> m ()
signalRemoveEmissionHook signalId hookId = liftIO $ do
    g_signal_remove_emission_hook signalId hookId
    return ()


-- function signal_query
-- Args: [ Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The signal id of the signal to query information for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "query"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalQuery" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A user provided structure that is\n filled in with constant values upon success."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_query" g_signal_query :: 
    Word32 ->                               -- signal_id : TBasicType TUInt
    Ptr GObject.SignalQuery.SignalQuery ->  -- query : TInterface (Name {namespace = "GObject", name = "SignalQuery"})
    IO ()

-- | Queries the signal system for in-depth information about a
-- specific signal. This function will fill in a user-provided
-- structure to hold signal-specific information. If an invalid
-- signal id is passed in, the /@signalId@/ member of the t'GI.GObject.Structs.SignalQuery.SignalQuery'
-- is 0. All members filled into the t'GI.GObject.Structs.SignalQuery.SignalQuery' structure should
-- be considered constant and have to be left untouched.
signalQuery ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@signalId@/: The signal id of the signal to query information for.
    -> m (GObject.SignalQuery.SignalQuery)
signalQuery signalId = liftIO $ do
    query <- SP.callocBytes 56 :: IO (Ptr GObject.SignalQuery.SignalQuery)
    g_signal_query signalId query
    query' <- (wrapPtr GObject.SignalQuery.SignalQuery) query
    return query'


-- function signal_parse_name
-- Args: [ Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string of the form \"signal-name::detail\"."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "itype"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The interface/instance type that introduced \"signal-name\"."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id_p"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Location to store the signal id."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "detail_p"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Location to store the detail quark."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "force_detail_quark"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE forces creation of a #GQuark for the detail."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_parse_name" g_signal_parse_name :: 
    CString ->                              -- detailed_signal : TBasicType TUTF8
    CGType ->                               -- itype : TBasicType TGType
    Ptr Word32 ->                           -- signal_id_p : TBasicType TUInt
    Ptr Word32 ->                           -- detail_p : TBasicType TUInt32
    CInt ->                                 -- force_detail_quark : TBasicType TBoolean
    IO CInt

-- | Internal function to parse a signal name into its /@signalId@/
-- and /@detail@/ quark.
signalParseName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@detailedSignal@/: a string of the form \"signal-name[detail](#g:signal:detail)\".
    -> GType
    -- ^ /@itype@/: The interface\/instance type that introduced \"signal-name\".
    -> Bool
    -- ^ /@forceDetailQuark@/: 'P.True' forces creation of a @/GQuark/@ for the detail.
    -> m ((Bool, Word32, Word32))
    -- ^ __Returns:__ Whether the signal name could successfully be parsed and /@signalIdP@/ and /@detailP@/ contain valid return values.
signalParseName detailedSignal itype forceDetailQuark = liftIO $ do
    detailedSignal' <- textToCString detailedSignal
    let itype' = gtypeToCGType itype
    signalIdP <- allocMem :: IO (Ptr Word32)
    detailP <- allocMem :: IO (Ptr Word32)
    let forceDetailQuark' = (P.fromIntegral . P.fromEnum) forceDetailQuark
    result <- g_signal_parse_name detailedSignal' itype' signalIdP detailP forceDetailQuark'
    let result' = (/= 0) result
    signalIdP' <- peek signalIdP
    detailP' <- peek detailP
    freeMem detailedSignal'
    freeMem signalIdP
    freeMem detailP
    return (result', signalIdP', detailP')


-- function signal_override_class_handler
-- Args: [ Arg
--           { argCName = "signal_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name for the signal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the instance type on which to override the class handler\n for the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_handler"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the handler." , sinceVersion = Nothing }
--           , argScope = ScopeTypeForever
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_override_class_handler" g_signal_override_class_handler :: 
    CString ->                              -- signal_name : TBasicType TUTF8
    CGType ->                               -- instance_type : TBasicType TGType
    FunPtr GObject.Callbacks.C_Callback ->  -- class_handler : TInterface (Name {namespace = "GObject", name = "Callback"})
    IO ()

-- | Overrides the class closure (i.e. the default handler) for the
-- given signal for emissions on instances of /@instanceType@/ with
-- callback /@classHandler@/. /@instanceType@/ must be derived from the
-- type to which the signal belongs.
-- 
-- See 'GI.GObject.Functions.signalChainFromOverridden' and
-- @/g_signal_chain_from_overridden_handler()/@ for how to chain up to the
-- parent class closure from inside the overridden one.
-- 
-- /Since: 2.18/
signalOverrideClassHandler ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@signalName@/: the name for the signal
    -> GType
    -- ^ /@instanceType@/: the instance type on which to override the class handler
    --  for the signal.
    -> GObject.Callbacks.Callback
    -- ^ /@classHandler@/: the handler.
    -> m ()
signalOverrideClassHandler signalName instanceType classHandler = liftIO $ do
    signalName' <- textToCString signalName
    let instanceType' = gtypeToCGType instanceType
    classHandler' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing classHandler)
    g_signal_override_class_handler signalName' instanceType' classHandler'
    freeMem signalName'
    return ()


-- function signal_override_class_closure
-- Args: [ Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the signal id" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "instance_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the instance type on which to override the class closure\n for the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "class_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the closure." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_override_class_closure" g_signal_override_class_closure :: 
    Word32 ->                               -- signal_id : TBasicType TUInt
    CGType ->                               -- instance_type : TBasicType TGType
    Ptr (GClosure ()) ->                    -- class_closure : TGClosure Nothing
    IO ()

-- | Overrides the class closure (i.e. the default handler) for the given signal
-- for emissions on instances of /@instanceType@/. /@instanceType@/ must be derived
-- from the type to which the signal belongs.
-- 
-- See 'GI.GObject.Functions.signalChainFromOverridden' and
-- @/g_signal_chain_from_overridden_handler()/@ for how to chain up to the
-- parent class closure from inside the overridden one.
signalOverrideClassClosure ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@signalId@/: the signal id
    -> GType
    -- ^ /@instanceType@/: the instance type on which to override the class closure
    --  for the signal.
    -> GClosure a
    -- ^ /@classClosure@/: the closure.
    -> m ()
signalOverrideClassClosure signalId instanceType classClosure = liftIO $ do
    let instanceType' = gtypeToCGType instanceType
    classClosure' <- unsafeManagedPtrCastPtr classClosure
    g_signal_override_class_closure signalId instanceType' classClosure'
    touchManagedPtr classClosure
    return ()


-- function signal_name
-- Args: [ Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the signal's identifying number."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_name" g_signal_name :: 
    Word32 ->                               -- signal_id : TBasicType TUInt
    IO CString

-- | Given the signal\'s identifier, finds its name.
-- 
-- Two different signals may have the same name, if they have differing types.
signalName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@signalId@/: the signal\'s identifying number.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the signal name, or 'P.Nothing' if the signal number was invalid.
signalName signalId = liftIO $ do
    result <- g_signal_name signalId
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function signal_lookup
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the signal's name." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "itype"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type that the signal operates on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_lookup" g_signal_lookup :: 
    CString ->                              -- name : TBasicType TUTF8
    CGType ->                               -- itype : TBasicType TGType
    IO Word32

-- | Given the name of the signal and the type of object it connects to, gets
-- the signal\'s identifying integer. Emitting the signal by number is
-- somewhat faster than using the name each time.
-- 
-- Also tries the ancestors of the given type.
-- 
-- The type class passed as /@itype@/ must already have been instantiated (for
-- example, using 'GI.GObject.Functions.typeClassRef') for this function to work, as signals are
-- always installed during class initialization.
-- 
-- See @/g_signal_new()/@ for details on allowed signal names.
signalLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the signal\'s name.
    -> GType
    -- ^ /@itype@/: the type that the signal operates on.
    -> m Word32
    -- ^ __Returns:__ the signal\'s identifying number, or 0 if no signal was found.
signalLookup name itype = liftIO $ do
    name' <- textToCString name
    let itype' = gtypeToCGType itype
    result <- g_signal_lookup name' itype'
    freeMem name'
    return result


-- function signal_list_ids
-- Args: [ Arg
--           { argCName = "itype"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Instance or interface type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_ids"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Location to store the number of signal ids for @itype."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_ids"
--              , argType = TBasicType TUInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "Location to store the number of signal ids for @itype."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TUInt))
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_list_ids" g_signal_list_ids :: 
    CGType ->                               -- itype : TBasicType TGType
    Ptr Word32 ->                           -- n_ids : TBasicType TUInt
    IO (Ptr Word32)

-- | Lists the signals by id that a certain instance or interface type
-- created. Further information about the signals can be acquired through
-- 'GI.GObject.Functions.signalQuery'.
signalListIds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@itype@/: Instance or interface type.
    -> m [Word32]
    -- ^ __Returns:__ Newly allocated array of signal IDs.
signalListIds itype = liftIO $ do
    let itype' = gtypeToCGType itype
    nIds <- allocMem :: IO (Ptr Word32)
    result <- g_signal_list_ids itype' nIds
    nIds' <- peek nIds
    checkUnexpectedReturnNULL "signalListIds" result
    result' <- (unpackStorableArrayWithLength nIds') result
    freeMem result
    freeMem nIds
    return result'


-- function signal_is_valid_name
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the canonical name of the signal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_is_valid_name" g_signal_is_valid_name :: 
    CString ->                              -- name : TBasicType TUTF8
    IO CInt

-- | Validate a signal name. This can be useful for dynamically-generated signals
-- which need to be validated at run-time before actually trying to create them.
-- 
-- See @/GObject.signal_new/@ for details of the rules for valid names.
-- The rules for signal names are the same as those for property names.
-- 
-- /Since: 2.66/
signalIsValidName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the canonical name of the signal
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@name@/ is a valid signal name, 'P.False' otherwise.
signalIsValidName name = liftIO $ do
    name' <- textToCString name
    result <- g_signal_is_valid_name name'
    let result' = (/= 0) result
    freeMem name'
    return result'


-- function signal_has_handler_pending
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the object whose signal handlers are sought."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the signal id." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detail." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_be_blocked"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether blocked handlers should count as match."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_has_handler_pending" g_signal_has_handler_pending :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    CInt ->                                 -- may_be_blocked : TBasicType TBoolean
    IO CInt

-- | Returns whether there are any handlers connected to /@instance@/ for the
-- given signal id and detail.
-- 
-- If /@detail@/ is 0 then it will only match handlers that were connected
-- without detail.  If /@detail@/ is non-zero then it will match handlers
-- connected both without detail and with the given detail.  This is
-- consistent with how a signal emitted with /@detail@/ would be delivered
-- to those handlers.
-- 
-- Since 2.46 this also checks for a non-default class closure being
-- installed, as this is basically always what you want.
-- 
-- One example of when you might use this is when the arguments to the
-- signal are difficult to compute. A class implementor may opt to not
-- emit the signal if no one is attached anyway, thus saving the cost
-- of building the arguments.
signalHasHandlerPending ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the object whose signal handlers are sought.
    -> Word32
    -- ^ /@signalId@/: the signal id.
    -> Word32
    -- ^ /@detail@/: the detail.
    -> Bool
    -- ^ /@mayBeBlocked@/: whether blocked handlers should count as match.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if a handler is connected to the signal, 'P.False'
    --          otherwise.
signalHasHandlerPending instance_ signalId detail mayBeBlocked = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    let mayBeBlocked' = (P.fromIntegral . P.fromEnum) mayBeBlocked
    result <- g_signal_has_handler_pending instance_' signalId detail mayBeBlocked'
    let result' = (/= 0) result
    touchManagedPtr instance_
    return result'


-- function signal_handlers_unblock_matched
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The instance to unblock handlers from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalMatchType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Mask indicating which of @signal_id, @detail, @closure, @func\n and/or @data the handlers have to match."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Signal the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal detail the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure the handlers will invoke."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The C closure callback of the handlers (useless for non-C closures)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure data of the handlers' closures."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handlers_unblock_matched" g_signal_handlers_unblock_matched :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CUInt ->                                -- mask : TInterface (Name {namespace = "GObject", name = "SignalMatchType"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr () ->                               -- func : TBasicType TPtr
    Ptr () ->                               -- data : TBasicType TPtr
    IO Word32

-- | Unblocks all handlers on an instance that match a certain selection
-- criteria.
-- 
-- The criteria mask is passed as a combination of t'GI.GObject.Flags.SignalMatchType' flags, and
-- the criteria values are passed as arguments. A handler must match on all
-- flags set in /@mask@/ to be unblocked (i.e. the match is conjunctive).
-- 
-- Passing at least one of the 'GI.GObject.Flags.SignalMatchTypeId', 'GI.GObject.Flags.SignalMatchTypeClosure',
-- 'GI.GObject.Flags.SignalMatchTypeFunc'
-- or 'GI.GObject.Flags.SignalMatchTypeData' match flags is required for successful matches.
-- If no handlers were found, 0 is returned, the number of unblocked handlers
-- otherwise. The match criteria should not apply to any handlers that are
-- not currently blocked.
-- 
-- Support for 'GI.GObject.Flags.SignalMatchTypeId' was added in GLib 2.78.
signalHandlersUnblockMatched ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to unblock handlers from.
    -> [GObject.Flags.SignalMatchType]
    -- ^ /@mask@/: Mask indicating which of /@signalId@/, /@detail@/, /@closure@/, /@func@/
    --  and\/or /@data@/ the handlers have to match.
    -> Word32
    -- ^ /@signalId@/: Signal the handlers have to be connected to.
    -> Word32
    -- ^ /@detail@/: Signal detail the handlers have to be connected to.
    -> Maybe (GClosure b)
    -- ^ /@closure@/: The closure the handlers will invoke.
    -> Ptr ()
    -- ^ /@func@/: The C closure callback of the handlers (useless for non-C closures).
    -> Ptr ()
    -- ^ /@data@/: The closure data of the handlers\' closures.
    -> m Word32
    -- ^ __Returns:__ The number of handlers that matched.
signalHandlersUnblockMatched instance_ mask signalId detail closure func data_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    let mask' = gflagsToWord mask
    maybeClosure <- case closure of
        Nothing -> return FP.nullPtr
        Just jClosure -> do
            jClosure' <- unsafeManagedPtrCastPtr jClosure
            return jClosure'
    result <- g_signal_handlers_unblock_matched instance_' mask' signalId detail maybeClosure func data_
    touchManagedPtr instance_
    whenJust closure touchManagedPtr
    return result


-- function signal_handlers_disconnect_matched
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The instance to remove handlers from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalMatchType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Mask indicating which of @signal_id, @detail, @closure, @func\n and/or @data the handlers have to match."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Signal the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal detail the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure the handlers will invoke."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The C closure callback of the handlers (useless for non-C closures)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure data of the handlers' closures."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handlers_disconnect_matched" g_signal_handlers_disconnect_matched :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CUInt ->                                -- mask : TInterface (Name {namespace = "GObject", name = "SignalMatchType"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr () ->                               -- func : TBasicType TPtr
    Ptr () ->                               -- data : TBasicType TPtr
    IO Word32

-- | Disconnects all handlers on an instance that match a certain
-- selection criteria.
-- 
-- The criteria mask is passed as a combination of t'GI.GObject.Flags.SignalMatchType' flags, and
-- the criteria values are passed as arguments. A handler must match on all
-- flags set in /@mask@/ to be disconnected (i.e. the match is conjunctive).
-- 
-- Passing at least one of the 'GI.GObject.Flags.SignalMatchTypeId', 'GI.GObject.Flags.SignalMatchTypeClosure',
-- 'GI.GObject.Flags.SignalMatchTypeFunc' or
-- 'GI.GObject.Flags.SignalMatchTypeData' match flags is required for successful
-- matches.  If no handlers were found, 0 is returned, the number of
-- disconnected handlers otherwise.
-- 
-- Support for 'GI.GObject.Flags.SignalMatchTypeId' was added in GLib 2.78.
signalHandlersDisconnectMatched ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to remove handlers from.
    -> [GObject.Flags.SignalMatchType]
    -- ^ /@mask@/: Mask indicating which of /@signalId@/, /@detail@/, /@closure@/, /@func@/
    --  and\/or /@data@/ the handlers have to match.
    -> Word32
    -- ^ /@signalId@/: Signal the handlers have to be connected to.
    -> Word32
    -- ^ /@detail@/: Signal detail the handlers have to be connected to.
    -> Maybe (GClosure b)
    -- ^ /@closure@/: The closure the handlers will invoke.
    -> Ptr ()
    -- ^ /@func@/: The C closure callback of the handlers (useless for non-C closures).
    -> Ptr ()
    -- ^ /@data@/: The closure data of the handlers\' closures.
    -> m Word32
    -- ^ __Returns:__ The number of handlers that matched.
signalHandlersDisconnectMatched instance_ mask signalId detail closure func data_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    let mask' = gflagsToWord mask
    maybeClosure <- case closure of
        Nothing -> return FP.nullPtr
        Just jClosure -> do
            jClosure' <- unsafeManagedPtrCastPtr jClosure
            return jClosure'
    result <- g_signal_handlers_disconnect_matched instance_' mask' signalId detail maybeClosure func data_
    touchManagedPtr instance_
    whenJust closure touchManagedPtr
    return result


-- function signal_handlers_destroy
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The instance whose signal handlers are destroyed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handlers_destroy" g_signal_handlers_destroy :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    IO ()

-- | Destroy all signal handlers of a type instance. This function is
-- an implementation detail of the t'GI.GObject.Objects.Object.Object' dispose implementation,
-- and should not be used outside of the type system.
signalHandlersDestroy ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance whose signal handlers are destroyed
    -> m ()
signalHandlersDestroy instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_signal_handlers_destroy instance_'
    touchManagedPtr instance_
    return ()


-- function signal_handlers_block_matched
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The instance to block handlers from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalMatchType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Mask indicating which of @signal_id, @detail, @closure, @func\n and/or @data the handlers have to match."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Signal the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal detail the handlers have to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure the handlers will invoke."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The C closure callback of the handlers (useless for non-C closures)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure data of the handlers' closures."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handlers_block_matched" g_signal_handlers_block_matched :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CUInt ->                                -- mask : TInterface (Name {namespace = "GObject", name = "SignalMatchType"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr () ->                               -- func : TBasicType TPtr
    Ptr () ->                               -- data : TBasicType TPtr
    IO Word32

-- | Blocks all handlers on an instance that match a certain selection criteria.
-- 
-- The criteria mask is passed as a combination of t'GI.GObject.Flags.SignalMatchType' flags, and
-- the criteria values are passed as arguments. A handler must match on all
-- flags set in /@mask@/ to be blocked (i.e. the match is conjunctive).
-- 
-- Passing at least one of the 'GI.GObject.Flags.SignalMatchTypeId', 'GI.GObject.Flags.SignalMatchTypeClosure',
-- 'GI.GObject.Flags.SignalMatchTypeFunc'
-- or 'GI.GObject.Flags.SignalMatchTypeData' match flags is required for successful matches.
-- If no handlers were found, 0 is returned, the number of blocked handlers
-- otherwise.
-- 
-- Support for 'GI.GObject.Flags.SignalMatchTypeId' was added in GLib 2.78.
signalHandlersBlockMatched ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to block handlers from.
    -> [GObject.Flags.SignalMatchType]
    -- ^ /@mask@/: Mask indicating which of /@signalId@/, /@detail@/, /@closure@/, /@func@/
    --  and\/or /@data@/ the handlers have to match.
    -> Word32
    -- ^ /@signalId@/: Signal the handlers have to be connected to.
    -> Word32
    -- ^ /@detail@/: Signal detail the handlers have to be connected to.
    -> Maybe (GClosure b)
    -- ^ /@closure@/: The closure the handlers will invoke.
    -> Ptr ()
    -- ^ /@func@/: The C closure callback of the handlers (useless for non-C closures).
    -> Ptr ()
    -- ^ /@data@/: The closure data of the handlers\' closures.
    -> m Word32
    -- ^ __Returns:__ The number of handlers that matched.
signalHandlersBlockMatched instance_ mask signalId detail closure func data_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    let mask' = gflagsToWord mask
    maybeClosure <- case closure of
        Nothing -> return FP.nullPtr
        Just jClosure -> do
            jClosure' <- unsafeManagedPtrCastPtr jClosure
            return jClosure'
    result <- g_signal_handlers_block_matched instance_' mask' signalId detail maybeClosure func data_
    touchManagedPtr instance_
    whenJust closure touchManagedPtr
    return result


-- function signal_handler_unblock
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The instance to unblock the signal handler of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Handler id of the handler to be unblocked."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handler_unblock" g_signal_handler_unblock :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    FCT.CULong ->                           -- handler_id : TBasicType TULong
    IO ()

-- | Undoes the effect of a previous 'GI.GObject.Functions.signalHandlerBlock' call.  A
-- blocked handler is skipped during signal emissions and will not be
-- invoked, unblocking it (for exactly the amount of times it has been
-- blocked before) reverts its \"blocked\" state, so the handler will be
-- recognized by the signal system and is called upon future or
-- currently ongoing signal emissions (since the order in which
-- handlers are called during signal emissions is deterministic,
-- whether the unblocked handler in question is called as part of a
-- currently ongoing emission depends on how far that emission has
-- proceeded yet).
-- 
-- The /@handlerId@/ has to be a valid id of a signal handler that is
-- connected to a signal of /@instance@/ and is currently blocked.
signalHandlerUnblock ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to unblock the signal handler of.
    -> FCT.CULong
    -- ^ /@handlerId@/: Handler id of the handler to be unblocked.
    -> m ()
signalHandlerUnblock instance_ handlerId = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_signal_handler_unblock instance_' handlerId
    touchManagedPtr instance_
    return ()


-- function signal_handler_is_connected
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The instance where a signal handler is sought."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the handler ID." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handler_is_connected" g_signal_handler_is_connected :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    FCT.CULong ->                           -- handler_id : TBasicType TULong
    IO CInt

-- | Returns whether /@handlerId@/ is the ID of a handler connected to /@instance@/.
signalHandlerIsConnected ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance where a signal handler is sought.
    -> FCT.CULong
    -- ^ /@handlerId@/: the handler ID.
    -> m Bool
    -- ^ __Returns:__ whether /@handlerId@/ identifies a handler connected to /@instance@/.
signalHandlerIsConnected instance_ handlerId = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    result <- g_signal_handler_is_connected instance_' handlerId
    let result' = (/= 0) result
    touchManagedPtr instance_
    return result'


-- function signal_handler_find
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The instance owning the signal handler to be found."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalMatchType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Mask indicating which of @signal_id, @detail, @closure, @func\n and/or @data the handler has to match."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Signal the handler has to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Signal detail the handler has to be connected to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure the handler will invoke."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The C closure callback of the handler (useless for non-C closures)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The closure data of the handler's closure."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handler_find" g_signal_handler_find :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CUInt ->                                -- mask : TInterface (Name {namespace = "GObject", name = "SignalMatchType"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    Ptr () ->                               -- func : TBasicType TPtr
    Ptr () ->                               -- data : TBasicType TPtr
    IO FCT.CULong

-- | Finds the first signal handler that matches certain selection criteria.
-- The criteria mask is passed as an OR-ed combination of t'GI.GObject.Flags.SignalMatchType'
-- flags, and the criteria values are passed as arguments.
-- The match /@mask@/ has to be non-0 for successful matches.
-- If no handler was found, 0 is returned.
signalHandlerFind ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance owning the signal handler to be found.
    -> [GObject.Flags.SignalMatchType]
    -- ^ /@mask@/: Mask indicating which of /@signalId@/, /@detail@/, /@closure@/, /@func@/
    --  and\/or /@data@/ the handler has to match.
    -> Word32
    -- ^ /@signalId@/: Signal the handler has to be connected to.
    -> Word32
    -- ^ /@detail@/: Signal detail the handler has to be connected to.
    -> Maybe (GClosure b)
    -- ^ /@closure@/: The closure the handler will invoke.
    -> Ptr ()
    -- ^ /@func@/: The C closure callback of the handler (useless for non-C closures).
    -> Ptr ()
    -- ^ /@data@/: The closure data of the handler\'s closure.
    -> m FCT.CULong
    -- ^ __Returns:__ A valid non-0 signal handler id for a successful match.
signalHandlerFind instance_ mask signalId detail closure func data_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    let mask' = gflagsToWord mask
    maybeClosure <- case closure of
        Nothing -> return FP.nullPtr
        Just jClosure -> do
            jClosure' <- unsafeManagedPtrCastPtr jClosure
            return jClosure'
    result <- g_signal_handler_find instance_' mask' signalId detail maybeClosure func data_
    touchManagedPtr instance_
    whenJust closure touchManagedPtr
    return result


-- function signal_handler_disconnect
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The instance to remove the signal handler from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Handler id of the handler to be disconnected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handler_disconnect" g_signal_handler_disconnect :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    FCT.CULong ->                           -- handler_id : TBasicType TULong
    IO ()

-- | Disconnects a handler from an instance so it will not be called during
-- any future or currently ongoing emissions of the signal it has been
-- connected to. The /@handlerId@/ becomes invalid and may be reused.
-- 
-- The /@handlerId@/ has to be a valid signal handler id, connected to a
-- signal of /@instance@/.
signalHandlerDisconnect ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to remove the signal handler from.
    -> FCT.CULong
    -- ^ /@handlerId@/: Handler id of the handler to be disconnected.
    -> m ()
signalHandlerDisconnect instance_ handlerId = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_signal_handler_disconnect instance_' handlerId
    touchManagedPtr instance_
    return ()


-- function signal_handler_block
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The instance to block the signal handler of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_id"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Handler id of the handler to be blocked."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_handler_block" g_signal_handler_block :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    FCT.CULong ->                           -- handler_id : TBasicType TULong
    IO ()

-- | Blocks a handler of an instance so it will not be called during any
-- signal emissions unless it is unblocked again. Thus \"blocking\" a
-- signal handler means to temporarily deactivate it, a signal handler
-- has to be unblocked exactly the same amount of times it has been
-- blocked before to become active again.
-- 
-- The /@handlerId@/ has to be a valid signal handler id, connected to a
-- signal of /@instance@/.
signalHandlerBlock ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: The instance to block the signal handler of.
    -> FCT.CULong
    -- ^ /@handlerId@/: Handler id of the handler to be blocked.
    -> m ()
signalHandlerBlock instance_ handlerId = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_signal_handler_block instance_' handlerId
    touchManagedPtr instance_
    return ()


-- function signal_get_invocation_hint
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the instance to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GObject" , name = "SignalInvocationHint" })
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_get_invocation_hint" g_signal_get_invocation_hint :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    IO (Ptr GObject.SignalInvocationHint.SignalInvocationHint)

-- | Returns the invocation hint of the innermost signal emission of instance.
signalGetInvocationHint ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the instance to query
    -> m (Maybe GObject.SignalInvocationHint.SignalInvocationHint)
    -- ^ __Returns:__ the invocation hint of the innermost
    --     signal emission, or 'P.Nothing' if not found.
signalGetInvocationHint instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    result <- g_signal_get_invocation_hint instance_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.SignalInvocationHint.SignalInvocationHint) result'
        return result''
    touchManagedPtr instance_
    return maybeResult


-- function signal_emitv
-- Args: [ Arg
--           { argCName = "instance_and_params"
--           , argType = TCArray False (-1) (-1) TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "argument list for the signal emission.\n The first element in the array is a #GValue for the instance the signal\n is being emitted on. The rest are any arguments to be passed to the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the signal id" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detail" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Location to\nstore the return value of the signal emission. This must be provided if the\nspecified signal returns a value, but may be ignored otherwise."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_emitv" g_signal_emitv :: 
    Ptr B.GValue.GValue ->                  -- instance_and_params : TCArray False (-1) (-1) TGValue
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr GValue ->                           -- return_value : TGValue
    IO ()

-- | Emits a signal. Signal emission is done synchronously.
-- The method will only return control after all handlers are called or signal emission was stopped.
-- 
-- Note that 'GI.GObject.Functions.signalEmitv' doesn\'t change /@returnValue@/ if no handlers are
-- connected, in contrast to @/g_signal_emit()/@ and @/g_signal_emit_valist()/@.
signalEmitv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GValue]
    -- ^ /@instanceAndParams@/: argument list for the signal emission.
    --  The first element in the array is a t'GI.GObject.Structs.Value.Value' for the instance the signal
    --  is being emitted on. The rest are any arguments to be passed to the signal.
    -> Word32
    -- ^ /@signalId@/: the signal id
    -> Word32
    -- ^ /@detail@/: the detail
    -> m (GValue)
signalEmitv instanceAndParams signalId detail = liftIO $ do
    instanceAndParams' <- B.GValue.packGValueArray instanceAndParams
    returnValue <- SP.callocBytes 24 :: IO (Ptr GValue)
    g_signal_emitv instanceAndParams' signalId detail returnValue
    returnValue' <- B.GValue.wrapGValuePtr returnValue
    mapM_ touchManagedPtr instanceAndParams
    freeMem instanceAndParams'
    return returnValue'


-- function signal_connect_closure_by_id
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the instance to connect to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id of the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detail." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the closure to connect."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "after"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether the handler should be called before or after the\n default handler of the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_connect_closure_by_id" g_signal_connect_closure_by_id :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    CInt ->                                 -- after : TBasicType TBoolean
    IO FCT.CULong

-- | Connects a closure to a signal for a particular object.
-- 
-- If /@closure@/ is a floating reference (see 'GI.GObject.Structs.Closure.closureSink'), this function
-- takes ownership of /@closure@/.
-- 
-- This function cannot fail. If the given signal name doesn’t exist,
-- a critical warning is emitted. No validation is performed on the
-- ‘detail’ string when specified in /@detailedSignal@/, other than a
-- non-empty check.
-- 
-- Refer to the <http://developer.gnome.org/gobject/stable/signals.html signals documentation> for more
-- details.
signalConnectClosureById ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the instance to connect to.
    -> Word32
    -- ^ /@signalId@/: the id of the signal.
    -> Word32
    -- ^ /@detail@/: the detail.
    -> GClosure b
    -- ^ /@closure@/: the closure to connect.
    -> Bool
    -- ^ /@after@/: whether the handler should be called before or after the
    --  default handler of the signal.
    -> m FCT.CULong
    -- ^ __Returns:__ the handler ID (always greater than 0)
signalConnectClosureById instance_ signalId detail closure after = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    closure' <- unsafeManagedPtrCastPtr closure
    let after' = (P.fromIntegral . P.fromEnum) after
    result <- g_signal_connect_closure_by_id instance_' signalId detail closure' after'
    touchManagedPtr instance_
    touchManagedPtr closure
    return result


-- function signal_connect_closure
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the instance to connect to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string of the form \"signal-name::detail\"."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the closure to connect."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "after"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether the handler should be called before or after the\n default handler of the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_connect_closure" g_signal_connect_closure :: 
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    CString ->                              -- detailed_signal : TBasicType TUTF8
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    CInt ->                                 -- after : TBasicType TBoolean
    IO FCT.CULong

-- | Connects a closure to a signal for a particular object.
-- 
-- If /@closure@/ is a floating reference (see 'GI.GObject.Structs.Closure.closureSink'), this function
-- takes ownership of /@closure@/.
-- 
-- This function cannot fail. If the given signal name doesn’t exist,
-- a critical warning is emitted. No validation is performed on the
-- ‘detail’ string when specified in /@detailedSignal@/, other than a
-- non-empty check.
-- 
-- Refer to the <http://developer.gnome.org/gobject/stable/signals.html signals documentation> for more
-- details.
signalConnectClosure ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@instance@/: the instance to connect to.
    -> T.Text
    -- ^ /@detailedSignal@/: a string of the form \"signal-name[detail](#g:signal:detail)\".
    -> GClosure b
    -- ^ /@closure@/: the closure to connect.
    -> Bool
    -- ^ /@after@/: whether the handler should be called before or after the
    --  default handler of the signal.
    -> m FCT.CULong
    -- ^ __Returns:__ the handler ID (always greater than 0)
signalConnectClosure instance_ detailedSignal closure after = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    detailedSignal' <- textToCString detailedSignal
    closure' <- unsafeManagedPtrCastPtr closure
    let after' = (P.fromIntegral . P.fromEnum) after
    result <- g_signal_connect_closure instance_' detailedSignal' closure' after'
    touchManagedPtr instance_
    touchManagedPtr closure
    freeMem detailedSignal'
    return result


-- function signal_chain_from_overridden
-- Args: [ Arg
--           { argCName = "instance_and_params"
--           , argType = TCArray False (-1) (-1) TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the argument list of the signal emission.\n The first element in the array is a #GValue for the instance the signal\n is being emitted on. The rest are any arguments to be passed to the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Location for the return value."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_chain_from_overridden" g_signal_chain_from_overridden :: 
    Ptr B.GValue.GValue ->                  -- instance_and_params : TCArray False (-1) (-1) TGValue
    Ptr GValue ->                           -- return_value : TGValue
    IO ()

-- | Calls the original class closure of a signal. This function should only
-- be called from an overridden class closure; see
-- 'GI.GObject.Functions.signalOverrideClassClosure' and
-- 'GI.GObject.Functions.signalOverrideClassHandler'.
signalChainFromOverridden ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GValue]
    -- ^ /@instanceAndParams@/: the argument list of the signal emission.
    --  The first element in the array is a t'GI.GObject.Structs.Value.Value' for the instance the signal
    --  is being emitted on. The rest are any arguments to be passed to the signal.
    -> GValue
    -- ^ /@returnValue@/: Location for the return value.
    -> m ()
signalChainFromOverridden instanceAndParams returnValue = liftIO $ do
    instanceAndParams' <- B.GValue.packGValueArray instanceAndParams
    returnValue' <- unsafeManagedPtrGetPtr returnValue
    g_signal_chain_from_overridden instanceAndParams' returnValue'
    mapM_ touchManagedPtr instanceAndParams
    touchManagedPtr returnValue
    freeMem instanceAndParams'
    return ()


-- function signal_add_emission_hook
-- Args: [ Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the signal identifier, as returned by g_signal_lookup()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detail"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detail on which to call the hook."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hook_func"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalEmissionHook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSignalEmissionHook function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hook_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for @hook_func."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDestroyNotify for @hook_data."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_add_emission_hook" g_signal_add_emission_hook :: 
    Word32 ->                               -- signal_id : TBasicType TUInt
    Word32 ->                               -- detail : TBasicType TUInt32
    FunPtr GObject.Callbacks.C_SignalEmissionHook -> -- hook_func : TInterface (Name {namespace = "GObject", name = "SignalEmissionHook"})
    Ptr () ->                               -- hook_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- data_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO FCT.CULong

-- | Adds an emission hook for a signal, which will get called for any emission
-- of that signal, independent of the instance. This is possible only
-- for signals which don\'t have 'GI.GObject.Flags.SignalFlagsNoHooks' flag set.
signalAddEmissionHook ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@signalId@/: the signal identifier, as returned by 'GI.GObject.Functions.signalLookup'.
    -> Word32
    -- ^ /@detail@/: the detail on which to call the hook.
    -> GObject.Callbacks.SignalEmissionHook
    -- ^ /@hookFunc@/: a t'GI.GObject.Callbacks.SignalEmissionHook' function.
    -> m FCT.CULong
    -- ^ __Returns:__ the hook id, for later use with 'GI.GObject.Functions.signalRemoveEmissionHook'.
signalAddEmissionHook signalId detail hookFunc = liftIO $ do
    hookFunc' <- GObject.Callbacks.mk_SignalEmissionHook (GObject.Callbacks.wrap_SignalEmissionHook Nothing (GObject.Callbacks.drop_closures_SignalEmissionHook hookFunc))
    let hookData = castFunPtrToPtr hookFunc'
    let dataDestroy = SP.safeFreeFunPtrPtr
    result <- g_signal_add_emission_hook signalId detail hookFunc' hookData dataDestroy
    return result


-- function signal_accumulator_true_handled
-- Args: [ Arg
--           { argCName = "ihint"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalInvocationHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_accu"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_return"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dummy"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_accumulator_true_handled" g_signal_accumulator_true_handled :: 
    Ptr GObject.SignalInvocationHint.SignalInvocationHint -> -- ihint : TInterface (Name {namespace = "GObject", name = "SignalInvocationHint"})
    Ptr GValue ->                           -- return_accu : TGValue
    Ptr GValue ->                           -- handler_return : TGValue
    Ptr () ->                               -- dummy : TBasicType TPtr
    IO CInt

-- | A predefined t'GI.GObject.Callbacks.SignalAccumulator' for signals that return a
-- boolean values. The behavior that this accumulator gives is
-- that a return of 'P.True' stops the signal emission: no further
-- callbacks will be invoked, while a return of 'P.False' allows
-- the emission to continue. The idea here is that a 'P.True' return
-- indicates that the callback handled the signal, and no further
-- handling is needed.
-- 
-- /Since: 2.4/
signalAccumulatorTrueHandled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> GValue
    -- ^ /@returnAccu@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> GValue
    -- ^ /@handlerReturn@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> Ptr ()
    -- ^ /@dummy@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> m Bool
    -- ^ __Returns:__ standard t'GI.GObject.Callbacks.SignalAccumulator' result
signalAccumulatorTrueHandled ihint returnAccu handlerReturn dummy = liftIO $ do
    ihint' <- unsafeManagedPtrGetPtr ihint
    returnAccu' <- unsafeManagedPtrGetPtr returnAccu
    handlerReturn' <- unsafeManagedPtrGetPtr handlerReturn
    result <- g_signal_accumulator_true_handled ihint' returnAccu' handlerReturn' dummy
    let result' = (/= 0) result
    touchManagedPtr ihint
    touchManagedPtr returnAccu
    touchManagedPtr handlerReturn
    return result'


-- function signal_accumulator_first_wins
-- Args: [ Arg
--           { argCName = "ihint"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "SignalInvocationHint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "return_accu"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handler_return"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dummy"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "standard #GSignalAccumulator parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_accumulator_first_wins" g_signal_accumulator_first_wins :: 
    Ptr GObject.SignalInvocationHint.SignalInvocationHint -> -- ihint : TInterface (Name {namespace = "GObject", name = "SignalInvocationHint"})
    Ptr GValue ->                           -- return_accu : TGValue
    Ptr GValue ->                           -- handler_return : TGValue
    Ptr () ->                               -- dummy : TBasicType TPtr
    IO CInt

-- | A predefined t'GI.GObject.Callbacks.SignalAccumulator' for signals intended to be used as a
-- hook for application code to provide a particular value.  Usually
-- only one such value is desired and multiple handlers for the same
-- signal don\'t make much sense (except for the case of the default
-- handler defined in the class structure, in which case you will
-- usually want the signal connection to override the class handler).
-- 
-- This accumulator will use the return value from the first signal
-- handler that is run as the return value for the signal and not run
-- any further handlers (ie: the first handler \"wins\").
-- 
-- /Since: 2.28/
signalAccumulatorFirstWins ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.SignalInvocationHint.SignalInvocationHint
    -- ^ /@ihint@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> GValue
    -- ^ /@returnAccu@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> GValue
    -- ^ /@handlerReturn@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> Ptr ()
    -- ^ /@dummy@/: standard t'GI.GObject.Callbacks.SignalAccumulator' parameter
    -> m Bool
    -- ^ __Returns:__ standard t'GI.GObject.Callbacks.SignalAccumulator' result
signalAccumulatorFirstWins ihint returnAccu handlerReturn dummy = liftIO $ do
    ihint' <- unsafeManagedPtrGetPtr ihint
    returnAccu' <- unsafeManagedPtrGetPtr returnAccu
    handlerReturn' <- unsafeManagedPtrGetPtr handlerReturn
    result <- g_signal_accumulator_first_wins ihint' returnAccu' handlerReturn' dummy
    let result' = (/= 0) result
    touchManagedPtr ihint
    touchManagedPtr returnAccu
    touchManagedPtr handlerReturn
    return result'


-- function pointer_type_register_static
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the new pointer type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_pointer_type_register_static" g_pointer_type_register_static :: 
    CString ->                              -- name : TBasicType TUTF8
    IO CGType

-- | Creates a new @/G_TYPE_POINTER/@ derived type id for a new
-- pointer type with name /@name@/.
pointerTypeRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the new pointer type.
    -> m GType
    -- ^ __Returns:__ a new @/G_TYPE_POINTER/@ derived type id for /@name@/.
pointerTypeRegisterStatic name = liftIO $ do
    name' <- textToCString name
    result <- g_pointer_type_register_static name'
    let result' = GType result
    freeMem name'
    return result'


-- function param_values_cmp
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value1"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value2"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_values_cmp" g_param_values_cmp :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- value1 : TGValue
    Ptr GValue ->                           -- value2 : TGValue
    IO Int32

-- | Compares /@value1@/ with /@value2@/ according to /@pspec@/, and return -1, 0 or +1,
-- if /@value1@/ is found to be less than, equal to or greater than /@value2@/,
-- respectively.
paramValuesCmp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@value1@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> GValue
    -- ^ /@value2@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> m Int32
    -- ^ __Returns:__ -1, 0 or +1, for a less than, equal to or greater than result
paramValuesCmp pspec value1 value2 = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value1' <- unsafeManagedPtrGetPtr value1
    value2' <- unsafeManagedPtrGetPtr value2
    result <- g_param_values_cmp pspec' value1' value2'
    touchManagedPtr pspec
    touchManagedPtr value1
    touchManagedPtr value2
    return result


-- function param_value_validate
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_value_validate" g_param_value_validate :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Ensures that the contents of /@value@/ comply with the specifications
-- set out by /@pspec@/. For example, a t'GI.GObject.Objects.ParamSpecInt.ParamSpecInt' might require
-- that integers stored in /@value@/ may not be smaller than -42 and not be
-- greater than +42. If /@value@/ contains an integer outside of this range,
-- it is modified accordingly, so the resulting value will fit into the
-- range -42 .. +42.
paramValueValidate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> m Bool
    -- ^ __Returns:__ whether modifying /@value@/ was necessary to ensure validity
paramValueValidate pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    result <- g_param_value_validate pspec' value'
    let result' = (/= 0) result
    touchManagedPtr pspec
    touchManagedPtr value
    return result'


-- function param_value_set_default
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GValue of correct type for @pspec; since 2.64, you\n  can also pass an empty #GValue, initialized with %G_VALUE_INIT"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_param_value_set_default" g_param_value_set_default :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- value : TGValue
    IO ()

-- | Sets /@value@/ to its default value as specified in /@pspec@/.
paramValueSetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/; since 2.64, you
    --   can also pass an empty t'GI.GObject.Structs.Value.Value', initialized with @/G_VALUE_INIT/@
    -> m ()
paramValueSetDefault pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    g_param_value_set_default pspec' value'
    touchManagedPtr pspec
    touchManagedPtr value
    return ()


-- function param_value_is_valid
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_value_is_valid" g_param_value_is_valid :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Return whether the contents of /@value@/ comply with the specifications
-- set out by /@pspec@/.
-- 
-- /Since: 2.74/
paramValueIsValid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> m Bool
    -- ^ __Returns:__ whether the contents of /@value@/ comply with the specifications
    --   set out by /@pspec@/.
paramValueIsValid pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    result <- g_param_value_is_valid pspec' value'
    let result' = (/= 0) result
    touchManagedPtr pspec
    touchManagedPtr value
    return result'


-- function param_value_defaults
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_value_defaults" g_param_value_defaults :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Checks whether /@value@/ contains the default value as specified in /@pspec@/.
paramValueDefaults ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> m Bool
    -- ^ __Returns:__ whether /@value@/ contains the canonical default for this /@pspec@/
paramValueDefaults pspec value = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    value' <- unsafeManagedPtrGetPtr value
    result <- g_param_value_defaults pspec' value'
    let result' = (/= 0) result
    touchManagedPtr pspec
    touchManagedPtr value
    return result'


-- function param_value_convert
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source #GValue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "destination #GValue of correct type for @pspec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "strict_validation"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE requires @dest_value to conform to @pspec\nwithout modifications"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_value_convert" g_param_value_convert :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Ptr GValue ->                           -- src_value : TGValue
    Ptr GValue ->                           -- dest_value : TGValue
    CInt ->                                 -- strict_validation : TBasicType TBoolean
    IO CInt

-- | Transforms /@srcValue@/ into /@destValue@/ if possible, and then
-- validates /@destValue@/, in order for it to conform to /@pspec@/.  If
-- /@strictValidation@/ is 'P.True' this function will only succeed if the
-- transformed /@destValue@/ complied to /@pspec@/ without modifications.
-- 
-- See also 'GI.GObject.Functions.valueTypeTransformable', 'GI.GObject.Structs.Value.valueTransform' and
-- 'GI.GObject.Functions.paramValueValidate'.
paramValueConvert ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> GValue
    -- ^ /@srcValue@/: source t'GI.GObject.Structs.Value.Value'
    -> GValue
    -- ^ /@destValue@/: destination t'GI.GObject.Structs.Value.Value' of correct type for /@pspec@/
    -> Bool
    -- ^ /@strictValidation@/: 'P.True' requires /@destValue@/ to conform to /@pspec@/
    -- without modifications
    -> m Bool
    -- ^ __Returns:__ 'P.True' if transformation and validation were successful,
    --  'P.False' otherwise and /@destValue@/ is left untouched.
paramValueConvert pspec srcValue destValue strictValidation = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    srcValue' <- unsafeManagedPtrGetPtr srcValue
    destValue' <- unsafeManagedPtrGetPtr destValue
    let strictValidation' = (P.fromIntegral . P.fromEnum) strictValidation
    result <- g_param_value_convert pspec' srcValue' destValue' strictValidation'
    let result' = (/= 0) result
    touchManagedPtr pspec
    touchManagedPtr srcValue
    touchManagedPtr destValue
    return result'


-- function param_type_register_static
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "0-terminated string used as the name of the new #GParamSpec type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pspec_info"
--           , argType =
--               TInterface
--                 Name { namespace = "GObject" , name = "ParamSpecTypeInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #GParamSpecTypeInfo for this #GParamSpec type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_type_register_static" g_param_type_register_static :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr GObject.ParamSpecTypeInfo.ParamSpecTypeInfo -> -- pspec_info : TInterface (Name {namespace = "GObject", name = "ParamSpecTypeInfo"})
    IO CGType

-- | Registers /@name@/ as the name of a new static type derived
-- from @/G_TYPE_PARAM/@.
-- 
-- The type system uses the information contained in the t'GI.GObject.Structs.ParamSpecTypeInfo.ParamSpecTypeInfo'
-- structure pointed to by /@info@/ to manage the t'GI.GObject.Objects.ParamSpec.ParamSpec' type and its
-- instances.
paramTypeRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: 0-terminated string used as the name of the new t'GI.GObject.Objects.ParamSpec.ParamSpec' type.
    -> GObject.ParamSpecTypeInfo.ParamSpecTypeInfo
    -- ^ /@pspecInfo@/: The t'GI.GObject.Structs.ParamSpecTypeInfo.ParamSpecTypeInfo' for this t'GI.GObject.Objects.ParamSpec.ParamSpec' type.
    -> m GType
    -- ^ __Returns:__ The new type identifier.
paramTypeRegisterStatic name pspecInfo = liftIO $ do
    name' <- textToCString name
    pspecInfo' <- unsafeManagedPtrGetPtr pspecInfo
    result <- g_param_type_register_static name' pspecInfo'
    let result' = GType result
    touchManagedPtr pspecInfo
    freeMem name'
    return result'


-- function param_spec_variant
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariantType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GVariant of type @type to\n                use as the default value, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_variant" g_param_spec_variant :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Ptr GLib.VariantType.VariantType ->     -- type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    Ptr GVariant ->                         -- default_value : TVariant
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecVariant.ParamSpecVariant' instance specifying a t'GVariant'
-- property.
-- 
-- If /@defaultValue@/ is floating, it is consumed.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
-- 
-- /Since: 2.26/
paramSpecVariant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GLib.VariantType.VariantType
    -- ^ /@type@/: a t'GI.GLib.Structs.VariantType.VariantType'
    -> Maybe (GVariant)
    -- ^ /@defaultValue@/: a t'GVariant' of type /@type@/ to
    --                 use as the default value, or 'P.Nothing'
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ the newly created t'GI.GObject.Objects.ParamSpec.ParamSpec'
paramSpecVariant name nick blurb type_ defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    type_' <- unsafeManagedPtrGetPtr type_
    maybeDefaultValue <- case defaultValue of
        Nothing -> return FP.nullPtr
        Just jDefaultValue -> do
            jDefaultValue' <- B.GVariant.disownGVariant jDefaultValue
            return jDefaultValue'
    let flags' = gflagsToWord flags
    result <- g_param_spec_variant name' maybeNick maybeBlurb type_' maybeDefaultValue flags'
    checkUnexpectedReturnNULL "paramSpecVariant" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    touchManagedPtr type_
    whenJust defaultValue touchManagedPtr
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_unichar
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUniChar
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_unichar" g_param_spec_unichar :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CInt ->                                 -- default_value : TBasicType TUniChar
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecUnichar.ParamSpecUnichar' instance specifying a @/G_TYPE_UINT/@
-- property. t'GI.GObject.Structs.Value.Value' structures for this property can be accessed with
-- 'GI.GObject.Structs.Value.valueSetUint' and 'GI.GObject.Structs.Value.valueGetUint'.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecUnichar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Char
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecUnichar name nick blurb defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let defaultValue' = (P.fromIntegral . SP.ord) defaultValue
    let flags' = gflagsToWord flags
    result <- g_param_spec_unichar name' maybeNick maybeBlurb defaultValue' flags'
    checkUnexpectedReturnNULL "paramSpecUnichar" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_ulong
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_ulong" g_param_spec_ulong :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    FCT.CULong ->                           -- minimum : TBasicType TULong
    FCT.CULong ->                           -- maximum : TBasicType TULong
    FCT.CULong ->                           -- default_value : TBasicType TULong
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecULong.ParamSpecULong' instance specifying a @/G_TYPE_ULONG/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecUlong ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> FCT.CULong
    -- ^ /@minimum@/: minimum value for the property specified
    -> FCT.CULong
    -- ^ /@maximum@/: maximum value for the property specified
    -> FCT.CULong
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecUlong name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_ulong name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecUlong" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_uint64
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_uint64" g_param_spec_uint64 :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Word64 ->                               -- minimum : TBasicType TUInt64
    Word64 ->                               -- maximum : TBasicType TUInt64
    Word64 ->                               -- default_value : TBasicType TUInt64
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecUInt64.ParamSpecUInt64' instance specifying a @/G_TYPE_UINT64/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecUint64 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Word64
    -- ^ /@minimum@/: minimum value for the property specified
    -> Word64
    -- ^ /@maximum@/: maximum value for the property specified
    -> Word64
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecUint64 name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_uint64 name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecUint64" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_uint
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_uint" g_param_spec_uint :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Word32 ->                               -- minimum : TBasicType TUInt
    Word32 ->                               -- maximum : TBasicType TUInt
    Word32 ->                               -- default_value : TBasicType TUInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecUInt.ParamSpecUInt' instance specifying a @/G_TYPE_UINT/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecUint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Word32
    -- ^ /@minimum@/: minimum value for the property specified
    -> Word32
    -- ^ /@maximum@/: maximum value for the property specified
    -> Word32
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecUint name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_uint name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecUint" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_uchar
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_uchar" g_param_spec_uchar :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Word8 ->                                -- minimum : TBasicType TUInt8
    Word8 ->                                -- maximum : TBasicType TUInt8
    Word8 ->                                -- default_value : TBasicType TUInt8
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecUChar.ParamSpecUChar' instance specifying a @/G_TYPE_UCHAR/@ property.
paramSpecUchar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Word8
    -- ^ /@minimum@/: minimum value for the property specified
    -> Word8
    -- ^ /@maximum@/: maximum value for the property specified
    -> Word8
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecUchar name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_uchar name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecUchar" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_string
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_string" g_param_spec_string :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CString ->                              -- default_value : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecString.ParamSpecString' instance.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Maybe (T.Text)
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecString name nick blurb defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    maybeDefaultValue <- case defaultValue of
        Nothing -> return FP.nullPtr
        Just jDefaultValue -> do
            jDefaultValue' <- textToCString jDefaultValue
            return jDefaultValue'
    let flags' = gflagsToWord flags
    result <- g_param_spec_string name' maybeNick maybeBlurb maybeDefaultValue flags'
    checkUnexpectedReturnNULL "paramSpecString" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    freeMem maybeDefaultValue
    return result'


-- function param_spec_pointer
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_pointer" g_param_spec_pointer :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecPointer.ParamSpecPointer' instance specifying a pointer property.
-- Where possible, it is better to use 'GI.GObject.Functions.paramSpecObject' or
-- 'GI.GObject.Functions.paramSpecBoxed' to expose memory management information.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecPointer ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecPointer name nick blurb flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_pointer name' maybeNick maybeBlurb flags'
    checkUnexpectedReturnNULL "paramSpecPointer" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_param
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "param_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType derived from %G_TYPE_PARAM"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_param" g_param_spec_param :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- param_type : TBasicType TGType
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecParam.ParamSpecParam' instance specifying a @/G_TYPE_PARAM/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecParam ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@paramType@/: a t'GType' derived from @/G_TYPE_PARAM/@
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecParam name nick blurb paramType flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let paramType' = gtypeToCGType paramType
    let flags' = gflagsToWord flags
    result <- g_param_spec_param name' maybeNick maybeBlurb paramType' flags'
    checkUnexpectedReturnNULL "paramSpecParam" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_object
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%G_TYPE_OBJECT derived type of this property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_object" g_param_spec_object :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- object_type : TBasicType TGType
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecBoxed.ParamSpecBoxed' instance specifying a @/G_TYPE_OBJECT/@
-- derived property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecObject ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@objectType@/: @/G_TYPE_OBJECT/@ derived type of this property
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecObject name nick blurb objectType flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let objectType' = gtypeToCGType objectType
    let flags' = gflagsToWord flags
    result <- g_param_spec_object name' maybeNick maybeBlurb objectType' flags'
    checkUnexpectedReturnNULL "paramSpecObject" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_long
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TLong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_long" g_param_spec_long :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    FCT.CLong ->                            -- minimum : TBasicType TLong
    FCT.CLong ->                            -- maximum : TBasicType TLong
    FCT.CLong ->                            -- default_value : TBasicType TLong
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecLong.ParamSpecLong' instance specifying a @/G_TYPE_LONG/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecLong ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> FCT.CLong
    -- ^ /@minimum@/: minimum value for the property specified
    -> FCT.CLong
    -- ^ /@maximum@/: maximum value for the property specified
    -> FCT.CLong
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecLong name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_long name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecLong" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_int64
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_int64" g_param_spec_int64 :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Int64 ->                                -- minimum : TBasicType TInt64
    Int64 ->                                -- maximum : TBasicType TInt64
    Int64 ->                                -- default_value : TBasicType TInt64
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecInt64.ParamSpecInt64' instance specifying a @/G_TYPE_INT64/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecInt64 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Int64
    -- ^ /@minimum@/: minimum value for the property specified
    -> Int64
    -- ^ /@maximum@/: maximum value for the property specified
    -> Int64
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecInt64 name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_int64 name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecInt64" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_int
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_int" g_param_spec_int :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Int32 ->                                -- minimum : TBasicType TInt
    Int32 ->                                -- maximum : TBasicType TInt
    Int32 ->                                -- default_value : TBasicType TInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecInt.ParamSpecInt' instance specifying a @/G_TYPE_INT/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecInt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Int32
    -- ^ /@minimum@/: minimum value for the property specified
    -> Int32
    -- ^ /@maximum@/: maximum value for the property specified
    -> Int32
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecInt name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_int name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecInt" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_gtype
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_a_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GType whose subtypes are allowed as values\n of the property (use %G_TYPE_NONE for any type)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_gtype" g_param_spec_gtype :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- is_a_type : TBasicType TGType
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecGType.ParamSpecGType' instance specifying a
-- @/G_TYPE_GTYPE/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
-- 
-- /Since: 2.10/
paramSpecGtype ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@isAType@/: a t'GType' whose subtypes are allowed as values
    --  of the property (use @/G_TYPE_NONE/@ for any type)
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecGtype name nick blurb isAType flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let isAType' = gtypeToCGType isAType
    let flags' = gflagsToWord flags
    result <- g_param_spec_gtype name' maybeNick maybeBlurb isAType' flags'
    checkUnexpectedReturnNULL "paramSpecGtype" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_float
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_float" g_param_spec_float :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CFloat ->                               -- minimum : TBasicType TFloat
    CFloat ->                               -- maximum : TBasicType TFloat
    CFloat ->                               -- default_value : TBasicType TFloat
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecFloat.ParamSpecFloat' instance specifying a @/G_TYPE_FLOAT/@ property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecFloat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Float
    -- ^ /@minimum@/: minimum value for the property specified
    -> Float
    -- ^ /@maximum@/: maximum value for the property specified
    -> Float
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecFloat name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let minimum' = realToFrac minimum
    let maximum' = realToFrac maximum
    let defaultValue' = realToFrac defaultValue
    let flags' = gflagsToWord flags
    result <- g_param_spec_float name' maybeNick maybeBlurb minimum' maximum' defaultValue' flags'
    checkUnexpectedReturnNULL "paramSpecFloat" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_flags
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType derived from %G_TYPE_FLAGS"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_flags" g_param_spec_flags :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- flags_type : TBasicType TGType
    Word32 ->                               -- default_value : TBasicType TUInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecFlags.ParamSpecFlags' instance specifying a @/G_TYPE_FLAGS/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@flagsType@/: a t'GType' derived from @/G_TYPE_FLAGS/@
    -> Word32
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecFlags name nick blurb flagsType defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flagsType' = gtypeToCGType flagsType
    let flags' = gflagsToWord flags
    result <- g_param_spec_flags name' maybeNick maybeBlurb flagsType' defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecFlags" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_enum
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enum_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GType derived from %G_TYPE_ENUM"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_enum" g_param_spec_enum :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- enum_type : TBasicType TGType
    Int32 ->                                -- default_value : TBasicType TInt
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecEnum.ParamSpecEnum' instance specifying a @/G_TYPE_ENUM/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecEnum ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@enumType@/: a t'GType' derived from @/G_TYPE_ENUM/@
    -> Int32
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecEnum name nick blurb enumType defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let enumType' = gtypeToCGType enumType
    let flags' = gflagsToWord flags
    result <- g_param_spec_enum name' maybeNick maybeBlurb enumType' defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecEnum" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_double
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_double" g_param_spec_double :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CDouble ->                              -- minimum : TBasicType TDouble
    CDouble ->                              -- maximum : TBasicType TDouble
    CDouble ->                              -- default_value : TBasicType TDouble
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecDouble.ParamSpecDouble' instance specifying a @/G_TYPE_DOUBLE/@
-- property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecDouble ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Double
    -- ^ /@minimum@/: minimum value for the property specified
    -> Double
    -- ^ /@maximum@/: maximum value for the property specified
    -> Double
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecDouble name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let minimum' = realToFrac minimum
    let maximum' = realToFrac maximum
    let defaultValue' = realToFrac defaultValue
    let flags' = gflagsToWord flags
    result <- g_param_spec_double name' maybeNick maybeBlurb minimum' maximum' defaultValue' flags'
    checkUnexpectedReturnNULL "paramSpecDouble" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_char
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minimum"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "maximum"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_char" g_param_spec_char :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    Int8 ->                                 -- minimum : TBasicType TInt8
    Int8 ->                                 -- maximum : TBasicType TInt8
    Int8 ->                                 -- default_value : TBasicType TInt8
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecChar.ParamSpecChar' instance specifying a @/G_TYPE_CHAR/@ property.
paramSpecChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Int8
    -- ^ /@minimum@/: minimum value for the property specified
    -> Int8
    -- ^ /@maximum@/: maximum value for the property specified
    -> Int8
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecChar name nick blurb minimum maximum defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let flags' = gflagsToWord flags
    result <- g_param_spec_char name' maybeNick maybeBlurb minimum maximum defaultValue flags'
    checkUnexpectedReturnNULL "paramSpecChar" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_boxed
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "boxed_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%G_TYPE_BOXED derived type of this property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_boxed" g_param_spec_boxed :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CGType ->                               -- boxed_type : TBasicType TGType
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecBoxed.ParamSpecBoxed' instance specifying a @/G_TYPE_BOXED/@
-- derived property.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecBoxed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> GType
    -- ^ /@boxedType@/: @/G_TYPE_BOXED/@ derived type of this property
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecBoxed name nick blurb boxedType flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let boxedType' = gtypeToCGType boxedType
    let flags' = gflagsToWord flags
    result <- g_param_spec_boxed name' maybeNick maybeBlurb boxedType' flags'
    checkUnexpectedReturnNULL "paramSpecBoxed" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function param_spec_boolean
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "canonical name of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "nick name for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blurb"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "default value for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ParamFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags for the property specified"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_boolean" g_param_spec_boolean :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- nick : TBasicType TUTF8
    CString ->                              -- blurb : TBasicType TUTF8
    CInt ->                                 -- default_value : TBasicType TBoolean
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ParamFlags"})
    IO (Ptr GParamSpec)

-- | Creates a new t'GI.GObject.Objects.ParamSpecBoolean.ParamSpecBoolean' instance specifying a @/G_TYPE_BOOLEAN/@
-- property. In many cases, it may be more appropriate to use an enum with
-- 'GI.GObject.Functions.paramSpecEnum', both to improve code clarity by using explicitly named
-- values, and to allow for more values to be added in future without breaking
-- API.
-- 
-- See @/g_param_spec_internal()/@ for details on property names.
paramSpecBoolean ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: canonical name of the property specified
    -> Maybe (T.Text)
    -- ^ /@nick@/: nick name for the property specified
    -> Maybe (T.Text)
    -- ^ /@blurb@/: description of the property specified
    -> Bool
    -- ^ /@defaultValue@/: default value for the property specified
    -> [GObject.Flags.ParamFlags]
    -- ^ /@flags@/: flags for the property specified
    -> m GParamSpec
    -- ^ __Returns:__ a newly created parameter specification
paramSpecBoolean name nick blurb defaultValue flags = liftIO $ do
    name' <- textToCString name
    maybeNick <- case nick of
        Nothing -> return FP.nullPtr
        Just jNick -> do
            jNick' <- textToCString jNick
            return jNick'
    maybeBlurb <- case blurb of
        Nothing -> return FP.nullPtr
        Just jBlurb -> do
            jBlurb' <- textToCString jBlurb
            return jBlurb'
    let defaultValue' = (P.fromIntegral . P.fromEnum) defaultValue
    let flags' = gflagsToWord flags
    result <- g_param_spec_boolean name' maybeNick maybeBlurb defaultValue' flags'
    checkUnexpectedReturnNULL "paramSpecBoolean" result
    result' <- B.GParamSpec.wrapGParamSpecPtr result
    freeMem name'
    freeMem maybeNick
    freeMem maybeBlurb
    return result'


-- function gtype_get_type
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_gtype_get_type" g_gtype_get_type :: 
    IO CGType

-- | /No description available in the introspection data./
gtypeGetType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GType
gtypeGetType  = liftIO $ do
    result <- g_gtype_get_type
    let result' = GType result
    return result'


-- function flags_to_string
-- Args: [ Arg
--           { argCName = "flags_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type identifier of a #GFlagsClass type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_to_string" g_flags_to_string :: 
    CGType ->                               -- flags_type : TBasicType TGType
    Word32 ->                               -- value : TBasicType TUInt
    IO CString

-- | Pretty-prints /@value@/ in the form of the flag names separated by @ | @ and
-- sorted. Any extra bits will be shown at the end as a hexadecimal number.
-- 
-- This is intended to be used for debugging purposes. The format of the output
-- may change in the future.
-- 
-- /Since: 2.54/
flagsToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@flagsType@/: the type identifier of a t'GI.GObject.Structs.FlagsClass.FlagsClass' type
    -> Word32
    -- ^ /@value@/: the value
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated text string
flagsToString flagsType value = liftIO $ do
    let flagsType' = gtypeToCGType flagsType
    result <- g_flags_to_string flagsType' value
    checkUnexpectedReturnNULL "flagsToString" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function flags_register_static
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A nul-terminated string used as the name of the new type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "const_static_values"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GObject" , name = "FlagsValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of\n #GFlagsValue structs for the possible flags values. The array is\n terminated by a struct with all members being 0. GObject keeps a\n reference to the data, so it cannot be stack-allocated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_register_static" g_flags_register_static :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr (Ptr GObject.FlagsValue.FlagsValue) -> -- const_static_values : TCArray True (-1) (-1) (TInterface (Name {namespace = "GObject", name = "FlagsValue"}))
    IO CGType

-- | Registers a new static flags type with the name /@name@/.
-- 
-- It is normally more convenient to let [glib-mkenums][glib-mkenums]
-- generate a @/my_flags_get_type()/@ function from a usual C enumeration
-- definition than to write one yourself using 'GI.GObject.Functions.flagsRegisterStatic'.
flagsRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: A nul-terminated string used as the name of the new type.
    -> [GObject.FlagsValue.FlagsValue]
    -- ^ /@constStaticValues@/: An array of
    --  t'GI.GObject.Structs.FlagsValue.FlagsValue' structs for the possible flags values. The array is
    --  terminated by a struct with all members being 0. GObject keeps a
    --  reference to the data, so it cannot be stack-allocated.
    -> m GType
    -- ^ __Returns:__ The new type identifier.
flagsRegisterStatic name constStaticValues = liftIO $ do
    name' <- textToCString name
    constStaticValues' <- mapM unsafeManagedPtrGetPtr constStaticValues
    constStaticValues'' <- packZeroTerminatedPtrArray constStaticValues'
    result <- g_flags_register_static name' constStaticValues''
    let result' = GType result
    mapM_ touchManagedPtr constStaticValues
    freeMem name'
    freeMem constStaticValues''
    return result'


-- function flags_get_value_by_nick
-- Args: [ Arg
--           { argCName = "flags_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "FlagsClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFlagsClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the nickname to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "FlagsValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_get_value_by_nick" g_flags_get_value_by_nick :: 
    Ptr GObject.FlagsClass.FlagsClass ->    -- flags_class : TInterface (Name {namespace = "GObject", name = "FlagsClass"})
    CString ->                              -- nick : TBasicType TUTF8
    IO (Ptr GObject.FlagsValue.FlagsValue)

-- | Looks up a t'GI.GObject.Structs.FlagsValue.FlagsValue' by nickname.
flagsGetValueByNick ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.FlagsClass.FlagsClass
    -- ^ /@flagsClass@/: a t'GI.GObject.Structs.FlagsClass.FlagsClass'
    -> T.Text
    -- ^ /@nick@/: the nickname to look up
    -> m (Maybe GObject.FlagsValue.FlagsValue)
    -- ^ __Returns:__ the t'GI.GObject.Structs.FlagsValue.FlagsValue' with nickname /@nick@/,
    --          or 'P.Nothing' if there is no flag with that nickname
flagsGetValueByNick flagsClass nick = liftIO $ do
    flagsClass' <- unsafeManagedPtrGetPtr flagsClass
    nick' <- textToCString nick
    result <- g_flags_get_value_by_nick flagsClass' nick'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.FlagsValue.FlagsValue) result'
        return result''
    touchManagedPtr flagsClass
    freeMem nick'
    return maybeResult


-- function flags_get_value_by_name
-- Args: [ Arg
--           { argCName = "flags_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "FlagsClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFlagsClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "FlagsValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_get_value_by_name" g_flags_get_value_by_name :: 
    Ptr GObject.FlagsClass.FlagsClass ->    -- flags_class : TInterface (Name {namespace = "GObject", name = "FlagsClass"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr GObject.FlagsValue.FlagsValue)

-- | Looks up a t'GI.GObject.Structs.FlagsValue.FlagsValue' by name.
flagsGetValueByName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.FlagsClass.FlagsClass
    -- ^ /@flagsClass@/: a t'GI.GObject.Structs.FlagsClass.FlagsClass'
    -> T.Text
    -- ^ /@name@/: the name to look up
    -> m (Maybe GObject.FlagsValue.FlagsValue)
    -- ^ __Returns:__ the t'GI.GObject.Structs.FlagsValue.FlagsValue' with name /@name@/,
    --          or 'P.Nothing' if there is no flag with that name
flagsGetValueByName flagsClass name = liftIO $ do
    flagsClass' <- unsafeManagedPtrGetPtr flagsClass
    name' <- textToCString name
    result <- g_flags_get_value_by_name flagsClass' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.FlagsValue.FlagsValue) result'
        return result''
    touchManagedPtr flagsClass
    freeMem name'
    return maybeResult


-- function flags_get_first_value
-- Args: [ Arg
--           { argCName = "flags_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "FlagsClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFlagsClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "FlagsValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_get_first_value" g_flags_get_first_value :: 
    Ptr GObject.FlagsClass.FlagsClass ->    -- flags_class : TInterface (Name {namespace = "GObject", name = "FlagsClass"})
    Word32 ->                               -- value : TBasicType TUInt
    IO (Ptr GObject.FlagsValue.FlagsValue)

-- | Returns the first t'GI.GObject.Structs.FlagsValue.FlagsValue' which is set in /@value@/.
flagsGetFirstValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.FlagsClass.FlagsClass
    -- ^ /@flagsClass@/: a t'GI.GObject.Structs.FlagsClass.FlagsClass'
    -> Word32
    -- ^ /@value@/: the value
    -> m (Maybe GObject.FlagsValue.FlagsValue)
    -- ^ __Returns:__ the first t'GI.GObject.Structs.FlagsValue.FlagsValue' which is set in
    --          /@value@/, or 'P.Nothing' if none is set
flagsGetFirstValue flagsClass value = liftIO $ do
    flagsClass' <- unsafeManagedPtrGetPtr flagsClass
    result <- g_flags_get_first_value flagsClass' value
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.FlagsValue.FlagsValue) result'
        return result''
    touchManagedPtr flagsClass
    return maybeResult


-- function flags_complete_type_info
-- Args: [ Arg
--           { argCName = "g_flags_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the type identifier of the type being completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypeInfo struct to be filled in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "const_values"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "FlagsValue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GFlagsValue structs for the possible\n enumeration values. The array is terminated by a struct with all\n members being 0."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_flags_complete_type_info" g_flags_complete_type_info :: 
    CGType ->                               -- g_flags_type : TBasicType TGType
    Ptr (Ptr GObject.TypeInfo.TypeInfo) ->  -- info : TInterface (Name {namespace = "GObject", name = "TypeInfo"})
    Ptr GObject.FlagsValue.FlagsValue ->    -- const_values : TInterface (Name {namespace = "GObject", name = "FlagsValue"})
    IO ()

-- | This function is meant to be called from the @/complete_type_info()/@
-- function of a t'GI.GObject.Interfaces.TypePlugin.TypePlugin' implementation, see the example for
-- 'GI.GObject.Functions.enumCompleteTypeInfo' above.
flagsCompleteTypeInfo ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gFlagsType@/: the type identifier of the type being completed
    -> GObject.FlagsValue.FlagsValue
    -- ^ /@constValues@/: An array of t'GI.GObject.Structs.FlagsValue.FlagsValue' structs for the possible
    --  enumeration values. The array is terminated by a struct with all
    --  members being 0.
    -> m (GObject.TypeInfo.TypeInfo)
flagsCompleteTypeInfo gFlagsType constValues = liftIO $ do
    let gFlagsType' = gtypeToCGType gFlagsType
    info <- callocMem :: IO (Ptr (Ptr GObject.TypeInfo.TypeInfo))
    constValues' <- unsafeManagedPtrGetPtr constValues
    g_flags_complete_type_info gFlagsType' info constValues'
    info' <- peek info
    info'' <- (wrapPtr GObject.TypeInfo.TypeInfo) info'
    touchManagedPtr constValues
    freeMem info
    return info''


-- function enum_to_string
-- Args: [ Arg
--           { argCName = "g_enum_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type identifier of a #GEnumClass type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_to_string" g_enum_to_string :: 
    CGType ->                               -- g_enum_type : TBasicType TGType
    Int32 ->                                -- value : TBasicType TInt
    IO CString

-- | Pretty-prints /@value@/ in the form of the enum’s name.
-- 
-- This is intended to be used for debugging purposes. The format of the output
-- may change in the future.
-- 
-- /Since: 2.54/
enumToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gEnumType@/: the type identifier of a t'GI.GObject.Structs.EnumClass.EnumClass' type
    -> Int32
    -- ^ /@value@/: the value
    -> m T.Text
    -- ^ __Returns:__ a newly-allocated text string
enumToString gEnumType value = liftIO $ do
    let gEnumType' = gtypeToCGType gEnumType
    result <- g_enum_to_string gEnumType' value
    checkUnexpectedReturnNULL "enumToString" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function enum_register_static
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A nul-terminated string used as the name of the new type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "const_static_values"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GObject" , name = "EnumValue" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of\n #GEnumValue structs for the possible enumeration values. The array is\n terminated by a struct with all members being 0. GObject keeps a\n reference to the data, so it cannot be stack-allocated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_register_static" g_enum_register_static :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr (Ptr GObject.EnumValue.EnumValue) -> -- const_static_values : TCArray True (-1) (-1) (TInterface (Name {namespace = "GObject", name = "EnumValue"}))
    IO CGType

-- | Registers a new static enumeration type with the name /@name@/.
-- 
-- It is normally more convenient to let [glib-mkenums][glib-mkenums],
-- generate a @/my_enum_get_type()/@ function from a usual C enumeration
-- definition  than to write one yourself using 'GI.GObject.Functions.enumRegisterStatic'.
enumRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: A nul-terminated string used as the name of the new type.
    -> [GObject.EnumValue.EnumValue]
    -- ^ /@constStaticValues@/: An array of
    --  t'GI.GObject.Structs.EnumValue.EnumValue' structs for the possible enumeration values. The array is
    --  terminated by a struct with all members being 0. GObject keeps a
    --  reference to the data, so it cannot be stack-allocated.
    -> m GType
    -- ^ __Returns:__ The new type identifier.
enumRegisterStatic name constStaticValues = liftIO $ do
    name' <- textToCString name
    constStaticValues' <- mapM unsafeManagedPtrGetPtr constStaticValues
    constStaticValues'' <- packZeroTerminatedPtrArray constStaticValues'
    result <- g_enum_register_static name' constStaticValues''
    let result' = GType result
    mapM_ touchManagedPtr constStaticValues
    freeMem name'
    freeMem constStaticValues''
    return result'


-- function enum_get_value_by_nick
-- Args: [ Arg
--           { argCName = "enum_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "EnumClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEnumClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nick"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the nickname to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "EnumValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_get_value_by_nick" g_enum_get_value_by_nick :: 
    Ptr GObject.EnumClass.EnumClass ->      -- enum_class : TInterface (Name {namespace = "GObject", name = "EnumClass"})
    CString ->                              -- nick : TBasicType TUTF8
    IO (Ptr GObject.EnumValue.EnumValue)

-- | Looks up a t'GI.GObject.Structs.EnumValue.EnumValue' by nickname.
enumGetValueByNick ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.EnumClass.EnumClass
    -- ^ /@enumClass@/: a t'GI.GObject.Structs.EnumClass.EnumClass'
    -> T.Text
    -- ^ /@nick@/: the nickname to look up
    -> m (Maybe GObject.EnumValue.EnumValue)
    -- ^ __Returns:__ the t'GI.GObject.Structs.EnumValue.EnumValue' with nickname /@nick@/,
    --          or 'P.Nothing' if the enumeration doesn\'t have a member
    --          with that nickname
enumGetValueByNick enumClass nick = liftIO $ do
    enumClass' <- unsafeManagedPtrGetPtr enumClass
    nick' <- textToCString nick
    result <- g_enum_get_value_by_nick enumClass' nick'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.EnumValue.EnumValue) result'
        return result''
    touchManagedPtr enumClass
    freeMem nick'
    return maybeResult


-- function enum_get_value_by_name
-- Args: [ Arg
--           { argCName = "enum_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "EnumClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEnumClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "EnumValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_get_value_by_name" g_enum_get_value_by_name :: 
    Ptr GObject.EnumClass.EnumClass ->      -- enum_class : TInterface (Name {namespace = "GObject", name = "EnumClass"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr GObject.EnumValue.EnumValue)

-- | Looks up a t'GI.GObject.Structs.EnumValue.EnumValue' by name.
enumGetValueByName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.EnumClass.EnumClass
    -- ^ /@enumClass@/: a t'GI.GObject.Structs.EnumClass.EnumClass'
    -> T.Text
    -- ^ /@name@/: the name to look up
    -> m (Maybe GObject.EnumValue.EnumValue)
    -- ^ __Returns:__ the t'GI.GObject.Structs.EnumValue.EnumValue' with name /@name@/,
    --          or 'P.Nothing' if the enumeration doesn\'t have a member
    --          with that name
enumGetValueByName enumClass name = liftIO $ do
    enumClass' <- unsafeManagedPtrGetPtr enumClass
    name' <- textToCString name
    result <- g_enum_get_value_by_name enumClass' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.EnumValue.EnumValue) result'
        return result''
    touchManagedPtr enumClass
    freeMem name'
    return maybeResult


-- function enum_get_value
-- Args: [ Arg
--           { argCName = "enum_class"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "EnumClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GEnumClass" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value to look up"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "EnumValue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_get_value" g_enum_get_value :: 
    Ptr GObject.EnumClass.EnumClass ->      -- enum_class : TInterface (Name {namespace = "GObject", name = "EnumClass"})
    Int32 ->                                -- value : TBasicType TInt
    IO (Ptr GObject.EnumValue.EnumValue)

-- | Returns the t'GI.GObject.Structs.EnumValue.EnumValue' for a value.
enumGetValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GObject.EnumClass.EnumClass
    -- ^ /@enumClass@/: a t'GI.GObject.Structs.EnumClass.EnumClass'
    -> Int32
    -- ^ /@value@/: the value to look up
    -> m (Maybe GObject.EnumValue.EnumValue)
    -- ^ __Returns:__ the t'GI.GObject.Structs.EnumValue.EnumValue' for /@value@/, or 'P.Nothing'
    --          if /@value@/ is not a member of the enumeration
enumGetValue enumClass value = liftIO $ do
    enumClass' <- unsafeManagedPtrGetPtr enumClass
    result <- g_enum_get_value enumClass' value
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GObject.EnumValue.EnumValue) result'
        return result''
    touchManagedPtr enumClass
    return maybeResult


-- function enum_complete_type_info
-- Args: [ Arg
--           { argCName = "g_enum_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the type identifier of the type being completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInfo" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTypeInfo struct to be filled in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "const_values"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "EnumValue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "An array of #GEnumValue structs for the possible\n enumeration values. The array is terminated by a struct with all\n members being 0."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_enum_complete_type_info" g_enum_complete_type_info :: 
    CGType ->                               -- g_enum_type : TBasicType TGType
    Ptr (Ptr GObject.TypeInfo.TypeInfo) ->  -- info : TInterface (Name {namespace = "GObject", name = "TypeInfo"})
    Ptr GObject.EnumValue.EnumValue ->      -- const_values : TInterface (Name {namespace = "GObject", name = "EnumValue"})
    IO ()

-- | This function is meant to be called from the @complete_type_info@
-- function of a t'GI.GObject.Interfaces.TypePlugin.TypePlugin' implementation, as in the following
-- example:
-- 
-- 
-- === /C code/
-- >
-- >static void
-- >my_enum_complete_type_info (GTypePlugin     *plugin,
-- >                            GType            g_type,
-- >                            GTypeInfo       *info,
-- >                            GTypeValueTable *value_table)
-- >{
-- >  static const GEnumValue values[] = {
-- >    { MY_ENUM_FOO, "MY_ENUM_FOO", "foo" },
-- >    { MY_ENUM_BAR, "MY_ENUM_BAR", "bar" },
-- >    { 0, NULL, NULL }
-- >  };
-- >
-- >  g_enum_complete_type_info (type, info, values);
-- >}
enumCompleteTypeInfo ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@gEnumType@/: the type identifier of the type being completed
    -> GObject.EnumValue.EnumValue
    -- ^ /@constValues@/: An array of t'GI.GObject.Structs.EnumValue.EnumValue' structs for the possible
    --  enumeration values. The array is terminated by a struct with all
    --  members being 0.
    -> m (GObject.TypeInfo.TypeInfo)
enumCompleteTypeInfo gEnumType constValues = liftIO $ do
    let gEnumType' = gtypeToCGType gEnumType
    info <- callocMem :: IO (Ptr (Ptr GObject.TypeInfo.TypeInfo))
    constValues' <- unsafeManagedPtrGetPtr constValues
    g_enum_complete_type_info gEnumType' info constValues'
    info' <- peek info
    info'' <- (wrapPtr GObject.TypeInfo.TypeInfo) info'
    touchManagedPtr constValues
    freeMem info
    return info''


-- function clear_signal_handler
-- Args: [ Arg
--           { argCName = "handler_id_ptr"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A pointer to a handler ID (of type #gulong) of the handler to be disconnected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The instance to remove the signal handler from.\n  This pointer may be %NULL or invalid, if the handler ID is zero."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_clear_signal_handler" g_clear_signal_handler :: 
    FCT.CULong ->                           -- handler_id_ptr : TBasicType TULong
    Ptr GObject.Object.Object ->            -- instance : TInterface (Name {namespace = "GObject", name = "Object"})
    IO ()

-- | Disconnects a handler from /@instance@/ so it will not be called during
-- any future or currently ongoing emissions of the signal it has been
-- connected to. The /@handlerIdPtr@/ is then set to zero, which is never a valid handler ID value (see @/g_signal_connect()/@).
-- 
-- If the handler ID is 0 then this function does nothing.
-- 
-- There is also a macro version of this function so that the code
-- will be inlined.
-- 
-- /Since: 2.62/
clearSignalHandler ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FCT.CULong
    -- ^ /@handlerIdPtr@/: A pointer to a handler ID (of type @/gulong/@) of the handler to be disconnected.
    -> a
    -- ^ /@instance@/: The instance to remove the signal handler from.
    --   This pointer may be 'P.Nothing' or invalid, if the handler ID is zero.
    -> m ()
clearSignalHandler handlerIdPtr instance_ = liftIO $ do
    instance_' <- unsafeManagedPtrCastPtr instance_
    g_clear_signal_handler handlerIdPtr instance_'
    touchManagedPtr instance_
    return ()


-- function boxed_type_register_static
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the new boxed type."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "boxed_copy"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "BoxedCopyFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Boxed structure copy function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeForever
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "boxed_free"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "BoxedFreeFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Boxed structure free function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeForever
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_boxed_type_register_static" g_boxed_type_register_static :: 
    CString ->                              -- name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_BoxedCopyFunc -> -- boxed_copy : TInterface (Name {namespace = "GObject", name = "BoxedCopyFunc"})
    FunPtr GObject.Callbacks.C_BoxedFreeFunc -> -- boxed_free : TInterface (Name {namespace = "GObject", name = "BoxedFreeFunc"})
    IO CGType

-- | This function creates a new @/G_TYPE_BOXED/@ derived type id for a new
-- boxed type with name /@name@/.
-- 
-- Boxed type handling functions have to be provided to copy and free
-- opaque boxed structures of this type.
-- 
-- For the general case, it is recommended to use @/G_DEFINE_BOXED_TYPE()/@
-- instead of calling 'GI.GObject.Functions.boxedTypeRegisterStatic' directly. The macro
-- will create the appropriate @*_get_type()@ function for the boxed type.
boxedTypeRegisterStatic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: Name of the new boxed type.
    -> GObject.Callbacks.BoxedCopyFunc
    -- ^ /@boxedCopy@/: Boxed structure copy function.
    -> GObject.Callbacks.BoxedFreeFunc
    -- ^ /@boxedFree@/: Boxed structure free function.
    -> m GType
    -- ^ __Returns:__ New @/G_TYPE_BOXED/@ derived type id for /@name@/.
boxedTypeRegisterStatic name boxedCopy boxedFree = liftIO $ do
    name' <- textToCString name
    boxedCopy' <- GObject.Callbacks.mk_BoxedCopyFunc (GObject.Callbacks.wrap_BoxedCopyFunc Nothing (GObject.Callbacks.drop_closures_BoxedCopyFunc boxedCopy))
    boxedFree' <- GObject.Callbacks.mk_BoxedFreeFunc (GObject.Callbacks.wrap_BoxedFreeFunc Nothing (GObject.Callbacks.drop_closures_BoxedFreeFunc boxedFree))
    result <- g_boxed_type_register_static name' boxedCopy' boxedFree'
    let result' = GType result
    freeMem name'
    return result'


-- function boxed_free
-- Args: [ Arg
--           { argCName = "boxed_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of @boxed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "boxed"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The boxed structure to be freed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_boxed_free" g_boxed_free :: 
    CGType ->                               -- boxed_type : TBasicType TGType
    Ptr () ->                               -- boxed : TBasicType TPtr
    IO ()

-- | Free the boxed structure /@boxed@/ which is of type /@boxedType@/.
boxedFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@boxedType@/: The type of /@boxed@/.
    -> Ptr ()
    -- ^ /@boxed@/: The boxed structure to be freed.
    -> m ()
boxedFree boxedType boxed = liftIO $ do
    let boxedType' = gtypeToCGType boxedType
    g_boxed_free boxedType' boxed
    return ()


-- function boxed_copy
-- Args: [ Arg
--           { argCName = "boxed_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of @src_boxed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_boxed"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The boxed structure to be copied."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_boxed_copy" g_boxed_copy :: 
    CGType ->                               -- boxed_type : TBasicType TGType
    Ptr () ->                               -- src_boxed : TBasicType TPtr
    IO (Ptr ())

-- | Provide a copy of a boxed structure /@srcBoxed@/ which is of type /@boxedType@/.
boxedCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@boxedType@/: The type of /@srcBoxed@/.
    -> Ptr ()
    -- ^ /@srcBoxed@/: The boxed structure to be copied.
    -> m (Ptr ())
    -- ^ __Returns:__ The newly created copy of the boxed
    --    structure.
boxedCopy boxedType srcBoxed = liftIO $ do
    let boxedType' = gtypeToCGType boxedType
    result <- g_boxed_copy boxedType' srcBoxed
    return result



