{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Constants
    ( 
    pattern VALUE_NOCOPY_CONTENTS           ,
    pattern VALUE_INTERNED_STRING           ,
    pattern VALUE_COLLECT_FORMAT_MAX_LENGTH ,
    pattern TYPE_RESERVED_USER_FIRST        ,
    pattern TYPE_RESERVED_GLIB_LAST         ,
    pattern TYPE_RESERVED_GLIB_FIRST        ,
    pattern TYPE_RESERVED_BSE_LAST          ,
    pattern TYPE_RESERVED_BSE_FIRST         ,
    pattern TYPE_FUNDAMENTAL_SHIFT          ,
    pattern TYPE_FUNDAMENTAL_MAX            ,
    pattern TYPE_FLAG_RESERVED_ID_BIT       ,
    pattern SIGNAL_MATCH_MASK               ,
    pattern SIGNAL_FLAGS_MASK               ,
    pattern PARAM_USER_SHIFT                ,
    pattern PARAM_STATIC_STRINGS            ,
    pattern PARAM_MASK                      ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | If passed to @/G_VALUE_COLLECT()/@, allocated data won\'t be copied
-- but used verbatim. This does not affect ref-counted types like
-- objects. This does not affect usage of 'GI.GObject.Structs.Value.valueCopy', the data will
-- be copied if it is not ref-counted.
pattern VALUE_NOCOPY_CONTENTS = 134217728 :: Int32

-- | For string values, indicates that the string contained is canonical and will
-- exist for the duration of the process. See 'GI.GObject.Structs.Value.valueSetInternedString'.
-- 
-- /Since: 2.66/
pattern VALUE_INTERNED_STRING = 268435456 :: Int32

-- | The maximal number of @/GTypeCValues/@ which can be collected for a
-- single t'GI.GObject.Structs.Value.Value'.
pattern VALUE_COLLECT_FORMAT_MAX_LENGTH = 8 :: Int32

-- | First available fundamental type number to create new fundamental
-- type id with @/G_TYPE_MAKE_FUNDAMENTAL()/@.
pattern TYPE_RESERVED_USER_FIRST = 49 :: Int32

-- | Last fundamental type number reserved for GLib.
pattern TYPE_RESERVED_GLIB_LAST = 31 :: Int32

-- | First fundamental type number to create a new fundamental type id with
-- @/G_TYPE_MAKE_FUNDAMENTAL()/@ reserved for GLib.
pattern TYPE_RESERVED_GLIB_FIRST = 22 :: Int32

-- | Last fundamental type number reserved for BSE.
pattern TYPE_RESERVED_BSE_LAST = 48 :: Int32

-- | First fundamental type number to create a new fundamental type id with
-- @/G_TYPE_MAKE_FUNDAMENTAL()/@ reserved for BSE.
pattern TYPE_RESERVED_BSE_FIRST = 32 :: Int32

-- | Shift value used in converting numbers to type IDs.
pattern TYPE_FUNDAMENTAL_SHIFT = 2 :: Int32

-- | An integer constant that represents the number of identifiers reserved
-- for types that are assigned at compile-time.
pattern TYPE_FUNDAMENTAL_MAX = 1020 :: Int32

-- | A bit in the type number that\'s supposed to be left untouched.
pattern TYPE_FLAG_RESERVED_ID_BIT = 1 :: FCT.CSize

-- | A mask for all t'GI.GObject.Flags.SignalMatchType' bits.
pattern SIGNAL_MATCH_MASK = 63 :: Int32

-- | A mask for all t'GI.GObject.Flags.SignalFlags' bits.
pattern SIGNAL_FLAGS_MASK = 511 :: Int32

-- | Minimum shift count to be used for user defined flags, to be stored in
-- t'GI.GObject.Objects.ParamSpec.ParamSpec'.@/flags/@. The maximum allowed is 10.
pattern PARAM_USER_SHIFT = 8 :: Int32

-- | t'GI.GObject.Flags.ParamFlags' value alias for 'GI.GObject.Flags.ParamFlagsStaticName' | 'GI.GObject.Flags.ParamFlagsStaticNick' | 'GI.GObject.Flags.ParamFlagsStaticBlurb'.
-- 
-- It is recommended to use this for all properties by default, as it allows for
-- internal performance improvements in GObject.
-- 
-- It is very rare that a property would have a dynamically constructed name,
-- nickname or blurb.
-- 
-- Since 2.13.0
pattern PARAM_STATIC_STRINGS = 224 :: Int32

-- | Mask containing the bits of t'GI.GObject.Objects.ParamSpec.ParamSpec'.@/flags/@ which are reserved for GLib.
pattern PARAM_MASK = 255 :: Int32


