{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque structure used as the base of all type instances.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.TypeInstance
    ( 

-- * Exported types
    TypeInstance(..)                        ,
    newZeroTypeInstance                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getPrivate]("GI.GObject.Structs.TypeInstance#g:method:getPrivate").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTypeInstanceMethod               ,
#endif

-- ** getPrivate #method:getPrivate#

#if defined(ENABLE_OVERLOADING)
    TypeInstanceGetPrivateMethodInfo        ,
#endif
    typeInstanceGetPrivate                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TypeInstance = TypeInstance (SP.ManagedPtr TypeInstance)
    deriving (Eq)

instance SP.ManagedPtrNewtype TypeInstance where
    toManagedPtr (TypeInstance p) = p

instance BoxedPtr TypeInstance where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr TypeInstance)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TypeInstance where
    boxedPtrCalloc = callocBytes 8


-- | Construct a `TypeInstance` struct initialized to zero.
newZeroTypeInstance :: MonadIO m => m TypeInstance
newZeroTypeInstance = liftIO $ boxedPtrCalloc >>= wrapPtr TypeInstance

instance tag ~ 'AttrSet => Constructible TypeInstance tag where
    new _ attrs = do
        o <- newZeroTypeInstance
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TypeInstance
type instance O.AttributeList TypeInstance = TypeInstanceAttributeList
type TypeInstanceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TypeInstance::get_private
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "instance"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "TypeInstance" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_type_instance_get_private" g_type_instance_get_private :: 
    Ptr TypeInstance ->                     -- instance : TInterface (Name {namespace = "GObject", name = "TypeInstance"})
    CGType ->                               -- private_type : TBasicType TGType
    IO (Ptr ())

-- | /No description available in the introspection data./
typeInstanceGetPrivate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TypeInstance
    -> GType
    -> m (Ptr ())
typeInstanceGetPrivate instance_ privateType = liftIO $ do
    instance_' <- unsafeManagedPtrGetPtr instance_
    let privateType' = gtypeToCGType privateType
    result <- g_type_instance_get_private instance_' privateType'
    touchManagedPtr instance_
    return result

#if defined(ENABLE_OVERLOADING)
data TypeInstanceGetPrivateMethodInfo
instance (signature ~ (GType -> m (Ptr ())), MonadIO m) => O.OverloadedMethod TypeInstanceGetPrivateMethodInfo TypeInstance signature where
    overloadedMethod = typeInstanceGetPrivate

instance O.OverloadedMethodInfo TypeInstanceGetPrivateMethodInfo TypeInstance where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.TypeInstance.typeInstanceGetPrivate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-TypeInstance.html#v:typeInstanceGetPrivate"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTypeInstanceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTypeInstanceMethod "getPrivate" o = TypeInstanceGetPrivateMethodInfo
    ResolveTypeInstanceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTypeInstanceMethod t TypeInstance, O.OverloadedMethod info TypeInstance p) => OL.IsLabel t (TypeInstance -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTypeInstanceMethod t TypeInstance, O.OverloadedMethod info TypeInstance p, R.HasField t TypeInstance p) => R.HasField t TypeInstance p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTypeInstanceMethod t TypeInstance, O.OverloadedMethodInfo info TypeInstance) => OL.IsLabel t (O.MethodProxy info TypeInstance) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


