{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GObject.Structs.SignalInvocationHint.SignalInvocationHint' structure is used to pass on additional information
-- to callbacks during a signal emission.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.SignalInvocationHint
    ( 

-- * Exported types
    SignalInvocationHint(..)                ,
    newZeroSignalInvocationHint             ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSignalInvocationHintMethod       ,
#endif



 -- * Properties


-- ** detail #attr:detail#
-- | The detail passed on for this emission

    getSignalInvocationHintDetail           ,
    setSignalInvocationHintDetail           ,
#if defined(ENABLE_OVERLOADING)
    signalInvocationHint_detail             ,
#endif


-- ** runType #attr:runType#
-- | The stage the signal emission is currently in, this
--  field will contain one of 'GI.GObject.Flags.SignalFlagsRunFirst',
--  'GI.GObject.Flags.SignalFlagsRunLast' or 'GI.GObject.Flags.SignalFlagsRunCleanup' and 'GI.GObject.Flags.SignalFlagsAccumulatorFirstRun'.
--  'GI.GObject.Flags.SignalFlagsAccumulatorFirstRun' is only set for the first run of the accumulator
--  function for a signal emission.

    getSignalInvocationHintRunType          ,
    setSignalInvocationHintRunType          ,
#if defined(ENABLE_OVERLOADING)
    signalInvocationHint_runType            ,
#endif


-- ** signalId #attr:signalId#
-- | The signal id of the signal invoking the callback

    getSignalInvocationHintSignalId         ,
    setSignalInvocationHintSignalId         ,
#if defined(ENABLE_OVERLOADING)
    signalInvocationHint_signalId           ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#else
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#endif

-- | Memory-managed wrapper type.
newtype SignalInvocationHint = SignalInvocationHint (SP.ManagedPtr SignalInvocationHint)
    deriving (Eq)

instance SP.ManagedPtrNewtype SignalInvocationHint where
    toManagedPtr (SignalInvocationHint p) = p

instance BoxedPtr SignalInvocationHint where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 12 >=> B.ManagedPtr.wrapPtr SignalInvocationHint)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr SignalInvocationHint where
    boxedPtrCalloc = callocBytes 12


-- | Construct a `SignalInvocationHint` struct initialized to zero.
newZeroSignalInvocationHint :: MonadIO m => m SignalInvocationHint
newZeroSignalInvocationHint = liftIO $ boxedPtrCalloc >>= wrapPtr SignalInvocationHint

instance tag ~ 'AttrSet => Constructible SignalInvocationHint tag where
    new _ attrs = do
        o <- newZeroSignalInvocationHint
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@signal_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalInvocationHint #signalId
-- @
getSignalInvocationHintSignalId :: MonadIO m => SignalInvocationHint -> m Word32
getSignalInvocationHintSignalId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@signal_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalInvocationHint [ #signalId 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalInvocationHintSignalId :: MonadIO m => SignalInvocationHint -> Word32 -> m ()
setSignalInvocationHintSignalId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data SignalInvocationHintSignalIdFieldInfo
instance AttrInfo SignalInvocationHintSignalIdFieldInfo where
    type AttrBaseTypeConstraint SignalInvocationHintSignalIdFieldInfo = (~) SignalInvocationHint
    type AttrAllowedOps SignalInvocationHintSignalIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalInvocationHintSignalIdFieldInfo = (~) Word32
    type AttrTransferTypeConstraint SignalInvocationHintSignalIdFieldInfo = (~)Word32
    type AttrTransferType SignalInvocationHintSignalIdFieldInfo = Word32
    type AttrGetType SignalInvocationHintSignalIdFieldInfo = Word32
    type AttrLabel SignalInvocationHintSignalIdFieldInfo = "signal_id"
    type AttrOrigin SignalInvocationHintSignalIdFieldInfo = SignalInvocationHint
    attrGet = getSignalInvocationHintSignalId
    attrSet = setSignalInvocationHintSignalId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalInvocationHint.signalId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-SignalInvocationHint.html#g:attr:signalId"
        })

signalInvocationHint_signalId :: AttrLabelProxy "signalId"
signalInvocationHint_signalId = AttrLabelProxy

#endif


-- | Get the value of the “@detail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalInvocationHint #detail
-- @
getSignalInvocationHintDetail :: MonadIO m => SignalInvocationHint -> m Word32
getSignalInvocationHintDetail s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@detail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalInvocationHint [ #detail 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalInvocationHintDetail :: MonadIO m => SignalInvocationHint -> Word32 -> m ()
setSignalInvocationHintDetail s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data SignalInvocationHintDetailFieldInfo
instance AttrInfo SignalInvocationHintDetailFieldInfo where
    type AttrBaseTypeConstraint SignalInvocationHintDetailFieldInfo = (~) SignalInvocationHint
    type AttrAllowedOps SignalInvocationHintDetailFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalInvocationHintDetailFieldInfo = (~) Word32
    type AttrTransferTypeConstraint SignalInvocationHintDetailFieldInfo = (~)Word32
    type AttrTransferType SignalInvocationHintDetailFieldInfo = Word32
    type AttrGetType SignalInvocationHintDetailFieldInfo = Word32
    type AttrLabel SignalInvocationHintDetailFieldInfo = "detail"
    type AttrOrigin SignalInvocationHintDetailFieldInfo = SignalInvocationHint
    attrGet = getSignalInvocationHintDetail
    attrSet = setSignalInvocationHintDetail
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalInvocationHint.detail"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-SignalInvocationHint.html#g:attr:detail"
        })

signalInvocationHint_detail :: AttrLabelProxy "detail"
signalInvocationHint_detail = AttrLabelProxy

#endif


-- | Get the value of the “@run_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalInvocationHint #runType
-- @
getSignalInvocationHintRunType :: MonadIO m => SignalInvocationHint -> m [GObject.Flags.SignalFlags]
getSignalInvocationHintRunType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@run_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalInvocationHint [ #runType 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalInvocationHintRunType :: MonadIO m => SignalInvocationHint -> [GObject.Flags.SignalFlags] -> m ()
setSignalInvocationHintRunType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 8) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data SignalInvocationHintRunTypeFieldInfo
instance AttrInfo SignalInvocationHintRunTypeFieldInfo where
    type AttrBaseTypeConstraint SignalInvocationHintRunTypeFieldInfo = (~) SignalInvocationHint
    type AttrAllowedOps SignalInvocationHintRunTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalInvocationHintRunTypeFieldInfo = (~) [GObject.Flags.SignalFlags]
    type AttrTransferTypeConstraint SignalInvocationHintRunTypeFieldInfo = (~)[GObject.Flags.SignalFlags]
    type AttrTransferType SignalInvocationHintRunTypeFieldInfo = [GObject.Flags.SignalFlags]
    type AttrGetType SignalInvocationHintRunTypeFieldInfo = [GObject.Flags.SignalFlags]
    type AttrLabel SignalInvocationHintRunTypeFieldInfo = "run_type"
    type AttrOrigin SignalInvocationHintRunTypeFieldInfo = SignalInvocationHint
    attrGet = getSignalInvocationHintRunType
    attrSet = setSignalInvocationHintRunType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalInvocationHint.runType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-SignalInvocationHint.html#g:attr:runType"
        })

signalInvocationHint_runType :: AttrLabelProxy "runType"
signalInvocationHint_runType = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SignalInvocationHint
type instance O.AttributeList SignalInvocationHint = SignalInvocationHintAttributeList
type SignalInvocationHintAttributeList = ('[ '("signalId", SignalInvocationHintSignalIdFieldInfo), '("detail", SignalInvocationHintDetailFieldInfo), '("runType", SignalInvocationHintRunTypeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSignalInvocationHintMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSignalInvocationHintMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSignalInvocationHintMethod t SignalInvocationHint, O.OverloadedMethod info SignalInvocationHint p) => OL.IsLabel t (SignalInvocationHint -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSignalInvocationHintMethod t SignalInvocationHint, O.OverloadedMethod info SignalInvocationHint p, R.HasField t SignalInvocationHint p) => R.HasField t SignalInvocationHint p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSignalInvocationHintMethod t SignalInvocationHint, O.OverloadedMethodInfo info SignalInvocationHint) => OL.IsLabel t (O.MethodProxy info SignalInvocationHint) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


