{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The GParameter struct is an auxiliary structure used
-- to hand parameter name\/value pairs to 'GI.GObject.Objects.Object.objectNewv'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.Parameter
    ( 

-- * Exported types
    Parameter(..)                           ,
    newZeroParameter                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveParameterMethod                  ,
#endif



 -- * Properties


-- ** name #attr:name#
-- | the parameter name

    clearParameterName                      ,
    getParameterName                        ,
#if defined(ENABLE_OVERLOADING)
    parameter_name                          ,
#endif
    setParameterName                        ,


-- ** value #attr:value#
-- | the parameter value

    clearParameterValue                     ,
    getParameterValue                       ,
#if defined(ENABLE_OVERLOADING)
    parameter_value                         ,
#endif
    setParameterValue                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Parameter = Parameter (SP.ManagedPtr Parameter)
    deriving (Eq)

instance SP.ManagedPtrNewtype Parameter where
    toManagedPtr (Parameter p) = p

instance BoxedPtr Parameter where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr Parameter)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Parameter where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `Parameter` struct initialized to zero.
newZeroParameter :: MonadIO m => m Parameter
newZeroParameter = liftIO $ boxedPtrCalloc >>= wrapPtr Parameter

instance tag ~ 'AttrSet => Constructible Parameter tag where
    new _ attrs = do
        o <- newZeroParameter
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parameter #name
-- @
getParameterName :: MonadIO m => Parameter -> m (Maybe T.Text)
getParameterName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parameter [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setParameterName :: MonadIO m => Parameter -> CString -> m ()
setParameterName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearParameterName :: MonadIO m => Parameter -> m ()
clearParameterName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data ParameterNameFieldInfo
instance AttrInfo ParameterNameFieldInfo where
    type AttrBaseTypeConstraint ParameterNameFieldInfo = (~) Parameter
    type AttrAllowedOps ParameterNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParameterNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint ParameterNameFieldInfo = (~)CString
    type AttrTransferType ParameterNameFieldInfo = CString
    type AttrGetType ParameterNameFieldInfo = Maybe T.Text
    type AttrLabel ParameterNameFieldInfo = "name"
    type AttrOrigin ParameterNameFieldInfo = Parameter
    attrGet = getParameterName
    attrSet = setParameterName
    attrConstruct = undefined
    attrClear = clearParameterName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.Parameter.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-Parameter.html#g:attr:name"
        })

parameter_name :: AttrLabelProxy "name"
parameter_name = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' parameter #value
-- @
getParameterValue :: MonadIO m => Parameter -> m (Maybe GValue)
getParameterValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr GValue)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- B.GValue.newGValueFromPtr val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' parameter [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setParameterValue :: MonadIO m => Parameter -> Ptr GValue -> m ()
setParameterValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr GValue)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearParameterValue :: MonadIO m => Parameter -> m ()
clearParameterValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr GValue)

#if defined(ENABLE_OVERLOADING)
data ParameterValueFieldInfo
instance AttrInfo ParameterValueFieldInfo where
    type AttrBaseTypeConstraint ParameterValueFieldInfo = (~) Parameter
    type AttrAllowedOps ParameterValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ParameterValueFieldInfo = (~) (Ptr GValue)
    type AttrTransferTypeConstraint ParameterValueFieldInfo = (~)(Ptr GValue)
    type AttrTransferType ParameterValueFieldInfo = (Ptr GValue)
    type AttrGetType ParameterValueFieldInfo = Maybe GValue
    type AttrLabel ParameterValueFieldInfo = "value"
    type AttrOrigin ParameterValueFieldInfo = Parameter
    attrGet = getParameterValue
    attrSet = setParameterValue
    attrConstruct = undefined
    attrClear = clearParameterValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.Parameter.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-Parameter.html#g:attr:value"
        })

parameter_value :: AttrLabelProxy "value"
parameter_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Parameter
type instance O.AttributeList Parameter = ParameterAttributeList
type ParameterAttributeList = ('[ '("name", ParameterNameFieldInfo), '("value", ParameterValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveParameterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveParameterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveParameterMethod t Parameter, O.OverloadedMethod info Parameter p) => OL.IsLabel t (Parameter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveParameterMethod t Parameter, O.OverloadedMethod info Parameter p, R.HasField t Parameter p) => R.HasField t Parameter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveParameterMethod t Parameter, O.OverloadedMethodInfo info Parameter) => OL.IsLabel t (O.MethodProxy info Parameter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


