{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The class structure for the GInitiallyUnowned type.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.InitiallyUnownedClass
    ( 

-- * Exported types
    InitiallyUnownedClass(..)               ,
    newZeroInitiallyUnownedClass            ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveInitiallyUnownedClassMethod      ,
#endif



 -- * Properties


-- ** constructed #attr:constructed#
-- | the /@constructed@/ function is called by @/g_object_new()/@ as the
--  final step of the object creation process.  At the point of the call, all
--  construction properties have been set on the object.  The purpose of this
--  call is to allow for object initialisation steps that can only be performed
--  after construction properties have been set.  /@constructed@/ implementors
--  should chain up to the /@constructed@/ call of their parent class to allow it
--  to complete its initialisation.

    clearInitiallyUnownedClassConstructed   ,
    getInitiallyUnownedClassConstructed     ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_constructed       ,
#endif
    setInitiallyUnownedClassConstructed     ,


-- ** dispatchPropertiesChanged #attr:dispatchPropertiesChanged#
-- | emits property change notification for a bunch
--  of properties. Overriding /@dispatchPropertiesChanged@/ should be rarely
--  needed.

    clearInitiallyUnownedClassDispatchPropertiesChanged,
    getInitiallyUnownedClassDispatchPropertiesChanged,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_dispatchPropertiesChanged,
#endif
    setInitiallyUnownedClassDispatchPropertiesChanged,


-- ** dispose #attr:dispose#
-- | the /@dispose@/ function is supposed to drop all references to other
--  objects, but keep the instance otherwise intact, so that client method
--  invocations still work. It may be run multiple times (due to reference
--  loops). Before returning, /@dispose@/ should chain up to the /@dispose@/ method
--  of the parent class.

    clearInitiallyUnownedClassDispose       ,
    getInitiallyUnownedClassDispose         ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_dispose           ,
#endif
    setInitiallyUnownedClassDispose         ,


-- ** finalize #attr:finalize#
-- | instance finalization function, should finish the finalization of
--  the instance begun in /@dispose@/ and chain up to the /@finalize@/ method of the
--  parent class.

    clearInitiallyUnownedClassFinalize      ,
    getInitiallyUnownedClassFinalize        ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_finalize          ,
#endif
    setInitiallyUnownedClassFinalize        ,


-- ** gTypeClass #attr:gTypeClass#
-- | the parent class

    getInitiallyUnownedClassGTypeClass      ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_gTypeClass        ,
#endif


-- ** getProperty #attr:getProperty#
-- | the generic getter for all properties of this type. Should be
--  overridden for every type with properties.

    clearInitiallyUnownedClassGetProperty   ,
    getInitiallyUnownedClassGetProperty     ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_getProperty       ,
#endif
    setInitiallyUnownedClassGetProperty     ,


-- ** notify #attr:notify#
-- | the class closure for the notify signal

    clearInitiallyUnownedClassNotify        ,
    getInitiallyUnownedClassNotify          ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_notify            ,
#endif
    setInitiallyUnownedClassNotify          ,


-- ** setProperty #attr:setProperty#
-- | the generic setter for all properties of this type. Should be
--  overridden for every type with properties. If implementations of
--  /@setProperty@/ don\'t emit property change notification explicitly, this will
--  be done implicitly by the type system. However, if the notify signal is
--  emitted explicitly, the type system will not emit it a second time.

    clearInitiallyUnownedClassSetProperty   ,
    getInitiallyUnownedClassSetProperty     ,
#if defined(ENABLE_OVERLOADING)
    initiallyUnownedClass_setProperty       ,
#endif
    setInitiallyUnownedClassSetProperty     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass

#endif

-- | Memory-managed wrapper type.
newtype InitiallyUnownedClass = InitiallyUnownedClass (SP.ManagedPtr InitiallyUnownedClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype InitiallyUnownedClass where
    toManagedPtr (InitiallyUnownedClass p) = p

instance BoxedPtr InitiallyUnownedClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 136 >=> B.ManagedPtr.wrapPtr InitiallyUnownedClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr InitiallyUnownedClass where
    boxedPtrCalloc = callocBytes 136


-- | Construct a `InitiallyUnownedClass` struct initialized to zero.
newZeroInitiallyUnownedClass :: MonadIO m => m InitiallyUnownedClass
newZeroInitiallyUnownedClass = liftIO $ boxedPtrCalloc >>= wrapPtr InitiallyUnownedClass

instance tag ~ 'AttrSet => Constructible InitiallyUnownedClass tag where
    new _ attrs = do
        o <- newZeroInitiallyUnownedClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@g_type_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #gTypeClass
-- @
getInitiallyUnownedClassGTypeClass :: MonadIO m => InitiallyUnownedClass -> m GObject.TypeClass.TypeClass
getInitiallyUnownedClassGTypeClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.TypeClass.TypeClass)
    val' <- (newPtr GObject.TypeClass.TypeClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassGTypeClassFieldInfo
instance AttrInfo InitiallyUnownedClassGTypeClassFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassGTypeClassFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassGTypeClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint InitiallyUnownedClassGTypeClassFieldInfo = (~) (Ptr GObject.TypeClass.TypeClass)
    type AttrTransferTypeConstraint InitiallyUnownedClassGTypeClassFieldInfo = (~)(Ptr GObject.TypeClass.TypeClass)
    type AttrTransferType InitiallyUnownedClassGTypeClassFieldInfo = (Ptr GObject.TypeClass.TypeClass)
    type AttrGetType InitiallyUnownedClassGTypeClassFieldInfo = GObject.TypeClass.TypeClass
    type AttrLabel InitiallyUnownedClassGTypeClassFieldInfo = "g_type_class"
    type AttrOrigin InitiallyUnownedClassGTypeClassFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassGTypeClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.gTypeClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:gTypeClass"
        })

initiallyUnownedClass_gTypeClass :: AttrLabelProxy "gTypeClass"
initiallyUnownedClass_gTypeClass = AttrLabelProxy

#endif


-- | Get the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #setProperty
-- @
getInitiallyUnownedClassSetProperty :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassSetPropertyFieldCallback)
getInitiallyUnownedClassSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassSetPropertyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@set_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #setProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassSetProperty :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback -> m ()
setInitiallyUnownedClassSetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback)

-- | Set the value of the “@set_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setProperty
-- @
clearInitiallyUnownedClassSetProperty :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassSetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassSetPropertyFieldInfo
instance AttrInfo InitiallyUnownedClassSetPropertyFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassSetPropertyFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassSetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassSetPropertyFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassSetPropertyFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassSetPropertyFieldCallback
    type AttrTransferType InitiallyUnownedClassSetPropertyFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassSetPropertyFieldCallback)
    type AttrGetType InitiallyUnownedClassSetPropertyFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassSetPropertyFieldCallback
    type AttrLabel InitiallyUnownedClassSetPropertyFieldInfo = "set_property"
    type AttrOrigin InitiallyUnownedClassSetPropertyFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassSetProperty
    attrSet = setInitiallyUnownedClassSetProperty
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassSetProperty
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassSetPropertyFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassSetPropertyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.setProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:setProperty"
        })

initiallyUnownedClass_setProperty :: AttrLabelProxy "setProperty"
initiallyUnownedClass_setProperty = AttrLabelProxy

#endif


-- | Get the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #getProperty
-- @
getInitiallyUnownedClassGetProperty :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassGetPropertyFieldCallback)
getInitiallyUnownedClassGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassGetPropertyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@get_property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #getProperty 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassGetProperty :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback -> m ()
setInitiallyUnownedClassGetProperty s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback)

-- | Set the value of the “@get_property@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getProperty
-- @
clearInitiallyUnownedClassGetProperty :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassGetProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassGetPropertyFieldInfo
instance AttrInfo InitiallyUnownedClassGetPropertyFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassGetPropertyFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassGetPropertyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassGetPropertyFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassGetPropertyFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassGetPropertyFieldCallback
    type AttrTransferType InitiallyUnownedClassGetPropertyFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassGetPropertyFieldCallback)
    type AttrGetType InitiallyUnownedClassGetPropertyFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassGetPropertyFieldCallback
    type AttrLabel InitiallyUnownedClassGetPropertyFieldInfo = "get_property"
    type AttrOrigin InitiallyUnownedClassGetPropertyFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassGetProperty
    attrSet = setInitiallyUnownedClassGetProperty
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassGetProperty
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassGetPropertyFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassGetPropertyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.getProperty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:getProperty"
        })

initiallyUnownedClass_getProperty :: AttrLabelProxy "getProperty"
initiallyUnownedClass_getProperty = AttrLabelProxy

#endif


-- | Get the value of the “@dispose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #dispose
-- @
getInitiallyUnownedClassDispose :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassDisposeFieldCallback)
getInitiallyUnownedClassDispose s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassDisposeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@dispose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #dispose 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassDispose :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback -> m ()
setInitiallyUnownedClassDispose s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback)

-- | Set the value of the “@dispose@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dispose
-- @
clearInitiallyUnownedClassDispose :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassDispose s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassDisposeFieldInfo
instance AttrInfo InitiallyUnownedClassDisposeFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassDisposeFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassDisposeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassDisposeFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassDisposeFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassDisposeFieldCallback
    type AttrTransferType InitiallyUnownedClassDisposeFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDisposeFieldCallback)
    type AttrGetType InitiallyUnownedClassDisposeFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassDisposeFieldCallback
    type AttrLabel InitiallyUnownedClassDisposeFieldInfo = "dispose"
    type AttrOrigin InitiallyUnownedClassDisposeFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassDispose
    attrSet = setInitiallyUnownedClassDispose
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassDispose
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassDisposeFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassDisposeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.dispose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:dispose"
        })

initiallyUnownedClass_dispose :: AttrLabelProxy "dispose"
initiallyUnownedClass_dispose = AttrLabelProxy

#endif


-- | Get the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #finalize
-- @
getInitiallyUnownedClassFinalize :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassFinalizeFieldCallback)
getInitiallyUnownedClassFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassFinalizeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@finalize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #finalize 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassFinalize :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback -> m ()
setInitiallyUnownedClassFinalize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback)

-- | Set the value of the “@finalize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #finalize
-- @
clearInitiallyUnownedClassFinalize :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassFinalize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassFinalizeFieldInfo
instance AttrInfo InitiallyUnownedClassFinalizeFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassFinalizeFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassFinalizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassFinalizeFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassFinalizeFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassFinalizeFieldCallback
    type AttrTransferType InitiallyUnownedClassFinalizeFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassFinalizeFieldCallback)
    type AttrGetType InitiallyUnownedClassFinalizeFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassFinalizeFieldCallback
    type AttrLabel InitiallyUnownedClassFinalizeFieldInfo = "finalize"
    type AttrOrigin InitiallyUnownedClassFinalizeFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassFinalize
    attrSet = setInitiallyUnownedClassFinalize
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassFinalize
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassFinalizeFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassFinalizeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.finalize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:finalize"
        })

initiallyUnownedClass_finalize :: AttrLabelProxy "finalize"
initiallyUnownedClass_finalize = AttrLabelProxy

#endif


-- | Get the value of the “@dispatch_properties_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #dispatchPropertiesChanged
-- @
getInitiallyUnownedClassDispatchPropertiesChanged :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)
getInitiallyUnownedClassDispatchPropertiesChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@dispatch_properties_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #dispatchPropertiesChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassDispatchPropertiesChanged :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback -> m ()
setInitiallyUnownedClassDispatchPropertiesChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)

-- | Set the value of the “@dispatch_properties_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #dispatchPropertiesChanged
-- @
clearInitiallyUnownedClassDispatchPropertiesChanged :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassDispatchPropertiesChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassDispatchPropertiesChangedFieldInfo
instance AttrInfo InitiallyUnownedClassDispatchPropertiesChangedFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
    type AttrTransferType InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback)
    type AttrGetType InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassDispatchPropertiesChangedFieldCallback
    type AttrLabel InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = "dispatch_properties_changed"
    type AttrOrigin InitiallyUnownedClassDispatchPropertiesChangedFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassDispatchPropertiesChanged
    attrSet = setInitiallyUnownedClassDispatchPropertiesChanged
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassDispatchPropertiesChanged
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassDispatchPropertiesChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.dispatchPropertiesChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:dispatchPropertiesChanged"
        })

initiallyUnownedClass_dispatchPropertiesChanged :: AttrLabelProxy "dispatchPropertiesChanged"
initiallyUnownedClass_dispatchPropertiesChanged = AttrLabelProxy

#endif


-- | Get the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #notify
-- @
getInitiallyUnownedClassNotify :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassNotifyFieldCallback)
getInitiallyUnownedClassNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassNotifyFieldCallback val'
        return val''
    return result

-- | Set the value of the “@notify@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #notify 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassNotify :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback -> m ()
setInitiallyUnownedClassNotify s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback)

-- | Set the value of the “@notify@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #notify
-- @
clearInitiallyUnownedClassNotify :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassNotify s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassNotifyFieldInfo
instance AttrInfo InitiallyUnownedClassNotifyFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassNotifyFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassNotifyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassNotifyFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassNotifyFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassNotifyFieldCallback
    type AttrTransferType InitiallyUnownedClassNotifyFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassNotifyFieldCallback)
    type AttrGetType InitiallyUnownedClassNotifyFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassNotifyFieldCallback
    type AttrLabel InitiallyUnownedClassNotifyFieldInfo = "notify"
    type AttrOrigin InitiallyUnownedClassNotifyFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassNotify
    attrSet = setInitiallyUnownedClassNotify
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassNotify
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassNotifyFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassNotifyFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.notify"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:notify"
        })

initiallyUnownedClass_notify :: AttrLabelProxy "notify"
initiallyUnownedClass_notify = AttrLabelProxy

#endif


-- | Get the value of the “@constructed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' initiallyUnownedClass #constructed
-- @
getInitiallyUnownedClassConstructed :: MonadIO m => InitiallyUnownedClass -> m (Maybe GObject.Callbacks.InitiallyUnownedClassConstructedFieldCallback)
getInitiallyUnownedClassConstructed s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO (FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GObject.Callbacks.dynamic_InitiallyUnownedClassConstructedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@constructed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' initiallyUnownedClass [ #constructed 'Data.GI.Base.Attributes.:=' value ]
-- @
setInitiallyUnownedClassConstructed :: MonadIO m => InitiallyUnownedClass -> FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback -> m ()
setInitiallyUnownedClassConstructed s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (val :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback)

-- | Set the value of the “@constructed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #constructed
-- @
clearInitiallyUnownedClassConstructed :: MonadIO m => InitiallyUnownedClass -> m ()
clearInitiallyUnownedClassConstructed s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (FP.nullFunPtr :: FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data InitiallyUnownedClassConstructedFieldInfo
instance AttrInfo InitiallyUnownedClassConstructedFieldInfo where
    type AttrBaseTypeConstraint InitiallyUnownedClassConstructedFieldInfo = (~) InitiallyUnownedClass
    type AttrAllowedOps InitiallyUnownedClassConstructedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InitiallyUnownedClassConstructedFieldInfo = (~) (FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback)
    type AttrTransferTypeConstraint InitiallyUnownedClassConstructedFieldInfo = (~)GObject.Callbacks.InitiallyUnownedClassConstructedFieldCallback
    type AttrTransferType InitiallyUnownedClassConstructedFieldInfo = (FunPtr GObject.Callbacks.C_InitiallyUnownedClassConstructedFieldCallback)
    type AttrGetType InitiallyUnownedClassConstructedFieldInfo = Maybe GObject.Callbacks.InitiallyUnownedClassConstructedFieldCallback
    type AttrLabel InitiallyUnownedClassConstructedFieldInfo = "constructed"
    type AttrOrigin InitiallyUnownedClassConstructedFieldInfo = InitiallyUnownedClass
    attrGet = getInitiallyUnownedClassConstructed
    attrSet = setInitiallyUnownedClassConstructed
    attrConstruct = undefined
    attrClear = clearInitiallyUnownedClassConstructed
    attrTransfer _ v = do
        GObject.Callbacks.mk_InitiallyUnownedClassConstructedFieldCallback (GObject.Callbacks.wrap_InitiallyUnownedClassConstructedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.InitiallyUnownedClass.constructed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.30/docs/GI-GObject-Structs-InitiallyUnownedClass.html#g:attr:constructed"
        })

initiallyUnownedClass_constructed :: AttrLabelProxy "constructed"
initiallyUnownedClass_constructed = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InitiallyUnownedClass
type instance O.AttributeList InitiallyUnownedClass = InitiallyUnownedClassAttributeList
type InitiallyUnownedClassAttributeList = ('[ '("gTypeClass", InitiallyUnownedClassGTypeClassFieldInfo), '("setProperty", InitiallyUnownedClassSetPropertyFieldInfo), '("getProperty", InitiallyUnownedClassGetPropertyFieldInfo), '("dispose", InitiallyUnownedClassDisposeFieldInfo), '("finalize", InitiallyUnownedClassFinalizeFieldInfo), '("dispatchPropertiesChanged", InitiallyUnownedClassDispatchPropertiesChangedFieldInfo), '("notify", InitiallyUnownedClassNotifyFieldInfo), '("constructed", InitiallyUnownedClassConstructedFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveInitiallyUnownedClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInitiallyUnownedClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInitiallyUnownedClassMethod t InitiallyUnownedClass, O.OverloadedMethod info InitiallyUnownedClass p) => OL.IsLabel t (InitiallyUnownedClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInitiallyUnownedClassMethod t InitiallyUnownedClass, O.OverloadedMethod info InitiallyUnownedClass p, R.HasField t InitiallyUnownedClass p) => R.HasField t InitiallyUnownedClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInitiallyUnownedClassMethod t InitiallyUnownedClass, O.OverloadedMethodInfo info InitiallyUnownedClass) => OL.IsLabel t (O.MethodProxy info InitiallyUnownedClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


