{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Unions.FloatIEEE754.FloatIEEE754' and t'GI.GLib.Unions.DoubleIEEE754.DoubleIEEE754' unions are used to access the sign,
-- mantissa and exponent of IEEE floats and doubles. These unions are defined
-- as appropriate for a given platform. IEEE floats and doubles are supported
-- (used for storage) by at least Intel, PPC and Sparc.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Unions.DoubleIEEE754
    ( 

-- * Exported types
    DoubleIEEE754(..)                       ,
    newZeroDoubleIEEE754                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveDoubleIEEE754Method              ,
#endif



 -- * Properties


-- ** vDouble #attr:vDouble#
-- | the double value

#if defined(ENABLE_OVERLOADING)
    doubleIEEE754_vDouble                   ,
#endif
    getDoubleIEEE754VDouble                 ,
    setDoubleIEEE754VDouble                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype DoubleIEEE754 = DoubleIEEE754 (SP.ManagedPtr DoubleIEEE754)
    deriving (Eq)

instance SP.ManagedPtrNewtype DoubleIEEE754 where
    toManagedPtr (DoubleIEEE754 p) = p

instance BoxedPtr DoubleIEEE754 where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr DoubleIEEE754)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr DoubleIEEE754 where
    boxedPtrCalloc = callocBytes 8


-- | Construct a `DoubleIEEE754` struct initialized to zero.
newZeroDoubleIEEE754 :: MonadIO m => m DoubleIEEE754
newZeroDoubleIEEE754 = liftIO $ boxedPtrCalloc >>= wrapPtr DoubleIEEE754

instance tag ~ 'AttrSet => Constructible DoubleIEEE754 tag where
    new _ attrs = do
        o <- newZeroDoubleIEEE754
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@v_double@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' doubleIEEE754 #vDouble
-- @
getDoubleIEEE754VDouble :: MonadIO m => DoubleIEEE754 -> m Double
getDoubleIEEE754VDouble s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 65535) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@v_double@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' doubleIEEE754 [ #vDouble 'Data.GI.Base.Attributes.:=' value ]
-- @
setDoubleIEEE754VDouble :: MonadIO m => DoubleIEEE754 -> Double -> m ()
setDoubleIEEE754VDouble s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 65535) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data DoubleIEEE754VDoubleFieldInfo
instance AttrInfo DoubleIEEE754VDoubleFieldInfo where
    type AttrBaseTypeConstraint DoubleIEEE754VDoubleFieldInfo = (~) DoubleIEEE754
    type AttrAllowedOps DoubleIEEE754VDoubleFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DoubleIEEE754VDoubleFieldInfo = (~) Double
    type AttrTransferTypeConstraint DoubleIEEE754VDoubleFieldInfo = (~)Double
    type AttrTransferType DoubleIEEE754VDoubleFieldInfo = Double
    type AttrGetType DoubleIEEE754VDoubleFieldInfo = Double
    type AttrLabel DoubleIEEE754VDoubleFieldInfo = "v_double"
    type AttrOrigin DoubleIEEE754VDoubleFieldInfo = DoubleIEEE754
    attrGet = getDoubleIEEE754VDouble
    attrSet = setDoubleIEEE754VDouble
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Unions.DoubleIEEE754.vDouble"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Unions-DoubleIEEE754.html#g:attr:vDouble"
        })

doubleIEEE754_vDouble :: AttrLabelProxy "vDouble"
doubleIEEE754_vDouble = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DoubleIEEE754
type instance O.AttributeList DoubleIEEE754 = DoubleIEEE754AttributeList
type DoubleIEEE754AttributeList = ('[ '("vDouble", DoubleIEEE754VDoubleFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDoubleIEEE754Method (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDoubleIEEE754Method l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDoubleIEEE754Method t DoubleIEEE754, O.OverloadedMethod info DoubleIEEE754 p) => OL.IsLabel t (DoubleIEEE754 -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDoubleIEEE754Method t DoubleIEEE754, O.OverloadedMethod info DoubleIEEE754 p, R.HasField t DoubleIEEE754 p) => R.HasField t DoubleIEEE754 p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDoubleIEEE754Method t DoubleIEEE754, O.OverloadedMethodInfo info DoubleIEEE754) => OL.IsLabel t (O.MethodProxy info DoubleIEEE754) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


