{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.Tuples.Tuples' struct is used to return records (or tuples) from the
-- t'GI.GLib.Structs.Relation.Relation' by @/g_relation_select()/@. It only contains one public
-- member - the number of records that matched. To access the matched
-- records, you must use 'GI.GLib.Structs.Tuples.tuplesIndex'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Tuples
    ( 

-- * Exported types
    Tuples(..)                              ,
    newZeroTuples                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [destroy]("GI.GLib.Structs.Tuples#g:method:destroy"), [index]("GI.GLib.Structs.Tuples#g:method:index").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTuplesMethod                     ,
#endif

-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    TuplesDestroyMethodInfo                 ,
#endif
    tuplesDestroy                           ,


-- ** index #method:index#

#if defined(ENABLE_OVERLOADING)
    TuplesIndexMethodInfo                   ,
#endif
    tuplesIndex                             ,




 -- * Properties


-- ** len #attr:len#
-- | the number of records that matched.

    getTuplesLen                            ,
    setTuplesLen                            ,
#if defined(ENABLE_OVERLOADING)
    tuples_len                              ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Tuples = Tuples (SP.ManagedPtr Tuples)
    deriving (Eq)

instance SP.ManagedPtrNewtype Tuples where
    toManagedPtr (Tuples p) = p

instance BoxedPtr Tuples where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 4 >=> B.ManagedPtr.wrapPtr Tuples)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Tuples where
    boxedPtrCalloc = callocBytes 4


-- | Construct a `Tuples` struct initialized to zero.
newZeroTuples :: MonadIO m => m Tuples
newZeroTuples = liftIO $ boxedPtrCalloc >>= wrapPtr Tuples

instance tag ~ 'AttrSet => Constructible Tuples tag where
    new _ attrs = do
        o <- newZeroTuples
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@len@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tuples #len
-- @
getTuplesLen :: MonadIO m => Tuples -> m Word32
getTuplesLen s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@len@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tuples [ #len 'Data.GI.Base.Attributes.:=' value ]
-- @
setTuplesLen :: MonadIO m => Tuples -> Word32 -> m ()
setTuplesLen s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TuplesLenFieldInfo
instance AttrInfo TuplesLenFieldInfo where
    type AttrBaseTypeConstraint TuplesLenFieldInfo = (~) Tuples
    type AttrAllowedOps TuplesLenFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TuplesLenFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TuplesLenFieldInfo = (~)Word32
    type AttrTransferType TuplesLenFieldInfo = Word32
    type AttrGetType TuplesLenFieldInfo = Word32
    type AttrLabel TuplesLenFieldInfo = "len"
    type AttrOrigin TuplesLenFieldInfo = Tuples
    attrGet = getTuplesLen
    attrSet = setTuplesLen
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tuples.len"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Tuples.html#g:attr:len"
        })

tuples_len :: AttrLabelProxy "len"
tuples_len = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Tuples
type instance O.AttributeList Tuples = TuplesAttributeList
type TuplesAttributeList = ('[ '("len", TuplesLenFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Tuples::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tuples"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Tuples" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the tuple data to free."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tuples_destroy" g_tuples_destroy :: 
    Ptr Tuples ->                           -- tuples : TInterface (Name {namespace = "GLib", name = "Tuples"})
    IO ()

{-# DEPRECATED tuplesDestroy ["(Since version 2.26)","Rarely used API"] #-}
-- | Frees the records which were returned by @/g_relation_select()/@. This
-- should always be called after @/g_relation_select()/@ when you are
-- finished with the records. The records are not removed from the
-- t'GI.GLib.Structs.Relation.Relation'.
tuplesDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tuples
    -- ^ /@tuples@/: the tuple data to free.
    -> m ()
tuplesDestroy tuples = liftIO $ do
    tuples' <- unsafeManagedPtrGetPtr tuples
    g_tuples_destroy tuples'
    touchManagedPtr tuples
    return ()

#if defined(ENABLE_OVERLOADING)
data TuplesDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TuplesDestroyMethodInfo Tuples signature where
    overloadedMethod = tuplesDestroy

instance O.OverloadedMethodInfo TuplesDestroyMethodInfo Tuples where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tuples.tuplesDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Tuples.html#v:tuplesDestroy"
        })


#endif

-- method Tuples::index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tuples"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Tuples" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the tuple data, returned by g_relation_select()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the record."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "field"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the field to return."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_tuples_index" g_tuples_index :: 
    Ptr Tuples ->                           -- tuples : TInterface (Name {namespace = "GLib", name = "Tuples"})
    Int32 ->                                -- index_ : TBasicType TInt
    Int32 ->                                -- field : TBasicType TInt
    IO (Ptr ())

{-# DEPRECATED tuplesIndex ["(Since version 2.26)","Rarely used API"] #-}
-- | Gets a field from the records returned by @/g_relation_select()/@. It
-- returns the given field of the record at the given index. The
-- returned value should not be changed.
tuplesIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Tuples
    -- ^ /@tuples@/: the tuple data, returned by @/g_relation_select()/@.
    -> Int32
    -- ^ /@index_@/: the index of the record.
    -> Int32
    -- ^ /@field@/: the field to return.
    -> m (Ptr ())
    -- ^ __Returns:__ the field of the record.
tuplesIndex tuples index_ field = liftIO $ do
    tuples' <- unsafeManagedPtrGetPtr tuples
    result <- g_tuples_index tuples' index_ field
    touchManagedPtr tuples
    return result

#if defined(ENABLE_OVERLOADING)
data TuplesIndexMethodInfo
instance (signature ~ (Int32 -> Int32 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod TuplesIndexMethodInfo Tuples signature where
    overloadedMethod = tuplesIndex

instance O.OverloadedMethodInfo TuplesIndexMethodInfo Tuples where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Tuples.tuplesIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Tuples.html#v:tuplesIndex"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTuplesMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTuplesMethod "destroy" o = TuplesDestroyMethodInfo
    ResolveTuplesMethod "index" o = TuplesIndexMethodInfo
    ResolveTuplesMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTuplesMethod t Tuples, O.OverloadedMethod info Tuples p) => OL.IsLabel t (Tuples -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTuplesMethod t Tuples, O.OverloadedMethod info Tuples p, R.HasField t Tuples p) => R.HasField t Tuples p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTuplesMethod t Tuples, O.OverloadedMethodInfo info Tuples) => OL.IsLabel t (O.MethodProxy info Tuples) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


