{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque structure representing a test suite.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TestSuite
    ( 

-- * Exported types
    TestSuite(..)                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [add]("GI.GLib.Structs.TestSuite#g:method:add"), [addSuite]("GI.GLib.Structs.TestSuite#g:method:addSuite"), [free]("GI.GLib.Structs.TestSuite#g:method:free").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTestSuiteMethod                  ,
#endif

-- ** add #method:add#

#if defined(ENABLE_OVERLOADING)
    TestSuiteAddMethodInfo                  ,
#endif
    testSuiteAdd                            ,


-- ** addSuite #method:addSuite#

#if defined(ENABLE_OVERLOADING)
    TestSuiteAddSuiteMethodInfo             ,
#endif
    testSuiteAddSuite                       ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    TestSuiteFreeMethodInfo                 ,
#endif
    testSuiteFree                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Structs.TestCase as GLib.TestCase

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.TestCase as GLib.TestCase

#endif

-- | Memory-managed wrapper type.
newtype TestSuite = TestSuite (SP.ManagedPtr TestSuite)
    deriving (Eq)

instance SP.ManagedPtrNewtype TestSuite where
    toManagedPtr (TestSuite p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TestSuite where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TestSuite
type instance O.AttributeList TestSuite = TestSuiteAttributeList
type TestSuiteAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TestSuite::add
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "suite"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestSuite" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test suite" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "test_case"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestCase" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test case" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_suite_add" g_test_suite_add :: 
    Ptr TestSuite ->                        -- suite : TInterface (Name {namespace = "GLib", name = "TestSuite"})
    Ptr GLib.TestCase.TestCase ->           -- test_case : TInterface (Name {namespace = "GLib", name = "TestCase"})
    IO ()

-- | Adds /@testCase@/ to /@suite@/.
-- 
-- /Since: 2.16/
testSuiteAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestSuite
    -- ^ /@suite@/: a test suite
    -> GLib.TestCase.TestCase
    -- ^ /@testCase@/: a test case
    -> m ()
testSuiteAdd suite testCase = liftIO $ do
    suite' <- unsafeManagedPtrGetPtr suite
    testCase' <- unsafeManagedPtrGetPtr testCase
    g_test_suite_add suite' testCase'
    touchManagedPtr suite
    touchManagedPtr testCase
    return ()

#if defined(ENABLE_OVERLOADING)
data TestSuiteAddMethodInfo
instance (signature ~ (GLib.TestCase.TestCase -> m ()), MonadIO m) => O.OverloadedMethod TestSuiteAddMethodInfo TestSuite signature where
    overloadedMethod = testSuiteAdd

instance O.OverloadedMethodInfo TestSuiteAddMethodInfo TestSuite where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestSuite.testSuiteAdd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestSuite.html#v:testSuiteAdd"
        })


#endif

-- method TestSuite::add_suite
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "suite"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestSuite" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test suite" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nestedsuite"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestSuite" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another test suite" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_suite_add_suite" g_test_suite_add_suite :: 
    Ptr TestSuite ->                        -- suite : TInterface (Name {namespace = "GLib", name = "TestSuite"})
    Ptr TestSuite ->                        -- nestedsuite : TInterface (Name {namespace = "GLib", name = "TestSuite"})
    IO ()

-- | Adds /@nestedsuite@/ to /@suite@/.
-- 
-- /Since: 2.16/
testSuiteAddSuite ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestSuite
    -- ^ /@suite@/: a test suite
    -> TestSuite
    -- ^ /@nestedsuite@/: another test suite
    -> m ()
testSuiteAddSuite suite nestedsuite = liftIO $ do
    suite' <- unsafeManagedPtrGetPtr suite
    nestedsuite' <- unsafeManagedPtrGetPtr nestedsuite
    g_test_suite_add_suite suite' nestedsuite'
    touchManagedPtr suite
    touchManagedPtr nestedsuite
    return ()

#if defined(ENABLE_OVERLOADING)
data TestSuiteAddSuiteMethodInfo
instance (signature ~ (TestSuite -> m ()), MonadIO m) => O.OverloadedMethod TestSuiteAddSuiteMethodInfo TestSuite signature where
    overloadedMethod = testSuiteAddSuite

instance O.OverloadedMethodInfo TestSuiteAddSuiteMethodInfo TestSuite where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestSuite.testSuiteAddSuite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestSuite.html#v:testSuiteAddSuite"
        })


#endif

-- method TestSuite::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "suite"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestSuite" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test suite" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_suite_free" g_test_suite_free :: 
    Ptr TestSuite ->                        -- suite : TInterface (Name {namespace = "GLib", name = "TestSuite"})
    IO ()

-- | Frees the /@suite@/ and all nested suites.
-- 
-- /Since: 2.70/
testSuiteFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestSuite
    -- ^ /@suite@/: a test suite
    -> m ()
testSuiteFree suite = liftIO $ do
    suite' <- unsafeManagedPtrGetPtr suite
    g_test_suite_free suite'
    touchManagedPtr suite
    return ()

#if defined(ENABLE_OVERLOADING)
data TestSuiteFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TestSuiteFreeMethodInfo TestSuite signature where
    overloadedMethod = testSuiteFree

instance O.OverloadedMethodInfo TestSuiteFreeMethodInfo TestSuite where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestSuite.testSuiteFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestSuite.html#v:testSuiteFree"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTestSuiteMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTestSuiteMethod "add" o = TestSuiteAddMethodInfo
    ResolveTestSuiteMethod "addSuite" o = TestSuiteAddSuiteMethodInfo
    ResolveTestSuiteMethod "free" o = TestSuiteFreeMethodInfo
    ResolveTestSuiteMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTestSuiteMethod t TestSuite, O.OverloadedMethod info TestSuite p) => OL.IsLabel t (TestSuite -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTestSuiteMethod t TestSuite, O.OverloadedMethod info TestSuite p, R.HasField t TestSuite p) => R.HasField t TestSuite p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTestSuiteMethod t TestSuite, O.OverloadedMethodInfo info TestSuite) => OL.IsLabel t (O.MethodProxy info TestSuite) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


