{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TestLogMsg
    ( 

-- * Exported types
    TestLogMsg(..)                          ,
    newZeroTestLogMsg                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.GLib.Structs.TestLogMsg#g:method:free").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTestLogMsgMethod                 ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    TestLogMsgFreeMethodInfo                ,
#endif
    testLogMsgFree                          ,




 -- * Properties


-- ** logType #attr:logType#
-- | /No description available in the introspection data./

    getTestLogMsgLogType                    ,
    setTestLogMsgLogType                    ,
#if defined(ENABLE_OVERLOADING)
    testLogMsg_logType                      ,
#endif


-- ** nNums #attr:nNums#
-- | /No description available in the introspection data./

    getTestLogMsgNNums                      ,
    setTestLogMsgNNums                      ,
#if defined(ENABLE_OVERLOADING)
    testLogMsg_nNums                        ,
#endif


-- ** nStrings #attr:nStrings#
-- | /No description available in the introspection data./

    getTestLogMsgNStrings                   ,
    setTestLogMsgNStrings                   ,
#if defined(ENABLE_OVERLOADING)
    testLogMsg_nStrings                     ,
#endif


-- ** strings #attr:strings#
-- | /No description available in the introspection data./

    clearTestLogMsgStrings                  ,
    getTestLogMsgStrings                    ,
    setTestLogMsgStrings                    ,
#if defined(ENABLE_OVERLOADING)
    testLogMsg_strings                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#else
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#endif

-- | Memory-managed wrapper type.
newtype TestLogMsg = TestLogMsg (SP.ManagedPtr TestLogMsg)
    deriving (Eq)

instance SP.ManagedPtrNewtype TestLogMsg where
    toManagedPtr (TestLogMsg p) = p

instance BoxedPtr TestLogMsg where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr TestLogMsg)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TestLogMsg where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `TestLogMsg` struct initialized to zero.
newZeroTestLogMsg :: MonadIO m => m TestLogMsg
newZeroTestLogMsg = liftIO $ boxedPtrCalloc >>= wrapPtr TestLogMsg

instance tag ~ 'AttrSet => Constructible TestLogMsg tag where
    new _ attrs = do
        o <- newZeroTestLogMsg
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@log_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testLogMsg #logType
-- @
getTestLogMsgLogType :: MonadIO m => TestLogMsg -> m GLib.Enums.TestLogType
getTestLogMsgLogType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@log_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testLogMsg [ #logType 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestLogMsgLogType :: MonadIO m => TestLogMsg -> GLib.Enums.TestLogType -> m ()
setTestLogMsgLogType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data TestLogMsgLogTypeFieldInfo
instance AttrInfo TestLogMsgLogTypeFieldInfo where
    type AttrBaseTypeConstraint TestLogMsgLogTypeFieldInfo = (~) TestLogMsg
    type AttrAllowedOps TestLogMsgLogTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestLogMsgLogTypeFieldInfo = (~) GLib.Enums.TestLogType
    type AttrTransferTypeConstraint TestLogMsgLogTypeFieldInfo = (~)GLib.Enums.TestLogType
    type AttrTransferType TestLogMsgLogTypeFieldInfo = GLib.Enums.TestLogType
    type AttrGetType TestLogMsgLogTypeFieldInfo = GLib.Enums.TestLogType
    type AttrLabel TestLogMsgLogTypeFieldInfo = "log_type"
    type AttrOrigin TestLogMsgLogTypeFieldInfo = TestLogMsg
    attrGet = getTestLogMsgLogType
    attrSet = setTestLogMsgLogType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogMsg.logType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestLogMsg.html#g:attr:logType"
        })

testLogMsg_logType :: AttrLabelProxy "logType"
testLogMsg_logType = AttrLabelProxy

#endif


-- | Get the value of the “@n_strings@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testLogMsg #nStrings
-- @
getTestLogMsgNStrings :: MonadIO m => TestLogMsg -> m Word32
getTestLogMsgNStrings s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@n_strings@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testLogMsg [ #nStrings 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestLogMsgNStrings :: MonadIO m => TestLogMsg -> Word32 -> m ()
setTestLogMsgNStrings s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TestLogMsgNStringsFieldInfo
instance AttrInfo TestLogMsgNStringsFieldInfo where
    type AttrBaseTypeConstraint TestLogMsgNStringsFieldInfo = (~) TestLogMsg
    type AttrAllowedOps TestLogMsgNStringsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestLogMsgNStringsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TestLogMsgNStringsFieldInfo = (~)Word32
    type AttrTransferType TestLogMsgNStringsFieldInfo = Word32
    type AttrGetType TestLogMsgNStringsFieldInfo = Word32
    type AttrLabel TestLogMsgNStringsFieldInfo = "n_strings"
    type AttrOrigin TestLogMsgNStringsFieldInfo = TestLogMsg
    attrGet = getTestLogMsgNStrings
    attrSet = setTestLogMsgNStrings
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogMsg.nStrings"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestLogMsg.html#g:attr:nStrings"
        })

testLogMsg_nStrings :: AttrLabelProxy "nStrings"
testLogMsg_nStrings = AttrLabelProxy

#endif


-- | Get the value of the “@strings@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testLogMsg #strings
-- @
getTestLogMsgStrings :: MonadIO m => TestLogMsg -> m (Maybe T.Text)
getTestLogMsgStrings s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@strings@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testLogMsg [ #strings 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestLogMsgStrings :: MonadIO m => TestLogMsg -> CString -> m ()
setTestLogMsgStrings s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@strings@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #strings
-- @
clearTestLogMsgStrings :: MonadIO m => TestLogMsg -> m ()
clearTestLogMsgStrings s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TestLogMsgStringsFieldInfo
instance AttrInfo TestLogMsgStringsFieldInfo where
    type AttrBaseTypeConstraint TestLogMsgStringsFieldInfo = (~) TestLogMsg
    type AttrAllowedOps TestLogMsgStringsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TestLogMsgStringsFieldInfo = (~) CString
    type AttrTransferTypeConstraint TestLogMsgStringsFieldInfo = (~)CString
    type AttrTransferType TestLogMsgStringsFieldInfo = CString
    type AttrGetType TestLogMsgStringsFieldInfo = Maybe T.Text
    type AttrLabel TestLogMsgStringsFieldInfo = "strings"
    type AttrOrigin TestLogMsgStringsFieldInfo = TestLogMsg
    attrGet = getTestLogMsgStrings
    attrSet = setTestLogMsgStrings
    attrConstruct = undefined
    attrClear = clearTestLogMsgStrings
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogMsg.strings"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestLogMsg.html#g:attr:strings"
        })

testLogMsg_strings :: AttrLabelProxy "strings"
testLogMsg_strings = AttrLabelProxy

#endif


-- | Get the value of the “@n_nums@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' testLogMsg #nNums
-- @
getTestLogMsgNNums :: MonadIO m => TestLogMsg -> m Word32
getTestLogMsgNNums s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@n_nums@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' testLogMsg [ #nNums 'Data.GI.Base.Attributes.:=' value ]
-- @
setTestLogMsgNNums :: MonadIO m => TestLogMsg -> Word32 -> m ()
setTestLogMsgNNums s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TestLogMsgNNumsFieldInfo
instance AttrInfo TestLogMsgNNumsFieldInfo where
    type AttrBaseTypeConstraint TestLogMsgNNumsFieldInfo = (~) TestLogMsg
    type AttrAllowedOps TestLogMsgNNumsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TestLogMsgNNumsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TestLogMsgNNumsFieldInfo = (~)Word32
    type AttrTransferType TestLogMsgNNumsFieldInfo = Word32
    type AttrGetType TestLogMsgNNumsFieldInfo = Word32
    type AttrLabel TestLogMsgNNumsFieldInfo = "n_nums"
    type AttrOrigin TestLogMsgNNumsFieldInfo = TestLogMsg
    attrGet = getTestLogMsgNNums
    attrSet = setTestLogMsgNNums
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogMsg.nNums"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestLogMsg.html#g:attr:nNums"
        })

testLogMsg_nNums :: AttrLabelProxy "nNums"
testLogMsg_nNums = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TestLogMsg
type instance O.AttributeList TestLogMsg = TestLogMsgAttributeList
type TestLogMsgAttributeList = ('[ '("logType", TestLogMsgLogTypeFieldInfo), '("nStrings", TestLogMsgNStringsFieldInfo), '("strings", TestLogMsgStringsFieldInfo), '("nNums", TestLogMsgNNumsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method TestLogMsg::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "tmsg"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestLogMsg" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_log_msg_free" g_test_log_msg_free :: 
    Ptr TestLogMsg ->                       -- tmsg : TInterface (Name {namespace = "GLib", name = "TestLogMsg"})
    IO ()

-- | Internal function for gtester to free test log messages, no ABI guarantees provided.
testLogMsgFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestLogMsg
    -> m ()
testLogMsgFree tmsg = liftIO $ do
    tmsg' <- unsafeManagedPtrGetPtr tmsg
    g_test_log_msg_free tmsg'
    touchManagedPtr tmsg
    return ()

#if defined(ENABLE_OVERLOADING)
data TestLogMsgFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TestLogMsgFreeMethodInfo TestLogMsg signature where
    overloadedMethod = testLogMsgFree

instance O.OverloadedMethodInfo TestLogMsgFreeMethodInfo TestLogMsg where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestLogMsg.testLogMsgFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestLogMsg.html#v:testLogMsgFree"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTestLogMsgMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTestLogMsgMethod "free" o = TestLogMsgFreeMethodInfo
    ResolveTestLogMsgMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTestLogMsgMethod t TestLogMsg, O.OverloadedMethod info TestLogMsg p) => OL.IsLabel t (TestLogMsg -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTestLogMsgMethod t TestLogMsg, O.OverloadedMethod info TestLogMsg p, R.HasField t TestLogMsg p) => R.HasField t TestLogMsg p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTestLogMsgMethod t TestLogMsg, O.OverloadedMethodInfo info TestLogMsg) => OL.IsLabel t (O.MethodProxy info TestLogMsg) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


