{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque structure representing a test case.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.TestCase
    ( 

-- * Exported types
    TestCase(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.GLib.Structs.TestCase#g:method:free").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTestCaseMethod                   ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    TestCaseFreeMethodInfo                  ,
#endif
    testCaseFree                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TestCase = TestCase (SP.ManagedPtr TestCase)
    deriving (Eq)

instance SP.ManagedPtrNewtype TestCase where
    toManagedPtr (TestCase p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TestCase where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TestCase
type instance O.AttributeList TestCase = TestCaseAttributeList
type TestCaseAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method TestCase::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "test_case"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TestCase" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a test case" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_test_case_free" g_test_case_free :: 
    Ptr TestCase ->                         -- test_case : TInterface (Name {namespace = "GLib", name = "TestCase"})
    IO ()

-- | Free the /@testCase@/.
-- 
-- /Since: 2.70/
testCaseFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    TestCase
    -- ^ /@testCase@/: a test case
    -> m ()
testCaseFree testCase = liftIO $ do
    testCase' <- unsafeManagedPtrGetPtr testCase
    g_test_case_free testCase'
    touchManagedPtr testCase
    return ()

#if defined(ENABLE_OVERLOADING)
data TestCaseFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod TestCaseFreeMethodInfo TestCase signature where
    overloadedMethod = testCaseFree

instance O.OverloadedMethodInfo TestCaseFreeMethodInfo TestCase where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.TestCase.testCaseFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-TestCase.html#v:testCaseFree"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTestCaseMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTestCaseMethod "free" o = TestCaseFreeMethodInfo
    ResolveTestCaseMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTestCaseMethod t TestCase, O.OverloadedMethod info TestCase p) => OL.IsLabel t (TestCase -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTestCaseMethod t TestCase, O.OverloadedMethod info TestCase p, R.HasField t TestCase p) => R.HasField t TestCase p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTestCaseMethod t TestCase, O.OverloadedMethodInfo info TestCase) => OL.IsLabel t (O.MethodProxy info TestCase) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


