{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GStrvBuilder@ is a helper object to build a 'P.Nothing'-terminated string arrays.
-- 
-- The following example shows how to build a two element array:
-- 
-- 
-- === /c code/
-- >  g_autoptr(GStrvBuilder) builder = g_strv_builder_new ();
-- >  g_strv_builder_add (builder, "hello");
-- >  g_strv_builder_add (builder, "world");
-- >
-- >  g_auto(GStrv) array = g_strv_builder_end (builder);
-- >
-- >  g_assert_true (g_strv_equal (array, (const char *[]) { "hello", "world", NULL }));
-- 
-- 
-- /Since: 2.68/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.StrvBuilder
    ( 

-- * Exported types
    StrvBuilder(..)                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [add]("GI.GLib.Structs.StrvBuilder#g:method:add"), [addv]("GI.GLib.Structs.StrvBuilder#g:method:addv"), [end]("GI.GLib.Structs.StrvBuilder#g:method:end"), [ref]("GI.GLib.Structs.StrvBuilder#g:method:ref"), [take]("GI.GLib.Structs.StrvBuilder#g:method:take"), [unref]("GI.GLib.Structs.StrvBuilder#g:method:unref"), [unrefToStrv]("GI.GLib.Structs.StrvBuilder#g:method:unrefToStrv").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveStrvBuilderMethod                ,
#endif

-- ** add #method:add#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderAddMethodInfo                ,
#endif
    strvBuilderAdd                          ,


-- ** addv #method:addv#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderAddvMethodInfo               ,
#endif
    strvBuilderAddv                         ,


-- ** end #method:end#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderEndMethodInfo                ,
#endif
    strvBuilderEnd                          ,


-- ** new #method:new#

    strvBuilderNew                          ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderRefMethodInfo                ,
#endif
    strvBuilderRef                          ,


-- ** take #method:take#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderTakeMethodInfo               ,
#endif
    strvBuilderTake                         ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderUnrefMethodInfo              ,
#endif
    strvBuilderUnref                        ,


-- ** unrefToStrv #method:unrefToStrv#

#if defined(ENABLE_OVERLOADING)
    StrvBuilderUnrefToStrvMethodInfo        ,
#endif
    strvBuilderUnrefToStrv                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype StrvBuilder = StrvBuilder (SP.ManagedPtr StrvBuilder)
    deriving (Eq)

instance SP.ManagedPtrNewtype StrvBuilder where
    toManagedPtr (StrvBuilder p) = p

foreign import ccall "g_strv_builder_get_type" c_g_strv_builder_get_type :: 
    IO GType

type instance O.ParentTypes StrvBuilder = '[]
instance O.HasParentTypes StrvBuilder

instance B.Types.TypedObject StrvBuilder where
    glibType = c_g_strv_builder_get_type

instance B.Types.GBoxed StrvBuilder

-- | Convert 'StrvBuilder' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StrvBuilder) where
    gvalueGType_ = c_g_strv_builder_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr StrvBuilder)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr StrvBuilder)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed StrvBuilder ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StrvBuilder
type instance O.AttributeList StrvBuilder = StrvBuilderAttributeList
type StrvBuilderAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method StrvBuilder::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "StrvBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_new" g_strv_builder_new :: 
    IO (Ptr StrvBuilder)

-- | Creates a new t'GI.GLib.Structs.StrvBuilder.StrvBuilder' with a reference count of 1.
-- Use 'GI.GLib.Structs.StrvBuilder.strvBuilderUnref' on the returned value when no longer needed.
-- 
-- /Since: 2.68/
strvBuilderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m StrvBuilder
    -- ^ __Returns:__ the new t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
strvBuilderNew  = liftIO $ do
    result <- g_strv_builder_new
    checkUnexpectedReturnNULL "strvBuilderNew" result
    result' <- (wrapBoxed StrvBuilder) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method StrvBuilder::add
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_add" g_strv_builder_add :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    CString ->                              -- value : TBasicType TUTF8
    IO ()

-- | Add a string to the end of the array.
-- 
-- Since 2.68
strvBuilderAdd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> T.Text
    -- ^ /@value@/: a string.
    -> m ()
strvBuilderAdd builder value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- textToCString value
    g_strv_builder_add builder' value'
    touchManagedPtr builder
    freeMem value'
    return ()

#if defined(ENABLE_OVERLOADING)
data StrvBuilderAddMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod StrvBuilderAddMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderAdd

instance O.OverloadedMethodInfo StrvBuilderAddMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderAdd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderAdd"
        })


#endif

-- method StrvBuilder::addv
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vector of strings to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_addv" g_strv_builder_addv :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    Ptr CString ->                          -- value : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Appends all the strings in the given vector to the builder.
-- 
-- Since 2.70
strvBuilderAddv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> [T.Text]
    -- ^ /@value@/: the vector of strings to add
    -> m ()
strvBuilderAddv builder value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- packZeroTerminatedUTF8CArray value
    g_strv_builder_addv builder' value'
    touchManagedPtr builder
    mapZeroTerminatedCArray freeMem value'
    freeMem value'
    return ()

#if defined(ENABLE_OVERLOADING)
data StrvBuilderAddvMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m) => O.OverloadedMethod StrvBuilderAddvMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderAddv

instance O.OverloadedMethodInfo StrvBuilderAddvMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderAddv",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderAddv"
        })


#endif

-- method StrvBuilder::end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_end" g_strv_builder_end :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    IO (Ptr CString)

-- | Ends the builder process and returns the constructed NULL-terminated string
-- array. The returned value should be freed with 'GI.GLib.Functions.strfreev' when no longer
-- needed.
strvBuilderEnd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> m [T.Text]
    -- ^ __Returns:__ the constructed string array.
    -- 
    -- Since 2.68
strvBuilderEnd builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- g_strv_builder_end builder'
    checkUnexpectedReturnNULL "strvBuilderEnd" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data StrvBuilderEndMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m) => O.OverloadedMethod StrvBuilderEndMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderEnd

instance O.OverloadedMethodInfo StrvBuilderEndMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderEnd"
        })


#endif

-- method StrvBuilder::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "StrvBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_ref" g_strv_builder_ref :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    IO (Ptr StrvBuilder)

-- | Atomically increments the reference count of /@builder@/ by one.
-- This function is thread-safe and may be called from any thread.
-- 
-- /Since: 2.68/
strvBuilderRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> m StrvBuilder
    -- ^ __Returns:__ The passed in t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
strvBuilderRef builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- g_strv_builder_ref builder'
    checkUnexpectedReturnNULL "strvBuilderRef" result
    result' <- (wrapBoxed StrvBuilder) result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data StrvBuilderRefMethodInfo
instance (signature ~ (m StrvBuilder), MonadIO m) => O.OverloadedMethod StrvBuilderRefMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderRef

instance O.OverloadedMethodInfo StrvBuilderRefMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderRef"
        })


#endif

-- method StrvBuilder::take
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string.\n    Ownership of the string is transferred to the #GStrvBuilder"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_take" g_strv_builder_take :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    CString ->                              -- value : TBasicType TUTF8
    IO ()

-- | Add a string to the end of the array. After /@value@/ belongs to the
-- t'GI.GLib.Structs.StrvBuilder.StrvBuilder' and may no longer be modified by the caller.
-- 
-- Since 2.80
strvBuilderTake ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> T.Text
    -- ^ /@value@/: a string.
    --     Ownership of the string is transferred to the t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> m ()
strvBuilderTake builder value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- textToCString value
    g_strv_builder_take builder' value'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data StrvBuilderTakeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod StrvBuilderTakeMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderTake

instance O.OverloadedMethodInfo StrvBuilderTakeMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderTake",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderTake"
        })


#endif

-- method StrvBuilder::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GStrvBuilder allocated by g_strv_builder_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_unref" g_strv_builder_unref :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    IO ()

-- | Decreases the reference count on /@builder@/.
-- 
-- In the event that there are no more references, releases all memory
-- associated with the t'GI.GLib.Structs.StrvBuilder.StrvBuilder'.
-- 
-- /Since: 2.68/
strvBuilderUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder' allocated by 'GI.GLib.Structs.StrvBuilder.strvBuilderNew'
    -> m ()
strvBuilderUnref builder = liftIO $ do
    builder' <- B.ManagedPtr.disownBoxed builder
    g_strv_builder_unref builder'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data StrvBuilderUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod StrvBuilderUnrefMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderUnref

instance O.OverloadedMethodInfo StrvBuilderUnrefMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderUnref"
        })


#endif

-- method StrvBuilder::unref_to_strv
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "StrvBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GStrvBuilder" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_strv_builder_unref_to_strv" g_strv_builder_unref_to_strv :: 
    Ptr StrvBuilder ->                      -- builder : TInterface (Name {namespace = "GLib", name = "StrvBuilder"})
    IO (Ptr CString)

-- | Decreases the reference count on the string vector builder, and returns
-- its contents as a @NULL@-terminated string array.
-- 
-- This function is especially useful for cases where it\'s not possible
-- to use @g_autoptr()@.
-- 
-- 
-- === /c code/
-- >GStrvBuilder *builder = g_strv_builder_new ();
-- >g_strv_builder_add (builder, "hello");
-- >g_strv_builder_add (builder, "world");
-- >
-- >GStrv array = g_strv_builder_unref_to_strv (builder);
-- >
-- >g_assert_true (g_strv_equal (array, (const char *[]) { "hello", "world", NULL }));
-- >
-- >g_strfreev (array);
-- 
-- 
-- /Since: 2.82/
strvBuilderUnrefToStrv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StrvBuilder
    -- ^ /@builder@/: a t'GI.GLib.Structs.StrvBuilder.StrvBuilder'
    -> m [T.Text]
    -- ^ __Returns:__ the constructed string
    --   array
strvBuilderUnrefToStrv builder = liftIO $ do
    builder' <- B.ManagedPtr.disownBoxed builder
    result <- g_strv_builder_unref_to_strv builder'
    checkUnexpectedReturnNULL "strvBuilderUnrefToStrv" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data StrvBuilderUnrefToStrvMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m) => O.OverloadedMethod StrvBuilderUnrefToStrvMethodInfo StrvBuilder signature where
    overloadedMethod = strvBuilderUnrefToStrv

instance O.OverloadedMethodInfo StrvBuilderUnrefToStrvMethodInfo StrvBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.StrvBuilder.strvBuilderUnrefToStrv",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-StrvBuilder.html#v:strvBuilderUnrefToStrv"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveStrvBuilderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStrvBuilderMethod "add" o = StrvBuilderAddMethodInfo
    ResolveStrvBuilderMethod "addv" o = StrvBuilderAddvMethodInfo
    ResolveStrvBuilderMethod "end" o = StrvBuilderEndMethodInfo
    ResolveStrvBuilderMethod "ref" o = StrvBuilderRefMethodInfo
    ResolveStrvBuilderMethod "take" o = StrvBuilderTakeMethodInfo
    ResolveStrvBuilderMethod "unref" o = StrvBuilderUnrefMethodInfo
    ResolveStrvBuilderMethod "unrefToStrv" o = StrvBuilderUnrefToStrvMethodInfo
    ResolveStrvBuilderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStrvBuilderMethod t StrvBuilder, O.OverloadedMethod info StrvBuilder p) => OL.IsLabel t (StrvBuilder -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStrvBuilderMethod t StrvBuilder, O.OverloadedMethod info StrvBuilder p, R.HasField t StrvBuilder p) => R.HasField t StrvBuilder p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStrvBuilderMethod t StrvBuilder, O.OverloadedMethodInfo info StrvBuilder) => OL.IsLabel t (O.MethodProxy info StrvBuilder) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


