{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GSourceCallbackFuncs@ struct contains
-- functions for managing callback objects.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.SourceCallbackFuncs
    ( 

-- * Exported types
    SourceCallbackFuncs(..)                 ,
    newZeroSourceCallbackFuncs              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSourceCallbackFuncsMethod        ,
#endif



 -- * Properties


-- ** ref #attr:ref#
-- | Called when a reference is added to the callback object

    clearSourceCallbackFuncsRef             ,
    getSourceCallbackFuncsRef               ,
    setSourceCallbackFuncsRef               ,
#if defined(ENABLE_OVERLOADING)
    sourceCallbackFuncs_ref                 ,
#endif


-- ** unref #attr:unref#
-- | Called when a reference to the callback object is dropped

    clearSourceCallbackFuncsUnref           ,
    getSourceCallbackFuncsUnref             ,
    setSourceCallbackFuncsUnref             ,
#if defined(ENABLE_OVERLOADING)
    sourceCallbackFuncs_unref               ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype SourceCallbackFuncs = SourceCallbackFuncs (SP.ManagedPtr SourceCallbackFuncs)
    deriving (Eq)

instance SP.ManagedPtrNewtype SourceCallbackFuncs where
    toManagedPtr (SourceCallbackFuncs p) = p

instance BoxedPtr SourceCallbackFuncs where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr SourceCallbackFuncs)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr SourceCallbackFuncs where
    boxedPtrCalloc = callocBytes 24


-- | Construct a `SourceCallbackFuncs` struct initialized to zero.
newZeroSourceCallbackFuncs :: MonadIO m => m SourceCallbackFuncs
newZeroSourceCallbackFuncs = liftIO $ boxedPtrCalloc >>= wrapPtr SourceCallbackFuncs

instance tag ~ 'AttrSet => Constructible SourceCallbackFuncs tag where
    new _ attrs = do
        o <- newZeroSourceCallbackFuncs
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sourceCallbackFuncs #ref
-- @
getSourceCallbackFuncsRef :: MonadIO m => SourceCallbackFuncs -> m (Maybe GLib.Callbacks.SourceCallbackFuncsRefFieldCallback_WithClosures)
getSourceCallbackFuncsRef s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_SourceCallbackFuncsRefFieldCallback val'
        return val''
    return result

-- | Set the value of the “@ref@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' sourceCallbackFuncs [ #ref 'Data.GI.Base.Attributes.:=' value ]
-- @
setSourceCallbackFuncsRef :: MonadIO m => SourceCallbackFuncs -> FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback -> m ()
setSourceCallbackFuncsRef s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback)

-- | Set the value of the “@ref@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ref
-- @
clearSourceCallbackFuncsRef :: MonadIO m => SourceCallbackFuncs -> m ()
clearSourceCallbackFuncsRef s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SourceCallbackFuncsRefFieldInfo
instance AttrInfo SourceCallbackFuncsRefFieldInfo where
    type AttrBaseTypeConstraint SourceCallbackFuncsRefFieldInfo = (~) SourceCallbackFuncs
    type AttrAllowedOps SourceCallbackFuncsRefFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SourceCallbackFuncsRefFieldInfo = (~) (FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback)
    type AttrTransferTypeConstraint SourceCallbackFuncsRefFieldInfo = (~)GLib.Callbacks.SourceCallbackFuncsRefFieldCallback_WithClosures
    type AttrTransferType SourceCallbackFuncsRefFieldInfo = (FunPtr GLib.Callbacks.C_SourceCallbackFuncsRefFieldCallback)
    type AttrGetType SourceCallbackFuncsRefFieldInfo = Maybe GLib.Callbacks.SourceCallbackFuncsRefFieldCallback_WithClosures
    type AttrLabel SourceCallbackFuncsRefFieldInfo = "ref"
    type AttrOrigin SourceCallbackFuncsRefFieldInfo = SourceCallbackFuncs
    attrGet = getSourceCallbackFuncsRef
    attrSet = setSourceCallbackFuncsRef
    attrConstruct = undefined
    attrClear = clearSourceCallbackFuncsRef
    attrTransfer _ v = do
        GLib.Callbacks.mk_SourceCallbackFuncsRefFieldCallback (GLib.Callbacks.wrap_SourceCallbackFuncsRefFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SourceCallbackFuncs.ref"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SourceCallbackFuncs.html#g:attr:ref"
        })

sourceCallbackFuncs_ref :: AttrLabelProxy "ref"
sourceCallbackFuncs_ref = AttrLabelProxy

#endif


-- | Get the value of the “@unref@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sourceCallbackFuncs #unref
-- @
getSourceCallbackFuncsUnref :: MonadIO m => SourceCallbackFuncs -> m (Maybe GLib.Callbacks.SourceCallbackFuncsUnrefFieldCallback_WithClosures)
getSourceCallbackFuncsUnref s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_SourceCallbackFuncsUnrefFieldCallback val'
        return val''
    return result

-- | Set the value of the “@unref@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' sourceCallbackFuncs [ #unref 'Data.GI.Base.Attributes.:=' value ]
-- @
setSourceCallbackFuncsUnref :: MonadIO m => SourceCallbackFuncs -> FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback -> m ()
setSourceCallbackFuncsUnref s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback)

-- | Set the value of the “@unref@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #unref
-- @
clearSourceCallbackFuncsUnref :: MonadIO m => SourceCallbackFuncs -> m ()
clearSourceCallbackFuncsUnref s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SourceCallbackFuncsUnrefFieldInfo
instance AttrInfo SourceCallbackFuncsUnrefFieldInfo where
    type AttrBaseTypeConstraint SourceCallbackFuncsUnrefFieldInfo = (~) SourceCallbackFuncs
    type AttrAllowedOps SourceCallbackFuncsUnrefFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SourceCallbackFuncsUnrefFieldInfo = (~) (FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback)
    type AttrTransferTypeConstraint SourceCallbackFuncsUnrefFieldInfo = (~)GLib.Callbacks.SourceCallbackFuncsUnrefFieldCallback_WithClosures
    type AttrTransferType SourceCallbackFuncsUnrefFieldInfo = (FunPtr GLib.Callbacks.C_SourceCallbackFuncsUnrefFieldCallback)
    type AttrGetType SourceCallbackFuncsUnrefFieldInfo = Maybe GLib.Callbacks.SourceCallbackFuncsUnrefFieldCallback_WithClosures
    type AttrLabel SourceCallbackFuncsUnrefFieldInfo = "unref"
    type AttrOrigin SourceCallbackFuncsUnrefFieldInfo = SourceCallbackFuncs
    attrGet = getSourceCallbackFuncsUnref
    attrSet = setSourceCallbackFuncsUnref
    attrConstruct = undefined
    attrClear = clearSourceCallbackFuncsUnref
    attrTransfer _ v = do
        GLib.Callbacks.mk_SourceCallbackFuncsUnrefFieldCallback (GLib.Callbacks.wrap_SourceCallbackFuncsUnrefFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SourceCallbackFuncs.unref"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SourceCallbackFuncs.html#g:attr:unref"
        })

sourceCallbackFuncs_unref :: AttrLabelProxy "unref"
sourceCallbackFuncs_unref = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SourceCallbackFuncs
type instance O.AttributeList SourceCallbackFuncs = SourceCallbackFuncsAttributeList
type SourceCallbackFuncsAttributeList = ('[ '("ref", SourceCallbackFuncsRefFieldInfo), '("unref", SourceCallbackFuncsUnrefFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSourceCallbackFuncsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSourceCallbackFuncsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSourceCallbackFuncsMethod t SourceCallbackFuncs, O.OverloadedMethod info SourceCallbackFuncs p) => OL.IsLabel t (SourceCallbackFuncs -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSourceCallbackFuncsMethod t SourceCallbackFuncs, O.OverloadedMethod info SourceCallbackFuncs p, R.HasField t SourceCallbackFuncs p) => R.HasField t SourceCallbackFuncs p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSourceCallbackFuncsMethod t SourceCallbackFuncs, O.OverloadedMethodInfo info SourceCallbackFuncs) => OL.IsLabel t (O.MethodProxy info SourceCallbackFuncs) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


