{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.SequenceIter.SequenceIter' struct is an opaque data type representing an
-- iterator pointing into a t'GI.GLib.Structs.Sequence.Sequence'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.SequenceIter
    ( 

-- * Exported types
    SequenceIter(..)                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [compare]("GI.GLib.Structs.SequenceIter#g:method:compare"), [isBegin]("GI.GLib.Structs.SequenceIter#g:method:isBegin"), [isEnd]("GI.GLib.Structs.SequenceIter#g:method:isEnd"), [move]("GI.GLib.Structs.SequenceIter#g:method:move"), [next]("GI.GLib.Structs.SequenceIter#g:method:next"), [prev]("GI.GLib.Structs.SequenceIter#g:method:prev").
-- 
-- ==== Getters
-- [getPosition]("GI.GLib.Structs.SequenceIter#g:method:getPosition"), [getSequence]("GI.GLib.Structs.SequenceIter#g:method:getSequence").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSequenceIterMethod               ,
#endif

-- ** compare #method:compare#

#if defined(ENABLE_OVERLOADING)
    SequenceIterCompareMethodInfo           ,
#endif
    sequenceIterCompare                     ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    SequenceIterGetPositionMethodInfo       ,
#endif
    sequenceIterGetPosition                 ,


-- ** getSequence #method:getSequence#

#if defined(ENABLE_OVERLOADING)
    SequenceIterGetSequenceMethodInfo       ,
#endif
    sequenceIterGetSequence                 ,


-- ** isBegin #method:isBegin#

#if defined(ENABLE_OVERLOADING)
    SequenceIterIsBeginMethodInfo           ,
#endif
    sequenceIterIsBegin                     ,


-- ** isEnd #method:isEnd#

#if defined(ENABLE_OVERLOADING)
    SequenceIterIsEndMethodInfo             ,
#endif
    sequenceIterIsEnd                       ,


-- ** move #method:move#

#if defined(ENABLE_OVERLOADING)
    SequenceIterMoveMethodInfo              ,
#endif
    sequenceIterMove                        ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    SequenceIterNextMethodInfo              ,
#endif
    sequenceIterNext                        ,


-- ** prev #method:prev#

#if defined(ENABLE_OVERLOADING)
    SequenceIterPrevMethodInfo              ,
#endif
    sequenceIterPrev                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.Sequence as GLib.Sequence

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.Sequence as GLib.Sequence

#endif

-- | Memory-managed wrapper type.
newtype SequenceIter = SequenceIter (SP.ManagedPtr SequenceIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype SequenceIter where
    toManagedPtr (SequenceIter p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr SequenceIter where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SequenceIter
type instance O.AttributeList SequenceIter = SequenceIterAttributeList
type SequenceIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method SequenceIter::compare
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_compare" g_sequence_iter_compare :: 
    Ptr SequenceIter ->                     -- a : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr SequenceIter ->                     -- b : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO Int32

-- | Returns a negative number if /@a@/ comes before /@b@/, 0 if they are equal,
-- and a positive number if /@a@/ comes after /@b@/.
-- 
-- The /@a@/ and /@b@/ iterators must point into the same sequence.
-- 
-- /Since: 2.14/
sequenceIterCompare ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@a@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> SequenceIter
    -- ^ /@b@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m Int32
    -- ^ __Returns:__ a negative number if /@a@/ comes before /@b@/, 0 if they are
    --     equal, and a positive number if /@a@/ comes after /@b@/
sequenceIterCompare a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- g_sequence_iter_compare a' b'
    touchManagedPtr a
    touchManagedPtr b
    return result

#if defined(ENABLE_OVERLOADING)
data SequenceIterCompareMethodInfo
instance (signature ~ (SequenceIter -> m Int32), MonadIO m) => O.OverloadedMethod SequenceIterCompareMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterCompare

instance O.OverloadedMethodInfo SequenceIterCompareMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterCompare",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterCompare"
        })


#endif

-- method SequenceIter::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_get_position" g_sequence_iter_get_position :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO Int32

-- | Returns the position of /@iter@/
-- 
-- /Since: 2.14/
sequenceIterGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m Int32
    -- ^ __Returns:__ the position of /@iter@/
sequenceIterGetPosition iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_get_position iter'
    touchManagedPtr iter
    return result

#if defined(ENABLE_OVERLOADING)
data SequenceIterGetPositionMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod SequenceIterGetPositionMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterGetPosition

instance O.OverloadedMethodInfo SequenceIterGetPositionMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterGetPosition"
        })


#endif

-- method SequenceIter::get_sequence
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Sequence" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_get_sequence" g_sequence_iter_get_sequence :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO (Ptr GLib.Sequence.Sequence)

-- | Returns the t'GI.GLib.Structs.Sequence.Sequence' that /@iter@/ points into.
-- 
-- /Since: 2.14/
sequenceIterGetSequence ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m GLib.Sequence.Sequence
    -- ^ __Returns:__ the t'GI.GLib.Structs.Sequence.Sequence' that /@iter@/ points into
sequenceIterGetSequence iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_get_sequence iter'
    checkUnexpectedReturnNULL "sequenceIterGetSequence" result
    result' <- (newPtr GLib.Sequence.Sequence) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterGetSequenceMethodInfo
instance (signature ~ (m GLib.Sequence.Sequence), MonadIO m) => O.OverloadedMethod SequenceIterGetSequenceMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterGetSequence

instance O.OverloadedMethodInfo SequenceIterGetSequenceMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterGetSequence",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterGetSequence"
        })


#endif

-- method SequenceIter::is_begin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_is_begin" g_sequence_iter_is_begin :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO CInt

-- | Returns whether /@iter@/ is the begin iterator
-- 
-- /Since: 2.14/
sequenceIterIsBegin ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m Bool
    -- ^ __Returns:__ whether /@iter@/ is the begin iterator
sequenceIterIsBegin iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_is_begin iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterIsBeginMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SequenceIterIsBeginMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterIsBegin

instance O.OverloadedMethodInfo SequenceIterIsBeginMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterIsBegin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterIsBegin"
        })


#endif

-- method SequenceIter::is_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_is_end" g_sequence_iter_is_end :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO CInt

-- | Returns whether /@iter@/ is the end iterator
-- 
-- /Since: 2.14/
sequenceIterIsEnd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m Bool
    -- ^ __Returns:__ Whether /@iter@/ is the end iterator
sequenceIterIsEnd iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_is_end iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterIsEndMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SequenceIterIsEndMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterIsEnd

instance O.OverloadedMethodInfo SequenceIterIsEndMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterIsEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterIsEnd"
        })


#endif

-- method SequenceIter::move
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delta"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A positive or negative number indicating how many positions away\n   from @iter the returned #GSequenceIter will be"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_move" g_sequence_iter_move :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Int32 ->                                -- delta : TBasicType TInt
    IO (Ptr SequenceIter)

-- | Returns the t'GI.GLib.Structs.SequenceIter.SequenceIter' which is /@delta@/ positions away from /@iter@/.
-- If /@iter@/ is closer than -/@delta@/ positions to the beginning of the sequence,
-- the begin iterator is returned. If /@iter@/ is closer than /@delta@/ positions
-- to the end of the sequence, the end iterator is returned.
-- 
-- /Since: 2.14/
sequenceIterMove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> Int32
    -- ^ /@delta@/: A positive or negative number indicating how many positions away
    --    from /@iter@/ the returned t'GI.GLib.Structs.SequenceIter.SequenceIter' will be
    -> m SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' which is /@delta@/ positions away from /@iter@/
sequenceIterMove iter delta = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_move iter' delta
    checkUnexpectedReturnNULL "sequenceIterMove" result
    result' <- (newPtr SequenceIter) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterMoveMethodInfo
instance (signature ~ (Int32 -> m SequenceIter), MonadIO m) => O.OverloadedMethod SequenceIterMoveMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterMove

instance O.OverloadedMethodInfo SequenceIterMoveMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterMove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterMove"
        })


#endif

-- method SequenceIter::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_next" g_sequence_iter_next :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO (Ptr SequenceIter)

-- | Returns an iterator pointing to the next position after /@iter@/.
-- If /@iter@/ is the end iterator, the end iterator is returned.
-- 
-- /Since: 2.14/
sequenceIterNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the next position after /@iter@/
sequenceIterNext iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_next iter'
    checkUnexpectedReturnNULL "sequenceIterNext" result
    result' <- (newPtr SequenceIter) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterNextMethodInfo
instance (signature ~ (m SequenceIter), MonadIO m) => O.OverloadedMethod SequenceIterNextMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterNext

instance O.OverloadedMethodInfo SequenceIterNextMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterNext"
        })


#endif

-- method SequenceIter::prev
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_iter_prev" g_sequence_iter_prev :: 
    Ptr SequenceIter ->                     -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO (Ptr SequenceIter)

-- | Returns an iterator pointing to the previous position before /@iter@/.
-- If /@iter@/ is the begin iterator, the begin iterator is returned.
-- 
-- /Since: 2.14/
sequenceIterPrev ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the previous position
    --     before /@iter@/
sequenceIterPrev iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_iter_prev iter'
    checkUnexpectedReturnNULL "sequenceIterPrev" result
    result' <- (newPtr SequenceIter) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIterPrevMethodInfo
instance (signature ~ (m SequenceIter), MonadIO m) => O.OverloadedMethod SequenceIterPrevMethodInfo SequenceIter signature where
    overloadedMethod = sequenceIterPrev

instance O.OverloadedMethodInfo SequenceIterPrevMethodInfo SequenceIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.SequenceIter.sequenceIterPrev",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-SequenceIter.html#v:sequenceIterPrev"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSequenceIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSequenceIterMethod "compare" o = SequenceIterCompareMethodInfo
    ResolveSequenceIterMethod "isBegin" o = SequenceIterIsBeginMethodInfo
    ResolveSequenceIterMethod "isEnd" o = SequenceIterIsEndMethodInfo
    ResolveSequenceIterMethod "move" o = SequenceIterMoveMethodInfo
    ResolveSequenceIterMethod "next" o = SequenceIterNextMethodInfo
    ResolveSequenceIterMethod "prev" o = SequenceIterPrevMethodInfo
    ResolveSequenceIterMethod "getPosition" o = SequenceIterGetPositionMethodInfo
    ResolveSequenceIterMethod "getSequence" o = SequenceIterGetSequenceMethodInfo
    ResolveSequenceIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSequenceIterMethod t SequenceIter, O.OverloadedMethod info SequenceIter p) => OL.IsLabel t (SequenceIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSequenceIterMethod t SequenceIter, O.OverloadedMethod info SequenceIter p, R.HasField t SequenceIter p) => R.HasField t SequenceIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSequenceIterMethod t SequenceIter, O.OverloadedMethodInfo info SequenceIter) => OL.IsLabel t (O.MethodProxy info SequenceIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


