{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.Sequence.Sequence' struct is an opaque data type representing a
-- <http://developer.gnome.org/glib/stable/data-structures.html#scalable-lists sequence> data type.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Sequence
    ( 

-- * Exported types
    Sequence(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.GLib.Structs.Sequence#g:method:append"), [foreach]("GI.GLib.Structs.Sequence#g:method:foreach"), [free]("GI.GLib.Structs.Sequence#g:method:free"), [insertSorted]("GI.GLib.Structs.Sequence#g:method:insertSorted"), [insertSortedIter]("GI.GLib.Structs.Sequence#g:method:insertSortedIter"), [isEmpty]("GI.GLib.Structs.Sequence#g:method:isEmpty"), [lookup]("GI.GLib.Structs.Sequence#g:method:lookup"), [lookupIter]("GI.GLib.Structs.Sequence#g:method:lookupIter"), [prepend]("GI.GLib.Structs.Sequence#g:method:prepend"), [search]("GI.GLib.Structs.Sequence#g:method:search"), [searchIter]("GI.GLib.Structs.Sequence#g:method:searchIter"), [sort]("GI.GLib.Structs.Sequence#g:method:sort"), [sortIter]("GI.GLib.Structs.Sequence#g:method:sortIter").
-- 
-- ==== Getters
-- [getBeginIter]("GI.GLib.Structs.Sequence#g:method:getBeginIter"), [getEndIter]("GI.GLib.Structs.Sequence#g:method:getEndIter"), [getIterAtPos]("GI.GLib.Structs.Sequence#g:method:getIterAtPos"), [getLength]("GI.GLib.Structs.Sequence#g:method:getLength").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSequenceMethod                   ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    SequenceAppendMethodInfo                ,
#endif
    sequenceAppend                          ,


-- ** foreach #method:foreach#

#if defined(ENABLE_OVERLOADING)
    SequenceForeachMethodInfo               ,
#endif
    sequenceForeach                         ,


-- ** foreachRange #method:foreachRange#

    sequenceForeachRange                    ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    SequenceFreeMethodInfo                  ,
#endif
    sequenceFree                            ,


-- ** get #method:get#

    sequenceGet                             ,


-- ** getBeginIter #method:getBeginIter#

#if defined(ENABLE_OVERLOADING)
    SequenceGetBeginIterMethodInfo          ,
#endif
    sequenceGetBeginIter                    ,


-- ** getEndIter #method:getEndIter#

#if defined(ENABLE_OVERLOADING)
    SequenceGetEndIterMethodInfo            ,
#endif
    sequenceGetEndIter                      ,


-- ** getIterAtPos #method:getIterAtPos#

#if defined(ENABLE_OVERLOADING)
    SequenceGetIterAtPosMethodInfo          ,
#endif
    sequenceGetIterAtPos                    ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    SequenceGetLengthMethodInfo             ,
#endif
    sequenceGetLength                       ,


-- ** insertBefore #method:insertBefore#

    sequenceInsertBefore                    ,


-- ** insertSorted #method:insertSorted#

#if defined(ENABLE_OVERLOADING)
    SequenceInsertSortedMethodInfo          ,
#endif
    sequenceInsertSorted                    ,


-- ** insertSortedIter #method:insertSortedIter#

#if defined(ENABLE_OVERLOADING)
    SequenceInsertSortedIterMethodInfo      ,
#endif
    sequenceInsertSortedIter                ,


-- ** isEmpty #method:isEmpty#

#if defined(ENABLE_OVERLOADING)
    SequenceIsEmptyMethodInfo               ,
#endif
    sequenceIsEmpty                         ,


-- ** lookup #method:lookup#

#if defined(ENABLE_OVERLOADING)
    SequenceLookupMethodInfo                ,
#endif
    sequenceLookup                          ,


-- ** lookupIter #method:lookupIter#

#if defined(ENABLE_OVERLOADING)
    SequenceLookupIterMethodInfo            ,
#endif
    sequenceLookupIter                      ,


-- ** move #method:move#

    sequenceMove                            ,


-- ** moveRange #method:moveRange#

    sequenceMoveRange                       ,


-- ** prepend #method:prepend#

#if defined(ENABLE_OVERLOADING)
    SequencePrependMethodInfo               ,
#endif
    sequencePrepend                         ,


-- ** rangeGetMidpoint #method:rangeGetMidpoint#

    sequenceRangeGetMidpoint                ,


-- ** remove #method:remove#

    sequenceRemove                          ,


-- ** removeRange #method:removeRange#

    sequenceRemoveRange                     ,


-- ** search #method:search#

#if defined(ENABLE_OVERLOADING)
    SequenceSearchMethodInfo                ,
#endif
    sequenceSearch                          ,


-- ** searchIter #method:searchIter#

#if defined(ENABLE_OVERLOADING)
    SequenceSearchIterMethodInfo            ,
#endif
    sequenceSearchIter                      ,


-- ** set #method:set#

    sequenceSet                             ,


-- ** sort #method:sort#

#if defined(ENABLE_OVERLOADING)
    SequenceSortMethodInfo                  ,
#endif
    sequenceSort                            ,


-- ** sortChanged #method:sortChanged#

    sequenceSortChanged                     ,


-- ** sortChangedIter #method:sortChangedIter#

    sequenceSortChangedIter                 ,


-- ** sortIter #method:sortIter#

#if defined(ENABLE_OVERLOADING)
    SequenceSortIterMethodInfo              ,
#endif
    sequenceSortIter                        ,


-- ** swap #method:swap#

    sequenceSwap                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.SequenceIter as GLib.SequenceIter

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.SequenceIter as GLib.SequenceIter

#endif

-- | Memory-managed wrapper type.
newtype Sequence = Sequence (SP.ManagedPtr Sequence)
    deriving (Eq)

instance SP.ManagedPtrNewtype Sequence where
    toManagedPtr (Sequence p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr Sequence where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Sequence
type instance O.AttributeList Sequence = SequenceAttributeList
type SequenceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Sequence::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_append" g_sequence_append :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Adds a new item to the end of /@seq@/.
-- 
-- /Since: 2.14/
sequenceAppend ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: the data for the new item
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ an iterator pointing to the new item
sequenceAppend seq data_ = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_append seq' data_
    checkUnexpectedReturnNULL "sequenceAppend" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceAppendMethodInfo
instance (signature ~ (Ptr () -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceAppendMethodInfo Sequence signature where
    overloadedMethod = sequenceAppend

instance O.OverloadedMethodInfo SequenceAppendMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceAppend"
        })


#endif

-- method Sequence::foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TInterface Name { namespace = "GLib" , name = "Func" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each item in @seq"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_foreach" g_sequence_foreach :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    FunPtr GLib.Callbacks.C_Func ->         -- func : TInterface (Name {namespace = "GLib", name = "Func"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Calls /@func@/ for each item in the sequence passing /@userData@/
-- to the function. /@func@/ must not modify the sequence itself.
-- 
-- /Since: 2.14/
sequenceForeach ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> GLib.Callbacks.Func
    -- ^ /@func@/: the function to call for each item in /@seq@/
    -> m ()
sequenceForeach seq func = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    func' <- GLib.Callbacks.mk_Func (GLib.Callbacks.wrap_Func Nothing (GLib.Callbacks.drop_closures_Func func))
    let userData = nullPtr
    g_sequence_foreach seq' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr seq
    return ()

#if defined(ENABLE_OVERLOADING)
data SequenceForeachMethodInfo
instance (signature ~ (GLib.Callbacks.Func -> m ()), MonadIO m) => O.OverloadedMethod SequenceForeachMethodInfo Sequence signature where
    overloadedMethod = sequenceForeach

instance O.OverloadedMethodInfo SequenceForeachMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceForeach"
        })


#endif

-- method Sequence::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_free" g_sequence_free :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    IO ()

-- | Frees the memory allocated for /@seq@/. If /@seq@/ has a data destroy
-- function associated with it, that function is called on all items
-- in /@seq@/.
-- 
-- /Since: 2.14/
sequenceFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> m ()
sequenceFree seq = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    g_sequence_free seq'
    touchManagedPtr seq
    return ()

#if defined(ENABLE_OVERLOADING)
data SequenceFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SequenceFreeMethodInfo Sequence signature where
    overloadedMethod = sequenceFree

instance O.OverloadedMethodInfo SequenceFreeMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceFree"
        })


#endif

-- method Sequence::get_begin_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_get_begin_iter" g_sequence_get_begin_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Returns the begin iterator for /@seq@/.
-- 
-- /Since: 2.14/
sequenceGetBeginIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ the begin iterator for /@seq@/.
sequenceGetBeginIter seq = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_get_begin_iter seq'
    checkUnexpectedReturnNULL "sequenceGetBeginIter" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceGetBeginIterMethodInfo
instance (signature ~ (m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceGetBeginIterMethodInfo Sequence signature where
    overloadedMethod = sequenceGetBeginIter

instance O.OverloadedMethodInfo SequenceGetBeginIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceGetBeginIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceGetBeginIter"
        })


#endif

-- method Sequence::get_end_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_get_end_iter" g_sequence_get_end_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Returns the end iterator for /@seg@/
-- 
-- /Since: 2.14/
sequenceGetEndIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ the end iterator for /@seq@/
sequenceGetEndIter seq = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_get_end_iter seq'
    checkUnexpectedReturnNULL "sequenceGetEndIter" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceGetEndIterMethodInfo
instance (signature ~ (m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceGetEndIterMethodInfo Sequence signature where
    overloadedMethod = sequenceGetEndIter

instance O.OverloadedMethodInfo SequenceGetEndIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceGetEndIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceGetEndIter"
        })


#endif

-- method Sequence::get_iter_at_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a position in @seq, or -1 for the end"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_get_iter_at_pos" g_sequence_get_iter_at_pos :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Int32 ->                                -- pos : TBasicType TInt
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Returns the iterator at position /@pos@/. If /@pos@/ is negative or larger
-- than the number of items in /@seq@/, the end iterator is returned.
-- 
-- /Since: 2.14/
sequenceGetIterAtPos ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Int32
    -- ^ /@pos@/: a position in /@seq@/, or -1 for the end
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ The t'GI.GLib.Structs.SequenceIter.SequenceIter' at position /@pos@/
sequenceGetIterAtPos seq pos = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_get_iter_at_pos seq' pos
    checkUnexpectedReturnNULL "sequenceGetIterAtPos" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceGetIterAtPosMethodInfo
instance (signature ~ (Int32 -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceGetIterAtPosMethodInfo Sequence signature where
    overloadedMethod = sequenceGetIterAtPos

instance O.OverloadedMethodInfo SequenceGetIterAtPosMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceGetIterAtPos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceGetIterAtPos"
        })


#endif

-- method Sequence::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_get_length" g_sequence_get_length :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    IO Int32

-- | Returns the positive length (>= 0) of /@seq@/. Note that this method is
-- O(h) where \`h\' is the height of the tree. It is thus more efficient
-- to use 'GI.GLib.Structs.Sequence.sequenceIsEmpty' when comparing the length to zero.
-- 
-- /Since: 2.14/
sequenceGetLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> m Int32
    -- ^ __Returns:__ the length of /@seq@/
sequenceGetLength seq = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_get_length seq'
    touchManagedPtr seq
    return result

#if defined(ENABLE_OVERLOADING)
data SequenceGetLengthMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod SequenceGetLengthMethodInfo Sequence signature where
    overloadedMethod = sequenceGetLength

instance O.OverloadedMethodInfo SequenceGetLengthMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceGetLength"
        })


#endif

-- method Sequence::insert_sorted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to insert" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare items in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_insert_sorted" g_sequence_insert_sorted :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Inserts /@data@/ into /@seq@/ using /@cmpFunc@/ to determine the new
-- position. The sequence must already be sorted according to /@cmpFunc@/;
-- otherwise the new position of /@data@/ is undefined.
-- 
-- /@cmpFunc@/ is called with two items of the /@seq@/, and /@cmpData@/.
-- It should return 0 if the items are equal, a negative value
-- if the first item comes before the second, and a positive value
-- if the second item comes before the first.
-- 
-- Note that when adding a large amount of data to a t'GI.GLib.Structs.Sequence.Sequence',
-- it is more efficient to do unsorted insertions and then call
-- 'GI.GLib.Structs.Sequence.sequenceSort' or 'GI.GLib.Structs.Sequence.sequenceSortIter'.
-- 
-- /Since: 2.14/
sequenceInsertSorted ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: the data to insert
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@cmpFunc@/: the function used to compare items in the sequence
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the new item.
sequenceInsertSorted seq data_ cmpFunc = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    cmpFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc cmpFunc))
    let cmpData = nullPtr
    result <- g_sequence_insert_sorted seq' data_ cmpFunc' cmpData
    checkUnexpectedReturnNULL "sequenceInsertSorted" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceInsertSortedMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceInsertSortedMethodInfo Sequence signature where
    overloadedMethod = sequenceInsertSorted

instance O.OverloadedMethodInfo SequenceInsertSortedMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceInsertSorted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceInsertSorted"
        })


#endif

-- method Sequence::insert_sorted_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter_cmp"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SequenceIterCompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare iterators in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @iter_cmp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_insert_sorted_iter" g_sequence_insert_sorted_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_SequenceIterCompareFunc -> -- iter_cmp : TInterface (Name {namespace = "GLib", name = "SequenceIterCompareFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Like 'GI.GLib.Structs.Sequence.sequenceInsertSorted', but uses
-- a t'GI.GLib.Callbacks.SequenceIterCompareFunc' instead of a t'GI.GLib.Callbacks.CompareDataFunc' as
-- the compare function.
-- 
-- /@iterCmp@/ is called with two iterators pointing into /@seq@/.
-- It should return 0 if the iterators are equal, a negative
-- value if the first iterator comes before the second, and a
-- positive value if the second iterator comes before the first.
-- 
-- Note that when adding a large amount of data to a t'GI.GLib.Structs.Sequence.Sequence',
-- it is more efficient to do unsorted insertions and then call
-- 'GI.GLib.Structs.Sequence.sequenceSort' or 'GI.GLib.Structs.Sequence.sequenceSortIter'.
-- 
-- /Since: 2.14/
sequenceInsertSortedIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: data for the new item
    -> GLib.Callbacks.SequenceIterCompareFunc
    -- ^ /@iterCmp@/: the function used to compare iterators in the sequence
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the new item
sequenceInsertSortedIter seq data_ iterCmp = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    iterCmp' <- GLib.Callbacks.mk_SequenceIterCompareFunc (GLib.Callbacks.wrap_SequenceIterCompareFunc Nothing (GLib.Callbacks.drop_closures_SequenceIterCompareFunc iterCmp))
    let cmpData = nullPtr
    result <- g_sequence_insert_sorted_iter seq' data_ iterCmp' cmpData
    checkUnexpectedReturnNULL "sequenceInsertSortedIter" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    safeFreeFunPtr $ castFunPtrToPtr iterCmp'
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceInsertSortedIterMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.SequenceIterCompareFunc -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceInsertSortedIterMethodInfo Sequence signature where
    overloadedMethod = sequenceInsertSortedIter

instance O.OverloadedMethodInfo SequenceInsertSortedIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceInsertSortedIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceInsertSortedIter"
        })


#endif

-- method Sequence::is_empty
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_is_empty" g_sequence_is_empty :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    IO CInt

-- | Returns 'P.True' if the sequence contains zero items.
-- 
-- This function is functionally identical to checking the result of
-- 'GI.GLib.Structs.Sequence.sequenceGetLength' being equal to zero. However this function is
-- implemented in O(1) running time.
-- 
-- /Since: 2.48/
sequenceIsEmpty ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the sequence is empty, otherwise 'P.False'.
sequenceIsEmpty seq = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_is_empty seq'
    let result' = (/= 0) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceIsEmptyMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod SequenceIsEmptyMethodInfo Sequence signature where
    overloadedMethod = sequenceIsEmpty

instance O.OverloadedMethodInfo SequenceIsEmptyMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceIsEmpty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceIsEmpty"
        })


#endif

-- method Sequence::lookup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to look up" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare items in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_lookup" g_sequence_lookup :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Returns an iterator pointing to the position of the first item found
-- equal to /@data@/ according to /@cmpFunc@/ and /@cmpData@/. If more than one
-- item is equal, it is not guaranteed that it is the first which is
-- returned. In that case, you can use 'GI.GLib.Structs.SequenceIter.sequenceIterNext' and
-- 'GI.GLib.Structs.SequenceIter.sequenceIterPrev' to get others.
-- 
-- /@cmpFunc@/ is called with two items of the /@seq@/, and /@cmpData@/.
-- It should return 0 if the items are equal, a negative value if
-- the first item comes before the second, and a positive value if
-- the second item comes before the first.
-- 
-- This function will fail if the data contained in the sequence is
-- unsorted.
-- 
-- /Since: 2.28/
sequenceLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: data to look up
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@cmpFunc@/: the function used to compare items in the sequence
    -> m (Maybe GLib.SequenceIter.SequenceIter)
    -- ^ __Returns:__ an t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the position of the
    --     first item found equal to /@data@/ according to /@cmpFunc@/ and
    --     /@cmpData@/, or 'P.Nothing' if no such item exists
sequenceLookup seq data_ cmpFunc = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    cmpFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc cmpFunc))
    let cmpData = nullPtr
    result <- g_sequence_lookup seq' data_ cmpFunc' cmpData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.SequenceIter.SequenceIter) result'
        return result''
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr seq
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SequenceLookupMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m (Maybe GLib.SequenceIter.SequenceIter)), MonadIO m) => O.OverloadedMethod SequenceLookupMethodInfo Sequence signature where
    overloadedMethod = sequenceLookup

instance O.OverloadedMethodInfo SequenceLookupMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceLookup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceLookup"
        })


#endif

-- method Sequence::lookup_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to look up" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter_cmp"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SequenceIterCompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare iterators in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @iter_cmp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_lookup_iter" g_sequence_lookup_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_SequenceIterCompareFunc -> -- iter_cmp : TInterface (Name {namespace = "GLib", name = "SequenceIterCompareFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Like 'GI.GLib.Structs.Sequence.sequenceLookup', but uses a t'GI.GLib.Callbacks.SequenceIterCompareFunc'
-- instead of a t'GI.GLib.Callbacks.CompareDataFunc' as the compare function.
-- 
-- /@iterCmp@/ is called with two iterators pointing into /@seq@/.
-- It should return 0 if the iterators are equal, a negative value
-- if the first iterator comes before the second, and a positive
-- value if the second iterator comes before the first.
-- 
-- This function will fail if the data contained in the sequence is
-- unsorted.
-- 
-- /Since: 2.28/
sequenceLookupIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: data to look up
    -> GLib.Callbacks.SequenceIterCompareFunc
    -- ^ /@iterCmp@/: the function used to compare iterators in the sequence
    -> m (Maybe GLib.SequenceIter.SequenceIter)
    -- ^ __Returns:__ an t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the position of
    --     the first item found equal to /@data@/ according to /@iterCmp@/
    --     and /@cmpData@/, or 'P.Nothing' if no such item exists
sequenceLookupIter seq data_ iterCmp = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    iterCmp' <- GLib.Callbacks.mk_SequenceIterCompareFunc (GLib.Callbacks.wrap_SequenceIterCompareFunc Nothing (GLib.Callbacks.drop_closures_SequenceIterCompareFunc iterCmp))
    let cmpData = nullPtr
    result <- g_sequence_lookup_iter seq' data_ iterCmp' cmpData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr GLib.SequenceIter.SequenceIter) result'
        return result''
    safeFreeFunPtr $ castFunPtrToPtr iterCmp'
    touchManagedPtr seq
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SequenceLookupIterMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.SequenceIterCompareFunc -> m (Maybe GLib.SequenceIter.SequenceIter)), MonadIO m) => O.OverloadedMethod SequenceLookupIterMethodInfo Sequence signature where
    overloadedMethod = sequenceLookupIter

instance O.OverloadedMethodInfo SequenceLookupIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceLookupIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceLookupIter"
        })


#endif

-- method Sequence::prepend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_prepend" g_sequence_prepend :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Adds a new item to the front of /@seq@/
-- 
-- /Since: 2.14/
sequencePrepend ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: the data for the new item
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ an iterator pointing to the new item
sequencePrepend seq data_ = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    result <- g_sequence_prepend seq' data_
    checkUnexpectedReturnNULL "sequencePrepend" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequencePrependMethodInfo
instance (signature ~ (Ptr () -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequencePrependMethodInfo Sequence signature where
    overloadedMethod = sequencePrepend

instance O.OverloadedMethodInfo SequencePrependMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequencePrepend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequencePrepend"
        })


#endif

-- method Sequence::search
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare items in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_search" g_sequence_search :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Returns an iterator pointing to the position where /@data@/ would
-- be inserted according to /@cmpFunc@/ and /@cmpData@/.
-- 
-- /@cmpFunc@/ is called with two items of the /@seq@/, and /@cmpData@/.
-- It should return 0 if the items are equal, a negative value if
-- the first item comes before the second, and a positive value if
-- the second item comes before the first.
-- 
-- If you are simply searching for an existing element of the sequence,
-- consider using 'GI.GLib.Structs.Sequence.sequenceLookup'.
-- 
-- This function will fail if the data contained in the sequence is
-- unsorted.
-- 
-- /Since: 2.14/
sequenceSearch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: data for the new item
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@cmpFunc@/: the function used to compare items in the sequence
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ an t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the position where /@data@/
    --     would have been inserted according to /@cmpFunc@/ and /@cmpData@/
sequenceSearch seq data_ cmpFunc = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    cmpFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc cmpFunc))
    let cmpData = nullPtr
    result <- g_sequence_search seq' data_ cmpFunc' cmpData
    checkUnexpectedReturnNULL "sequenceSearch" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceSearchMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceSearchMethodInfo Sequence signature where
    overloadedMethod = sequenceSearch

instance O.OverloadedMethodInfo SequenceSearchMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceSearch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceSearch"
        })


#endif

-- method Sequence::search_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter_cmp"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SequenceIterCompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare iterators in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @iter_cmp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_search_iter" g_sequence_search_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_SequenceIterCompareFunc -> -- iter_cmp : TInterface (Name {namespace = "GLib", name = "SequenceIterCompareFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Like 'GI.GLib.Structs.Sequence.sequenceSearch', but uses a t'GI.GLib.Callbacks.SequenceIterCompareFunc'
-- instead of a t'GI.GLib.Callbacks.CompareDataFunc' as the compare function.
-- 
-- /@iterCmp@/ is called with two iterators pointing into /@seq@/.
-- It should return 0 if the iterators are equal, a negative value
-- if the first iterator comes before the second, and a positive
-- value if the second iterator comes before the first.
-- 
-- If you are simply searching for an existing element of the sequence,
-- consider using 'GI.GLib.Structs.Sequence.sequenceLookupIter'.
-- 
-- This function will fail if the data contained in the sequence is
-- unsorted.
-- 
-- /Since: 2.14/
sequenceSearchIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> Ptr ()
    -- ^ /@data@/: data for the new item
    -> GLib.Callbacks.SequenceIterCompareFunc
    -- ^ /@iterCmp@/: the function used to compare iterators in the sequence
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the position in /@seq@/
    --     where /@data@/ would have been inserted according to /@iterCmp@/
    --     and /@cmpData@/
sequenceSearchIter seq data_ iterCmp = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    iterCmp' <- GLib.Callbacks.mk_SequenceIterCompareFunc (GLib.Callbacks.wrap_SequenceIterCompareFunc Nothing (GLib.Callbacks.drop_closures_SequenceIterCompareFunc iterCmp))
    let cmpData = nullPtr
    result <- g_sequence_search_iter seq' data_ iterCmp' cmpData
    checkUnexpectedReturnNULL "sequenceSearchIter" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    safeFreeFunPtr $ castFunPtrToPtr iterCmp'
    touchManagedPtr seq
    return result'

#if defined(ENABLE_OVERLOADING)
data SequenceSearchIterMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.SequenceIterCompareFunc -> m GLib.SequenceIter.SequenceIter), MonadIO m) => O.OverloadedMethod SequenceSearchIterMethodInfo Sequence signature where
    overloadedMethod = sequenceSearchIter

instance O.OverloadedMethodInfo SequenceSearchIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceSearchIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceSearchIter"
        })


#endif

-- method Sequence::sort
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function used to sort the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_sort" g_sequence_sort :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO ()

-- | Sorts /@seq@/ using /@cmpFunc@/.
-- 
-- /@cmpFunc@/ is passed two items of /@seq@/ and should
-- return 0 if they are equal, a negative value if the
-- first comes before the second, and a positive value
-- if the second comes before the first.
-- 
-- /Since: 2.14/
sequenceSort ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@cmpFunc@/: the function used to sort the sequence
    -> m ()
sequenceSort seq cmpFunc = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    cmpFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc cmpFunc))
    let cmpData = nullPtr
    g_sequence_sort seq' cmpFunc' cmpData
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr seq
    return ()

#if defined(ENABLE_OVERLOADING)
data SequenceSortMethodInfo
instance (signature ~ (GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod SequenceSortMethodInfo Sequence signature where
    overloadedMethod = sequenceSort

instance O.OverloadedMethodInfo SequenceSortMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceSort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceSort"
        })


#endif

-- method Sequence::sort_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "seq"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Sequence" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequence" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SequenceIterCompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare iterators in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_sort_iter" g_sequence_sort_iter :: 
    Ptr Sequence ->                         -- seq : TInterface (Name {namespace = "GLib", name = "Sequence"})
    FunPtr GLib.Callbacks.C_SequenceIterCompareFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "SequenceIterCompareFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO ()

-- | Like 'GI.GLib.Structs.Sequence.sequenceSort', but uses a t'GI.GLib.Callbacks.SequenceIterCompareFunc' instead
-- of a t'GI.GLib.Callbacks.CompareDataFunc' as the compare function
-- 
-- /@cmpFunc@/ is called with two iterators pointing into /@seq@/. It should
-- return 0 if the iterators are equal, a negative value if the first
-- iterator comes before the second, and a positive value if the second
-- iterator comes before the first.
-- 
-- /Since: 2.14/
sequenceSortIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Sequence
    -- ^ /@seq@/: a t'GI.GLib.Structs.Sequence.Sequence'
    -> GLib.Callbacks.SequenceIterCompareFunc
    -- ^ /@cmpFunc@/: the function used to compare iterators in the sequence
    -> m ()
sequenceSortIter seq cmpFunc = liftIO $ do
    seq' <- unsafeManagedPtrGetPtr seq
    cmpFunc' <- GLib.Callbacks.mk_SequenceIterCompareFunc (GLib.Callbacks.wrap_SequenceIterCompareFunc Nothing (GLib.Callbacks.drop_closures_SequenceIterCompareFunc cmpFunc))
    let cmpData = nullPtr
    g_sequence_sort_iter seq' cmpFunc' cmpData
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr seq
    return ()

#if defined(ENABLE_OVERLOADING)
data SequenceSortIterMethodInfo
instance (signature ~ (GLib.Callbacks.SequenceIterCompareFunc -> m ()), MonadIO m) => O.OverloadedMethod SequenceSortIterMethodInfo Sequence signature where
    overloadedMethod = sequenceSortIter

instance O.OverloadedMethodInfo SequenceSortIterMethodInfo Sequence where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Sequence.sequenceSortIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Sequence.html#v:sequenceSortIter"
        })


#endif

-- method Sequence::foreach_range
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "begin"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TInterface Name { namespace = "GLib" , name = "Func" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFunc" , sinceVersion = Nothing }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_foreach_range" g_sequence_foreach_range :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- begin : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- end : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    FunPtr GLib.Callbacks.C_Func ->         -- func : TInterface (Name {namespace = "GLib", name = "Func"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Calls /@func@/ for each item in the range (/@begin@/, /@end@/) passing
-- /@userData@/ to the function. /@func@/ must not modify the sequence
-- itself.
-- 
-- /Since: 2.14/
sequenceForeachRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@begin@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@end@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.Callbacks.Func
    -- ^ /@func@/: a t'GI.GLib.Callbacks.Func'
    -> m ()
sequenceForeachRange begin end func = liftIO $ do
    begin' <- unsafeManagedPtrGetPtr begin
    end' <- unsafeManagedPtrGetPtr end
    func' <- GLib.Callbacks.mk_Func (GLib.Callbacks.wrap_Func Nothing (GLib.Callbacks.drop_closures_Func func))
    let userData = nullPtr
    g_sequence_foreach_range begin' end' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr begin
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::get
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_get" g_sequence_get :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO (Ptr ())

-- | Returns the data that /@iter@/ points to.
-- 
-- /Since: 2.14/
sequenceGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m (Ptr ())
    -- ^ __Returns:__ the data that /@iter@/ points to
sequenceGet iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_get iter'
    touchManagedPtr iter
    return result

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::insert_before
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data for the new item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_insert_before" g_sequence_insert_before :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Inserts a new item just before the item pointed to by /@iter@/.
-- 
-- /Since: 2.14/
sequenceInsertBefore ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> Ptr ()
    -- ^ /@data@/: the data for the new item
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ an iterator pointing to the new item
sequenceInsertBefore iter data_ = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- g_sequence_insert_before iter' data_
    checkUnexpectedReturnNULL "sequenceInsertBefore" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::move
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter pointing to the item to move"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GSequenceIter pointing to the position to which\n    the item is moved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_move" g_sequence_move :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- src : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- dest : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO ()

-- | Moves the item pointed to by /@src@/ to the position indicated by /@dest@/.
-- After calling this function /@dest@/ will point to the position immediately
-- after /@src@/. It is allowed for /@src@/ and /@dest@/ to point into different
-- sequences.
-- 
-- /Since: 2.14/
sequenceMove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@src@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the item to move
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@dest@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing to the position to which
    --     the item is moved
    -> m ()
sequenceMove src dest = liftIO $ do
    src' <- unsafeManagedPtrGetPtr src
    dest' <- unsafeManagedPtrGetPtr dest
    g_sequence_move src' dest'
    touchManagedPtr src
    touchManagedPtr dest
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::move_range
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "dest"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "begin"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_move_range" g_sequence_move_range :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- dest : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- begin : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- end : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO ()

-- | Inserts the (/@begin@/, /@end@/) range at the destination pointed to by /@dest@/.
-- The /@begin@/ and /@end@/ iters must point into the same sequence. It is
-- allowed for /@dest@/ to point to a different sequence than the one pointed
-- into by /@begin@/ and /@end@/.
-- 
-- If /@dest@/ is 'P.Nothing', the range indicated by /@begin@/ and /@end@/ is
-- removed from the sequence. If /@dest@/ points to a place within
-- the (/@begin@/, /@end@/) range, the range does not move.
-- 
-- /Since: 2.14/
sequenceMoveRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@dest@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@begin@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@end@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m ()
sequenceMoveRange dest begin end = liftIO $ do
    dest' <- unsafeManagedPtrGetPtr dest
    begin' <- unsafeManagedPtrGetPtr begin
    end' <- unsafeManagedPtrGetPtr end
    g_sequence_move_range dest' begin' end'
    touchManagedPtr dest
    touchManagedPtr begin
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::range_get_midpoint
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "begin"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "SequenceIter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_range_get_midpoint" g_sequence_range_get_midpoint :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- begin : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- end : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO (Ptr GLib.SequenceIter.SequenceIter)

-- | Finds an iterator somewhere in the range (/@begin@/, /@end@/). This
-- iterator will be close to the middle of the range, but is not
-- guaranteed to be exactly in the middle.
-- 
-- The /@begin@/ and /@end@/ iterators must both point to the same sequence
-- and /@begin@/ must come before or be equal to /@end@/ in the sequence.
-- 
-- /Since: 2.14/
sequenceRangeGetMidpoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@begin@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@end@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m GLib.SequenceIter.SequenceIter
    -- ^ __Returns:__ a t'GI.GLib.Structs.SequenceIter.SequenceIter' pointing somewhere in the
    --    (/@begin@/, /@end@/) range
sequenceRangeGetMidpoint begin end = liftIO $ do
    begin' <- unsafeManagedPtrGetPtr begin
    end' <- unsafeManagedPtrGetPtr end
    result <- g_sequence_range_get_midpoint begin' end'
    checkUnexpectedReturnNULL "sequenceRangeGetMidpoint" result
    result' <- (newPtr GLib.SequenceIter.SequenceIter) result
    touchManagedPtr begin
    touchManagedPtr end
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::remove
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_remove" g_sequence_remove :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO ()

-- | Removes the item pointed to by /@iter@/. It is an error to pass the
-- end iterator to this function.
-- 
-- If the sequence has a data destroy function associated with it, this
-- function is called on the data for the removed item.
-- 
-- /Since: 2.14/
sequenceRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m ()
sequenceRemove iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    g_sequence_remove iter'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::remove_range
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "begin"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_remove_range" g_sequence_remove_range :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- begin : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- end : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO ()

-- | Removes all items in the (/@begin@/, /@end@/) range.
-- 
-- If the sequence has a data destroy function associated with it, this
-- function is called on the data for the removed items.
-- 
-- /Since: 2.14/
sequenceRemoveRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@begin@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@end@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m ()
sequenceRemoveRange begin end = liftIO $ do
    begin' <- unsafeManagedPtrGetPtr begin
    end' <- unsafeManagedPtrGetPtr end
    g_sequence_remove_range begin' end'
    touchManagedPtr begin
    touchManagedPtr end
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::set
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new data for the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_set" g_sequence_set :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Changes the data for the item pointed to by /@iter@/ to be /@data@/. If
-- the sequence has a data destroy function associated with it, that
-- function is called on the existing data that /@iter@/ pointed to.
-- 
-- /Since: 2.14/
sequenceSet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> Ptr ()
    -- ^ /@data@/: new data for the item
    -> m ()
sequenceSet iter data_ = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    g_sequence_set iter' data_
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::sort_changed
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare items in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_sort_changed" g_sequence_sort_changed :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- cmp_func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO ()

-- | Moves the data pointed to by /@iter@/ to a new position as indicated by
-- /@cmpFunc@/. This
-- function should be called for items in a sequence already sorted according
-- to /@cmpFunc@/ whenever some aspect of an item changes so that /@cmpFunc@/
-- may return different values for that item.
-- 
-- /@cmpFunc@/ is called with two items of the /@seq@/, and /@cmpData@/.
-- It should return 0 if the items are equal, a negative value if
-- the first item comes before the second, and a positive value if
-- the second item comes before the first.
-- 
-- /Since: 2.14/
sequenceSortChanged ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: A t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@cmpFunc@/: the function used to compare items in the sequence
    -> m ()
sequenceSortChanged iter cmpFunc = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    cmpFunc' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc cmpFunc))
    let cmpData = nullPtr
    g_sequence_sort_changed iter' cmpFunc' cmpData
    safeFreeFunPtr $ castFunPtrToPtr cmpFunc'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::sort_changed_iter
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter_cmp"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "SequenceIterCompareFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function used to compare iterators in the sequence"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cmp_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @cmp_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_sort_changed_iter" g_sequence_sort_changed_iter :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- iter : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    FunPtr GLib.Callbacks.C_SequenceIterCompareFunc -> -- iter_cmp : TInterface (Name {namespace = "GLib", name = "SequenceIterCompareFunc"})
    Ptr () ->                               -- cmp_data : TBasicType TPtr
    IO ()

-- | Like 'GI.GLib.Functions.sequenceSortChanged', but uses
-- a t'GI.GLib.Callbacks.SequenceIterCompareFunc' instead of a t'GI.GLib.Callbacks.CompareDataFunc' as
-- the compare function.
-- 
-- /@iterCmp@/ is called with two iterators pointing into the t'GI.GLib.Structs.Sequence.Sequence' that
-- /@iter@/ points into. It should
-- return 0 if the iterators are equal, a negative value if the first
-- iterator comes before the second, and a positive value if the second
-- iterator comes before the first.
-- 
-- /Since: 2.14/
sequenceSortChangedIter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@iter@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.Callbacks.SequenceIterCompareFunc
    -- ^ /@iterCmp@/: the function used to compare iterators in the sequence
    -> m ()
sequenceSortChangedIter iter iterCmp = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    iterCmp' <- GLib.Callbacks.mk_SequenceIterCompareFunc (GLib.Callbacks.wrap_SequenceIterCompareFunc Nothing (GLib.Callbacks.drop_closures_SequenceIterCompareFunc iterCmp))
    let cmpData = nullPtr
    g_sequence_sort_changed_iter iter' iterCmp' cmpData
    safeFreeFunPtr $ castFunPtrToPtr iterCmp'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Sequence::swap
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_sequence_swap" g_sequence_swap :: 
    Ptr GLib.SequenceIter.SequenceIter ->   -- a : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    Ptr GLib.SequenceIter.SequenceIter ->   -- b : TInterface (Name {namespace = "GLib", name = "SequenceIter"})
    IO ()

-- | Swaps the items pointed to by /@a@/ and /@b@/. It is allowed for /@a@/ and /@b@/
-- to point into difference sequences.
-- 
-- /Since: 2.14/
sequenceSwap ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.SequenceIter.SequenceIter
    -- ^ /@a@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@b@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> m ()
sequenceSwap a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    g_sequence_swap a' b'
    touchManagedPtr a
    touchManagedPtr b
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSequenceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSequenceMethod "append" o = SequenceAppendMethodInfo
    ResolveSequenceMethod "foreach" o = SequenceForeachMethodInfo
    ResolveSequenceMethod "free" o = SequenceFreeMethodInfo
    ResolveSequenceMethod "insertSorted" o = SequenceInsertSortedMethodInfo
    ResolveSequenceMethod "insertSortedIter" o = SequenceInsertSortedIterMethodInfo
    ResolveSequenceMethod "isEmpty" o = SequenceIsEmptyMethodInfo
    ResolveSequenceMethod "lookup" o = SequenceLookupMethodInfo
    ResolveSequenceMethod "lookupIter" o = SequenceLookupIterMethodInfo
    ResolveSequenceMethod "prepend" o = SequencePrependMethodInfo
    ResolveSequenceMethod "search" o = SequenceSearchMethodInfo
    ResolveSequenceMethod "searchIter" o = SequenceSearchIterMethodInfo
    ResolveSequenceMethod "sort" o = SequenceSortMethodInfo
    ResolveSequenceMethod "sortIter" o = SequenceSortIterMethodInfo
    ResolveSequenceMethod "getBeginIter" o = SequenceGetBeginIterMethodInfo
    ResolveSequenceMethod "getEndIter" o = SequenceGetEndIterMethodInfo
    ResolveSequenceMethod "getIterAtPos" o = SequenceGetIterAtPosMethodInfo
    ResolveSequenceMethod "getLength" o = SequenceGetLengthMethodInfo
    ResolveSequenceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSequenceMethod t Sequence, O.OverloadedMethod info Sequence p) => OL.IsLabel t (Sequence -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSequenceMethod t Sequence, O.OverloadedMethod info Sequence p, R.HasField t Sequence p) => R.HasField t Sequence p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSequenceMethod t Sequence, O.OverloadedMethodInfo info Sequence) => OL.IsLabel t (O.MethodProxy info Sequence) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


