{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Contains the public fields of a pointer array.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.PtrArray
    ( 

-- * Exported types
    PtrArray(..)                            ,
    newZeroPtrArray                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePtrArrayMethod                   ,
#endif



 -- * Properties


-- ** len #attr:len#
-- | number of pointers in the array

    getPtrArrayLen                          ,
#if defined(ENABLE_OVERLOADING)
    ptrArray_len                            ,
#endif
    setPtrArrayLen                          ,


-- ** pdata #attr:pdata#
-- | points to the array of pointers, which may be moved when the
--     array grows

    clearPtrArrayPdata                      ,
    getPtrArrayPdata                        ,
#if defined(ENABLE_OVERLOADING)
    ptrArray_pdata                          ,
#endif
    setPtrArrayPdata                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype PtrArray = PtrArray (SP.ManagedPtr PtrArray)
    deriving (Eq)

instance SP.ManagedPtrNewtype PtrArray where
    toManagedPtr (PtrArray p) = p

foreign import ccall "g_ptr_array_get_type" c_g_ptr_array_get_type :: 
    IO GType

type instance O.ParentTypes PtrArray = '[]
instance O.HasParentTypes PtrArray

instance B.Types.TypedObject PtrArray where
    glibType = c_g_ptr_array_get_type

instance B.Types.GBoxed PtrArray

-- | Convert 'PtrArray' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PtrArray) where
    gvalueGType_ = c_g_ptr_array_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr PtrArray)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr PtrArray)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed PtrArray ptr
        else return P.Nothing
        
    

-- | Construct a `PtrArray` struct initialized to zero.
newZeroPtrArray :: MonadIO m => m PtrArray
newZeroPtrArray = liftIO $ callocBoxedBytes 16 >>= wrapBoxed PtrArray

instance tag ~ 'AttrSet => Constructible PtrArray tag where
    new _ attrs = do
        o <- newZeroPtrArray
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@pdata@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' ptrArray #pdata
-- @
getPtrArrayPdata :: MonadIO m => PtrArray -> m (Ptr ())
getPtrArrayPdata s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@pdata@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' ptrArray [ #pdata 'Data.GI.Base.Attributes.:=' value ]
-- @
setPtrArrayPdata :: MonadIO m => PtrArray -> Ptr () -> m ()
setPtrArrayPdata s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@pdata@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pdata
-- @
clearPtrArrayPdata :: MonadIO m => PtrArray -> m ()
clearPtrArrayPdata s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data PtrArrayPdataFieldInfo
instance AttrInfo PtrArrayPdataFieldInfo where
    type AttrBaseTypeConstraint PtrArrayPdataFieldInfo = (~) PtrArray
    type AttrAllowedOps PtrArrayPdataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint PtrArrayPdataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint PtrArrayPdataFieldInfo = (~)(Ptr ())
    type AttrTransferType PtrArrayPdataFieldInfo = (Ptr ())
    type AttrGetType PtrArrayPdataFieldInfo = Ptr ()
    type AttrLabel PtrArrayPdataFieldInfo = "pdata"
    type AttrOrigin PtrArrayPdataFieldInfo = PtrArray
    attrGet = getPtrArrayPdata
    attrSet = setPtrArrayPdata
    attrConstruct = undefined
    attrClear = clearPtrArrayPdata
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.PtrArray.pdata"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-PtrArray.html#g:attr:pdata"
        })

ptrArray_pdata :: AttrLabelProxy "pdata"
ptrArray_pdata = AttrLabelProxy

#endif


-- | Get the value of the “@len@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' ptrArray #len
-- @
getPtrArrayLen :: MonadIO m => PtrArray -> m Word32
getPtrArrayLen s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@len@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' ptrArray [ #len 'Data.GI.Base.Attributes.:=' value ]
-- @
setPtrArrayLen :: MonadIO m => PtrArray -> Word32 -> m ()
setPtrArrayLen s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data PtrArrayLenFieldInfo
instance AttrInfo PtrArrayLenFieldInfo where
    type AttrBaseTypeConstraint PtrArrayLenFieldInfo = (~) PtrArray
    type AttrAllowedOps PtrArrayLenFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PtrArrayLenFieldInfo = (~) Word32
    type AttrTransferTypeConstraint PtrArrayLenFieldInfo = (~)Word32
    type AttrTransferType PtrArrayLenFieldInfo = Word32
    type AttrGetType PtrArrayLenFieldInfo = Word32
    type AttrLabel PtrArrayLenFieldInfo = "len"
    type AttrOrigin PtrArrayLenFieldInfo = PtrArray
    attrGet = getPtrArrayLen
    attrSet = setPtrArrayLen
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.PtrArray.len"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-PtrArray.html#g:attr:len"
        })

ptrArray_len :: AttrLabelProxy "len"
ptrArray_len = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PtrArray
type instance O.AttributeList PtrArray = PtrArrayAttributeList
type PtrArrayAttributeList = ('[ '("pdata", PtrArrayPdataFieldInfo), '("len", PtrArrayLenFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePtrArrayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePtrArrayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePtrArrayMethod t PtrArray, O.OverloadedMethod info PtrArray p) => OL.IsLabel t (PtrArray -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePtrArrayMethod t PtrArray, O.OverloadedMethod info PtrArray p, R.HasField t PtrArray p) => R.HasField t PtrArray p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePtrArrayMethod t PtrArray, O.OverloadedMethodInfo info PtrArray) => OL.IsLabel t (O.MethodProxy info PtrArray) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


