{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GOptionGroup@ struct defines the options in a single
-- group. The struct has only private fields and should not be directly accessed.
-- 
-- All options in a group share the same translation function. Libraries which
-- need to parse commandline options are expected to provide a function for
-- getting a @GOptionGroup@ holding their options, which
-- the application can then add to its t'GI.GLib.Structs.OptionContext.OptionContext'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.OptionGroup
    ( 

-- * Exported types
    OptionGroup(..)                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addEntries]("GI.GLib.Structs.OptionGroup#g:method:addEntries"), [free]("GI.GLib.Structs.OptionGroup#g:method:free"), [ref]("GI.GLib.Structs.OptionGroup#g:method:ref"), [unref]("GI.GLib.Structs.OptionGroup#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- [setTranslateFunc]("GI.GLib.Structs.OptionGroup#g:method:setTranslateFunc"), [setTranslationDomain]("GI.GLib.Structs.OptionGroup#g:method:setTranslationDomain").

#if defined(ENABLE_OVERLOADING)
    ResolveOptionGroupMethod                ,
#endif

-- ** addEntries #method:addEntries#

#if defined(ENABLE_OVERLOADING)
    OptionGroupAddEntriesMethodInfo         ,
#endif
    optionGroupAddEntries                   ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    OptionGroupFreeMethodInfo               ,
#endif
    optionGroupFree                         ,


-- ** new #method:new#

    optionGroupNew                          ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    OptionGroupRefMethodInfo                ,
#endif
    optionGroupRef                          ,


-- ** setTranslateFunc #method:setTranslateFunc#

#if defined(ENABLE_OVERLOADING)
    OptionGroupSetTranslateFuncMethodInfo   ,
#endif
    optionGroupSetTranslateFunc             ,


-- ** setTranslationDomain #method:setTranslationDomain#

#if defined(ENABLE_OVERLOADING)
    OptionGroupSetTranslationDomainMethodInfo,
#endif
    optionGroupSetTranslationDomain         ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    OptionGroupUnrefMethodInfo              ,
#endif
    optionGroupUnref                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionEntry as GLib.OptionEntry

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionEntry as GLib.OptionEntry

#endif

-- | Memory-managed wrapper type.
newtype OptionGroup = OptionGroup (SP.ManagedPtr OptionGroup)
    deriving (Eq)

instance SP.ManagedPtrNewtype OptionGroup where
    toManagedPtr (OptionGroup p) = p

foreign import ccall "g_option_group_get_type" c_g_option_group_get_type :: 
    IO GType

type instance O.ParentTypes OptionGroup = '[]
instance O.HasParentTypes OptionGroup

instance B.Types.TypedObject OptionGroup where
    glibType = c_g_option_group_get_type

instance B.Types.GBoxed OptionGroup

-- | Convert 'OptionGroup' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe OptionGroup) where
    gvalueGType_ = c_g_option_group_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr OptionGroup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr OptionGroup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed OptionGroup ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OptionGroup
type instance O.AttributeList OptionGroup = OptionGroupAttributeList
type OptionGroupAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method OptionGroup::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the name for the option group, this is used to provide\n  help for the options in this group with `--help-`@name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a description for this group to be shown in\n  `--help`. This string is translated using the translation\n  domain or translation function of the group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "help_description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a description for the `--help-`@name option.\n  This string is translated using the translation domain or translation function\n  of the group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data that will be passed to the pre- and post-parse hooks,\n  the error hook and to callbacks of %G_OPTION_ARG_CALLBACK options, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function that will be called to free @user_data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "OptionGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_new" g_option_group_new :: 
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- description : TBasicType TUTF8
    CString ->                              -- help_description : TBasicType TUTF8
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr OptionGroup)

-- | Creates a new t'GI.GLib.Structs.OptionGroup.OptionGroup'.
-- 
-- /@description@/ is typically used to provide a title for the group. If so, it
-- is recommended that it’s written in title case, and has a trailing colon so
-- that it matches the style of built-in GLib group titles such as
-- ‘Application Options:’.
-- 
-- /Since: 2.6/
optionGroupNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name for the option group, this is used to provide
    --   help for the options in this group with @--help-@/@name@/
    -> T.Text
    -- ^ /@description@/: a description for this group to be shown in
    --   @--help@. This string is translated using the translation
    --   domain or translation function of the group
    -> T.Text
    -- ^ /@helpDescription@/: a description for the @--help-@/@name@/ option.
    --   This string is translated using the translation domain or translation function
    --   of the group
    -> Ptr ()
    -- ^ /@userData@/: user data that will be passed to the pre- and post-parse hooks,
    --   the error hook and to callbacks of 'GI.GLib.Enums.OptionArgCallback' options, or 'P.Nothing'
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroy@/: a function that will be called to free /@userData@/, or 'P.Nothing'
    -> m OptionGroup
    -- ^ __Returns:__ a newly created option group. It should be added
    --   to a t'GI.GLib.Structs.OptionContext.OptionContext' or freed with 'GI.GLib.Structs.OptionGroup.optionGroupUnref'.
optionGroupNew name description helpDescription userData destroy = liftIO $ do
    name' <- textToCString name
    description' <- textToCString description
    helpDescription' <- textToCString helpDescription
    maybeDestroy <- case destroy of
        Nothing -> return FP.nullFunPtr
        Just jDestroy -> do
            ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) (GLib.Callbacks.drop_closures_DestroyNotify jDestroy))
            poke ptrdestroy jDestroy'
            return jDestroy'
    result <- g_option_group_new name' description' helpDescription' userData maybeDestroy
    checkUnexpectedReturnNULL "optionGroupNew" result
    result' <- (wrapBoxed OptionGroup) result
    freeMem name'
    freeMem description'
    freeMem helpDescription'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method OptionGroup::add_entries
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "entries"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GLib" , name = "OptionEntry" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %NULL-terminated array of #GOptionEntrys"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_add_entries" g_option_group_add_entries :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    Ptr (Ptr GLib.OptionEntry.OptionEntry) -> -- entries : TCArray True (-1) (-1) (TInterface (Name {namespace = "GLib", name = "OptionEntry"}))
    IO ()

-- | Adds the options specified in /@entries@/ to /@group@/.
-- 
-- /Since: 2.6/
optionGroupAddEntries ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> [GLib.OptionEntry.OptionEntry]
    -- ^ /@entries@/: a 'P.Nothing'-terminated array of @/GOptionEntrys/@
    -> m ()
optionGroupAddEntries group entries = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    entries' <- mapM unsafeManagedPtrGetPtr entries
    entries'' <- packZeroTerminatedPtrArray entries'
    g_option_group_add_entries group' entries''
    touchManagedPtr group
    mapM_ touchManagedPtr entries
    freeMem entries''
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionGroupAddEntriesMethodInfo
instance (signature ~ ([GLib.OptionEntry.OptionEntry] -> m ()), MonadIO m) => O.OverloadedMethod OptionGroupAddEntriesMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupAddEntries

instance O.OverloadedMethodInfo OptionGroupAddEntriesMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupAddEntries",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupAddEntries"
        })


#endif

-- method OptionGroup::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_free" g_option_group_free :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO ()

{-# DEPRECATED optionGroupFree ["(Since version 2.44)","Use 'GI.GLib.Structs.OptionGroup.optionGroupUnref' instead."] #-}
-- | Frees a t'GI.GLib.Structs.OptionGroup.OptionGroup'. Note that you must not free groups
-- which have been added to a t'GI.GLib.Structs.OptionContext.OptionContext'.
-- 
-- /Since: 2.6/
optionGroupFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> m ()
optionGroupFree group = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    g_option_group_free group'
    touchManagedPtr group
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionGroupFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod OptionGroupFreeMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupFree

instance O.OverloadedMethodInfo OptionGroupFreeMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupFree"
        })


#endif

-- method OptionGroup::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "OptionGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_ref" g_option_group_ref :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO (Ptr OptionGroup)

-- | Increments the reference count of /@group@/ by one.
-- 
-- /Since: 2.44/
optionGroupRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> m OptionGroup
    -- ^ __Returns:__ a t'GI.GLib.Structs.OptionGroup.OptionGroup'
optionGroupRef group = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    result <- g_option_group_ref group'
    checkUnexpectedReturnNULL "optionGroupRef" result
    result' <- (wrapBoxed OptionGroup) result
    touchManagedPtr group
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionGroupRefMethodInfo
instance (signature ~ (m OptionGroup), MonadIO m) => O.OverloadedMethod OptionGroupRefMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupRef

instance O.OverloadedMethodInfo OptionGroupRefMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupRef"
        })


#endif

-- method OptionGroup::set_translate_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TranslateFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTranslateFunc, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function which gets called to free @data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_set_translate_func" g_option_group_set_translate_func :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    FunPtr GLib.Callbacks.C_TranslateFunc -> -- func : TInterface (Name {namespace = "GLib", name = "TranslateFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the function which is used to translate user-visible strings,
-- for @--help@ output. Different groups can use different
-- @/GTranslateFuncs/@. If /@func@/ is 'P.Nothing', strings are not translated.
-- 
-- If you are using @/gettext()/@, you only need to set the translation
-- domain, see 'GI.GLib.Structs.OptionGroup.optionGroupSetTranslationDomain'.
-- 
-- /Since: 2.6/
optionGroupSetTranslateFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> Maybe (GLib.Callbacks.TranslateFunc)
    -- ^ /@func@/: the t'GI.GLib.Callbacks.TranslateFunc', or 'P.Nothing'
    -> m ()
optionGroupSetTranslateFunc group func = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    maybeFunc <- case func of
        Nothing -> return FP.nullFunPtr
        Just jFunc -> do
            jFunc' <- GLib.Callbacks.mk_TranslateFunc (GLib.Callbacks.wrap_TranslateFunc Nothing (GLib.Callbacks.drop_closures_TranslateFunc jFunc))
            return jFunc'
    let data_ = castFunPtrToPtr maybeFunc
    let destroyNotify = SP.safeFreeFunPtrPtr
    g_option_group_set_translate_func group' maybeFunc data_ destroyNotify
    touchManagedPtr group
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionGroupSetTranslateFuncMethodInfo
instance (signature ~ (Maybe (GLib.Callbacks.TranslateFunc) -> m ()), MonadIO m) => O.OverloadedMethod OptionGroupSetTranslateFuncMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupSetTranslateFunc

instance O.OverloadedMethodInfo OptionGroupSetTranslateFuncMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupSetTranslateFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupSetTranslateFunc"
        })


#endif

-- method OptionGroup::set_translation_domain
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the domain to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_set_translation_domain" g_option_group_set_translation_domain :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    CString ->                              -- domain : TBasicType TUTF8
    IO ()

-- | A convenience function to use @/gettext()/@ for translating
-- user-visible strings.
-- 
-- /Since: 2.6/
optionGroupSetTranslationDomain ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> T.Text
    -- ^ /@domain@/: the domain to use
    -> m ()
optionGroupSetTranslationDomain group domain = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    domain' <- textToCString domain
    g_option_group_set_translation_domain group' domain'
    touchManagedPtr group
    freeMem domain'
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionGroupSetTranslationDomainMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod OptionGroupSetTranslationDomainMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupSetTranslationDomain

instance O.OverloadedMethodInfo OptionGroupSetTranslationDomainMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupSetTranslationDomain",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupSetTranslationDomain"
        })


#endif

-- method OptionGroup::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_group_unref" g_option_group_unref :: 
    Ptr OptionGroup ->                      -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO ()

-- | Decrements the reference count of /@group@/ by one.
-- If the reference count drops to 0, the /@group@/ will be freed.
-- and all memory allocated by the /@group@/ is released.
-- 
-- /Since: 2.44/
optionGroupUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionGroup
    -- ^ /@group@/: a t'GI.GLib.Structs.OptionGroup.OptionGroup'
    -> m ()
optionGroupUnref group = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    g_option_group_unref group'
    touchManagedPtr group
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionGroupUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod OptionGroupUnrefMethodInfo OptionGroup signature where
    overloadedMethod = optionGroupUnref

instance O.OverloadedMethodInfo OptionGroupUnrefMethodInfo OptionGroup where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionGroup.optionGroupUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionGroup.html#v:optionGroupUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOptionGroupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOptionGroupMethod "addEntries" o = OptionGroupAddEntriesMethodInfo
    ResolveOptionGroupMethod "free" o = OptionGroupFreeMethodInfo
    ResolveOptionGroupMethod "ref" o = OptionGroupRefMethodInfo
    ResolveOptionGroupMethod "unref" o = OptionGroupUnrefMethodInfo
    ResolveOptionGroupMethod "setTranslateFunc" o = OptionGroupSetTranslateFuncMethodInfo
    ResolveOptionGroupMethod "setTranslationDomain" o = OptionGroupSetTranslationDomainMethodInfo
    ResolveOptionGroupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOptionGroupMethod t OptionGroup, O.OverloadedMethod info OptionGroup p) => OL.IsLabel t (OptionGroup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOptionGroupMethod t OptionGroup, O.OverloadedMethod info OptionGroup p, R.HasField t OptionGroup p) => R.HasField t OptionGroup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOptionGroupMethod t OptionGroup, O.OverloadedMethodInfo info OptionGroup) => OL.IsLabel t (O.MethodProxy info OptionGroup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


