{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- - 'GI.GLib.Enums.OptionArgNone': @/gboolean/@
--     - 'GI.GLib.Enums.OptionArgString': @/gchar/@*
--     - 'GI.GLib.Enums.OptionArgInt': @/gint/@
--     - 'GI.GLib.Enums.OptionArgFilename': @/gchar/@*
--     - 'GI.GLib.Enums.OptionArgStringArray': @/gchar/@**
--     - 'GI.GLib.Enums.OptionArgFilenameArray': @/gchar/@**
--     - 'GI.GLib.Enums.OptionArgDouble': @/gdouble/@
-- 
--     If /@arg@/ type is 'GI.GLib.Enums.OptionArgString' or 'GI.GLib.Enums.OptionArgFilename',
--     the location will contain a newly allocated string if the option
--     was given. That string needs to be freed by the callee using 'GI.GLib.Functions.free'.
--     Likewise if /@arg@/ type is 'GI.GLib.Enums.OptionArgStringArray' or
--     'GI.GLib.Enums.OptionArgFilenameArray', the data should be freed using 'GI.GLib.Functions.strfreev'.
-- A GOptionEntry struct defines a single option. To have an effect, they
-- must be added to a t'GI.GLib.Structs.OptionGroup.OptionGroup' with 'GI.GLib.Structs.OptionContext.optionContextAddMainEntries'
-- or 'GI.GLib.Structs.OptionGroup.optionGroupAddEntries'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.OptionEntry
    ( 

-- * Exported types
    OptionEntry(..)                         ,
    newZeroOptionEntry                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOptionEntryMethod                ,
#endif



 -- * Properties


-- ** arg #attr:arg#
-- | The type of the option, as a t'GI.GLib.Enums.OptionArg'

    getOptionEntryArg                       ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_arg                         ,
#endif
    setOptionEntryArg                       ,


-- ** argData #attr:argData#
-- | If the /@arg@/ type is 'GI.GLib.Enums.OptionArgCallback', then /@argData@/
--     must point to a t'GI.GLib.Callbacks.OptionArgFunc' callback function, which will be
--     called to handle the extra argument. Otherwise, /@argData@/ is a
--     pointer to a location to store the value, the required type of
--     the location depends on the /@arg@/ type:

    clearOptionEntryArgData                 ,
    getOptionEntryArgData                   ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_argData                     ,
#endif
    setOptionEntryArgData                   ,


-- ** argDescription #attr:argDescription#
-- | The placeholder to use for the extra argument parsed
--     by the option in @--help@ output. The /@argDescription@/ is translated
--     using the /@translateFunc@/ of the group, see
--     'GI.GLib.Structs.OptionGroup.optionGroupSetTranslationDomain'.

    clearOptionEntryArgDescription          ,
    getOptionEntryArgDescription            ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_argDescription              ,
#endif
    setOptionEntryArgDescription            ,


-- ** description #attr:description#
-- | the description for the option in @--help@
--     output. The /@description@/ is translated using the /@translateFunc@/
--     of the group, see 'GI.GLib.Structs.OptionGroup.optionGroupSetTranslationDomain'.

    clearOptionEntryDescription             ,
    getOptionEntryDescription               ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_description                 ,
#endif
    setOptionEntryDescription               ,


-- ** flags #attr:flags#
-- | Flags from t'GI.GLib.Flags.OptionFlags'

    getOptionEntryFlags                     ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_flags                       ,
#endif
    setOptionEntryFlags                     ,


-- ** longName #attr:longName#
-- | The long name of an option can be used to specify it
--     in a commandline as @--long_name@. Every option must have a
--     long name. To resolve conflicts if multiple option groups contain
--     the same long name, it is also possible to specify the option as
--     @--groupname-long_name@.

    clearOptionEntryLongName                ,
    getOptionEntryLongName                  ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_longName                    ,
#endif
    setOptionEntryLongName                  ,


-- ** shortName #attr:shortName#
-- | If an option has a short name, it can be specified
--     @-short_name@ in a commandline. /@shortName@/ must be  a printable
--     ASCII character different from \'-\', or zero if the option has no
--     short name.

    getOptionEntryShortName                 ,
#if defined(ENABLE_OVERLOADING)
    optionEntry_shortName                   ,
#endif
    setOptionEntryShortName                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#else
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#endif

-- | Memory-managed wrapper type.
newtype OptionEntry = OptionEntry (SP.ManagedPtr OptionEntry)
    deriving (Eq)

instance SP.ManagedPtrNewtype OptionEntry where
    toManagedPtr (OptionEntry p) = p

instance BoxedPtr OptionEntry where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr OptionEntry)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OptionEntry where
    boxedPtrCalloc = callocBytes 48


-- | Construct a `OptionEntry` struct initialized to zero.
newZeroOptionEntry :: MonadIO m => m OptionEntry
newZeroOptionEntry = liftIO $ boxedPtrCalloc >>= wrapPtr OptionEntry

instance tag ~ 'AttrSet => Constructible OptionEntry tag where
    new _ attrs = do
        o <- newZeroOptionEntry
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@long_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #longName
-- @
getOptionEntryLongName :: MonadIO m => OptionEntry -> m (Maybe T.Text)
getOptionEntryLongName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@long_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #longName 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryLongName :: MonadIO m => OptionEntry -> CString -> m ()
setOptionEntryLongName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@long_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #longName
-- @
clearOptionEntryLongName :: MonadIO m => OptionEntry -> m ()
clearOptionEntryLongName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data OptionEntryLongNameFieldInfo
instance AttrInfo OptionEntryLongNameFieldInfo where
    type AttrBaseTypeConstraint OptionEntryLongNameFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryLongNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OptionEntryLongNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint OptionEntryLongNameFieldInfo = (~)CString
    type AttrTransferType OptionEntryLongNameFieldInfo = CString
    type AttrGetType OptionEntryLongNameFieldInfo = Maybe T.Text
    type AttrLabel OptionEntryLongNameFieldInfo = "long_name"
    type AttrOrigin OptionEntryLongNameFieldInfo = OptionEntry
    attrGet = getOptionEntryLongName
    attrSet = setOptionEntryLongName
    attrConstruct = undefined
    attrClear = clearOptionEntryLongName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.longName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:longName"
        })

optionEntry_longName :: AttrLabelProxy "longName"
optionEntry_longName = AttrLabelProxy

#endif


-- | Get the value of the “@short_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #shortName
-- @
getOptionEntryShortName :: MonadIO m => OptionEntry -> m Int8
getOptionEntryShortName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int8
    return val

-- | Set the value of the “@short_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #shortName 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryShortName :: MonadIO m => OptionEntry -> Int8 -> m ()
setOptionEntryShortName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data OptionEntryShortNameFieldInfo
instance AttrInfo OptionEntryShortNameFieldInfo where
    type AttrBaseTypeConstraint OptionEntryShortNameFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryShortNameFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OptionEntryShortNameFieldInfo = (~) Int8
    type AttrTransferTypeConstraint OptionEntryShortNameFieldInfo = (~)Int8
    type AttrTransferType OptionEntryShortNameFieldInfo = Int8
    type AttrGetType OptionEntryShortNameFieldInfo = Int8
    type AttrLabel OptionEntryShortNameFieldInfo = "short_name"
    type AttrOrigin OptionEntryShortNameFieldInfo = OptionEntry
    attrGet = getOptionEntryShortName
    attrSet = setOptionEntryShortName
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.shortName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:shortName"
        })

optionEntry_shortName :: AttrLabelProxy "shortName"
optionEntry_shortName = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #flags
-- @
getOptionEntryFlags :: MonadIO m => OptionEntry -> m Int32
getOptionEntryFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryFlags :: MonadIO m => OptionEntry -> Int32 -> m ()
setOptionEntryFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OptionEntryFlagsFieldInfo
instance AttrInfo OptionEntryFlagsFieldInfo where
    type AttrBaseTypeConstraint OptionEntryFlagsFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OptionEntryFlagsFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OptionEntryFlagsFieldInfo = (~)Int32
    type AttrTransferType OptionEntryFlagsFieldInfo = Int32
    type AttrGetType OptionEntryFlagsFieldInfo = Int32
    type AttrLabel OptionEntryFlagsFieldInfo = "flags"
    type AttrOrigin OptionEntryFlagsFieldInfo = OptionEntry
    attrGet = getOptionEntryFlags
    attrSet = setOptionEntryFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:flags"
        })

optionEntry_flags :: AttrLabelProxy "flags"
optionEntry_flags = AttrLabelProxy

#endif


-- | Get the value of the “@arg@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #arg
-- @
getOptionEntryArg :: MonadIO m => OptionEntry -> m GLib.Enums.OptionArg
getOptionEntryArg s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@arg@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #arg 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryArg :: MonadIO m => OptionEntry -> GLib.Enums.OptionArg -> m ()
setOptionEntryArg s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 16) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data OptionEntryArgFieldInfo
instance AttrInfo OptionEntryArgFieldInfo where
    type AttrBaseTypeConstraint OptionEntryArgFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryArgFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OptionEntryArgFieldInfo = (~) GLib.Enums.OptionArg
    type AttrTransferTypeConstraint OptionEntryArgFieldInfo = (~)GLib.Enums.OptionArg
    type AttrTransferType OptionEntryArgFieldInfo = GLib.Enums.OptionArg
    type AttrGetType OptionEntryArgFieldInfo = GLib.Enums.OptionArg
    type AttrLabel OptionEntryArgFieldInfo = "arg"
    type AttrOrigin OptionEntryArgFieldInfo = OptionEntry
    attrGet = getOptionEntryArg
    attrSet = setOptionEntryArg
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.arg"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:arg"
        })

optionEntry_arg :: AttrLabelProxy "arg"
optionEntry_arg = AttrLabelProxy

#endif


-- | Get the value of the “@arg_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #argData
-- @
getOptionEntryArgData :: MonadIO m => OptionEntry -> m (Ptr ())
getOptionEntryArgData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr ())
    return val

-- | Set the value of the “@arg_data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #argData 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryArgData :: MonadIO m => OptionEntry -> Ptr () -> m ()
setOptionEntryArgData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr ())

-- | Set the value of the “@arg_data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #argData
-- @
clearOptionEntryArgData :: MonadIO m => OptionEntry -> m ()
clearOptionEntryArgData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data OptionEntryArgDataFieldInfo
instance AttrInfo OptionEntryArgDataFieldInfo where
    type AttrBaseTypeConstraint OptionEntryArgDataFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryArgDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OptionEntryArgDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint OptionEntryArgDataFieldInfo = (~)(Ptr ())
    type AttrTransferType OptionEntryArgDataFieldInfo = (Ptr ())
    type AttrGetType OptionEntryArgDataFieldInfo = Ptr ()
    type AttrLabel OptionEntryArgDataFieldInfo = "arg_data"
    type AttrOrigin OptionEntryArgDataFieldInfo = OptionEntry
    attrGet = getOptionEntryArgData
    attrSet = setOptionEntryArgData
    attrConstruct = undefined
    attrClear = clearOptionEntryArgData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.argData"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:argData"
        })

optionEntry_argData :: AttrLabelProxy "argData"
optionEntry_argData = AttrLabelProxy

#endif


-- | Get the value of the “@description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #description
-- @
getOptionEntryDescription :: MonadIO m => OptionEntry -> m (Maybe T.Text)
getOptionEntryDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #description 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryDescription :: MonadIO m => OptionEntry -> CString -> m ()
setOptionEntryDescription s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: CString)

-- | Set the value of the “@description@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #description
-- @
clearOptionEntryDescription :: MonadIO m => OptionEntry -> m ()
clearOptionEntryDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data OptionEntryDescriptionFieldInfo
instance AttrInfo OptionEntryDescriptionFieldInfo where
    type AttrBaseTypeConstraint OptionEntryDescriptionFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryDescriptionFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OptionEntryDescriptionFieldInfo = (~) CString
    type AttrTransferTypeConstraint OptionEntryDescriptionFieldInfo = (~)CString
    type AttrTransferType OptionEntryDescriptionFieldInfo = CString
    type AttrGetType OptionEntryDescriptionFieldInfo = Maybe T.Text
    type AttrLabel OptionEntryDescriptionFieldInfo = "description"
    type AttrOrigin OptionEntryDescriptionFieldInfo = OptionEntry
    attrGet = getOptionEntryDescription
    attrSet = setOptionEntryDescription
    attrConstruct = undefined
    attrClear = clearOptionEntryDescription
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.description"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:description"
        })

optionEntry_description :: AttrLabelProxy "description"
optionEntry_description = AttrLabelProxy

#endif


-- | Get the value of the “@arg_description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' optionEntry #argDescription
-- @
getOptionEntryArgDescription :: MonadIO m => OptionEntry -> m (Maybe T.Text)
getOptionEntryArgDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@arg_description@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' optionEntry [ #argDescription 'Data.GI.Base.Attributes.:=' value ]
-- @
setOptionEntryArgDescription :: MonadIO m => OptionEntry -> CString -> m ()
setOptionEntryArgDescription s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: CString)

-- | Set the value of the “@arg_description@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #argDescription
-- @
clearOptionEntryArgDescription :: MonadIO m => OptionEntry -> m ()
clearOptionEntryArgDescription s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data OptionEntryArgDescriptionFieldInfo
instance AttrInfo OptionEntryArgDescriptionFieldInfo where
    type AttrBaseTypeConstraint OptionEntryArgDescriptionFieldInfo = (~) OptionEntry
    type AttrAllowedOps OptionEntryArgDescriptionFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OptionEntryArgDescriptionFieldInfo = (~) CString
    type AttrTransferTypeConstraint OptionEntryArgDescriptionFieldInfo = (~)CString
    type AttrTransferType OptionEntryArgDescriptionFieldInfo = CString
    type AttrGetType OptionEntryArgDescriptionFieldInfo = Maybe T.Text
    type AttrLabel OptionEntryArgDescriptionFieldInfo = "arg_description"
    type AttrOrigin OptionEntryArgDescriptionFieldInfo = OptionEntry
    attrGet = getOptionEntryArgDescription
    attrSet = setOptionEntryArgDescription
    attrConstruct = undefined
    attrClear = clearOptionEntryArgDescription
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionEntry.argDescription"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionEntry.html#g:attr:argDescription"
        })

optionEntry_argDescription :: AttrLabelProxy "argDescription"
optionEntry_argDescription = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OptionEntry
type instance O.AttributeList OptionEntry = OptionEntryAttributeList
type OptionEntryAttributeList = ('[ '("longName", OptionEntryLongNameFieldInfo), '("shortName", OptionEntryShortNameFieldInfo), '("flags", OptionEntryFlagsFieldInfo), '("arg", OptionEntryArgFieldInfo), '("argData", OptionEntryArgDataFieldInfo), '("description", OptionEntryDescriptionFieldInfo), '("argDescription", OptionEntryArgDescriptionFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOptionEntryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOptionEntryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOptionEntryMethod t OptionEntry, O.OverloadedMethod info OptionEntry p) => OL.IsLabel t (OptionEntry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOptionEntryMethod t OptionEntry, O.OverloadedMethod info OptionEntry p, R.HasField t OptionEntry p) => R.HasField t OptionEntry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOptionEntryMethod t OptionEntry, O.OverloadedMethodInfo info OptionEntry) => OL.IsLabel t (O.MethodProxy info OptionEntry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


