{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GOptionContext@ struct defines which options
-- are accepted by the commandline option parser. The struct has only private
-- fields and should not be directly accessed.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.OptionContext
    ( 

-- * Exported types
    OptionContext(..)                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addGroup]("GI.GLib.Structs.OptionContext#g:method:addGroup"), [addMainEntries]("GI.GLib.Structs.OptionContext#g:method:addMainEntries"), [parse]("GI.GLib.Structs.OptionContext#g:method:parse"), [parseStrv]("GI.GLib.Structs.OptionContext#g:method:parseStrv").
-- 
-- ==== Getters
-- [getDescription]("GI.GLib.Structs.OptionContext#g:method:getDescription"), [getHelp]("GI.GLib.Structs.OptionContext#g:method:getHelp"), [getHelpEnabled]("GI.GLib.Structs.OptionContext#g:method:getHelpEnabled"), [getIgnoreUnknownOptions]("GI.GLib.Structs.OptionContext#g:method:getIgnoreUnknownOptions"), [getMainGroup]("GI.GLib.Structs.OptionContext#g:method:getMainGroup"), [getStrictPosix]("GI.GLib.Structs.OptionContext#g:method:getStrictPosix"), [getSummary]("GI.GLib.Structs.OptionContext#g:method:getSummary").
-- 
-- ==== Setters
-- [setDescription]("GI.GLib.Structs.OptionContext#g:method:setDescription"), [setHelpEnabled]("GI.GLib.Structs.OptionContext#g:method:setHelpEnabled"), [setIgnoreUnknownOptions]("GI.GLib.Structs.OptionContext#g:method:setIgnoreUnknownOptions"), [setMainGroup]("GI.GLib.Structs.OptionContext#g:method:setMainGroup"), [setStrictPosix]("GI.GLib.Structs.OptionContext#g:method:setStrictPosix"), [setSummary]("GI.GLib.Structs.OptionContext#g:method:setSummary"), [setTranslateFunc]("GI.GLib.Structs.OptionContext#g:method:setTranslateFunc"), [setTranslationDomain]("GI.GLib.Structs.OptionContext#g:method:setTranslationDomain").

#if defined(ENABLE_OVERLOADING)
    ResolveOptionContextMethod              ,
#endif

-- ** addGroup #method:addGroup#

#if defined(ENABLE_OVERLOADING)
    OptionContextAddGroupMethodInfo         ,
#endif
    optionContextAddGroup                   ,


-- ** addMainEntries #method:addMainEntries#

#if defined(ENABLE_OVERLOADING)
    OptionContextAddMainEntriesMethodInfo   ,
#endif
    optionContextAddMainEntries             ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetDescriptionMethodInfo   ,
#endif
    optionContextGetDescription             ,


-- ** getHelp #method:getHelp#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetHelpMethodInfo          ,
#endif
    optionContextGetHelp                    ,


-- ** getHelpEnabled #method:getHelpEnabled#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetHelpEnabledMethodInfo   ,
#endif
    optionContextGetHelpEnabled             ,


-- ** getIgnoreUnknownOptions #method:getIgnoreUnknownOptions#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetIgnoreUnknownOptionsMethodInfo,
#endif
    optionContextGetIgnoreUnknownOptions    ,


-- ** getMainGroup #method:getMainGroup#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetMainGroupMethodInfo     ,
#endif
    optionContextGetMainGroup               ,


-- ** getStrictPosix #method:getStrictPosix#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetStrictPosixMethodInfo   ,
#endif
    optionContextGetStrictPosix             ,


-- ** getSummary #method:getSummary#

#if defined(ENABLE_OVERLOADING)
    OptionContextGetSummaryMethodInfo       ,
#endif
    optionContextGetSummary                 ,


-- ** parse #method:parse#

#if defined(ENABLE_OVERLOADING)
    OptionContextParseMethodInfo            ,
#endif
    optionContextParse                      ,


-- ** parseStrv #method:parseStrv#

#if defined(ENABLE_OVERLOADING)
    OptionContextParseStrvMethodInfo        ,
#endif
    optionContextParseStrv                  ,


-- ** setDescription #method:setDescription#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetDescriptionMethodInfo   ,
#endif
    optionContextSetDescription             ,


-- ** setHelpEnabled #method:setHelpEnabled#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetHelpEnabledMethodInfo   ,
#endif
    optionContextSetHelpEnabled             ,


-- ** setIgnoreUnknownOptions #method:setIgnoreUnknownOptions#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetIgnoreUnknownOptionsMethodInfo,
#endif
    optionContextSetIgnoreUnknownOptions    ,


-- ** setMainGroup #method:setMainGroup#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetMainGroupMethodInfo     ,
#endif
    optionContextSetMainGroup               ,


-- ** setStrictPosix #method:setStrictPosix#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetStrictPosixMethodInfo   ,
#endif
    optionContextSetStrictPosix             ,


-- ** setSummary #method:setSummary#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetSummaryMethodInfo       ,
#endif
    optionContextSetSummary                 ,


-- ** setTranslateFunc #method:setTranslateFunc#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetTranslateFuncMethodInfo ,
#endif
    optionContextSetTranslateFunc           ,


-- ** setTranslationDomain #method:setTranslationDomain#

#if defined(ENABLE_OVERLOADING)
    OptionContextSetTranslationDomainMethodInfo,
#endif
    optionContextSetTranslationDomain       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionEntry as GLib.OptionEntry
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionEntry as GLib.OptionEntry
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup

#endif

-- | Memory-managed wrapper type.
newtype OptionContext = OptionContext (SP.ManagedPtr OptionContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype OptionContext where
    toManagedPtr (OptionContext p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr OptionContext where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OptionContext
type instance O.AttributeList OptionContext = OptionContextAttributeList
type OptionContextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method OptionContext::add_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the group to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_add_group" g_option_context_add_group :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    Ptr GLib.OptionGroup.OptionGroup ->     -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO ()

-- | Adds a t'GI.GLib.Structs.OptionGroup.OptionGroup' to the /@context@/, so that parsing with /@context@/
-- will recognize the options in the group. Note that this will take
-- ownership of the /@group@/ and thus the /@group@/ should not be freed.
-- 
-- /Since: 2.6/
optionContextAddGroup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: the group to add
    -> m ()
optionContextAddGroup context group = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    group' <- B.ManagedPtr.disownBoxed group
    g_option_context_add_group context' group'
    touchManagedPtr context
    touchManagedPtr group
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextAddGroupMethodInfo
instance (signature ~ (GLib.OptionGroup.OptionGroup -> m ()), MonadIO m) => O.OverloadedMethod OptionContextAddGroupMethodInfo OptionContext signature where
    overloadedMethod = optionContextAddGroup

instance O.OverloadedMethodInfo OptionContextAddGroupMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextAddGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextAddGroup"
        })


#endif

-- method OptionContext::add_main_entries
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "entries"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface Name { namespace = "GLib" , name = "OptionEntry" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %NULL-terminated array of #GOptionEntrys"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "translation_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a translation domain to use for translating\n   the `--help` output for the options in @entries\n   with gettext(), or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_add_main_entries" g_option_context_add_main_entries :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    Ptr (Ptr GLib.OptionEntry.OptionEntry) -> -- entries : TCArray True (-1) (-1) (TInterface (Name {namespace = "GLib", name = "OptionEntry"}))
    CString ->                              -- translation_domain : TBasicType TUTF8
    IO ()

-- | A convenience function which creates a main group if it doesn\'t
-- exist, adds the /@entries@/ to it and sets the translation domain.
-- 
-- /Since: 2.6/
optionContextAddMainEntries ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> [GLib.OptionEntry.OptionEntry]
    -- ^ /@entries@/: a 'P.Nothing'-terminated array of @/GOptionEntrys/@
    -> Maybe (T.Text)
    -- ^ /@translationDomain@/: a translation domain to use for translating
    --    the @--help@ output for the options in /@entries@/
    --    with @/gettext()/@, or 'P.Nothing'
    -> m ()
optionContextAddMainEntries context entries translationDomain = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    entries' <- mapM unsafeManagedPtrGetPtr entries
    entries'' <- packZeroTerminatedPtrArray entries'
    maybeTranslationDomain <- case translationDomain of
        Nothing -> return FP.nullPtr
        Just jTranslationDomain -> do
            jTranslationDomain' <- textToCString jTranslationDomain
            return jTranslationDomain'
    g_option_context_add_main_entries context' entries'' maybeTranslationDomain
    touchManagedPtr context
    mapM_ touchManagedPtr entries
    freeMem entries''
    freeMem maybeTranslationDomain
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextAddMainEntriesMethodInfo
instance (signature ~ ([GLib.OptionEntry.OptionEntry] -> Maybe (T.Text) -> m ()), MonadIO m) => O.OverloadedMethod OptionContextAddMainEntriesMethodInfo OptionContext signature where
    overloadedMethod = optionContextAddMainEntries

instance O.OverloadedMethodInfo OptionContextAddMainEntriesMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextAddMainEntries",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextAddMainEntries"
        })


#endif

-- XXX Could not generate method OptionContext::free
-- Bad introspection data: Transferring a non-boxed struct with unknown size!
-- method OptionContext::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_description" g_option_context_get_description :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO CString

-- | Returns the description. See 'GI.GLib.Structs.OptionContext.optionContextSetDescription'.
-- 
-- /Since: 2.12/
optionContextGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m T.Text
    -- ^ __Returns:__ the description
optionContextGetDescription context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_description context'
    checkUnexpectedReturnNULL "optionContextGetDescription" result
    result' <- cstringToText result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod OptionContextGetDescriptionMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetDescription

instance O.OverloadedMethodInfo OptionContextGetDescriptionMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetDescription"
        })


#endif

-- method OptionContext::get_help
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "main_help"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "if %TRUE, only include the main group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GOptionGroup to create help for, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_help" g_option_context_get_help :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CInt ->                                 -- main_help : TBasicType TBoolean
    Ptr GLib.OptionGroup.OptionGroup ->     -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO CString

-- | Returns a formatted, translated help text for the given context.
-- To obtain the text produced by @--help@, call
-- @g_option_context_get_help (context, TRUE, NULL)@.
-- To obtain the text produced by @--help-all@, call
-- @g_option_context_get_help (context, FALSE, NULL)@.
-- To obtain the help text for an option group, call
-- @g_option_context_get_help (context, FALSE, group)@.
-- 
-- /Since: 2.14/
optionContextGetHelp ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Bool
    -- ^ /@mainHelp@/: if 'P.True', only include the main group
    -> Maybe (GLib.OptionGroup.OptionGroup)
    -- ^ /@group@/: the t'GI.GLib.Structs.OptionGroup.OptionGroup' to create help for, or 'P.Nothing'
    -> m T.Text
    -- ^ __Returns:__ A newly allocated string containing the help text
optionContextGetHelp context mainHelp group = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    let mainHelp' = (P.fromIntegral . P.fromEnum) mainHelp
    maybeGroup <- case group of
        Nothing -> return FP.nullPtr
        Just jGroup -> do
            jGroup' <- unsafeManagedPtrGetPtr jGroup
            return jGroup'
    result <- g_option_context_get_help context' mainHelp' maybeGroup
    checkUnexpectedReturnNULL "optionContextGetHelp" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr context
    whenJust group touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetHelpMethodInfo
instance (signature ~ (Bool -> Maybe (GLib.OptionGroup.OptionGroup) -> m T.Text), MonadIO m) => O.OverloadedMethod OptionContextGetHelpMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetHelp

instance O.OverloadedMethodInfo OptionContextGetHelpMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetHelp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetHelp"
        })


#endif

-- method OptionContext::get_help_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_help_enabled" g_option_context_get_help_enabled :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO CInt

-- | Returns whether automatic @--help@ generation
-- is turned on for /@context@/. See 'GI.GLib.Structs.OptionContext.optionContextSetHelpEnabled'.
-- 
-- /Since: 2.6/
optionContextGetHelpEnabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if automatic help generation is turned on.
optionContextGetHelpEnabled context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_help_enabled context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetHelpEnabledMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod OptionContextGetHelpEnabledMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetHelpEnabled

instance O.OverloadedMethodInfo OptionContextGetHelpEnabledMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetHelpEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetHelpEnabled"
        })


#endif

-- method OptionContext::get_ignore_unknown_options
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_ignore_unknown_options" g_option_context_get_ignore_unknown_options :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO CInt

-- | Returns whether unknown options are ignored or not. See
-- 'GI.GLib.Structs.OptionContext.optionContextSetIgnoreUnknownOptions'.
-- 
-- /Since: 2.6/
optionContextGetIgnoreUnknownOptions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if unknown options are ignored.
optionContextGetIgnoreUnknownOptions context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_ignore_unknown_options context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetIgnoreUnknownOptionsMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod OptionContextGetIgnoreUnknownOptionsMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetIgnoreUnknownOptions

instance O.OverloadedMethodInfo OptionContextGetIgnoreUnknownOptionsMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetIgnoreUnknownOptions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetIgnoreUnknownOptions"
        })


#endif

-- method OptionContext::get_main_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "OptionGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_main_group" g_option_context_get_main_group :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO (Ptr GLib.OptionGroup.OptionGroup)

-- | Returns a pointer to the main group of /@context@/.
-- 
-- /Since: 2.6/
optionContextGetMainGroup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m GLib.OptionGroup.OptionGroup
    -- ^ __Returns:__ the main group of /@context@/, or 'P.Nothing' if
    --  /@context@/ doesn\'t have a main group. Note that group belongs to
    --  /@context@/ and should not be modified or freed.
optionContextGetMainGroup context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_main_group context'
    checkUnexpectedReturnNULL "optionContextGetMainGroup" result
    result' <- (newBoxed GLib.OptionGroup.OptionGroup) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetMainGroupMethodInfo
instance (signature ~ (m GLib.OptionGroup.OptionGroup), MonadIO m) => O.OverloadedMethod OptionContextGetMainGroupMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetMainGroup

instance O.OverloadedMethodInfo OptionContextGetMainGroupMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetMainGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetMainGroup"
        })


#endif

-- method OptionContext::get_strict_posix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_strict_posix" g_option_context_get_strict_posix :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO CInt

-- | Returns whether strict POSIX code is enabled.
-- 
-- See 'GI.GLib.Structs.OptionContext.optionContextSetStrictPosix' for more information.
-- 
-- /Since: 2.44/
optionContextGetStrictPosix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if strict POSIX is enabled, 'P.False' otherwise.
optionContextGetStrictPosix context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_strict_posix context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetStrictPosixMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod OptionContextGetStrictPosixMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetStrictPosix

instance O.OverloadedMethodInfo OptionContextGetStrictPosixMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetStrictPosix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetStrictPosix"
        })


#endif

-- method OptionContext::get_summary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_get_summary" g_option_context_get_summary :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    IO CString

-- | Returns the summary. See 'GI.GLib.Structs.OptionContext.optionContextSetSummary'.
-- 
-- /Since: 2.12/
optionContextGetSummary ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> m T.Text
    -- ^ __Returns:__ the summary
optionContextGetSummary context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_option_context_get_summary context'
    checkUnexpectedReturnNULL "optionContextGetSummary" result
    result' <- cstringToText result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data OptionContextGetSummaryMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod OptionContextGetSummaryMethodInfo OptionContext signature where
    overloadedMethod = optionContextGetSummary

instance O.OverloadedMethodInfo OptionContextGetSummaryMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextGetSummary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextGetSummary"
        })


#endif

-- method OptionContext::parse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to the number of command line arguments"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray False (-1) 1 (TBasicType TUTF8)
--           , direction = DirectionInout
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a pointer to the array of command line arguments"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "argc"
--              , argType = TBasicType TInt
--              , direction = DirectionInout
--              , mayBeNull = True
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "a pointer to the number of command line arguments"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_option_context_parse" g_option_context_parse :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    Ptr Int32 ->                            -- argc : TBasicType TInt
    Ptr (Ptr CString) ->                    -- argv : TCArray False (-1) 1 (TBasicType TUTF8)
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Parses the command line arguments, recognizing options
-- which have been added to /@context@/. A side-effect of
-- calling this function is that 'GI.GLib.Functions.setPrgname' will be
-- called.
-- 
-- If the parsing is successful, any parsed arguments are
-- removed from the array and /@argc@/ and /@argv@/ are updated
-- accordingly. A \'--\' option is stripped from /@argv@/
-- unless there are unparsed options before and after it,
-- or some of the options after it start with \'-\'. In case
-- of an error, /@argc@/ and /@argv@/ are left unmodified.
-- 
-- If automatic @--help@ support is enabled
-- (see 'GI.GLib.Structs.OptionContext.optionContextSetHelpEnabled'), and the
-- /@argv@/ array contains one of the recognized help options,
-- this function will produce help output to stdout and
-- call @exit (0)@.
-- 
-- Note that function depends on the
-- <http://developer.gnome.org/glib/stable/running.html#locale current locale> for automatic
-- character set conversion of string and filename arguments.
-- 
-- /Since: 2.6/
optionContextParse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Maybe ([T.Text])
    -- ^ /@argv@/: a pointer to the array of command line arguments
    -> m ((Maybe [T.Text]))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
optionContextParse context argv = liftIO $ do
    let argc = case argv of
            Nothing -> 0
            Just jArgv -> fromIntegral $ P.length jArgv
    context' <- unsafeManagedPtrGetPtr context
    argc' <- allocMem :: IO (Ptr Int32)
    poke argc' argc
    maybeArgv <- case argv of
        Nothing -> return FP.nullPtr
        Just jArgv -> do
            jArgv' <- packUTF8CArray jArgv
            return jArgv'
    maybeArgv' <- allocMem :: IO (Ptr (Ptr CString))
    poke maybeArgv' maybeArgv
    onException (do
        _ <- propagateGError $ g_option_context_parse context' argc' maybeArgv'
        argc'' <- peek argc'
        maybeArgv'' <- peek maybeArgv'
        maybeMaybeArgv'' <- convertIfNonNull maybeArgv'' $ \maybeArgv''' -> do
            maybeArgv'''' <- (unpackUTF8CArrayWithLength argc'') maybeArgv'''
            (mapCArrayWithLength argc'') freeMem maybeArgv'''
            freeMem maybeArgv'''
            return maybeArgv''''
        touchManagedPtr context
        freeMem argc'
        freeMem maybeArgv'
        return maybeMaybeArgv''
     ) (do
        freeMem argc'
        freeMem maybeArgv'
     )

#if defined(ENABLE_OVERLOADING)
data OptionContextParseMethodInfo
instance (signature ~ (Maybe ([T.Text]) -> m ((Maybe [T.Text]))), MonadIO m) => O.OverloadedMethod OptionContextParseMethodInfo OptionContext signature where
    overloadedMethod = optionContextParse

instance O.OverloadedMethodInfo OptionContextParseMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextParse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextParse"
        })


#endif

-- method OptionContext::parse_strv
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "arguments"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer\n   to the command line arguments (which must be in UTF-8 on Windows).\n   Starting with GLib 2.62, @arguments can be %NULL, which matches\n   g_option_context_parse()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_option_context_parse_strv" g_option_context_parse_strv :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    Ptr (Ptr CString) ->                    -- arguments : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Parses the command line arguments.
-- 
-- This function is similar to 'GI.GLib.Structs.OptionContext.optionContextParse' except that it
-- respects the normal memory rules when dealing with a strv instead of
-- assuming that the passed-in array is the argv of the main function.
-- 
-- In particular, strings that are removed from the arguments list will
-- be freed using 'GI.GLib.Functions.free'.
-- 
-- On Windows, the strings are expected to be in UTF-8.  This is in
-- contrast to 'GI.GLib.Structs.OptionContext.optionContextParse' which expects them to be in the
-- system codepage, which is how they are passed as /@argv@/ to @/main()/@.
-- See @/g_win32_get_command_line()/@ for a solution.
-- 
-- This function is useful if you are trying to use t'GI.GLib.Structs.OptionContext.OptionContext' with
-- @/GApplication/@.
-- 
-- /Since: 2.40/
optionContextParseStrv ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> [T.Text]
    -- ^ /@arguments@/: a pointer
    --    to the command line arguments (which must be in UTF-8 on Windows).
    --    Starting with GLib 2.62, /@arguments@/ can be 'P.Nothing', which matches
    --    'GI.GLib.Structs.OptionContext.optionContextParse'.
    -> m ([T.Text])
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
optionContextParseStrv context arguments = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    arguments' <- packZeroTerminatedUTF8CArray arguments
    arguments'' <- allocMem :: IO (Ptr (Ptr CString))
    poke arguments'' arguments'
    onException (do
        _ <- propagateGError $ g_option_context_parse_strv context' arguments''
        arguments''' <- peek arguments''
        arguments'''' <- unpackZeroTerminatedUTF8CArray arguments'''
        mapZeroTerminatedCArray freeMem arguments'''
        freeMem arguments'''
        touchManagedPtr context
        freeMem arguments''
        return arguments''''
     ) (do
        freeMem arguments''
     )

#if defined(ENABLE_OVERLOADING)
data OptionContextParseStrvMethodInfo
instance (signature ~ ([T.Text] -> m ([T.Text])), MonadIO m) => O.OverloadedMethod OptionContextParseStrvMethodInfo OptionContext signature where
    overloadedMethod = optionContextParseStrv

instance O.OverloadedMethodInfo OptionContextParseStrvMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextParseStrv",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextParseStrv"
        })


#endif

-- method OptionContext::set_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string to be shown in `--help` output\n  after the list of options, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_description" g_option_context_set_description :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CString ->                              -- description : TBasicType TUTF8
    IO ()

-- | Adds a string to be displayed in @--help@ output after the list
-- of options. This text often includes a bug reporting address.
-- 
-- Note that the summary is translated (see
-- 'GI.GLib.Structs.OptionContext.optionContextSetTranslateFunc').
-- 
-- /Since: 2.12/
optionContextSetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Maybe (T.Text)
    -- ^ /@description@/: a string to be shown in @--help@ output
    --   after the list of options, or 'P.Nothing'
    -> m ()
optionContextSetDescription context description = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    maybeDescription <- case description of
        Nothing -> return FP.nullPtr
        Just jDescription -> do
            jDescription' <- textToCString jDescription
            return jDescription'
    g_option_context_set_description context' maybeDescription
    touchManagedPtr context
    freeMem maybeDescription
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetDescriptionMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetDescriptionMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetDescription

instance O.OverloadedMethodInfo OptionContextSetDescriptionMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetDescription"
        })


#endif

-- method OptionContext::set_help_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "help_enabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to enable `--help`, %FALSE to disable it"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_help_enabled" g_option_context_set_help_enabled :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CInt ->                                 -- help_enabled : TBasicType TBoolean
    IO ()

-- | Enables or disables automatic generation of @--help@ output.
-- By default, 'GI.GLib.Structs.OptionContext.optionContextParse' recognizes @--help@, @-h@,
-- @-?@, @--help-all@ and @--help-groupname@ and creates suitable
-- output to stdout.
-- 
-- /Since: 2.6/
optionContextSetHelpEnabled ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Bool
    -- ^ /@helpEnabled@/: 'P.True' to enable @--help@, 'P.False' to disable it
    -> m ()
optionContextSetHelpEnabled context helpEnabled = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    let helpEnabled' = (P.fromIntegral . P.fromEnum) helpEnabled
    g_option_context_set_help_enabled context' helpEnabled'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetHelpEnabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetHelpEnabledMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetHelpEnabled

instance O.OverloadedMethodInfo OptionContextSetHelpEnabledMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetHelpEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetHelpEnabled"
        })


#endif

-- method OptionContext::set_ignore_unknown_options
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ignore_unknown"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE to ignore unknown options, %FALSE to produce\n   an error when unknown options are met"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_ignore_unknown_options" g_option_context_set_ignore_unknown_options :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CInt ->                                 -- ignore_unknown : TBasicType TBoolean
    IO ()

-- | Sets whether to ignore unknown options or not. If an argument is
-- ignored, it is left in the /@argv@/ array after parsing. By default,
-- 'GI.GLib.Structs.OptionContext.optionContextParse' treats unknown options as error.
-- 
-- This setting does not affect non-option arguments (i.e. arguments
-- which don\'t start with a dash). But note that GOption cannot reliably
-- determine whether a non-option belongs to a preceding unknown option.
-- 
-- /Since: 2.6/
optionContextSetIgnoreUnknownOptions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Bool
    -- ^ /@ignoreUnknown@/: 'P.True' to ignore unknown options, 'P.False' to produce
    --    an error when unknown options are met
    -> m ()
optionContextSetIgnoreUnknownOptions context ignoreUnknown = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    let ignoreUnknown' = (P.fromIntegral . P.fromEnum) ignoreUnknown
    g_option_context_set_ignore_unknown_options context' ignoreUnknown'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetIgnoreUnknownOptionsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetIgnoreUnknownOptionsMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetIgnoreUnknownOptions

instance O.OverloadedMethodInfo OptionContextSetIgnoreUnknownOptionsMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetIgnoreUnknownOptions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetIgnoreUnknownOptions"
        })


#endif

-- method OptionContext::set_main_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the group to set as main group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_main_group" g_option_context_set_main_group :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    Ptr GLib.OptionGroup.OptionGroup ->     -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO ()

-- | Sets a t'GI.GLib.Structs.OptionGroup.OptionGroup' as main group of the /@context@/.
-- This has the same effect as calling 'GI.GLib.Structs.OptionContext.optionContextAddGroup',
-- the only difference is that the options in the main group are
-- treated differently when generating @--help@ output.
-- 
-- /Since: 2.6/
optionContextSetMainGroup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: the group to set as main group
    -> m ()
optionContextSetMainGroup context group = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    group' <- B.ManagedPtr.disownBoxed group
    g_option_context_set_main_group context' group'
    touchManagedPtr context
    touchManagedPtr group
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetMainGroupMethodInfo
instance (signature ~ (GLib.OptionGroup.OptionGroup -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetMainGroupMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetMainGroup

instance O.OverloadedMethodInfo OptionContextSetMainGroupMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetMainGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetMainGroup"
        })


#endif

-- method OptionContext::set_strict_posix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "strict_posix"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_strict_posix" g_option_context_set_strict_posix :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CInt ->                                 -- strict_posix : TBasicType TBoolean
    IO ()

-- | Sets strict POSIX mode.
-- 
-- By default, this mode is disabled.
-- 
-- In strict POSIX mode, the first non-argument parameter encountered
-- (eg: filename) terminates argument processing.  Remaining arguments
-- are treated as non-options and are not attempted to be parsed.
-- 
-- If strict POSIX mode is disabled then parsing is done in the GNU way
-- where option arguments can be freely mixed with non-options.
-- 
-- As an example, consider \"ls foo -l\".  With GNU style parsing, this
-- will list \"foo\" in long mode.  In strict POSIX style, this will list
-- the files named \"foo\" and \"-l\".
-- 
-- It may be useful to force strict POSIX mode when creating \"verb
-- style\" command line tools.  For example, the \"gsettings\" command line
-- tool supports the global option \"--schemadir\" as well as many
-- subcommands (\"get\", \"set\", etc.) which each have their own set of
-- arguments.  Using strict POSIX mode will allow parsing the global
-- options up to the verb name while leaving the remaining options to be
-- parsed by the relevant subcommand (which can be determined by
-- examining the verb name, which should be present in argv[1] after
-- parsing).
-- 
-- /Since: 2.44/
optionContextSetStrictPosix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Bool
    -- ^ /@strictPosix@/: the new value
    -> m ()
optionContextSetStrictPosix context strictPosix = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    let strictPosix' = (P.fromIntegral . P.fromEnum) strictPosix
    g_option_context_set_strict_posix context' strictPosix'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetStrictPosixMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetStrictPosixMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetStrictPosix

instance O.OverloadedMethodInfo OptionContextSetStrictPosixMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetStrictPosix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetStrictPosix"
        })


#endif

-- method OptionContext::set_summary
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "summary"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string to be shown in `--help` output\n before the list of options, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_summary" g_option_context_set_summary :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CString ->                              -- summary : TBasicType TUTF8
    IO ()

-- | Adds a string to be displayed in @--help@ output before the list
-- of options. This is typically a summary of the program functionality.
-- 
-- Note that the summary is translated (see
-- 'GI.GLib.Structs.OptionContext.optionContextSetTranslateFunc' and
-- 'GI.GLib.Structs.OptionContext.optionContextSetTranslationDomain').
-- 
-- /Since: 2.12/
optionContextSetSummary ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Maybe (T.Text)
    -- ^ /@summary@/: a string to be shown in @--help@ output
    --  before the list of options, or 'P.Nothing'
    -> m ()
optionContextSetSummary context summary = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    maybeSummary <- case summary of
        Nothing -> return FP.nullPtr
        Just jSummary -> do
            jSummary' <- textToCString jSummary
            return jSummary'
    g_option_context_set_summary context' maybeSummary
    touchManagedPtr context
    freeMem maybeSummary
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetSummaryMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetSummaryMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetSummary

instance O.OverloadedMethodInfo OptionContextSetSummaryMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetSummary",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetSummary"
        })


#endif

-- method OptionContext::set_translate_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TranslateFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTranslateFunc, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function which gets called to free @data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_translate_func" g_option_context_set_translate_func :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    FunPtr GLib.Callbacks.C_TranslateFunc -> -- func : TInterface (Name {namespace = "GLib", name = "TranslateFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the function which is used to translate the contexts
-- user-visible strings, for @--help@ output. If /@func@/ is 'P.Nothing',
-- strings are not translated.
-- 
-- Note that option groups have their own translation functions,
-- this function only affects the /@parameterString@/ (see @/g_option_context_new()/@),
-- the summary (see 'GI.GLib.Structs.OptionContext.optionContextSetSummary') and the description
-- (see 'GI.GLib.Structs.OptionContext.optionContextSetDescription').
-- 
-- If you are using @/gettext()/@, you only need to set the translation
-- domain, see 'GI.GLib.Structs.OptionContext.optionContextSetTranslationDomain'.
-- 
-- /Since: 2.12/
optionContextSetTranslateFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> Maybe (GLib.Callbacks.TranslateFunc)
    -- ^ /@func@/: the t'GI.GLib.Callbacks.TranslateFunc', or 'P.Nothing'
    -> m ()
optionContextSetTranslateFunc context func = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    maybeFunc <- case func of
        Nothing -> return FP.nullFunPtr
        Just jFunc -> do
            jFunc' <- GLib.Callbacks.mk_TranslateFunc (GLib.Callbacks.wrap_TranslateFunc Nothing (GLib.Callbacks.drop_closures_TranslateFunc jFunc))
            return jFunc'
    let data_ = castFunPtrToPtr maybeFunc
    let destroyNotify = SP.safeFreeFunPtrPtr
    g_option_context_set_translate_func context' maybeFunc data_ destroyNotify
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetTranslateFuncMethodInfo
instance (signature ~ (Maybe (GLib.Callbacks.TranslateFunc) -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetTranslateFuncMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetTranslateFunc

instance O.OverloadedMethodInfo OptionContextSetTranslateFuncMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetTranslateFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetTranslateFunc"
        })


#endif

-- method OptionContext::set_translation_domain
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOptionContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the domain to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_option_context_set_translation_domain" g_option_context_set_translation_domain :: 
    Ptr OptionContext ->                    -- context : TInterface (Name {namespace = "GLib", name = "OptionContext"})
    CString ->                              -- domain : TBasicType TUTF8
    IO ()

-- | A convenience function to use @/gettext()/@ for translating
-- user-visible strings.
-- 
-- /Since: 2.12/
optionContextSetTranslationDomain ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    OptionContext
    -- ^ /@context@/: a t'GI.GLib.Structs.OptionContext.OptionContext'
    -> T.Text
    -- ^ /@domain@/: the domain to use
    -> m ()
optionContextSetTranslationDomain context domain = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    domain' <- textToCString domain
    g_option_context_set_translation_domain context' domain'
    touchManagedPtr context
    freeMem domain'
    return ()

#if defined(ENABLE_OVERLOADING)
data OptionContextSetTranslationDomainMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod OptionContextSetTranslationDomainMethodInfo OptionContext signature where
    overloadedMethod = optionContextSetTranslationDomain

instance O.OverloadedMethodInfo OptionContextSetTranslationDomainMethodInfo OptionContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.OptionContext.optionContextSetTranslationDomain",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-OptionContext.html#v:optionContextSetTranslationDomain"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOptionContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOptionContextMethod "addGroup" o = OptionContextAddGroupMethodInfo
    ResolveOptionContextMethod "addMainEntries" o = OptionContextAddMainEntriesMethodInfo
    ResolveOptionContextMethod "parse" o = OptionContextParseMethodInfo
    ResolveOptionContextMethod "parseStrv" o = OptionContextParseStrvMethodInfo
    ResolveOptionContextMethod "getDescription" o = OptionContextGetDescriptionMethodInfo
    ResolveOptionContextMethod "getHelp" o = OptionContextGetHelpMethodInfo
    ResolveOptionContextMethod "getHelpEnabled" o = OptionContextGetHelpEnabledMethodInfo
    ResolveOptionContextMethod "getIgnoreUnknownOptions" o = OptionContextGetIgnoreUnknownOptionsMethodInfo
    ResolveOptionContextMethod "getMainGroup" o = OptionContextGetMainGroupMethodInfo
    ResolveOptionContextMethod "getStrictPosix" o = OptionContextGetStrictPosixMethodInfo
    ResolveOptionContextMethod "getSummary" o = OptionContextGetSummaryMethodInfo
    ResolveOptionContextMethod "setDescription" o = OptionContextSetDescriptionMethodInfo
    ResolveOptionContextMethod "setHelpEnabled" o = OptionContextSetHelpEnabledMethodInfo
    ResolveOptionContextMethod "setIgnoreUnknownOptions" o = OptionContextSetIgnoreUnknownOptionsMethodInfo
    ResolveOptionContextMethod "setMainGroup" o = OptionContextSetMainGroupMethodInfo
    ResolveOptionContextMethod "setStrictPosix" o = OptionContextSetStrictPosixMethodInfo
    ResolveOptionContextMethod "setSummary" o = OptionContextSetSummaryMethodInfo
    ResolveOptionContextMethod "setTranslateFunc" o = OptionContextSetTranslateFuncMethodInfo
    ResolveOptionContextMethod "setTranslationDomain" o = OptionContextSetTranslationDomainMethodInfo
    ResolveOptionContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOptionContextMethod t OptionContext, O.OverloadedMethod info OptionContext p) => OL.IsLabel t (OptionContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOptionContextMethod t OptionContext, O.OverloadedMethod info OptionContext p, R.HasField t OptionContext p) => R.HasField t OptionContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOptionContextMethod t OptionContext, O.OverloadedMethodInfo info OptionContext) => OL.IsLabel t (O.MethodProxy info OptionContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


