{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Any of the fields in t'GI.GLib.Structs.MarkupParser.MarkupParser' can be 'P.Nothing', in which case they
-- will be ignored. Except for the /@error@/ function, any of these callbacks
-- can set an error; in particular the 'GI.GLib.Enums.MarkupErrorUnknownElement',
-- 'GI.GLib.Enums.MarkupErrorUnknownAttribute', and 'GI.GLib.Enums.MarkupErrorInvalidContent'
-- errors are intended to be set from these callbacks. If you set an error
-- from a callback, 'GI.GLib.Structs.MarkupParseContext.markupParseContextParse' will report that error
-- back to its caller.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MarkupParser
    ( 

-- * Exported types
    MarkupParser(..)                        ,
    newZeroMarkupParser                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveMarkupParserMethod               ,
#endif



 -- * Properties


-- ** endElement #attr:endElement#
-- | Callback to invoke when the closing tag of an element
--     is seen. Note that this is also called for empty tags like
--     @\<empty\/>@.

    clearMarkupParserEndElement             ,
    getMarkupParserEndElement               ,
#if defined(ENABLE_OVERLOADING)
    markupParser_endElement                 ,
#endif
    setMarkupParserEndElement               ,


-- ** error #attr:error#
-- | Callback to invoke when an error occurs.

    clearMarkupParserError                  ,
    getMarkupParserError                    ,
#if defined(ENABLE_OVERLOADING)
    markupParser_error                      ,
#endif
    setMarkupParserError                    ,


-- ** passthrough #attr:passthrough#
-- | Callback to invoke for comments, processing instructions
--     and doctype declarations; if you\'re re-writing the parsed document,
--     write the passthrough text back out in the same position. If the
--     'GI.GLib.Flags.MarkupParseFlagsTreatCdataAsText' flag is not set, this function is also
--     called for CDATA marked sections.

    clearMarkupParserPassthrough            ,
    getMarkupParserPassthrough              ,
#if defined(ENABLE_OVERLOADING)
    markupParser_passthrough                ,
#endif
    setMarkupParserPassthrough              ,


-- ** startElement #attr:startElement#
-- | Callback to invoke when the opening tag of an element
--     is seen. The callback\'s /@attributeNames@/ and /@attributeValues@/ parameters
--     are 'P.Nothing'-terminated.

    clearMarkupParserStartElement           ,
    getMarkupParserStartElement             ,
#if defined(ENABLE_OVERLOADING)
    markupParser_startElement               ,
#endif
    setMarkupParserStartElement             ,


-- ** text #attr:text#
-- | Callback to invoke when some text is seen (text is always
--     inside an element). Note that the text of an element may be spread
--     over multiple calls of this function. If the
--     'GI.GLib.Flags.MarkupParseFlagsTreatCdataAsText' flag is set, this function is also
--     called for the content of CDATA marked sections.

    clearMarkupParserText                   ,
    getMarkupParserText                     ,
#if defined(ENABLE_OVERLOADING)
    markupParser_text                       ,
#endif
    setMarkupParserText                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype MarkupParser = MarkupParser (SP.ManagedPtr MarkupParser)
    deriving (Eq)

instance SP.ManagedPtrNewtype MarkupParser where
    toManagedPtr (MarkupParser p) = p

instance BoxedPtr MarkupParser where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr MarkupParser)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr MarkupParser where
    boxedPtrCalloc = callocBytes 40


-- | Construct a `MarkupParser` struct initialized to zero.
newZeroMarkupParser :: MonadIO m => m MarkupParser
newZeroMarkupParser = liftIO $ boxedPtrCalloc >>= wrapPtr MarkupParser

instance tag ~ 'AttrSet => Constructible MarkupParser tag where
    new _ attrs = do
        o <- newZeroMarkupParser
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@start_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' markupParser #startElement
-- @
getMarkupParserStartElement :: MonadIO m => MarkupParser -> m (Maybe GLib.Callbacks.MarkupParserStartElementFieldCallback_WithClosures)
getMarkupParserStartElement s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MarkupParserStartElementFieldCallback val'
        return val''
    return result

-- | Set the value of the “@start_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' markupParser [ #startElement 'Data.GI.Base.Attributes.:=' value ]
-- @
setMarkupParserStartElement :: MonadIO m => MarkupParser -> FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback -> m ()
setMarkupParserStartElement s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)

-- | Set the value of the “@start_element@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #startElement
-- @
clearMarkupParserStartElement :: MonadIO m => MarkupParser -> m ()
clearMarkupParserStartElement s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MarkupParserStartElementFieldInfo
instance AttrInfo MarkupParserStartElementFieldInfo where
    type AttrBaseTypeConstraint MarkupParserStartElementFieldInfo = (~) MarkupParser
    type AttrAllowedOps MarkupParserStartElementFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MarkupParserStartElementFieldInfo = (~) (FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)
    type AttrTransferTypeConstraint MarkupParserStartElementFieldInfo = (~)(FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)
    type AttrTransferType MarkupParserStartElementFieldInfo = (FunPtr GLib.Callbacks.C_MarkupParserStartElementFieldCallback)
    type AttrGetType MarkupParserStartElementFieldInfo = Maybe GLib.Callbacks.MarkupParserStartElementFieldCallback_WithClosures
    type AttrLabel MarkupParserStartElementFieldInfo = "start_element"
    type AttrOrigin MarkupParserStartElementFieldInfo = MarkupParser
    attrGet = getMarkupParserStartElement
    attrSet = setMarkupParserStartElement
    attrConstruct = undefined
    attrClear = clearMarkupParserStartElement
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParser.startElement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MarkupParser.html#g:attr:startElement"
        })

markupParser_startElement :: AttrLabelProxy "startElement"
markupParser_startElement = AttrLabelProxy

#endif


-- | Get the value of the “@end_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' markupParser #endElement
-- @
getMarkupParserEndElement :: MonadIO m => MarkupParser -> m (Maybe GLib.Callbacks.MarkupParserEndElementFieldCallback_WithClosures)
getMarkupParserEndElement s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MarkupParserEndElementFieldCallback val'
        return val''
    return result

-- | Set the value of the “@end_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' markupParser [ #endElement 'Data.GI.Base.Attributes.:=' value ]
-- @
setMarkupParserEndElement :: MonadIO m => MarkupParser -> FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback -> m ()
setMarkupParserEndElement s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)

-- | Set the value of the “@end_element@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #endElement
-- @
clearMarkupParserEndElement :: MonadIO m => MarkupParser -> m ()
clearMarkupParserEndElement s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MarkupParserEndElementFieldInfo
instance AttrInfo MarkupParserEndElementFieldInfo where
    type AttrBaseTypeConstraint MarkupParserEndElementFieldInfo = (~) MarkupParser
    type AttrAllowedOps MarkupParserEndElementFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MarkupParserEndElementFieldInfo = (~) (FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)
    type AttrTransferTypeConstraint MarkupParserEndElementFieldInfo = (~)(FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)
    type AttrTransferType MarkupParserEndElementFieldInfo = (FunPtr GLib.Callbacks.C_MarkupParserEndElementFieldCallback)
    type AttrGetType MarkupParserEndElementFieldInfo = Maybe GLib.Callbacks.MarkupParserEndElementFieldCallback_WithClosures
    type AttrLabel MarkupParserEndElementFieldInfo = "end_element"
    type AttrOrigin MarkupParserEndElementFieldInfo = MarkupParser
    attrGet = getMarkupParserEndElement
    attrSet = setMarkupParserEndElement
    attrConstruct = undefined
    attrClear = clearMarkupParserEndElement
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParser.endElement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MarkupParser.html#g:attr:endElement"
        })

markupParser_endElement :: AttrLabelProxy "endElement"
markupParser_endElement = AttrLabelProxy

#endif


-- | Get the value of the “@text@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' markupParser #text
-- @
getMarkupParserText :: MonadIO m => MarkupParser -> m (Maybe GLib.Callbacks.MarkupParserTextFieldCallback_WithClosures)
getMarkupParserText s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MarkupParserTextFieldCallback val'
        return val''
    return result

-- | Set the value of the “@text@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' markupParser [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setMarkupParserText :: MonadIO m => MarkupParser -> FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback -> m ()
setMarkupParserText s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)

-- | Set the value of the “@text@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearMarkupParserText :: MonadIO m => MarkupParser -> m ()
clearMarkupParserText s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MarkupParserTextFieldInfo
instance AttrInfo MarkupParserTextFieldInfo where
    type AttrBaseTypeConstraint MarkupParserTextFieldInfo = (~) MarkupParser
    type AttrAllowedOps MarkupParserTextFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MarkupParserTextFieldInfo = (~) (FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)
    type AttrTransferTypeConstraint MarkupParserTextFieldInfo = (~)(FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)
    type AttrTransferType MarkupParserTextFieldInfo = (FunPtr GLib.Callbacks.C_MarkupParserTextFieldCallback)
    type AttrGetType MarkupParserTextFieldInfo = Maybe GLib.Callbacks.MarkupParserTextFieldCallback_WithClosures
    type AttrLabel MarkupParserTextFieldInfo = "text"
    type AttrOrigin MarkupParserTextFieldInfo = MarkupParser
    attrGet = getMarkupParserText
    attrSet = setMarkupParserText
    attrConstruct = undefined
    attrClear = clearMarkupParserText
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParser.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MarkupParser.html#g:attr:text"
        })

markupParser_text :: AttrLabelProxy "text"
markupParser_text = AttrLabelProxy

#endif


-- | Get the value of the “@passthrough@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' markupParser #passthrough
-- @
getMarkupParserPassthrough :: MonadIO m => MarkupParser -> m (Maybe GLib.Callbacks.MarkupParserPassthroughFieldCallback_WithClosures)
getMarkupParserPassthrough s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MarkupParserPassthroughFieldCallback val'
        return val''
    return result

-- | Set the value of the “@passthrough@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' markupParser [ #passthrough 'Data.GI.Base.Attributes.:=' value ]
-- @
setMarkupParserPassthrough :: MonadIO m => MarkupParser -> FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback -> m ()
setMarkupParserPassthrough s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)

-- | Set the value of the “@passthrough@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #passthrough
-- @
clearMarkupParserPassthrough :: MonadIO m => MarkupParser -> m ()
clearMarkupParserPassthrough s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MarkupParserPassthroughFieldInfo
instance AttrInfo MarkupParserPassthroughFieldInfo where
    type AttrBaseTypeConstraint MarkupParserPassthroughFieldInfo = (~) MarkupParser
    type AttrAllowedOps MarkupParserPassthroughFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MarkupParserPassthroughFieldInfo = (~) (FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)
    type AttrTransferTypeConstraint MarkupParserPassthroughFieldInfo = (~)(FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)
    type AttrTransferType MarkupParserPassthroughFieldInfo = (FunPtr GLib.Callbacks.C_MarkupParserPassthroughFieldCallback)
    type AttrGetType MarkupParserPassthroughFieldInfo = Maybe GLib.Callbacks.MarkupParserPassthroughFieldCallback_WithClosures
    type AttrLabel MarkupParserPassthroughFieldInfo = "passthrough"
    type AttrOrigin MarkupParserPassthroughFieldInfo = MarkupParser
    attrGet = getMarkupParserPassthrough
    attrSet = setMarkupParserPassthrough
    attrConstruct = undefined
    attrClear = clearMarkupParserPassthrough
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParser.passthrough"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MarkupParser.html#g:attr:passthrough"
        })

markupParser_passthrough :: AttrLabelProxy "passthrough"
markupParser_passthrough = AttrLabelProxy

#endif


-- | Get the value of the “@error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' markupParser #error
-- @
getMarkupParserError :: MonadIO m => MarkupParser -> m (Maybe GLib.Callbacks.MarkupParserErrorFieldCallback_WithClosures)
getMarkupParserError s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_MarkupParserErrorFieldCallback val'
        return val''
    return result

-- | Set the value of the “@error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' markupParser [ #error 'Data.GI.Base.Attributes.:=' value ]
-- @
setMarkupParserError :: MonadIO m => MarkupParser -> FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback -> m ()
setMarkupParserError s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback)

-- | Set the value of the “@error@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #error
-- @
clearMarkupParserError :: MonadIO m => MarkupParser -> m ()
clearMarkupParserError s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback)

#if defined(ENABLE_OVERLOADING)
data MarkupParserErrorFieldInfo
instance AttrInfo MarkupParserErrorFieldInfo where
    type AttrBaseTypeConstraint MarkupParserErrorFieldInfo = (~) MarkupParser
    type AttrAllowedOps MarkupParserErrorFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint MarkupParserErrorFieldInfo = (~) (FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback)
    type AttrTransferTypeConstraint MarkupParserErrorFieldInfo = (~)GLib.Callbacks.MarkupParserErrorFieldCallback_WithClosures
    type AttrTransferType MarkupParserErrorFieldInfo = (FunPtr GLib.Callbacks.C_MarkupParserErrorFieldCallback)
    type AttrGetType MarkupParserErrorFieldInfo = Maybe GLib.Callbacks.MarkupParserErrorFieldCallback_WithClosures
    type AttrLabel MarkupParserErrorFieldInfo = "error"
    type AttrOrigin MarkupParserErrorFieldInfo = MarkupParser
    attrGet = getMarkupParserError
    attrSet = setMarkupParserError
    attrConstruct = undefined
    attrClear = clearMarkupParserError
    attrTransfer _ v = do
        GLib.Callbacks.mk_MarkupParserErrorFieldCallback (GLib.Callbacks.wrap_MarkupParserErrorFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MarkupParser.error"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MarkupParser.html#g:attr:error"
        })

markupParser_error :: AttrLabelProxy "error"
markupParser_error = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MarkupParser
type instance O.AttributeList MarkupParser = MarkupParserAttributeList
type MarkupParserAttributeList = ('[ '("startElement", MarkupParserStartElementFieldInfo), '("endElement", MarkupParserEndElementFieldInfo), '("text", MarkupParserTextFieldInfo), '("passthrough", MarkupParserPassthroughFieldInfo), '("error", MarkupParserErrorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMarkupParserMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMarkupParserMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMarkupParserMethod t MarkupParser, O.OverloadedMethod info MarkupParser p) => OL.IsLabel t (MarkupParser -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMarkupParserMethod t MarkupParser, O.OverloadedMethod info MarkupParser p, R.HasField t MarkupParser p) => R.HasField t MarkupParser p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMarkupParserMethod t MarkupParser, O.OverloadedMethodInfo info MarkupParser) => OL.IsLabel t (O.MethodProxy info MarkupParser) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


