{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.MappedFile.MappedFile' represents a file mapping created with
-- 'GI.GLib.Structs.MappedFile.mappedFileNew'. It has only private members and should
-- not be accessed directly.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MappedFile
    ( 

-- * Exported types
    MappedFile(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.GLib.Structs.MappedFile#g:method:free"), [ref]("GI.GLib.Structs.MappedFile#g:method:ref"), [unref]("GI.GLib.Structs.MappedFile#g:method:unref").
-- 
-- ==== Getters
-- [getBytes]("GI.GLib.Structs.MappedFile#g:method:getBytes"), [getContents]("GI.GLib.Structs.MappedFile#g:method:getContents"), [getLength]("GI.GLib.Structs.MappedFile#g:method:getLength").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMappedFileMethod                 ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    MappedFileFreeMethodInfo                ,
#endif
    mappedFileFree                          ,


-- ** getBytes #method:getBytes#

#if defined(ENABLE_OVERLOADING)
    MappedFileGetBytesMethodInfo            ,
#endif
    mappedFileGetBytes                      ,


-- ** getContents #method:getContents#

#if defined(ENABLE_OVERLOADING)
    MappedFileGetContentsMethodInfo         ,
#endif
    mappedFileGetContents                   ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    MappedFileGetLengthMethodInfo           ,
#endif
    mappedFileGetLength                     ,


-- ** new #method:new#

    mappedFileNew                           ,


-- ** newFromFd #method:newFromFd#

    mappedFileNewFromFd                     ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    MappedFileRefMethodInfo                 ,
#endif
    mappedFileRef                           ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    MappedFileUnrefMethodInfo               ,
#endif
    mappedFileUnref                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Structs.Bytes as GLib.Bytes

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.Bytes as GLib.Bytes

#endif

-- | Memory-managed wrapper type.
newtype MappedFile = MappedFile (SP.ManagedPtr MappedFile)
    deriving (Eq)

instance SP.ManagedPtrNewtype MappedFile where
    toManagedPtr (MappedFile p) = p

foreign import ccall "g_mapped_file_get_type" c_g_mapped_file_get_type :: 
    IO GType

type instance O.ParentTypes MappedFile = '[]
instance O.HasParentTypes MappedFile

instance B.Types.TypedObject MappedFile where
    glibType = c_g_mapped_file_get_type

instance B.Types.GBoxed MappedFile

-- | Convert 'MappedFile' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MappedFile) where
    gvalueGType_ = c_g_mapped_file_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MappedFile)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MappedFile)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MappedFile ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MappedFile
type instance O.AttributeList MappedFile = MappedFileAttributeList
type MappedFileAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method MappedFile::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The path of the file to load, in the GLib\n    filename encoding"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "writable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the mapping should be writable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MappedFile" })
-- throws : True
-- Skip return : False

foreign import ccall "g_mapped_file_new" g_mapped_file_new :: 
    CString ->                              -- filename : TBasicType TFileName
    CInt ->                                 -- writable : TBasicType TBoolean
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr MappedFile)

-- | Maps a file into memory. On UNIX, this is using the @/mmap()/@ function.
-- 
-- If /@writable@/ is 'P.True', the mapped buffer may be modified, otherwise
-- it is an error to modify the mapped buffer. Modifications to the buffer
-- are not visible to other processes mapping the same file, and are not
-- written back to the file.
-- 
-- Note that modifications of the underlying file might affect the contents
-- of the t'GI.GLib.Structs.MappedFile.MappedFile'. Therefore, mapping should only be used if the file
-- will not be modified, or if all modifications of the file are done
-- atomically (e.g. using 'GI.GLib.Functions.fileSetContents').
-- 
-- If /@filename@/ is the name of an empty, regular file, the function
-- will successfully return an empty t'GI.GLib.Structs.MappedFile.MappedFile'. In other cases of
-- size 0 (e.g. device files such as \/dev\/null), /@error@/ will be set
-- to the t'GI.GLib.Enums.FileError' value 'GI.GLib.Enums.FileErrorInval'.
-- 
-- /Since: 2.8/
mappedFileNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filename@/: The path of the file to load, in the GLib
    --     filename encoding
    -> Bool
    -- ^ /@writable@/: whether the mapping should be writable
    -> m MappedFile
    -- ^ __Returns:__ a newly allocated t'GI.GLib.Structs.MappedFile.MappedFile' which must be unref\'d
    --    with 'GI.GLib.Structs.MappedFile.mappedFileUnref', or 'P.Nothing' if the mapping failed. /(Can throw 'Data.GI.Base.GError.GError')/
mappedFileNew filename writable = liftIO $ do
    filename' <- stringToCString filename
    let writable' = (P.fromIntegral . P.fromEnum) writable
    onException (do
        result <- propagateGError $ g_mapped_file_new filename' writable'
        checkUnexpectedReturnNULL "mappedFileNew" result
        result' <- (wrapBoxed MappedFile) result
        freeMem filename'
        return result'
     ) (do
        freeMem filename'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method MappedFile::new_from_fd
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The file descriptor of the file to load"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "writable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the mapping should be writable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MappedFile" })
-- throws : True
-- Skip return : False

foreign import ccall "g_mapped_file_new_from_fd" g_mapped_file_new_from_fd :: 
    Int32 ->                                -- fd : TBasicType TInt
    CInt ->                                 -- writable : TBasicType TBoolean
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr MappedFile)

-- | Maps a file into memory. On UNIX, this is using the @/mmap()/@ function.
-- 
-- If /@writable@/ is 'P.True', the mapped buffer may be modified, otherwise
-- it is an error to modify the mapped buffer. Modifications to the buffer
-- are not visible to other processes mapping the same file, and are not
-- written back to the file.
-- 
-- Note that modifications of the underlying file might affect the contents
-- of the t'GI.GLib.Structs.MappedFile.MappedFile'. Therefore, mapping should only be used if the file
-- will not be modified, or if all modifications of the file are done
-- atomically (e.g. using 'GI.GLib.Functions.fileSetContents').
-- 
-- /Since: 2.32/
mappedFileNewFromFd ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: The file descriptor of the file to load
    -> Bool
    -- ^ /@writable@/: whether the mapping should be writable
    -> m MappedFile
    -- ^ __Returns:__ a newly allocated t'GI.GLib.Structs.MappedFile.MappedFile' which must be unref\'d
    --    with 'GI.GLib.Structs.MappedFile.mappedFileUnref', or 'P.Nothing' if the mapping failed. /(Can throw 'Data.GI.Base.GError.GError')/
mappedFileNewFromFd fd writable = liftIO $ do
    let writable' = (P.fromIntegral . P.fromEnum) writable
    onException (do
        result <- propagateGError $ g_mapped_file_new_from_fd fd writable'
        checkUnexpectedReturnNULL "mappedFileNewFromFd" result
        result' <- (wrapBoxed MappedFile) result
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method MappedFile::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_free" g_mapped_file_free :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO ()

{-# DEPRECATED mappedFileFree ["(Since version 2.22)","Use 'GI.GLib.Structs.MappedFile.mappedFileUnref' instead."] #-}
-- | This call existed before t'GI.GLib.Structs.MappedFile.MappedFile' had refcounting and is currently
-- exactly the same as 'GI.GLib.Structs.MappedFile.mappedFileUnref'.
-- 
-- /Since: 2.8/
mappedFileFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m ()
mappedFileFree file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    g_mapped_file_free file'
    touchManagedPtr file
    return ()

#if defined(ENABLE_OVERLOADING)
data MappedFileFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MappedFileFreeMethodInfo MappedFile signature where
    overloadedMethod = mappedFileFree

instance O.OverloadedMethodInfo MappedFileFreeMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileFree"
        })


#endif

-- method MappedFile::get_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_get_bytes" g_mapped_file_get_bytes :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO (Ptr GLib.Bytes.Bytes)

-- | Creates a new t'GI.GLib.Structs.Bytes.Bytes' which references the data mapped from /@file@/.
-- The mapped contents of the file must not be modified after creating this
-- bytes object, because a t'GI.GLib.Structs.Bytes.Bytes' should be immutable.
-- 
-- /Since: 2.34/
mappedFileGetBytes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ A newly allocated t'GI.GLib.Structs.Bytes.Bytes' referencing data
    --     from /@file@/
mappedFileGetBytes file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    result <- g_mapped_file_get_bytes file'
    checkUnexpectedReturnNULL "mappedFileGetBytes" result
    result' <- (wrapBoxed GLib.Bytes.Bytes) result
    touchManagedPtr file
    return result'

#if defined(ENABLE_OVERLOADING)
data MappedFileGetBytesMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m) => O.OverloadedMethod MappedFileGetBytesMethodInfo MappedFile signature where
    overloadedMethod = mappedFileGetBytes

instance O.OverloadedMethodInfo MappedFileGetBytesMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileGetBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileGetBytes"
        })


#endif

-- method MappedFile::get_contents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_get_contents" g_mapped_file_get_contents :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO CString

-- | Returns the contents of a t'GI.GLib.Structs.MappedFile.MappedFile'.
-- 
-- Note that the contents may not be zero-terminated,
-- even if the t'GI.GLib.Structs.MappedFile.MappedFile' is backed by a text file.
-- 
-- If the file is empty then 'P.Nothing' is returned.
-- 
-- /Since: 2.8/
mappedFileGetContents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the contents of /@file@/, or 'P.Nothing'.
mappedFileGetContents file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    result <- g_mapped_file_get_contents file'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr file
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MappedFileGetContentsMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod MappedFileGetContentsMethodInfo MappedFile signature where
    overloadedMethod = mappedFileGetContents

instance O.OverloadedMethodInfo MappedFileGetContentsMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileGetContents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileGetContents"
        })


#endif

-- method MappedFile::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_get_length" g_mapped_file_get_length :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO FCT.CSize

-- | Returns the length of the contents of a t'GI.GLib.Structs.MappedFile.MappedFile'.
-- 
-- /Since: 2.8/
mappedFileGetLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m FCT.CSize
    -- ^ __Returns:__ the length of the contents of /@file@/.
mappedFileGetLength file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    result <- g_mapped_file_get_length file'
    touchManagedPtr file
    return result

#if defined(ENABLE_OVERLOADING)
data MappedFileGetLengthMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m) => O.OverloadedMethod MappedFileGetLengthMethodInfo MappedFile signature where
    overloadedMethod = mappedFileGetLength

instance O.OverloadedMethodInfo MappedFileGetLengthMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileGetLength"
        })


#endif

-- method MappedFile::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MappedFile" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_ref" g_mapped_file_ref :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO (Ptr MappedFile)

-- | Increments the reference count of /@file@/ by one.  It is safe to call
-- this function from any thread.
-- 
-- /Since: 2.22/
mappedFileRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m MappedFile
    -- ^ __Returns:__ the passed in t'GI.GLib.Structs.MappedFile.MappedFile'.
mappedFileRef file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    result <- g_mapped_file_ref file'
    checkUnexpectedReturnNULL "mappedFileRef" result
    result' <- (wrapBoxed MappedFile) result
    touchManagedPtr file
    return result'

#if defined(ENABLE_OVERLOADING)
data MappedFileRefMethodInfo
instance (signature ~ (m MappedFile), MonadIO m) => O.OverloadedMethod MappedFileRefMethodInfo MappedFile signature where
    overloadedMethod = mappedFileRef

instance O.OverloadedMethodInfo MappedFileRefMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileRef"
        })


#endif

-- method MappedFile::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "file"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MappedFile" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMappedFile" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mapped_file_unref" g_mapped_file_unref :: 
    Ptr MappedFile ->                       -- file : TInterface (Name {namespace = "GLib", name = "MappedFile"})
    IO ()

-- | Decrements the reference count of /@file@/ by one.  If the reference count
-- drops to 0, unmaps the buffer of /@file@/ and frees it.
-- 
-- It is safe to call this function from any thread.
-- 
-- Since 2.22
mappedFileUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MappedFile
    -- ^ /@file@/: a t'GI.GLib.Structs.MappedFile.MappedFile'
    -> m ()
mappedFileUnref file = liftIO $ do
    file' <- unsafeManagedPtrGetPtr file
    g_mapped_file_unref file'
    touchManagedPtr file
    return ()

#if defined(ENABLE_OVERLOADING)
data MappedFileUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MappedFileUnrefMethodInfo MappedFile signature where
    overloadedMethod = mappedFileUnref

instance O.OverloadedMethodInfo MappedFileUnrefMethodInfo MappedFile where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MappedFile.mappedFileUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MappedFile.html#v:mappedFileUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMappedFileMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMappedFileMethod "free" o = MappedFileFreeMethodInfo
    ResolveMappedFileMethod "ref" o = MappedFileRefMethodInfo
    ResolveMappedFileMethod "unref" o = MappedFileUnrefMethodInfo
    ResolveMappedFileMethod "getBytes" o = MappedFileGetBytesMethodInfo
    ResolveMappedFileMethod "getContents" o = MappedFileGetContentsMethodInfo
    ResolveMappedFileMethod "getLength" o = MappedFileGetLengthMethodInfo
    ResolveMappedFileMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMappedFileMethod t MappedFile, O.OverloadedMethod info MappedFile p) => OL.IsLabel t (MappedFile -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMappedFileMethod t MappedFile, O.OverloadedMethod info MappedFile p, R.HasField t MappedFile p) => R.HasField t MappedFile p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMappedFileMethod t MappedFile, O.OverloadedMethodInfo info MappedFile) => OL.IsLabel t (O.MethodProxy info MappedFile) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


