{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GMainLoop@ struct is an opaque data type
-- representing the main event loop of a GLib or GTK application.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MainLoop
    ( 

-- * Exported types
    MainLoop(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [isRunning]("GI.GLib.Structs.MainLoop#g:method:isRunning"), [quit]("GI.GLib.Structs.MainLoop#g:method:quit"), [ref]("GI.GLib.Structs.MainLoop#g:method:ref"), [run]("GI.GLib.Structs.MainLoop#g:method:run"), [unref]("GI.GLib.Structs.MainLoop#g:method:unref").
-- 
-- ==== Getters
-- [getContext]("GI.GLib.Structs.MainLoop#g:method:getContext").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMainLoopMethod                   ,
#endif

-- ** getContext #method:getContext#

#if defined(ENABLE_OVERLOADING)
    MainLoopGetContextMethodInfo            ,
#endif
    mainLoopGetContext                      ,


-- ** isRunning #method:isRunning#

#if defined(ENABLE_OVERLOADING)
    MainLoopIsRunningMethodInfo             ,
#endif
    mainLoopIsRunning                       ,


-- ** new #method:new#

    mainLoopNew                             ,


-- ** quit #method:quit#

#if defined(ENABLE_OVERLOADING)
    MainLoopQuitMethodInfo                  ,
#endif
    mainLoopQuit                            ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    MainLoopRefMethodInfo                   ,
#endif
    mainLoopRef                             ,


-- ** run #method:run#

#if defined(ENABLE_OVERLOADING)
    MainLoopRunMethodInfo                   ,
#endif
    mainLoopRun                             ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    MainLoopUnrefMethodInfo                 ,
#endif
    mainLoopUnref                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex

#else
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext

#endif

-- | Memory-managed wrapper type.
newtype MainLoop = MainLoop (SP.ManagedPtr MainLoop)
    deriving (Eq)

instance SP.ManagedPtrNewtype MainLoop where
    toManagedPtr (MainLoop p) = p

foreign import ccall "g_main_loop_get_type" c_g_main_loop_get_type :: 
    IO GType

type instance O.ParentTypes MainLoop = '[]
instance O.HasParentTypes MainLoop

instance B.Types.TypedObject MainLoop where
    glibType = c_g_main_loop_get_type

instance B.Types.GBoxed MainLoop

-- | Convert 'MainLoop' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MainLoop) where
    gvalueGType_ = c_g_main_loop_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MainLoop)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MainLoop)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MainLoop ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MainLoop
type instance O.AttributeList MainLoop = MainLoopAttributeList
type MainLoopAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method MainLoop::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext  (if %NULL, the global-default\n  main context will be used)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_running"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "set to %TRUE to indicate that the loop is running. This\nis not very important since calling [method@GLib.MainLoop.run] will set this\nto %TRUE anyway."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MainLoop" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_new" g_main_loop_new :: 
    Ptr GLib.MainContext.MainContext ->     -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    CInt ->                                 -- is_running : TBasicType TBoolean
    IO (Ptr MainLoop)

-- | Creates a new [struct/@gLib@/.MainLoop] structure.
mainLoopNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GLib.MainContext.MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext'  (if 'P.Nothing', the global-default
    --   main context will be used).
    -> Bool
    -- ^ /@isRunning@/: set to 'P.True' to indicate that the loop is running. This
    -- is not very important since calling 'GI.GLib.Structs.MainLoop.mainLoopRun' will set this
    -- to 'P.True' anyway.
    -> m MainLoop
    -- ^ __Returns:__ a new t'GI.GLib.Structs.MainLoop.MainLoop'.
mainLoopNew context isRunning = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    let isRunning' = (P.fromIntegral . P.fromEnum) isRunning
    result <- g_main_loop_new maybeContext isRunning'
    checkUnexpectedReturnNULL "mainLoopNew" result
    result' <- (wrapBoxed MainLoop) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MainLoop::get_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_get_context" g_main_loop_get_context :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO (Ptr GLib.MainContext.MainContext)

-- | Returns the [struct/@gLib@/.MainContext] of /@loop@/.
mainLoopGetContext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'.
    -> m GLib.MainContext.MainContext
    -- ^ __Returns:__ the [struct/@gLib@/.MainContext] of /@loop@/
mainLoopGetContext loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    result <- g_main_loop_get_context loop'
    checkUnexpectedReturnNULL "mainLoopGetContext" result
    result' <- (newBoxed GLib.MainContext.MainContext) result
    touchManagedPtr loop
    return result'

#if defined(ENABLE_OVERLOADING)
data MainLoopGetContextMethodInfo
instance (signature ~ (m GLib.MainContext.MainContext), MonadIO m) => O.OverloadedMethod MainLoopGetContextMethodInfo MainLoop signature where
    overloadedMethod = mainLoopGetContext

instance O.OverloadedMethodInfo MainLoopGetContextMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopGetContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopGetContext"
        })


#endif

-- method MainLoop::is_running
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_is_running" g_main_loop_is_running :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO CInt

-- | Checks to see if the main loop is currently being run via
-- 'GI.GLib.Structs.MainLoop.mainLoopRun'.
mainLoopIsRunning ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the mainloop is currently being run.
mainLoopIsRunning loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    result <- g_main_loop_is_running loop'
    let result' = (/= 0) result
    touchManagedPtr loop
    return result'

#if defined(ENABLE_OVERLOADING)
data MainLoopIsRunningMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MainLoopIsRunningMethodInfo MainLoop signature where
    overloadedMethod = mainLoopIsRunning

instance O.OverloadedMethodInfo MainLoopIsRunningMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopIsRunning",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopIsRunning"
        })


#endif

-- method MainLoop::quit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_quit" g_main_loop_quit :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO ()

-- | Stops a [struct/@gLib@/.MainLoop] from running. Any calls to
-- 'GI.GLib.Structs.MainLoop.mainLoopRun' for the loop will return.
-- 
-- Note that sources that have already been dispatched when
-- 'GI.GLib.Structs.MainLoop.mainLoopQuit' is called will still be executed.
mainLoopQuit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'
    -> m ()
mainLoopQuit loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    g_main_loop_quit loop'
    touchManagedPtr loop
    return ()

#if defined(ENABLE_OVERLOADING)
data MainLoopQuitMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainLoopQuitMethodInfo MainLoop signature where
    overloadedMethod = mainLoopQuit

instance O.OverloadedMethodInfo MainLoopQuitMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopQuit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopQuit"
        })


#endif

-- method MainLoop::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "MainLoop" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_ref" g_main_loop_ref :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO (Ptr MainLoop)

-- | Increases the reference count on a [struct/@gLib@/.MainLoop] object by one.
mainLoopRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'
    -> m MainLoop
    -- ^ __Returns:__ /@loop@/
mainLoopRef loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    result <- g_main_loop_ref loop'
    checkUnexpectedReturnNULL "mainLoopRef" result
    result' <- (wrapBoxed MainLoop) result
    touchManagedPtr loop
    return result'

#if defined(ENABLE_OVERLOADING)
data MainLoopRefMethodInfo
instance (signature ~ (m MainLoop), MonadIO m) => O.OverloadedMethod MainLoopRefMethodInfo MainLoop signature where
    overloadedMethod = mainLoopRef

instance O.OverloadedMethodInfo MainLoopRefMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopRef"
        })


#endif

-- method MainLoop::run
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_run" g_main_loop_run :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO ()

-- | Runs a main loop until 'GI.GLib.Structs.MainLoop.mainLoopQuit' is called on the loop.
-- If this is called for the thread of the loop\'s t'GI.GLib.Structs.MainContext.MainContext',
-- it will process events from the loop, otherwise it will
-- simply wait.
mainLoopRun ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'
    -> m ()
mainLoopRun loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    g_main_loop_run loop'
    touchManagedPtr loop
    return ()

#if defined(ENABLE_OVERLOADING)
data MainLoopRunMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainLoopRunMethodInfo MainLoop signature where
    overloadedMethod = mainLoopRun

instance O.OverloadedMethodInfo MainLoopRunMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopRun",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopRun"
        })


#endif

-- method MainLoop::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "loop"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainLoop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainLoop" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_loop_unref" g_main_loop_unref :: 
    Ptr MainLoop ->                         -- loop : TInterface (Name {namespace = "GLib", name = "MainLoop"})
    IO ()

-- | Decreases the reference count on a [struct/@gLib@/.MainLoop] object by one. If
-- the result is zero, free the loop and free all associated memory.
mainLoopUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainLoop
    -- ^ /@loop@/: a t'GI.GLib.Structs.MainLoop.MainLoop'
    -> m ()
mainLoopUnref loop = liftIO $ do
    loop' <- unsafeManagedPtrGetPtr loop
    g_main_loop_unref loop'
    touchManagedPtr loop
    return ()

#if defined(ENABLE_OVERLOADING)
data MainLoopUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainLoopUnrefMethodInfo MainLoop signature where
    overloadedMethod = mainLoopUnref

instance O.OverloadedMethodInfo MainLoopUnrefMethodInfo MainLoop where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainLoop.mainLoopUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainLoop.html#v:mainLoopUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMainLoopMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMainLoopMethod "isRunning" o = MainLoopIsRunningMethodInfo
    ResolveMainLoopMethod "quit" o = MainLoopQuitMethodInfo
    ResolveMainLoopMethod "ref" o = MainLoopRefMethodInfo
    ResolveMainLoopMethod "run" o = MainLoopRunMethodInfo
    ResolveMainLoopMethod "unref" o = MainLoopUnrefMethodInfo
    ResolveMainLoopMethod "getContext" o = MainLoopGetContextMethodInfo
    ResolveMainLoopMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMainLoopMethod t MainLoop, O.OverloadedMethod info MainLoop p) => OL.IsLabel t (MainLoop -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMainLoopMethod t MainLoop, O.OverloadedMethod info MainLoop p, R.HasField t MainLoop p) => R.HasField t MainLoop p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMainLoopMethod t MainLoop, O.OverloadedMethodInfo info MainLoop) => OL.IsLabel t (O.MethodProxy info MainLoop) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


