{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GMainContext@ struct is an opaque data
-- type representing a set of sources to be handled in a main loop.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.MainContext
    ( 

-- * Exported types
    MainContext(..)                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [acquire]("GI.GLib.Structs.MainContext#g:method:acquire"), [addPoll]("GI.GLib.Structs.MainContext#g:method:addPoll"), [check]("GI.GLib.Structs.MainContext#g:method:check"), [dispatch]("GI.GLib.Structs.MainContext#g:method:dispatch"), [findSourceByFuncsUserData]("GI.GLib.Structs.MainContext#g:method:findSourceByFuncsUserData"), [findSourceById]("GI.GLib.Structs.MainContext#g:method:findSourceById"), [findSourceByUserData]("GI.GLib.Structs.MainContext#g:method:findSourceByUserData"), [invokeFull]("GI.GLib.Structs.MainContext#g:method:invokeFull"), [isOwner]("GI.GLib.Structs.MainContext#g:method:isOwner"), [iteration]("GI.GLib.Structs.MainContext#g:method:iteration"), [pending]("GI.GLib.Structs.MainContext#g:method:pending"), [popThreadDefault]("GI.GLib.Structs.MainContext#g:method:popThreadDefault"), [prepare]("GI.GLib.Structs.MainContext#g:method:prepare"), [pushThreadDefault]("GI.GLib.Structs.MainContext#g:method:pushThreadDefault"), [query]("GI.GLib.Structs.MainContext#g:method:query"), [ref]("GI.GLib.Structs.MainContext#g:method:ref"), [release]("GI.GLib.Structs.MainContext#g:method:release"), [removePoll]("GI.GLib.Structs.MainContext#g:method:removePoll"), [unref]("GI.GLib.Structs.MainContext#g:method:unref"), [wait]("GI.GLib.Structs.MainContext#g:method:wait"), [wakeup]("GI.GLib.Structs.MainContext#g:method:wakeup").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMainContextMethod                ,
#endif

-- ** acquire #method:acquire#

#if defined(ENABLE_OVERLOADING)
    MainContextAcquireMethodInfo            ,
#endif
    mainContextAcquire                      ,


-- ** addPoll #method:addPoll#

#if defined(ENABLE_OVERLOADING)
    MainContextAddPollMethodInfo            ,
#endif
    mainContextAddPoll                      ,


-- ** check #method:check#

#if defined(ENABLE_OVERLOADING)
    MainContextCheckMethodInfo              ,
#endif
    mainContextCheck                        ,


-- ** default #method:default#

    mainContextDefault                      ,


-- ** dispatch #method:dispatch#

#if defined(ENABLE_OVERLOADING)
    MainContextDispatchMethodInfo           ,
#endif
    mainContextDispatch                     ,


-- ** findSourceByFuncsUserData #method:findSourceByFuncsUserData#

#if defined(ENABLE_OVERLOADING)
    MainContextFindSourceByFuncsUserDataMethodInfo,
#endif
    mainContextFindSourceByFuncsUserData    ,


-- ** findSourceById #method:findSourceById#

#if defined(ENABLE_OVERLOADING)
    MainContextFindSourceByIdMethodInfo     ,
#endif
    mainContextFindSourceById               ,


-- ** findSourceByUserData #method:findSourceByUserData#

#if defined(ENABLE_OVERLOADING)
    MainContextFindSourceByUserDataMethodInfo,
#endif
    mainContextFindSourceByUserData         ,


-- ** getThreadDefault #method:getThreadDefault#

    mainContextGetThreadDefault             ,


-- ** invokeFull #method:invokeFull#

#if defined(ENABLE_OVERLOADING)
    MainContextInvokeFullMethodInfo         ,
#endif
    mainContextInvokeFull                   ,


-- ** isOwner #method:isOwner#

#if defined(ENABLE_OVERLOADING)
    MainContextIsOwnerMethodInfo            ,
#endif
    mainContextIsOwner                      ,


-- ** iteration #method:iteration#

#if defined(ENABLE_OVERLOADING)
    MainContextIterationMethodInfo          ,
#endif
    mainContextIteration                    ,


-- ** new #method:new#

    mainContextNew                          ,


-- ** newWithFlags #method:newWithFlags#

    mainContextNewWithFlags                 ,


-- ** pending #method:pending#

#if defined(ENABLE_OVERLOADING)
    MainContextPendingMethodInfo            ,
#endif
    mainContextPending                      ,


-- ** popThreadDefault #method:popThreadDefault#

#if defined(ENABLE_OVERLOADING)
    MainContextPopThreadDefaultMethodInfo   ,
#endif
    mainContextPopThreadDefault             ,


-- ** prepare #method:prepare#

#if defined(ENABLE_OVERLOADING)
    MainContextPrepareMethodInfo            ,
#endif
    mainContextPrepare                      ,


-- ** pushThreadDefault #method:pushThreadDefault#

#if defined(ENABLE_OVERLOADING)
    MainContextPushThreadDefaultMethodInfo  ,
#endif
    mainContextPushThreadDefault            ,


-- ** query #method:query#

#if defined(ENABLE_OVERLOADING)
    MainContextQueryMethodInfo              ,
#endif
    mainContextQuery                        ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    MainContextRefMethodInfo                ,
#endif
    mainContextRef                          ,


-- ** refThreadDefault #method:refThreadDefault#

    mainContextRefThreadDefault             ,


-- ** release #method:release#

#if defined(ENABLE_OVERLOADING)
    MainContextReleaseMethodInfo            ,
#endif
    mainContextRelease                      ,


-- ** removePoll #method:removePoll#

#if defined(ENABLE_OVERLOADING)
    MainContextRemovePollMethodInfo         ,
#endif
    mainContextRemovePoll                   ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    MainContextUnrefMethodInfo              ,
#endif
    mainContextUnref                        ,


-- ** wait #method:wait#

#if defined(ENABLE_OVERLOADING)
    MainContextWaitMethodInfo               ,
#endif
    mainContextWait                         ,


-- ** wakeup #method:wakeup#

#if defined(ENABLE_OVERLOADING)
    MainContextWakeupMethodInfo             ,
#endif
    mainContextWakeup                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex

#endif

-- | Memory-managed wrapper type.
newtype MainContext = MainContext (SP.ManagedPtr MainContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype MainContext where
    toManagedPtr (MainContext p) = p

foreign import ccall "g_main_context_get_type" c_g_main_context_get_type :: 
    IO GType

type instance O.ParentTypes MainContext = '[]
instance O.HasParentTypes MainContext

instance B.Types.TypedObject MainContext where
    glibType = c_g_main_context_get_type

instance B.Types.GBoxed MainContext

-- | Convert 'MainContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MainContext) where
    gvalueGType_ = c_g_main_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr MainContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr MainContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed MainContext ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MainContext
type instance O.AttributeList MainContext = MainContextAttributeList
type MainContextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method MainContext::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_new" g_main_context_new :: 
    IO (Ptr MainContext)

-- | Creates a new [struct/@gLib@/.MainContext] structure.
mainContextNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MainContext
    -- ^ __Returns:__ the new t'GI.GLib.Structs.MainContext.MainContext'
mainContextNew  = liftIO $ do
    result <- g_main_context_new
    checkUnexpectedReturnNULL "mainContextNew" result
    result' <- (wrapBoxed MainContext) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MainContext::new_with_flags
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContextFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a bitwise-OR combination of #GMainContextFlags flags that can only be\n        set at creation time."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_new_with_flags" g_main_context_new_with_flags :: 
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "MainContextFlags"})
    IO (Ptr MainContext)

-- | Creates a new [struct/@gLib@/.MainContext] structure.
-- 
-- /Since: 2.72/
mainContextNewWithFlags ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [GLib.Flags.MainContextFlags]
    -- ^ /@flags@/: a bitwise-OR combination of t'GI.GLib.Flags.MainContextFlags' flags that can only be
    --         set at creation time.
    -> m MainContext
    -- ^ __Returns:__ the new t'GI.GLib.Structs.MainContext.MainContext'
mainContextNewWithFlags flags = liftIO $ do
    let flags' = gflagsToWord flags
    result <- g_main_context_new_with_flags flags'
    checkUnexpectedReturnNULL "mainContextNewWithFlags" result
    result' <- (wrapBoxed MainContext) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MainContext::acquire
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_acquire" g_main_context_acquire :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO CInt

-- | Tries to become the owner of the specified context.
-- If some other thread is the owner of the context,
-- returns 'P.False' immediately. Ownership is properly
-- recursive: the owner can require ownership again
-- and will release ownership when 'GI.GLib.Structs.MainContext.mainContextRelease'
-- is called as many times as 'GI.GLib.Structs.MainContext.mainContextAcquire'.
-- 
-- You must be the owner of a context before you
-- can call 'GI.GLib.Structs.MainContext.mainContextPrepare', 'GI.GLib.Structs.MainContext.mainContextQuery',
-- 'GI.GLib.Structs.MainContext.mainContextCheck', 'GI.GLib.Structs.MainContext.mainContextDispatch',
-- 'GI.GLib.Structs.MainContext.mainContextRelease'.
-- 
-- Since 2.76 /@context@/ can be 'P.Nothing' to use the global-default
-- main context.
mainContextAcquire ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the operation succeeded, and
    --   this thread is now the owner of /@context@/.
mainContextAcquire context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_main_context_acquire maybeContext
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextAcquireMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MainContextAcquireMethodInfo MainContext signature where
    overloadedMethod i = mainContextAcquire (Just i)

instance O.OverloadedMethodInfo MainContextAcquireMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextAcquire",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextAcquire"
        })


#endif

-- method MainContext::add_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (or %NULL for the global-default\n  main context)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GPollFD structure holding information about a file\n     descriptor to watch."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority for this file descriptor which should be\n     the same as the priority used for [method@GLib.Source.attach] to ensure\n     that the file descriptor is polled whenever the results may be needed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_add_poll" g_main_context_add_poll :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr GLib.PollFD.PollFD ->               -- fd : TInterface (Name {namespace = "GLib", name = "PollFD"})
    Int32 ->                                -- priority : TBasicType TInt
    IO ()

-- | Adds a file descriptor to the set of file descriptors polled for
-- this context. This will very seldom be used directly. Instead
-- a typical event source will use @g_source_add_unix_fd@ instead.
mainContextAddPoll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (or 'P.Nothing' for the global-default
    --   main context)
    -> GLib.PollFD.PollFD
    -- ^ /@fd@/: a t'GI.GLib.Structs.PollFD.PollFD' structure holding information about a file
    --      descriptor to watch.
    -> Int32
    -- ^ /@priority@/: the priority for this file descriptor which should be
    --      the same as the priority used for 'GI.GLib.Structs.Source.sourceAttach' to ensure
    --      that the file descriptor is polled whenever the results may be needed.
    -> m ()
mainContextAddPoll context fd priority = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    fd' <- unsafeManagedPtrGetPtr fd
    g_main_context_add_poll maybeContext fd' priority
    whenJust context touchManagedPtr
    touchManagedPtr fd
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextAddPollMethodInfo
instance (signature ~ (GLib.PollFD.PollFD -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod MainContextAddPollMethodInfo MainContext signature where
    overloadedMethod i = mainContextAddPoll (Just i)

instance O.OverloadedMethodInfo MainContextAddPollMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextAddPoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextAddPoll"
        })


#endif

-- method MainContext::check
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the maximum numerical priority of sources to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fds"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 3
--                 (TInterface Name { namespace = "GLib" , name = "PollFD" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "array of #GPollFD's that was passed to\n      the last call to [method@GLib.MainContext.query]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fds"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return value of [method@GLib.MainContext.query]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fds"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "return value of [method@GLib.MainContext.query]"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_check" g_main_context_check :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Int32 ->                                -- max_priority : TBasicType TInt
    Ptr GLib.PollFD.PollFD ->               -- fds : TCArray False (-1) 3 (TInterface (Name {namespace = "GLib", name = "PollFD"}))
    Int32 ->                                -- n_fds : TBasicType TInt
    IO CInt

-- | Passes the results of polling back to the main loop. You should be
-- careful to pass /@fds@/ and its length /@nFds@/ as received from
-- 'GI.GLib.Structs.MainContext.mainContextQuery', as this functions relies on assumptions
-- on how /@fds@/ is filled.
-- 
-- You must have successfully acquired the context with
-- 'GI.GLib.Structs.MainContext.mainContextAcquire' before you may call this function.
-- 
-- Since 2.76 /@context@/ can be 'P.Nothing' to use the global-default
-- main context.
mainContextCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> Int32
    -- ^ /@maxPriority@/: the maximum numerical priority of sources to check
    -> [GLib.PollFD.PollFD]
    -- ^ /@fds@/: array of t'GI.GLib.Structs.PollFD.PollFD'\'s that was passed to
    --       the last call to 'GI.GLib.Structs.MainContext.mainContextQuery'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if some sources are ready to be dispatched.
mainContextCheck context maxPriority fds = liftIO $ do
    let nFds = fromIntegral $ P.length fds
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    fds' <- mapM unsafeManagedPtrGetPtr fds
    fds'' <- packBlockArray 8 fds'
    result <- g_main_context_check maybeContext maxPriority fds'' nFds
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    mapM_ touchManagedPtr fds
    freeMem fds''
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextCheckMethodInfo
instance (signature ~ (Int32 -> [GLib.PollFD.PollFD] -> m Bool), MonadIO m) => O.OverloadedMethod MainContextCheckMethodInfo MainContext signature where
    overloadedMethod i = mainContextCheck (Just i)

instance O.OverloadedMethodInfo MainContextCheckMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextCheck",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextCheck"
        })


#endif

-- method MainContext::dispatch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_dispatch" g_main_context_dispatch :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | Dispatches all pending sources.
-- 
-- You must have successfully acquired the context with
-- 'GI.GLib.Structs.MainContext.mainContextAcquire' before you may call this function.
-- 
-- Since 2.76 /@context@/ can be 'P.Nothing' to use the global-default
-- main context.
mainContextDispatch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m ()
mainContextDispatch context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    g_main_context_dispatch maybeContext
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextDispatchMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextDispatchMethodInfo MainContext signature where
    overloadedMethod i = mainContextDispatch (Just i)

instance O.OverloadedMethodInfo MainContextDispatchMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextDispatch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextDispatch"
        })


#endif

-- method MainContext::find_source_by_funcs_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "funcs"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFuncs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the @source_funcs passed to [ctor@GLib.Source.new]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the user data from the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_find_source_by_funcs_user_data" g_main_context_find_source_by_funcs_user_data :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr GLib.SourceFuncs.SourceFuncs ->     -- funcs : TInterface (Name {namespace = "GLib", name = "SourceFuncs"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr GLib.Source.Source)

-- | Finds a source with the given source functions and user data.  If
-- multiple sources exist with the same source function and user data,
-- the first one found will be returned.
mainContextFindSourceByFuncsUserData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used).
    -> GLib.SourceFuncs.SourceFuncs
    -- ^ /@funcs@/: the /@sourceFuncs@/ passed to 'GI.GLib.Structs.Source.sourceNew'.
    -> Ptr ()
    -- ^ /@userData@/: the user data from the callback.
    -> m GLib.Source.Source
    -- ^ __Returns:__ the source, if one was found, otherwise 'P.Nothing'
mainContextFindSourceByFuncsUserData context funcs userData = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    funcs' <- unsafeManagedPtrGetPtr funcs
    result <- g_main_context_find_source_by_funcs_user_data maybeContext funcs' userData
    checkUnexpectedReturnNULL "mainContextFindSourceByFuncsUserData" result
    result' <- (newBoxed GLib.Source.Source) result
    whenJust context touchManagedPtr
    touchManagedPtr funcs
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextFindSourceByFuncsUserDataMethodInfo
instance (signature ~ (GLib.SourceFuncs.SourceFuncs -> Ptr () -> m GLib.Source.Source), MonadIO m) => O.OverloadedMethod MainContextFindSourceByFuncsUserDataMethodInfo MainContext signature where
    overloadedMethod i = mainContextFindSourceByFuncsUserData (Just i)

instance O.OverloadedMethodInfo MainContextFindSourceByFuncsUserDataMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextFindSourceByFuncsUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextFindSourceByFuncsUserData"
        })


#endif

-- method MainContext::find_source_by_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the source ID, as returned by [method@GLib.Source.get_id]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_find_source_by_id" g_main_context_find_source_by_id :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Word32 ->                               -- source_id : TBasicType TUInt
    IO (Ptr GLib.Source.Source)

-- | Finds a t'GI.GLib.Structs.Source.Source' given a pair of context and ID.
-- 
-- It is a programmer error to attempt to look up a non-existent source.
-- 
-- More specifically: source IDs can be reissued after a source has been
-- destroyed and therefore it is never valid to use this function with a
-- source ID which may have already been removed.  An example is when
-- scheduling an idle to run in another thread with 'GI.GLib.Functions.idleAdd': the
-- idle may already have run and been removed by the time this function
-- is called on its (now invalid) source ID.  This source ID may have
-- been reissued, leading to the operation being performed against the
-- wrong source.
mainContextFindSourceById ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> Word32
    -- ^ /@sourceId@/: the source ID, as returned by 'GI.GLib.Structs.Source.sourceGetId'.
    -> m GLib.Source.Source
    -- ^ __Returns:__ the t'GI.GLib.Structs.Source.Source'
mainContextFindSourceById context sourceId = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_main_context_find_source_by_id maybeContext sourceId
    checkUnexpectedReturnNULL "mainContextFindSourceById" result
    result' <- (newBoxed GLib.Source.Source) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextFindSourceByIdMethodInfo
instance (signature ~ (Word32 -> m GLib.Source.Source), MonadIO m) => O.OverloadedMethod MainContextFindSourceByIdMethodInfo MainContext signature where
    overloadedMethod i = mainContextFindSourceById (Just i)

instance O.OverloadedMethodInfo MainContextFindSourceByIdMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextFindSourceById",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextFindSourceById"
        })


#endif

-- method MainContext::find_source_by_user_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the user_data for the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_find_source_by_user_data" g_main_context_find_source_by_user_data :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO (Ptr GLib.Source.Source)

-- | Finds a source with the given user data for the callback.  If
-- multiple sources exist with the same user data, the first
-- one found will be returned.
mainContextFindSourceByUserData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> Ptr ()
    -- ^ /@userData@/: the user_data for the callback.
    -> m GLib.Source.Source
    -- ^ __Returns:__ the source, if one was found, otherwise 'P.Nothing'
mainContextFindSourceByUserData context userData = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_main_context_find_source_by_user_data maybeContext userData
    checkUnexpectedReturnNULL "mainContextFindSourceByUserData" result
    result' <- (newBoxed GLib.Source.Source) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextFindSourceByUserDataMethodInfo
instance (signature ~ (Ptr () -> m GLib.Source.Source), MonadIO m) => O.OverloadedMethod MainContextFindSourceByUserDataMethodInfo MainContext signature where
    overloadedMethod i = mainContextFindSourceByUserData (Just i)

instance O.OverloadedMethodInfo MainContextFindSourceByUserDataMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextFindSourceByUserData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextFindSourceByUserData"
        })


#endif

-- method MainContext::invoke_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext, or %NULL for the global-default\n  main context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the priority at which to run @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a function to call when @data is no longer in use, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_invoke_full" g_main_context_invoke_full :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Int32 ->                                -- priority : TBasicType TInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Invokes a function in such a way that /@context@/ is owned during the
-- invocation of /@function@/.
-- 
-- This function is the same as t'GI.GLib.Structs.MainContext.MainContext'.@/invoke/@() except that it
-- lets you specify the priority in case /@function@/ ends up being
-- scheduled as an idle and also lets you give a t'GI.GLib.Callbacks.DestroyNotify' for /@data@/.
-- 
-- /@notify@/ should not assume that it is called from any particular
-- thread or with any particular context acquired.
-- 
-- /Since: 2.28/
mainContextInvokeFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext', or 'P.Nothing' for the global-default
    --   main context
    -> Int32
    -- ^ /@priority@/: the priority at which to run /@function@/
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m ()
mainContextInvokeFull context priority function = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    g_main_context_invoke_full maybeContext priority function' data_ notify
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextInvokeFullMethodInfo
instance (signature ~ (Int32 -> GLib.Callbacks.SourceFunc -> m ()), MonadIO m) => O.OverloadedMethod MainContextInvokeFullMethodInfo MainContext signature where
    overloadedMethod i = mainContextInvokeFull (Just i)

instance O.OverloadedMethodInfo MainContextInvokeFullMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextInvokeFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextInvokeFull"
        })


#endif

-- method MainContext::is_owner
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_is_owner" g_main_context_is_owner :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO CInt

-- | Determines whether this thread holds the (recursive)
-- ownership of this [struct/@gLib@/.MainContext]. This is useful to
-- know before waiting on another thread that may be
-- blocking to get ownership of /@context@/.
-- 
-- /Since: 2.10/
mainContextIsOwner ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m Bool
    -- ^ __Returns:__ 'P.True' if current thread is owner of /@context@/.
mainContextIsOwner context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_main_context_is_owner maybeContext
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextIsOwnerMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MainContextIsOwnerMethodInfo MainContext signature where
    overloadedMethod i = mainContextIsOwner (Just i)

instance O.OverloadedMethodInfo MainContextIsOwnerMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextIsOwner",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextIsOwner"
        })


#endif

-- method MainContext::iteration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "may_block"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the call may block."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_iteration" g_main_context_iteration :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    CInt ->                                 -- may_block : TBasicType TBoolean
    IO CInt

-- | Runs a single iteration for the given main loop. This involves
-- checking to see if any event sources are ready to be processed,
-- then if no events sources are ready and /@mayBlock@/ is 'P.True', waiting
-- for a source to become ready, then dispatching the highest priority
-- events sources that are ready. Otherwise, if /@mayBlock@/ is 'P.False'
-- sources are not waited to become ready, only those highest priority
-- events sources will be dispatched (if any), that are ready at this
-- given moment without further waiting.
-- 
-- Note that even when /@mayBlock@/ is 'P.True', it is still possible for
-- 'GI.GLib.Structs.MainContext.mainContextIteration' to return 'P.False', since the wait may
-- be interrupted for other reasons than an event source becoming ready.
mainContextIteration ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> Bool
    -- ^ /@mayBlock@/: whether the call may block.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if events were dispatched.
mainContextIteration context mayBlock = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    let mayBlock' = (P.fromIntegral . P.fromEnum) mayBlock
    result <- g_main_context_iteration maybeContext mayBlock'
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextIterationMethodInfo
instance (signature ~ (Bool -> m Bool), MonadIO m) => O.OverloadedMethod MainContextIterationMethodInfo MainContext signature where
    overloadedMethod i = mainContextIteration (Just i)

instance O.OverloadedMethodInfo MainContextIterationMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextIteration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextIteration"
        })


#endif

-- method MainContext::pending
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_pending" g_main_context_pending :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO CInt

-- | Checks if any sources have pending events for the given context.
mainContextPending ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m Bool
    -- ^ __Returns:__ 'P.True' if events are pending.
mainContextPending context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    result <- g_main_context_pending maybeContext
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextPendingMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod MainContextPendingMethodInfo MainContext signature where
    overloadedMethod i = mainContextPending (Just i)

instance O.OverloadedMethodInfo MainContextPendingMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextPending",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextPending"
        })


#endif

-- method MainContext::pop_thread_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext, or %NULL for the global-default\n  main context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_pop_thread_default" g_main_context_pop_thread_default :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | Pops /@context@/ off the thread-default context stack (verifying that
-- it was on the top of the stack).
-- 
-- /Since: 2.22/
mainContextPopThreadDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext', or 'P.Nothing' for the global-default
    --   main context
    -> m ()
mainContextPopThreadDefault context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    g_main_context_pop_thread_default maybeContext
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextPopThreadDefaultMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextPopThreadDefaultMethodInfo MainContext signature where
    overloadedMethod i = mainContextPopThreadDefault (Just i)

instance O.OverloadedMethodInfo MainContextPopThreadDefaultMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextPopThreadDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextPopThreadDefault"
        })


#endif

-- method MainContext::prepare
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store priority of highest priority\n           source already ready."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_prepare" g_main_context_prepare :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr Int32 ->                            -- priority : TBasicType TInt
    IO CInt

-- | Prepares to poll sources within a main loop. The resulting information
-- for polling is determined by calling 'GI.GLib.Structs.MainContext.mainContextQuery'.
-- 
-- You must have successfully acquired the context with
-- 'GI.GLib.Structs.MainContext.mainContextAcquire' before you may call this function.
mainContextPrepare ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m ((Bool, Int32))
    -- ^ __Returns:__ 'P.True' if some source is ready to be dispatched
    --               prior to polling.
mainContextPrepare context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    priority <- allocMem :: IO (Ptr Int32)
    result <- g_main_context_prepare maybeContext priority
    let result' = (/= 0) result
    priority' <- peek priority
    whenJust context touchManagedPtr
    freeMem priority
    return (result', priority')

#if defined(ENABLE_OVERLOADING)
data MainContextPrepareMethodInfo
instance (signature ~ (m ((Bool, Int32))), MonadIO m) => O.OverloadedMethod MainContextPrepareMethodInfo MainContext signature where
    overloadedMethod i = mainContextPrepare (Just i)

instance O.OverloadedMethodInfo MainContextPrepareMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextPrepare",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextPrepare"
        })


#endif

-- method MainContext::push_thread_default
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext, or %NULL for the global-default\n  main context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_push_thread_default" g_main_context_push_thread_default :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | Acquires /@context@/ and sets it as the thread-default context for the
-- current thread. This will cause certain asynchronous operations
-- (such as most <http://developer.gnome.org/glib/stable/../gio/index.html Gio>-based I\/O) which are
-- started in this thread to run under /@context@/ and deliver their
-- results to its main loop, rather than running under the global
-- default main context in the main thread. Note that calling this function
-- changes the context returned by [func/@gLib@/.MainContext.get_thread_default],
-- not the one returned by [func/@gLib@/.MainContext.default], so it does not
-- affect the context used by functions like 'GI.GLib.Functions.idleAdd'.
-- 
-- Normally you would call this function shortly after creating a new
-- thread, passing it a [struct/@gLib@/.MainContext] which will be run by a
-- [struct/@gLib@/.MainLoop] in that thread, to set a new default context for all
-- async operations in that thread. In this case you may not need to
-- ever call 'GI.GLib.Structs.MainContext.mainContextPopThreadDefault', assuming you want
-- the new [struct/@gLib@/.MainContext] to be the default for the whole lifecycle
-- of the thread.
-- 
-- If you don\'t have control over how the new thread was created (e.g.
-- in the new thread isn\'t newly created, or if the thread life
-- cycle is managed by a t'GI.GLib.Structs.ThreadPool.ThreadPool'), it is always suggested to wrap
-- the logic that needs to use the new [struct/@gLib@/.MainContext] inside a
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault' \/
-- 'GI.GLib.Structs.MainContext.mainContextPopThreadDefault' pair, otherwise threads that
-- are re-used will end up never explicitly releasing the
-- [struct/@gLib@/.MainContext] reference they hold.
-- 
-- In some cases you may want to schedule a single operation in a
-- non-default context, or temporarily use a non-default context in
-- the main thread. In that case, you can wrap the call to the
-- asynchronous operation inside a
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault' \/
-- 'GI.GLib.Structs.MainContext.mainContextPopThreadDefault' pair, but it is up to you to
-- ensure that no other asynchronous operations accidentally get
-- started while the non-default context is active.
-- 
-- Beware that libraries that predate this function may not correctly
-- handle being used from a thread with a thread-default context. Eg,
-- see @/g_file_supports_thread_contexts()/@.
-- 
-- /Since: 2.22/
mainContextPushThreadDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext', or 'P.Nothing' for the global-default
    --   main context
    -> m ()
mainContextPushThreadDefault context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    g_main_context_push_thread_default maybeContext
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextPushThreadDefaultMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextPushThreadDefaultMethodInfo MainContext signature where
    overloadedMethod i = mainContextPushThreadDefault (Just i)

instance O.OverloadedMethodInfo MainContextPushThreadDefaultMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextPushThreadDefault",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextPushThreadDefault"
        })


#endif

-- XXX Could not generate method MainContext::pusher_new
-- Bad introspection data: Could not resolve the symbol “g_main_context_pusher_new” in the “GLib” namespace, ignoring.
-- method MainContext::query
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum priority source to check"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store timeout to be used in polling"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "fds"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "GLib" , name = "PollFD" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to\n      store #GPollFD records that need to be polled."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fds"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @fds." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fds"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of @fds." , sinceVersion = Nothing }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_query" g_main_context_query :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Int32 ->                                -- max_priority : TBasicType TInt
    Ptr Int32 ->                            -- timeout_ : TBasicType TInt
    Ptr GLib.PollFD.PollFD ->               -- fds : TCArray False (-1) 4 (TInterface (Name {namespace = "GLib", name = "PollFD"}))
    Int32 ->                                -- n_fds : TBasicType TInt
    IO Int32

-- | Determines information necessary to poll this main loop. You should
-- be careful to pass the resulting /@fds@/ array and its length /@nFds@/
-- as is when calling 'GI.GLib.Structs.MainContext.mainContextCheck', as this function relies
-- on assumptions made when the array is filled.
-- 
-- You must have successfully acquired the context with
-- 'GI.GLib.Structs.MainContext.mainContextAcquire' before you may call this function.
mainContextQuery ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> Int32
    -- ^ /@maxPriority@/: maximum priority source to check
    -> [GLib.PollFD.PollFD]
    -- ^ /@fds@/: location to
    --       store t'GI.GLib.Structs.PollFD.PollFD' records that need to be polled.
    -> m ((Int32, Int32, [GLib.PollFD.PollFD]))
    -- ^ __Returns:__ the number of records actually stored in /@fds@/,
    --   or, if more than /@nFds@/ records need to be stored, the number
    --   of records that need to be stored.
mainContextQuery context maxPriority fds = liftIO $ do
    let nFds = fromIntegral $ P.length fds
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    timeout_ <- allocMem :: IO (Ptr Int32)
    fds' <- mapM B.ManagedPtr.disownBoxed fds
    fds'' <- packBlockArray 8 fds'
    result <- g_main_context_query maybeContext maxPriority timeout_ fds'' nFds
    timeout_' <- peek timeout_
    fds''' <- (unpackBoxedArrayWithLength 8 nFds) fds''
    fds'''' <- mapM (wrapBoxed GLib.PollFD.PollFD) fds'''
    freeMem fds''
    whenJust context touchManagedPtr
    mapM_ touchManagedPtr fds
    freeMem timeout_
    return (result, timeout_', fds'''')

#if defined(ENABLE_OVERLOADING)
data MainContextQueryMethodInfo
instance (signature ~ (Int32 -> [GLib.PollFD.PollFD] -> m ((Int32, Int32, [GLib.PollFD.PollFD]))), MonadIO m) => O.OverloadedMethod MainContextQueryMethodInfo MainContext signature where
    overloadedMethod i = mainContextQuery (Just i)

instance O.OverloadedMethodInfo MainContextQueryMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextQuery",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextQuery"
        })


#endif

-- method MainContext::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_ref" g_main_context_ref :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO (Ptr MainContext)

-- | Increases the reference count on a [struct/@gLib@/.MainContext] object by one.
mainContextRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext'
    -> m MainContext
    -- ^ __Returns:__ the /@context@/ that was passed in (since 2.6)
mainContextRef context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    result <- g_main_context_ref context'
    checkUnexpectedReturnNULL "mainContextRef" result
    result' <- (wrapBoxed MainContext) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextRefMethodInfo
instance (signature ~ (m MainContext), MonadIO m) => O.OverloadedMethod MainContextRefMethodInfo MainContext signature where
    overloadedMethod = mainContextRef

instance O.OverloadedMethodInfo MainContextRefMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextRef"
        })


#endif

-- method MainContext::release
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_release" g_main_context_release :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | Releases ownership of a context previously acquired by this thread
-- with 'GI.GLib.Structs.MainContext.mainContextAcquire'. If the context was acquired multiple
-- times, the ownership will be released only when 'GI.GLib.Structs.MainContext.mainContextRelease'
-- is called as many times as it was acquired.
-- 
-- You must have successfully acquired the context with
-- 'GI.GLib.Structs.MainContext.mainContextAcquire' before you may call this function.
mainContextRelease ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m ()
mainContextRelease context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    g_main_context_release maybeContext
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextReleaseMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextReleaseMethodInfo MainContext signature where
    overloadedMethod i = mainContextRelease (Just i)

instance O.OverloadedMethodInfo MainContextReleaseMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextRelease",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextRelease"
        })


#endif

-- method MainContext::remove_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GPollFD descriptor previously added with\n  [method@GLib.MainContext.add_poll]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_remove_poll" g_main_context_remove_poll :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr GLib.PollFD.PollFD ->               -- fd : TInterface (Name {namespace = "GLib", name = "PollFD"})
    IO ()

-- | Removes file descriptor from the set of file descriptors to be
-- polled for a particular context.
mainContextRemovePoll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> GLib.PollFD.PollFD
    -- ^ /@fd@/: a t'GI.GLib.Structs.PollFD.PollFD' descriptor previously added with
    --   'GI.GLib.Structs.MainContext.mainContextAddPoll'
    -> m ()
mainContextRemovePoll context fd = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    fd' <- unsafeManagedPtrGetPtr fd
    g_main_context_remove_poll maybeContext fd'
    whenJust context touchManagedPtr
    touchManagedPtr fd
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextRemovePollMethodInfo
instance (signature ~ (GLib.PollFD.PollFD -> m ()), MonadIO m) => O.OverloadedMethod MainContextRemovePollMethodInfo MainContext signature where
    overloadedMethod i = mainContextRemovePoll (Just i)

instance O.OverloadedMethodInfo MainContextRemovePollMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextRemovePoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextRemovePoll"
        })


#endif

-- method MainContext::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMainContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_unref" g_main_context_unref :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | Decreases the reference count on a [struct/@gLib@/.MainContext] object by one.
-- If
-- the result is zero, free the context and free all associated memory.
mainContextUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    MainContext
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext'
    -> m ()
mainContextUnref context = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    g_main_context_unref context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextUnrefMethodInfo MainContext signature where
    overloadedMethod = mainContextUnref

instance O.OverloadedMethodInfo MainContextUnrefMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextUnref"
        })


#endif

-- method MainContext::wait
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cond"
--           , argType = TInterface Name { namespace = "GLib" , name = "Cond" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a condition variable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mutex"
--           , argType = TInterface Name { namespace = "GLib" , name = "Mutex" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mutex, currently held"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_wait" g_main_context_wait :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    Ptr GLib.Cond.Cond ->                   -- cond : TInterface (Name {namespace = "GLib", name = "Cond"})
    Ptr GLib.Mutex.Mutex ->                 -- mutex : TInterface (Name {namespace = "GLib", name = "Mutex"})
    IO CInt

{-# DEPRECATED mainContextWait ["(Since version 2.58)","Use 'GI.GLib.Structs.MainContext.mainContextIsOwner' and separate","   locking instead."] #-}
-- | Tries to become the owner of the specified context,
-- as with 'GI.GLib.Structs.MainContext.mainContextAcquire'. But if another thread
-- is the owner, atomically drop /@mutex@/ and wait on /@cond@/ until
-- that owner releases ownership or until /@cond@/ is signaled, then
-- try again (once) to become the owner.
mainContextWait ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> GLib.Cond.Cond
    -- ^ /@cond@/: a condition variable
    -> GLib.Mutex.Mutex
    -- ^ /@mutex@/: a mutex, currently held
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the operation succeeded, and
    --   this thread is now the owner of /@context@/.
mainContextWait context cond mutex = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    cond' <- unsafeManagedPtrGetPtr cond
    mutex' <- unsafeManagedPtrGetPtr mutex
    result <- g_main_context_wait maybeContext cond' mutex'
    let result' = (/= 0) result
    whenJust context touchManagedPtr
    touchManagedPtr cond
    touchManagedPtr mutex
    return result'

#if defined(ENABLE_OVERLOADING)
data MainContextWaitMethodInfo
instance (signature ~ (GLib.Cond.Cond -> GLib.Mutex.Mutex -> m Bool), MonadIO m) => O.OverloadedMethod MainContextWaitMethodInfo MainContext signature where
    overloadedMethod i = mainContextWait (Just i)

instance O.OverloadedMethodInfo MainContextWaitMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextWait",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextWait"
        })


#endif

-- method MainContext::wakeup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MainContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GMainContext (if %NULL, the global-default\n  main context will be used)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_wakeup" g_main_context_wakeup :: 
    Ptr MainContext ->                      -- context : TInterface (Name {namespace = "GLib", name = "MainContext"})
    IO ()

-- | If /@context@/ is currently blocking in 'GI.GLib.Structs.MainContext.mainContextIteration'
-- waiting for a source to become ready, cause it to stop blocking
-- and return.  Otherwise, cause the next invocation of
-- 'GI.GLib.Structs.MainContext.mainContextIteration' to return without blocking.
-- 
-- This API is useful for low-level control over [struct/@gLib@/.MainContext]; for
-- example, integrating it with main loop implementations such as
-- [struct/@gLib@/.MainLoop].
-- 
-- Another related use for this function is when implementing a main
-- loop with a termination condition, computed from multiple threads:
-- 
-- 
-- === /C code/
-- >
-- >  #define NUM_TASKS 10
-- >  static gint tasks_remaining = NUM_TASKS;  // (atomic)
-- >  ...
-- > 
-- >  while (g_atomic_int_get (&tasks_remaining) != 0)
-- >    g_main_context_iteration (NULL, TRUE);
-- 
--  
-- Then in a thread:
-- 
-- === /C code/
-- >
-- >  perform_work();
-- >
-- >  if (g_atomic_int_dec_and_test (&tasks_remaining))
-- >    g_main_context_wakeup (NULL);
mainContextWakeup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (MainContext)
    -- ^ /@context@/: a t'GI.GLib.Structs.MainContext.MainContext' (if 'P.Nothing', the global-default
    --   main context will be used)
    -> m ()
mainContextWakeup context = liftIO $ do
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrGetPtr jContext
            return jContext'
    g_main_context_wakeup maybeContext
    whenJust context touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MainContextWakeupMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod MainContextWakeupMethodInfo MainContext signature where
    overloadedMethod i = mainContextWakeup (Just i)

instance O.OverloadedMethodInfo MainContextWakeupMethodInfo MainContext where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.MainContext.mainContextWakeup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-MainContext.html#v:mainContextWakeup"
        })


#endif

-- method MainContext::default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_default" g_main_context_default :: 
    IO (Ptr MainContext)

-- | Returns the global-default main context. This is the main context
-- used for main loop functions when a main loop is not explicitly
-- specified, and corresponds to the \"main\" main loop. See also
-- [func/@gLib@/.MainContext.get_thread_default].
mainContextDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MainContext
    -- ^ __Returns:__ the global-default main context.
mainContextDefault  = liftIO $ do
    result <- g_main_context_default
    checkUnexpectedReturnNULL "mainContextDefault" result
    result' <- (newBoxed MainContext) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MainContext::get_thread_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_get_thread_default" g_main_context_get_thread_default :: 
    IO (Ptr MainContext)

-- | Gets the thread-default t'GI.GLib.Structs.MainContext.MainContext' for this thread. Asynchronous
-- operations that want to be able to be run in contexts other than
-- the default one should call this method or
-- [func/@gLib@/.MainContext.ref_thread_default] to get a
-- [struct/@gLib@/.MainContext] to add their [struct/@gLib@/.Source]s to. (Note that
-- even in single-threaded programs applications may sometimes want to
-- temporarily push a non-default context, so it is not safe to assume that
-- this will always return 'P.Nothing' if you are running in the default thread.)
-- 
-- If you need to hold a reference on the context, use
-- [func/@gLib@/.MainContext.ref_thread_default] instead.
-- 
-- /Since: 2.22/
mainContextGetThreadDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe MainContext)
    -- ^ __Returns:__ the thread-default t'GI.GLib.Structs.MainContext.MainContext', or
    -- 'P.Nothing' if the thread-default context is the global-default main context.
mainContextGetThreadDefault  = liftIO $ do
    result <- g_main_context_get_thread_default
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed MainContext) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method MainContext::ref_thread_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "MainContext" })
-- throws : False
-- Skip return : False

foreign import ccall "g_main_context_ref_thread_default" g_main_context_ref_thread_default :: 
    IO (Ptr MainContext)

-- | Gets the thread-default [struct/@gLib@/.MainContext] for this thread, as with
-- [func/@gLib@/.MainContext.get_thread_default], but also adds a reference to
-- it with 'GI.GLib.Structs.MainContext.mainContextRef'. In addition, unlike
-- [func/@gLib@/.MainContext.get_thread_default], if the thread-default context
-- is the global-default context, this will return that
-- [struct/@gLib@/.MainContext] (with a ref added to it) rather than returning
-- 'P.Nothing'.
-- 
-- /Since: 2.32/
mainContextRefThreadDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MainContext
    -- ^ __Returns:__ the thread-default t'GI.GLib.Structs.MainContext.MainContext'. Unref
    --     with 'GI.GLib.Structs.MainContext.mainContextUnref' when you are done with it.
mainContextRefThreadDefault  = liftIO $ do
    result <- g_main_context_ref_thread_default
    checkUnexpectedReturnNULL "mainContextRefThreadDefault" result
    result' <- (wrapBoxed MainContext) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMainContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMainContextMethod "acquire" o = MainContextAcquireMethodInfo
    ResolveMainContextMethod "addPoll" o = MainContextAddPollMethodInfo
    ResolveMainContextMethod "check" o = MainContextCheckMethodInfo
    ResolveMainContextMethod "dispatch" o = MainContextDispatchMethodInfo
    ResolveMainContextMethod "findSourceByFuncsUserData" o = MainContextFindSourceByFuncsUserDataMethodInfo
    ResolveMainContextMethod "findSourceById" o = MainContextFindSourceByIdMethodInfo
    ResolveMainContextMethod "findSourceByUserData" o = MainContextFindSourceByUserDataMethodInfo
    ResolveMainContextMethod "invokeFull" o = MainContextInvokeFullMethodInfo
    ResolveMainContextMethod "isOwner" o = MainContextIsOwnerMethodInfo
    ResolveMainContextMethod "iteration" o = MainContextIterationMethodInfo
    ResolveMainContextMethod "pending" o = MainContextPendingMethodInfo
    ResolveMainContextMethod "popThreadDefault" o = MainContextPopThreadDefaultMethodInfo
    ResolveMainContextMethod "prepare" o = MainContextPrepareMethodInfo
    ResolveMainContextMethod "pushThreadDefault" o = MainContextPushThreadDefaultMethodInfo
    ResolveMainContextMethod "query" o = MainContextQueryMethodInfo
    ResolveMainContextMethod "ref" o = MainContextRefMethodInfo
    ResolveMainContextMethod "release" o = MainContextReleaseMethodInfo
    ResolveMainContextMethod "removePoll" o = MainContextRemovePollMethodInfo
    ResolveMainContextMethod "unref" o = MainContextUnrefMethodInfo
    ResolveMainContextMethod "wait" o = MainContextWaitMethodInfo
    ResolveMainContextMethod "wakeup" o = MainContextWakeupMethodInfo
    ResolveMainContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMainContextMethod t MainContext, O.OverloadedMethod info MainContext p) => OL.IsLabel t (MainContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMainContextMethod t MainContext, O.OverloadedMethod info MainContext p, R.HasField t MainContext p) => R.HasField t MainContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMainContextMethod t MainContext, O.OverloadedMethodInfo info MainContext) => OL.IsLabel t (O.MethodProxy info MainContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


