{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A table of functions used to handle different types of t'GI.GLib.Structs.IOChannel.IOChannel'
-- in a generic way.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.IOFuncs
    ( 

-- * Exported types
    IOFuncs(..)                             ,
    newZeroIOFuncs                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveIOFuncsMethod                    ,
#endif



 -- * Properties


-- ** ioClose #attr:ioClose#
-- | closes the channel.  This is called from
--            'GI.GLib.Structs.IOChannel.iOChannelClose' after flushing the buffers.

    clearIOFuncsIoClose                     ,
    getIOFuncsIoClose                       ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioClose                         ,
#endif
    setIOFuncsIoClose                       ,


-- ** ioCreateWatch #attr:ioCreateWatch#
-- | creates a watch on the channel.  This call
--                   corresponds directly to 'GI.GLib.Functions.ioCreateWatch'.

    clearIOFuncsIoCreateWatch               ,
    getIOFuncsIoCreateWatch                 ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioCreateWatch                   ,
#endif
    setIOFuncsIoCreateWatch                 ,


-- ** ioFree #attr:ioFree#
-- | called from 'GI.GLib.Structs.IOChannel.iOChannelUnref' when the channel needs to
--           be freed.  This function must free the memory associated
--           with the channel, including freeing the t'GI.GLib.Structs.IOChannel.IOChannel'
--           structure itself.  The channel buffers have been flushed
--           and possibly /@ioClose@/ has been called by the time this
--           function is called.

    clearIOFuncsIoFree                      ,
    getIOFuncsIoFree                        ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioFree                          ,
#endif
    setIOFuncsIoFree                        ,


-- ** ioGetFlags #attr:ioGetFlags#
-- | gets the t'GI.GLib.Flags.IOFlags' for the channel.  This function
--                need only return the 'GI.GLib.Flags.IOFlagsAppend' and
--                'GI.GLib.Flags.IOFlagsNonblock' flags; 'GI.GLib.Structs.IOChannel.iOChannelGetFlags'
--                automatically adds the others as appropriate.

    clearIOFuncsIoGetFlags                  ,
    getIOFuncsIoGetFlags                    ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioGetFlags                      ,
#endif
    setIOFuncsIoGetFlags                    ,


-- ** ioRead #attr:ioRead#
-- | reads raw bytes from the channel.  This is called from
--           various functions such as 'GI.GLib.Structs.IOChannel.iOChannelReadChars' to
--           read raw bytes from the channel.  Encoding and buffering
--           issues are dealt with at a higher level.

    clearIOFuncsIoRead                      ,
    getIOFuncsIoRead                        ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioRead                          ,
#endif
    setIOFuncsIoRead                        ,


-- ** ioSeek #attr:ioSeek#
-- | seeks the channel.  This is called from
--           'GI.GLib.Structs.IOChannel.iOChannelSeek' on channels that support it.

    clearIOFuncsIoSeek                      ,
    getIOFuncsIoSeek                        ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioSeek                          ,
#endif
    setIOFuncsIoSeek                        ,


-- ** ioSetFlags #attr:ioSetFlags#
-- | sets the t'GI.GLib.Flags.IOFlags' on the channel.  This is called
--                from 'GI.GLib.Structs.IOChannel.iOChannelSetFlags' with all flags except
--                for 'GI.GLib.Flags.IOFlagsAppend' and 'GI.GLib.Flags.IOFlagsNonblock' masked
--                out.

    clearIOFuncsIoSetFlags                  ,
    getIOFuncsIoSetFlags                    ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioSetFlags                      ,
#endif
    setIOFuncsIoSetFlags                    ,


-- ** ioWrite #attr:ioWrite#
-- | writes raw bytes to the channel.  This is called from
--            various functions such as 'GI.GLib.Structs.IOChannel.iOChannelWriteChars' to
--            write raw bytes to the channel.  Encoding and buffering
--            issues are dealt with at a higher level.

    clearIOFuncsIoWrite                     ,
    getIOFuncsIoWrite                       ,
#if defined(ENABLE_OVERLOADING)
    iOFuncs_ioWrite                         ,
#endif
    setIOFuncsIoWrite                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype IOFuncs = IOFuncs (SP.ManagedPtr IOFuncs)
    deriving (Eq)

instance SP.ManagedPtrNewtype IOFuncs where
    toManagedPtr (IOFuncs p) = p

instance BoxedPtr IOFuncs where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 64 >=> B.ManagedPtr.wrapPtr IOFuncs)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr IOFuncs where
    boxedPtrCalloc = callocBytes 64


-- | Construct a `IOFuncs` struct initialized to zero.
newZeroIOFuncs :: MonadIO m => m IOFuncs
newZeroIOFuncs = liftIO $ boxedPtrCalloc >>= wrapPtr IOFuncs

instance tag ~ 'AttrSet => Constructible IOFuncs tag where
    new _ attrs = do
        o <- newZeroIOFuncs
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@io_read@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioRead
-- @
getIOFuncsIoRead :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoReadFieldCallback)
getIOFuncsIoRead s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoReadFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_read@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioRead 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoRead :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback -> m ()
setIOFuncsIoRead s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)

-- | Set the value of the “@io_read@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioRead
-- @
clearIOFuncsIoRead :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoRead s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoReadFieldInfo
instance AttrInfo IOFuncsIoReadFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoReadFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoReadFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoReadFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoReadFieldInfo = (~)(FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)
    type AttrTransferType IOFuncsIoReadFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoReadFieldCallback)
    type AttrGetType IOFuncsIoReadFieldInfo = Maybe GLib.Callbacks.IOFuncsIoReadFieldCallback
    type AttrLabel IOFuncsIoReadFieldInfo = "io_read"
    type AttrOrigin IOFuncsIoReadFieldInfo = IOFuncs
    attrGet = getIOFuncsIoRead
    attrSet = setIOFuncsIoRead
    attrConstruct = undefined
    attrClear = clearIOFuncsIoRead
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioRead"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioRead"
        })

iOFuncs_ioRead :: AttrLabelProxy "ioRead"
iOFuncs_ioRead = AttrLabelProxy

#endif


-- | Get the value of the “@io_write@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioWrite
-- @
getIOFuncsIoWrite :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoWriteFieldCallback)
getIOFuncsIoWrite s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoWriteFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_write@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioWrite 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoWrite :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback -> m ()
setIOFuncsIoWrite s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)

-- | Set the value of the “@io_write@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioWrite
-- @
clearIOFuncsIoWrite :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoWrite s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoWriteFieldInfo
instance AttrInfo IOFuncsIoWriteFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoWriteFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoWriteFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoWriteFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoWriteFieldInfo = (~)(FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)
    type AttrTransferType IOFuncsIoWriteFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoWriteFieldCallback)
    type AttrGetType IOFuncsIoWriteFieldInfo = Maybe GLib.Callbacks.IOFuncsIoWriteFieldCallback
    type AttrLabel IOFuncsIoWriteFieldInfo = "io_write"
    type AttrOrigin IOFuncsIoWriteFieldInfo = IOFuncs
    attrGet = getIOFuncsIoWrite
    attrSet = setIOFuncsIoWrite
    attrConstruct = undefined
    attrClear = clearIOFuncsIoWrite
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioWrite"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioWrite"
        })

iOFuncs_ioWrite :: AttrLabelProxy "ioWrite"
iOFuncs_ioWrite = AttrLabelProxy

#endif


-- | Get the value of the “@io_seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioSeek
-- @
getIOFuncsIoSeek :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoSeekFieldCallback)
getIOFuncsIoSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoSeekFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioSeek 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoSeek :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback -> m ()
setIOFuncsIoSeek s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)

-- | Set the value of the “@io_seek@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioSeek
-- @
clearIOFuncsIoSeek :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoSeekFieldInfo
instance AttrInfo IOFuncsIoSeekFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoSeekFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoSeekFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoSeekFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoSeekFieldInfo = (~)(FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)
    type AttrTransferType IOFuncsIoSeekFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoSeekFieldCallback)
    type AttrGetType IOFuncsIoSeekFieldInfo = Maybe GLib.Callbacks.IOFuncsIoSeekFieldCallback
    type AttrLabel IOFuncsIoSeekFieldInfo = "io_seek"
    type AttrOrigin IOFuncsIoSeekFieldInfo = IOFuncs
    attrGet = getIOFuncsIoSeek
    attrSet = setIOFuncsIoSeek
    attrConstruct = undefined
    attrClear = clearIOFuncsIoSeek
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioSeek"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioSeek"
        })

iOFuncs_ioSeek :: AttrLabelProxy "ioSeek"
iOFuncs_ioSeek = AttrLabelProxy

#endif


-- | Get the value of the “@io_close@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioClose
-- @
getIOFuncsIoClose :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoCloseFieldCallback)
getIOFuncsIoClose s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoCloseFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_close@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioClose 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoClose :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback -> m ()
setIOFuncsIoClose s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)

-- | Set the value of the “@io_close@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioClose
-- @
clearIOFuncsIoClose :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoClose s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoCloseFieldInfo
instance AttrInfo IOFuncsIoCloseFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoCloseFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoCloseFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoCloseFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoCloseFieldInfo = (~)(FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)
    type AttrTransferType IOFuncsIoCloseFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoCloseFieldCallback)
    type AttrGetType IOFuncsIoCloseFieldInfo = Maybe GLib.Callbacks.IOFuncsIoCloseFieldCallback
    type AttrLabel IOFuncsIoCloseFieldInfo = "io_close"
    type AttrOrigin IOFuncsIoCloseFieldInfo = IOFuncs
    attrGet = getIOFuncsIoClose
    attrSet = setIOFuncsIoClose
    attrConstruct = undefined
    attrClear = clearIOFuncsIoClose
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioClose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioClose"
        })

iOFuncs_ioClose :: AttrLabelProxy "ioClose"
iOFuncs_ioClose = AttrLabelProxy

#endif


-- | Get the value of the “@io_create_watch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioCreateWatch
-- @
getIOFuncsIoCreateWatch :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoCreateWatchFieldCallback)
getIOFuncsIoCreateWatch s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoCreateWatchFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_create_watch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioCreateWatch 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoCreateWatch :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback -> m ()
setIOFuncsIoCreateWatch s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback)

-- | Set the value of the “@io_create_watch@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioCreateWatch
-- @
clearIOFuncsIoCreateWatch :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoCreateWatch s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoCreateWatchFieldInfo
instance AttrInfo IOFuncsIoCreateWatchFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoCreateWatchFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoCreateWatchFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoCreateWatchFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoCreateWatchFieldInfo = (~)GLib.Callbacks.IOFuncsIoCreateWatchFieldCallback
    type AttrTransferType IOFuncsIoCreateWatchFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoCreateWatchFieldCallback)
    type AttrGetType IOFuncsIoCreateWatchFieldInfo = Maybe GLib.Callbacks.IOFuncsIoCreateWatchFieldCallback
    type AttrLabel IOFuncsIoCreateWatchFieldInfo = "io_create_watch"
    type AttrOrigin IOFuncsIoCreateWatchFieldInfo = IOFuncs
    attrGet = getIOFuncsIoCreateWatch
    attrSet = setIOFuncsIoCreateWatch
    attrConstruct = undefined
    attrClear = clearIOFuncsIoCreateWatch
    attrTransfer _ v = do
        GLib.Callbacks.mk_IOFuncsIoCreateWatchFieldCallback (GLib.Callbacks.wrap_IOFuncsIoCreateWatchFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioCreateWatch"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioCreateWatch"
        })

iOFuncs_ioCreateWatch :: AttrLabelProxy "ioCreateWatch"
iOFuncs_ioCreateWatch = AttrLabelProxy

#endif


-- | Get the value of the “@io_free@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioFree
-- @
getIOFuncsIoFree :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoFreeFieldCallback)
getIOFuncsIoFree s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoFreeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_free@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioFree 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoFree :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback -> m ()
setIOFuncsIoFree s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback)

-- | Set the value of the “@io_free@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioFree
-- @
clearIOFuncsIoFree :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoFree s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoFreeFieldInfo
instance AttrInfo IOFuncsIoFreeFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoFreeFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoFreeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoFreeFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoFreeFieldInfo = (~)GLib.Callbacks.IOFuncsIoFreeFieldCallback
    type AttrTransferType IOFuncsIoFreeFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoFreeFieldCallback)
    type AttrGetType IOFuncsIoFreeFieldInfo = Maybe GLib.Callbacks.IOFuncsIoFreeFieldCallback
    type AttrLabel IOFuncsIoFreeFieldInfo = "io_free"
    type AttrOrigin IOFuncsIoFreeFieldInfo = IOFuncs
    attrGet = getIOFuncsIoFree
    attrSet = setIOFuncsIoFree
    attrConstruct = undefined
    attrClear = clearIOFuncsIoFree
    attrTransfer _ v = do
        GLib.Callbacks.mk_IOFuncsIoFreeFieldCallback (GLib.Callbacks.wrap_IOFuncsIoFreeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioFree"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioFree"
        })

iOFuncs_ioFree :: AttrLabelProxy "ioFree"
iOFuncs_ioFree = AttrLabelProxy

#endif


-- | Get the value of the “@io_set_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioSetFlags
-- @
getIOFuncsIoSetFlags :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoSetFlagsFieldCallback)
getIOFuncsIoSetFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoSetFlagsFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_set_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioSetFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoSetFlags :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback -> m ()
setIOFuncsIoSetFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)

-- | Set the value of the “@io_set_flags@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioSetFlags
-- @
clearIOFuncsIoSetFlags :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoSetFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoSetFlagsFieldInfo
instance AttrInfo IOFuncsIoSetFlagsFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoSetFlagsFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoSetFlagsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoSetFlagsFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoSetFlagsFieldInfo = (~)(FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)
    type AttrTransferType IOFuncsIoSetFlagsFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoSetFlagsFieldCallback)
    type AttrGetType IOFuncsIoSetFlagsFieldInfo = Maybe GLib.Callbacks.IOFuncsIoSetFlagsFieldCallback
    type AttrLabel IOFuncsIoSetFlagsFieldInfo = "io_set_flags"
    type AttrOrigin IOFuncsIoSetFlagsFieldInfo = IOFuncs
    attrGet = getIOFuncsIoSetFlags
    attrSet = setIOFuncsIoSetFlags
    attrConstruct = undefined
    attrClear = clearIOFuncsIoSetFlags
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioSetFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioSetFlags"
        })

iOFuncs_ioSetFlags :: AttrLabelProxy "ioSetFlags"
iOFuncs_ioSetFlags = AttrLabelProxy

#endif


-- | Get the value of the “@io_get_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iOFuncs #ioGetFlags
-- @
getIOFuncsIoGetFlags :: MonadIO m => IOFuncs -> m (Maybe GLib.Callbacks.IOFuncsIoGetFlagsFieldCallback)
getIOFuncsIoGetFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_IOFuncsIoGetFlagsFieldCallback val'
        return val''
    return result

-- | Set the value of the “@io_get_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iOFuncs [ #ioGetFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setIOFuncsIoGetFlags :: MonadIO m => IOFuncs -> FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback -> m ()
setIOFuncsIoGetFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback)

-- | Set the value of the “@io_get_flags@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #ioGetFlags
-- @
clearIOFuncsIoGetFlags :: MonadIO m => IOFuncs -> m ()
clearIOFuncsIoGetFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback)

#if defined(ENABLE_OVERLOADING)
data IOFuncsIoGetFlagsFieldInfo
instance AttrInfo IOFuncsIoGetFlagsFieldInfo where
    type AttrBaseTypeConstraint IOFuncsIoGetFlagsFieldInfo = (~) IOFuncs
    type AttrAllowedOps IOFuncsIoGetFlagsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint IOFuncsIoGetFlagsFieldInfo = (~) (FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback)
    type AttrTransferTypeConstraint IOFuncsIoGetFlagsFieldInfo = (~)GLib.Callbacks.IOFuncsIoGetFlagsFieldCallback
    type AttrTransferType IOFuncsIoGetFlagsFieldInfo = (FunPtr GLib.Callbacks.C_IOFuncsIoGetFlagsFieldCallback)
    type AttrGetType IOFuncsIoGetFlagsFieldInfo = Maybe GLib.Callbacks.IOFuncsIoGetFlagsFieldCallback
    type AttrLabel IOFuncsIoGetFlagsFieldInfo = "io_get_flags"
    type AttrOrigin IOFuncsIoGetFlagsFieldInfo = IOFuncs
    attrGet = getIOFuncsIoGetFlags
    attrSet = setIOFuncsIoGetFlags
    attrConstruct = undefined
    attrClear = clearIOFuncsIoGetFlags
    attrTransfer _ v = do
        GLib.Callbacks.mk_IOFuncsIoGetFlagsFieldCallback (GLib.Callbacks.wrap_IOFuncsIoGetFlagsFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.IOFuncs.ioGetFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-IOFuncs.html#g:attr:ioGetFlags"
        })

iOFuncs_ioGetFlags :: AttrLabelProxy "ioGetFlags"
iOFuncs_ioGetFlags = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IOFuncs
type instance O.AttributeList IOFuncs = IOFuncsAttributeList
type IOFuncsAttributeList = ('[ '("ioRead", IOFuncsIoReadFieldInfo), '("ioWrite", IOFuncsIoWriteFieldInfo), '("ioSeek", IOFuncsIoSeekFieldInfo), '("ioClose", IOFuncsIoCloseFieldInfo), '("ioCreateWatch", IOFuncsIoCreateWatchFieldInfo), '("ioFree", IOFuncsIoFreeFieldInfo), '("ioSetFlags", IOFuncsIoSetFlagsFieldInfo), '("ioGetFlags", IOFuncsIoGetFlagsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveIOFuncsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIOFuncsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIOFuncsMethod t IOFuncs, O.OverloadedMethod info IOFuncs p) => OL.IsLabel t (IOFuncs -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIOFuncsMethod t IOFuncs, O.OverloadedMethod info IOFuncs p, R.HasField t IOFuncs p) => R.HasField t IOFuncs p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIOFuncsMethod t IOFuncs, O.OverloadedMethodInfo info IOFuncs) => OL.IsLabel t (O.MethodProxy info IOFuncs) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


