{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GCompletion@ provides support for automatic completion of a string
-- using any group of target strings. It is typically used for file
-- name completion as is common in many UNIX shells.
-- 
-- A @GCompletion@ is created using [func/@gLib@/.Completion.new]. Target items are
-- added and removed with t'GI.GLib.Structs.Completion.Completion'.@/add_items/@(),
-- t'GI.GLib.Structs.Completion.Completion'.@/remove_items/@() and
-- 'GI.GLib.Structs.Completion.completionClearItems'. A completion attempt is requested with
-- t'GI.GLib.Structs.Completion.Completion'.@/complete/@() or 'GI.GLib.Structs.Completion.completionCompleteUtf8'.
-- When no longer needed, the @GCompletion@ is freed with
-- 'GI.GLib.Structs.Completion.completionFree'.
-- 
-- Items in the completion can be simple strings (e.g. filenames), or
-- pointers to arbitrary data structures. If data structures are used
-- you must provide a [type/@gLib@/.CompletionFunc] in [func/@gLib@/.Completion.new],
-- which retrieves the item’s string from the data structure. You can change
-- the way in which strings are compared by setting a different
-- [type/@gLib@/.CompletionStrncmpFunc] in t'GI.GLib.Structs.Completion.Completion'.@/set_compare/@().
-- 
-- @GCompletion@ has been marked as deprecated, since this API is rarely
-- used and not very actively maintained.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Completion
    ( 

-- * Exported types
    Completion(..)                          ,
    newZeroCompletion                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [clearItems]("GI.GLib.Structs.Completion#g:method:clearItems"), [completeUtf8]("GI.GLib.Structs.Completion#g:method:completeUtf8"), [free]("GI.GLib.Structs.Completion#g:method:free").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveCompletionMethod                 ,
#endif

-- ** clearItems #method:clearItems#

#if defined(ENABLE_OVERLOADING)
    CompletionClearItemsMethodInfo          ,
#endif
    completionClearItems                    ,


-- ** completeUtf8 #method:completeUtf8#

#if defined(ENABLE_OVERLOADING)
    CompletionCompleteUtf8MethodInfo        ,
#endif
    completionCompleteUtf8                  ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    CompletionFreeMethodInfo                ,
#endif
    completionFree                          ,




 -- * Properties


-- ** cache #attr:cache#
-- | the list of items which begin with /@prefix@/.

    clearCompletionCache                    ,
#if defined(ENABLE_OVERLOADING)
    completion_cache                        ,
#endif
    getCompletionCache                      ,
    setCompletionCache                      ,


-- ** func #attr:func#
-- | function which is called to get the string associated with a
--        target item. It is 'P.Nothing' if the target items are strings.

    clearCompletionFunc                     ,
#if defined(ENABLE_OVERLOADING)
    completion_func                         ,
#endif
    getCompletionFunc                       ,
    setCompletionFunc                       ,


-- ** items #attr:items#
-- | list of target items (strings or data structures).

    clearCompletionItems                    ,
#if defined(ENABLE_OVERLOADING)
    completion_items                        ,
#endif
    getCompletionItems                      ,
    setCompletionItems                      ,


-- ** prefix #attr:prefix#
-- | the last prefix passed to @/g_completion_complete()/@ or
--          'GI.GLib.Structs.Completion.completionCompleteUtf8'.

    clearCompletionPrefix                   ,
#if defined(ENABLE_OVERLOADING)
    completion_prefix                       ,
#endif
    getCompletionPrefix                     ,
    setCompletionPrefix                     ,


-- ** strncmpFunc #attr:strncmpFunc#
-- | The function to use when comparing strings.  Use
--                @/g_completion_set_compare()/@ to modify this function.

    clearCompletionStrncmpFunc              ,
#if defined(ENABLE_OVERLOADING)
    completion_strncmpFunc                  ,
#endif
    getCompletionStrncmpFunc                ,
    setCompletionStrncmpFunc                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype Completion = Completion (SP.ManagedPtr Completion)
    deriving (Eq)

instance SP.ManagedPtrNewtype Completion where
    toManagedPtr (Completion p) = p

instance BoxedPtr Completion where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr Completion)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Completion where
    boxedPtrCalloc = callocBytes 40


-- | Construct a `Completion` struct initialized to zero.
newZeroCompletion :: MonadIO m => m Completion
newZeroCompletion = liftIO $ boxedPtrCalloc >>= wrapPtr Completion

instance tag ~ 'AttrSet => Constructible Completion tag where
    new _ attrs = do
        o <- newZeroCompletion
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@items@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' completion #items
-- @
getCompletionItems :: MonadIO m => Completion -> m ([Ptr ()])
getCompletionItems s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr (GList (Ptr ())))
    val' <- unpackGList val
    return val'

-- | Set the value of the “@items@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' completion [ #items 'Data.GI.Base.Attributes.:=' value ]
-- @
setCompletionItems :: MonadIO m => Completion -> Ptr (GList (Ptr ())) -> m ()
setCompletionItems s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr (GList (Ptr ())))

-- | Set the value of the “@items@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #items
-- @
clearCompletionItems :: MonadIO m => Completion -> m ()
clearCompletionItems s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr (GList (Ptr ())))

#if defined(ENABLE_OVERLOADING)
data CompletionItemsFieldInfo
instance AttrInfo CompletionItemsFieldInfo where
    type AttrBaseTypeConstraint CompletionItemsFieldInfo = (~) Completion
    type AttrAllowedOps CompletionItemsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CompletionItemsFieldInfo = (~) (Ptr (GList (Ptr ())))
    type AttrTransferTypeConstraint CompletionItemsFieldInfo = (~)(Ptr (GList (Ptr ())))
    type AttrTransferType CompletionItemsFieldInfo = (Ptr (GList (Ptr ())))
    type AttrGetType CompletionItemsFieldInfo = [Ptr ()]
    type AttrLabel CompletionItemsFieldInfo = "items"
    type AttrOrigin CompletionItemsFieldInfo = Completion
    attrGet = getCompletionItems
    attrSet = setCompletionItems
    attrConstruct = undefined
    attrClear = clearCompletionItems
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.items"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#g:attr:items"
        })

completion_items :: AttrLabelProxy "items"
completion_items = AttrLabelProxy

#endif


-- | Get the value of the “@func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' completion #func
-- @
getCompletionFunc :: MonadIO m => Completion -> m (Maybe GLib.Callbacks.CompletionFunc_WithClosures)
getCompletionFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr GLib.Callbacks.C_CompletionFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_CompletionFunc val'
        return val''
    return result

-- | Set the value of the “@func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' completion [ #func 'Data.GI.Base.Attributes.:=' value ]
-- @
setCompletionFunc :: MonadIO m => Completion -> FunPtr GLib.Callbacks.C_CompletionFunc -> m ()
setCompletionFunc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr GLib.Callbacks.C_CompletionFunc)

-- | Set the value of the “@func@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #func
-- @
clearCompletionFunc :: MonadIO m => Completion -> m ()
clearCompletionFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_CompletionFunc)

#if defined(ENABLE_OVERLOADING)
data CompletionFuncFieldInfo
instance AttrInfo CompletionFuncFieldInfo where
    type AttrBaseTypeConstraint CompletionFuncFieldInfo = (~) Completion
    type AttrAllowedOps CompletionFuncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CompletionFuncFieldInfo = (~) (FunPtr GLib.Callbacks.C_CompletionFunc)
    type AttrTransferTypeConstraint CompletionFuncFieldInfo = (~)GLib.Callbacks.CompletionFunc_WithClosures
    type AttrTransferType CompletionFuncFieldInfo = (FunPtr GLib.Callbacks.C_CompletionFunc)
    type AttrGetType CompletionFuncFieldInfo = Maybe GLib.Callbacks.CompletionFunc_WithClosures
    type AttrLabel CompletionFuncFieldInfo = "func"
    type AttrOrigin CompletionFuncFieldInfo = Completion
    attrGet = getCompletionFunc
    attrSet = setCompletionFunc
    attrConstruct = undefined
    attrClear = clearCompletionFunc
    attrTransfer _ v = do
        GLib.Callbacks.mk_CompletionFunc (GLib.Callbacks.wrap_CompletionFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.func"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#g:attr:func"
        })

completion_func :: AttrLabelProxy "func"
completion_func = AttrLabelProxy

#endif


-- | Get the value of the “@prefix@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' completion #prefix
-- @
getCompletionPrefix :: MonadIO m => Completion -> m (Maybe T.Text)
getCompletionPrefix s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@prefix@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' completion [ #prefix 'Data.GI.Base.Attributes.:=' value ]
-- @
setCompletionPrefix :: MonadIO m => Completion -> CString -> m ()
setCompletionPrefix s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@prefix@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #prefix
-- @
clearCompletionPrefix :: MonadIO m => Completion -> m ()
clearCompletionPrefix s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data CompletionPrefixFieldInfo
instance AttrInfo CompletionPrefixFieldInfo where
    type AttrBaseTypeConstraint CompletionPrefixFieldInfo = (~) Completion
    type AttrAllowedOps CompletionPrefixFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CompletionPrefixFieldInfo = (~) CString
    type AttrTransferTypeConstraint CompletionPrefixFieldInfo = (~)CString
    type AttrTransferType CompletionPrefixFieldInfo = CString
    type AttrGetType CompletionPrefixFieldInfo = Maybe T.Text
    type AttrLabel CompletionPrefixFieldInfo = "prefix"
    type AttrOrigin CompletionPrefixFieldInfo = Completion
    attrGet = getCompletionPrefix
    attrSet = setCompletionPrefix
    attrConstruct = undefined
    attrClear = clearCompletionPrefix
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.prefix"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#g:attr:prefix"
        })

completion_prefix :: AttrLabelProxy "prefix"
completion_prefix = AttrLabelProxy

#endif


-- | Get the value of the “@cache@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' completion #cache
-- @
getCompletionCache :: MonadIO m => Completion -> m ([Ptr ()])
getCompletionCache s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (GList (Ptr ())))
    val' <- unpackGList val
    return val'

-- | Set the value of the “@cache@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' completion [ #cache 'Data.GI.Base.Attributes.:=' value ]
-- @
setCompletionCache :: MonadIO m => Completion -> Ptr (GList (Ptr ())) -> m ()
setCompletionCache s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (GList (Ptr ())))

-- | Set the value of the “@cache@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #cache
-- @
clearCompletionCache :: MonadIO m => Completion -> m ()
clearCompletionCache s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (GList (Ptr ())))

#if defined(ENABLE_OVERLOADING)
data CompletionCacheFieldInfo
instance AttrInfo CompletionCacheFieldInfo where
    type AttrBaseTypeConstraint CompletionCacheFieldInfo = (~) Completion
    type AttrAllowedOps CompletionCacheFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CompletionCacheFieldInfo = (~) (Ptr (GList (Ptr ())))
    type AttrTransferTypeConstraint CompletionCacheFieldInfo = (~)(Ptr (GList (Ptr ())))
    type AttrTransferType CompletionCacheFieldInfo = (Ptr (GList (Ptr ())))
    type AttrGetType CompletionCacheFieldInfo = [Ptr ()]
    type AttrLabel CompletionCacheFieldInfo = "cache"
    type AttrOrigin CompletionCacheFieldInfo = Completion
    attrGet = getCompletionCache
    attrSet = setCompletionCache
    attrConstruct = undefined
    attrClear = clearCompletionCache
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.cache"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#g:attr:cache"
        })

completion_cache :: AttrLabelProxy "cache"
completion_cache = AttrLabelProxy

#endif


-- | Get the value of the “@strncmp_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' completion #strncmpFunc
-- @
getCompletionStrncmpFunc :: MonadIO m => Completion -> m (Maybe GLib.Callbacks.CompletionStrncmpFunc)
getCompletionStrncmpFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr GLib.Callbacks.C_CompletionStrncmpFunc)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = GLib.Callbacks.dynamic_CompletionStrncmpFunc val'
        return val''
    return result

-- | Set the value of the “@strncmp_func@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' completion [ #strncmpFunc 'Data.GI.Base.Attributes.:=' value ]
-- @
setCompletionStrncmpFunc :: MonadIO m => Completion -> FunPtr GLib.Callbacks.C_CompletionStrncmpFunc -> m ()
setCompletionStrncmpFunc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr GLib.Callbacks.C_CompletionStrncmpFunc)

-- | Set the value of the “@strncmp_func@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #strncmpFunc
-- @
clearCompletionStrncmpFunc :: MonadIO m => Completion -> m ()
clearCompletionStrncmpFunc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr GLib.Callbacks.C_CompletionStrncmpFunc)

#if defined(ENABLE_OVERLOADING)
data CompletionStrncmpFuncFieldInfo
instance AttrInfo CompletionStrncmpFuncFieldInfo where
    type AttrBaseTypeConstraint CompletionStrncmpFuncFieldInfo = (~) Completion
    type AttrAllowedOps CompletionStrncmpFuncFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint CompletionStrncmpFuncFieldInfo = (~) (FunPtr GLib.Callbacks.C_CompletionStrncmpFunc)
    type AttrTransferTypeConstraint CompletionStrncmpFuncFieldInfo = (~)GLib.Callbacks.CompletionStrncmpFunc
    type AttrTransferType CompletionStrncmpFuncFieldInfo = (FunPtr GLib.Callbacks.C_CompletionStrncmpFunc)
    type AttrGetType CompletionStrncmpFuncFieldInfo = Maybe GLib.Callbacks.CompletionStrncmpFunc
    type AttrLabel CompletionStrncmpFuncFieldInfo = "strncmp_func"
    type AttrOrigin CompletionStrncmpFuncFieldInfo = Completion
    attrGet = getCompletionStrncmpFunc
    attrSet = setCompletionStrncmpFunc
    attrConstruct = undefined
    attrClear = clearCompletionStrncmpFunc
    attrTransfer _ v = do
        GLib.Callbacks.mk_CompletionStrncmpFunc (GLib.Callbacks.wrap_CompletionStrncmpFunc Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.strncmpFunc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#g:attr:strncmpFunc"
        })

completion_strncmpFunc :: AttrLabelProxy "strncmpFunc"
completion_strncmpFunc = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Completion
type instance O.AttributeList Completion = CompletionAttributeList
type CompletionAttributeList = ('[ '("items", CompletionItemsFieldInfo), '("func", CompletionFuncFieldInfo), '("prefix", CompletionPrefixFieldInfo), '("cache", CompletionCacheFieldInfo), '("strncmpFunc", CompletionStrncmpFuncFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Completion::clear_items
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cmp"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Completion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompletion." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_completion_clear_items" g_completion_clear_items :: 
    Ptr Completion ->                       -- cmp : TInterface (Name {namespace = "GLib", name = "Completion"})
    IO ()

{-# DEPRECATED completionClearItems ["(Since version 2.26)","Rarely used API"] #-}
-- | Removes all items from the t'GI.GLib.Structs.Completion.Completion'. The items are not freed, so if the
-- memory was dynamically allocated, it should be freed after calling this
-- function.
completionClearItems ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Completion
    -- ^ /@cmp@/: the t'GI.GLib.Structs.Completion.Completion'.
    -> m ()
completionClearItems cmp = liftIO $ do
    cmp' <- unsafeManagedPtrGetPtr cmp
    g_completion_clear_items cmp'
    touchManagedPtr cmp
    return ()

#if defined(ENABLE_OVERLOADING)
data CompletionClearItemsMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod CompletionClearItemsMethodInfo Completion signature where
    overloadedMethod = completionClearItems

instance O.OverloadedMethodInfo CompletionClearItemsMethodInfo Completion where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.completionClearItems",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#v:completionClearItems"
        })


#endif

-- method Completion::complete_utf8
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cmp"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Completion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompletion" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "prefix"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the prefix string, typically used by the user, which is compared\n   with each of the items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_prefix"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if non-%NULL, returns the longest prefix which is common to all\n   items that matched @prefix, or %NULL if no items matched @prefix.\n   This string should be freed when no longer needed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGList (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_completion_complete_utf8" g_completion_complete_utf8 :: 
    Ptr Completion ->                       -- cmp : TInterface (Name {namespace = "GLib", name = "Completion"})
    CString ->                              -- prefix : TBasicType TUTF8
    CString ->                              -- new_prefix : TBasicType TUTF8
    IO (Ptr (GList CString))

{-# DEPRECATED completionCompleteUtf8 ["(Since version 2.26)","Rarely used API"] #-}
-- | Attempts to complete the string /@prefix@/ using the t'GI.GLib.Structs.Completion.Completion' target items.
-- In contrast to @/g_completion_complete()/@, this function returns the largest common
-- prefix that is a valid UTF-8 string, omitting a possible common partial
-- character.
-- 
-- You should use this function instead of @/g_completion_complete()/@ if your
-- items are UTF-8 strings.
-- 
-- /Since: 2.4/
completionCompleteUtf8 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Completion
    -- ^ /@cmp@/: the t'GI.GLib.Structs.Completion.Completion'
    -> T.Text
    -- ^ /@prefix@/: the prefix string, typically used by the user, which is compared
    --    with each of the items
    -> T.Text
    -- ^ /@newPrefix@/: if non-'P.Nothing', returns the longest prefix which is common to all
    --    items that matched /@prefix@/, or 'P.Nothing' if no items matched /@prefix@/.
    --    This string should be freed when no longer needed.
    -> m [T.Text]
    -- ^ __Returns:__ the list of items whose strings begin with /@prefix@/. This should
    -- not be changed.
completionCompleteUtf8 cmp prefix newPrefix = liftIO $ do
    cmp' <- unsafeManagedPtrGetPtr cmp
    prefix' <- textToCString prefix
    newPrefix' <- textToCString newPrefix
    result <- g_completion_complete_utf8 cmp' prefix' newPrefix'
    result' <- unpackGList result
    result'' <- mapM cstringToText result'
    touchManagedPtr cmp
    freeMem prefix'
    freeMem newPrefix'
    return result''

#if defined(ENABLE_OVERLOADING)
data CompletionCompleteUtf8MethodInfo
instance (signature ~ (T.Text -> T.Text -> m [T.Text]), MonadIO m) => O.OverloadedMethod CompletionCompleteUtf8MethodInfo Completion signature where
    overloadedMethod = completionCompleteUtf8

instance O.OverloadedMethodInfo CompletionCompleteUtf8MethodInfo Completion where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.completionCompleteUtf8",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#v:completionCompleteUtf8"
        })


#endif

-- method Completion::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cmp"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Completion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompletion." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_completion_free" g_completion_free :: 
    Ptr Completion ->                       -- cmp : TInterface (Name {namespace = "GLib", name = "Completion"})
    IO ()

{-# DEPRECATED completionFree ["(Since version 2.26)","Rarely used API"] #-}
-- | Frees all memory used by the t'GI.GLib.Structs.Completion.Completion'. The items are not freed, so if
-- the memory was dynamically allocated, it should be freed after calling this
-- function.
completionFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Completion
    -- ^ /@cmp@/: the t'GI.GLib.Structs.Completion.Completion'.
    -> m ()
completionFree cmp = liftIO $ do
    cmp' <- unsafeManagedPtrGetPtr cmp
    g_completion_free cmp'
    touchManagedPtr cmp
    return ()

#if defined(ENABLE_OVERLOADING)
data CompletionFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod CompletionFreeMethodInfo Completion signature where
    overloadedMethod = completionFree

instance O.OverloadedMethodInfo CompletionFreeMethodInfo Completion where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Completion.completionFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Completion.html#v:completionFree"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveCompletionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCompletionMethod "clearItems" o = CompletionClearItemsMethodInfo
    ResolveCompletionMethod "completeUtf8" o = CompletionCompleteUtf8MethodInfo
    ResolveCompletionMethod "free" o = CompletionFreeMethodInfo
    ResolveCompletionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCompletionMethod t Completion, O.OverloadedMethod info Completion p) => OL.IsLabel t (Completion -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCompletionMethod t Completion, O.OverloadedMethod info Completion p, R.HasField t Completion p) => R.HasField t Completion p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCompletionMethod t Completion, O.OverloadedMethodInfo info Completion) => OL.IsLabel t (O.MethodProxy info Completion) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


