{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- GLib provides a generic API for computing checksums (or ‘digests’)
-- for a sequence of arbitrary bytes, using various hashing algorithms
-- like MD5, SHA-1 and SHA-256. Checksums are commonly used in various
-- environments and specifications.
-- 
-- To create a new @GChecksum@, use 'GI.GLib.Structs.Checksum.checksumNew'. To free
-- a @GChecksum@, use 'GI.GLib.Structs.Checksum.checksumFree'.
-- 
-- GLib supports incremental checksums using the @GChecksum@ data
-- structure, by calling 'GI.GLib.Structs.Checksum.checksumUpdate' as long as there’s data
-- available and then using 'GI.GLib.Structs.Checksum.checksumGetString' or
-- t'GI.GLib.Structs.Checksum.Checksum'.@/get_digest/@() to compute the checksum and return it
-- either as a string in hexadecimal form, or as a raw sequence of bytes. To
-- compute the checksum for binary blobs and nul-terminated strings in
-- one go, use the convenience functions 'GI.GLib.Functions.computeChecksumForData'
-- and 'GI.GLib.Functions.computeChecksumForString', respectively.
-- 
-- /Since: 2.16/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Checksum
    ( 

-- * Exported types
    Checksum(..)                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.GLib.Structs.Checksum#g:method:copy"), [free]("GI.GLib.Structs.Checksum#g:method:free"), [reset]("GI.GLib.Structs.Checksum#g:method:reset"), [update]("GI.GLib.Structs.Checksum#g:method:update").
-- 
-- ==== Getters
-- [getString]("GI.GLib.Structs.Checksum#g:method:getString").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveChecksumMethod                   ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    ChecksumCopyMethodInfo                  ,
#endif
    checksumCopy                            ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    ChecksumFreeMethodInfo                  ,
#endif
    checksumFree                            ,


-- ** getString #method:getString#

#if defined(ENABLE_OVERLOADING)
    ChecksumGetStringMethodInfo             ,
#endif
    checksumGetString                       ,


-- ** new #method:new#

    checksumNew                             ,


-- ** reset #method:reset#

#if defined(ENABLE_OVERLOADING)
    ChecksumResetMethodInfo                 ,
#endif
    checksumReset                           ,


-- ** typeGetLength #method:typeGetLength#

    checksumTypeGetLength                   ,


-- ** update #method:update#

#if defined(ENABLE_OVERLOADING)
    ChecksumUpdateMethodInfo                ,
#endif
    checksumUpdate                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#else
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums

#endif

-- | Memory-managed wrapper type.
newtype Checksum = Checksum (SP.ManagedPtr Checksum)
    deriving (Eq)

instance SP.ManagedPtrNewtype Checksum where
    toManagedPtr (Checksum p) = p

foreign import ccall "g_checksum_get_type" c_g_checksum_get_type :: 
    IO GType

type instance O.ParentTypes Checksum = '[]
instance O.HasParentTypes Checksum

instance B.Types.TypedObject Checksum where
    glibType = c_g_checksum_get_type

instance B.Types.GBoxed Checksum

-- | Convert 'Checksum' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Checksum) where
    gvalueGType_ = c_g_checksum_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Checksum)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Checksum)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Checksum ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Checksum
type instance O.AttributeList Checksum = ChecksumAttributeList
type ChecksumAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Checksum::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "checksum_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "ChecksumType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the desired type of checksum"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Checksum" })
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_new" g_checksum_new :: 
    CUInt ->                                -- checksum_type : TInterface (Name {namespace = "GLib", name = "ChecksumType"})
    IO (Ptr Checksum)

-- | Creates a new t'GI.GLib.Structs.Checksum.Checksum', using the checksum algorithm /@checksumType@/.
-- If the /@checksumType@/ is not known, 'P.Nothing' is returned.
-- A t'GI.GLib.Structs.Checksum.Checksum' can be used to compute the checksum, or digest, of an
-- arbitrary binary blob, using different hashing algorithms.
-- 
-- A t'GI.GLib.Structs.Checksum.Checksum' works by feeding a binary blob through 'GI.GLib.Structs.Checksum.checksumUpdate'
-- until there is data to be checked; the digest can then be extracted
-- using 'GI.GLib.Structs.Checksum.checksumGetString', which will return the checksum as a
-- hexadecimal string; or @/g_checksum_get_digest()/@, which will return a
-- vector of raw bytes. Once either 'GI.GLib.Structs.Checksum.checksumGetString' or
-- @/g_checksum_get_digest()/@ have been called on a t'GI.GLib.Structs.Checksum.Checksum', the checksum
-- will be closed and it won\'t be possible to call 'GI.GLib.Structs.Checksum.checksumUpdate'
-- on it anymore.
-- 
-- /Since: 2.16/
checksumNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.ChecksumType
    -- ^ /@checksumType@/: the desired type of checksum
    -> m (Maybe Checksum)
    -- ^ __Returns:__ the newly created t'GI.GLib.Structs.Checksum.Checksum', or 'P.Nothing'.
    --   Use 'GI.GLib.Structs.Checksum.checksumFree' to free the memory allocated by it.
checksumNew checksumType = liftIO $ do
    let checksumType' = (fromIntegral . fromEnum) checksumType
    result <- g_checksum_new checksumType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Checksum) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Checksum::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "checksum"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Checksum" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GChecksum to copy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Checksum" })
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_copy" g_checksum_copy :: 
    Ptr Checksum ->                         -- checksum : TInterface (Name {namespace = "GLib", name = "Checksum"})
    IO (Ptr Checksum)

-- | Copies a t'GI.GLib.Structs.Checksum.Checksum'. If /@checksum@/ has been closed, by calling
-- 'GI.GLib.Structs.Checksum.checksumGetString' or @/g_checksum_get_digest()/@, the copied
-- checksum will be closed as well.
-- 
-- /Since: 2.16/
checksumCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Checksum
    -- ^ /@checksum@/: the t'GI.GLib.Structs.Checksum.Checksum' to copy
    -> m Checksum
    -- ^ __Returns:__ the copy of the passed t'GI.GLib.Structs.Checksum.Checksum'. Use
    --   'GI.GLib.Structs.Checksum.checksumFree' when finished using it.
checksumCopy checksum = liftIO $ do
    checksum' <- unsafeManagedPtrGetPtr checksum
    result <- g_checksum_copy checksum'
    checkUnexpectedReturnNULL "checksumCopy" result
    result' <- (wrapBoxed Checksum) result
    touchManagedPtr checksum
    return result'

#if defined(ENABLE_OVERLOADING)
data ChecksumCopyMethodInfo
instance (signature ~ (m Checksum), MonadIO m) => O.OverloadedMethod ChecksumCopyMethodInfo Checksum signature where
    overloadedMethod = checksumCopy

instance O.OverloadedMethodInfo ChecksumCopyMethodInfo Checksum where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Checksum.checksumCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Checksum.html#v:checksumCopy"
        })


#endif

-- method Checksum::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "checksum"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Checksum" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GChecksum" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_free" g_checksum_free :: 
    Ptr Checksum ->                         -- checksum : TInterface (Name {namespace = "GLib", name = "Checksum"})
    IO ()

-- | Frees the memory allocated for /@checksum@/.
-- 
-- /Since: 2.16/
checksumFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Checksum
    -- ^ /@checksum@/: a t'GI.GLib.Structs.Checksum.Checksum'
    -> m ()
checksumFree checksum = liftIO $ do
    checksum' <- unsafeManagedPtrGetPtr checksum
    g_checksum_free checksum'
    touchManagedPtr checksum
    return ()

#if defined(ENABLE_OVERLOADING)
data ChecksumFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ChecksumFreeMethodInfo Checksum signature where
    overloadedMethod = checksumFree

instance O.OverloadedMethodInfo ChecksumFreeMethodInfo Checksum where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Checksum.checksumFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Checksum.html#v:checksumFree"
        })


#endif

-- method Checksum::get_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "checksum"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Checksum" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GChecksum" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_get_string" g_checksum_get_string :: 
    Ptr Checksum ->                         -- checksum : TInterface (Name {namespace = "GLib", name = "Checksum"})
    IO CString

-- | Gets the digest as a hexadecimal string.
-- 
-- Once this function has been called the t'GI.GLib.Structs.Checksum.Checksum' can no longer be
-- updated with 'GI.GLib.Structs.Checksum.checksumUpdate'.
-- 
-- The hexadecimal characters will be lower case.
-- 
-- /Since: 2.16/
checksumGetString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Checksum
    -- ^ /@checksum@/: a t'GI.GLib.Structs.Checksum.Checksum'
    -> m T.Text
    -- ^ __Returns:__ the hexadecimal representation of the checksum. The
    --   returned string is owned by the checksum and should not be modified
    --   or freed.
checksumGetString checksum = liftIO $ do
    checksum' <- unsafeManagedPtrGetPtr checksum
    result <- g_checksum_get_string checksum'
    checkUnexpectedReturnNULL "checksumGetString" result
    result' <- cstringToText result
    touchManagedPtr checksum
    return result'

#if defined(ENABLE_OVERLOADING)
data ChecksumGetStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod ChecksumGetStringMethodInfo Checksum signature where
    overloadedMethod = checksumGetString

instance O.OverloadedMethodInfo ChecksumGetStringMethodInfo Checksum where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Checksum.checksumGetString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Checksum.html#v:checksumGetString"
        })


#endif

-- method Checksum::reset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "checksum"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Checksum" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GChecksum to reset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_reset" g_checksum_reset :: 
    Ptr Checksum ->                         -- checksum : TInterface (Name {namespace = "GLib", name = "Checksum"})
    IO ()

-- | Resets the state of the /@checksum@/ back to its initial state.
-- 
-- /Since: 2.18/
checksumReset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Checksum
    -- ^ /@checksum@/: the t'GI.GLib.Structs.Checksum.Checksum' to reset
    -> m ()
checksumReset checksum = liftIO $ do
    checksum' <- unsafeManagedPtrGetPtr checksum
    g_checksum_reset checksum'
    touchManagedPtr checksum
    return ()

#if defined(ENABLE_OVERLOADING)
data ChecksumResetMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ChecksumResetMethodInfo Checksum signature where
    overloadedMethod = checksumReset

instance O.OverloadedMethodInfo ChecksumResetMethodInfo Checksum where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Checksum.checksumReset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Checksum.html#v:checksumReset"
        })


#endif

-- method Checksum::update
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "checksum"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Checksum" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GChecksum" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer used to compute the checksum"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "size of the buffer, or -1 if it is a null-terminated string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "size of the buffer, or -1 if it is a null-terminated string."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_update" g_checksum_update :: 
    Ptr Checksum ->                         -- checksum : TInterface (Name {namespace = "GLib", name = "Checksum"})
    Ptr Word8 ->                            -- data : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- length : TBasicType TSSize
    IO ()

-- | Feeds /@data@/ into an existing t'GI.GLib.Structs.Checksum.Checksum'. The checksum must still be
-- open, that is 'GI.GLib.Structs.Checksum.checksumGetString' or @/g_checksum_get_digest()/@ must
-- not have been called on /@checksum@/.
-- 
-- /Since: 2.16/
checksumUpdate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Checksum
    -- ^ /@checksum@/: a t'GI.GLib.Structs.Checksum.Checksum'
    -> ByteString
    -- ^ /@data@/: buffer used to compute the checksum
    -> m ()
checksumUpdate checksum data_ = liftIO $ do
    let length_ = fromIntegral $ B.length data_
    checksum' <- unsafeManagedPtrGetPtr checksum
    data_' <- packByteString data_
    g_checksum_update checksum' data_' length_
    touchManagedPtr checksum
    freeMem data_'
    return ()

#if defined(ENABLE_OVERLOADING)
data ChecksumUpdateMethodInfo
instance (signature ~ (ByteString -> m ()), MonadIO m) => O.OverloadedMethod ChecksumUpdateMethodInfo Checksum signature where
    overloadedMethod = checksumUpdate

instance O.OverloadedMethodInfo ChecksumUpdateMethodInfo Checksum where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Checksum.checksumUpdate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Checksum.html#v:checksumUpdate"
        })


#endif

-- method Checksum::type_get_length
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "checksum_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "ChecksumType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GChecksumType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_checksum_type_get_length" g_checksum_type_get_length :: 
    CUInt ->                                -- checksum_type : TInterface (Name {namespace = "GLib", name = "ChecksumType"})
    IO DI.Int64

-- | Gets the length in bytes of digests of type /@checksumType@/
-- 
-- /Since: 2.16/
checksumTypeGetLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.ChecksumType
    -- ^ /@checksumType@/: a t'GI.GLib.Enums.ChecksumType'
    -> m DI.Int64
    -- ^ __Returns:__ the checksum length, or -1 if /@checksumType@/ is
    -- not supported.
checksumTypeGetLength checksumType = liftIO $ do
    let checksumType' = (fromIntegral . fromEnum) checksumType
    result <- g_checksum_type_get_length checksumType'
    return result

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveChecksumMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveChecksumMethod "copy" o = ChecksumCopyMethodInfo
    ResolveChecksumMethod "free" o = ChecksumFreeMethodInfo
    ResolveChecksumMethod "reset" o = ChecksumResetMethodInfo
    ResolveChecksumMethod "update" o = ChecksumUpdateMethodInfo
    ResolveChecksumMethod "getString" o = ChecksumGetStringMethodInfo
    ResolveChecksumMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveChecksumMethod t Checksum, O.OverloadedMethod info Checksum p) => OL.IsLabel t (Checksum -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveChecksumMethod t Checksum, O.OverloadedMethod info Checksum p, R.HasField t Checksum p) => R.HasField t Checksum p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveChecksumMethod t Checksum, O.OverloadedMethodInfo info Checksum) => OL.IsLabel t (O.MethodProxy info Checksum) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


