{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Allocator
    ( 

-- * Exported types
    Allocator(..)                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.GLib.Structs.Allocator#g:method:free").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveAllocatorMethod                  ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    AllocatorFreeMethodInfo                 ,
#endif
    allocatorFree                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Allocator = Allocator (SP.ManagedPtr Allocator)
    deriving (Eq)

instance SP.ManagedPtrNewtype Allocator where
    toManagedPtr (Allocator p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr Allocator where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Allocator
type instance O.AttributeList Allocator = AllocatorAttributeList
type AllocatorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Allocator::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "allocator"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Allocator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_allocator_free" g_allocator_free :: 
    Ptr Allocator ->                        -- allocator : TInterface (Name {namespace = "GLib", name = "Allocator"})
    IO ()

-- | /No description available in the introspection data./
allocatorFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Allocator
    -> m ()
allocatorFree allocator = liftIO $ do
    allocator' <- unsafeManagedPtrGetPtr allocator
    g_allocator_free allocator'
    touchManagedPtr allocator
    return ()

#if defined(ENABLE_OVERLOADING)
data AllocatorFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AllocatorFreeMethodInfo Allocator signature where
    overloadedMethod = allocatorFree

instance O.OverloadedMethodInfo AllocatorFreeMethodInfo Allocator where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Allocator.allocatorFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.29/docs/GI-GLib-Structs-Allocator.html#v:allocatorFree"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAllocatorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAllocatorMethod "free" o = AllocatorFreeMethodInfo
    ResolveAllocatorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAllocatorMethod t Allocator, O.OverloadedMethod info Allocator p) => OL.IsLabel t (Allocator -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAllocatorMethod t Allocator, O.OverloadedMethod info Allocator p, R.HasField t Allocator p) => R.HasField t Allocator p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAllocatorMethod t Allocator, O.OverloadedMethodInfo info Allocator) => OL.IsLabel t (O.MethodProxy info Allocator) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


