

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Enums
    ( 

 -- * Enumerations


-- ** BookmarkFileError #enum:BookmarkFileError#

    BookmarkFileError(..)                   ,
    catchBookmarkFileError                  ,
    handleBookmarkFileError                 ,


-- ** ChecksumType #enum:ChecksumType#

    ChecksumType(..)                        ,


-- ** ConvertError #enum:ConvertError#

    ConvertError(..)                        ,
    catchConvertError                       ,
    handleConvertError                      ,


-- ** DateDMY #enum:DateDMY#

    DateDMY(..)                             ,


-- ** DateMonth #enum:DateMonth#

    DateMonth(..)                           ,


-- ** DateWeekday #enum:DateWeekday#

    DateWeekday(..)                         ,


-- ** ErrorType #enum:ErrorType#

    ErrorType(..)                           ,


-- ** FileError #enum:FileError#

    FileError(..)                           ,
    catchFileError                          ,
    handleFileError                         ,


-- ** IOChannelError #enum:IOChannelError#

    IOChannelError(..)                      ,
    catchIOChannelError                     ,
    handleIOChannelError                    ,


-- ** IOError #enum:IOError#

    IOError(..)                             ,


-- ** IOStatus #enum:IOStatus#

    IOStatus(..)                            ,


-- ** KeyFileError #enum:KeyFileError#

    KeyFileError(..)                        ,
    catchKeyFileError                       ,
    handleKeyFileError                      ,


-- ** LogWriterOutput #enum:LogWriterOutput#

    LogWriterOutput(..)                     ,


-- ** MarkupError #enum:MarkupError#

    MarkupError(..)                         ,
    catchMarkupError                        ,
    handleMarkupError                       ,


-- ** NormalizeMode #enum:NormalizeMode#

    NormalizeMode(..)                       ,


-- ** NumberParserError #enum:NumberParserError#

    NumberParserError(..)                   ,
    catchNumberParserError                  ,
    handleNumberParserError                 ,


-- ** OnceStatus #enum:OnceStatus#

    OnceStatus(..)                          ,


-- ** OptionArg #enum:OptionArg#

    OptionArg(..)                           ,


-- ** OptionError #enum:OptionError#

    OptionError(..)                         ,
    catchOptionError                        ,
    handleOptionError                       ,


-- ** RegexError #enum:RegexError#

    RegexError(..)                          ,
    catchRegexError                         ,
    handleRegexError                        ,


-- ** SeekType #enum:SeekType#

    SeekType(..)                            ,


-- ** ShellError #enum:ShellError#

    ShellError(..)                          ,
    catchShellError                         ,
    handleShellError                        ,


-- ** SliceConfig #enum:SliceConfig#

    SliceConfig(..)                         ,


-- ** SpawnError #enum:SpawnError#

    SpawnError(..)                          ,
    catchSpawnError                         ,
    handleSpawnError                        ,


-- ** TestFileType #enum:TestFileType#

    TestFileType(..)                        ,


-- ** TestLogType #enum:TestLogType#

    TestLogType(..)                         ,


-- ** TestResult #enum:TestResult#

    TestResult(..)                          ,


-- ** ThreadError #enum:ThreadError#

    ThreadError(..)                         ,
    catchThreadError                        ,
    handleThreadError                       ,


-- ** TimeType #enum:TimeType#

    TimeType(..)                            ,


-- ** TokenType #enum:TokenType#

    TokenType(..)                           ,


-- ** TraverseType #enum:TraverseType#

    TraverseType(..)                        ,


-- ** UnicodeBreakType #enum:UnicodeBreakType#

    UnicodeBreakType(..)                    ,


-- ** UnicodeScript #enum:UnicodeScript#

    UnicodeScript(..)                       ,


-- ** UnicodeType #enum:UnicodeType#

    UnicodeType(..)                         ,


-- ** UnixPipeEnd #enum:UnixPipeEnd#

    UnixPipeEnd(..)                         ,


-- ** UriError #enum:UriError#

    UriError(..)                            ,
    catchUriError                           ,
    handleUriError                          ,


-- ** UserDirectory #enum:UserDirectory#

    UserDirectory(..)                       ,


-- ** VariantClass #enum:VariantClass#

    VariantClass(..)                        ,


-- ** VariantParseError #enum:VariantParseError#

    VariantParseError(..)                   ,
    catchVariantParseError                  ,
    handleVariantParseError                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum VariantParseError
-- | Error codes returned by parsing text-format GVariants.
data VariantParseError = 
      VariantParseErrorFailed
    -- ^ generic error (unused)
    | VariantParseErrorBasicTypeExpected
    -- ^ a non-basic t'GI.GLib.Structs.VariantType.VariantType' was given where a basic type was expected
    | VariantParseErrorCannotInferType
    -- ^ cannot infer the t'GI.GLib.Structs.VariantType.VariantType'
    | VariantParseErrorDefiniteTypeExpected
    -- ^ an indefinite t'GI.GLib.Structs.VariantType.VariantType' was given where a definite type was expected
    | VariantParseErrorInputNotAtEnd
    -- ^ extra data after parsing finished
    | VariantParseErrorInvalidCharacter
    -- ^ invalid character in number or unicode escape
    | VariantParseErrorInvalidFormatString
    -- ^ not a valid t'GVariant' format string
    | VariantParseErrorInvalidObjectPath
    -- ^ not a valid object path
    | VariantParseErrorInvalidSignature
    -- ^ not a valid type signature
    | VariantParseErrorInvalidTypeString
    -- ^ not a valid t'GVariant' type string
    | VariantParseErrorNoCommonType
    -- ^ could not find a common type for array entries
    | VariantParseErrorNumberOutOfRange
    -- ^ the numerical value is out of range of the given type
    | VariantParseErrorNumberTooBig
    -- ^ the numerical value is out of range for any type
    | VariantParseErrorTypeError
    -- ^ cannot parse as variant of the specified type
    | VariantParseErrorUnexpectedToken
    -- ^ an unexpected token was encountered
    | VariantParseErrorUnknownKeyword
    -- ^ an unknown keyword was encountered
    | VariantParseErrorUnterminatedStringConstant
    -- ^ unterminated string constant
    | VariantParseErrorValueExpected
    -- ^ no value given
    | VariantParseErrorRecursion
    -- ^ variant was too deeply nested; t'GVariant' is only guaranteed to handle nesting up to 64 levels (Since: 2.64)
    | AnotherVariantParseError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum VariantParseError where
    fromEnum VariantParseErrorFailed = 0
    fromEnum VariantParseErrorBasicTypeExpected = 1
    fromEnum VariantParseErrorCannotInferType = 2
    fromEnum VariantParseErrorDefiniteTypeExpected = 3
    fromEnum VariantParseErrorInputNotAtEnd = 4
    fromEnum VariantParseErrorInvalidCharacter = 5
    fromEnum VariantParseErrorInvalidFormatString = 6
    fromEnum VariantParseErrorInvalidObjectPath = 7
    fromEnum VariantParseErrorInvalidSignature = 8
    fromEnum VariantParseErrorInvalidTypeString = 9
    fromEnum VariantParseErrorNoCommonType = 10
    fromEnum VariantParseErrorNumberOutOfRange = 11
    fromEnum VariantParseErrorNumberTooBig = 12
    fromEnum VariantParseErrorTypeError = 13
    fromEnum VariantParseErrorUnexpectedToken = 14
    fromEnum VariantParseErrorUnknownKeyword = 15
    fromEnum VariantParseErrorUnterminatedStringConstant = 16
    fromEnum VariantParseErrorValueExpected = 17
    fromEnum VariantParseErrorRecursion = 18
    fromEnum (AnotherVariantParseError k) = k

    toEnum 0 = VariantParseErrorFailed
    toEnum 1 = VariantParseErrorBasicTypeExpected
    toEnum 2 = VariantParseErrorCannotInferType
    toEnum 3 = VariantParseErrorDefiniteTypeExpected
    toEnum 4 = VariantParseErrorInputNotAtEnd
    toEnum 5 = VariantParseErrorInvalidCharacter
    toEnum 6 = VariantParseErrorInvalidFormatString
    toEnum 7 = VariantParseErrorInvalidObjectPath
    toEnum 8 = VariantParseErrorInvalidSignature
    toEnum 9 = VariantParseErrorInvalidTypeString
    toEnum 10 = VariantParseErrorNoCommonType
    toEnum 11 = VariantParseErrorNumberOutOfRange
    toEnum 12 = VariantParseErrorNumberTooBig
    toEnum 13 = VariantParseErrorTypeError
    toEnum 14 = VariantParseErrorUnexpectedToken
    toEnum 15 = VariantParseErrorUnknownKeyword
    toEnum 16 = VariantParseErrorUnterminatedStringConstant
    toEnum 17 = VariantParseErrorValueExpected
    toEnum 18 = VariantParseErrorRecursion
    toEnum k = AnotherVariantParseError k

instance P.Ord VariantParseError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass VariantParseError where
    gerrorClassDomain _ = "g-variant-parse-error-quark"

-- | Catch exceptions of type `VariantParseError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchVariantParseError ::
    IO a ->
    (VariantParseError -> GErrorMessage -> IO a) ->
    IO a
catchVariantParseError = catchGErrorJustDomain

-- | Handle exceptions of type `VariantParseError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleVariantParseError ::
    (VariantParseError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleVariantParseError = handleGErrorJustDomain

-- Enum VariantClass
-- | The range of possible top-level types of t'GVariant' instances.
-- 
-- /Since: 2.24/
data VariantClass = 
      VariantClassBoolean
    -- ^ The t'GVariant' is a boolean.
    | VariantClassByte
    -- ^ The t'GVariant' is a byte.
    | VariantClassInt16
    -- ^ The t'GVariant' is a signed 16 bit integer.
    | VariantClassUint16
    -- ^ The t'GVariant' is an unsigned 16 bit integer.
    | VariantClassInt32
    -- ^ The t'GVariant' is a signed 32 bit integer.
    | VariantClassUint32
    -- ^ The t'GVariant' is an unsigned 32 bit integer.
    | VariantClassInt64
    -- ^ The t'GVariant' is a signed 64 bit integer.
    | VariantClassUint64
    -- ^ The t'GVariant' is an unsigned 64 bit integer.
    | VariantClassHandle
    -- ^ The t'GVariant' is a file handle index.
    | VariantClassDouble
    -- ^ The t'GVariant' is a double precision floating
    --                          point value.
    | VariantClassString
    -- ^ The t'GVariant' is a normal string.
    | VariantClassObjectPath
    -- ^ The t'GVariant' is a D-Bus object path
    --                               string.
    | VariantClassSignature
    -- ^ The t'GVariant' is a D-Bus signature string.
    | VariantClassVariant
    -- ^ The t'GVariant' is a variant.
    | VariantClassMaybe
    -- ^ The t'GVariant' is a maybe-typed value.
    | VariantClassArray
    -- ^ The t'GVariant' is an array.
    | VariantClassTuple
    -- ^ The t'GVariant' is a tuple.
    | VariantClassDictEntry
    -- ^ The t'GVariant' is a dictionary entry.
    | AnotherVariantClass Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum VariantClass where
    fromEnum VariantClassBoolean = 98
    fromEnum VariantClassByte = 121
    fromEnum VariantClassInt16 = 110
    fromEnum VariantClassUint16 = 113
    fromEnum VariantClassInt32 = 105
    fromEnum VariantClassUint32 = 117
    fromEnum VariantClassInt64 = 120
    fromEnum VariantClassUint64 = 116
    fromEnum VariantClassHandle = 104
    fromEnum VariantClassDouble = 100
    fromEnum VariantClassString = 115
    fromEnum VariantClassObjectPath = 111
    fromEnum VariantClassSignature = 103
    fromEnum VariantClassVariant = 118
    fromEnum VariantClassMaybe = 109
    fromEnum VariantClassArray = 97
    fromEnum VariantClassTuple = 40
    fromEnum VariantClassDictEntry = 123
    fromEnum (AnotherVariantClass k) = k

    toEnum 98 = VariantClassBoolean
    toEnum 121 = VariantClassByte
    toEnum 110 = VariantClassInt16
    toEnum 113 = VariantClassUint16
    toEnum 105 = VariantClassInt32
    toEnum 117 = VariantClassUint32
    toEnum 120 = VariantClassInt64
    toEnum 116 = VariantClassUint64
    toEnum 104 = VariantClassHandle
    toEnum 100 = VariantClassDouble
    toEnum 115 = VariantClassString
    toEnum 111 = VariantClassObjectPath
    toEnum 103 = VariantClassSignature
    toEnum 118 = VariantClassVariant
    toEnum 109 = VariantClassMaybe
    toEnum 97 = VariantClassArray
    toEnum 40 = VariantClassTuple
    toEnum 123 = VariantClassDictEntry
    toEnum k = AnotherVariantClass k

instance P.Ord VariantClass where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum UserDirectory
-- | These are logical ids for special directories which are defined
-- depending on the platform used. You should use 'GI.GLib.Functions.getUserSpecialDir'
-- to retrieve the full path associated to the logical id.
-- 
-- The t'GI.GLib.Enums.UserDirectory' enumeration can be extended at later date. Not
-- every platform has a directory for every logical id in this
-- enumeration.
-- 
-- /Since: 2.14/
data UserDirectory = 
      UserDirectoryDirectoryDesktop
    -- ^ the user\'s Desktop directory
    | UserDirectoryDirectoryDocuments
    -- ^ the user\'s Documents directory
    | UserDirectoryDirectoryDownload
    -- ^ the user\'s Downloads directory
    | UserDirectoryDirectoryMusic
    -- ^ the user\'s Music directory
    | UserDirectoryDirectoryPictures
    -- ^ the user\'s Pictures directory
    | UserDirectoryDirectoryPublicShare
    -- ^ the user\'s shared directory
    | UserDirectoryDirectoryTemplates
    -- ^ the user\'s Templates directory
    | UserDirectoryDirectoryVideos
    -- ^ the user\'s Movies directory
    | UserDirectoryNDirectories
    -- ^ the number of enum values
    | AnotherUserDirectory Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UserDirectory where
    fromEnum UserDirectoryDirectoryDesktop = 0
    fromEnum UserDirectoryDirectoryDocuments = 1
    fromEnum UserDirectoryDirectoryDownload = 2
    fromEnum UserDirectoryDirectoryMusic = 3
    fromEnum UserDirectoryDirectoryPictures = 4
    fromEnum UserDirectoryDirectoryPublicShare = 5
    fromEnum UserDirectoryDirectoryTemplates = 6
    fromEnum UserDirectoryDirectoryVideos = 7
    fromEnum UserDirectoryNDirectories = 8
    fromEnum (AnotherUserDirectory k) = k

    toEnum 0 = UserDirectoryDirectoryDesktop
    toEnum 1 = UserDirectoryDirectoryDocuments
    toEnum 2 = UserDirectoryDirectoryDownload
    toEnum 3 = UserDirectoryDirectoryMusic
    toEnum 4 = UserDirectoryDirectoryPictures
    toEnum 5 = UserDirectoryDirectoryPublicShare
    toEnum 6 = UserDirectoryDirectoryTemplates
    toEnum 7 = UserDirectoryDirectoryVideos
    toEnum 8 = UserDirectoryNDirectories
    toEnum k = AnotherUserDirectory k

instance P.Ord UserDirectory where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum UriError
-- | Error codes returned by t'GI.GLib.Structs.Uri.Uri' methods.
-- 
-- /Since: 2.66/
data UriError = 
      UriErrorFailed
    -- ^ Generic error if no more specific error is available.
    --     See the error message for details.
    | UriErrorBadScheme
    -- ^ The scheme of a URI could not be parsed.
    | UriErrorBadUser
    -- ^ The user\/userinfo of a URI could not be parsed.
    | UriErrorBadPassword
    -- ^ The password of a URI could not be parsed.
    | UriErrorBadAuthParams
    -- ^ The authentication parameters of a URI could not be parsed.
    | UriErrorBadHost
    -- ^ The host of a URI could not be parsed.
    | UriErrorBadPort
    -- ^ The port of a URI could not be parsed.
    | UriErrorBadPath
    -- ^ The path of a URI could not be parsed.
    | UriErrorBadQuery
    -- ^ The query of a URI could not be parsed.
    | UriErrorBadFragment
    -- ^ The fragment of a URI could not be parsed.
    | AnotherUriError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UriError where
    fromEnum UriErrorFailed = 0
    fromEnum UriErrorBadScheme = 1
    fromEnum UriErrorBadUser = 2
    fromEnum UriErrorBadPassword = 3
    fromEnum UriErrorBadAuthParams = 4
    fromEnum UriErrorBadHost = 5
    fromEnum UriErrorBadPort = 6
    fromEnum UriErrorBadPath = 7
    fromEnum UriErrorBadQuery = 8
    fromEnum UriErrorBadFragment = 9
    fromEnum (AnotherUriError k) = k

    toEnum 0 = UriErrorFailed
    toEnum 1 = UriErrorBadScheme
    toEnum 2 = UriErrorBadUser
    toEnum 3 = UriErrorBadPassword
    toEnum 4 = UriErrorBadAuthParams
    toEnum 5 = UriErrorBadHost
    toEnum 6 = UriErrorBadPort
    toEnum 7 = UriErrorBadPath
    toEnum 8 = UriErrorBadQuery
    toEnum 9 = UriErrorBadFragment
    toEnum k = AnotherUriError k

instance P.Ord UriError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass UriError where
    gerrorClassDomain _ = "g-uri-quark"

-- | Catch exceptions of type `UriError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchUriError ::
    IO a ->
    (UriError -> GErrorMessage -> IO a) ->
    IO a
catchUriError = catchGErrorJustDomain

-- | Handle exceptions of type `UriError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleUriError ::
    (UriError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleUriError = handleGErrorJustDomain

-- Enum UnixPipeEnd
-- | Mnemonic constants for the ends of a Unix pipe.
-- 
-- /Since: 2.80/
data UnixPipeEnd = 
      UnixPipeEndRead
    -- ^ The readable file descriptor 0
    | UnixPipeEndWrite
    -- ^ The writable file descriptor 1
    | AnotherUnixPipeEnd Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnixPipeEnd where
    fromEnum UnixPipeEndRead = 0
    fromEnum UnixPipeEndWrite = 1
    fromEnum (AnotherUnixPipeEnd k) = k

    toEnum 0 = UnixPipeEndRead
    toEnum 1 = UnixPipeEndWrite
    toEnum k = AnotherUnixPipeEnd k

instance P.Ord UnixPipeEnd where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum UnicodeType
-- | These are the possible character classifications from the
-- Unicode specification.
-- See <http://www.unicode.org/reports/tr44/#General_Category_Values Unicode Character Database>.
data UnicodeType = 
      UnicodeTypeControl
    -- ^ General category \"Other, Control\" (Cc)
    | UnicodeTypeFormat
    -- ^ General category \"Other, Format\" (Cf)
    | UnicodeTypeUnassigned
    -- ^ General category \"Other, Not Assigned\" (Cn)
    | UnicodeTypePrivateUse
    -- ^ General category \"Other, Private Use\" (Co)
    | UnicodeTypeSurrogate
    -- ^ General category \"Other, Surrogate\" (Cs)
    | UnicodeTypeLowercaseLetter
    -- ^ General category \"Letter, Lowercase\" (Ll)
    | UnicodeTypeModifierLetter
    -- ^ General category \"Letter, Modifier\" (Lm)
    | UnicodeTypeOtherLetter
    -- ^ General category \"Letter, Other\" (Lo)
    | UnicodeTypeTitlecaseLetter
    -- ^ General category \"Letter, Titlecase\" (Lt)
    | UnicodeTypeUppercaseLetter
    -- ^ General category \"Letter, Uppercase\" (Lu)
    | UnicodeTypeSpacingMark
    -- ^ General category \"Mark, Spacing\" (Mc)
    | UnicodeTypeEnclosingMark
    -- ^ General category \"Mark, Enclosing\" (Me)
    | UnicodeTypeNonSpacingMark
    -- ^ General category \"Mark, Nonspacing\" (Mn)
    | UnicodeTypeDecimalNumber
    -- ^ General category \"Number, Decimal Digit\" (Nd)
    | UnicodeTypeLetterNumber
    -- ^ General category \"Number, Letter\" (Nl)
    | UnicodeTypeOtherNumber
    -- ^ General category \"Number, Other\" (No)
    | UnicodeTypeConnectPunctuation
    -- ^ General category \"Punctuation, Connector\" (Pc)
    | UnicodeTypeDashPunctuation
    -- ^ General category \"Punctuation, Dash\" (Pd)
    | UnicodeTypeClosePunctuation
    -- ^ General category \"Punctuation, Close\" (Pe)
    | UnicodeTypeFinalPunctuation
    -- ^ General category \"Punctuation, Final quote\" (Pf)
    | UnicodeTypeInitialPunctuation
    -- ^ General category \"Punctuation, Initial quote\" (Pi)
    | UnicodeTypeOtherPunctuation
    -- ^ General category \"Punctuation, Other\" (Po)
    | UnicodeTypeOpenPunctuation
    -- ^ General category \"Punctuation, Open\" (Ps)
    | UnicodeTypeCurrencySymbol
    -- ^ General category \"Symbol, Currency\" (Sc)
    | UnicodeTypeModifierSymbol
    -- ^ General category \"Symbol, Modifier\" (Sk)
    | UnicodeTypeMathSymbol
    -- ^ General category \"Symbol, Math\" (Sm)
    | UnicodeTypeOtherSymbol
    -- ^ General category \"Symbol, Other\" (So)
    | UnicodeTypeLineSeparator
    -- ^ General category \"Separator, Line\" (Zl)
    | UnicodeTypeParagraphSeparator
    -- ^ General category \"Separator, Paragraph\" (Zp)
    | UnicodeTypeSpaceSeparator
    -- ^ General category \"Separator, Space\" (Zs)
    | AnotherUnicodeType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnicodeType where
    fromEnum UnicodeTypeControl = 0
    fromEnum UnicodeTypeFormat = 1
    fromEnum UnicodeTypeUnassigned = 2
    fromEnum UnicodeTypePrivateUse = 3
    fromEnum UnicodeTypeSurrogate = 4
    fromEnum UnicodeTypeLowercaseLetter = 5
    fromEnum UnicodeTypeModifierLetter = 6
    fromEnum UnicodeTypeOtherLetter = 7
    fromEnum UnicodeTypeTitlecaseLetter = 8
    fromEnum UnicodeTypeUppercaseLetter = 9
    fromEnum UnicodeTypeSpacingMark = 10
    fromEnum UnicodeTypeEnclosingMark = 11
    fromEnum UnicodeTypeNonSpacingMark = 12
    fromEnum UnicodeTypeDecimalNumber = 13
    fromEnum UnicodeTypeLetterNumber = 14
    fromEnum UnicodeTypeOtherNumber = 15
    fromEnum UnicodeTypeConnectPunctuation = 16
    fromEnum UnicodeTypeDashPunctuation = 17
    fromEnum UnicodeTypeClosePunctuation = 18
    fromEnum UnicodeTypeFinalPunctuation = 19
    fromEnum UnicodeTypeInitialPunctuation = 20
    fromEnum UnicodeTypeOtherPunctuation = 21
    fromEnum UnicodeTypeOpenPunctuation = 22
    fromEnum UnicodeTypeCurrencySymbol = 23
    fromEnum UnicodeTypeModifierSymbol = 24
    fromEnum UnicodeTypeMathSymbol = 25
    fromEnum UnicodeTypeOtherSymbol = 26
    fromEnum UnicodeTypeLineSeparator = 27
    fromEnum UnicodeTypeParagraphSeparator = 28
    fromEnum UnicodeTypeSpaceSeparator = 29
    fromEnum (AnotherUnicodeType k) = k

    toEnum 0 = UnicodeTypeControl
    toEnum 1 = UnicodeTypeFormat
    toEnum 2 = UnicodeTypeUnassigned
    toEnum 3 = UnicodeTypePrivateUse
    toEnum 4 = UnicodeTypeSurrogate
    toEnum 5 = UnicodeTypeLowercaseLetter
    toEnum 6 = UnicodeTypeModifierLetter
    toEnum 7 = UnicodeTypeOtherLetter
    toEnum 8 = UnicodeTypeTitlecaseLetter
    toEnum 9 = UnicodeTypeUppercaseLetter
    toEnum 10 = UnicodeTypeSpacingMark
    toEnum 11 = UnicodeTypeEnclosingMark
    toEnum 12 = UnicodeTypeNonSpacingMark
    toEnum 13 = UnicodeTypeDecimalNumber
    toEnum 14 = UnicodeTypeLetterNumber
    toEnum 15 = UnicodeTypeOtherNumber
    toEnum 16 = UnicodeTypeConnectPunctuation
    toEnum 17 = UnicodeTypeDashPunctuation
    toEnum 18 = UnicodeTypeClosePunctuation
    toEnum 19 = UnicodeTypeFinalPunctuation
    toEnum 20 = UnicodeTypeInitialPunctuation
    toEnum 21 = UnicodeTypeOtherPunctuation
    toEnum 22 = UnicodeTypeOpenPunctuation
    toEnum 23 = UnicodeTypeCurrencySymbol
    toEnum 24 = UnicodeTypeModifierSymbol
    toEnum 25 = UnicodeTypeMathSymbol
    toEnum 26 = UnicodeTypeOtherSymbol
    toEnum 27 = UnicodeTypeLineSeparator
    toEnum 28 = UnicodeTypeParagraphSeparator
    toEnum 29 = UnicodeTypeSpaceSeparator
    toEnum k = AnotherUnicodeType k

instance P.Ord UnicodeType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnicodeType = '[]
instance O.HasParentTypes UnicodeType

foreign import ccall "g_unicode_type_get_type" c_g_unicode_type_get_type :: 
    IO GType

instance B.Types.TypedObject UnicodeType where
    glibType = c_g_unicode_type_get_type

instance B.Types.BoxedEnum UnicodeType

-- Enum UnicodeScript
-- | The t'GI.GLib.Enums.UnicodeScript' enumeration identifies different writing
-- systems. The values correspond to the names as defined in the
-- Unicode standard. The enumeration has been added in GLib 2.14,
-- and is interchangeable with @/PangoScript/@.
-- 
-- Note that new types may be added in the future. Applications
-- should be ready to handle unknown values.
-- See <http://www.unicode.org/reports/tr24/ Unicode Standard Annex #24: Script names>.
data UnicodeScript = 
      UnicodeScriptInvalidCode
    -- ^ a value never returned from 'GI.GLib.Functions.unicharGetScript'
    | UnicodeScriptCommon
    -- ^ a character used by multiple different scripts
    | UnicodeScriptInherited
    -- ^ a mark glyph that takes its script from the
    --                               base glyph to which it is attached
    | UnicodeScriptArabic
    -- ^ Arabic
    | UnicodeScriptArmenian
    -- ^ Armenian
    | UnicodeScriptBengali
    -- ^ Bengali
    | UnicodeScriptBopomofo
    -- ^ Bopomofo
    | UnicodeScriptCherokee
    -- ^ Cherokee
    | UnicodeScriptCoptic
    -- ^ Coptic
    | UnicodeScriptCyrillic
    -- ^ Cyrillic
    | UnicodeScriptDeseret
    -- ^ Deseret
    | UnicodeScriptDevanagari
    -- ^ Devanagari
    | UnicodeScriptEthiopic
    -- ^ Ethiopic
    | UnicodeScriptGeorgian
    -- ^ Georgian
    | UnicodeScriptGothic
    -- ^ Gothic
    | UnicodeScriptGreek
    -- ^ Greek
    | UnicodeScriptGujarati
    -- ^ Gujarati
    | UnicodeScriptGurmukhi
    -- ^ Gurmukhi
    | UnicodeScriptHan
    -- ^ Han
    | UnicodeScriptHangul
    -- ^ Hangul
    | UnicodeScriptHebrew
    -- ^ Hebrew
    | UnicodeScriptHiragana
    -- ^ Hiragana
    | UnicodeScriptKannada
    -- ^ Kannada
    | UnicodeScriptKatakana
    -- ^ Katakana
    | UnicodeScriptKhmer
    -- ^ Khmer
    | UnicodeScriptLao
    -- ^ Lao
    | UnicodeScriptLatin
    -- ^ Latin
    | UnicodeScriptMalayalam
    -- ^ Malayalam
    | UnicodeScriptMongolian
    -- ^ Mongolian
    | UnicodeScriptMyanmar
    -- ^ Myanmar
    | UnicodeScriptOgham
    -- ^ Ogham
    | UnicodeScriptOldItalic
    -- ^ Old Italic
    | UnicodeScriptOriya
    -- ^ Oriya
    | UnicodeScriptRunic
    -- ^ Runic
    | UnicodeScriptSinhala
    -- ^ Sinhala
    | UnicodeScriptSyriac
    -- ^ Syriac
    | UnicodeScriptTamil
    -- ^ Tamil
    | UnicodeScriptTelugu
    -- ^ Telugu
    | UnicodeScriptThaana
    -- ^ Thaana
    | UnicodeScriptThai
    -- ^ Thai
    | UnicodeScriptTibetan
    -- ^ Tibetan
    | UnicodeScriptCanadianAboriginal
    -- ^ Canadian Aboriginal
    | UnicodeScriptYi
    -- ^ Yi
    | UnicodeScriptTagalog
    -- ^ Tagalog
    | UnicodeScriptHanunoo
    -- ^ Hanunoo
    | UnicodeScriptBuhid
    -- ^ Buhid
    | UnicodeScriptTagbanwa
    -- ^ Tagbanwa
    | UnicodeScriptBraille
    -- ^ Braille
    | UnicodeScriptCypriot
    -- ^ Cypriot
    | UnicodeScriptLimbu
    -- ^ Limbu
    | UnicodeScriptOsmanya
    -- ^ Osmanya
    | UnicodeScriptShavian
    -- ^ Shavian
    | UnicodeScriptLinearB
    -- ^ Linear B
    | UnicodeScriptTaiLe
    -- ^ Tai Le
    | UnicodeScriptUgaritic
    -- ^ Ugaritic
    | UnicodeScriptNewTaiLue
    -- ^ New Tai Lue
    | UnicodeScriptBuginese
    -- ^ Buginese
    | UnicodeScriptGlagolitic
    -- ^ Glagolitic
    | UnicodeScriptTifinagh
    -- ^ Tifinagh
    | UnicodeScriptSylotiNagri
    -- ^ Syloti Nagri
    | UnicodeScriptOldPersian
    -- ^ Old Persian
    | UnicodeScriptKharoshthi
    -- ^ Kharoshthi
    | UnicodeScriptUnknown
    -- ^ an unassigned code point
    | UnicodeScriptBalinese
    -- ^ Balinese
    | UnicodeScriptCuneiform
    -- ^ Cuneiform
    | UnicodeScriptPhoenician
    -- ^ Phoenician
    | UnicodeScriptPhagsPa
    -- ^ Phags-pa
    | UnicodeScriptNko
    -- ^ N\'Ko
    | UnicodeScriptKayahLi
    -- ^ Kayah Li. Since 2.16.3
    | UnicodeScriptLepcha
    -- ^ Lepcha. Since 2.16.3
    | UnicodeScriptRejang
    -- ^ Rejang. Since 2.16.3
    | UnicodeScriptSundanese
    -- ^ Sundanese. Since 2.16.3
    | UnicodeScriptSaurashtra
    -- ^ Saurashtra. Since 2.16.3
    | UnicodeScriptCham
    -- ^ Cham. Since 2.16.3
    | UnicodeScriptOlChiki
    -- ^ Ol Chiki. Since 2.16.3
    | UnicodeScriptVai
    -- ^ Vai. Since 2.16.3
    | UnicodeScriptCarian
    -- ^ Carian. Since 2.16.3
    | UnicodeScriptLycian
    -- ^ Lycian. Since 2.16.3
    | UnicodeScriptLydian
    -- ^ Lydian. Since 2.16.3
    | UnicodeScriptAvestan
    -- ^ Avestan. Since 2.26
    | UnicodeScriptBamum
    -- ^ Bamum. Since 2.26
    | UnicodeScriptEgyptianHieroglyphs
    -- ^ Egyptian Hieroglpyhs. Since 2.26
    | UnicodeScriptImperialAramaic
    -- ^ Imperial Aramaic. Since 2.26
    | UnicodeScriptInscriptionalPahlavi
    -- ^ Inscriptional Pahlavi. Since 2.26
    | UnicodeScriptInscriptionalParthian
    -- ^ Inscriptional Parthian. Since 2.26
    | UnicodeScriptJavanese
    -- ^ Javanese. Since 2.26
    | UnicodeScriptKaithi
    -- ^ Kaithi. Since 2.26
    | UnicodeScriptLisu
    -- ^ Lisu. Since 2.26
    | UnicodeScriptMeeteiMayek
    -- ^ Meetei Mayek. Since 2.26
    | UnicodeScriptOldSouthArabian
    -- ^ Old South Arabian. Since 2.26
    | UnicodeScriptOldTurkic
    -- ^ Old Turkic. Since 2.28
    | UnicodeScriptSamaritan
    -- ^ Samaritan. Since 2.26
    | UnicodeScriptTaiTham
    -- ^ Tai Tham. Since 2.26
    | UnicodeScriptTaiViet
    -- ^ Tai Viet. Since 2.26
    | UnicodeScriptBatak
    -- ^ Batak. Since 2.28
    | UnicodeScriptBrahmi
    -- ^ Brahmi. Since 2.28
    | UnicodeScriptMandaic
    -- ^ Mandaic. Since 2.28
    | UnicodeScriptChakma
    -- ^ Chakma. Since: 2.32
    | UnicodeScriptMeroiticCursive
    -- ^ Meroitic Cursive. Since: 2.32
    | UnicodeScriptMeroiticHieroglyphs
    -- ^ Meroitic Hieroglyphs. Since: 2.32
    | UnicodeScriptMiao
    -- ^ Miao. Since: 2.32
    | UnicodeScriptSharada
    -- ^ Sharada. Since: 2.32
    | UnicodeScriptSoraSompeng
    -- ^ Sora Sompeng. Since: 2.32
    | UnicodeScriptTakri
    -- ^ Takri. Since: 2.32
    | UnicodeScriptBassaVah
    -- ^ Bassa. Since: 2.42
    | UnicodeScriptCaucasianAlbanian
    -- ^ Caucasian Albanian. Since: 2.42
    | UnicodeScriptDuployan
    -- ^ Duployan. Since: 2.42
    | UnicodeScriptElbasan
    -- ^ Elbasan. Since: 2.42
    | UnicodeScriptGrantha
    -- ^ Grantha. Since: 2.42
    | UnicodeScriptKhojki
    -- ^ Kjohki. Since: 2.42
    | UnicodeScriptKhudawadi
    -- ^ Khudawadi, Sindhi. Since: 2.42
    | UnicodeScriptLinearA
    -- ^ Linear A. Since: 2.42
    | UnicodeScriptMahajani
    -- ^ Mahajani. Since: 2.42
    | UnicodeScriptManichaean
    -- ^ Manichaean. Since: 2.42
    | UnicodeScriptMendeKikakui
    -- ^ Mende Kikakui. Since: 2.42
    | UnicodeScriptModi
    -- ^ Modi. Since: 2.42
    | UnicodeScriptMro
    -- ^ Mro. Since: 2.42
    | UnicodeScriptNabataean
    -- ^ Nabataean. Since: 2.42
    | UnicodeScriptOldNorthArabian
    -- ^ Old North Arabian. Since: 2.42
    | UnicodeScriptOldPermic
    -- ^ Old Permic. Since: 2.42
    | UnicodeScriptPahawhHmong
    -- ^ Pahawh Hmong. Since: 2.42
    | UnicodeScriptPalmyrene
    -- ^ Palmyrene. Since: 2.42
    | UnicodeScriptPauCinHau
    -- ^ Pau Cin Hau. Since: 2.42
    | UnicodeScriptPsalterPahlavi
    -- ^ Psalter Pahlavi. Since: 2.42
    | UnicodeScriptSiddham
    -- ^ Siddham. Since: 2.42
    | UnicodeScriptTirhuta
    -- ^ Tirhuta. Since: 2.42
    | UnicodeScriptWarangCiti
    -- ^ Warang Citi. Since: 2.42
    | UnicodeScriptAhom
    -- ^ Ahom. Since: 2.48
    | UnicodeScriptAnatolianHieroglyphs
    -- ^ Anatolian Hieroglyphs. Since: 2.48
    | UnicodeScriptHatran
    -- ^ Hatran. Since: 2.48
    | UnicodeScriptMultani
    -- ^ Multani. Since: 2.48
    | UnicodeScriptOldHungarian
    -- ^ Old Hungarian. Since: 2.48
    | UnicodeScriptSignwriting
    -- ^ Signwriting. Since: 2.48
    | UnicodeScriptAdlam
    -- ^ Adlam. Since: 2.50
    | UnicodeScriptBhaiksuki
    -- ^ Bhaiksuki. Since: 2.50
    | UnicodeScriptMarchen
    -- ^ Marchen. Since: 2.50
    | UnicodeScriptNewa
    -- ^ Newa. Since: 2.50
    | UnicodeScriptOsage
    -- ^ Osage. Since: 2.50
    | UnicodeScriptTangut
    -- ^ Tangut. Since: 2.50
    | UnicodeScriptMasaramGondi
    -- ^ Masaram Gondi. Since: 2.54
    | UnicodeScriptNushu
    -- ^ Nushu. Since: 2.54
    | UnicodeScriptSoyombo
    -- ^ Soyombo. Since: 2.54
    | UnicodeScriptZanabazarSquare
    -- ^ Zanabazar Square. Since: 2.54
    | UnicodeScriptDogra
    -- ^ Dogra. Since: 2.58
    | UnicodeScriptGunjalaGondi
    -- ^ Gunjala Gondi. Since: 2.58
    | UnicodeScriptHanifiRohingya
    -- ^ Hanifi Rohingya. Since: 2.58
    | UnicodeScriptMakasar
    -- ^ Makasar. Since: 2.58
    | UnicodeScriptMedefaidrin
    -- ^ Medefaidrin. Since: 2.58
    | UnicodeScriptOldSogdian
    -- ^ Old Sogdian. Since: 2.58
    | UnicodeScriptSogdian
    -- ^ Sogdian. Since: 2.58
    | UnicodeScriptElymaic
    -- ^ Elym. Since: 2.62
    | UnicodeScriptNandinagari
    -- ^ Nand. Since: 2.62
    | UnicodeScriptNyiakengPuachueHmong
    -- ^ Rohg. Since: 2.62
    | UnicodeScriptWancho
    -- ^ Wcho. Since: 2.62
    | UnicodeScriptChorasmian
    -- ^ Chorasmian. Since: 2.66
    | UnicodeScriptDivesAkuru
    -- ^ Dives Akuru. Since: 2.66
    | UnicodeScriptKhitanSmallScript
    -- ^ Khitan small script. Since: 2.66
    | UnicodeScriptYezidi
    -- ^ Yezidi. Since: 2.66
    | UnicodeScriptCyproMinoan
    -- ^ Cypro-Minoan. Since: 2.72
    | UnicodeScriptOldUyghur
    -- ^ Old Uyghur. Since: 2.72
    | UnicodeScriptTangsa
    -- ^ Tangsa. Since: 2.72
    | UnicodeScriptToto
    -- ^ Toto. Since: 2.72
    | UnicodeScriptVithkuqi
    -- ^ Vithkuqi. Since: 2.72
    | UnicodeScriptMath
    -- ^ Mathematical notation. Since: 2.72
    | UnicodeScriptKawi
    -- ^ Kawi. Since 2.74
    | UnicodeScriptNagMundari
    -- ^ Nag Mundari. Since 2.74
    | UnicodeScriptTodhri
    -- ^ Todhri. Since: 2.84
    | UnicodeScriptGaray
    -- ^ Garay. Since: 2.84
    | UnicodeScriptTuluTigalari
    -- ^ Tulu-Tigalari. Since: 2.84
    | UnicodeScriptSunuwar
    -- ^ Sunuwar. Since: 2.84
    | UnicodeScriptGurungKhema
    -- ^ Gurung Khema. Since: 2.84
    | UnicodeScriptKiratRai
    -- ^ Kirat Rai. Since: 2.84
    | UnicodeScriptOlOnal
    -- ^ Ol Onal. Since: 2.84
    | AnotherUnicodeScript Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnicodeScript where
    fromEnum UnicodeScriptInvalidCode = -1
    fromEnum UnicodeScriptCommon = 0
    fromEnum UnicodeScriptInherited = 1
    fromEnum UnicodeScriptArabic = 2
    fromEnum UnicodeScriptArmenian = 3
    fromEnum UnicodeScriptBengali = 4
    fromEnum UnicodeScriptBopomofo = 5
    fromEnum UnicodeScriptCherokee = 6
    fromEnum UnicodeScriptCoptic = 7
    fromEnum UnicodeScriptCyrillic = 8
    fromEnum UnicodeScriptDeseret = 9
    fromEnum UnicodeScriptDevanagari = 10
    fromEnum UnicodeScriptEthiopic = 11
    fromEnum UnicodeScriptGeorgian = 12
    fromEnum UnicodeScriptGothic = 13
    fromEnum UnicodeScriptGreek = 14
    fromEnum UnicodeScriptGujarati = 15
    fromEnum UnicodeScriptGurmukhi = 16
    fromEnum UnicodeScriptHan = 17
    fromEnum UnicodeScriptHangul = 18
    fromEnum UnicodeScriptHebrew = 19
    fromEnum UnicodeScriptHiragana = 20
    fromEnum UnicodeScriptKannada = 21
    fromEnum UnicodeScriptKatakana = 22
    fromEnum UnicodeScriptKhmer = 23
    fromEnum UnicodeScriptLao = 24
    fromEnum UnicodeScriptLatin = 25
    fromEnum UnicodeScriptMalayalam = 26
    fromEnum UnicodeScriptMongolian = 27
    fromEnum UnicodeScriptMyanmar = 28
    fromEnum UnicodeScriptOgham = 29
    fromEnum UnicodeScriptOldItalic = 30
    fromEnum UnicodeScriptOriya = 31
    fromEnum UnicodeScriptRunic = 32
    fromEnum UnicodeScriptSinhala = 33
    fromEnum UnicodeScriptSyriac = 34
    fromEnum UnicodeScriptTamil = 35
    fromEnum UnicodeScriptTelugu = 36
    fromEnum UnicodeScriptThaana = 37
    fromEnum UnicodeScriptThai = 38
    fromEnum UnicodeScriptTibetan = 39
    fromEnum UnicodeScriptCanadianAboriginal = 40
    fromEnum UnicodeScriptYi = 41
    fromEnum UnicodeScriptTagalog = 42
    fromEnum UnicodeScriptHanunoo = 43
    fromEnum UnicodeScriptBuhid = 44
    fromEnum UnicodeScriptTagbanwa = 45
    fromEnum UnicodeScriptBraille = 46
    fromEnum UnicodeScriptCypriot = 47
    fromEnum UnicodeScriptLimbu = 48
    fromEnum UnicodeScriptOsmanya = 49
    fromEnum UnicodeScriptShavian = 50
    fromEnum UnicodeScriptLinearB = 51
    fromEnum UnicodeScriptTaiLe = 52
    fromEnum UnicodeScriptUgaritic = 53
    fromEnum UnicodeScriptNewTaiLue = 54
    fromEnum UnicodeScriptBuginese = 55
    fromEnum UnicodeScriptGlagolitic = 56
    fromEnum UnicodeScriptTifinagh = 57
    fromEnum UnicodeScriptSylotiNagri = 58
    fromEnum UnicodeScriptOldPersian = 59
    fromEnum UnicodeScriptKharoshthi = 60
    fromEnum UnicodeScriptUnknown = 61
    fromEnum UnicodeScriptBalinese = 62
    fromEnum UnicodeScriptCuneiform = 63
    fromEnum UnicodeScriptPhoenician = 64
    fromEnum UnicodeScriptPhagsPa = 65
    fromEnum UnicodeScriptNko = 66
    fromEnum UnicodeScriptKayahLi = 67
    fromEnum UnicodeScriptLepcha = 68
    fromEnum UnicodeScriptRejang = 69
    fromEnum UnicodeScriptSundanese = 70
    fromEnum UnicodeScriptSaurashtra = 71
    fromEnum UnicodeScriptCham = 72
    fromEnum UnicodeScriptOlChiki = 73
    fromEnum UnicodeScriptVai = 74
    fromEnum UnicodeScriptCarian = 75
    fromEnum UnicodeScriptLycian = 76
    fromEnum UnicodeScriptLydian = 77
    fromEnum UnicodeScriptAvestan = 78
    fromEnum UnicodeScriptBamum = 79
    fromEnum UnicodeScriptEgyptianHieroglyphs = 80
    fromEnum UnicodeScriptImperialAramaic = 81
    fromEnum UnicodeScriptInscriptionalPahlavi = 82
    fromEnum UnicodeScriptInscriptionalParthian = 83
    fromEnum UnicodeScriptJavanese = 84
    fromEnum UnicodeScriptKaithi = 85
    fromEnum UnicodeScriptLisu = 86
    fromEnum UnicodeScriptMeeteiMayek = 87
    fromEnum UnicodeScriptOldSouthArabian = 88
    fromEnum UnicodeScriptOldTurkic = 89
    fromEnum UnicodeScriptSamaritan = 90
    fromEnum UnicodeScriptTaiTham = 91
    fromEnum UnicodeScriptTaiViet = 92
    fromEnum UnicodeScriptBatak = 93
    fromEnum UnicodeScriptBrahmi = 94
    fromEnum UnicodeScriptMandaic = 95
    fromEnum UnicodeScriptChakma = 96
    fromEnum UnicodeScriptMeroiticCursive = 97
    fromEnum UnicodeScriptMeroiticHieroglyphs = 98
    fromEnum UnicodeScriptMiao = 99
    fromEnum UnicodeScriptSharada = 100
    fromEnum UnicodeScriptSoraSompeng = 101
    fromEnum UnicodeScriptTakri = 102
    fromEnum UnicodeScriptBassaVah = 103
    fromEnum UnicodeScriptCaucasianAlbanian = 104
    fromEnum UnicodeScriptDuployan = 105
    fromEnum UnicodeScriptElbasan = 106
    fromEnum UnicodeScriptGrantha = 107
    fromEnum UnicodeScriptKhojki = 108
    fromEnum UnicodeScriptKhudawadi = 109
    fromEnum UnicodeScriptLinearA = 110
    fromEnum UnicodeScriptMahajani = 111
    fromEnum UnicodeScriptManichaean = 112
    fromEnum UnicodeScriptMendeKikakui = 113
    fromEnum UnicodeScriptModi = 114
    fromEnum UnicodeScriptMro = 115
    fromEnum UnicodeScriptNabataean = 116
    fromEnum UnicodeScriptOldNorthArabian = 117
    fromEnum UnicodeScriptOldPermic = 118
    fromEnum UnicodeScriptPahawhHmong = 119
    fromEnum UnicodeScriptPalmyrene = 120
    fromEnum UnicodeScriptPauCinHau = 121
    fromEnum UnicodeScriptPsalterPahlavi = 122
    fromEnum UnicodeScriptSiddham = 123
    fromEnum UnicodeScriptTirhuta = 124
    fromEnum UnicodeScriptWarangCiti = 125
    fromEnum UnicodeScriptAhom = 126
    fromEnum UnicodeScriptAnatolianHieroglyphs = 127
    fromEnum UnicodeScriptHatran = 128
    fromEnum UnicodeScriptMultani = 129
    fromEnum UnicodeScriptOldHungarian = 130
    fromEnum UnicodeScriptSignwriting = 131
    fromEnum UnicodeScriptAdlam = 132
    fromEnum UnicodeScriptBhaiksuki = 133
    fromEnum UnicodeScriptMarchen = 134
    fromEnum UnicodeScriptNewa = 135
    fromEnum UnicodeScriptOsage = 136
    fromEnum UnicodeScriptTangut = 137
    fromEnum UnicodeScriptMasaramGondi = 138
    fromEnum UnicodeScriptNushu = 139
    fromEnum UnicodeScriptSoyombo = 140
    fromEnum UnicodeScriptZanabazarSquare = 141
    fromEnum UnicodeScriptDogra = 142
    fromEnum UnicodeScriptGunjalaGondi = 143
    fromEnum UnicodeScriptHanifiRohingya = 144
    fromEnum UnicodeScriptMakasar = 145
    fromEnum UnicodeScriptMedefaidrin = 146
    fromEnum UnicodeScriptOldSogdian = 147
    fromEnum UnicodeScriptSogdian = 148
    fromEnum UnicodeScriptElymaic = 149
    fromEnum UnicodeScriptNandinagari = 150
    fromEnum UnicodeScriptNyiakengPuachueHmong = 151
    fromEnum UnicodeScriptWancho = 152
    fromEnum UnicodeScriptChorasmian = 153
    fromEnum UnicodeScriptDivesAkuru = 154
    fromEnum UnicodeScriptKhitanSmallScript = 155
    fromEnum UnicodeScriptYezidi = 156
    fromEnum UnicodeScriptCyproMinoan = 157
    fromEnum UnicodeScriptOldUyghur = 158
    fromEnum UnicodeScriptTangsa = 159
    fromEnum UnicodeScriptToto = 160
    fromEnum UnicodeScriptVithkuqi = 161
    fromEnum UnicodeScriptMath = 162
    fromEnum UnicodeScriptKawi = 163
    fromEnum UnicodeScriptNagMundari = 164
    fromEnum UnicodeScriptTodhri = 165
    fromEnum UnicodeScriptGaray = 166
    fromEnum UnicodeScriptTuluTigalari = 167
    fromEnum UnicodeScriptSunuwar = 168
    fromEnum UnicodeScriptGurungKhema = 169
    fromEnum UnicodeScriptKiratRai = 170
    fromEnum UnicodeScriptOlOnal = 171
    fromEnum (AnotherUnicodeScript k) = k

    toEnum -1 = UnicodeScriptInvalidCode
    toEnum 0 = UnicodeScriptCommon
    toEnum 1 = UnicodeScriptInherited
    toEnum 2 = UnicodeScriptArabic
    toEnum 3 = UnicodeScriptArmenian
    toEnum 4 = UnicodeScriptBengali
    toEnum 5 = UnicodeScriptBopomofo
    toEnum 6 = UnicodeScriptCherokee
    toEnum 7 = UnicodeScriptCoptic
    toEnum 8 = UnicodeScriptCyrillic
    toEnum 9 = UnicodeScriptDeseret
    toEnum 10 = UnicodeScriptDevanagari
    toEnum 11 = UnicodeScriptEthiopic
    toEnum 12 = UnicodeScriptGeorgian
    toEnum 13 = UnicodeScriptGothic
    toEnum 14 = UnicodeScriptGreek
    toEnum 15 = UnicodeScriptGujarati
    toEnum 16 = UnicodeScriptGurmukhi
    toEnum 17 = UnicodeScriptHan
    toEnum 18 = UnicodeScriptHangul
    toEnum 19 = UnicodeScriptHebrew
    toEnum 20 = UnicodeScriptHiragana
    toEnum 21 = UnicodeScriptKannada
    toEnum 22 = UnicodeScriptKatakana
    toEnum 23 = UnicodeScriptKhmer
    toEnum 24 = UnicodeScriptLao
    toEnum 25 = UnicodeScriptLatin
    toEnum 26 = UnicodeScriptMalayalam
    toEnum 27 = UnicodeScriptMongolian
    toEnum 28 = UnicodeScriptMyanmar
    toEnum 29 = UnicodeScriptOgham
    toEnum 30 = UnicodeScriptOldItalic
    toEnum 31 = UnicodeScriptOriya
    toEnum 32 = UnicodeScriptRunic
    toEnum 33 = UnicodeScriptSinhala
    toEnum 34 = UnicodeScriptSyriac
    toEnum 35 = UnicodeScriptTamil
    toEnum 36 = UnicodeScriptTelugu
    toEnum 37 = UnicodeScriptThaana
    toEnum 38 = UnicodeScriptThai
    toEnum 39 = UnicodeScriptTibetan
    toEnum 40 = UnicodeScriptCanadianAboriginal
    toEnum 41 = UnicodeScriptYi
    toEnum 42 = UnicodeScriptTagalog
    toEnum 43 = UnicodeScriptHanunoo
    toEnum 44 = UnicodeScriptBuhid
    toEnum 45 = UnicodeScriptTagbanwa
    toEnum 46 = UnicodeScriptBraille
    toEnum 47 = UnicodeScriptCypriot
    toEnum 48 = UnicodeScriptLimbu
    toEnum 49 = UnicodeScriptOsmanya
    toEnum 50 = UnicodeScriptShavian
    toEnum 51 = UnicodeScriptLinearB
    toEnum 52 = UnicodeScriptTaiLe
    toEnum 53 = UnicodeScriptUgaritic
    toEnum 54 = UnicodeScriptNewTaiLue
    toEnum 55 = UnicodeScriptBuginese
    toEnum 56 = UnicodeScriptGlagolitic
    toEnum 57 = UnicodeScriptTifinagh
    toEnum 58 = UnicodeScriptSylotiNagri
    toEnum 59 = UnicodeScriptOldPersian
    toEnum 60 = UnicodeScriptKharoshthi
    toEnum 61 = UnicodeScriptUnknown
    toEnum 62 = UnicodeScriptBalinese
    toEnum 63 = UnicodeScriptCuneiform
    toEnum 64 = UnicodeScriptPhoenician
    toEnum 65 = UnicodeScriptPhagsPa
    toEnum 66 = UnicodeScriptNko
    toEnum 67 = UnicodeScriptKayahLi
    toEnum 68 = UnicodeScriptLepcha
    toEnum 69 = UnicodeScriptRejang
    toEnum 70 = UnicodeScriptSundanese
    toEnum 71 = UnicodeScriptSaurashtra
    toEnum 72 = UnicodeScriptCham
    toEnum 73 = UnicodeScriptOlChiki
    toEnum 74 = UnicodeScriptVai
    toEnum 75 = UnicodeScriptCarian
    toEnum 76 = UnicodeScriptLycian
    toEnum 77 = UnicodeScriptLydian
    toEnum 78 = UnicodeScriptAvestan
    toEnum 79 = UnicodeScriptBamum
    toEnum 80 = UnicodeScriptEgyptianHieroglyphs
    toEnum 81 = UnicodeScriptImperialAramaic
    toEnum 82 = UnicodeScriptInscriptionalPahlavi
    toEnum 83 = UnicodeScriptInscriptionalParthian
    toEnum 84 = UnicodeScriptJavanese
    toEnum 85 = UnicodeScriptKaithi
    toEnum 86 = UnicodeScriptLisu
    toEnum 87 = UnicodeScriptMeeteiMayek
    toEnum 88 = UnicodeScriptOldSouthArabian
    toEnum 89 = UnicodeScriptOldTurkic
    toEnum 90 = UnicodeScriptSamaritan
    toEnum 91 = UnicodeScriptTaiTham
    toEnum 92 = UnicodeScriptTaiViet
    toEnum 93 = UnicodeScriptBatak
    toEnum 94 = UnicodeScriptBrahmi
    toEnum 95 = UnicodeScriptMandaic
    toEnum 96 = UnicodeScriptChakma
    toEnum 97 = UnicodeScriptMeroiticCursive
    toEnum 98 = UnicodeScriptMeroiticHieroglyphs
    toEnum 99 = UnicodeScriptMiao
    toEnum 100 = UnicodeScriptSharada
    toEnum 101 = UnicodeScriptSoraSompeng
    toEnum 102 = UnicodeScriptTakri
    toEnum 103 = UnicodeScriptBassaVah
    toEnum 104 = UnicodeScriptCaucasianAlbanian
    toEnum 105 = UnicodeScriptDuployan
    toEnum 106 = UnicodeScriptElbasan
    toEnum 107 = UnicodeScriptGrantha
    toEnum 108 = UnicodeScriptKhojki
    toEnum 109 = UnicodeScriptKhudawadi
    toEnum 110 = UnicodeScriptLinearA
    toEnum 111 = UnicodeScriptMahajani
    toEnum 112 = UnicodeScriptManichaean
    toEnum 113 = UnicodeScriptMendeKikakui
    toEnum 114 = UnicodeScriptModi
    toEnum 115 = UnicodeScriptMro
    toEnum 116 = UnicodeScriptNabataean
    toEnum 117 = UnicodeScriptOldNorthArabian
    toEnum 118 = UnicodeScriptOldPermic
    toEnum 119 = UnicodeScriptPahawhHmong
    toEnum 120 = UnicodeScriptPalmyrene
    toEnum 121 = UnicodeScriptPauCinHau
    toEnum 122 = UnicodeScriptPsalterPahlavi
    toEnum 123 = UnicodeScriptSiddham
    toEnum 124 = UnicodeScriptTirhuta
    toEnum 125 = UnicodeScriptWarangCiti
    toEnum 126 = UnicodeScriptAhom
    toEnum 127 = UnicodeScriptAnatolianHieroglyphs
    toEnum 128 = UnicodeScriptHatran
    toEnum 129 = UnicodeScriptMultani
    toEnum 130 = UnicodeScriptOldHungarian
    toEnum 131 = UnicodeScriptSignwriting
    toEnum 132 = UnicodeScriptAdlam
    toEnum 133 = UnicodeScriptBhaiksuki
    toEnum 134 = UnicodeScriptMarchen
    toEnum 135 = UnicodeScriptNewa
    toEnum 136 = UnicodeScriptOsage
    toEnum 137 = UnicodeScriptTangut
    toEnum 138 = UnicodeScriptMasaramGondi
    toEnum 139 = UnicodeScriptNushu
    toEnum 140 = UnicodeScriptSoyombo
    toEnum 141 = UnicodeScriptZanabazarSquare
    toEnum 142 = UnicodeScriptDogra
    toEnum 143 = UnicodeScriptGunjalaGondi
    toEnum 144 = UnicodeScriptHanifiRohingya
    toEnum 145 = UnicodeScriptMakasar
    toEnum 146 = UnicodeScriptMedefaidrin
    toEnum 147 = UnicodeScriptOldSogdian
    toEnum 148 = UnicodeScriptSogdian
    toEnum 149 = UnicodeScriptElymaic
    toEnum 150 = UnicodeScriptNandinagari
    toEnum 151 = UnicodeScriptNyiakengPuachueHmong
    toEnum 152 = UnicodeScriptWancho
    toEnum 153 = UnicodeScriptChorasmian
    toEnum 154 = UnicodeScriptDivesAkuru
    toEnum 155 = UnicodeScriptKhitanSmallScript
    toEnum 156 = UnicodeScriptYezidi
    toEnum 157 = UnicodeScriptCyproMinoan
    toEnum 158 = UnicodeScriptOldUyghur
    toEnum 159 = UnicodeScriptTangsa
    toEnum 160 = UnicodeScriptToto
    toEnum 161 = UnicodeScriptVithkuqi
    toEnum 162 = UnicodeScriptMath
    toEnum 163 = UnicodeScriptKawi
    toEnum 164 = UnicodeScriptNagMundari
    toEnum 165 = UnicodeScriptTodhri
    toEnum 166 = UnicodeScriptGaray
    toEnum 167 = UnicodeScriptTuluTigalari
    toEnum 168 = UnicodeScriptSunuwar
    toEnum 169 = UnicodeScriptGurungKhema
    toEnum 170 = UnicodeScriptKiratRai
    toEnum 171 = UnicodeScriptOlOnal
    toEnum k = AnotherUnicodeScript k

instance P.Ord UnicodeScript where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnicodeScript = '[]
instance O.HasParentTypes UnicodeScript

foreign import ccall "g_unicode_script_get_type" c_g_unicode_script_get_type :: 
    IO GType

instance B.Types.TypedObject UnicodeScript where
    glibType = c_g_unicode_script_get_type

instance B.Types.BoxedEnum UnicodeScript

-- Enum UnicodeBreakType
-- | These are the possible line break classifications.
-- 
-- Since new Unicode versions may add new types here, applications should be ready
-- to handle unknown values. They may be regarded as 'GI.GLib.Enums.UnicodeBreakTypeUnknown'.
-- 
-- See <https://www.unicode.org/reports/tr14/ Unicode Line Breaking Algorithm>.
data UnicodeBreakType = 
      UnicodeBreakTypeMandatory
    -- ^ Mandatory Break (BK)
    | UnicodeBreakTypeCarriageReturn
    -- ^ Carriage Return (CR)
    | UnicodeBreakTypeLineFeed
    -- ^ Line Feed (LF)
    | UnicodeBreakTypeCombiningMark
    -- ^ Attached Characters and Combining Marks (CM)
    | UnicodeBreakTypeSurrogate
    -- ^ Surrogates (SG)
    | UnicodeBreakTypeZeroWidthSpace
    -- ^ Zero Width Space (ZW)
    | UnicodeBreakTypeInseparable
    -- ^ Inseparable (IN)
    | UnicodeBreakTypeNonBreakingGlue
    -- ^ Non-breaking (\"Glue\") (GL)
    | UnicodeBreakTypeContingent
    -- ^ Contingent Break Opportunity (CB)
    | UnicodeBreakTypeSpace
    -- ^ Space (SP)
    | UnicodeBreakTypeAfter
    -- ^ Break Opportunity After (BA)
    | UnicodeBreakTypeBefore
    -- ^ Break Opportunity Before (BB)
    | UnicodeBreakTypeBeforeAndAfter
    -- ^ Break Opportunity Before and After (B2)
    | UnicodeBreakTypeHyphen
    -- ^ Hyphen (HY)
    | UnicodeBreakTypeNonStarter
    -- ^ Nonstarter (NS)
    | UnicodeBreakTypeOpenPunctuation
    -- ^ Opening Punctuation (OP)
    | UnicodeBreakTypeClosePunctuation
    -- ^ Closing Punctuation (CL)
    | UnicodeBreakTypeQuotation
    -- ^ Ambiguous Quotation (QU)
    | UnicodeBreakTypeExclamation
    -- ^ Exclamation\/Interrogation (EX)
    | UnicodeBreakTypeIdeographic
    -- ^ Ideographic (ID)
    | UnicodeBreakTypeNumeric
    -- ^ Numeric (NU)
    | UnicodeBreakTypeInfixSeparator
    -- ^ Infix Separator (Numeric) (IS)
    | UnicodeBreakTypeSymbol
    -- ^ Symbols Allowing Break After (SY)
    | UnicodeBreakTypeAlphabetic
    -- ^ Ordinary Alphabetic and Symbol Characters (AL)
    | UnicodeBreakTypePrefix
    -- ^ Prefix (Numeric) (PR)
    | UnicodeBreakTypePostfix
    -- ^ Postfix (Numeric) (PO)
    | UnicodeBreakTypeComplexContext
    -- ^ Complex Content Dependent (South East Asian) (SA)
    | UnicodeBreakTypeAmbiguous
    -- ^ Ambiguous (Alphabetic or Ideographic) (AI)
    | UnicodeBreakTypeUnknown
    -- ^ Unknown (XX)
    | UnicodeBreakTypeNextLine
    -- ^ Next Line (NL)
    | UnicodeBreakTypeWordJoiner
    -- ^ Word Joiner (WJ)
    | UnicodeBreakTypeHangulLJamo
    -- ^ Hangul L Jamo (JL)
    | UnicodeBreakTypeHangulVJamo
    -- ^ Hangul V Jamo (JV)
    | UnicodeBreakTypeHangulTJamo
    -- ^ Hangul T Jamo (JT)
    | UnicodeBreakTypeHangulLvSyllable
    -- ^ Hangul LV Syllable (H2)
    | UnicodeBreakTypeHangulLvtSyllable
    -- ^ Hangul LVT Syllable (H3)
    | UnicodeBreakTypeCloseParanthesis
    -- ^ Closing Parenthesis (CP). Since 2.28. Deprecated: 2.70: Use 'GI.GLib.Enums.UnicodeBreakTypeCloseParenthesis' instead.
    | UnicodeBreakTypeCloseParenthesis
    -- ^ Closing Parenthesis (CP). Since 2.70
    | UnicodeBreakTypeConditionalJapaneseStarter
    -- ^ Conditional Japanese Starter (CJ). Since: 2.32
    | UnicodeBreakTypeHebrewLetter
    -- ^ Hebrew Letter (HL). Since: 2.32
    | UnicodeBreakTypeRegionalIndicator
    -- ^ Regional Indicator (RI). Since: 2.36
    | UnicodeBreakTypeEmojiBase
    -- ^ Emoji Base (EB). Since: 2.50
    | UnicodeBreakTypeEmojiModifier
    -- ^ Emoji Modifier (EM). Since: 2.50
    | UnicodeBreakTypeZeroWidthJoiner
    -- ^ Zero Width Joiner (ZWJ). Since: 2.50
    | UnicodeBreakTypeAksara
    -- ^ Aksara (AK). Since: 2.80
    | UnicodeBreakTypeAksaraPreBase
    -- ^ Aksara Pre-Base (AP). Since: 2.80
    | UnicodeBreakTypeAksaraStart
    -- ^ Aksara Start (AS). Since: 2.80
    | UnicodeBreakTypeViramaFinal
    -- ^ Virama Final (VF). Since: 2.80
    | UnicodeBreakTypeVirama
    -- ^ Virama (VI). Since: 2.80
    | AnotherUnicodeBreakType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum UnicodeBreakType where
    fromEnum UnicodeBreakTypeMandatory = 0
    fromEnum UnicodeBreakTypeCarriageReturn = 1
    fromEnum UnicodeBreakTypeLineFeed = 2
    fromEnum UnicodeBreakTypeCombiningMark = 3
    fromEnum UnicodeBreakTypeSurrogate = 4
    fromEnum UnicodeBreakTypeZeroWidthSpace = 5
    fromEnum UnicodeBreakTypeInseparable = 6
    fromEnum UnicodeBreakTypeNonBreakingGlue = 7
    fromEnum UnicodeBreakTypeContingent = 8
    fromEnum UnicodeBreakTypeSpace = 9
    fromEnum UnicodeBreakTypeAfter = 10
    fromEnum UnicodeBreakTypeBefore = 11
    fromEnum UnicodeBreakTypeBeforeAndAfter = 12
    fromEnum UnicodeBreakTypeHyphen = 13
    fromEnum UnicodeBreakTypeNonStarter = 14
    fromEnum UnicodeBreakTypeOpenPunctuation = 15
    fromEnum UnicodeBreakTypeClosePunctuation = 16
    fromEnum UnicodeBreakTypeQuotation = 17
    fromEnum UnicodeBreakTypeExclamation = 18
    fromEnum UnicodeBreakTypeIdeographic = 19
    fromEnum UnicodeBreakTypeNumeric = 20
    fromEnum UnicodeBreakTypeInfixSeparator = 21
    fromEnum UnicodeBreakTypeSymbol = 22
    fromEnum UnicodeBreakTypeAlphabetic = 23
    fromEnum UnicodeBreakTypePrefix = 24
    fromEnum UnicodeBreakTypePostfix = 25
    fromEnum UnicodeBreakTypeComplexContext = 26
    fromEnum UnicodeBreakTypeAmbiguous = 27
    fromEnum UnicodeBreakTypeUnknown = 28
    fromEnum UnicodeBreakTypeNextLine = 29
    fromEnum UnicodeBreakTypeWordJoiner = 30
    fromEnum UnicodeBreakTypeHangulLJamo = 31
    fromEnum UnicodeBreakTypeHangulVJamo = 32
    fromEnum UnicodeBreakTypeHangulTJamo = 33
    fromEnum UnicodeBreakTypeHangulLvSyllable = 34
    fromEnum UnicodeBreakTypeHangulLvtSyllable = 35
    fromEnum UnicodeBreakTypeCloseParanthesis = 36
    fromEnum UnicodeBreakTypeCloseParenthesis = 36
    fromEnum UnicodeBreakTypeConditionalJapaneseStarter = 37
    fromEnum UnicodeBreakTypeHebrewLetter = 38
    fromEnum UnicodeBreakTypeRegionalIndicator = 39
    fromEnum UnicodeBreakTypeEmojiBase = 40
    fromEnum UnicodeBreakTypeEmojiModifier = 41
    fromEnum UnicodeBreakTypeZeroWidthJoiner = 42
    fromEnum UnicodeBreakTypeAksara = 43
    fromEnum UnicodeBreakTypeAksaraPreBase = 44
    fromEnum UnicodeBreakTypeAksaraStart = 45
    fromEnum UnicodeBreakTypeViramaFinal = 46
    fromEnum UnicodeBreakTypeVirama = 47
    fromEnum (AnotherUnicodeBreakType k) = k

    toEnum 0 = UnicodeBreakTypeMandatory
    toEnum 1 = UnicodeBreakTypeCarriageReturn
    toEnum 2 = UnicodeBreakTypeLineFeed
    toEnum 3 = UnicodeBreakTypeCombiningMark
    toEnum 4 = UnicodeBreakTypeSurrogate
    toEnum 5 = UnicodeBreakTypeZeroWidthSpace
    toEnum 6 = UnicodeBreakTypeInseparable
    toEnum 7 = UnicodeBreakTypeNonBreakingGlue
    toEnum 8 = UnicodeBreakTypeContingent
    toEnum 9 = UnicodeBreakTypeSpace
    toEnum 10 = UnicodeBreakTypeAfter
    toEnum 11 = UnicodeBreakTypeBefore
    toEnum 12 = UnicodeBreakTypeBeforeAndAfter
    toEnum 13 = UnicodeBreakTypeHyphen
    toEnum 14 = UnicodeBreakTypeNonStarter
    toEnum 15 = UnicodeBreakTypeOpenPunctuation
    toEnum 16 = UnicodeBreakTypeClosePunctuation
    toEnum 17 = UnicodeBreakTypeQuotation
    toEnum 18 = UnicodeBreakTypeExclamation
    toEnum 19 = UnicodeBreakTypeIdeographic
    toEnum 20 = UnicodeBreakTypeNumeric
    toEnum 21 = UnicodeBreakTypeInfixSeparator
    toEnum 22 = UnicodeBreakTypeSymbol
    toEnum 23 = UnicodeBreakTypeAlphabetic
    toEnum 24 = UnicodeBreakTypePrefix
    toEnum 25 = UnicodeBreakTypePostfix
    toEnum 26 = UnicodeBreakTypeComplexContext
    toEnum 27 = UnicodeBreakTypeAmbiguous
    toEnum 28 = UnicodeBreakTypeUnknown
    toEnum 29 = UnicodeBreakTypeNextLine
    toEnum 30 = UnicodeBreakTypeWordJoiner
    toEnum 31 = UnicodeBreakTypeHangulLJamo
    toEnum 32 = UnicodeBreakTypeHangulVJamo
    toEnum 33 = UnicodeBreakTypeHangulTJamo
    toEnum 34 = UnicodeBreakTypeHangulLvSyllable
    toEnum 35 = UnicodeBreakTypeHangulLvtSyllable
    toEnum 36 = UnicodeBreakTypeCloseParanthesis
    toEnum 37 = UnicodeBreakTypeConditionalJapaneseStarter
    toEnum 38 = UnicodeBreakTypeHebrewLetter
    toEnum 39 = UnicodeBreakTypeRegionalIndicator
    toEnum 40 = UnicodeBreakTypeEmojiBase
    toEnum 41 = UnicodeBreakTypeEmojiModifier
    toEnum 42 = UnicodeBreakTypeZeroWidthJoiner
    toEnum 43 = UnicodeBreakTypeAksara
    toEnum 44 = UnicodeBreakTypeAksaraPreBase
    toEnum 45 = UnicodeBreakTypeAksaraStart
    toEnum 46 = UnicodeBreakTypeViramaFinal
    toEnum 47 = UnicodeBreakTypeVirama
    toEnum k = AnotherUnicodeBreakType k

instance P.Ord UnicodeBreakType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes UnicodeBreakType = '[]
instance O.HasParentTypes UnicodeBreakType

foreign import ccall "g_unicode_break_type_get_type" c_g_unicode_break_type_get_type :: 
    IO GType

instance B.Types.TypedObject UnicodeBreakType where
    glibType = c_g_unicode_break_type_get_type

instance B.Types.BoxedEnum UnicodeBreakType

-- Enum TraverseType
-- | Specifies the type of traversal performed by 'GI.GLib.Structs.Tree.treeTraverse',
-- 'GI.GLib.Structs.Node.nodeTraverse' and @/g_node_find()/@.
-- 
-- The different orders are illustrated here:
-- 
-- * In order: A, B, C, D, E, F, G, H, I
-- \<picture>
--   \<source srcset=\"Sorted_binary_tree_inorder-dark.svg\"
--    media=\"(prefers-color-scheme: dark)\">
--   \<img src=\"Sorted_binary_tree_inorder.svg\"
--    alt=\"Sorted binary tree, in-order traversal\">
-- \<\/picture>
-- * Pre order: F, B, A, D, C, E, G, I, H
-- \<picture>
--   \<source srcset=\"Sorted_binary_tree_preorder-dark.svg\"
--    media=\"(prefers-color-scheme: dark)\">
--   \<img src=\"Sorted_binary_tree_preorder.svg\"
--    alt=\"Sorted binary tree, pre-order traversal\">
-- \<\/picture>
-- * Post order: A, C, E, D, B, H, I, G, F
-- \<picture>
--   \<source srcset=\"Sorted_binary_tree_postorder-dark.svg\"
--    media=\"(prefers-color-scheme: dark)\">
--   \<img src=\"Sorted_binary_tree_postorder.svg\"
--    alt=\"Sorted binary tree, post-order traversal\">
-- \<\/picture>
-- * Level order: F, B, G, A, D, I, C, E, H
-- \<picture>
--   \<source srcset=\"Sorted_binary_tree_breadth-first_traversal-dark.svg\"
--    media=\"(prefers-color-scheme: dark)\">
--   \<img src=\"Sorted_binary_tree_breadth-first_traversal.svg\"
--    alt=\"Sorted binary tree, breadth-first level order traversal\">
-- \<\/picture>
data TraverseType = 
      TraverseTypeInOrder
    -- ^ visits a node\'s left child first, then the node itself,
    --              then its right child. This is the one to use if you
    --              want the output sorted according to the compare
    --              function.
    | TraverseTypePreOrder
    -- ^ visits a node, then its children.
    | TraverseTypePostOrder
    -- ^ visits the node\'s children, then the node itself.
    | TraverseTypeLevelOrder
    -- ^ is not implemented for
    --              <http://developer.gnome.org/glib/stable/data-structures.html#binary-trees balanced binary trees>.
    --              For <http://developer.gnome.org/glib/stable/data-structures.html#n-ary-trees n-ary trees>, it
    --              visits the root node first, then its children, then
    --              its grandchildren, and so on. Note that this is less
    --              efficient than the other orders.
    | AnotherTraverseType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TraverseType where
    fromEnum TraverseTypeInOrder = 0
    fromEnum TraverseTypePreOrder = 1
    fromEnum TraverseTypePostOrder = 2
    fromEnum TraverseTypeLevelOrder = 3
    fromEnum (AnotherTraverseType k) = k

    toEnum 0 = TraverseTypeInOrder
    toEnum 1 = TraverseTypePreOrder
    toEnum 2 = TraverseTypePostOrder
    toEnum 3 = TraverseTypeLevelOrder
    toEnum k = AnotherTraverseType k

instance P.Ord TraverseType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum TokenType
-- | The possible types of token returned from each
-- 'GI.GLib.Structs.Scanner.scannerGetNextToken' call.
data TokenType = 
      TokenTypeEof
    -- ^ the end of the file
    | TokenTypeLeftParen
    -- ^ a \'(\' character
    | TokenTypeRightParen
    -- ^ a \')\' character
    | TokenTypeLeftCurly
    -- ^ a \'{\' character
    | TokenTypeRightCurly
    -- ^ a \'}\' character
    | TokenTypeLeftBrace
    -- ^ a \'[\' character
    | TokenTypeRightBrace
    -- ^ a \']\' character
    | TokenTypeEqualSign
    -- ^ a \'=\' character
    | TokenTypeComma
    -- ^ a \',\' character
    | TokenTypeNone
    -- ^ not a token
    | TokenTypeError
    -- ^ an error occurred
    | TokenTypeChar
    -- ^ a character
    | TokenTypeBinary
    -- ^ a binary integer
    | TokenTypeOctal
    -- ^ an octal integer
    | TokenTypeInt
    -- ^ an integer
    | TokenTypeHex
    -- ^ a hex integer
    | TokenTypeFloat
    -- ^ a floating point number
    | TokenTypeString
    -- ^ a string
    | TokenTypeSymbol
    -- ^ a symbol
    | TokenTypeIdentifier
    -- ^ an identifier
    | TokenTypeIdentifierNull
    -- ^ a null identifier
    | TokenTypeCommentSingle
    -- ^ one line comment
    | TokenTypeCommentMulti
    -- ^ multi line comment
    | AnotherTokenType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TokenType where
    fromEnum TokenTypeEof = 0
    fromEnum TokenTypeLeftParen = 40
    fromEnum TokenTypeRightParen = 41
    fromEnum TokenTypeLeftCurly = 123
    fromEnum TokenTypeRightCurly = 125
    fromEnum TokenTypeLeftBrace = 91
    fromEnum TokenTypeRightBrace = 93
    fromEnum TokenTypeEqualSign = 61
    fromEnum TokenTypeComma = 44
    fromEnum TokenTypeNone = 256
    fromEnum TokenTypeError = 257
    fromEnum TokenTypeChar = 258
    fromEnum TokenTypeBinary = 259
    fromEnum TokenTypeOctal = 260
    fromEnum TokenTypeInt = 261
    fromEnum TokenTypeHex = 262
    fromEnum TokenTypeFloat = 263
    fromEnum TokenTypeString = 264
    fromEnum TokenTypeSymbol = 265
    fromEnum TokenTypeIdentifier = 266
    fromEnum TokenTypeIdentifierNull = 267
    fromEnum TokenTypeCommentSingle = 268
    fromEnum TokenTypeCommentMulti = 269
    fromEnum (AnotherTokenType k) = k

    toEnum 0 = TokenTypeEof
    toEnum 40 = TokenTypeLeftParen
    toEnum 41 = TokenTypeRightParen
    toEnum 123 = TokenTypeLeftCurly
    toEnum 125 = TokenTypeRightCurly
    toEnum 91 = TokenTypeLeftBrace
    toEnum 93 = TokenTypeRightBrace
    toEnum 61 = TokenTypeEqualSign
    toEnum 44 = TokenTypeComma
    toEnum 256 = TokenTypeNone
    toEnum 257 = TokenTypeError
    toEnum 258 = TokenTypeChar
    toEnum 259 = TokenTypeBinary
    toEnum 260 = TokenTypeOctal
    toEnum 261 = TokenTypeInt
    toEnum 262 = TokenTypeHex
    toEnum 263 = TokenTypeFloat
    toEnum 264 = TokenTypeString
    toEnum 265 = TokenTypeSymbol
    toEnum 266 = TokenTypeIdentifier
    toEnum 267 = TokenTypeIdentifierNull
    toEnum 268 = TokenTypeCommentSingle
    toEnum 269 = TokenTypeCommentMulti
    toEnum k = AnotherTokenType k

instance P.Ord TokenType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum TimeType
-- | Disambiguates a given time in two ways.
-- 
-- First, specifies if the given time is in universal or local time.
-- 
-- Second, if the time is in local time, specifies if it is local
-- standard time or local daylight time.  This is important for the case
-- where the same local time occurs twice (during daylight savings time
-- transitions, for example).
data TimeType = 
      TimeTypeStandard
    -- ^ the time is in local standard time
    | TimeTypeDaylight
    -- ^ the time is in local daylight time
    | TimeTypeUniversal
    -- ^ the time is in UTC
    | AnotherTimeType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TimeType where
    fromEnum TimeTypeStandard = 0
    fromEnum TimeTypeDaylight = 1
    fromEnum TimeTypeUniversal = 2
    fromEnum (AnotherTimeType k) = k

    toEnum 0 = TimeTypeStandard
    toEnum 1 = TimeTypeDaylight
    toEnum 2 = TimeTypeUniversal
    toEnum k = AnotherTimeType k

instance P.Ord TimeType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum ThreadError
-- | Possible errors of thread related functions.
data ThreadError = 
      ThreadErrorThreadErrorAgain
    -- ^ a thread couldn\'t be created due to resource
    --                        shortage. Try again later.
    | AnotherThreadError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ThreadError where
    fromEnum ThreadErrorThreadErrorAgain = 0
    fromEnum (AnotherThreadError k) = k

    toEnum 0 = ThreadErrorThreadErrorAgain
    toEnum k = AnotherThreadError k

instance P.Ord ThreadError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ThreadError where
    gerrorClassDomain _ = "g_thread_error"

-- | Catch exceptions of type `ThreadError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchThreadError ::
    IO a ->
    (ThreadError -> GErrorMessage -> IO a) ->
    IO a
catchThreadError = catchGErrorJustDomain

-- | Handle exceptions of type `ThreadError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleThreadError ::
    (ThreadError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleThreadError = handleGErrorJustDomain

-- Enum TestResult
-- | /No description available in the introspection data./
data TestResult = 
      TestResultSuccess
    -- ^ /No description available in the introspection data./
    | TestResultSkipped
    -- ^ /No description available in the introspection data./
    | TestResultFailure
    -- ^ /No description available in the introspection data./
    | TestResultIncomplete
    -- ^ /No description available in the introspection data./
    | AnotherTestResult Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestResult where
    fromEnum TestResultSuccess = 0
    fromEnum TestResultSkipped = 1
    fromEnum TestResultFailure = 2
    fromEnum TestResultIncomplete = 3
    fromEnum (AnotherTestResult k) = k

    toEnum 0 = TestResultSuccess
    toEnum 1 = TestResultSkipped
    toEnum 2 = TestResultFailure
    toEnum 3 = TestResultIncomplete
    toEnum k = AnotherTestResult k

instance P.Ord TestResult where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum TestLogType
-- | /No description available in the introspection data./
data TestLogType = 
      TestLogTypeNone
    -- ^ /No description available in the introspection data./
    | TestLogTypeError
    -- ^ /No description available in the introspection data./
    | TestLogTypeStartBinary
    -- ^ /No description available in the introspection data./
    | TestLogTypeListCase
    -- ^ /No description available in the introspection data./
    | TestLogTypeSkipCase
    -- ^ /No description available in the introspection data./
    | TestLogTypeStartCase
    -- ^ /No description available in the introspection data./
    | TestLogTypeStopCase
    -- ^ /No description available in the introspection data./
    | TestLogTypeMinResult
    -- ^ /No description available in the introspection data./
    | TestLogTypeMaxResult
    -- ^ /No description available in the introspection data./
    | TestLogTypeMessage
    -- ^ /No description available in the introspection data./
    | TestLogTypeStartSuite
    -- ^ /No description available in the introspection data./
    | TestLogTypeStopSuite
    -- ^ /No description available in the introspection data./
    | AnotherTestLogType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestLogType where
    fromEnum TestLogTypeNone = 0
    fromEnum TestLogTypeError = 1
    fromEnum TestLogTypeStartBinary = 2
    fromEnum TestLogTypeListCase = 3
    fromEnum TestLogTypeSkipCase = 4
    fromEnum TestLogTypeStartCase = 5
    fromEnum TestLogTypeStopCase = 6
    fromEnum TestLogTypeMinResult = 7
    fromEnum TestLogTypeMaxResult = 8
    fromEnum TestLogTypeMessage = 9
    fromEnum TestLogTypeStartSuite = 10
    fromEnum TestLogTypeStopSuite = 11
    fromEnum (AnotherTestLogType k) = k

    toEnum 0 = TestLogTypeNone
    toEnum 1 = TestLogTypeError
    toEnum 2 = TestLogTypeStartBinary
    toEnum 3 = TestLogTypeListCase
    toEnum 4 = TestLogTypeSkipCase
    toEnum 5 = TestLogTypeStartCase
    toEnum 6 = TestLogTypeStopCase
    toEnum 7 = TestLogTypeMinResult
    toEnum 8 = TestLogTypeMaxResult
    toEnum 9 = TestLogTypeMessage
    toEnum 10 = TestLogTypeStartSuite
    toEnum 11 = TestLogTypeStopSuite
    toEnum k = AnotherTestLogType k

instance P.Ord TestLogType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum TestFileType
-- | The type of file to return the filename for, when used with
-- @/GLib.test_build_filename/@.
-- 
-- These two options correspond rather directly to the \'dist\' and
-- \'built\' terminology that automake uses and are explicitly used to
-- distinguish between the \'srcdir\' and \'builddir\' being separate. All
-- files in your project should either be dist (in the @EXTRA_DIST@ or
-- @dist_schema_DATA@ sense, in which case they will always be in the
-- srcdir) or built (in the @BUILT_SOURCES@ sense, in which case they
-- will always be in the builddir).
-- 
-- Note: As a general rule of automake, files that are generated only as
-- part of the build-from-git process (but then are distributed with the
-- tarball) always go in srcdir (even if doing a srcdir != builddir
-- build from git) and are considered as distributed files.
-- 
-- The same principles apply for other build systems, such as meson.
-- 
-- /Since: 2.38/
data TestFileType = 
      TestFileTypeDist
    -- ^ a file that was included in the distribution tarball
    | TestFileTypeBuilt
    -- ^ a file that was built on the compiling machine
    | AnotherTestFileType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestFileType where
    fromEnum TestFileTypeDist = 0
    fromEnum TestFileTypeBuilt = 1
    fromEnum (AnotherTestFileType k) = k

    toEnum 0 = TestFileTypeDist
    toEnum 1 = TestFileTypeBuilt
    toEnum k = AnotherTestFileType k

instance P.Ord TestFileType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum SpawnError
-- | Error codes returned by spawning processes.
data SpawnError = 
      SpawnErrorFork
    -- ^ Fork failed due to lack of memory.
    | SpawnErrorRead
    -- ^ Read or select on pipes failed.
    | SpawnErrorChdir
    -- ^ Changing to working directory failed.
    | SpawnErrorAcces
    -- ^ @/execv()/@ returned @EACCES@
    | SpawnErrorPerm
    -- ^ @/execv()/@ returned @EPERM@
    | SpawnErrorTooBig
    -- ^ @/execv()/@ returned @E2BIG@
    | SpawnError2big
    -- ^ deprecated alias for 'GI.GLib.Enums.SpawnErrorTooBig' (deprecated since GLib 2.32)
    | SpawnErrorNoexec
    -- ^ @/execv()/@ returned @ENOEXEC@
    | SpawnErrorNametoolong
    -- ^ @/execv()/@ returned @ENAMETOOLONG@
    | SpawnErrorNoent
    -- ^ @/execv()/@ returned @ENOENT@
    | SpawnErrorNomem
    -- ^ @/execv()/@ returned @ENOMEM@
    | SpawnErrorNotdir
    -- ^ @/execv()/@ returned @ENOTDIR@
    | SpawnErrorLoop
    -- ^ @/execv()/@ returned @ELOOP@
    | SpawnErrorTxtbusy
    -- ^ @/execv()/@ returned @ETXTBUSY@
    | SpawnErrorIo
    -- ^ @/execv()/@ returned @EIO@
    | SpawnErrorNfile
    -- ^ @/execv()/@ returned @ENFILE@
    | SpawnErrorMfile
    -- ^ @/execv()/@ returned @EMFILE@
    | SpawnErrorInval
    -- ^ @/execv()/@ returned @EINVAL@
    | SpawnErrorIsdir
    -- ^ @/execv()/@ returned @EISDIR@
    | SpawnErrorLibbad
    -- ^ @/execv()/@ returned @ELIBBAD@
    | SpawnErrorFailed
    -- ^ Some other fatal failure,
    --   @error->message@ should explain.
    | AnotherSpawnError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SpawnError where
    fromEnum SpawnErrorFork = 0
    fromEnum SpawnErrorRead = 1
    fromEnum SpawnErrorChdir = 2
    fromEnum SpawnErrorAcces = 3
    fromEnum SpawnErrorPerm = 4
    fromEnum SpawnErrorTooBig = 5
    fromEnum SpawnError2big = 5
    fromEnum SpawnErrorNoexec = 6
    fromEnum SpawnErrorNametoolong = 7
    fromEnum SpawnErrorNoent = 8
    fromEnum SpawnErrorNomem = 9
    fromEnum SpawnErrorNotdir = 10
    fromEnum SpawnErrorLoop = 11
    fromEnum SpawnErrorTxtbusy = 12
    fromEnum SpawnErrorIo = 13
    fromEnum SpawnErrorNfile = 14
    fromEnum SpawnErrorMfile = 15
    fromEnum SpawnErrorInval = 16
    fromEnum SpawnErrorIsdir = 17
    fromEnum SpawnErrorLibbad = 18
    fromEnum SpawnErrorFailed = 19
    fromEnum (AnotherSpawnError k) = k

    toEnum 0 = SpawnErrorFork
    toEnum 1 = SpawnErrorRead
    toEnum 2 = SpawnErrorChdir
    toEnum 3 = SpawnErrorAcces
    toEnum 4 = SpawnErrorPerm
    toEnum 5 = SpawnErrorTooBig
    toEnum 6 = SpawnErrorNoexec
    toEnum 7 = SpawnErrorNametoolong
    toEnum 8 = SpawnErrorNoent
    toEnum 9 = SpawnErrorNomem
    toEnum 10 = SpawnErrorNotdir
    toEnum 11 = SpawnErrorLoop
    toEnum 12 = SpawnErrorTxtbusy
    toEnum 13 = SpawnErrorIo
    toEnum 14 = SpawnErrorNfile
    toEnum 15 = SpawnErrorMfile
    toEnum 16 = SpawnErrorInval
    toEnum 17 = SpawnErrorIsdir
    toEnum 18 = SpawnErrorLibbad
    toEnum 19 = SpawnErrorFailed
    toEnum k = AnotherSpawnError k

instance P.Ord SpawnError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass SpawnError where
    gerrorClassDomain _ = "g-exec-error-quark"

-- | Catch exceptions of type `SpawnError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchSpawnError ::
    IO a ->
    (SpawnError -> GErrorMessage -> IO a) ->
    IO a
catchSpawnError = catchGErrorJustDomain

-- | Handle exceptions of type `SpawnError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleSpawnError ::
    (SpawnError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleSpawnError = handleGErrorJustDomain

-- Enum SliceConfig
-- | /No description available in the introspection data./
data SliceConfig = 
      SliceConfigAlwaysMalloc
    -- ^ /No description available in the introspection data./
    | SliceConfigBypassMagazines
    -- ^ /No description available in the introspection data./
    | SliceConfigWorkingSetMsecs
    -- ^ /No description available in the introspection data./
    | SliceConfigColorIncrement
    -- ^ /No description available in the introspection data./
    | SliceConfigChunkSizes
    -- ^ /No description available in the introspection data./
    | SliceConfigContentionCounter
    -- ^ /No description available in the introspection data./
    | AnotherSliceConfig Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SliceConfig where
    fromEnum SliceConfigAlwaysMalloc = 1
    fromEnum SliceConfigBypassMagazines = 2
    fromEnum SliceConfigWorkingSetMsecs = 3
    fromEnum SliceConfigColorIncrement = 4
    fromEnum SliceConfigChunkSizes = 5
    fromEnum SliceConfigContentionCounter = 6
    fromEnum (AnotherSliceConfig k) = k

    toEnum 1 = SliceConfigAlwaysMalloc
    toEnum 2 = SliceConfigBypassMagazines
    toEnum 3 = SliceConfigWorkingSetMsecs
    toEnum 4 = SliceConfigColorIncrement
    toEnum 5 = SliceConfigChunkSizes
    toEnum 6 = SliceConfigContentionCounter
    toEnum k = AnotherSliceConfig k

instance P.Ord SliceConfig where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum ShellError
-- | Error codes returned by shell functions.
data ShellError = 
      ShellErrorBadQuoting
    -- ^ Mismatched or otherwise mangled quoting.
    | ShellErrorEmptyString
    -- ^ String to be parsed was empty.
    | ShellErrorFailed
    -- ^ Some other error.
    | AnotherShellError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ShellError where
    fromEnum ShellErrorBadQuoting = 0
    fromEnum ShellErrorEmptyString = 1
    fromEnum ShellErrorFailed = 2
    fromEnum (AnotherShellError k) = k

    toEnum 0 = ShellErrorBadQuoting
    toEnum 1 = ShellErrorEmptyString
    toEnum 2 = ShellErrorFailed
    toEnum k = AnotherShellError k

instance P.Ord ShellError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ShellError where
    gerrorClassDomain _ = "g-shell-error-quark"

-- | Catch exceptions of type `ShellError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchShellError ::
    IO a ->
    (ShellError -> GErrorMessage -> IO a) ->
    IO a
catchShellError = catchGErrorJustDomain

-- | Handle exceptions of type `ShellError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleShellError ::
    (ShellError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleShellError = handleGErrorJustDomain

-- Enum SeekType
-- | An enumeration specifying the base position for a
-- 'GI.GLib.Structs.IOChannel.iOChannelSeekPosition' operation.
data SeekType = 
      SeekTypeCur
    -- ^ the current position in the file.
    | SeekTypeSet
    -- ^ the start of the file.
    | SeekTypeEnd
    -- ^ the end of the file.
    | AnotherSeekType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SeekType where
    fromEnum SeekTypeCur = 0
    fromEnum SeekTypeSet = 1
    fromEnum SeekTypeEnd = 2
    fromEnum (AnotherSeekType k) = k

    toEnum 0 = SeekTypeCur
    toEnum 1 = SeekTypeSet
    toEnum 2 = SeekTypeEnd
    toEnum k = AnotherSeekType k

instance P.Ord SeekType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum RegexError
-- | Error codes returned by regular expressions functions.
-- 
-- /Since: 2.14/
data RegexError = 
      RegexErrorCompile
    -- ^ Compilation of the regular expression failed.
    | RegexErrorOptimize
    -- ^ Optimization of the regular expression failed.
    | RegexErrorReplace
    -- ^ Replacement failed due to an ill-formed replacement
    --     string.
    | RegexErrorMatch
    -- ^ The match process failed.
    | RegexErrorInternal
    -- ^ Internal error of the regular expression engine.
    --     Since 2.16
    | RegexErrorStrayBackslash
    -- ^ \"\\\" at end of pattern. Since 2.16
    | RegexErrorMissingControlChar
    -- ^ \"\\c\" at end of pattern. Since 2.16
    | RegexErrorUnrecognizedEscape
    -- ^ Unrecognized character follows \"\\\".
    --     Since 2.16
    | RegexErrorQuantifiersOutOfOrder
    -- ^ Numbers out of order in \"{}\"
    --     quantifier. Since 2.16
    | RegexErrorQuantifierTooBig
    -- ^ Number too big in \"{}\" quantifier.
    --     Since 2.16
    | RegexErrorUnterminatedCharacterClass
    -- ^ Missing terminating \"]\" for
    --     character class. Since 2.16
    | RegexErrorInvalidEscapeInCharacterClass
    -- ^ Invalid escape sequence
    --     in character class. Since 2.16
    | RegexErrorRangeOutOfOrder
    -- ^ Range out of order in character class.
    --     Since 2.16
    | RegexErrorNothingToRepeat
    -- ^ Nothing to repeat. Since 2.16
    | RegexErrorUnrecognizedCharacter
    -- ^ Unrecognized character after \"(?\",
    --     \"(?\<\" or \"(?P\". Since 2.16
    | RegexErrorPosixNamedClassOutsideClass
    -- ^ POSIX named classes are
    --     supported only within a class. Since 2.16
    | RegexErrorUnmatchedParenthesis
    -- ^ Missing terminating \")\" or \")\"
    --     without opening \"(\". Since 2.16
    | RegexErrorInexistentSubpatternReference
    -- ^ Reference to non-existent
    --     subpattern. Since 2.16
    | RegexErrorUnterminatedComment
    -- ^ Missing terminating \")\" after comment.
    --     Since 2.16
    | RegexErrorExpressionTooLarge
    -- ^ Regular expression too large.
    --     Since 2.16
    | RegexErrorMemoryError
    -- ^ Failed to get memory. Since 2.16
    | RegexErrorVariableLengthLookbehind
    -- ^ Lookbehind assertion is not
    --     fixed length. Since 2.16
    | RegexErrorMalformedCondition
    -- ^ Malformed number or name after \"(?(\".
    --     Since 2.16
    | RegexErrorTooManyConditionalBranches
    -- ^ Conditional group contains
    --     more than two branches. Since 2.16
    | RegexErrorAssertionExpected
    -- ^ Assertion expected after \"(?(\".
    --     Since 2.16
    | RegexErrorUnknownPosixClassName
    -- ^ Unknown POSIX class name.
    --     Since 2.16
    | RegexErrorPosixCollatingElementsNotSupported
    -- ^ POSIX collating
    --     elements are not supported. Since 2.16
    | RegexErrorHexCodeTooLarge
    -- ^ Character value in \"\\x{...}\" sequence
    --     is too large. Since 2.16
    | RegexErrorInvalidCondition
    -- ^ Invalid condition \"(?(0)\". Since 2.16
    | RegexErrorSingleByteMatchInLookbehind
    -- ^ \\C not allowed in
    --     lookbehind assertion. Since 2.16
    | RegexErrorInfiniteLoop
    -- ^ Recursive call could loop indefinitely.
    --     Since 2.16
    | RegexErrorMissingSubpatternNameTerminator
    -- ^ Missing terminator
    --     in subpattern name. Since 2.16
    | RegexErrorDuplicateSubpatternName
    -- ^ Two named subpatterns have
    --     the same name. Since 2.16
    | RegexErrorMalformedProperty
    -- ^ Malformed \"\\P\" or \"\\p\" sequence.
    --     Since 2.16
    | RegexErrorUnknownProperty
    -- ^ Unknown property name after \"\\P\" or
    --     \"\\p\". Since 2.16
    | RegexErrorSubpatternNameTooLong
    -- ^ Subpattern name is too long
    --     (maximum 32 characters). Since 2.16
    | RegexErrorTooManySubpatterns
    -- ^ Too many named subpatterns (maximum
    --     10,000). Since 2.16
    | RegexErrorInvalidOctalValue
    -- ^ Octal value is greater than \"\\377\".
    --     Since 2.16
    | RegexErrorTooManyBranchesInDefine
    -- ^ \"DEFINE\" group contains more
    --     than one branch. Since 2.16
    | RegexErrorDefineRepetion
    -- ^ Repeating a \"DEFINE\" group is not allowed.
    --     This error is never raised. Since: 2.16 Deprecated: 2.34
    | RegexErrorInconsistentNewlineOptions
    -- ^ Inconsistent newline options.
    --     Since 2.16
    | RegexErrorMissingBackReference
    -- ^ \"\\g\" is not followed by a braced,
    --      angle-bracketed, or quoted name or number, or by a plain number. Since: 2.16
    | RegexErrorInvalidRelativeReference
    -- ^ relative reference must not be zero. Since: 2.34
    | RegexErrorBacktrackingControlVerbArgumentForbidden
    -- ^ the backtracing
    --     control verb used does not allow an argument. Since: 2.34
    | RegexErrorUnknownBacktrackingControlVerb
    -- ^ unknown backtracing
    --     control verb. Since: 2.34
    | RegexErrorNumberTooBig
    -- ^ number is too big in escape sequence. Since: 2.34
    | RegexErrorMissingSubpatternName
    -- ^ Missing subpattern name. Since: 2.34
    | RegexErrorMissingDigit
    -- ^ Missing digit. Since 2.34
    | RegexErrorInvalidDataCharacter
    -- ^ In JavaScript compatibility mode,
    --     \"[\" is an invalid data character. Since: 2.34
    | RegexErrorExtraSubpatternName
    -- ^ different names for subpatterns of the
    --     same number are not allowed. Since: 2.34
    | RegexErrorBacktrackingControlVerbArgumentRequired
    -- ^ the backtracing control
    --     verb requires an argument. Since: 2.34
    | RegexErrorInvalidControlChar
    -- ^ \"\\c\" must be followed by an ASCII
    --     character. Since: 2.34
    | RegexErrorMissingName
    -- ^ \"\\k\" is not followed by a braced, angle-bracketed, or
    --     quoted name. Since: 2.34
    | RegexErrorNotSupportedInClass
    -- ^ \"\\N\" is not supported in a class. Since: 2.34
    | RegexErrorTooManyForwardReferences
    -- ^ too many forward references. Since: 2.34
    | RegexErrorNameTooLong
    -- ^ the name is too long in \"(*MARK)\", \"(*PRUNE)\",
    --     \"(*SKIP)\", or \"(*THEN)\". Since: 2.34
    | RegexErrorCharacterValueTooLarge
    -- ^ the character value in the \\u sequence is
    --     too large. Since: 2.34
    | AnotherRegexError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RegexError where
    fromEnum RegexErrorCompile = 0
    fromEnum RegexErrorOptimize = 1
    fromEnum RegexErrorReplace = 2
    fromEnum RegexErrorMatch = 3
    fromEnum RegexErrorInternal = 4
    fromEnum RegexErrorStrayBackslash = 101
    fromEnum RegexErrorMissingControlChar = 102
    fromEnum RegexErrorUnrecognizedEscape = 103
    fromEnum RegexErrorQuantifiersOutOfOrder = 104
    fromEnum RegexErrorQuantifierTooBig = 105
    fromEnum RegexErrorUnterminatedCharacterClass = 106
    fromEnum RegexErrorInvalidEscapeInCharacterClass = 107
    fromEnum RegexErrorRangeOutOfOrder = 108
    fromEnum RegexErrorNothingToRepeat = 109
    fromEnum RegexErrorUnrecognizedCharacter = 112
    fromEnum RegexErrorPosixNamedClassOutsideClass = 113
    fromEnum RegexErrorUnmatchedParenthesis = 114
    fromEnum RegexErrorInexistentSubpatternReference = 115
    fromEnum RegexErrorUnterminatedComment = 118
    fromEnum RegexErrorExpressionTooLarge = 120
    fromEnum RegexErrorMemoryError = 121
    fromEnum RegexErrorVariableLengthLookbehind = 125
    fromEnum RegexErrorMalformedCondition = 126
    fromEnum RegexErrorTooManyConditionalBranches = 127
    fromEnum RegexErrorAssertionExpected = 128
    fromEnum RegexErrorUnknownPosixClassName = 130
    fromEnum RegexErrorPosixCollatingElementsNotSupported = 131
    fromEnum RegexErrorHexCodeTooLarge = 134
    fromEnum RegexErrorInvalidCondition = 135
    fromEnum RegexErrorSingleByteMatchInLookbehind = 136
    fromEnum RegexErrorInfiniteLoop = 140
    fromEnum RegexErrorMissingSubpatternNameTerminator = 142
    fromEnum RegexErrorDuplicateSubpatternName = 143
    fromEnum RegexErrorMalformedProperty = 146
    fromEnum RegexErrorUnknownProperty = 147
    fromEnum RegexErrorSubpatternNameTooLong = 148
    fromEnum RegexErrorTooManySubpatterns = 149
    fromEnum RegexErrorInvalidOctalValue = 151
    fromEnum RegexErrorTooManyBranchesInDefine = 154
    fromEnum RegexErrorDefineRepetion = 155
    fromEnum RegexErrorInconsistentNewlineOptions = 156
    fromEnum RegexErrorMissingBackReference = 157
    fromEnum RegexErrorInvalidRelativeReference = 158
    fromEnum RegexErrorBacktrackingControlVerbArgumentForbidden = 159
    fromEnum RegexErrorUnknownBacktrackingControlVerb = 160
    fromEnum RegexErrorNumberTooBig = 161
    fromEnum RegexErrorMissingSubpatternName = 162
    fromEnum RegexErrorMissingDigit = 163
    fromEnum RegexErrorInvalidDataCharacter = 164
    fromEnum RegexErrorExtraSubpatternName = 165
    fromEnum RegexErrorBacktrackingControlVerbArgumentRequired = 166
    fromEnum RegexErrorInvalidControlChar = 168
    fromEnum RegexErrorMissingName = 169
    fromEnum RegexErrorNotSupportedInClass = 171
    fromEnum RegexErrorTooManyForwardReferences = 172
    fromEnum RegexErrorNameTooLong = 175
    fromEnum RegexErrorCharacterValueTooLarge = 176
    fromEnum (AnotherRegexError k) = k

    toEnum 0 = RegexErrorCompile
    toEnum 1 = RegexErrorOptimize
    toEnum 2 = RegexErrorReplace
    toEnum 3 = RegexErrorMatch
    toEnum 4 = RegexErrorInternal
    toEnum 101 = RegexErrorStrayBackslash
    toEnum 102 = RegexErrorMissingControlChar
    toEnum 103 = RegexErrorUnrecognizedEscape
    toEnum 104 = RegexErrorQuantifiersOutOfOrder
    toEnum 105 = RegexErrorQuantifierTooBig
    toEnum 106 = RegexErrorUnterminatedCharacterClass
    toEnum 107 = RegexErrorInvalidEscapeInCharacterClass
    toEnum 108 = RegexErrorRangeOutOfOrder
    toEnum 109 = RegexErrorNothingToRepeat
    toEnum 112 = RegexErrorUnrecognizedCharacter
    toEnum 113 = RegexErrorPosixNamedClassOutsideClass
    toEnum 114 = RegexErrorUnmatchedParenthesis
    toEnum 115 = RegexErrorInexistentSubpatternReference
    toEnum 118 = RegexErrorUnterminatedComment
    toEnum 120 = RegexErrorExpressionTooLarge
    toEnum 121 = RegexErrorMemoryError
    toEnum 125 = RegexErrorVariableLengthLookbehind
    toEnum 126 = RegexErrorMalformedCondition
    toEnum 127 = RegexErrorTooManyConditionalBranches
    toEnum 128 = RegexErrorAssertionExpected
    toEnum 130 = RegexErrorUnknownPosixClassName
    toEnum 131 = RegexErrorPosixCollatingElementsNotSupported
    toEnum 134 = RegexErrorHexCodeTooLarge
    toEnum 135 = RegexErrorInvalidCondition
    toEnum 136 = RegexErrorSingleByteMatchInLookbehind
    toEnum 140 = RegexErrorInfiniteLoop
    toEnum 142 = RegexErrorMissingSubpatternNameTerminator
    toEnum 143 = RegexErrorDuplicateSubpatternName
    toEnum 146 = RegexErrorMalformedProperty
    toEnum 147 = RegexErrorUnknownProperty
    toEnum 148 = RegexErrorSubpatternNameTooLong
    toEnum 149 = RegexErrorTooManySubpatterns
    toEnum 151 = RegexErrorInvalidOctalValue
    toEnum 154 = RegexErrorTooManyBranchesInDefine
    toEnum 155 = RegexErrorDefineRepetion
    toEnum 156 = RegexErrorInconsistentNewlineOptions
    toEnum 157 = RegexErrorMissingBackReference
    toEnum 158 = RegexErrorInvalidRelativeReference
    toEnum 159 = RegexErrorBacktrackingControlVerbArgumentForbidden
    toEnum 160 = RegexErrorUnknownBacktrackingControlVerb
    toEnum 161 = RegexErrorNumberTooBig
    toEnum 162 = RegexErrorMissingSubpatternName
    toEnum 163 = RegexErrorMissingDigit
    toEnum 164 = RegexErrorInvalidDataCharacter
    toEnum 165 = RegexErrorExtraSubpatternName
    toEnum 166 = RegexErrorBacktrackingControlVerbArgumentRequired
    toEnum 168 = RegexErrorInvalidControlChar
    toEnum 169 = RegexErrorMissingName
    toEnum 171 = RegexErrorNotSupportedInClass
    toEnum 172 = RegexErrorTooManyForwardReferences
    toEnum 175 = RegexErrorNameTooLong
    toEnum 176 = RegexErrorCharacterValueTooLarge
    toEnum k = AnotherRegexError k

instance P.Ord RegexError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass RegexError where
    gerrorClassDomain _ = "g-regex-error-quark"

-- | Catch exceptions of type `RegexError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchRegexError ::
    IO a ->
    (RegexError -> GErrorMessage -> IO a) ->
    IO a
catchRegexError = catchGErrorJustDomain

-- | Handle exceptions of type `RegexError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleRegexError ::
    (RegexError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleRegexError = handleGErrorJustDomain

-- Enum OptionError
-- | Error codes returned by option parsing.
data OptionError = 
      OptionErrorUnknownOption
    -- ^ An option was not known to the parser.
    --  This error will only be reported, if the parser hasn\'t been instructed
    --  to ignore unknown options, see 'GI.GLib.Structs.OptionContext.optionContextSetIgnoreUnknownOptions'.
    | OptionErrorBadValue
    -- ^ A value couldn\'t be parsed.
    | OptionErrorFailed
    -- ^ A t'GI.GLib.Callbacks.OptionArgFunc' callback failed.
    | AnotherOptionError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OptionError where
    fromEnum OptionErrorUnknownOption = 0
    fromEnum OptionErrorBadValue = 1
    fromEnum OptionErrorFailed = 2
    fromEnum (AnotherOptionError k) = k

    toEnum 0 = OptionErrorUnknownOption
    toEnum 1 = OptionErrorBadValue
    toEnum 2 = OptionErrorFailed
    toEnum k = AnotherOptionError k

instance P.Ord OptionError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass OptionError where
    gerrorClassDomain _ = "g-option-context-error-quark"

-- | Catch exceptions of type `OptionError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchOptionError ::
    IO a ->
    (OptionError -> GErrorMessage -> IO a) ->
    IO a
catchOptionError = catchGErrorJustDomain

-- | Handle exceptions of type `OptionError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleOptionError ::
    (OptionError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleOptionError = handleGErrorJustDomain

-- Enum OptionArg
-- | The t'GI.GLib.Enums.OptionArg' enum values determine which type of extra argument the
-- options expect to find. If an option expects an extra argument, it can
-- be specified in several ways; with a short option: @-x arg@, with a long
-- option: @--name arg@ or combined in a single argument: @--name=arg@.
data OptionArg = 
      OptionArgNone
    -- ^ No extra argument. This is useful for simple flags or booleans.
    | OptionArgString
    -- ^ The option takes a UTF-8 string argument.
    | OptionArgInt
    -- ^ The option takes an integer argument.
    | OptionArgCallback
    -- ^ The option provides a callback (of type t'GI.GLib.Callbacks.OptionArgFunc')
    --   to parse the extra argument.
    | OptionArgFilename
    -- ^ The option takes a filename as argument, which will
    --      be in the GLib filename encoding rather than UTF-8.
    | OptionArgStringArray
    -- ^ The option takes a string argument, multiple
    --   uses of the option are collected into an array of strings.
    | OptionArgFilenameArray
    -- ^ The option takes a filename as argument,
    --   multiple uses of the option are collected into an array of strings.
    | OptionArgDouble
    -- ^ The option takes a double argument. The argument
    --   can be formatted either for the user\'s locale or for the \"C\" locale.
    --   Since 2.12
    | OptionArgInt64
    -- ^ The option takes a 64-bit integer. Like
    --   'GI.GLib.Enums.OptionArgInt' but for larger numbers. The number can be in
    --   decimal base, or in hexadecimal (when prefixed with @0x@, for
    --   example, @0xffffffff@). Since 2.12
    | AnotherOptionArg Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OptionArg where
    fromEnum OptionArgNone = 0
    fromEnum OptionArgString = 1
    fromEnum OptionArgInt = 2
    fromEnum OptionArgCallback = 3
    fromEnum OptionArgFilename = 4
    fromEnum OptionArgStringArray = 5
    fromEnum OptionArgFilenameArray = 6
    fromEnum OptionArgDouble = 7
    fromEnum OptionArgInt64 = 8
    fromEnum (AnotherOptionArg k) = k

    toEnum 0 = OptionArgNone
    toEnum 1 = OptionArgString
    toEnum 2 = OptionArgInt
    toEnum 3 = OptionArgCallback
    toEnum 4 = OptionArgFilename
    toEnum 5 = OptionArgStringArray
    toEnum 6 = OptionArgFilenameArray
    toEnum 7 = OptionArgDouble
    toEnum 8 = OptionArgInt64
    toEnum k = AnotherOptionArg k

instance P.Ord OptionArg where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum OnceStatus
-- | The possible statuses of a one-time initialization function
-- controlled by a t'GI.GLib.Structs.Once.Once' struct.
-- 
-- /Since: 2.4/
data OnceStatus = 
      OnceStatusNotcalled
    -- ^ the function has not been called yet.
    | OnceStatusProgress
    -- ^ the function call is currently in progress.
    | OnceStatusReady
    -- ^ the function has been called.
    | AnotherOnceStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OnceStatus where
    fromEnum OnceStatusNotcalled = 0
    fromEnum OnceStatusProgress = 1
    fromEnum OnceStatusReady = 2
    fromEnum (AnotherOnceStatus k) = k

    toEnum 0 = OnceStatusNotcalled
    toEnum 1 = OnceStatusProgress
    toEnum 2 = OnceStatusReady
    toEnum k = AnotherOnceStatus k

instance P.Ord OnceStatus where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum NumberParserError
-- | Error codes returned by functions converting a string to a number.
-- 
-- /Since: 2.54/
data NumberParserError = 
      NumberParserErrorInvalid
    -- ^ string was not a valid number
    | NumberParserErrorOutOfBounds
    -- ^ string was a number, but out of bounds
    | AnotherNumberParserError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NumberParserError where
    fromEnum NumberParserErrorInvalid = 0
    fromEnum NumberParserErrorOutOfBounds = 1
    fromEnum (AnotherNumberParserError k) = k

    toEnum 0 = NumberParserErrorInvalid
    toEnum 1 = NumberParserErrorOutOfBounds
    toEnum k = AnotherNumberParserError k

instance P.Ord NumberParserError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass NumberParserError where
    gerrorClassDomain _ = "g-number-parser-error-quark"

-- | Catch exceptions of type `NumberParserError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchNumberParserError ::
    IO a ->
    (NumberParserError -> GErrorMessage -> IO a) ->
    IO a
catchNumberParserError = catchGErrorJustDomain

-- | Handle exceptions of type `NumberParserError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleNumberParserError ::
    (NumberParserError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleNumberParserError = handleGErrorJustDomain

-- Enum NormalizeMode
-- | Defines how a Unicode string is transformed in a canonical
-- form, standardizing such issues as whether a character with
-- an accent is represented as a base character and combining
-- accent or as a single precomposed character. Unicode strings
-- should generally be normalized before comparing them.
data NormalizeMode = 
      NormalizeModeDefault
    -- ^ standardize differences that do not affect the
    --     text content, such as the above-mentioned accent representation
    | NormalizeModeNfd
    -- ^ another name for 'GI.GLib.Enums.NormalizeModeDefault'
    | NormalizeModeDefaultCompose
    -- ^ like 'GI.GLib.Enums.NormalizeModeDefault', but with
    --     composed forms rather than a maximally decomposed form
    | NormalizeModeNfc
    -- ^ another name for 'GI.GLib.Enums.NormalizeModeDefaultCompose'
    | NormalizeModeAll
    -- ^ beyond 'GI.GLib.Enums.NormalizeModeDefault' also standardize the
    --     \"compatibility\" characters in Unicode, such as SUPERSCRIPT THREE
    --     to the standard forms (in this case DIGIT THREE). Formatting
    --     information may be lost but for most text operations such
    --     characters should be considered the same
    | NormalizeModeNfkd
    -- ^ another name for 'GI.GLib.Enums.NormalizeModeAll'
    | NormalizeModeAllCompose
    -- ^ like 'GI.GLib.Enums.NormalizeModeAll', but with composed
    --     forms rather than a maximally decomposed form
    | NormalizeModeNfkc
    -- ^ another name for 'GI.GLib.Enums.NormalizeModeAllCompose'
    | AnotherNormalizeMode Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum NormalizeMode where
    fromEnum NormalizeModeDefault = 0
    fromEnum NormalizeModeNfd = 0
    fromEnum NormalizeModeDefaultCompose = 1
    fromEnum NormalizeModeNfc = 1
    fromEnum NormalizeModeAll = 2
    fromEnum NormalizeModeNfkd = 2
    fromEnum NormalizeModeAllCompose = 3
    fromEnum NormalizeModeNfkc = 3
    fromEnum (AnotherNormalizeMode k) = k

    toEnum 0 = NormalizeModeDefault
    toEnum 1 = NormalizeModeDefaultCompose
    toEnum 2 = NormalizeModeAll
    toEnum 3 = NormalizeModeAllCompose
    toEnum k = AnotherNormalizeMode k

instance P.Ord NormalizeMode where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes NormalizeMode = '[]
instance O.HasParentTypes NormalizeMode

foreign import ccall "g_normalize_mode_get_type" c_g_normalize_mode_get_type :: 
    IO GType

instance B.Types.TypedObject NormalizeMode where
    glibType = c_g_normalize_mode_get_type

instance B.Types.BoxedEnum NormalizeMode

-- Enum MarkupError
-- | Error codes returned by markup parsing.
data MarkupError = 
      MarkupErrorBadUtf8
    -- ^ text being parsed was not valid UTF-8
    | MarkupErrorEmpty
    -- ^ document contained nothing, or only whitespace
    | MarkupErrorParse
    -- ^ document was ill-formed
    | MarkupErrorUnknownElement
    -- ^ error should be set by t'GI.GLib.Structs.MarkupParser.MarkupParser'
    --     functions; element wasn\'t known
    | MarkupErrorUnknownAttribute
    -- ^ error should be set by t'GI.GLib.Structs.MarkupParser.MarkupParser'
    --     functions; attribute wasn\'t known
    | MarkupErrorInvalidContent
    -- ^ error should be set by t'GI.GLib.Structs.MarkupParser.MarkupParser'
    --     functions; content was invalid
    | MarkupErrorMissingAttribute
    -- ^ error should be set by t'GI.GLib.Structs.MarkupParser.MarkupParser'
    --     functions; a required attribute was missing
    | AnotherMarkupError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MarkupError where
    fromEnum MarkupErrorBadUtf8 = 0
    fromEnum MarkupErrorEmpty = 1
    fromEnum MarkupErrorParse = 2
    fromEnum MarkupErrorUnknownElement = 3
    fromEnum MarkupErrorUnknownAttribute = 4
    fromEnum MarkupErrorInvalidContent = 5
    fromEnum MarkupErrorMissingAttribute = 6
    fromEnum (AnotherMarkupError k) = k

    toEnum 0 = MarkupErrorBadUtf8
    toEnum 1 = MarkupErrorEmpty
    toEnum 2 = MarkupErrorParse
    toEnum 3 = MarkupErrorUnknownElement
    toEnum 4 = MarkupErrorUnknownAttribute
    toEnum 5 = MarkupErrorInvalidContent
    toEnum 6 = MarkupErrorMissingAttribute
    toEnum k = AnotherMarkupError k

instance P.Ord MarkupError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass MarkupError where
    gerrorClassDomain _ = "g-markup-error-quark"

-- | Catch exceptions of type `MarkupError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchMarkupError ::
    IO a ->
    (MarkupError -> GErrorMessage -> IO a) ->
    IO a
catchMarkupError = catchGErrorJustDomain

-- | Handle exceptions of type `MarkupError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleMarkupError ::
    (MarkupError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleMarkupError = handleGErrorJustDomain

-- Enum LogWriterOutput
-- | Return values from @/GLogWriterFuncs/@ to indicate whether the given log entry
-- was successfully handled by the writer, or whether there was an error in
-- handling it (and hence a fallback writer should be used).
-- 
-- If a t'GI.GLib.Callbacks.LogWriterFunc' ignores a log entry, it should return
-- 'GI.GLib.Enums.LogWriterOutputHandled'.
-- 
-- /Since: 2.50/
data LogWriterOutput = 
      LogWriterOutputHandled
    -- ^ Log writer has handled the log entry.
    | LogWriterOutputUnhandled
    -- ^ Log writer could not handle the log entry.
    | AnotherLogWriterOutput Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum LogWriterOutput where
    fromEnum LogWriterOutputHandled = 1
    fromEnum LogWriterOutputUnhandled = 0
    fromEnum (AnotherLogWriterOutput k) = k

    toEnum 1 = LogWriterOutputHandled
    toEnum 0 = LogWriterOutputUnhandled
    toEnum k = AnotherLogWriterOutput k

instance P.Ord LogWriterOutput where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum KeyFileError
-- | Error codes returned by key file parsing.
data KeyFileError = 
      KeyFileErrorUnknownEncoding
    -- ^ the text being parsed was in
    --   an unknown encoding
    | KeyFileErrorParse
    -- ^ document was ill-formed
    | KeyFileErrorNotFound
    -- ^ the file was not found
    | KeyFileErrorKeyNotFound
    -- ^ a requested key was not found
    | KeyFileErrorGroupNotFound
    -- ^ a requested group was not found
    | KeyFileErrorInvalidValue
    -- ^ a value could not be parsed
    | AnotherKeyFileError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum KeyFileError where
    fromEnum KeyFileErrorUnknownEncoding = 0
    fromEnum KeyFileErrorParse = 1
    fromEnum KeyFileErrorNotFound = 2
    fromEnum KeyFileErrorKeyNotFound = 3
    fromEnum KeyFileErrorGroupNotFound = 4
    fromEnum KeyFileErrorInvalidValue = 5
    fromEnum (AnotherKeyFileError k) = k

    toEnum 0 = KeyFileErrorUnknownEncoding
    toEnum 1 = KeyFileErrorParse
    toEnum 2 = KeyFileErrorNotFound
    toEnum 3 = KeyFileErrorKeyNotFound
    toEnum 4 = KeyFileErrorGroupNotFound
    toEnum 5 = KeyFileErrorInvalidValue
    toEnum k = AnotherKeyFileError k

instance P.Ord KeyFileError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass KeyFileError where
    gerrorClassDomain _ = "g-key-file-error-quark"

-- | Catch exceptions of type `KeyFileError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchKeyFileError ::
    IO a ->
    (KeyFileError -> GErrorMessage -> IO a) ->
    IO a
catchKeyFileError = catchGErrorJustDomain

-- | Handle exceptions of type `KeyFileError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleKeyFileError ::
    (KeyFileError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleKeyFileError = handleGErrorJustDomain

-- Enum IOStatus
-- | Statuses returned by most of the t'GI.GLib.Structs.IOFuncs.IOFuncs' functions.
data IOStatus = 
      IOStatusError
    -- ^ An error occurred.
    | IOStatusNormal
    -- ^ Success.
    | IOStatusEof
    -- ^ End of file.
    | IOStatusAgain
    -- ^ Resource temporarily unavailable.
    | AnotherIOStatus Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOStatus where
    fromEnum IOStatusError = 0
    fromEnum IOStatusNormal = 1
    fromEnum IOStatusEof = 2
    fromEnum IOStatusAgain = 3
    fromEnum (AnotherIOStatus k) = k

    toEnum 0 = IOStatusError
    toEnum 1 = IOStatusNormal
    toEnum 2 = IOStatusEof
    toEnum 3 = IOStatusAgain
    toEnum k = AnotherIOStatus k

instance P.Ord IOStatus where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum IOError
-- | t'GI.GLib.Enums.IOError' is only used by the deprecated functions
-- 'GI.GLib.Structs.IOChannel.iOChannelRead', 'GI.GLib.Structs.IOChannel.iOChannelWrite', and 'GI.GLib.Structs.IOChannel.iOChannelSeek'.
data IOError = 
      IOErrorNone
    -- ^ no error
    | IOErrorAgain
    -- ^ an EAGAIN error occurred
    | IOErrorInval
    -- ^ an EINVAL error occurred
    | IOErrorUnknown
    -- ^ another error occurred
    | AnotherIOError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOError where
    fromEnum IOErrorNone = 0
    fromEnum IOErrorAgain = 1
    fromEnum IOErrorInval = 2
    fromEnum IOErrorUnknown = 3
    fromEnum (AnotherIOError k) = k

    toEnum 0 = IOErrorNone
    toEnum 1 = IOErrorAgain
    toEnum 2 = IOErrorInval
    toEnum 3 = IOErrorUnknown
    toEnum k = AnotherIOError k

instance P.Ord IOError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum IOChannelError
-- | Error codes returned by t'GI.GLib.Structs.IOChannel.IOChannel' operations.
data IOChannelError = 
      IOChannelErrorFbig
    -- ^ File too large.
    | IOChannelErrorInval
    -- ^ Invalid argument.
    | IOChannelErrorIo
    -- ^ IO error.
    | IOChannelErrorIsdir
    -- ^ File is a directory.
    | IOChannelErrorNospc
    -- ^ No space left on device.
    | IOChannelErrorNxio
    -- ^ No such device or address.
    | IOChannelErrorOverflow
    -- ^ Value too large for defined datatype.
    | IOChannelErrorPipe
    -- ^ Broken pipe.
    | IOChannelErrorFailed
    -- ^ Some other error.
    | AnotherIOChannelError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOChannelError where
    fromEnum IOChannelErrorFbig = 0
    fromEnum IOChannelErrorInval = 1
    fromEnum IOChannelErrorIo = 2
    fromEnum IOChannelErrorIsdir = 3
    fromEnum IOChannelErrorNospc = 4
    fromEnum IOChannelErrorNxio = 5
    fromEnum IOChannelErrorOverflow = 6
    fromEnum IOChannelErrorPipe = 7
    fromEnum IOChannelErrorFailed = 8
    fromEnum (AnotherIOChannelError k) = k

    toEnum 0 = IOChannelErrorFbig
    toEnum 1 = IOChannelErrorInval
    toEnum 2 = IOChannelErrorIo
    toEnum 3 = IOChannelErrorIsdir
    toEnum 4 = IOChannelErrorNospc
    toEnum 5 = IOChannelErrorNxio
    toEnum 6 = IOChannelErrorOverflow
    toEnum 7 = IOChannelErrorPipe
    toEnum 8 = IOChannelErrorFailed
    toEnum k = AnotherIOChannelError k

instance P.Ord IOChannelError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass IOChannelError where
    gerrorClassDomain _ = "g-io-channel-error-quark"

-- | Catch exceptions of type `IOChannelError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchIOChannelError ::
    IO a ->
    (IOChannelError -> GErrorMessage -> IO a) ->
    IO a
catchIOChannelError = catchGErrorJustDomain

-- | Handle exceptions of type `IOChannelError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleIOChannelError ::
    (IOChannelError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleIOChannelError = handleGErrorJustDomain

-- Enum FileError
-- | Values corresponding to /@errno@/ codes returned from file operations
-- on UNIX. Unlike /@errno@/ codes, GFileError values are available on
-- all systems, even Windows. The exact meaning of each code depends
-- on what sort of file operation you were performing; the UNIX
-- documentation gives more details. The following error code descriptions
-- come from the GNU C Library manual, and are under the copyright
-- of that manual.
-- 
-- It\'s not very portable to make detailed assumptions about exactly
-- which errors will be returned from a given operation. Some errors
-- don\'t occur on some systems, etc., sometimes there are subtle
-- differences in when a system will report a given error, etc.
data FileError = 
      FileErrorExist
    -- ^ Operation not permitted; only the owner of
    --     the file (or other resource) or processes with special privileges
    --     can perform the operation.
    | FileErrorIsdir
    -- ^ File is a directory; you cannot open a directory
    --     for writing, or create or remove hard links to it.
    | FileErrorAcces
    -- ^ Permission denied; the file permissions do not
    --     allow the attempted operation.
    | FileErrorNametoolong
    -- ^ Filename too long.
    | FileErrorNoent
    -- ^ No such file or directory. This is a \"file
    --     doesn\'t exist\" error for ordinary files that are referenced in
    --     contexts where they are expected to already exist.
    | FileErrorNotdir
    -- ^ A file that isn\'t a directory was specified when
    --     a directory is required.
    | FileErrorNxio
    -- ^ No such device or address. The system tried to
    --     use the device represented by a file you specified, and it
    --     couldn\'t find the device. This can mean that the device file was
    --     installed incorrectly, or that the physical device is missing or
    --     not correctly attached to the computer.
    | FileErrorNodev
    -- ^ The underlying file system of the specified file
    --     does not support memory mapping.
    | FileErrorRofs
    -- ^ The directory containing the new link can\'t be
    --     modified because it\'s on a read-only file system.
    | FileErrorTxtbsy
    -- ^ Text file busy.
    | FileErrorFault
    -- ^ You passed in a pointer to bad memory.
    --     (GLib won\'t reliably return this, don\'t pass in pointers to bad
    --     memory.)
    | FileErrorLoop
    -- ^ Too many levels of symbolic links were encountered
    --     in looking up a file name. This often indicates a cycle of symbolic
    --     links.
    | FileErrorNospc
    -- ^ No space left on device; write operation on a
    --     file failed because the disk is full.
    | FileErrorNomem
    -- ^ No memory available. The system cannot allocate
    --     more virtual memory because its capacity is full.
    | FileErrorMfile
    -- ^ The current process has too many files open and
    --     can\'t open any more. Duplicate descriptors do count toward this
    --     limit.
    | FileErrorNfile
    -- ^ There are too many distinct file openings in the
    --     entire system.
    | FileErrorBadf
    -- ^ Bad file descriptor; for example, I\/O on a
    --     descriptor that has been closed or reading from a descriptor open
    --     only for writing (or vice versa).
    | FileErrorInval
    -- ^ Invalid argument. This is used to indicate
    --     various kinds of problems with passing the wrong argument to a
    --     library function.
    | FileErrorPipe
    -- ^ Broken pipe; there is no process reading from the
    --     other end of a pipe. Every library function that returns this
    --     error code also generates a \'SIGPIPE\' signal; this signal
    --     terminates the program if not handled or blocked. Thus, your
    --     program will never actually see this code unless it has handled
    --     or blocked \'SIGPIPE\'.
    | FileErrorAgain
    -- ^ Resource temporarily unavailable; the call might
    --     work if you try again later.
    | FileErrorIntr
    -- ^ Interrupted function call; an asynchronous signal
    --     occurred and prevented completion of the call. When this
    --     happens, you should try the call again.
    | FileErrorIo
    -- ^ Input\/output error; usually used for physical read
    --    or write errors. i.e. the disk or other physical device hardware
    --    is returning errors.
    | FileErrorPerm
    -- ^ Operation not permitted; only the owner of the
    --    file (or other resource) or processes with special privileges can
    --    perform the operation.
    | FileErrorNosys
    -- ^ Function not implemented; this indicates that
    --    the system is missing some functionality.
    | FileErrorFailed
    -- ^ Does not correspond to a UNIX error code; this
    --    is the standard \"failed for unspecified reason\" error code present
    --    in all t'GError' error code enumerations. Returned if no specific
    --    code applies.
    | AnotherFileError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileError where
    fromEnum FileErrorExist = 0
    fromEnum FileErrorIsdir = 1
    fromEnum FileErrorAcces = 2
    fromEnum FileErrorNametoolong = 3
    fromEnum FileErrorNoent = 4
    fromEnum FileErrorNotdir = 5
    fromEnum FileErrorNxio = 6
    fromEnum FileErrorNodev = 7
    fromEnum FileErrorRofs = 8
    fromEnum FileErrorTxtbsy = 9
    fromEnum FileErrorFault = 10
    fromEnum FileErrorLoop = 11
    fromEnum FileErrorNospc = 12
    fromEnum FileErrorNomem = 13
    fromEnum FileErrorMfile = 14
    fromEnum FileErrorNfile = 15
    fromEnum FileErrorBadf = 16
    fromEnum FileErrorInval = 17
    fromEnum FileErrorPipe = 18
    fromEnum FileErrorAgain = 19
    fromEnum FileErrorIntr = 20
    fromEnum FileErrorIo = 21
    fromEnum FileErrorPerm = 22
    fromEnum FileErrorNosys = 23
    fromEnum FileErrorFailed = 24
    fromEnum (AnotherFileError k) = k

    toEnum 0 = FileErrorExist
    toEnum 1 = FileErrorIsdir
    toEnum 2 = FileErrorAcces
    toEnum 3 = FileErrorNametoolong
    toEnum 4 = FileErrorNoent
    toEnum 5 = FileErrorNotdir
    toEnum 6 = FileErrorNxio
    toEnum 7 = FileErrorNodev
    toEnum 8 = FileErrorRofs
    toEnum 9 = FileErrorTxtbsy
    toEnum 10 = FileErrorFault
    toEnum 11 = FileErrorLoop
    toEnum 12 = FileErrorNospc
    toEnum 13 = FileErrorNomem
    toEnum 14 = FileErrorMfile
    toEnum 15 = FileErrorNfile
    toEnum 16 = FileErrorBadf
    toEnum 17 = FileErrorInval
    toEnum 18 = FileErrorPipe
    toEnum 19 = FileErrorAgain
    toEnum 20 = FileErrorIntr
    toEnum 21 = FileErrorIo
    toEnum 22 = FileErrorPerm
    toEnum 23 = FileErrorNosys
    toEnum 24 = FileErrorFailed
    toEnum k = AnotherFileError k

instance P.Ord FileError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass FileError where
    gerrorClassDomain _ = "g-file-error-quark"

-- | Catch exceptions of type `FileError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchFileError ::
    IO a ->
    (FileError -> GErrorMessage -> IO a) ->
    IO a
catchFileError = catchGErrorJustDomain

-- | Handle exceptions of type `FileError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleFileError ::
    (FileError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleFileError = handleGErrorJustDomain

-- Enum ErrorType
-- | The possible errors, used in the /@vError@/ field
-- of t'GI.GLib.Unions.TokenValue.TokenValue', when the token is a 'GI.GLib.Enums.TokenTypeError'.
data ErrorType = 
      ErrorTypeUnknown
    -- ^ unknown error
    | ErrorTypeUnexpEof
    -- ^ unexpected end of file
    | ErrorTypeUnexpEofInString
    -- ^ unterminated string constant
    | ErrorTypeUnexpEofInComment
    -- ^ unterminated comment
    | ErrorTypeNonDigitInConst
    -- ^ non-digit character in a number
    | ErrorTypeDigitRadix
    -- ^ digit beyond radix in a number
    | ErrorTypeFloatRadix
    -- ^ non-decimal floating point number
    | ErrorTypeFloatMalformed
    -- ^ malformed floating point number
    | AnotherErrorType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ErrorType where
    fromEnum ErrorTypeUnknown = 0
    fromEnum ErrorTypeUnexpEof = 1
    fromEnum ErrorTypeUnexpEofInString = 2
    fromEnum ErrorTypeUnexpEofInComment = 3
    fromEnum ErrorTypeNonDigitInConst = 4
    fromEnum ErrorTypeDigitRadix = 5
    fromEnum ErrorTypeFloatRadix = 6
    fromEnum ErrorTypeFloatMalformed = 7
    fromEnum (AnotherErrorType k) = k

    toEnum 0 = ErrorTypeUnknown
    toEnum 1 = ErrorTypeUnexpEof
    toEnum 2 = ErrorTypeUnexpEofInString
    toEnum 3 = ErrorTypeUnexpEofInComment
    toEnum 4 = ErrorTypeNonDigitInConst
    toEnum 5 = ErrorTypeDigitRadix
    toEnum 6 = ErrorTypeFloatRadix
    toEnum 7 = ErrorTypeFloatMalformed
    toEnum k = AnotherErrorType k

instance P.Ord ErrorType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum DateWeekday
-- | Enumeration representing a day of the week; 'GI.GLib.Enums.DateWeekdayMonday',
-- 'GI.GLib.Enums.DateWeekdayTuesday', etc. 'GI.GLib.Enums.DateWeekdayBadWeekday' is an invalid weekday.
data DateWeekday = 
      DateWeekdayBadWeekday
    -- ^ invalid value
    | DateWeekdayMonday
    -- ^ Monday
    | DateWeekdayTuesday
    -- ^ Tuesday
    | DateWeekdayWednesday
    -- ^ Wednesday
    | DateWeekdayThursday
    -- ^ Thursday
    | DateWeekdayFriday
    -- ^ Friday
    | DateWeekdaySaturday
    -- ^ Saturday
    | DateWeekdaySunday
    -- ^ Sunday
    | AnotherDateWeekday Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DateWeekday where
    fromEnum DateWeekdayBadWeekday = 0
    fromEnum DateWeekdayMonday = 1
    fromEnum DateWeekdayTuesday = 2
    fromEnum DateWeekdayWednesday = 3
    fromEnum DateWeekdayThursday = 4
    fromEnum DateWeekdayFriday = 5
    fromEnum DateWeekdaySaturday = 6
    fromEnum DateWeekdaySunday = 7
    fromEnum (AnotherDateWeekday k) = k

    toEnum 0 = DateWeekdayBadWeekday
    toEnum 1 = DateWeekdayMonday
    toEnum 2 = DateWeekdayTuesday
    toEnum 3 = DateWeekdayWednesday
    toEnum 4 = DateWeekdayThursday
    toEnum 5 = DateWeekdayFriday
    toEnum 6 = DateWeekdaySaturday
    toEnum 7 = DateWeekdaySunday
    toEnum k = AnotherDateWeekday k

instance P.Ord DateWeekday where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum DateMonth
-- | Enumeration representing a month; values are 'GI.GLib.Enums.DateMonthJanuary',
-- 'GI.GLib.Enums.DateMonthFebruary', etc. 'GI.GLib.Enums.DateMonthBadMonth' is the invalid value.
data DateMonth = 
      DateMonthBadMonth
    -- ^ invalid value
    | DateMonthJanuary
    -- ^ January
    | DateMonthFebruary
    -- ^ February
    | DateMonthMarch
    -- ^ March
    | DateMonthApril
    -- ^ April
    | DateMonthMay
    -- ^ May
    | DateMonthJune
    -- ^ June
    | DateMonthJuly
    -- ^ July
    | DateMonthAugust
    -- ^ August
    | DateMonthSeptember
    -- ^ September
    | DateMonthOctober
    -- ^ October
    | DateMonthNovember
    -- ^ November
    | DateMonthDecember
    -- ^ December
    | AnotherDateMonth Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DateMonth where
    fromEnum DateMonthBadMonth = 0
    fromEnum DateMonthJanuary = 1
    fromEnum DateMonthFebruary = 2
    fromEnum DateMonthMarch = 3
    fromEnum DateMonthApril = 4
    fromEnum DateMonthMay = 5
    fromEnum DateMonthJune = 6
    fromEnum DateMonthJuly = 7
    fromEnum DateMonthAugust = 8
    fromEnum DateMonthSeptember = 9
    fromEnum DateMonthOctober = 10
    fromEnum DateMonthNovember = 11
    fromEnum DateMonthDecember = 12
    fromEnum (AnotherDateMonth k) = k

    toEnum 0 = DateMonthBadMonth
    toEnum 1 = DateMonthJanuary
    toEnum 2 = DateMonthFebruary
    toEnum 3 = DateMonthMarch
    toEnum 4 = DateMonthApril
    toEnum 5 = DateMonthMay
    toEnum 6 = DateMonthJune
    toEnum 7 = DateMonthJuly
    toEnum 8 = DateMonthAugust
    toEnum 9 = DateMonthSeptember
    toEnum 10 = DateMonthOctober
    toEnum 11 = DateMonthNovember
    toEnum 12 = DateMonthDecember
    toEnum k = AnotherDateMonth k

instance P.Ord DateMonth where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum DateDMY
-- | This enumeration isn\'t used in the API, but may be useful if you need
-- to mark a number as a day, month, or year.
data DateDMY = 
      DateDMYDay
    -- ^ a day
    | DateDMYMonth
    -- ^ a month
    | DateDMYYear
    -- ^ a year
    | AnotherDateDMY Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DateDMY where
    fromEnum DateDMYDay = 0
    fromEnum DateDMYMonth = 1
    fromEnum DateDMYYear = 2
    fromEnum (AnotherDateDMY k) = k

    toEnum 0 = DateDMYDay
    toEnum 1 = DateDMYMonth
    toEnum 2 = DateDMYYear
    toEnum k = AnotherDateDMY k

instance P.Ord DateDMY where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum ConvertError
-- | Error codes returned by character set conversion routines.
data ConvertError = 
      ConvertErrorNoConversion
    -- ^ Conversion between the requested character
    --     sets is not supported.
    | ConvertErrorIllegalSequence
    -- ^ Invalid byte sequence in conversion input;
    --    or the character sequence could not be represented in the target
    --    character set.
    | ConvertErrorFailed
    -- ^ Conversion failed for some reason.
    | ConvertErrorPartialInput
    -- ^ Partial character sequence at end of input.
    | ConvertErrorBadUri
    -- ^ URI is invalid.
    | ConvertErrorNotAbsolutePath
    -- ^ Pathname is not an absolute path.
    | ConvertErrorNoMemory
    -- ^ No memory available. Since: 2.40
    | ConvertErrorEmbeddedNul
    -- ^ An embedded NUL character is present in
    --     conversion output where a NUL-terminated string is expected.
    --     Since: 2.56
    | AnotherConvertError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConvertError where
    fromEnum ConvertErrorNoConversion = 0
    fromEnum ConvertErrorIllegalSequence = 1
    fromEnum ConvertErrorFailed = 2
    fromEnum ConvertErrorPartialInput = 3
    fromEnum ConvertErrorBadUri = 4
    fromEnum ConvertErrorNotAbsolutePath = 5
    fromEnum ConvertErrorNoMemory = 6
    fromEnum ConvertErrorEmbeddedNul = 7
    fromEnum (AnotherConvertError k) = k

    toEnum 0 = ConvertErrorNoConversion
    toEnum 1 = ConvertErrorIllegalSequence
    toEnum 2 = ConvertErrorFailed
    toEnum 3 = ConvertErrorPartialInput
    toEnum 4 = ConvertErrorBadUri
    toEnum 5 = ConvertErrorNotAbsolutePath
    toEnum 6 = ConvertErrorNoMemory
    toEnum 7 = ConvertErrorEmbeddedNul
    toEnum k = AnotherConvertError k

instance P.Ord ConvertError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass ConvertError where
    gerrorClassDomain _ = "g_convert_error"

-- | Catch exceptions of type `ConvertError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchConvertError ::
    IO a ->
    (ConvertError -> GErrorMessage -> IO a) ->
    IO a
catchConvertError = catchGErrorJustDomain

-- | Handle exceptions of type `ConvertError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleConvertError ::
    (ConvertError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleConvertError = handleGErrorJustDomain

-- Enum ChecksumType
-- | The hashing algorithm to be used by t'GI.GLib.Structs.Checksum.Checksum' when performing the
-- digest of some data.
-- 
-- Note that the t'GI.GLib.Enums.ChecksumType' enumeration may be extended at a later
-- date to include new hashing algorithm types.
-- 
-- /Since: 2.16/
data ChecksumType = 
      ChecksumTypeMd5
    -- ^ Use the MD5 hashing algorithm
    | ChecksumTypeSha1
    -- ^ Use the SHA-1 hashing algorithm
    | ChecksumTypeSha256
    -- ^ Use the SHA-256 hashing algorithm
    | ChecksumTypeSha512
    -- ^ Use the SHA-512 hashing algorithm (Since: 2.36)
    | ChecksumTypeSha384
    -- ^ Use the SHA-384 hashing algorithm (Since: 2.51)
    | AnotherChecksumType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ChecksumType where
    fromEnum ChecksumTypeMd5 = 0
    fromEnum ChecksumTypeSha1 = 1
    fromEnum ChecksumTypeSha256 = 2
    fromEnum ChecksumTypeSha512 = 3
    fromEnum ChecksumTypeSha384 = 4
    fromEnum (AnotherChecksumType k) = k

    toEnum 0 = ChecksumTypeMd5
    toEnum 1 = ChecksumTypeSha1
    toEnum 2 = ChecksumTypeSha256
    toEnum 3 = ChecksumTypeSha512
    toEnum 4 = ChecksumTypeSha384
    toEnum k = AnotherChecksumType k

instance P.Ord ChecksumType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

-- Enum BookmarkFileError
-- | Error codes returned by bookmark file parsing.
data BookmarkFileError = 
      BookmarkFileErrorInvalidUri
    -- ^ URI was ill-formed
    | BookmarkFileErrorInvalidValue
    -- ^ a requested field was not found
    | BookmarkFileErrorAppNotRegistered
    -- ^ a requested application did
    --     not register a bookmark
    | BookmarkFileErrorUriNotFound
    -- ^ a requested URI was not found
    | BookmarkFileErrorRead
    -- ^ document was ill formed
    | BookmarkFileErrorUnknownEncoding
    -- ^ the text being parsed was
    --     in an unknown encoding
    | BookmarkFileErrorWrite
    -- ^ an error occurred while writing
    | BookmarkFileErrorFileNotFound
    -- ^ requested file was not found
    | AnotherBookmarkFileError Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BookmarkFileError where
    fromEnum BookmarkFileErrorInvalidUri = 0
    fromEnum BookmarkFileErrorInvalidValue = 1
    fromEnum BookmarkFileErrorAppNotRegistered = 2
    fromEnum BookmarkFileErrorUriNotFound = 3
    fromEnum BookmarkFileErrorRead = 4
    fromEnum BookmarkFileErrorUnknownEncoding = 5
    fromEnum BookmarkFileErrorWrite = 6
    fromEnum BookmarkFileErrorFileNotFound = 7
    fromEnum (AnotherBookmarkFileError k) = k

    toEnum 0 = BookmarkFileErrorInvalidUri
    toEnum 1 = BookmarkFileErrorInvalidValue
    toEnum 2 = BookmarkFileErrorAppNotRegistered
    toEnum 3 = BookmarkFileErrorUriNotFound
    toEnum 4 = BookmarkFileErrorRead
    toEnum 5 = BookmarkFileErrorUnknownEncoding
    toEnum 6 = BookmarkFileErrorWrite
    toEnum 7 = BookmarkFileErrorFileNotFound
    toEnum k = AnotherBookmarkFileError k

instance P.Ord BookmarkFileError where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance GErrorClass BookmarkFileError where
    gerrorClassDomain _ = "g-bookmark-file-error-quark"

-- | Catch exceptions of type `BookmarkFileError`. This is a specialized version of `Data.GI.Base.GError.catchGErrorJustDomain`.
catchBookmarkFileError ::
    IO a ->
    (BookmarkFileError -> GErrorMessage -> IO a) ->
    IO a
catchBookmarkFileError = catchGErrorJustDomain

-- | Handle exceptions of type `BookmarkFileError`. This is a specialized version of `Data.GI.Base.GError.handleGErrorJustDomain`.
handleBookmarkFileError ::
    (BookmarkFileError -> GErrorMessage -> IO a) ->
    IO a ->
    IO a
handleBookmarkFileError = handleGErrorJustDomain


