{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GStaticResource@ is an opaque data structure and can only be accessed
-- using the following functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.StaticResource
    ( 

-- * Exported types
    StaticResource(..)                      ,
    newZeroStaticResource                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [fini]("GI.Gio.Structs.StaticResource#g:method:fini"), [init]("GI.Gio.Structs.StaticResource#g:method:init").
-- 
-- ==== Getters
-- [getResource]("GI.Gio.Structs.StaticResource#g:method:getResource").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveStaticResourceMethod             ,
#endif

-- ** fini #method:fini#

#if defined(ENABLE_OVERLOADING)
    StaticResourceFiniMethodInfo            ,
#endif
    staticResourceFini                      ,


-- ** getResource #method:getResource#

#if defined(ENABLE_OVERLOADING)
    StaticResourceGetResourceMethodInfo     ,
#endif
    staticResourceGetResource               ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    StaticResourceInitMethodInfo            ,
#endif
    staticResourceInit                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.Resource as Gio.Resource

#else
import {-# SOURCE #-} qualified GI.Gio.Structs.Resource as Gio.Resource

#endif

-- | Memory-managed wrapper type.
newtype StaticResource = StaticResource (SP.ManagedPtr StaticResource)
    deriving (Eq)

instance SP.ManagedPtrNewtype StaticResource where
    toManagedPtr (StaticResource p) = p

instance BoxedPtr StaticResource where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr StaticResource)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr StaticResource where
    boxedPtrCalloc = callocBytes 40


-- | Construct a `StaticResource` struct initialized to zero.
newZeroStaticResource :: MonadIO m => m StaticResource
newZeroStaticResource = liftIO $ boxedPtrCalloc >>= wrapPtr StaticResource

instance tag ~ 'AttrSet => Constructible StaticResource tag where
    new _ attrs = do
        o <- newZeroStaticResource
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StaticResource
type instance O.AttributeList StaticResource = StaticResourceAttributeList
type StaticResourceAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method StaticResource::fini
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "static_resource"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "StaticResource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to a static [struct@Gio.StaticResource]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_static_resource_fini" g_static_resource_fini :: 
    Ptr StaticResource ->                   -- static_resource : TInterface (Name {namespace = "Gio", name = "StaticResource"})
    IO ()

-- | Finalizes a [struct/@gio@/.Resource] initialized by
-- 'GI.Gio.Structs.StaticResource.staticResourceInit'.
-- 
-- This is normally used by code generated by
-- <http://developer.gnome.org/gio/stable/glib-compile-resources.html `glib-compile-resources`>
-- and is not typically used by other code.
-- 
-- /Since: 2.32/
staticResourceFini ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StaticResource
    -- ^ /@staticResource@/: pointer to a static [struct/@gio@/.StaticResource]
    -> m ()
staticResourceFini staticResource = liftIO $ do
    staticResource' <- unsafeManagedPtrGetPtr staticResource
    g_static_resource_fini staticResource'
    touchManagedPtr staticResource
    return ()

#if defined(ENABLE_OVERLOADING)
data StaticResourceFiniMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod StaticResourceFiniMethodInfo StaticResource signature where
    overloadedMethod = staticResourceFini

instance O.OverloadedMethodInfo StaticResourceFiniMethodInfo StaticResource where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.StaticResource.staticResourceFini",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-StaticResource.html#v:staticResourceFini"
        })


#endif

-- method StaticResource::get_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "static_resource"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "StaticResource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to a static [struct@Gio.StaticResource]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Resource" })
-- throws : False
-- Skip return : False

foreign import ccall "g_static_resource_get_resource" g_static_resource_get_resource :: 
    Ptr StaticResource ->                   -- static_resource : TInterface (Name {namespace = "Gio", name = "StaticResource"})
    IO (Ptr Gio.Resource.Resource)

-- | Gets the [struct/@gio@/.Resource] that was registered by a call to
-- 'GI.Gio.Structs.StaticResource.staticResourceInit'.
-- 
-- This is normally used by code generated by
-- <http://developer.gnome.org/gio/stable/glib-compile-resources.html `glib-compile-resources`>
-- and is not typically used by other code.
-- 
-- /Since: 2.32/
staticResourceGetResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StaticResource
    -- ^ /@staticResource@/: pointer to a static [struct/@gio@/.StaticResource]
    -> m Gio.Resource.Resource
    -- ^ __Returns:__ a [struct/@gio@/.Resource]
staticResourceGetResource staticResource = liftIO $ do
    staticResource' <- unsafeManagedPtrGetPtr staticResource
    result <- g_static_resource_get_resource staticResource'
    checkUnexpectedReturnNULL "staticResourceGetResource" result
    result' <- (newBoxed Gio.Resource.Resource) result
    touchManagedPtr staticResource
    return result'

#if defined(ENABLE_OVERLOADING)
data StaticResourceGetResourceMethodInfo
instance (signature ~ (m Gio.Resource.Resource), MonadIO m) => O.OverloadedMethod StaticResourceGetResourceMethodInfo StaticResource signature where
    overloadedMethod = staticResourceGetResource

instance O.OverloadedMethodInfo StaticResourceGetResourceMethodInfo StaticResource where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.StaticResource.staticResourceGetResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-StaticResource.html#v:staticResourceGetResource"
        })


#endif

-- method StaticResource::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "static_resource"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "StaticResource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to a static [struct@Gio.StaticResource]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_static_resource_init" g_static_resource_init :: 
    Ptr StaticResource ->                   -- static_resource : TInterface (Name {namespace = "Gio", name = "StaticResource"})
    IO ()

-- | Initializes a [struct/@gio@/.Resource] from static data using a
-- [struct/@gio@/.StaticResource].
-- 
-- This is normally used by code generated by
-- <http://developer.gnome.org/gio/stable/glib-compile-resources.html `glib-compile-resources`>
-- and is not typically used by other code.
-- 
-- /Since: 2.32/
staticResourceInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    StaticResource
    -- ^ /@staticResource@/: pointer to a static [struct/@gio@/.StaticResource]
    -> m ()
staticResourceInit staticResource = liftIO $ do
    staticResource' <- unsafeManagedPtrGetPtr staticResource
    g_static_resource_init staticResource'
    touchManagedPtr staticResource
    return ()

#if defined(ENABLE_OVERLOADING)
data StaticResourceInitMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod StaticResourceInitMethodInfo StaticResource signature where
    overloadedMethod = staticResourceInit

instance O.OverloadedMethodInfo StaticResourceInitMethodInfo StaticResource where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.StaticResource.staticResourceInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-StaticResource.html#v:staticResourceInit"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveStaticResourceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStaticResourceMethod "fini" o = StaticResourceFiniMethodInfo
    ResolveStaticResourceMethod "init" o = StaticResourceInitMethodInfo
    ResolveStaticResourceMethod "getResource" o = StaticResourceGetResourceMethodInfo
    ResolveStaticResourceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStaticResourceMethod t StaticResource, O.OverloadedMethod info StaticResource p) => OL.IsLabel t (StaticResource -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStaticResourceMethod t StaticResource, O.OverloadedMethod info StaticResource p, R.HasField t StaticResource p) => R.HasField t StaticResource p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStaticResourceMethod t StaticResource, O.OverloadedMethodInfo info StaticResource) => OL.IsLabel t (O.MethodProxy info StaticResource) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


