{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides an interface for implementing seekable functionality on I\/O Streams.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.SeekableIface
    ( 

-- * Exported types
    SeekableIface(..)                       ,
    newZeroSeekableIface                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSeekableIfaceMethod              ,
#endif



 -- * Properties


-- ** canSeek #attr:canSeek#
-- | Checks if seeking is supported by the stream.

    clearSeekableIfaceCanSeek               ,
    getSeekableIfaceCanSeek                 ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_canSeek                   ,
#endif
    setSeekableIfaceCanSeek                 ,


-- ** canTruncate #attr:canTruncate#
-- | Checks if truncation is supported by the stream.

    clearSeekableIfaceCanTruncate           ,
    getSeekableIfaceCanTruncate             ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_canTruncate               ,
#endif
    setSeekableIfaceCanTruncate             ,


-- ** gIface #attr:gIface#
-- | The parent interface.

    getSeekableIfaceGIface                  ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_gIface                    ,
#endif


-- ** seek #attr:seek#
-- | Seeks to a location within a stream.

    clearSeekableIfaceSeek                  ,
    getSeekableIfaceSeek                    ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_seek                      ,
#endif
    setSeekableIfaceSeek                    ,


-- ** tell #attr:tell#
-- | Tells the current location within a stream.

    clearSeekableIfaceTell                  ,
    getSeekableIfaceTell                    ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_tell                      ,
#endif
    setSeekableIfaceTell                    ,


-- ** truncateFn #attr:truncateFn#
-- | Truncates a stream.

    clearSeekableIfaceTruncateFn            ,
    getSeekableIfaceTruncateFn              ,
#if defined(ENABLE_OVERLOADING)
    seekableIface_truncateFn                ,
#endif
    setSeekableIfaceTruncateFn              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import qualified GI.Gio.Callbacks as Gio.Callbacks

#else
import qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import qualified GI.Gio.Callbacks as Gio.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype SeekableIface = SeekableIface (SP.ManagedPtr SeekableIface)
    deriving (Eq)

instance SP.ManagedPtrNewtype SeekableIface where
    toManagedPtr (SeekableIface p) = p

instance BoxedPtr SeekableIface where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr SeekableIface)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr SeekableIface where
    boxedPtrCalloc = callocBytes 56


-- | Construct a `SeekableIface` struct initialized to zero.
newZeroSeekableIface :: MonadIO m => m SeekableIface
newZeroSeekableIface = liftIO $ boxedPtrCalloc >>= wrapPtr SeekableIface

instance tag ~ 'AttrSet => Constructible SeekableIface tag where
    new _ attrs = do
        o <- newZeroSeekableIface
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@g_iface@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #gIface
-- @
getSeekableIfaceGIface :: MonadIO m => SeekableIface -> m GObject.TypeInterface.TypeInterface
getSeekableIfaceGIface s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.TypeInterface.TypeInterface)
    val' <- (newPtr GObject.TypeInterface.TypeInterface) val
    return val'

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceGIfaceFieldInfo
instance AttrInfo SeekableIfaceGIfaceFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceGIfaceFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceGIfaceFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint SeekableIfaceGIfaceFieldInfo = (~) (Ptr GObject.TypeInterface.TypeInterface)
    type AttrTransferTypeConstraint SeekableIfaceGIfaceFieldInfo = (~)(Ptr GObject.TypeInterface.TypeInterface)
    type AttrTransferType SeekableIfaceGIfaceFieldInfo = (Ptr GObject.TypeInterface.TypeInterface)
    type AttrGetType SeekableIfaceGIfaceFieldInfo = GObject.TypeInterface.TypeInterface
    type AttrLabel SeekableIfaceGIfaceFieldInfo = "g_iface"
    type AttrOrigin SeekableIfaceGIfaceFieldInfo = SeekableIface
    attrGet = getSeekableIfaceGIface
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.gIface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:gIface"
        })

seekableIface_gIface :: AttrLabelProxy "gIface"
seekableIface_gIface = AttrLabelProxy

#endif


-- | Get the value of the “@tell@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #tell
-- @
getSeekableIfaceTell :: MonadIO m => SeekableIface -> m (Maybe Gio.Callbacks.SeekableIfaceTellFieldCallback)
getSeekableIfaceTell s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_SeekableIfaceTellFieldCallback val'
        return val''
    return result

-- | Set the value of the “@tell@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' seekableIface [ #tell 'Data.GI.Base.Attributes.:=' value ]
-- @
setSeekableIfaceTell :: MonadIO m => SeekableIface -> FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback -> m ()
setSeekableIfaceTell s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback)

-- | Set the value of the “@tell@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #tell
-- @
clearSeekableIfaceTell :: MonadIO m => SeekableIface -> m ()
clearSeekableIfaceTell s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceTellFieldInfo
instance AttrInfo SeekableIfaceTellFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceTellFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceTellFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SeekableIfaceTellFieldInfo = (~) (FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback)
    type AttrTransferTypeConstraint SeekableIfaceTellFieldInfo = (~)Gio.Callbacks.SeekableIfaceTellFieldCallback
    type AttrTransferType SeekableIfaceTellFieldInfo = (FunPtr Gio.Callbacks.C_SeekableIfaceTellFieldCallback)
    type AttrGetType SeekableIfaceTellFieldInfo = Maybe Gio.Callbacks.SeekableIfaceTellFieldCallback
    type AttrLabel SeekableIfaceTellFieldInfo = "tell"
    type AttrOrigin SeekableIfaceTellFieldInfo = SeekableIface
    attrGet = getSeekableIfaceTell
    attrSet = setSeekableIfaceTell
    attrConstruct = undefined
    attrClear = clearSeekableIfaceTell
    attrTransfer _ v = do
        Gio.Callbacks.mk_SeekableIfaceTellFieldCallback (Gio.Callbacks.wrap_SeekableIfaceTellFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.tell"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:tell"
        })

seekableIface_tell :: AttrLabelProxy "tell"
seekableIface_tell = AttrLabelProxy

#endif


-- | Get the value of the “@can_seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #canSeek
-- @
getSeekableIfaceCanSeek :: MonadIO m => SeekableIface -> m (Maybe Gio.Callbacks.SeekableIfaceCanSeekFieldCallback)
getSeekableIfaceCanSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_SeekableIfaceCanSeekFieldCallback val'
        return val''
    return result

-- | Set the value of the “@can_seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' seekableIface [ #canSeek 'Data.GI.Base.Attributes.:=' value ]
-- @
setSeekableIfaceCanSeek :: MonadIO m => SeekableIface -> FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback -> m ()
setSeekableIfaceCanSeek s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback)

-- | Set the value of the “@can_seek@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #canSeek
-- @
clearSeekableIfaceCanSeek :: MonadIO m => SeekableIface -> m ()
clearSeekableIfaceCanSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceCanSeekFieldInfo
instance AttrInfo SeekableIfaceCanSeekFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceCanSeekFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceCanSeekFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SeekableIfaceCanSeekFieldInfo = (~) (FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback)
    type AttrTransferTypeConstraint SeekableIfaceCanSeekFieldInfo = (~)Gio.Callbacks.SeekableIfaceCanSeekFieldCallback
    type AttrTransferType SeekableIfaceCanSeekFieldInfo = (FunPtr Gio.Callbacks.C_SeekableIfaceCanSeekFieldCallback)
    type AttrGetType SeekableIfaceCanSeekFieldInfo = Maybe Gio.Callbacks.SeekableIfaceCanSeekFieldCallback
    type AttrLabel SeekableIfaceCanSeekFieldInfo = "can_seek"
    type AttrOrigin SeekableIfaceCanSeekFieldInfo = SeekableIface
    attrGet = getSeekableIfaceCanSeek
    attrSet = setSeekableIfaceCanSeek
    attrConstruct = undefined
    attrClear = clearSeekableIfaceCanSeek
    attrTransfer _ v = do
        Gio.Callbacks.mk_SeekableIfaceCanSeekFieldCallback (Gio.Callbacks.wrap_SeekableIfaceCanSeekFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.canSeek"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:canSeek"
        })

seekableIface_canSeek :: AttrLabelProxy "canSeek"
seekableIface_canSeek = AttrLabelProxy

#endif


-- | Get the value of the “@seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #seek
-- @
getSeekableIfaceSeek :: MonadIO m => SeekableIface -> m (Maybe Gio.Callbacks.SeekableIfaceSeekFieldCallback)
getSeekableIfaceSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_SeekableIfaceSeekFieldCallback val'
        return val''
    return result

-- | Set the value of the “@seek@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' seekableIface [ #seek 'Data.GI.Base.Attributes.:=' value ]
-- @
setSeekableIfaceSeek :: MonadIO m => SeekableIface -> FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback -> m ()
setSeekableIfaceSeek s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)

-- | Set the value of the “@seek@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #seek
-- @
clearSeekableIfaceSeek :: MonadIO m => SeekableIface -> m ()
clearSeekableIfaceSeek s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceSeekFieldInfo
instance AttrInfo SeekableIfaceSeekFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceSeekFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceSeekFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SeekableIfaceSeekFieldInfo = (~) (FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)
    type AttrTransferTypeConstraint SeekableIfaceSeekFieldInfo = (~)(FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)
    type AttrTransferType SeekableIfaceSeekFieldInfo = (FunPtr Gio.Callbacks.C_SeekableIfaceSeekFieldCallback)
    type AttrGetType SeekableIfaceSeekFieldInfo = Maybe Gio.Callbacks.SeekableIfaceSeekFieldCallback
    type AttrLabel SeekableIfaceSeekFieldInfo = "seek"
    type AttrOrigin SeekableIfaceSeekFieldInfo = SeekableIface
    attrGet = getSeekableIfaceSeek
    attrSet = setSeekableIfaceSeek
    attrConstruct = undefined
    attrClear = clearSeekableIfaceSeek
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.seek"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:seek"
        })

seekableIface_seek :: AttrLabelProxy "seek"
seekableIface_seek = AttrLabelProxy

#endif


-- | Get the value of the “@can_truncate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #canTruncate
-- @
getSeekableIfaceCanTruncate :: MonadIO m => SeekableIface -> m (Maybe Gio.Callbacks.SeekableIfaceCanTruncateFieldCallback)
getSeekableIfaceCanTruncate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_SeekableIfaceCanTruncateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@can_truncate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' seekableIface [ #canTruncate 'Data.GI.Base.Attributes.:=' value ]
-- @
setSeekableIfaceCanTruncate :: MonadIO m => SeekableIface -> FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback -> m ()
setSeekableIfaceCanTruncate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback)

-- | Set the value of the “@can_truncate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #canTruncate
-- @
clearSeekableIfaceCanTruncate :: MonadIO m => SeekableIface -> m ()
clearSeekableIfaceCanTruncate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceCanTruncateFieldInfo
instance AttrInfo SeekableIfaceCanTruncateFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceCanTruncateFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceCanTruncateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SeekableIfaceCanTruncateFieldInfo = (~) (FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback)
    type AttrTransferTypeConstraint SeekableIfaceCanTruncateFieldInfo = (~)Gio.Callbacks.SeekableIfaceCanTruncateFieldCallback
    type AttrTransferType SeekableIfaceCanTruncateFieldInfo = (FunPtr Gio.Callbacks.C_SeekableIfaceCanTruncateFieldCallback)
    type AttrGetType SeekableIfaceCanTruncateFieldInfo = Maybe Gio.Callbacks.SeekableIfaceCanTruncateFieldCallback
    type AttrLabel SeekableIfaceCanTruncateFieldInfo = "can_truncate"
    type AttrOrigin SeekableIfaceCanTruncateFieldInfo = SeekableIface
    attrGet = getSeekableIfaceCanTruncate
    attrSet = setSeekableIfaceCanTruncate
    attrConstruct = undefined
    attrClear = clearSeekableIfaceCanTruncate
    attrTransfer _ v = do
        Gio.Callbacks.mk_SeekableIfaceCanTruncateFieldCallback (Gio.Callbacks.wrap_SeekableIfaceCanTruncateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.canTruncate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:canTruncate"
        })

seekableIface_canTruncate :: AttrLabelProxy "canTruncate"
seekableIface_canTruncate = AttrLabelProxy

#endif


-- | Get the value of the “@truncate_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' seekableIface #truncateFn
-- @
getSeekableIfaceTruncateFn :: MonadIO m => SeekableIface -> m (Maybe Gio.Callbacks.SeekableIfaceTruncateFnFieldCallback)
getSeekableIfaceTruncateFn s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_SeekableIfaceTruncateFnFieldCallback val'
        return val''
    return result

-- | Set the value of the “@truncate_fn@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' seekableIface [ #truncateFn 'Data.GI.Base.Attributes.:=' value ]
-- @
setSeekableIfaceTruncateFn :: MonadIO m => SeekableIface -> FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback -> m ()
setSeekableIfaceTruncateFn s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)

-- | Set the value of the “@truncate_fn@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #truncateFn
-- @
clearSeekableIfaceTruncateFn :: MonadIO m => SeekableIface -> m ()
clearSeekableIfaceTruncateFn s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)

#if defined(ENABLE_OVERLOADING)
data SeekableIfaceTruncateFnFieldInfo
instance AttrInfo SeekableIfaceTruncateFnFieldInfo where
    type AttrBaseTypeConstraint SeekableIfaceTruncateFnFieldInfo = (~) SeekableIface
    type AttrAllowedOps SeekableIfaceTruncateFnFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SeekableIfaceTruncateFnFieldInfo = (~) (FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)
    type AttrTransferTypeConstraint SeekableIfaceTruncateFnFieldInfo = (~)(FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)
    type AttrTransferType SeekableIfaceTruncateFnFieldInfo = (FunPtr Gio.Callbacks.C_SeekableIfaceTruncateFnFieldCallback)
    type AttrGetType SeekableIfaceTruncateFnFieldInfo = Maybe Gio.Callbacks.SeekableIfaceTruncateFnFieldCallback
    type AttrLabel SeekableIfaceTruncateFnFieldInfo = "truncate_fn"
    type AttrOrigin SeekableIfaceTruncateFnFieldInfo = SeekableIface
    attrGet = getSeekableIfaceTruncateFn
    attrSet = setSeekableIfaceTruncateFn
    attrConstruct = undefined
    attrClear = clearSeekableIfaceTruncateFn
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.SeekableIface.truncateFn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-SeekableIface.html#g:attr:truncateFn"
        })

seekableIface_truncateFn :: AttrLabelProxy "truncateFn"
seekableIface_truncateFn = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SeekableIface
type instance O.AttributeList SeekableIface = SeekableIfaceAttributeList
type SeekableIfaceAttributeList = ('[ '("gIface", SeekableIfaceGIfaceFieldInfo), '("tell", SeekableIfaceTellFieldInfo), '("canSeek", SeekableIfaceCanSeekFieldInfo), '("seek", SeekableIfaceSeekFieldInfo), '("canTruncate", SeekableIfaceCanTruncateFieldInfo), '("truncateFn", SeekableIfaceTruncateFnFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSeekableIfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSeekableIfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSeekableIfaceMethod t SeekableIface, O.OverloadedMethod info SeekableIface p) => OL.IsLabel t (SeekableIface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSeekableIfaceMethod t SeekableIface, O.OverloadedMethod info SeekableIface p, R.HasField t SeekableIface p) => R.HasField t SeekableIface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSeekableIfaceMethod t SeekableIface, O.OverloadedMethodInfo info SeekableIface) => OL.IsLabel t (O.MethodProxy info SeekableIface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


