{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Structure used for scatter\/gather data output when sending multiple
-- messages or packets in one go. You generally pass in an array of
-- @/GOutputVectors/@ and the operation will use all the buffers as if they
-- were one buffer.
-- 
-- If /@address@/ is 'P.Nothing' then the message is sent to the default receiver
-- (as previously set by 'GI.Gio.Objects.Socket.socketConnect').
-- 
-- /Since: 2.44/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.OutputMessage
    ( 

-- * Exported types
    OutputMessage(..)                       ,
    newZeroOutputMessage                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOutputMessageMethod              ,
#endif



 -- * Properties


-- ** address #attr:address#
-- | a t'GI.Gio.Objects.SocketAddress.SocketAddress', or 'P.Nothing'

    clearOutputMessageAddress               ,
    getOutputMessageAddress                 ,
#if defined(ENABLE_OVERLOADING)
    outputMessage_address                   ,
#endif
    setOutputMessageAddress                 ,


-- ** bytesSent #attr:bytesSent#
-- | initialize to 0. Will be set to the number of bytes
--     that have been sent

    getOutputMessageBytesSent               ,
#if defined(ENABLE_OVERLOADING)
    outputMessage_bytesSent                 ,
#endif
    setOutputMessageBytesSent               ,


-- ** numControlMessages #attr:numControlMessages#
-- | number of elements in /@controlMessages@/.

    getOutputMessageNumControlMessages      ,
#if defined(ENABLE_OVERLOADING)
    outputMessage_numControlMessages        ,
#endif
    setOutputMessageNumControlMessages      ,


-- ** numVectors #attr:numVectors#
-- | the number of output vectors pointed to by /@vectors@/.

    getOutputMessageNumVectors              ,
#if defined(ENABLE_OVERLOADING)
    outputMessage_numVectors                ,
#endif
    setOutputMessageNumVectors              ,


-- ** vectors #attr:vectors#
-- | pointer to an array of output vectors

    clearOutputMessageVectors               ,
    getOutputMessageVectors                 ,
#if defined(ENABLE_OVERLOADING)
    outputMessage_vectors                   ,
#endif
    setOutputMessageVectors                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#endif

-- | Memory-managed wrapper type.
newtype OutputMessage = OutputMessage (SP.ManagedPtr OutputMessage)
    deriving (Eq)

instance SP.ManagedPtrNewtype OutputMessage where
    toManagedPtr (OutputMessage p) = p

instance BoxedPtr OutputMessage where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr OutputMessage)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OutputMessage where
    boxedPtrCalloc = callocBytes 40


-- | Construct a `OutputMessage` struct initialized to zero.
newZeroOutputMessage :: MonadIO m => m OutputMessage
newZeroOutputMessage = liftIO $ boxedPtrCalloc >>= wrapPtr OutputMessage

instance tag ~ 'AttrSet => Constructible OutputMessage tag where
    new _ attrs = do
        o <- newZeroOutputMessage
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@address@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputMessage #address
-- @
getOutputMessageAddress :: MonadIO m => OutputMessage -> m (Maybe Gio.SocketAddress.SocketAddress)
getOutputMessageAddress s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Gio.SocketAddress.SocketAddress)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gio.SocketAddress.SocketAddress) val'
        return val''
    return result

-- | Set the value of the “@address@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputMessage [ #address 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputMessageAddress :: MonadIO m => OutputMessage -> Ptr Gio.SocketAddress.SocketAddress -> m ()
setOutputMessageAddress s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Gio.SocketAddress.SocketAddress)

-- | Set the value of the “@address@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #address
-- @
clearOutputMessageAddress :: MonadIO m => OutputMessage -> m ()
clearOutputMessageAddress s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Gio.SocketAddress.SocketAddress)

#if defined(ENABLE_OVERLOADING)
data OutputMessageAddressFieldInfo
instance AttrInfo OutputMessageAddressFieldInfo where
    type AttrBaseTypeConstraint OutputMessageAddressFieldInfo = (~) OutputMessage
    type AttrAllowedOps OutputMessageAddressFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OutputMessageAddressFieldInfo = (~) (Ptr Gio.SocketAddress.SocketAddress)
    type AttrTransferTypeConstraint OutputMessageAddressFieldInfo = (~)(Ptr Gio.SocketAddress.SocketAddress)
    type AttrTransferType OutputMessageAddressFieldInfo = (Ptr Gio.SocketAddress.SocketAddress)
    type AttrGetType OutputMessageAddressFieldInfo = Maybe Gio.SocketAddress.SocketAddress
    type AttrLabel OutputMessageAddressFieldInfo = "address"
    type AttrOrigin OutputMessageAddressFieldInfo = OutputMessage
    attrGet = getOutputMessageAddress
    attrSet = setOutputMessageAddress
    attrConstruct = undefined
    attrClear = clearOutputMessageAddress
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputMessage.address"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-OutputMessage.html#g:attr:address"
        })

outputMessage_address :: AttrLabelProxy "address"
outputMessage_address = AttrLabelProxy

#endif


-- | Get the value of the “@vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputMessage #vectors
-- @
getOutputMessageVectors :: MonadIO m => OutputMessage -> m (Maybe Gio.OutputVector.OutputVector)
getOutputMessageVectors s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gio.OutputVector.OutputVector)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Gio.OutputVector.OutputVector) val'
        return val''
    return result

-- | Set the value of the “@vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputMessage [ #vectors 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputMessageVectors :: MonadIO m => OutputMessage -> Ptr Gio.OutputVector.OutputVector -> m ()
setOutputMessageVectors s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gio.OutputVector.OutputVector)

-- | Set the value of the “@vectors@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vectors
-- @
clearOutputMessageVectors :: MonadIO m => OutputMessage -> m ()
clearOutputMessageVectors s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gio.OutputVector.OutputVector)

#if defined(ENABLE_OVERLOADING)
data OutputMessageVectorsFieldInfo
instance AttrInfo OutputMessageVectorsFieldInfo where
    type AttrBaseTypeConstraint OutputMessageVectorsFieldInfo = (~) OutputMessage
    type AttrAllowedOps OutputMessageVectorsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OutputMessageVectorsFieldInfo = (~) (Ptr Gio.OutputVector.OutputVector)
    type AttrTransferTypeConstraint OutputMessageVectorsFieldInfo = (~)(Ptr Gio.OutputVector.OutputVector)
    type AttrTransferType OutputMessageVectorsFieldInfo = (Ptr Gio.OutputVector.OutputVector)
    type AttrGetType OutputMessageVectorsFieldInfo = Maybe Gio.OutputVector.OutputVector
    type AttrLabel OutputMessageVectorsFieldInfo = "vectors"
    type AttrOrigin OutputMessageVectorsFieldInfo = OutputMessage
    attrGet = getOutputMessageVectors
    attrSet = setOutputMessageVectors
    attrConstruct = undefined
    attrClear = clearOutputMessageVectors
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputMessage.vectors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-OutputMessage.html#g:attr:vectors"
        })

outputMessage_vectors :: AttrLabelProxy "vectors"
outputMessage_vectors = AttrLabelProxy

#endif


-- | Get the value of the “@num_vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputMessage #numVectors
-- @
getOutputMessageNumVectors :: MonadIO m => OutputMessage -> m Word32
getOutputMessageNumVectors s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@num_vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputMessage [ #numVectors 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputMessageNumVectors :: MonadIO m => OutputMessage -> Word32 -> m ()
setOutputMessageNumVectors s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OutputMessageNumVectorsFieldInfo
instance AttrInfo OutputMessageNumVectorsFieldInfo where
    type AttrBaseTypeConstraint OutputMessageNumVectorsFieldInfo = (~) OutputMessage
    type AttrAllowedOps OutputMessageNumVectorsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OutputMessageNumVectorsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OutputMessageNumVectorsFieldInfo = (~)Word32
    type AttrTransferType OutputMessageNumVectorsFieldInfo = Word32
    type AttrGetType OutputMessageNumVectorsFieldInfo = Word32
    type AttrLabel OutputMessageNumVectorsFieldInfo = "num_vectors"
    type AttrOrigin OutputMessageNumVectorsFieldInfo = OutputMessage
    attrGet = getOutputMessageNumVectors
    attrSet = setOutputMessageNumVectors
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputMessage.numVectors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-OutputMessage.html#g:attr:numVectors"
        })

outputMessage_numVectors :: AttrLabelProxy "numVectors"
outputMessage_numVectors = AttrLabelProxy

#endif


-- | Get the value of the “@bytes_sent@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputMessage #bytesSent
-- @
getOutputMessageBytesSent :: MonadIO m => OutputMessage -> m Word32
getOutputMessageBytesSent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@bytes_sent@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputMessage [ #bytesSent 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputMessageBytesSent :: MonadIO m => OutputMessage -> Word32 -> m ()
setOutputMessageBytesSent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OutputMessageBytesSentFieldInfo
instance AttrInfo OutputMessageBytesSentFieldInfo where
    type AttrBaseTypeConstraint OutputMessageBytesSentFieldInfo = (~) OutputMessage
    type AttrAllowedOps OutputMessageBytesSentFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OutputMessageBytesSentFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OutputMessageBytesSentFieldInfo = (~)Word32
    type AttrTransferType OutputMessageBytesSentFieldInfo = Word32
    type AttrGetType OutputMessageBytesSentFieldInfo = Word32
    type AttrLabel OutputMessageBytesSentFieldInfo = "bytes_sent"
    type AttrOrigin OutputMessageBytesSentFieldInfo = OutputMessage
    attrGet = getOutputMessageBytesSent
    attrSet = setOutputMessageBytesSent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputMessage.bytesSent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-OutputMessage.html#g:attr:bytesSent"
        })

outputMessage_bytesSent :: AttrLabelProxy "bytesSent"
outputMessage_bytesSent = AttrLabelProxy

#endif


-- XXX Skipped attribute for "OutputMessage:control_messages"
-- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 5 (TInterface (Name {namespace = "Gio", name = "SocketControlMessage"}))
-- | Get the value of the “@num_control_messages@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputMessage #numControlMessages
-- @
getOutputMessageNumControlMessages :: MonadIO m => OutputMessage -> m Word32
getOutputMessageNumControlMessages s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@num_control_messages@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputMessage [ #numControlMessages 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputMessageNumControlMessages :: MonadIO m => OutputMessage -> Word32 -> m ()
setOutputMessageNumControlMessages s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OutputMessageNumControlMessagesFieldInfo
instance AttrInfo OutputMessageNumControlMessagesFieldInfo where
    type AttrBaseTypeConstraint OutputMessageNumControlMessagesFieldInfo = (~) OutputMessage
    type AttrAllowedOps OutputMessageNumControlMessagesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OutputMessageNumControlMessagesFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OutputMessageNumControlMessagesFieldInfo = (~)Word32
    type AttrTransferType OutputMessageNumControlMessagesFieldInfo = Word32
    type AttrGetType OutputMessageNumControlMessagesFieldInfo = Word32
    type AttrLabel OutputMessageNumControlMessagesFieldInfo = "num_control_messages"
    type AttrOrigin OutputMessageNumControlMessagesFieldInfo = OutputMessage
    attrGet = getOutputMessageNumControlMessages
    attrSet = setOutputMessageNumControlMessages
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputMessage.numControlMessages"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-OutputMessage.html#g:attr:numControlMessages"
        })

outputMessage_numControlMessages :: AttrLabelProxy "numControlMessages"
outputMessage_numControlMessages = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OutputMessage
type instance O.AttributeList OutputMessage = OutputMessageAttributeList
type OutputMessageAttributeList = ('[ '("address", OutputMessageAddressFieldInfo), '("vectors", OutputMessageVectorsFieldInfo), '("numVectors", OutputMessageNumVectorsFieldInfo), '("bytesSent", OutputMessageBytesSentFieldInfo), '("numControlMessages", OutputMessageNumControlMessagesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOutputMessageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOutputMessageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOutputMessageMethod t OutputMessage, O.OverloadedMethod info OutputMessage p) => OL.IsLabel t (OutputMessage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOutputMessageMethod t OutputMessage, O.OverloadedMethod info OutputMessage p, R.HasField t OutputMessage p) => R.HasField t OutputMessage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOutputMessageMethod t OutputMessage, O.OverloadedMethodInfo info OutputMessage) => OL.IsLabel t (O.MethodProxy info OutputMessage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


