{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Structure used for scatter\/gather data input.
-- You generally pass in an array of @/GInputVectors/@
-- and the operation will store the read data starting in the
-- first buffer, switching to the next as needed.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.InputVector
    ( 

-- * Exported types
    InputVector(..)                         ,
    newZeroInputVector                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveInputVectorMethod                ,
#endif



 -- * Properties


-- ** buffer #attr:buffer#
-- | Pointer to a buffer where data will be written.

    clearInputVectorBuffer                  ,
    getInputVectorBuffer                    ,
#if defined(ENABLE_OVERLOADING)
    inputVector_buffer                      ,
#endif
    setInputVectorBuffer                    ,


-- ** size #attr:size#
-- | the available size in /@buffer@/.

    getInputVectorSize                      ,
#if defined(ENABLE_OVERLOADING)
    inputVector_size                        ,
#endif
    setInputVectorSize                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype InputVector = InputVector (SP.ManagedPtr InputVector)
    deriving (Eq)

instance SP.ManagedPtrNewtype InputVector where
    toManagedPtr (InputVector p) = p

instance BoxedPtr InputVector where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr InputVector)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr InputVector where
    boxedPtrCalloc = callocBytes 16


-- | Construct a `InputVector` struct initialized to zero.
newZeroInputVector :: MonadIO m => m InputVector
newZeroInputVector = liftIO $ boxedPtrCalloc >>= wrapPtr InputVector

instance tag ~ 'AttrSet => Constructible InputVector tag where
    new _ attrs = do
        o <- newZeroInputVector
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@buffer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputVector #buffer
-- @
getInputVectorBuffer :: MonadIO m => InputVector -> m (Ptr ())
getInputVectorBuffer s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@buffer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputVector [ #buffer 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputVectorBuffer :: MonadIO m => InputVector -> Ptr () -> m ()
setInputVectorBuffer s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@buffer@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #buffer
-- @
clearInputVectorBuffer :: MonadIO m => InputVector -> m ()
clearInputVectorBuffer s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data InputVectorBufferFieldInfo
instance AttrInfo InputVectorBufferFieldInfo where
    type AttrBaseTypeConstraint InputVectorBufferFieldInfo = (~) InputVector
    type AttrAllowedOps InputVectorBufferFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputVectorBufferFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint InputVectorBufferFieldInfo = (~)(Ptr ())
    type AttrTransferType InputVectorBufferFieldInfo = (Ptr ())
    type AttrGetType InputVectorBufferFieldInfo = Ptr ()
    type AttrLabel InputVectorBufferFieldInfo = "buffer"
    type AttrOrigin InputVectorBufferFieldInfo = InputVector
    attrGet = getInputVectorBuffer
    attrSet = setInputVectorBuffer
    attrConstruct = undefined
    attrClear = clearInputVectorBuffer
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputVector.buffer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputVector.html#g:attr:buffer"
        })

inputVector_buffer :: AttrLabelProxy "buffer"
inputVector_buffer = AttrLabelProxy

#endif


-- | Get the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputVector #size
-- @
getInputVectorSize :: MonadIO m => InputVector -> m FCT.CSize
getInputVectorSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO FCT.CSize
    return val

-- | Set the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputVector [ #size 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputVectorSize :: MonadIO m => InputVector -> FCT.CSize -> m ()
setInputVectorSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data InputVectorSizeFieldInfo
instance AttrInfo InputVectorSizeFieldInfo where
    type AttrBaseTypeConstraint InputVectorSizeFieldInfo = (~) InputVector
    type AttrAllowedOps InputVectorSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint InputVectorSizeFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint InputVectorSizeFieldInfo = (~)FCT.CSize
    type AttrTransferType InputVectorSizeFieldInfo = FCT.CSize
    type AttrGetType InputVectorSizeFieldInfo = FCT.CSize
    type AttrLabel InputVectorSizeFieldInfo = "size"
    type AttrOrigin InputVectorSizeFieldInfo = InputVector
    attrGet = getInputVectorSize
    attrSet = setInputVectorSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputVector.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputVector.html#g:attr:size"
        })

inputVector_size :: AttrLabelProxy "size"
inputVector_size = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InputVector
type instance O.AttributeList InputVector = InputVectorAttributeList
type InputVectorAttributeList = ('[ '("buffer", InputVectorBufferFieldInfo), '("size", InputVectorSizeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveInputVectorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInputVectorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInputVectorMethod t InputVector, O.OverloadedMethod info InputVector p) => OL.IsLabel t (InputVector -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInputVectorMethod t InputVector, O.OverloadedMethod info InputVector p, R.HasField t InputVector p) => R.HasField t InputVector p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInputVectorMethod t InputVector, O.OverloadedMethodInfo info InputVector) => OL.IsLabel t (O.MethodProxy info InputVector) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


