{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Structure used for scatter\/gather data input when receiving multiple
-- messages or packets in one go. You generally pass in an array of empty
-- @/GInputVectors/@ and the operation will use all the buffers as if they
-- were one buffer, and will set /@bytesReceived@/ to the total number of bytes
-- received across all @/GInputVectors/@.
-- 
-- This structure closely mirrors @struct mmsghdr@ and @struct msghdr@ from
-- the POSIX sockets API (see @man 2 recvmmsg@).
-- 
-- If /@address@/ is non-'P.Nothing' then it is set to the source address the message
-- was received from, and the caller must free it afterwards.
-- 
-- If /@controlMessages@/ is non-'P.Nothing' then it is set to an array of control
-- messages received with the message (if any), and the caller must free it
-- afterwards. /@numControlMessages@/ is set to the number of elements in
-- this array, which may be zero.
-- 
-- Flags relevant to this message will be returned in /@flags@/. For example,
-- @MSG_EOR@ or @MSG_TRUNC@.
-- 
-- /Since: 2.48/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.InputMessage
    ( 

-- * Exported types
    InputMessage(..)                        ,
    newZeroInputMessage                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveInputMessageMethod               ,
#endif



 -- * Properties


-- ** address #attr:address#
-- | return location
--   for a t'GI.Gio.Objects.SocketAddress.SocketAddress', or 'P.Nothing'

    clearInputMessageAddress                ,
    getInputMessageAddress                  ,
#if defined(ENABLE_OVERLOADING)
    inputMessage_address                    ,
#endif
    setInputMessageAddress                  ,


-- ** bytesReceived #attr:bytesReceived#
-- | will be set to the number of bytes that have been
--   received

    getInputMessageBytesReceived            ,
#if defined(ENABLE_OVERLOADING)
    inputMessage_bytesReceived              ,
#endif
    setInputMessageBytesReceived            ,


-- ** flags #attr:flags#
-- | collection of t'GI.Gio.Flags.SocketMsgFlags' for the received message,
--   outputted by the call

    getInputMessageFlags                    ,
#if defined(ENABLE_OVERLOADING)
    inputMessage_flags                      ,
#endif
    setInputMessageFlags                    ,


-- ** numControlMessages #attr:numControlMessages#
-- | return location for the number of
--   elements in /@controlMessages@/

    getInputMessageNumControlMessages       ,
#if defined(ENABLE_OVERLOADING)
    inputMessage_numControlMessages         ,
#endif
    setInputMessageNumControlMessages       ,


-- ** numVectors #attr:numVectors#
-- | the number of input vectors pointed to by /@vectors@/

    getInputMessageNumVectors               ,
#if defined(ENABLE_OVERLOADING)
    inputMessage_numVectors                 ,
#endif
    setInputMessageNumVectors               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#endif

-- | Memory-managed wrapper type.
newtype InputMessage = InputMessage (SP.ManagedPtr InputMessage)
    deriving (Eq)

instance SP.ManagedPtrNewtype InputMessage where
    toManagedPtr (InputMessage p) = p

instance BoxedPtr InputMessage where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr InputMessage)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr InputMessage where
    boxedPtrCalloc = callocBytes 56


-- | Construct a `InputMessage` struct initialized to zero.
newZeroInputMessage :: MonadIO m => m InputMessage
newZeroInputMessage = liftIO $ boxedPtrCalloc >>= wrapPtr InputMessage

instance tag ~ 'AttrSet => Constructible InputMessage tag where
    new _ attrs = do
        o <- newZeroInputMessage
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@address@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputMessage #address
-- @
getInputMessageAddress :: MonadIO m => InputMessage -> m (Maybe Gio.SocketAddress.SocketAddress)
getInputMessageAddress s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Gio.SocketAddress.SocketAddress)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gio.SocketAddress.SocketAddress) val'
        return val''
    return result

-- | Set the value of the “@address@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputMessage [ #address 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputMessageAddress :: MonadIO m => InputMessage -> Ptr Gio.SocketAddress.SocketAddress -> m ()
setInputMessageAddress s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Gio.SocketAddress.SocketAddress)

-- | Set the value of the “@address@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #address
-- @
clearInputMessageAddress :: MonadIO m => InputMessage -> m ()
clearInputMessageAddress s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Gio.SocketAddress.SocketAddress)

#if defined(ENABLE_OVERLOADING)
data InputMessageAddressFieldInfo
instance AttrInfo InputMessageAddressFieldInfo where
    type AttrBaseTypeConstraint InputMessageAddressFieldInfo = (~) InputMessage
    type AttrAllowedOps InputMessageAddressFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint InputMessageAddressFieldInfo = (~) (Ptr Gio.SocketAddress.SocketAddress)
    type AttrTransferTypeConstraint InputMessageAddressFieldInfo = (~)(Ptr Gio.SocketAddress.SocketAddress)
    type AttrTransferType InputMessageAddressFieldInfo = (Ptr Gio.SocketAddress.SocketAddress)
    type AttrGetType InputMessageAddressFieldInfo = Maybe Gio.SocketAddress.SocketAddress
    type AttrLabel InputMessageAddressFieldInfo = "address"
    type AttrOrigin InputMessageAddressFieldInfo = InputMessage
    attrGet = getInputMessageAddress
    attrSet = setInputMessageAddress
    attrConstruct = undefined
    attrClear = clearInputMessageAddress
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputMessage.address"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputMessage.html#g:attr:address"
        })

inputMessage_address :: AttrLabelProxy "address"
inputMessage_address = AttrLabelProxy

#endif


-- XXX Skipped attribute for "InputMessage:vectors"
-- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 2 (TInterface (Name {namespace = "Gio", name = "InputVector"}))
-- | Get the value of the “@num_vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputMessage #numVectors
-- @
getInputMessageNumVectors :: MonadIO m => InputMessage -> m Word32
getInputMessageNumVectors s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Word32
    return val

-- | Set the value of the “@num_vectors@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputMessage [ #numVectors 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputMessageNumVectors :: MonadIO m => InputMessage -> Word32 -> m ()
setInputMessageNumVectors s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data InputMessageNumVectorsFieldInfo
instance AttrInfo InputMessageNumVectorsFieldInfo where
    type AttrBaseTypeConstraint InputMessageNumVectorsFieldInfo = (~) InputMessage
    type AttrAllowedOps InputMessageNumVectorsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint InputMessageNumVectorsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint InputMessageNumVectorsFieldInfo = (~)Word32
    type AttrTransferType InputMessageNumVectorsFieldInfo = Word32
    type AttrGetType InputMessageNumVectorsFieldInfo = Word32
    type AttrLabel InputMessageNumVectorsFieldInfo = "num_vectors"
    type AttrOrigin InputMessageNumVectorsFieldInfo = InputMessage
    attrGet = getInputMessageNumVectors
    attrSet = setInputMessageNumVectors
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputMessage.numVectors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputMessage.html#g:attr:numVectors"
        })

inputMessage_numVectors :: AttrLabelProxy "numVectors"
inputMessage_numVectors = AttrLabelProxy

#endif


-- | Get the value of the “@bytes_received@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputMessage #bytesReceived
-- @
getInputMessageBytesReceived :: MonadIO m => InputMessage -> m FCT.CSize
getInputMessageBytesReceived s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO FCT.CSize
    return val

-- | Set the value of the “@bytes_received@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputMessage [ #bytesReceived 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputMessageBytesReceived :: MonadIO m => InputMessage -> FCT.CSize -> m ()
setInputMessageBytesReceived s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data InputMessageBytesReceivedFieldInfo
instance AttrInfo InputMessageBytesReceivedFieldInfo where
    type AttrBaseTypeConstraint InputMessageBytesReceivedFieldInfo = (~) InputMessage
    type AttrAllowedOps InputMessageBytesReceivedFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint InputMessageBytesReceivedFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint InputMessageBytesReceivedFieldInfo = (~)FCT.CSize
    type AttrTransferType InputMessageBytesReceivedFieldInfo = FCT.CSize
    type AttrGetType InputMessageBytesReceivedFieldInfo = FCT.CSize
    type AttrLabel InputMessageBytesReceivedFieldInfo = "bytes_received"
    type AttrOrigin InputMessageBytesReceivedFieldInfo = InputMessage
    attrGet = getInputMessageBytesReceived
    attrSet = setInputMessageBytesReceived
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputMessage.bytesReceived"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputMessage.html#g:attr:bytesReceived"
        })

inputMessage_bytesReceived :: AttrLabelProxy "bytesReceived"
inputMessage_bytesReceived = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputMessage #flags
-- @
getInputMessageFlags :: MonadIO m => InputMessage -> m Int32
getInputMessageFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Int32
    return val

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputMessage [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputMessageFlags :: MonadIO m => InputMessage -> Int32 -> m ()
setInputMessageFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data InputMessageFlagsFieldInfo
instance AttrInfo InputMessageFlagsFieldInfo where
    type AttrBaseTypeConstraint InputMessageFlagsFieldInfo = (~) InputMessage
    type AttrAllowedOps InputMessageFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint InputMessageFlagsFieldInfo = (~) Int32
    type AttrTransferTypeConstraint InputMessageFlagsFieldInfo = (~)Int32
    type AttrTransferType InputMessageFlagsFieldInfo = Int32
    type AttrGetType InputMessageFlagsFieldInfo = Int32
    type AttrLabel InputMessageFlagsFieldInfo = "flags"
    type AttrOrigin InputMessageFlagsFieldInfo = InputMessage
    attrGet = getInputMessageFlags
    attrSet = setInputMessageFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputMessage.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputMessage.html#g:attr:flags"
        })

inputMessage_flags :: AttrLabelProxy "flags"
inputMessage_flags = AttrLabelProxy

#endif


-- XXX Skipped attribute for "InputMessage:control_messages"
-- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 6 (TInterface (Name {namespace = "Gio", name = "SocketControlMessage"}))
-- | Get the value of the “@num_control_messages@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inputMessage #numControlMessages
-- @
getInputMessageNumControlMessages :: MonadIO m => InputMessage -> m Word32
getInputMessageNumControlMessages s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Word32
    return val

-- | Set the value of the “@num_control_messages@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inputMessage [ #numControlMessages 'Data.GI.Base.Attributes.:=' value ]
-- @
setInputMessageNumControlMessages :: MonadIO m => InputMessage -> Word32 -> m ()
setInputMessageNumControlMessages s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data InputMessageNumControlMessagesFieldInfo
instance AttrInfo InputMessageNumControlMessagesFieldInfo where
    type AttrBaseTypeConstraint InputMessageNumControlMessagesFieldInfo = (~) InputMessage
    type AttrAllowedOps InputMessageNumControlMessagesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint InputMessageNumControlMessagesFieldInfo = (~) Word32
    type AttrTransferTypeConstraint InputMessageNumControlMessagesFieldInfo = (~)Word32
    type AttrTransferType InputMessageNumControlMessagesFieldInfo = Word32
    type AttrGetType InputMessageNumControlMessagesFieldInfo = Word32
    type AttrLabel InputMessageNumControlMessagesFieldInfo = "num_control_messages"
    type AttrOrigin InputMessageNumControlMessagesFieldInfo = InputMessage
    attrGet = getInputMessageNumControlMessages
    attrSet = setInputMessageNumControlMessages
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.InputMessage.numControlMessages"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-InputMessage.html#g:attr:numControlMessages"
        })

inputMessage_numControlMessages :: AttrLabelProxy "numControlMessages"
inputMessage_numControlMessages = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InputMessage
type instance O.AttributeList InputMessage = InputMessageAttributeList
type InputMessageAttributeList = ('[ '("address", InputMessageAddressFieldInfo), '("numVectors", InputMessageNumVectorsFieldInfo), '("bytesReceived", InputMessageBytesReceivedFieldInfo), '("flags", InputMessageFlagsFieldInfo), '("numControlMessages", InputMessageNumControlMessagesFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveInputMessageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInputMessageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInputMessageMethod t InputMessage, O.OverloadedMethod info InputMessage p) => OL.IsLabel t (InputMessage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInputMessageMethod t InputMessage, O.OverloadedMethod info InputMessage p, R.HasField t InputMessage p) => R.HasField t InputMessage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInputMessageMethod t InputMessage, O.OverloadedMethodInfo info InputMessage) => OL.IsLabel t (O.MethodProxy info InputMessage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


