{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Opaque class for defining and scheduling IO jobs.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.IOSchedulerJob
    ( 

-- * Exported types
    IOSchedulerJob(..)                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [sendToMainloop]("GI.Gio.Structs.IOSchedulerJob#g:method:sendToMainloop"), [sendToMainloopAsync]("GI.Gio.Structs.IOSchedulerJob#g:method:sendToMainloopAsync").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveIOSchedulerJobMethod             ,
#endif

-- ** sendToMainloop #method:sendToMainloop#

#if defined(ENABLE_OVERLOADING)
    IOSchedulerJobSendToMainloopMethodInfo  ,
#endif
    iOSchedulerJobSendToMainloop            ,


-- ** sendToMainloopAsync #method:sendToMainloopAsync#

#if defined(ENABLE_OVERLOADING)
    IOSchedulerJobSendToMainloopAsyncMethodInfo,
#endif
    iOSchedulerJobSendToMainloopAsync       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype IOSchedulerJob = IOSchedulerJob (SP.ManagedPtr IOSchedulerJob)
    deriving (Eq)

instance SP.ManagedPtrNewtype IOSchedulerJob where
    toManagedPtr (IOSchedulerJob p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr IOSchedulerJob where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IOSchedulerJob
type instance O.AttributeList IOSchedulerJob = IOSchedulerJobAttributeList
type IOSchedulerJobAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method IOSchedulerJob::send_to_mainloop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOSchedulerJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOSchedulerJob" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GSourceFunc callback that will be called in the original thread"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDestroyNotify for @user_data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_scheduler_job_send_to_mainloop" g_io_scheduler_job_send_to_mainloop :: 
    Ptr IOSchedulerJob ->                   -- job : TInterface (Name {namespace = "Gio", name = "IOSchedulerJob"})
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- func : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO CInt

{-# DEPRECATED iOSchedulerJobSendToMainloop ["(Since version 2.36)","Use @/g_main_context_invoke()/@."] #-}
-- | Used from an I\/O job to send a callback to be run in the thread
-- that the job was started from, waiting for the result (and thus
-- blocking the I\/O job).
iOSchedulerJobSendToMainloop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOSchedulerJob
    -- ^ /@job@/: a t'GI.Gio.Structs.IOSchedulerJob.IOSchedulerJob'
    -> GLib.Callbacks.SourceFunc
    -- ^ /@func@/: a t'GI.GLib.Callbacks.SourceFunc' callback that will be called in the original thread
    -> m Bool
    -- ^ __Returns:__ The return value of /@func@/
iOSchedulerJobSendToMainloop job func = liftIO $ do
    job' <- unsafeManagedPtrGetPtr job
    func' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc func))
    let userData = castFunPtrToPtr func'
    let notify = SP.safeFreeFunPtrPtr
    result <- g_io_scheduler_job_send_to_mainloop job' func' userData notify
    let result' = (/= 0) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data IOSchedulerJobSendToMainloopMethodInfo
instance (signature ~ (GLib.Callbacks.SourceFunc -> m Bool), MonadIO m) => O.OverloadedMethod IOSchedulerJobSendToMainloopMethodInfo IOSchedulerJob signature where
    overloadedMethod = iOSchedulerJobSendToMainloop

instance O.OverloadedMethodInfo IOSchedulerJobSendToMainloopMethodInfo IOSchedulerJob where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOSchedulerJob.iOSchedulerJobSendToMainloop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOSchedulerJob.html#v:iOSchedulerJobSendToMainloop"
        })


#endif

-- method IOSchedulerJob::send_to_mainloop_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOSchedulerJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOSchedulerJob" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GSourceFunc callback that will be called in the original thread"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDestroyNotify for @user_data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_scheduler_job_send_to_mainloop_async" g_io_scheduler_job_send_to_mainloop_async :: 
    Ptr IOSchedulerJob ->                   -- job : TInterface (Name {namespace = "Gio", name = "IOSchedulerJob"})
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- func : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

{-# DEPRECATED iOSchedulerJobSendToMainloopAsync ["(Since version 2.36)","Use @/g_main_context_invoke()/@."] #-}
-- | Used from an I\/O job to send a callback to be run asynchronously in
-- the thread that the job was started from. The callback will be run
-- when the main loop is available, but at that time the I\/O job might
-- have finished. The return value from the callback is ignored.
-- 
-- Note that if you are passing the /@userData@/ from 'GI.Gio.Functions.ioSchedulerPushJob'
-- on to this function you have to ensure that it is not freed before
-- /@func@/ is called, either by passing 'P.Nothing' as /@notify@/ to
-- 'GI.Gio.Functions.ioSchedulerPushJob' or by using refcounting for /@userData@/.
iOSchedulerJobSendToMainloopAsync ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOSchedulerJob
    -- ^ /@job@/: a t'GI.Gio.Structs.IOSchedulerJob.IOSchedulerJob'
    -> GLib.Callbacks.SourceFunc
    -- ^ /@func@/: a t'GI.GLib.Callbacks.SourceFunc' callback that will be called in the original thread
    -> m ()
iOSchedulerJobSendToMainloopAsync job func = liftIO $ do
    job' <- unsafeManagedPtrGetPtr job
    func' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc func))
    let userData = castFunPtrToPtr func'
    let notify = SP.safeFreeFunPtrPtr
    g_io_scheduler_job_send_to_mainloop_async job' func' userData notify
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data IOSchedulerJobSendToMainloopAsyncMethodInfo
instance (signature ~ (GLib.Callbacks.SourceFunc -> m ()), MonadIO m) => O.OverloadedMethod IOSchedulerJobSendToMainloopAsyncMethodInfo IOSchedulerJob signature where
    overloadedMethod = iOSchedulerJobSendToMainloopAsync

instance O.OverloadedMethodInfo IOSchedulerJobSendToMainloopAsyncMethodInfo IOSchedulerJob where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOSchedulerJob.iOSchedulerJobSendToMainloopAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOSchedulerJob.html#v:iOSchedulerJobSendToMainloopAsync"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveIOSchedulerJobMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIOSchedulerJobMethod "sendToMainloop" o = IOSchedulerJobSendToMainloopMethodInfo
    ResolveIOSchedulerJobMethod "sendToMainloopAsync" o = IOSchedulerJobSendToMainloopAsyncMethodInfo
    ResolveIOSchedulerJobMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIOSchedulerJobMethod t IOSchedulerJob, O.OverloadedMethod info IOSchedulerJob p) => OL.IsLabel t (IOSchedulerJob -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIOSchedulerJobMethod t IOSchedulerJob, O.OverloadedMethod info IOSchedulerJob p, R.HasField t IOSchedulerJob p) => R.HasField t IOSchedulerJob p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIOSchedulerJobMethod t IOSchedulerJob, O.OverloadedMethodInfo info IOSchedulerJob) => OL.IsLabel t (O.MethodProxy info IOSchedulerJob) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


