{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GIOExtensionPoint@ provides a mechanism for modules to extend the
-- functionality of the library or application that loaded it in an
-- organized fashion.
-- 
-- An extension point is identified by a name, and it may optionally
-- require that any implementation must be of a certain type (or derived
-- thereof). Use [func/@gio@/.IOExtensionPoint.register] to register an
-- extension point, and 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointSetRequiredType' to
-- set a required type.
-- 
-- A module can implement an extension point by specifying the
-- [type/@gObject@/.Type] that implements the functionality. Additionally, each
-- implementation of an extension point has a name, and a priority. Use
-- [func/@gio@/.IOExtensionPoint.implement] to implement an extension point.
-- 
-- 
-- === /c code/
-- >GIOExtensionPoint *ep;
-- >
-- >// Register an extension point
-- >ep = g_io_extension_point_register ("my-extension-point");
-- >g_io_extension_point_set_required_type (ep, MY_TYPE_EXAMPLE);
-- 
-- 
-- 
-- === /c code/
-- >// Implement an extension point
-- >G_DEFINE_TYPE (MyExampleImpl, my_example_impl, MY_TYPE_EXAMPLE)
-- >g_io_extension_point_implement ("my-extension-point",
-- >                                my_example_impl_get_type (),
-- >                                "my-example",
-- >                                10);
-- 
-- 
--  It is up to the code that registered the extension point how
--  it uses the implementations that have been associated with it.
--  Depending on the use case, it may use all implementations, or
--  only the one with the highest priority, or pick a specific
--  one by name.
-- 
--  To avoid opening all modules just to find out what extension
--  points they implement, GIO makes use of a caching mechanism,
--  see <http://developer.gnome.org/gio/stable/gio-querymodules.html gio-querymodules>.
--  You are expected to run this command after installing a
--  GIO module.
-- 
--  The @GIO_EXTRA_MODULES@ environment variable can be used to
--  specify additional directories to automatically load modules
--  from. This environment variable has the same syntax as the
--  @PATH@. If two modules have the same base name in different
--  directories, then the latter one will be ignored. If additional
--  directories are specified GIO will load modules from the built-in
--  directory last.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.IOExtensionPoint
    ( 

-- * Exported types
    IOExtensionPoint(..)                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getExtensionByName]("GI.Gio.Structs.IOExtensionPoint#g:method:getExtensionByName"), [getExtensions]("GI.Gio.Structs.IOExtensionPoint#g:method:getExtensions"), [getRequiredType]("GI.Gio.Structs.IOExtensionPoint#g:method:getRequiredType").
-- 
-- ==== Setters
-- [setRequiredType]("GI.Gio.Structs.IOExtensionPoint#g:method:setRequiredType").

#if defined(ENABLE_OVERLOADING)
    ResolveIOExtensionPointMethod           ,
#endif

-- ** getExtensionByName #method:getExtensionByName#

#if defined(ENABLE_OVERLOADING)
    IOExtensionPointGetExtensionByNameMethodInfo,
#endif
    iOExtensionPointGetExtensionByName      ,


-- ** getExtensions #method:getExtensions#

#if defined(ENABLE_OVERLOADING)
    IOExtensionPointGetExtensionsMethodInfo ,
#endif
    iOExtensionPointGetExtensions           ,


-- ** getRequiredType #method:getRequiredType#

#if defined(ENABLE_OVERLOADING)
    IOExtensionPointGetRequiredTypeMethodInfo,
#endif
    iOExtensionPointGetRequiredType         ,


-- ** implement #method:implement#

    iOExtensionPointImplement               ,


-- ** lookup #method:lookup#

    iOExtensionPointLookup                  ,


-- ** register #method:register#

    iOExtensionPointRegister                ,


-- ** setRequiredType #method:setRequiredType#

#if defined(ENABLE_OVERLOADING)
    IOExtensionPointSetRequiredTypeMethodInfo,
#endif
    iOExtensionPointSetRequiredType         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Structs.IOExtension as Gio.IOExtension

#else
import {-# SOURCE #-} qualified GI.Gio.Structs.IOExtension as Gio.IOExtension

#endif

-- | Memory-managed wrapper type.
newtype IOExtensionPoint = IOExtensionPoint (SP.ManagedPtr IOExtensionPoint)
    deriving (Eq)

instance SP.ManagedPtrNewtype IOExtensionPoint where
    toManagedPtr (IOExtensionPoint p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr IOExtensionPoint where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IOExtensionPoint
type instance O.AttributeList IOExtensionPoint = IOExtensionPointAttributeList
type IOExtensionPointAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method IOExtensionPoint::get_extension_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension_point"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtensionPoint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the extension to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOExtension" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_get_extension_by_name" g_io_extension_point_get_extension_by_name :: 
    Ptr IOExtensionPoint ->                 -- extension_point : TInterface (Name {namespace = "Gio", name = "IOExtensionPoint"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gio.IOExtension.IOExtension)

-- | Finds a t'GI.Gio.Structs.IOExtension.IOExtension' for an extension point by name.
iOExtensionPointGetExtensionByName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtensionPoint
    -- ^ /@extensionPoint@/: a t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint'
    -> T.Text
    -- ^ /@name@/: the name of the extension to get
    -> m Gio.IOExtension.IOExtension
    -- ^ __Returns:__ the t'GI.Gio.Structs.IOExtension.IOExtension' for /@extensionPoint@/ that has the
    --    given name, or 'P.Nothing' if there is no extension with that name
iOExtensionPointGetExtensionByName extensionPoint name = liftIO $ do
    extensionPoint' <- unsafeManagedPtrGetPtr extensionPoint
    name' <- textToCString name
    result <- g_io_extension_point_get_extension_by_name extensionPoint' name'
    checkUnexpectedReturnNULL "iOExtensionPointGetExtensionByName" result
    result' <- (newPtr Gio.IOExtension.IOExtension) result
    touchManagedPtr extensionPoint
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
data IOExtensionPointGetExtensionByNameMethodInfo
instance (signature ~ (T.Text -> m Gio.IOExtension.IOExtension), MonadIO m) => O.OverloadedMethod IOExtensionPointGetExtensionByNameMethodInfo IOExtensionPoint signature where
    overloadedMethod = iOExtensionPointGetExtensionByName

instance O.OverloadedMethodInfo IOExtensionPointGetExtensionByNameMethodInfo IOExtensionPoint where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensionByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtensionPoint.html#v:iOExtensionPointGetExtensionByName"
        })


#endif

-- method IOExtensionPoint::get_extensions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension_point"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtensionPoint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "IOExtension" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_get_extensions" g_io_extension_point_get_extensions :: 
    Ptr IOExtensionPoint ->                 -- extension_point : TInterface (Name {namespace = "Gio", name = "IOExtensionPoint"})
    IO (Ptr (GList (Ptr Gio.IOExtension.IOExtension)))

-- | Gets a list of all extensions that implement this extension point.
-- The list is sorted by priority, beginning with the highest priority.
iOExtensionPointGetExtensions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtensionPoint
    -- ^ /@extensionPoint@/: a t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint'
    -> m [Gio.IOExtension.IOExtension]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of
    --     @/GIOExtensions/@. The list is owned by GIO and should not be
    --     modified.
iOExtensionPointGetExtensions extensionPoint = liftIO $ do
    extensionPoint' <- unsafeManagedPtrGetPtr extensionPoint
    result <- g_io_extension_point_get_extensions extensionPoint'
    result' <- unpackGList result
    result'' <- mapM (newPtr Gio.IOExtension.IOExtension) result'
    touchManagedPtr extensionPoint
    return result''

#if defined(ENABLE_OVERLOADING)
data IOExtensionPointGetExtensionsMethodInfo
instance (signature ~ (m [Gio.IOExtension.IOExtension]), MonadIO m) => O.OverloadedMethod IOExtensionPointGetExtensionsMethodInfo IOExtensionPoint signature where
    overloadedMethod = iOExtensionPointGetExtensions

instance O.OverloadedMethodInfo IOExtensionPointGetExtensionsMethodInfo IOExtensionPoint where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtensionPoint.html#v:iOExtensionPointGetExtensions"
        })


#endif

-- method IOExtensionPoint::get_required_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension_point"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtensionPoint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_get_required_type" g_io_extension_point_get_required_type :: 
    Ptr IOExtensionPoint ->                 -- extension_point : TInterface (Name {namespace = "Gio", name = "IOExtensionPoint"})
    IO CGType

-- | Gets the required type for /@extensionPoint@/.
iOExtensionPointGetRequiredType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtensionPoint
    -- ^ /@extensionPoint@/: a t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint'
    -> m GType
    -- ^ __Returns:__ the t'GType' that all implementations must have,
    --   or @/G_TYPE_INVALID/@ if the extension point has no required type
iOExtensionPointGetRequiredType extensionPoint = liftIO $ do
    extensionPoint' <- unsafeManagedPtrGetPtr extensionPoint
    result <- g_io_extension_point_get_required_type extensionPoint'
    let result' = GType result
    touchManagedPtr extensionPoint
    return result'

#if defined(ENABLE_OVERLOADING)
data IOExtensionPointGetRequiredTypeMethodInfo
instance (signature ~ (m GType), MonadIO m) => O.OverloadedMethod IOExtensionPointGetRequiredTypeMethodInfo IOExtensionPoint signature where
    overloadedMethod = iOExtensionPointGetRequiredType

instance O.OverloadedMethodInfo IOExtensionPointGetRequiredTypeMethodInfo IOExtensionPoint where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetRequiredType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtensionPoint.html#v:iOExtensionPointGetRequiredType"
        })


#endif

-- method IOExtensionPoint::set_required_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension_point"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtensionPoint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GType to require"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_set_required_type" g_io_extension_point_set_required_type :: 
    Ptr IOExtensionPoint ->                 -- extension_point : TInterface (Name {namespace = "Gio", name = "IOExtensionPoint"})
    CGType ->                               -- type : TBasicType TGType
    IO ()

-- | Sets the required type for /@extensionPoint@/ to /@type@/.
-- All implementations must henceforth have this type.
iOExtensionPointSetRequiredType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtensionPoint
    -- ^ /@extensionPoint@/: a t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint'
    -> GType
    -- ^ /@type@/: the t'GType' to require
    -> m ()
iOExtensionPointSetRequiredType extensionPoint type_ = liftIO $ do
    extensionPoint' <- unsafeManagedPtrGetPtr extensionPoint
    let type_' = gtypeToCGType type_
    g_io_extension_point_set_required_type extensionPoint' type_'
    touchManagedPtr extensionPoint
    return ()

#if defined(ENABLE_OVERLOADING)
data IOExtensionPointSetRequiredTypeMethodInfo
instance (signature ~ (GType -> m ()), MonadIO m) => O.OverloadedMethod IOExtensionPointSetRequiredTypeMethodInfo IOExtensionPoint signature where
    overloadedMethod = iOExtensionPointSetRequiredType

instance O.OverloadedMethodInfo IOExtensionPointSetRequiredTypeMethodInfo IOExtensionPoint where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtensionPoint.iOExtensionPointSetRequiredType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtensionPoint.html#v:iOExtensionPointSetRequiredType"
        })


#endif

-- method IOExtensionPoint::implement
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "extension_point_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the extension point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GType to register as extension"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "extension_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name for the extension"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the priority for the extension"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOExtension" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_implement" g_io_extension_point_implement :: 
    CString ->                              -- extension_point_name : TBasicType TUTF8
    CGType ->                               -- type : TBasicType TGType
    CString ->                              -- extension_name : TBasicType TUTF8
    Int32 ->                                -- priority : TBasicType TInt
    IO (Ptr Gio.IOExtension.IOExtension)

-- | Registers /@type@/ as extension for the extension point with name
-- /@extensionPointName@/.
-- 
-- If /@type@/ has already been registered as an extension for this
-- extension point, the existing t'GI.Gio.Structs.IOExtension.IOExtension' object is returned.
iOExtensionPointImplement ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@extensionPointName@/: the name of the extension point
    -> GType
    -- ^ /@type@/: the t'GType' to register as extension
    -> T.Text
    -- ^ /@extensionName@/: the name for the extension
    -> Int32
    -- ^ /@priority@/: the priority for the extension
    -> m Gio.IOExtension.IOExtension
    -- ^ __Returns:__ a t'GI.Gio.Structs.IOExtension.IOExtension' object for t'GType'
iOExtensionPointImplement extensionPointName type_ extensionName priority = liftIO $ do
    extensionPointName' <- textToCString extensionPointName
    let type_' = gtypeToCGType type_
    extensionName' <- textToCString extensionName
    result <- g_io_extension_point_implement extensionPointName' type_' extensionName' priority
    checkUnexpectedReturnNULL "iOExtensionPointImplement" result
    result' <- (newPtr Gio.IOExtension.IOExtension) result
    freeMem extensionPointName'
    freeMem extensionName'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IOExtensionPoint::lookup
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the extension point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_lookup" g_io_extension_point_lookup :: 
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr IOExtensionPoint)

-- | Looks up an existing extension point.
iOExtensionPointLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the extension point
    -> m IOExtensionPoint
    -- ^ __Returns:__ the t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint', or 'P.Nothing' if there
    --    is no registered extension point with the given name.
iOExtensionPointLookup name = liftIO $ do
    name' <- textToCString name
    result <- g_io_extension_point_lookup name'
    checkUnexpectedReturnNULL "iOExtensionPointLookup" result
    result' <- (newPtr IOExtensionPoint) result
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method IOExtensionPoint::register
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the extension point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "IOExtensionPoint" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_point_register" g_io_extension_point_register :: 
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr IOExtensionPoint)

-- | Registers an extension point.
iOExtensionPointRegister ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: The name of the extension point
    -> m IOExtensionPoint
    -- ^ __Returns:__ the new t'GI.Gio.Structs.IOExtensionPoint.IOExtensionPoint'. This object is
    --    owned by GIO and should not be freed.
iOExtensionPointRegister name = liftIO $ do
    name' <- textToCString name
    result <- g_io_extension_point_register name'
    checkUnexpectedReturnNULL "iOExtensionPointRegister" result
    result' <- (newPtr IOExtensionPoint) result
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveIOExtensionPointMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIOExtensionPointMethod "getExtensionByName" o = IOExtensionPointGetExtensionByNameMethodInfo
    ResolveIOExtensionPointMethod "getExtensions" o = IOExtensionPointGetExtensionsMethodInfo
    ResolveIOExtensionPointMethod "getRequiredType" o = IOExtensionPointGetRequiredTypeMethodInfo
    ResolveIOExtensionPointMethod "setRequiredType" o = IOExtensionPointSetRequiredTypeMethodInfo
    ResolveIOExtensionPointMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIOExtensionPointMethod t IOExtensionPoint, O.OverloadedMethod info IOExtensionPoint p) => OL.IsLabel t (IOExtensionPoint -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIOExtensionPointMethod t IOExtensionPoint, O.OverloadedMethod info IOExtensionPoint p, R.HasField t IOExtensionPoint p) => R.HasField t IOExtensionPoint p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIOExtensionPointMethod t IOExtensionPoint, O.OverloadedMethodInfo info IOExtensionPoint) => OL.IsLabel t (O.MethodProxy info IOExtensionPoint) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


