{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Structs.IOExtension.IOExtension' is an opaque data structure and can only be accessed
-- using the following functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.IOExtension
    ( 

-- * Exported types
    IOExtension(..)                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getName]("GI.Gio.Structs.IOExtension#g:method:getName"), [getPriority]("GI.Gio.Structs.IOExtension#g:method:getPriority"), [getType]("GI.Gio.Structs.IOExtension#g:method:getType").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveIOExtensionMethod                ,
#endif

-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    IOExtensionGetNameMethodInfo            ,
#endif
    iOExtensionGetName                      ,


-- ** getPriority #method:getPriority#

#if defined(ENABLE_OVERLOADING)
    IOExtensionGetPriorityMethodInfo        ,
#endif
    iOExtensionGetPriority                  ,


-- ** getType #method:getType#

#if defined(ENABLE_OVERLOADING)
    IOExtensionGetTypeMethodInfo            ,
#endif
    iOExtensionGetType                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype IOExtension = IOExtension (SP.ManagedPtr IOExtension)
    deriving (Eq)

instance SP.ManagedPtrNewtype IOExtension where
    toManagedPtr (IOExtension p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr IOExtension where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IOExtension
type instance O.AttributeList IOExtension = IOExtensionAttributeList
type IOExtensionAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method IOExtension::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtension" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtension" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_get_name" g_io_extension_get_name :: 
    Ptr IOExtension ->                      -- extension : TInterface (Name {namespace = "Gio", name = "IOExtension"})
    IO CString

-- | Gets the name under which /@extension@/ was registered.
-- 
-- Note that the same type may be registered as extension
-- for multiple extension points, under different names.
iOExtensionGetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtension
    -- ^ /@extension@/: a t'GI.Gio.Structs.IOExtension.IOExtension'
    -> m T.Text
    -- ^ __Returns:__ the name of /@extension@/.
iOExtensionGetName extension = liftIO $ do
    extension' <- unsafeManagedPtrGetPtr extension
    result <- g_io_extension_get_name extension'
    checkUnexpectedReturnNULL "iOExtensionGetName" result
    result' <- cstringToText result
    touchManagedPtr extension
    return result'

#if defined(ENABLE_OVERLOADING)
data IOExtensionGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod IOExtensionGetNameMethodInfo IOExtension signature where
    overloadedMethod = iOExtensionGetName

instance O.OverloadedMethodInfo IOExtensionGetNameMethodInfo IOExtension where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtension.iOExtensionGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtension.html#v:iOExtensionGetName"
        })


#endif

-- method IOExtension::get_priority
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtension" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtension" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_get_priority" g_io_extension_get_priority :: 
    Ptr IOExtension ->                      -- extension : TInterface (Name {namespace = "Gio", name = "IOExtension"})
    IO Int32

-- | Gets the priority with which /@extension@/ was registered.
iOExtensionGetPriority ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtension
    -- ^ /@extension@/: a t'GI.Gio.Structs.IOExtension.IOExtension'
    -> m Int32
    -- ^ __Returns:__ the priority of /@extension@/
iOExtensionGetPriority extension = liftIO $ do
    extension' <- unsafeManagedPtrGetPtr extension
    result <- g_io_extension_get_priority extension'
    touchManagedPtr extension
    return result

#if defined(ENABLE_OVERLOADING)
data IOExtensionGetPriorityMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod IOExtensionGetPriorityMethodInfo IOExtension signature where
    overloadedMethod = iOExtensionGetPriority

instance O.OverloadedMethodInfo IOExtensionGetPriorityMethodInfo IOExtension where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtension.iOExtensionGetPriority",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtension.html#v:iOExtensionGetPriority"
        })


#endif

-- method IOExtension::get_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "extension"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOExtension" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOExtension" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_extension_get_type" g_io_extension_get_type :: 
    Ptr IOExtension ->                      -- extension : TInterface (Name {namespace = "Gio", name = "IOExtension"})
    IO CGType

-- | Gets the type associated with /@extension@/.
iOExtensionGetType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    IOExtension
    -- ^ /@extension@/: a t'GI.Gio.Structs.IOExtension.IOExtension'
    -> m GType
    -- ^ __Returns:__ the type of /@extension@/
iOExtensionGetType extension = liftIO $ do
    extension' <- unsafeManagedPtrGetPtr extension
    result <- g_io_extension_get_type extension'
    let result' = GType result
    touchManagedPtr extension
    return result'

#if defined(ENABLE_OVERLOADING)
data IOExtensionGetTypeMethodInfo
instance (signature ~ (m GType), MonadIO m) => O.OverloadedMethod IOExtensionGetTypeMethodInfo IOExtension signature where
    overloadedMethod = iOExtensionGetType

instance O.OverloadedMethodInfo IOExtensionGetTypeMethodInfo IOExtension where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.IOExtension.iOExtensionGetType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-IOExtension.html#v:iOExtensionGetType"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveIOExtensionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIOExtensionMethod "getName" o = IOExtensionGetNameMethodInfo
    ResolveIOExtensionMethod "getPriority" o = IOExtensionGetPriorityMethodInfo
    ResolveIOExtensionMethod "getType" o = IOExtensionGetTypeMethodInfo
    ResolveIOExtensionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIOExtensionMethod t IOExtension, O.OverloadedMethod info IOExtension p) => OL.IsLabel t (IOExtension -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIOExtensionMethod t IOExtension, O.OverloadedMethod info IOExtension p, R.HasField t IOExtension p) => R.HasField t IOExtension p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIOExtensionMethod t IOExtension, O.OverloadedMethodInfo info IOExtension) => OL.IsLabel t (O.MethodProxy info IOExtension) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


