{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about a D-Bus property on a D-Bus interface.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusPropertyInfo
    ( 

-- * Exported types
    DBusPropertyInfo(..)                    ,
    newZeroDBusPropertyInfo                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gio.Structs.DBusPropertyInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusPropertyInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusPropertyInfoMethod           ,
#endif

-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusPropertyInfoRefMethodInfo           ,
#endif
    dBusPropertyInfoRef                     ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusPropertyInfoUnrefMethodInfo         ,
#endif
    dBusPropertyInfoUnref                   ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusPropertyInfoAnnotations        ,
#if defined(ENABLE_OVERLOADING)
    dBusPropertyInfo_annotations            ,
#endif
    getDBusPropertyInfoAnnotations          ,
    setDBusPropertyInfoAnnotations          ,


-- ** flags #attr:flags#
-- | Access control flags for the property.

#if defined(ENABLE_OVERLOADING)
    dBusPropertyInfo_flags                  ,
#endif
    getDBusPropertyInfoFlags                ,
    setDBusPropertyInfoFlags                ,


-- ** name #attr:name#
-- | The name of the D-Bus property, e.g. \"SupportedFilesystems\".

    clearDBusPropertyInfoName               ,
#if defined(ENABLE_OVERLOADING)
    dBusPropertyInfo_name                   ,
#endif
    getDBusPropertyInfoName                 ,
    setDBusPropertyInfoName                 ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusPropertyInfo_refCount               ,
#endif
    getDBusPropertyInfoRefCount             ,
    setDBusPropertyInfoRefCount             ,


-- ** signature #attr:signature#
-- | The D-Bus signature of the property (a single complete type).

    clearDBusPropertyInfoSignature          ,
#if defined(ENABLE_OVERLOADING)
    dBusPropertyInfo_signature              ,
#endif
    getDBusPropertyInfoSignature            ,
    setDBusPropertyInfoSignature            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo

#else
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo

#endif

-- | Memory-managed wrapper type.
newtype DBusPropertyInfo = DBusPropertyInfo (SP.ManagedPtr DBusPropertyInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusPropertyInfo where
    toManagedPtr (DBusPropertyInfo p) = p

foreign import ccall "g_dbus_property_info_get_type" c_g_dbus_property_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusPropertyInfo = '[]
instance O.HasParentTypes DBusPropertyInfo

instance B.Types.TypedObject DBusPropertyInfo where
    glibType = c_g_dbus_property_info_get_type

instance B.Types.GBoxed DBusPropertyInfo

-- | Convert 'DBusPropertyInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusPropertyInfo) where
    gvalueGType_ = c_g_dbus_property_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusPropertyInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusPropertyInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusPropertyInfo ptr
        else return P.Nothing
        
    

-- | Construct a `DBusPropertyInfo` struct initialized to zero.
newZeroDBusPropertyInfo :: MonadIO m => m DBusPropertyInfo
newZeroDBusPropertyInfo = liftIO $ callocBoxedBytes 40 >>= wrapBoxed DBusPropertyInfo

instance tag ~ 'AttrSet => Constructible DBusPropertyInfo tag where
    new _ attrs = do
        o <- newZeroDBusPropertyInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusPropertyInfo #refCount
-- @
getDBusPropertyInfoRefCount :: MonadIO m => DBusPropertyInfo -> m Int32
getDBusPropertyInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusPropertyInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusPropertyInfoRefCount :: MonadIO m => DBusPropertyInfo -> Int32 -> m ()
setDBusPropertyInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoRefCountFieldInfo
instance AttrInfo DBusPropertyInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusPropertyInfoRefCountFieldInfo = (~) DBusPropertyInfo
    type AttrAllowedOps DBusPropertyInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusPropertyInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusPropertyInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusPropertyInfoRefCountFieldInfo = Int32
    type AttrGetType DBusPropertyInfoRefCountFieldInfo = Int32
    type AttrLabel DBusPropertyInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusPropertyInfoRefCountFieldInfo = DBusPropertyInfo
    attrGet = getDBusPropertyInfoRefCount
    attrSet = setDBusPropertyInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#g:attr:refCount"
        })

dBusPropertyInfo_refCount :: AttrLabelProxy "refCount"
dBusPropertyInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusPropertyInfo #name
-- @
getDBusPropertyInfoName :: MonadIO m => DBusPropertyInfo -> m (Maybe T.Text)
getDBusPropertyInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusPropertyInfo [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusPropertyInfoName :: MonadIO m => DBusPropertyInfo -> CString -> m ()
setDBusPropertyInfoName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearDBusPropertyInfoName :: MonadIO m => DBusPropertyInfo -> m ()
clearDBusPropertyInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoNameFieldInfo
instance AttrInfo DBusPropertyInfoNameFieldInfo where
    type AttrBaseTypeConstraint DBusPropertyInfoNameFieldInfo = (~) DBusPropertyInfo
    type AttrAllowedOps DBusPropertyInfoNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusPropertyInfoNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusPropertyInfoNameFieldInfo = (~)CString
    type AttrTransferType DBusPropertyInfoNameFieldInfo = CString
    type AttrGetType DBusPropertyInfoNameFieldInfo = Maybe T.Text
    type AttrLabel DBusPropertyInfoNameFieldInfo = "name"
    type AttrOrigin DBusPropertyInfoNameFieldInfo = DBusPropertyInfo
    attrGet = getDBusPropertyInfoName
    attrSet = setDBusPropertyInfoName
    attrConstruct = undefined
    attrClear = clearDBusPropertyInfoName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#g:attr:name"
        })

dBusPropertyInfo_name :: AttrLabelProxy "name"
dBusPropertyInfo_name = AttrLabelProxy

#endif


-- | Get the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusPropertyInfo #signature
-- @
getDBusPropertyInfoSignature :: MonadIO m => DBusPropertyInfo -> m (Maybe T.Text)
getDBusPropertyInfoSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@signature@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusPropertyInfo [ #signature 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusPropertyInfoSignature :: MonadIO m => DBusPropertyInfo -> CString -> m ()
setDBusPropertyInfoSignature s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@signature@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #signature
-- @
clearDBusPropertyInfoSignature :: MonadIO m => DBusPropertyInfo -> m ()
clearDBusPropertyInfoSignature s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoSignatureFieldInfo
instance AttrInfo DBusPropertyInfoSignatureFieldInfo where
    type AttrBaseTypeConstraint DBusPropertyInfoSignatureFieldInfo = (~) DBusPropertyInfo
    type AttrAllowedOps DBusPropertyInfoSignatureFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusPropertyInfoSignatureFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusPropertyInfoSignatureFieldInfo = (~)CString
    type AttrTransferType DBusPropertyInfoSignatureFieldInfo = CString
    type AttrGetType DBusPropertyInfoSignatureFieldInfo = Maybe T.Text
    type AttrLabel DBusPropertyInfoSignatureFieldInfo = "signature"
    type AttrOrigin DBusPropertyInfoSignatureFieldInfo = DBusPropertyInfo
    attrGet = getDBusPropertyInfoSignature
    attrSet = setDBusPropertyInfoSignature
    attrConstruct = undefined
    attrClear = clearDBusPropertyInfoSignature
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.signature"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#g:attr:signature"
        })

dBusPropertyInfo_signature :: AttrLabelProxy "signature"
dBusPropertyInfo_signature = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusPropertyInfo #flags
-- @
getDBusPropertyInfoFlags :: MonadIO m => DBusPropertyInfo -> m [Gio.Flags.DBusPropertyInfoFlags]
getDBusPropertyInfoFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusPropertyInfo [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusPropertyInfoFlags :: MonadIO m => DBusPropertyInfo -> [Gio.Flags.DBusPropertyInfoFlags] -> m ()
setDBusPropertyInfoFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 24) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoFlagsFieldInfo
instance AttrInfo DBusPropertyInfoFlagsFieldInfo where
    type AttrBaseTypeConstraint DBusPropertyInfoFlagsFieldInfo = (~) DBusPropertyInfo
    type AttrAllowedOps DBusPropertyInfoFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusPropertyInfoFlagsFieldInfo = (~) [Gio.Flags.DBusPropertyInfoFlags]
    type AttrTransferTypeConstraint DBusPropertyInfoFlagsFieldInfo = (~)[Gio.Flags.DBusPropertyInfoFlags]
    type AttrTransferType DBusPropertyInfoFlagsFieldInfo = [Gio.Flags.DBusPropertyInfoFlags]
    type AttrGetType DBusPropertyInfoFlagsFieldInfo = [Gio.Flags.DBusPropertyInfoFlags]
    type AttrLabel DBusPropertyInfoFlagsFieldInfo = "flags"
    type AttrOrigin DBusPropertyInfoFlagsFieldInfo = DBusPropertyInfo
    attrGet = getDBusPropertyInfoFlags
    attrSet = setDBusPropertyInfoFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#g:attr:flags"
        })

dBusPropertyInfo_flags :: AttrLabelProxy "flags"
dBusPropertyInfo_flags = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusPropertyInfo #annotations
-- @
getDBusPropertyInfoAnnotations :: MonadIO m => DBusPropertyInfo -> m (Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo])
getDBusPropertyInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusAnnotationInfo.DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusPropertyInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusPropertyInfoAnnotations :: MonadIO m => DBusPropertyInfo -> Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo) -> m ()
setDBusPropertyInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusPropertyInfoAnnotations :: MonadIO m => DBusPropertyInfo -> m ()
clearDBusPropertyInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoAnnotationsFieldInfo
instance AttrInfo DBusPropertyInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusPropertyInfoAnnotationsFieldInfo = (~) DBusPropertyInfo
    type AttrAllowedOps DBusPropertyInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusPropertyInfoAnnotationsFieldInfo = (~) (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusPropertyInfoAnnotationsFieldInfo = (~)(Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferType DBusPropertyInfoAnnotationsFieldInfo = (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrGetType DBusPropertyInfoAnnotationsFieldInfo = Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo]
    type AttrLabel DBusPropertyInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusPropertyInfoAnnotationsFieldInfo = DBusPropertyInfo
    attrGet = getDBusPropertyInfoAnnotations
    attrSet = setDBusPropertyInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusPropertyInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#g:attr:annotations"
        })

dBusPropertyInfo_annotations :: AttrLabelProxy "annotations"
dBusPropertyInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusPropertyInfo
type instance O.AttributeList DBusPropertyInfo = DBusPropertyInfoAttributeList
type DBusPropertyInfoAttributeList = ('[ '("refCount", DBusPropertyInfoRefCountFieldInfo), '("name", DBusPropertyInfoNameFieldInfo), '("signature", DBusPropertyInfoSignatureFieldInfo), '("flags", DBusPropertyInfoFlagsFieldInfo), '("annotations", DBusPropertyInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusPropertyInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusPropertyInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusPropertyInfo"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusPropertyInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_property_info_ref" g_dbus_property_info_ref :: 
    Ptr DBusPropertyInfo ->                 -- info : TInterface (Name {namespace = "Gio", name = "DBusPropertyInfo"})
    IO (Ptr DBusPropertyInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusPropertyInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusPropertyInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusPropertyInfo.DBusPropertyInfo'
    -> m DBusPropertyInfo
    -- ^ __Returns:__ The same /@info@/.
dBusPropertyInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_property_info_ref info'
    checkUnexpectedReturnNULL "dBusPropertyInfoRef" result
    result' <- (wrapBoxed DBusPropertyInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoRefMethodInfo
instance (signature ~ (m DBusPropertyInfo), MonadIO m) => O.OverloadedMethod DBusPropertyInfoRefMethodInfo DBusPropertyInfo signature where
    overloadedMethod = dBusPropertyInfoRef

instance O.OverloadedMethodInfo DBusPropertyInfoRefMethodInfo DBusPropertyInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.dBusPropertyInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#v:dBusPropertyInfoRef"
        })


#endif

-- method DBusPropertyInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusPropertyInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusPropertyInfo."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_property_info_unref" g_dbus_property_info_unref :: 
    Ptr DBusPropertyInfo ->                 -- info : TInterface (Name {namespace = "Gio", name = "DBusPropertyInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusPropertyInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusPropertyInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusPropertyInfo.DBusPropertyInfo'.
    -> m ()
dBusPropertyInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_property_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusPropertyInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusPropertyInfoUnrefMethodInfo DBusPropertyInfo signature where
    overloadedMethod = dBusPropertyInfoUnref

instance O.OverloadedMethodInfo DBusPropertyInfoUnrefMethodInfo DBusPropertyInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusPropertyInfo.dBusPropertyInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusPropertyInfo.html#v:dBusPropertyInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusPropertyInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusPropertyInfoMethod "ref" o = DBusPropertyInfoRefMethodInfo
    ResolveDBusPropertyInfoMethod "unref" o = DBusPropertyInfoUnrefMethodInfo
    ResolveDBusPropertyInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusPropertyInfoMethod t DBusPropertyInfo, O.OverloadedMethod info DBusPropertyInfo p) => OL.IsLabel t (DBusPropertyInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusPropertyInfoMethod t DBusPropertyInfo, O.OverloadedMethod info DBusPropertyInfo p, R.HasField t DBusPropertyInfo p) => R.HasField t DBusPropertyInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusPropertyInfoMethod t DBusPropertyInfo, O.OverloadedMethodInfo info DBusPropertyInfo) => OL.IsLabel t (O.MethodProxy info DBusPropertyInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


