{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about a method on a D-Bus interface.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusMethodInfo
    ( 

-- * Exported types
    DBusMethodInfo(..)                      ,
    newZeroDBusMethodInfo                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gio.Structs.DBusMethodInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusMethodInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusMethodInfoMethod             ,
#endif

-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusMethodInfoRefMethodInfo             ,
#endif
    dBusMethodInfoRef                       ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusMethodInfoUnrefMethodInfo           ,
#endif
    dBusMethodInfoUnref                     ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusMethodInfoAnnotations          ,
#if defined(ENABLE_OVERLOADING)
    dBusMethodInfo_annotations              ,
#endif
    getDBusMethodInfoAnnotations            ,
    setDBusMethodInfoAnnotations            ,


-- ** inArgs #attr:inArgs#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusArgInfo.DBusArgInfo' structures or 'P.Nothing' if there are no in arguments.

    clearDBusMethodInfoInArgs               ,
#if defined(ENABLE_OVERLOADING)
    dBusMethodInfo_inArgs                   ,
#endif
    getDBusMethodInfoInArgs                 ,
    setDBusMethodInfoInArgs                 ,


-- ** name #attr:name#
-- | The name of the D-Bus method, e.g. /@requestName@/.

    clearDBusMethodInfoName                 ,
#if defined(ENABLE_OVERLOADING)
    dBusMethodInfo_name                     ,
#endif
    getDBusMethodInfoName                   ,
    setDBusMethodInfoName                   ,


-- ** outArgs #attr:outArgs#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusArgInfo.DBusArgInfo' structures or 'P.Nothing' if there are no out arguments.

    clearDBusMethodInfoOutArgs              ,
#if defined(ENABLE_OVERLOADING)
    dBusMethodInfo_outArgs                  ,
#endif
    getDBusMethodInfoOutArgs                ,
    setDBusMethodInfoOutArgs                ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusMethodInfo_refCount                 ,
#endif
    getDBusMethodInfoRefCount               ,
    setDBusMethodInfoRefCount               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo

#else
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo

#endif

-- | Memory-managed wrapper type.
newtype DBusMethodInfo = DBusMethodInfo (SP.ManagedPtr DBusMethodInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusMethodInfo where
    toManagedPtr (DBusMethodInfo p) = p

foreign import ccall "g_dbus_method_info_get_type" c_g_dbus_method_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusMethodInfo = '[]
instance O.HasParentTypes DBusMethodInfo

instance B.Types.TypedObject DBusMethodInfo where
    glibType = c_g_dbus_method_info_get_type

instance B.Types.GBoxed DBusMethodInfo

-- | Convert 'DBusMethodInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusMethodInfo) where
    gvalueGType_ = c_g_dbus_method_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusMethodInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusMethodInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusMethodInfo ptr
        else return P.Nothing
        
    

-- | Construct a `DBusMethodInfo` struct initialized to zero.
newZeroDBusMethodInfo :: MonadIO m => m DBusMethodInfo
newZeroDBusMethodInfo = liftIO $ callocBoxedBytes 40 >>= wrapBoxed DBusMethodInfo

instance tag ~ 'AttrSet => Constructible DBusMethodInfo tag where
    new _ attrs = do
        o <- newZeroDBusMethodInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusMethodInfo #refCount
-- @
getDBusMethodInfoRefCount :: MonadIO m => DBusMethodInfo -> m Int32
getDBusMethodInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusMethodInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusMethodInfoRefCount :: MonadIO m => DBusMethodInfo -> Int32 -> m ()
setDBusMethodInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoRefCountFieldInfo
instance AttrInfo DBusMethodInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusMethodInfoRefCountFieldInfo = (~) DBusMethodInfo
    type AttrAllowedOps DBusMethodInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusMethodInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusMethodInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusMethodInfoRefCountFieldInfo = Int32
    type AttrGetType DBusMethodInfoRefCountFieldInfo = Int32
    type AttrLabel DBusMethodInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusMethodInfoRefCountFieldInfo = DBusMethodInfo
    attrGet = getDBusMethodInfoRefCount
    attrSet = setDBusMethodInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#g:attr:refCount"
        })

dBusMethodInfo_refCount :: AttrLabelProxy "refCount"
dBusMethodInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusMethodInfo #name
-- @
getDBusMethodInfoName :: MonadIO m => DBusMethodInfo -> m (Maybe T.Text)
getDBusMethodInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusMethodInfo [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusMethodInfoName :: MonadIO m => DBusMethodInfo -> CString -> m ()
setDBusMethodInfoName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearDBusMethodInfoName :: MonadIO m => DBusMethodInfo -> m ()
clearDBusMethodInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoNameFieldInfo
instance AttrInfo DBusMethodInfoNameFieldInfo where
    type AttrBaseTypeConstraint DBusMethodInfoNameFieldInfo = (~) DBusMethodInfo
    type AttrAllowedOps DBusMethodInfoNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusMethodInfoNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusMethodInfoNameFieldInfo = (~)CString
    type AttrTransferType DBusMethodInfoNameFieldInfo = CString
    type AttrGetType DBusMethodInfoNameFieldInfo = Maybe T.Text
    type AttrLabel DBusMethodInfoNameFieldInfo = "name"
    type AttrOrigin DBusMethodInfoNameFieldInfo = DBusMethodInfo
    attrGet = getDBusMethodInfoName
    attrSet = setDBusMethodInfoName
    attrConstruct = undefined
    attrClear = clearDBusMethodInfoName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#g:attr:name"
        })

dBusMethodInfo_name :: AttrLabelProxy "name"
dBusMethodInfo_name = AttrLabelProxy

#endif


-- | Get the value of the “@in_args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusMethodInfo #inArgs
-- @
getDBusMethodInfoInArgs :: MonadIO m => DBusMethodInfo -> m (Maybe [Gio.DBusArgInfo.DBusArgInfo])
getDBusMethodInfoInArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusArgInfo.DBusArgInfo) val''
        return val'''
    return result

-- | Set the value of the “@in_args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusMethodInfo [ #inArgs 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusMethodInfoInArgs :: MonadIO m => DBusMethodInfo -> Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo) -> m ()
setDBusMethodInfoInArgs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

-- | Set the value of the “@in_args@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #inArgs
-- @
clearDBusMethodInfoInArgs :: MonadIO m => DBusMethodInfo -> m ()
clearDBusMethodInfoInArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoInArgsFieldInfo
instance AttrInfo DBusMethodInfoInArgsFieldInfo where
    type AttrBaseTypeConstraint DBusMethodInfoInArgsFieldInfo = (~) DBusMethodInfo
    type AttrAllowedOps DBusMethodInfoInArgsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusMethodInfoInArgsFieldInfo = (~) (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferTypeConstraint DBusMethodInfoInArgsFieldInfo = (~)(Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferType DBusMethodInfoInArgsFieldInfo = (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrGetType DBusMethodInfoInArgsFieldInfo = Maybe [Gio.DBusArgInfo.DBusArgInfo]
    type AttrLabel DBusMethodInfoInArgsFieldInfo = "in_args"
    type AttrOrigin DBusMethodInfoInArgsFieldInfo = DBusMethodInfo
    attrGet = getDBusMethodInfoInArgs
    attrSet = setDBusMethodInfoInArgs
    attrConstruct = undefined
    attrClear = clearDBusMethodInfoInArgs
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.inArgs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#g:attr:inArgs"
        })

dBusMethodInfo_inArgs :: AttrLabelProxy "inArgs"
dBusMethodInfo_inArgs = AttrLabelProxy

#endif


-- | Get the value of the “@out_args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusMethodInfo #outArgs
-- @
getDBusMethodInfoOutArgs :: MonadIO m => DBusMethodInfo -> m (Maybe [Gio.DBusArgInfo.DBusArgInfo])
getDBusMethodInfoOutArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusArgInfo.DBusArgInfo) val''
        return val'''
    return result

-- | Set the value of the “@out_args@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusMethodInfo [ #outArgs 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusMethodInfoOutArgs :: MonadIO m => DBusMethodInfo -> Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo) -> m ()
setDBusMethodInfoOutArgs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

-- | Set the value of the “@out_args@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #outArgs
-- @
clearDBusMethodInfoOutArgs :: MonadIO m => DBusMethodInfo -> m ()
clearDBusMethodInfoOutArgs s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoOutArgsFieldInfo
instance AttrInfo DBusMethodInfoOutArgsFieldInfo where
    type AttrBaseTypeConstraint DBusMethodInfoOutArgsFieldInfo = (~) DBusMethodInfo
    type AttrAllowedOps DBusMethodInfoOutArgsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusMethodInfoOutArgsFieldInfo = (~) (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferTypeConstraint DBusMethodInfoOutArgsFieldInfo = (~)(Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrTransferType DBusMethodInfoOutArgsFieldInfo = (Ptr (Ptr Gio.DBusArgInfo.DBusArgInfo))
    type AttrGetType DBusMethodInfoOutArgsFieldInfo = Maybe [Gio.DBusArgInfo.DBusArgInfo]
    type AttrLabel DBusMethodInfoOutArgsFieldInfo = "out_args"
    type AttrOrigin DBusMethodInfoOutArgsFieldInfo = DBusMethodInfo
    attrGet = getDBusMethodInfoOutArgs
    attrSet = setDBusMethodInfoOutArgs
    attrConstruct = undefined
    attrClear = clearDBusMethodInfoOutArgs
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.outArgs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#g:attr:outArgs"
        })

dBusMethodInfo_outArgs :: AttrLabelProxy "outArgs"
dBusMethodInfo_outArgs = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusMethodInfo #annotations
-- @
getDBusMethodInfoAnnotations :: MonadIO m => DBusMethodInfo -> m (Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo])
getDBusMethodInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed Gio.DBusAnnotationInfo.DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusMethodInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusMethodInfoAnnotations :: MonadIO m => DBusMethodInfo -> Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo) -> m ()
setDBusMethodInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusMethodInfoAnnotations :: MonadIO m => DBusMethodInfo -> m ()
clearDBusMethodInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoAnnotationsFieldInfo
instance AttrInfo DBusMethodInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusMethodInfoAnnotationsFieldInfo = (~) DBusMethodInfo
    type AttrAllowedOps DBusMethodInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusMethodInfoAnnotationsFieldInfo = (~) (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusMethodInfoAnnotationsFieldInfo = (~)(Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrTransferType DBusMethodInfoAnnotationsFieldInfo = (Ptr (Ptr Gio.DBusAnnotationInfo.DBusAnnotationInfo))
    type AttrGetType DBusMethodInfoAnnotationsFieldInfo = Maybe [Gio.DBusAnnotationInfo.DBusAnnotationInfo]
    type AttrLabel DBusMethodInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusMethodInfoAnnotationsFieldInfo = DBusMethodInfo
    attrGet = getDBusMethodInfoAnnotations
    attrSet = setDBusMethodInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusMethodInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#g:attr:annotations"
        })

dBusMethodInfo_annotations :: AttrLabelProxy "annotations"
dBusMethodInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusMethodInfo
type instance O.AttributeList DBusMethodInfo = DBusMethodInfoAttributeList
type DBusMethodInfoAttributeList = ('[ '("refCount", DBusMethodInfoRefCountFieldInfo), '("name", DBusMethodInfoNameFieldInfo), '("inArgs", DBusMethodInfoInArgsFieldInfo), '("outArgs", DBusMethodInfoOutArgsFieldInfo), '("annotations", DBusMethodInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusMethodInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusMethodInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusMethodInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusMethodInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_method_info_ref" g_dbus_method_info_ref :: 
    Ptr DBusMethodInfo ->                   -- info : TInterface (Name {namespace = "Gio", name = "DBusMethodInfo"})
    IO (Ptr DBusMethodInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusMethodInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusMethodInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusMethodInfo.DBusMethodInfo'
    -> m DBusMethodInfo
    -- ^ __Returns:__ The same /@info@/.
dBusMethodInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_method_info_ref info'
    checkUnexpectedReturnNULL "dBusMethodInfoRef" result
    result' <- (wrapBoxed DBusMethodInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoRefMethodInfo
instance (signature ~ (m DBusMethodInfo), MonadIO m) => O.OverloadedMethod DBusMethodInfoRefMethodInfo DBusMethodInfo signature where
    overloadedMethod = dBusMethodInfoRef

instance O.OverloadedMethodInfo DBusMethodInfoRefMethodInfo DBusMethodInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.dBusMethodInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#v:dBusMethodInfoRef"
        })


#endif

-- method DBusMethodInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusMethodInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusMethodInfo."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_method_info_unref" g_dbus_method_info_unref :: 
    Ptr DBusMethodInfo ->                   -- info : TInterface (Name {namespace = "Gio", name = "DBusMethodInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusMethodInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusMethodInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusMethodInfo.DBusMethodInfo'.
    -> m ()
dBusMethodInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_method_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusMethodInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusMethodInfoUnrefMethodInfo DBusMethodInfo signature where
    overloadedMethod = dBusMethodInfoUnref

instance O.OverloadedMethodInfo DBusMethodInfoUnrefMethodInfo DBusMethodInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusMethodInfo.dBusMethodInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusMethodInfo.html#v:dBusMethodInfoUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusMethodInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusMethodInfoMethod "ref" o = DBusMethodInfoRefMethodInfo
    ResolveDBusMethodInfoMethod "unref" o = DBusMethodInfoUnrefMethodInfo
    ResolveDBusMethodInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusMethodInfoMethod t DBusMethodInfo, O.OverloadedMethod info DBusMethodInfo p) => OL.IsLabel t (DBusMethodInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusMethodInfoMethod t DBusMethodInfo, O.OverloadedMethod info DBusMethodInfo p, R.HasField t DBusMethodInfo p) => R.HasField t DBusMethodInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusMethodInfoMethod t DBusMethodInfo, O.OverloadedMethodInfo info DBusMethodInfo) => OL.IsLabel t (O.MethodProxy info DBusMethodInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


