{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about an annotation.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.DBusAnnotationInfo
    ( 

-- * Exported types
    DBusAnnotationInfo(..)                  ,
    newZeroDBusAnnotationInfo               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gio.Structs.DBusAnnotationInfo#g:method:ref"), [unref]("GI.Gio.Structs.DBusAnnotationInfo#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveDBusAnnotationInfoMethod         ,
#endif

-- ** lookup #method:lookup#

    dBusAnnotationInfoLookup                ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    DBusAnnotationInfoRefMethodInfo         ,
#endif
    dBusAnnotationInfoRef                   ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    DBusAnnotationInfoUnrefMethodInfo       ,
#endif
    dBusAnnotationInfoUnref                 ,




 -- * Properties


-- ** annotations #attr:annotations#
-- | A pointer to a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo' structures or 'P.Nothing' if there are no annotations.

    clearDBusAnnotationInfoAnnotations      ,
#if defined(ENABLE_OVERLOADING)
    dBusAnnotationInfo_annotations          ,
#endif
    getDBusAnnotationInfoAnnotations        ,
    setDBusAnnotationInfoAnnotations        ,


-- ** key #attr:key#
-- | The name of the annotation, e.g. \"org.freedesktop.DBus.Deprecated\".

    clearDBusAnnotationInfoKey              ,
#if defined(ENABLE_OVERLOADING)
    dBusAnnotationInfo_key                  ,
#endif
    getDBusAnnotationInfoKey                ,
    setDBusAnnotationInfoKey                ,


-- ** refCount #attr:refCount#
-- | The reference count or -1 if statically allocated.

#if defined(ENABLE_OVERLOADING)
    dBusAnnotationInfo_refCount             ,
#endif
    getDBusAnnotationInfoRefCount           ,
    setDBusAnnotationInfoRefCount           ,


-- ** value #attr:value#
-- | The value of the annotation.

    clearDBusAnnotationInfoValue            ,
#if defined(ENABLE_OVERLOADING)
    dBusAnnotationInfo_value                ,
#endif
    getDBusAnnotationInfoValue              ,
    setDBusAnnotationInfoValue              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype DBusAnnotationInfo = DBusAnnotationInfo (SP.ManagedPtr DBusAnnotationInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusAnnotationInfo where
    toManagedPtr (DBusAnnotationInfo p) = p

foreign import ccall "g_dbus_annotation_info_get_type" c_g_dbus_annotation_info_get_type :: 
    IO GType

type instance O.ParentTypes DBusAnnotationInfo = '[]
instance O.HasParentTypes DBusAnnotationInfo

instance B.Types.TypedObject DBusAnnotationInfo where
    glibType = c_g_dbus_annotation_info_get_type

instance B.Types.GBoxed DBusAnnotationInfo

-- | Convert 'DBusAnnotationInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusAnnotationInfo) where
    gvalueGType_ = c_g_dbus_annotation_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr DBusAnnotationInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr DBusAnnotationInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed DBusAnnotationInfo ptr
        else return P.Nothing
        
    

-- | Construct a `DBusAnnotationInfo` struct initialized to zero.
newZeroDBusAnnotationInfo :: MonadIO m => m DBusAnnotationInfo
newZeroDBusAnnotationInfo = liftIO $ callocBoxedBytes 32 >>= wrapBoxed DBusAnnotationInfo

instance tag ~ 'AttrSet => Constructible DBusAnnotationInfo tag where
    new _ attrs = do
        o <- newZeroDBusAnnotationInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusAnnotationInfo #refCount
-- @
getDBusAnnotationInfoRefCount :: MonadIO m => DBusAnnotationInfo -> m Int32
getDBusAnnotationInfoRefCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@ref_count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusAnnotationInfo [ #refCount 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusAnnotationInfoRefCount :: MonadIO m => DBusAnnotationInfo -> Int32 -> m ()
setDBusAnnotationInfoRefCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoRefCountFieldInfo
instance AttrInfo DBusAnnotationInfoRefCountFieldInfo where
    type AttrBaseTypeConstraint DBusAnnotationInfoRefCountFieldInfo = (~) DBusAnnotationInfo
    type AttrAllowedOps DBusAnnotationInfoRefCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DBusAnnotationInfoRefCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint DBusAnnotationInfoRefCountFieldInfo = (~)Int32
    type AttrTransferType DBusAnnotationInfoRefCountFieldInfo = Int32
    type AttrGetType DBusAnnotationInfoRefCountFieldInfo = Int32
    type AttrLabel DBusAnnotationInfoRefCountFieldInfo = "ref_count"
    type AttrOrigin DBusAnnotationInfoRefCountFieldInfo = DBusAnnotationInfo
    attrGet = getDBusAnnotationInfoRefCount
    attrSet = setDBusAnnotationInfoRefCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.refCount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#g:attr:refCount"
        })

dBusAnnotationInfo_refCount :: AttrLabelProxy "refCount"
dBusAnnotationInfo_refCount = AttrLabelProxy

#endif


-- | Get the value of the “@key@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusAnnotationInfo #key
-- @
getDBusAnnotationInfoKey :: MonadIO m => DBusAnnotationInfo -> m (Maybe T.Text)
getDBusAnnotationInfoKey s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@key@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusAnnotationInfo [ #key 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusAnnotationInfoKey :: MonadIO m => DBusAnnotationInfo -> CString -> m ()
setDBusAnnotationInfoKey s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@key@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #key
-- @
clearDBusAnnotationInfoKey :: MonadIO m => DBusAnnotationInfo -> m ()
clearDBusAnnotationInfoKey s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoKeyFieldInfo
instance AttrInfo DBusAnnotationInfoKeyFieldInfo where
    type AttrBaseTypeConstraint DBusAnnotationInfoKeyFieldInfo = (~) DBusAnnotationInfo
    type AttrAllowedOps DBusAnnotationInfoKeyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusAnnotationInfoKeyFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusAnnotationInfoKeyFieldInfo = (~)CString
    type AttrTransferType DBusAnnotationInfoKeyFieldInfo = CString
    type AttrGetType DBusAnnotationInfoKeyFieldInfo = Maybe T.Text
    type AttrLabel DBusAnnotationInfoKeyFieldInfo = "key"
    type AttrOrigin DBusAnnotationInfoKeyFieldInfo = DBusAnnotationInfo
    attrGet = getDBusAnnotationInfoKey
    attrSet = setDBusAnnotationInfoKey
    attrConstruct = undefined
    attrClear = clearDBusAnnotationInfoKey
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.key"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#g:attr:key"
        })

dBusAnnotationInfo_key :: AttrLabelProxy "key"
dBusAnnotationInfo_key = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusAnnotationInfo #value
-- @
getDBusAnnotationInfoValue :: MonadIO m => DBusAnnotationInfo -> m (Maybe T.Text)
getDBusAnnotationInfoValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusAnnotationInfo [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusAnnotationInfoValue :: MonadIO m => DBusAnnotationInfo -> CString -> m ()
setDBusAnnotationInfoValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearDBusAnnotationInfoValue :: MonadIO m => DBusAnnotationInfo -> m ()
clearDBusAnnotationInfoValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoValueFieldInfo
instance AttrInfo DBusAnnotationInfoValueFieldInfo where
    type AttrBaseTypeConstraint DBusAnnotationInfoValueFieldInfo = (~) DBusAnnotationInfo
    type AttrAllowedOps DBusAnnotationInfoValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusAnnotationInfoValueFieldInfo = (~) CString
    type AttrTransferTypeConstraint DBusAnnotationInfoValueFieldInfo = (~)CString
    type AttrTransferType DBusAnnotationInfoValueFieldInfo = CString
    type AttrGetType DBusAnnotationInfoValueFieldInfo = Maybe T.Text
    type AttrLabel DBusAnnotationInfoValueFieldInfo = "value"
    type AttrOrigin DBusAnnotationInfoValueFieldInfo = DBusAnnotationInfo
    attrGet = getDBusAnnotationInfoValue
    attrSet = setDBusAnnotationInfoValue
    attrConstruct = undefined
    attrClear = clearDBusAnnotationInfoValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#g:attr:value"
        })

dBusAnnotationInfo_value :: AttrLabelProxy "value"
dBusAnnotationInfo_value = AttrLabelProxy

#endif


-- | Get the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusAnnotationInfo #annotations
-- @
getDBusAnnotationInfoAnnotations :: MonadIO m => DBusAnnotationInfo -> m (Maybe [DBusAnnotationInfo])
getDBusAnnotationInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr (Ptr DBusAnnotationInfo))
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- unpackZeroTerminatedPtrArray val'
        val''' <- mapM (newBoxed DBusAnnotationInfo) val''
        return val'''
    return result

-- | Set the value of the “@annotations@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusAnnotationInfo [ #annotations 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusAnnotationInfoAnnotations :: MonadIO m => DBusAnnotationInfo -> Ptr (Ptr DBusAnnotationInfo) -> m ()
setDBusAnnotationInfoAnnotations s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr (Ptr DBusAnnotationInfo))

-- | Set the value of the “@annotations@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #annotations
-- @
clearDBusAnnotationInfoAnnotations :: MonadIO m => DBusAnnotationInfo -> m ()
clearDBusAnnotationInfoAnnotations s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr (Ptr DBusAnnotationInfo))

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoAnnotationsFieldInfo
instance AttrInfo DBusAnnotationInfoAnnotationsFieldInfo where
    type AttrBaseTypeConstraint DBusAnnotationInfoAnnotationsFieldInfo = (~) DBusAnnotationInfo
    type AttrAllowedOps DBusAnnotationInfoAnnotationsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DBusAnnotationInfoAnnotationsFieldInfo = (~) (Ptr (Ptr DBusAnnotationInfo))
    type AttrTransferTypeConstraint DBusAnnotationInfoAnnotationsFieldInfo = (~)(Ptr (Ptr DBusAnnotationInfo))
    type AttrTransferType DBusAnnotationInfoAnnotationsFieldInfo = (Ptr (Ptr DBusAnnotationInfo))
    type AttrGetType DBusAnnotationInfoAnnotationsFieldInfo = Maybe [DBusAnnotationInfo]
    type AttrLabel DBusAnnotationInfoAnnotationsFieldInfo = "annotations"
    type AttrOrigin DBusAnnotationInfoAnnotationsFieldInfo = DBusAnnotationInfo
    attrGet = getDBusAnnotationInfoAnnotations
    attrSet = setDBusAnnotationInfoAnnotations
    attrConstruct = undefined
    attrClear = clearDBusAnnotationInfoAnnotations
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.annotations"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#g:attr:annotations"
        })

dBusAnnotationInfo_annotations :: AttrLabelProxy "annotations"
dBusAnnotationInfo_annotations = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusAnnotationInfo
type instance O.AttributeList DBusAnnotationInfo = DBusAnnotationInfoAttributeList
type DBusAnnotationInfoAttributeList = ('[ '("refCount", DBusAnnotationInfoRefCountFieldInfo), '("key", DBusAnnotationInfoKeyFieldInfo), '("value", DBusAnnotationInfoValueFieldInfo), '("annotations", DBusAnnotationInfoAnnotationsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method DBusAnnotationInfo::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusAnnotationInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusNodeInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusAnnotationInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_annotation_info_ref" g_dbus_annotation_info_ref :: 
    Ptr DBusAnnotationInfo ->               -- info : TInterface (Name {namespace = "Gio", name = "DBusAnnotationInfo"})
    IO (Ptr DBusAnnotationInfo)

-- | If /@info@/ is statically allocated does nothing. Otherwise increases
-- the reference count.
-- 
-- /Since: 2.26/
dBusAnnotationInfoRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusAnnotationInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusNodeInfo.DBusNodeInfo'
    -> m DBusAnnotationInfo
    -- ^ __Returns:__ The same /@info@/.
dBusAnnotationInfoRef info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    result <- g_dbus_annotation_info_ref info'
    checkUnexpectedReturnNULL "dBusAnnotationInfoRef" result
    result' <- (wrapBoxed DBusAnnotationInfo) result
    touchManagedPtr info
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoRefMethodInfo
instance (signature ~ (m DBusAnnotationInfo), MonadIO m) => O.OverloadedMethod DBusAnnotationInfoRefMethodInfo DBusAnnotationInfo signature where
    overloadedMethod = dBusAnnotationInfoRef

instance O.OverloadedMethodInfo DBusAnnotationInfoRefMethodInfo DBusAnnotationInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.dBusAnnotationInfoRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#v:dBusAnnotationInfoRef"
        })


#endif

-- method DBusAnnotationInfo::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusAnnotationInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusAnnotationInfo."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_annotation_info_unref" g_dbus_annotation_info_unref :: 
    Ptr DBusAnnotationInfo ->               -- info : TInterface (Name {namespace = "Gio", name = "DBusAnnotationInfo"})
    IO ()

-- | If /@info@/ is statically allocated, does nothing. Otherwise decreases
-- the reference count of /@info@/. When its reference count drops to 0,
-- the memory used is freed.
-- 
-- /Since: 2.26/
dBusAnnotationInfoUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    DBusAnnotationInfo
    -- ^ /@info@/: A t'GI.Gio.Structs.DBusAnnotationInfo.DBusAnnotationInfo'.
    -> m ()
dBusAnnotationInfoUnref info = liftIO $ do
    info' <- unsafeManagedPtrGetPtr info
    g_dbus_annotation_info_unref info'
    touchManagedPtr info
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusAnnotationInfoUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod DBusAnnotationInfoUnrefMethodInfo DBusAnnotationInfo signature where
    overloadedMethod = dBusAnnotationInfoUnref

instance O.OverloadedMethodInfo DBusAnnotationInfoUnrefMethodInfo DBusAnnotationInfo where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.DBusAnnotationInfo.dBusAnnotationInfoUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Structs-DBusAnnotationInfo.html#v:dBusAnnotationInfoUnref"
        })


#endif

-- method DBusAnnotationInfo::lookup
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "annotations"
--           , argType =
--               TCArray
--                 True
--                 (-1)
--                 (-1)
--                 (TInterface
--                    Name { namespace = "Gio" , name = "DBusAnnotationInfo" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A %NULL-terminated array of annotations or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the annotation to look up."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_annotation_info_lookup" g_dbus_annotation_info_lookup :: 
    Ptr (Ptr DBusAnnotationInfo) ->         -- annotations : TCArray True (-1) (-1) (TInterface (Name {namespace = "Gio", name = "DBusAnnotationInfo"}))
    CString ->                              -- name : TBasicType TUTF8
    IO CString

-- | Looks up the value of an annotation.
-- 
-- The cost of this function is O(n) in number of annotations.
-- 
-- /Since: 2.26/
dBusAnnotationInfoLookup ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([DBusAnnotationInfo])
    -- ^ /@annotations@/: A 'P.Nothing'-terminated array of annotations or 'P.Nothing'.
    -> T.Text
    -- ^ /@name@/: The name of the annotation to look up.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The value or 'P.Nothing' if not found. Do not free, it is owned by /@annotations@/.
dBusAnnotationInfoLookup annotations name = liftIO $ do
    maybeAnnotations <- case annotations of
        Nothing -> return FP.nullPtr
        Just jAnnotations -> do
            jAnnotations' <- mapM unsafeManagedPtrGetPtr jAnnotations
            jAnnotations'' <- packZeroTerminatedPtrArray jAnnotations'
            return jAnnotations''
    name' <- textToCString name
    result <- g_dbus_annotation_info_lookup maybeAnnotations name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    whenJust annotations (mapM_ touchManagedPtr)
    freeMem maybeAnnotations
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusAnnotationInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusAnnotationInfoMethod "ref" o = DBusAnnotationInfoRefMethodInfo
    ResolveDBusAnnotationInfoMethod "unref" o = DBusAnnotationInfoUnrefMethodInfo
    ResolveDBusAnnotationInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusAnnotationInfoMethod t DBusAnnotationInfo, O.OverloadedMethod info DBusAnnotationInfo p) => OL.IsLabel t (DBusAnnotationInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusAnnotationInfoMethod t DBusAnnotationInfo, O.OverloadedMethod info DBusAnnotationInfo p, R.HasField t DBusAnnotationInfo p) => R.HasField t DBusAnnotationInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusAnnotationInfoMethod t DBusAnnotationInfo, O.OverloadedMethodInfo info DBusAnnotationInfo) => OL.IsLabel t (O.MethodProxy info DBusAnnotationInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


