{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GZlibCompressor@ is an implementation of t'GI.Gio.Interfaces.Converter.Converter' that
-- compresses data using zlib.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ZlibCompressor
    ( 

-- * Exported types
    ZlibCompressor(..)                      ,
    IsZlibCompressor                        ,
    toZlibCompressor                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [convert]("GI.Gio.Interfaces.Converter#g:method:convert"), [convertBytes]("GI.Gio.Interfaces.Converter#g:method:convertBytes"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gio.Interfaces.Converter#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFileInfo]("GI.Gio.Objects.ZlibCompressor#g:method:getFileInfo"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFileInfo]("GI.Gio.Objects.ZlibCompressor#g:method:setFileInfo"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveZlibCompressorMethod             ,
#endif

-- ** getFileInfo #method:getFileInfo#

#if defined(ENABLE_OVERLOADING)
    ZlibCompressorGetFileInfoMethodInfo     ,
#endif
    zlibCompressorGetFileInfo               ,


-- ** new #method:new#

    zlibCompressorNew                       ,


-- ** setFileInfo #method:setFileInfo#

#if defined(ENABLE_OVERLOADING)
    ZlibCompressorSetFileInfoMethodInfo     ,
#endif
    zlibCompressorSetFileInfo               ,




 -- * Properties


-- ** fileInfo #attr:fileInfo#
-- | If set to a non-'P.Nothing' t'GI.Gio.Objects.FileInfo.FileInfo' object, and [ZlibCompressor:format]("GI.Gio.Objects.ZlibCompressor#g:attr:format") is
-- 'GI.Gio.Enums.ZlibCompressorFormatGzip', the compressor will write the file name
-- and modification time from the file info to the GZIP header.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ZlibCompressorFileInfoPropertyInfo      ,
#endif
    clearZlibCompressorFileInfo             ,
    constructZlibCompressorFileInfo         ,
    getZlibCompressorFileInfo               ,
    setZlibCompressorFileInfo               ,
#if defined(ENABLE_OVERLOADING)
    zlibCompressorFileInfo                  ,
#endif


-- ** format #attr:format#
-- | The format of the compressed data.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    ZlibCompressorFormatPropertyInfo        ,
#endif
    constructZlibCompressorFormat           ,
    getZlibCompressorFormat                 ,
#if defined(ENABLE_OVERLOADING)
    zlibCompressorFormat                    ,
#endif


-- ** level #attr:level#
-- | The level of compression from @0@ (no compression) to @9@ (most
-- compression). @-1@ for the default level.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    ZlibCompressorLevelPropertyInfo         ,
#endif
    constructZlibCompressorLevel            ,
    getZlibCompressorLevel                  ,
#if defined(ENABLE_OVERLOADING)
    zlibCompressorLevel                     ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo

#endif

-- | Memory-managed wrapper type.
newtype ZlibCompressor = ZlibCompressor (SP.ManagedPtr ZlibCompressor)
    deriving (Eq)

instance SP.ManagedPtrNewtype ZlibCompressor where
    toManagedPtr (ZlibCompressor p) = p

foreign import ccall "g_zlib_compressor_get_type"
    c_g_zlib_compressor_get_type :: IO B.Types.GType

instance B.Types.TypedObject ZlibCompressor where
    glibType = c_g_zlib_compressor_get_type

instance B.Types.GObject ZlibCompressor

-- | Type class for types which can be safely cast to `ZlibCompressor`, for instance with `toZlibCompressor`.
class (SP.GObject o, O.IsDescendantOf ZlibCompressor o) => IsZlibCompressor o
instance (SP.GObject o, O.IsDescendantOf ZlibCompressor o) => IsZlibCompressor o

instance O.HasParentTypes ZlibCompressor
type instance O.ParentTypes ZlibCompressor = '[GObject.Object.Object, Gio.Converter.Converter]

-- | Cast to `ZlibCompressor`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toZlibCompressor :: (MIO.MonadIO m, IsZlibCompressor o) => o -> m ZlibCompressor
toZlibCompressor = MIO.liftIO . B.ManagedPtr.unsafeCastTo ZlibCompressor

-- | Convert 'ZlibCompressor' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ZlibCompressor) where
    gvalueGType_ = c_g_zlib_compressor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ZlibCompressor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ZlibCompressor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ZlibCompressor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveZlibCompressorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveZlibCompressorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveZlibCompressorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveZlibCompressorMethod "convert" o = Gio.Converter.ConverterConvertMethodInfo
    ResolveZlibCompressorMethod "convertBytes" o = Gio.Converter.ConverterConvertBytesMethodInfo
    ResolveZlibCompressorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveZlibCompressorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveZlibCompressorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveZlibCompressorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveZlibCompressorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveZlibCompressorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveZlibCompressorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveZlibCompressorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveZlibCompressorMethod "reset" o = Gio.Converter.ConverterResetMethodInfo
    ResolveZlibCompressorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveZlibCompressorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveZlibCompressorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveZlibCompressorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveZlibCompressorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveZlibCompressorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveZlibCompressorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveZlibCompressorMethod "getFileInfo" o = ZlibCompressorGetFileInfoMethodInfo
    ResolveZlibCompressorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveZlibCompressorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveZlibCompressorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveZlibCompressorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveZlibCompressorMethod "setFileInfo" o = ZlibCompressorSetFileInfoMethodInfo
    ResolveZlibCompressorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveZlibCompressorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveZlibCompressorMethod t ZlibCompressor, O.OverloadedMethod info ZlibCompressor p) => OL.IsLabel t (ZlibCompressor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveZlibCompressorMethod t ZlibCompressor, O.OverloadedMethod info ZlibCompressor p, R.HasField t ZlibCompressor p) => R.HasField t ZlibCompressor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveZlibCompressorMethod t ZlibCompressor, O.OverloadedMethodInfo info ZlibCompressor) => OL.IsLabel t (O.MethodProxy info ZlibCompressor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "file-info"
   -- Type: TInterface (Name {namespace = "Gio", name = "FileInfo"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@file-info@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' zlibCompressor #fileInfo
-- @
getZlibCompressorFileInfo :: (MonadIO m, IsZlibCompressor o) => o -> m (Maybe Gio.FileInfo.FileInfo)
getZlibCompressorFileInfo obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file-info" Gio.FileInfo.FileInfo

-- | Set the value of the “@file-info@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' zlibCompressor [ #fileInfo 'Data.GI.Base.Attributes.:=' value ]
-- @
setZlibCompressorFileInfo :: (MonadIO m, IsZlibCompressor o, Gio.FileInfo.IsFileInfo a) => o -> a -> m ()
setZlibCompressorFileInfo obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "file-info" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@file-info@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructZlibCompressorFileInfo :: (IsZlibCompressor o, MIO.MonadIO m, Gio.FileInfo.IsFileInfo a) => a -> m (GValueConstruct o)
constructZlibCompressorFileInfo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file-info" (P.Just val)

-- | Set the value of the “@file-info@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #fileInfo
-- @
clearZlibCompressorFileInfo :: (MonadIO m, IsZlibCompressor o) => o -> m ()
clearZlibCompressorFileInfo obj = liftIO $ B.Properties.setObjectPropertyObject obj "file-info" (Nothing :: Maybe Gio.FileInfo.FileInfo)

#if defined(ENABLE_OVERLOADING)
data ZlibCompressorFileInfoPropertyInfo
instance AttrInfo ZlibCompressorFileInfoPropertyInfo where
    type AttrAllowedOps ZlibCompressorFileInfoPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ZlibCompressorFileInfoPropertyInfo = IsZlibCompressor
    type AttrSetTypeConstraint ZlibCompressorFileInfoPropertyInfo = Gio.FileInfo.IsFileInfo
    type AttrTransferTypeConstraint ZlibCompressorFileInfoPropertyInfo = Gio.FileInfo.IsFileInfo
    type AttrTransferType ZlibCompressorFileInfoPropertyInfo = Gio.FileInfo.FileInfo
    type AttrGetType ZlibCompressorFileInfoPropertyInfo = (Maybe Gio.FileInfo.FileInfo)
    type AttrLabel ZlibCompressorFileInfoPropertyInfo = "file-info"
    type AttrOrigin ZlibCompressorFileInfoPropertyInfo = ZlibCompressor
    attrGet = getZlibCompressorFileInfo
    attrSet = setZlibCompressorFileInfo
    attrTransfer _ v = do
        unsafeCastTo Gio.FileInfo.FileInfo v
    attrConstruct = constructZlibCompressorFileInfo
    attrClear = clearZlibCompressorFileInfo
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibCompressor.fileInfo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ZlibCompressor.html#g:attr:fileInfo"
        })
#endif

-- VVV Prop "format"
   -- Type: TInterface (Name {namespace = "Gio", name = "ZlibCompressorFormat"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@format@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' zlibCompressor #format
-- @
getZlibCompressorFormat :: (MonadIO m, IsZlibCompressor o) => o -> m Gio.Enums.ZlibCompressorFormat
getZlibCompressorFormat obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "format"

-- | Construct a `GValueConstruct` with valid value for the “@format@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructZlibCompressorFormat :: (IsZlibCompressor o, MIO.MonadIO m) => Gio.Enums.ZlibCompressorFormat -> m (GValueConstruct o)
constructZlibCompressorFormat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "format" val

#if defined(ENABLE_OVERLOADING)
data ZlibCompressorFormatPropertyInfo
instance AttrInfo ZlibCompressorFormatPropertyInfo where
    type AttrAllowedOps ZlibCompressorFormatPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ZlibCompressorFormatPropertyInfo = IsZlibCompressor
    type AttrSetTypeConstraint ZlibCompressorFormatPropertyInfo = (~) Gio.Enums.ZlibCompressorFormat
    type AttrTransferTypeConstraint ZlibCompressorFormatPropertyInfo = (~) Gio.Enums.ZlibCompressorFormat
    type AttrTransferType ZlibCompressorFormatPropertyInfo = Gio.Enums.ZlibCompressorFormat
    type AttrGetType ZlibCompressorFormatPropertyInfo = Gio.Enums.ZlibCompressorFormat
    type AttrLabel ZlibCompressorFormatPropertyInfo = "format"
    type AttrOrigin ZlibCompressorFormatPropertyInfo = ZlibCompressor
    attrGet = getZlibCompressorFormat
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructZlibCompressorFormat
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibCompressor.format"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ZlibCompressor.html#g:attr:format"
        })
#endif

-- VVV Prop "level"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@level@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' zlibCompressor #level
-- @
getZlibCompressorLevel :: (MonadIO m, IsZlibCompressor o) => o -> m Int32
getZlibCompressorLevel obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "level"

-- | Construct a `GValueConstruct` with valid value for the “@level@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructZlibCompressorLevel :: (IsZlibCompressor o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructZlibCompressorLevel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "level" val

#if defined(ENABLE_OVERLOADING)
data ZlibCompressorLevelPropertyInfo
instance AttrInfo ZlibCompressorLevelPropertyInfo where
    type AttrAllowedOps ZlibCompressorLevelPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ZlibCompressorLevelPropertyInfo = IsZlibCompressor
    type AttrSetTypeConstraint ZlibCompressorLevelPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ZlibCompressorLevelPropertyInfo = (~) Int32
    type AttrTransferType ZlibCompressorLevelPropertyInfo = Int32
    type AttrGetType ZlibCompressorLevelPropertyInfo = Int32
    type AttrLabel ZlibCompressorLevelPropertyInfo = "level"
    type AttrOrigin ZlibCompressorLevelPropertyInfo = ZlibCompressor
    attrGet = getZlibCompressorLevel
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructZlibCompressorLevel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibCompressor.level"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ZlibCompressor.html#g:attr:level"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ZlibCompressor
type instance O.AttributeList ZlibCompressor = ZlibCompressorAttributeList
type ZlibCompressorAttributeList = ('[ '("fileInfo", ZlibCompressorFileInfoPropertyInfo), '("format", ZlibCompressorFormatPropertyInfo), '("level", ZlibCompressorLevelPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
zlibCompressorFileInfo :: AttrLabelProxy "fileInfo"
zlibCompressorFileInfo = AttrLabelProxy

zlibCompressorFormat :: AttrLabelProxy "format"
zlibCompressorFormat = AttrLabelProxy

zlibCompressorLevel :: AttrLabelProxy "level"
zlibCompressorLevel = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ZlibCompressor = ZlibCompressorSignalList
type ZlibCompressorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ZlibCompressor::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "format"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ZlibCompressorFormat" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The format to use for the compressed data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "level"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "compression level (0-9), -1 for default"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ZlibCompressor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_zlib_compressor_new" g_zlib_compressor_new :: 
    CUInt ->                                -- format : TInterface (Name {namespace = "Gio", name = "ZlibCompressorFormat"})
    Int32 ->                                -- level : TBasicType TInt
    IO (Ptr ZlibCompressor)

-- | Creates a new t'GI.Gio.Objects.ZlibCompressor.ZlibCompressor'.
-- 
-- /Since: 2.24/
zlibCompressorNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.ZlibCompressorFormat
    -- ^ /@format@/: The format to use for the compressed data
    -> Int32
    -- ^ /@level@/: compression level (0-9), -1 for default
    -> m ZlibCompressor
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ZlibCompressor.ZlibCompressor'
zlibCompressorNew format level = liftIO $ do
    let format' = (fromIntegral . fromEnum) format
    result <- g_zlib_compressor_new format' level
    checkUnexpectedReturnNULL "zlibCompressorNew" result
    result' <- (wrapObject ZlibCompressor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ZlibCompressor::get_file_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "compressor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ZlibCompressor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GZlibCompressor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_zlib_compressor_get_file_info" g_zlib_compressor_get_file_info :: 
    Ptr ZlibCompressor ->                   -- compressor : TInterface (Name {namespace = "Gio", name = "ZlibCompressor"})
    IO (Ptr Gio.FileInfo.FileInfo)

-- | Returns the [ZlibCompressor:fileInfo]("GI.Gio.Objects.ZlibCompressor#g:attr:fileInfo") property.
-- 
-- /Since: 2.26/
zlibCompressorGetFileInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsZlibCompressor a) =>
    a
    -- ^ /@compressor@/: a t'GI.Gio.Objects.ZlibCompressor.ZlibCompressor'
    -> m (Maybe Gio.FileInfo.FileInfo)
    -- ^ __Returns:__ a t'GI.Gio.Objects.FileInfo.FileInfo', or 'P.Nothing'
zlibCompressorGetFileInfo compressor = liftIO $ do
    compressor' <- unsafeManagedPtrCastPtr compressor
    result <- g_zlib_compressor_get_file_info compressor'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.FileInfo.FileInfo) result'
        return result''
    touchManagedPtr compressor
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ZlibCompressorGetFileInfoMethodInfo
instance (signature ~ (m (Maybe Gio.FileInfo.FileInfo)), MonadIO m, IsZlibCompressor a) => O.OverloadedMethod ZlibCompressorGetFileInfoMethodInfo a signature where
    overloadedMethod = zlibCompressorGetFileInfo

instance O.OverloadedMethodInfo ZlibCompressorGetFileInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibCompressor.zlibCompressorGetFileInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ZlibCompressor.html#v:zlibCompressorGetFileInfo"
        })


#endif

-- method ZlibCompressor::set_file_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "compressor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ZlibCompressor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GZlibCompressor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file_info"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileInfo" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_zlib_compressor_set_file_info" g_zlib_compressor_set_file_info :: 
    Ptr ZlibCompressor ->                   -- compressor : TInterface (Name {namespace = "Gio", name = "ZlibCompressor"})
    Ptr Gio.FileInfo.FileInfo ->            -- file_info : TInterface (Name {namespace = "Gio", name = "FileInfo"})
    IO ()

-- | Sets /@fileInfo@/ in /@compressor@/. If non-'P.Nothing', and /@compressor@/\'s
-- [ZlibCompressor:format]("GI.Gio.Objects.ZlibCompressor#g:attr:format") property is 'GI.Gio.Enums.ZlibCompressorFormatGzip',
-- it will be used to set the file name and modification time in
-- the GZIP header of the compressed data.
-- 
-- Note: it is an error to call this function while a compression is in
-- progress; it may only be called immediately after creation of /@compressor@/,
-- or after resetting it with 'GI.Gio.Interfaces.Converter.converterReset'.
-- 
-- /Since: 2.26/
zlibCompressorSetFileInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsZlibCompressor a, Gio.FileInfo.IsFileInfo b) =>
    a
    -- ^ /@compressor@/: a t'GI.Gio.Objects.ZlibCompressor.ZlibCompressor'
    -> Maybe (b)
    -- ^ /@fileInfo@/: a t'GI.Gio.Objects.FileInfo.FileInfo'
    -> m ()
zlibCompressorSetFileInfo compressor fileInfo = liftIO $ do
    compressor' <- unsafeManagedPtrCastPtr compressor
    maybeFileInfo <- case fileInfo of
        Nothing -> return FP.nullPtr
        Just jFileInfo -> do
            jFileInfo' <- unsafeManagedPtrCastPtr jFileInfo
            return jFileInfo'
    g_zlib_compressor_set_file_info compressor' maybeFileInfo
    touchManagedPtr compressor
    whenJust fileInfo touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ZlibCompressorSetFileInfoMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsZlibCompressor a, Gio.FileInfo.IsFileInfo b) => O.OverloadedMethod ZlibCompressorSetFileInfoMethodInfo a signature where
    overloadedMethod = zlibCompressorSetFileInfo

instance O.OverloadedMethodInfo ZlibCompressorSetFileInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ZlibCompressor.zlibCompressorSetFileInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ZlibCompressor.html#v:zlibCompressorSetFileInfo"
        })


#endif


