{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Entry point for using GIO functionality.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.Vfs
    ( 

-- * Exported types
    Vfs(..)                                 ,
    IsVfs                                   ,
    toVfs                                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isActive]("GI.Gio.Objects.Vfs#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [parseName]("GI.Gio.Objects.Vfs#g:method:parseName"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [registerUriScheme]("GI.Gio.Objects.Vfs#g:method:registerUriScheme"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unregisterUriScheme]("GI.Gio.Objects.Vfs#g:method:unregisterUriScheme"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFileForPath]("GI.Gio.Objects.Vfs#g:method:getFileForPath"), [getFileForUri]("GI.Gio.Objects.Vfs#g:method:getFileForUri"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSupportedUriSchemes]("GI.Gio.Objects.Vfs#g:method:getSupportedUriSchemes").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveVfsMethod                        ,
#endif

-- ** getDefault #method:getDefault#

    vfsGetDefault                           ,


-- ** getFileForPath #method:getFileForPath#

#if defined(ENABLE_OVERLOADING)
    VfsGetFileForPathMethodInfo             ,
#endif
    vfsGetFileForPath                       ,


-- ** getFileForUri #method:getFileForUri#

#if defined(ENABLE_OVERLOADING)
    VfsGetFileForUriMethodInfo              ,
#endif
    vfsGetFileForUri                        ,


-- ** getLocal #method:getLocal#

    vfsGetLocal                             ,


-- ** getSupportedUriSchemes #method:getSupportedUriSchemes#

#if defined(ENABLE_OVERLOADING)
    VfsGetSupportedUriSchemesMethodInfo     ,
#endif
    vfsGetSupportedUriSchemes               ,


-- ** isActive #method:isActive#

#if defined(ENABLE_OVERLOADING)
    VfsIsActiveMethodInfo                   ,
#endif
    vfsIsActive                             ,


-- ** parseName #method:parseName#

#if defined(ENABLE_OVERLOADING)
    VfsParseNameMethodInfo                  ,
#endif
    vfsParseName                            ,


-- ** registerUriScheme #method:registerUriScheme#

#if defined(ENABLE_OVERLOADING)
    VfsRegisterUriSchemeMethodInfo          ,
#endif
    vfsRegisterUriScheme                    ,


-- ** unregisterUriScheme #method:unregisterUriScheme#

#if defined(ENABLE_OVERLOADING)
    VfsUnregisterUriSchemeMethodInfo        ,
#endif
    vfsUnregisterUriScheme                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File

#endif

-- | Memory-managed wrapper type.
newtype Vfs = Vfs (SP.ManagedPtr Vfs)
    deriving (Eq)

instance SP.ManagedPtrNewtype Vfs where
    toManagedPtr (Vfs p) = p

foreign import ccall "g_vfs_get_type"
    c_g_vfs_get_type :: IO B.Types.GType

instance B.Types.TypedObject Vfs where
    glibType = c_g_vfs_get_type

instance B.Types.GObject Vfs

-- | Type class for types which can be safely cast to `Vfs`, for instance with `toVfs`.
class (SP.GObject o, O.IsDescendantOf Vfs o) => IsVfs o
instance (SP.GObject o, O.IsDescendantOf Vfs o) => IsVfs o

instance O.HasParentTypes Vfs
type instance O.ParentTypes Vfs = '[GObject.Object.Object]

-- | Cast to `Vfs`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toVfs :: (MIO.MonadIO m, IsVfs o) => o -> m Vfs
toVfs = MIO.liftIO . B.ManagedPtr.unsafeCastTo Vfs

-- | Convert 'Vfs' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Vfs) where
    gvalueGType_ = c_g_vfs_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Vfs)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Vfs)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Vfs ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveVfsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVfsMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveVfsMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveVfsMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveVfsMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveVfsMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveVfsMethod "isActive" o = VfsIsActiveMethodInfo
    ResolveVfsMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveVfsMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveVfsMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveVfsMethod "parseName" o = VfsParseNameMethodInfo
    ResolveVfsMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveVfsMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveVfsMethod "registerUriScheme" o = VfsRegisterUriSchemeMethodInfo
    ResolveVfsMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveVfsMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveVfsMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveVfsMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveVfsMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveVfsMethod "unregisterUriScheme" o = VfsUnregisterUriSchemeMethodInfo
    ResolveVfsMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveVfsMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveVfsMethod "getFileForPath" o = VfsGetFileForPathMethodInfo
    ResolveVfsMethod "getFileForUri" o = VfsGetFileForUriMethodInfo
    ResolveVfsMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveVfsMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveVfsMethod "getSupportedUriSchemes" o = VfsGetSupportedUriSchemesMethodInfo
    ResolveVfsMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveVfsMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveVfsMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveVfsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVfsMethod t Vfs, O.OverloadedMethod info Vfs p) => OL.IsLabel t (Vfs -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVfsMethod t Vfs, O.OverloadedMethod info Vfs p, R.HasField t Vfs p) => R.HasField t Vfs p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVfsMethod t Vfs, O.OverloadedMethodInfo info Vfs) => OL.IsLabel t (O.MethodProxy info Vfs) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Vfs
type instance O.AttributeList Vfs = VfsAttributeList
type VfsAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Vfs = VfsSignalList
type VfsSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Vfs::get_file_for_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing a VFS path."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_get_file_for_path" g_vfs_get_file_for_path :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    CString ->                              -- path : TBasicType TUTF8
    IO (Ptr Gio.File.File)

-- | Gets a t'GI.Gio.Interfaces.File.File' for /@path@/.
vfsGetFileForPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'.
    -> T.Text
    -- ^ /@path@/: a string containing a VFS path.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File'.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
vfsGetFileForPath vfs path = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    path' <- textToCString path
    result <- g_vfs_get_file_for_path vfs' path'
    checkUnexpectedReturnNULL "vfsGetFileForPath" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr vfs
    freeMem path'
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsGetFileForPathMethodInfo
instance (signature ~ (T.Text -> m Gio.File.File), MonadIO m, IsVfs a) => O.OverloadedMethod VfsGetFileForPathMethodInfo a signature where
    overloadedMethod = vfsGetFileForPath

instance O.OverloadedMethodInfo VfsGetFileForPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsGetFileForPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsGetFileForPath"
        })


#endif

-- method Vfs::get_file_for_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a#GVfs." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing a URI"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_get_file_for_uri" g_vfs_get_file_for_uri :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    CString ->                              -- uri : TBasicType TUTF8
    IO (Ptr Gio.File.File)

-- | Gets a t'GI.Gio.Interfaces.File.File' for /@uri@/.
-- 
-- This operation never fails, but the returned object
-- might not support any I\/O operation if the URI
-- is malformed or if the URI scheme is not supported.
vfsGetFileForUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: at'GI.Gio.Objects.Vfs.Vfs'.
    -> T.Text
    -- ^ /@uri@/: a string containing a URI
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File'.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
vfsGetFileForUri vfs uri = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    uri' <- textToCString uri
    result <- g_vfs_get_file_for_uri vfs' uri'
    checkUnexpectedReturnNULL "vfsGetFileForUri" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr vfs
    freeMem uri'
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsGetFileForUriMethodInfo
instance (signature ~ (T.Text -> m Gio.File.File), MonadIO m, IsVfs a) => O.OverloadedMethod VfsGetFileForUriMethodInfo a signature where
    overloadedMethod = vfsGetFileForUri

instance O.OverloadedMethodInfo VfsGetFileForUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsGetFileForUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsGetFileForUri"
        })


#endif

-- method Vfs::get_supported_uri_schemes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_get_supported_uri_schemes" g_vfs_get_supported_uri_schemes :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    IO (Ptr CString)

-- | Gets a list of URI schemes supported by /@vfs@/.
vfsGetSupportedUriSchemes ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'.
    -> m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of strings.
    --     The returned array belongs to GIO and must
    --     not be freed or modified.
vfsGetSupportedUriSchemes vfs = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    result <- g_vfs_get_supported_uri_schemes vfs'
    checkUnexpectedReturnNULL "vfsGetSupportedUriSchemes" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr vfs
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsGetSupportedUriSchemesMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsVfs a) => O.OverloadedMethod VfsGetSupportedUriSchemesMethodInfo a signature where
    overloadedMethod = vfsGetSupportedUriSchemes

instance O.OverloadedMethodInfo VfsGetSupportedUriSchemesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsGetSupportedUriSchemes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsGetSupportedUriSchemes"
        })


#endif

-- method Vfs::is_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_is_active" g_vfs_is_active :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    IO CInt

-- | Checks if the VFS is active.
vfsIsActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if construction of the /@vfs@/ was successful
    --     and it is now active.
vfsIsActive vfs = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    result <- g_vfs_is_active vfs'
    let result' = (/= 0) result
    touchManagedPtr vfs
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsIsActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsVfs a) => O.OverloadedMethod VfsIsActiveMethodInfo a signature where
    overloadedMethod = vfsIsActive

instance O.OverloadedMethodInfo VfsIsActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsIsActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsIsActive"
        })


#endif

-- method Vfs::parse_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parse_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string to be parsed by the VFS module."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_parse_name" g_vfs_parse_name :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    CString ->                              -- parse_name : TBasicType TUTF8
    IO (Ptr Gio.File.File)

-- | This operation never fails, but the returned object might
-- not support any I\/O operations if the /@parseName@/ cannot
-- be parsed by the t'GI.Gio.Objects.Vfs.Vfs' module.
vfsParseName ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'.
    -> T.Text
    -- ^ /@parseName@/: a string to be parsed by the VFS module.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File' for the given /@parseName@/.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
vfsParseName vfs parseName = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    parseName' <- textToCString parseName
    result <- g_vfs_parse_name vfs' parseName'
    checkUnexpectedReturnNULL "vfsParseName" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr vfs
    freeMem parseName'
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsParseNameMethodInfo
instance (signature ~ (T.Text -> m Gio.File.File), MonadIO m, IsVfs a) => O.OverloadedMethod VfsParseNameMethodInfo a signature where
    overloadedMethod = vfsParseName

instance O.OverloadedMethodInfo VfsParseNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsParseName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsParseName"
        })


#endif

-- method Vfs::register_uri_scheme
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an URI scheme, e.g. \"http\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri_func"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VfsFileLookupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfsFileLookupFunc"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "custom data passed to be passed to @uri_func, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to be called when unregistering the\n    URI scheme, or when @vfs is disposed, to free the resources used\n    by the URI lookup function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parse_name_func"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "VfsFileLookupFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfsFileLookupFunc"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 6
--           , argDestroy = 7
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parse_name_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "custom data passed to be passed to\n    @parse_name_func, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parse_name_destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function to be called when unregistering the\n    URI scheme, or when @vfs is disposed, to free the resources used\n    by the parse name lookup function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_register_uri_scheme" g_vfs_register_uri_scheme :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    CString ->                              -- scheme : TBasicType TUTF8
    FunPtr Gio.Callbacks.C_VfsFileLookupFunc -> -- uri_func : TInterface (Name {namespace = "Gio", name = "VfsFileLookupFunc"})
    Ptr () ->                               -- uri_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- uri_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    FunPtr Gio.Callbacks.C_VfsFileLookupFunc -> -- parse_name_func : TInterface (Name {namespace = "Gio", name = "VfsFileLookupFunc"})
    Ptr () ->                               -- parse_name_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- parse_name_destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO CInt

-- | Registers /@uriFunc@/ and /@parseNameFunc@/ as the t'GI.Gio.Interfaces.File.File' URI and parse name
-- lookup functions for URIs with a scheme matching /@scheme@/.
-- Note that /@scheme@/ is registered only within the running application, as
-- opposed to desktop-wide as it happens with GVfs backends.
-- 
-- When a t'GI.Gio.Interfaces.File.File' is requested with an URI containing /@scheme@/ (e.g. through
-- 'GI.Gio.Functions.fileNewForUri'), /@uriFunc@/ will be called to allow a custom
-- constructor. The implementation of /@uriFunc@/ should not be blocking, and
-- must not call 'GI.Gio.Objects.Vfs.vfsRegisterUriScheme' or 'GI.Gio.Objects.Vfs.vfsUnregisterUriScheme'.
-- 
-- When 'GI.Gio.Functions.fileParseName' is called with a parse name obtained from such file,
-- /@parseNameFunc@/ will be called to allow the t'GI.Gio.Interfaces.File.File' to be created again. In
-- that case, it\'s responsibility of /@parseNameFunc@/ to make sure the parse
-- name matches what the custom t'GI.Gio.Interfaces.File.File' implementation returned when
-- 'GI.Gio.Interfaces.File.fileGetParseName' was previously called. The implementation of
-- /@parseNameFunc@/ should not be blocking, and must not call
-- 'GI.Gio.Objects.Vfs.vfsRegisterUriScheme' or 'GI.Gio.Objects.Vfs.vfsUnregisterUriScheme'.
-- 
-- It\'s an error to call this function twice with the same scheme. To unregister
-- a custom URI scheme, use 'GI.Gio.Objects.Vfs.vfsUnregisterUriScheme'.
-- 
-- /Since: 2.50/
vfsRegisterUriScheme ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'
    -> T.Text
    -- ^ /@scheme@/: an URI scheme, e.g. \"http\"
    -> Maybe (Gio.Callbacks.VfsFileLookupFunc)
    -- ^ /@uriFunc@/: a t'GI.Gio.Callbacks.VfsFileLookupFunc'
    -> Maybe (Gio.Callbacks.VfsFileLookupFunc)
    -- ^ /@parseNameFunc@/: a t'GI.Gio.Callbacks.VfsFileLookupFunc'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@scheme@/ was successfully registered, or 'P.False' if a handler
    --     for /@scheme@/ already exists.
vfsRegisterUriScheme vfs scheme uriFunc parseNameFunc = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    scheme' <- textToCString scheme
    maybeUriFunc <- case uriFunc of
        Nothing -> return FP.nullFunPtr
        Just jUriFunc -> do
            jUriFunc' <- Gio.Callbacks.mk_VfsFileLookupFunc (Gio.Callbacks.wrap_VfsFileLookupFunc Nothing (Gio.Callbacks.drop_closures_VfsFileLookupFunc jUriFunc))
            return jUriFunc'
    maybeParseNameFunc <- case parseNameFunc of
        Nothing -> return FP.nullFunPtr
        Just jParseNameFunc -> do
            jParseNameFunc' <- Gio.Callbacks.mk_VfsFileLookupFunc (Gio.Callbacks.wrap_VfsFileLookupFunc Nothing (Gio.Callbacks.drop_closures_VfsFileLookupFunc jParseNameFunc))
            return jParseNameFunc'
    let uriData = castFunPtrToPtr maybeUriFunc
    let uriDestroy = SP.safeFreeFunPtrPtr
    let parseNameData = castFunPtrToPtr maybeParseNameFunc
    let parseNameDestroy = SP.safeFreeFunPtrPtr
    result <- g_vfs_register_uri_scheme vfs' scheme' maybeUriFunc uriData uriDestroy maybeParseNameFunc parseNameData parseNameDestroy
    let result' = (/= 0) result
    touchManagedPtr vfs
    freeMem scheme'
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsRegisterUriSchemeMethodInfo
instance (signature ~ (T.Text -> Maybe (Gio.Callbacks.VfsFileLookupFunc) -> Maybe (Gio.Callbacks.VfsFileLookupFunc) -> m Bool), MonadIO m, IsVfs a) => O.OverloadedMethod VfsRegisterUriSchemeMethodInfo a signature where
    overloadedMethod = vfsRegisterUriScheme

instance O.OverloadedMethodInfo VfsRegisterUriSchemeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsRegisterUriScheme",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsRegisterUriScheme"
        })


#endif

-- method Vfs::unregister_uri_scheme
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an URI scheme, e.g. \"http\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_unregister_uri_scheme" g_vfs_unregister_uri_scheme :: 
    Ptr Vfs ->                              -- vfs : TInterface (Name {namespace = "Gio", name = "Vfs"})
    CString ->                              -- scheme : TBasicType TUTF8
    IO CInt

-- | Unregisters the URI handler for /@scheme@/ previously registered with
-- 'GI.Gio.Objects.Vfs.vfsRegisterUriScheme'.
-- 
-- /Since: 2.50/
vfsUnregisterUriScheme ::
    (B.CallStack.HasCallStack, MonadIO m, IsVfs a) =>
    a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'
    -> T.Text
    -- ^ /@scheme@/: an URI scheme, e.g. \"http\"
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@scheme@/ was successfully unregistered, or 'P.False' if a
    --     handler for /@scheme@/ does not exist.
vfsUnregisterUriScheme vfs scheme = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    scheme' <- textToCString scheme
    result <- g_vfs_unregister_uri_scheme vfs' scheme'
    let result' = (/= 0) result
    touchManagedPtr vfs
    freeMem scheme'
    return result'

#if defined(ENABLE_OVERLOADING)
data VfsUnregisterUriSchemeMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsVfs a) => O.OverloadedMethod VfsUnregisterUriSchemeMethodInfo a signature where
    overloadedMethod = vfsUnregisterUriScheme

instance O.OverloadedMethodInfo VfsUnregisterUriSchemeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Vfs.vfsUnregisterUriScheme",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Vfs.html#v:vfsUnregisterUriScheme"
        })


#endif

-- method Vfs::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Vfs" })
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_get_default" g_vfs_get_default :: 
    IO (Ptr Vfs)

-- | Gets the default t'GI.Gio.Objects.Vfs.Vfs' for the system.
vfsGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Vfs
    -- ^ __Returns:__ a t'GI.Gio.Objects.Vfs.Vfs', which will be the local
    --     file system t'GI.Gio.Objects.Vfs.Vfs' if no other implementation is available.
vfsGetDefault  = liftIO $ do
    result <- g_vfs_get_default
    checkUnexpectedReturnNULL "vfsGetDefault" result
    result' <- (newObject Vfs) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Vfs::get_local
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Vfs" })
-- throws : False
-- Skip return : False

foreign import ccall "g_vfs_get_local" g_vfs_get_local :: 
    IO (Ptr Vfs)

-- | Gets the local t'GI.Gio.Objects.Vfs.Vfs' for the system.
vfsGetLocal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Vfs
    -- ^ __Returns:__ a t'GI.Gio.Objects.Vfs.Vfs'.
vfsGetLocal  = liftIO $ do
    result <- g_vfs_get_local
    checkUnexpectedReturnNULL "vfsGetLocal" result
    result' <- (newObject Vfs) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


