{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GUnixOutputStream@ implements t'GI.Gio.Objects.OutputStream.OutputStream' for writing to a UNIX
-- file descriptor, including asynchronous operations. (If the file
-- descriptor refers to a socket or pipe, this will use @poll()@ to do
-- asynchronous I\/O. If it refers to a regular file, it will fall back
-- to doing asynchronous I\/O in another thread.)
-- 
-- Note that @\<gio\/gunixoutputstream.h>@ belongs to the UNIX-specific GIO
-- interfaces, thus you have to use the @gio-unix-2.0.pc@ pkg-config file
-- file or the @GioUnix-2.0@ GIR namespace when using it.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixOutputStream
    ( 

-- * Exported types
    UnixOutputStream(..)                    ,
    IsUnixOutputStream                      ,
    toUnixOutputStream                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableOutputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableOutputStream#g:method:createSource"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isWritable]("GI.Gio.Interfaces.PollableOutputStream#g:method:isWritable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writeNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writeNonblocking"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish"), [writevNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writevNonblocking").
-- 
-- ==== Getters
-- [getCloseFd]("GI.Gio.Objects.UnixOutputStream#g:method:getCloseFd"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFd]("GI.Gio.Objects.UnixOutputStream#g:method:getFd"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCloseFd]("GI.Gio.Objects.UnixOutputStream#g:method:setCloseFd"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixOutputStreamMethod           ,
#endif

-- ** getCloseFd #method:getCloseFd#

#if defined(ENABLE_OVERLOADING)
    UnixOutputStreamGetCloseFdMethodInfo    ,
#endif
    unixOutputStreamGetCloseFd              ,


-- ** getFd #method:getFd#

#if defined(ENABLE_OVERLOADING)
    UnixOutputStreamGetFdMethodInfo         ,
#endif
    unixOutputStreamGetFd                   ,


-- ** new #method:new#

    unixOutputStreamNew                     ,


-- ** setCloseFd #method:setCloseFd#

#if defined(ENABLE_OVERLOADING)
    UnixOutputStreamSetCloseFdMethodInfo    ,
#endif
    unixOutputStreamSetCloseFd              ,




 -- * Properties


-- ** closeFd #attr:closeFd#
-- | Whether to close the file descriptor when the stream is closed.
-- 
-- /Since: 2.20/

#if defined(ENABLE_OVERLOADING)
    UnixOutputStreamCloseFdPropertyInfo     ,
#endif
    constructUnixOutputStreamCloseFd        ,
    getUnixOutputStreamCloseFd              ,
    setUnixOutputStreamCloseFd              ,
#if defined(ENABLE_OVERLOADING)
    unixOutputStreamCloseFd                 ,
#endif


-- ** fd #attr:fd#
-- | The file descriptor that the stream writes to.
-- 
-- /Since: 2.20/

#if defined(ENABLE_OVERLOADING)
    UnixOutputStreamFdPropertyInfo          ,
#endif
    constructUnixOutputStreamFd             ,
    getUnixOutputStreamFd                   ,
#if defined(ENABLE_OVERLOADING)
    unixOutputStreamFd                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.FileDescriptorBased as Gio.FileDescriptorBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.FileDescriptorBased as Gio.FileDescriptorBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype UnixOutputStream = UnixOutputStream (SP.ManagedPtr UnixOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixOutputStream where
    toManagedPtr (UnixOutputStream p) = p

foreign import ccall "g_unix_output_stream_get_type"
    c_g_unix_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixOutputStream where
    glibType = c_g_unix_output_stream_get_type

instance B.Types.GObject UnixOutputStream

-- | Type class for types which can be safely cast to `UnixOutputStream`, for instance with `toUnixOutputStream`.
class (SP.GObject o, O.IsDescendantOf UnixOutputStream o) => IsUnixOutputStream o
instance (SP.GObject o, O.IsDescendantOf UnixOutputStream o) => IsUnixOutputStream o

instance O.HasParentTypes UnixOutputStream
type instance O.ParentTypes UnixOutputStream = '[Gio.OutputStream.OutputStream, GObject.Object.Object, Gio.FileDescriptorBased.FileDescriptorBased, Gio.PollableOutputStream.PollableOutputStream]

-- | Cast to `UnixOutputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toUnixOutputStream :: (MIO.MonadIO m, IsUnixOutputStream o) => o -> m UnixOutputStream
toUnixOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixOutputStream

-- | Convert 'UnixOutputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixOutputStream) where
    gvalueGType_ = c_g_unix_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixOutputStreamMethod "canPoll" o = Gio.PollableOutputStream.PollableOutputStreamCanPollMethodInfo
    ResolveUnixOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveUnixOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveUnixOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveUnixOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveUnixOutputStreamMethod "createSource" o = Gio.PollableOutputStream.PollableOutputStreamCreateSourceMethodInfo
    ResolveUnixOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveUnixOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveUnixOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveUnixOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveUnixOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveUnixOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveUnixOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixOutputStreamMethod "isWritable" o = Gio.PollableOutputStream.PollableOutputStreamIsWritableMethodInfo
    ResolveUnixOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveUnixOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveUnixOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveUnixOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveUnixOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveUnixOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveUnixOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveUnixOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveUnixOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveUnixOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveUnixOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveUnixOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveUnixOutputStreamMethod "writeNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWriteNonblockingMethodInfo
    ResolveUnixOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveUnixOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveUnixOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveUnixOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveUnixOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveUnixOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveUnixOutputStreamMethod "writevNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWritevNonblockingMethodInfo
    ResolveUnixOutputStreamMethod "getCloseFd" o = UnixOutputStreamGetCloseFdMethodInfo
    ResolveUnixOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixOutputStreamMethod "getFd" o = UnixOutputStreamGetFdMethodInfo
    ResolveUnixOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixOutputStreamMethod "setCloseFd" o = UnixOutputStreamSetCloseFdMethodInfo
    ResolveUnixOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveUnixOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixOutputStreamMethod t UnixOutputStream, O.OverloadedMethod info UnixOutputStream p) => OL.IsLabel t (UnixOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixOutputStreamMethod t UnixOutputStream, O.OverloadedMethod info UnixOutputStream p, R.HasField t UnixOutputStream p) => R.HasField t UnixOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixOutputStreamMethod t UnixOutputStream, O.OverloadedMethodInfo info UnixOutputStream) => OL.IsLabel t (O.MethodProxy info UnixOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "close-fd"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@close-fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' unixOutputStream #closeFd
-- @
getUnixOutputStreamCloseFd :: (MonadIO m, IsUnixOutputStream o) => o -> m Bool
getUnixOutputStreamCloseFd obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "close-fd"

-- | Set the value of the “@close-fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' unixOutputStream [ #closeFd 'Data.GI.Base.Attributes.:=' value ]
-- @
setUnixOutputStreamCloseFd :: (MonadIO m, IsUnixOutputStream o) => o -> Bool -> m ()
setUnixOutputStreamCloseFd obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "close-fd" val

-- | Construct a `GValueConstruct` with valid value for the “@close-fd@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUnixOutputStreamCloseFd :: (IsUnixOutputStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructUnixOutputStreamCloseFd val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "close-fd" val

#if defined(ENABLE_OVERLOADING)
data UnixOutputStreamCloseFdPropertyInfo
instance AttrInfo UnixOutputStreamCloseFdPropertyInfo where
    type AttrAllowedOps UnixOutputStreamCloseFdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint UnixOutputStreamCloseFdPropertyInfo = IsUnixOutputStream
    type AttrSetTypeConstraint UnixOutputStreamCloseFdPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint UnixOutputStreamCloseFdPropertyInfo = (~) Bool
    type AttrTransferType UnixOutputStreamCloseFdPropertyInfo = Bool
    type AttrGetType UnixOutputStreamCloseFdPropertyInfo = Bool
    type AttrLabel UnixOutputStreamCloseFdPropertyInfo = "close-fd"
    type AttrOrigin UnixOutputStreamCloseFdPropertyInfo = UnixOutputStream
    attrGet = getUnixOutputStreamCloseFd
    attrSet = setUnixOutputStreamCloseFd
    attrTransfer _ v = do
        return v
    attrConstruct = constructUnixOutputStreamCloseFd
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixOutputStream.closeFd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixOutputStream.html#g:attr:closeFd"
        })
#endif

-- VVV Prop "fd"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' unixOutputStream #fd
-- @
getUnixOutputStreamFd :: (MonadIO m, IsUnixOutputStream o) => o -> m Int32
getUnixOutputStreamFd obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "fd"

-- | Construct a `GValueConstruct` with valid value for the “@fd@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUnixOutputStreamFd :: (IsUnixOutputStream o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructUnixOutputStreamFd val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "fd" val

#if defined(ENABLE_OVERLOADING)
data UnixOutputStreamFdPropertyInfo
instance AttrInfo UnixOutputStreamFdPropertyInfo where
    type AttrAllowedOps UnixOutputStreamFdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint UnixOutputStreamFdPropertyInfo = IsUnixOutputStream
    type AttrSetTypeConstraint UnixOutputStreamFdPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint UnixOutputStreamFdPropertyInfo = (~) Int32
    type AttrTransferType UnixOutputStreamFdPropertyInfo = Int32
    type AttrGetType UnixOutputStreamFdPropertyInfo = Int32
    type AttrLabel UnixOutputStreamFdPropertyInfo = "fd"
    type AttrOrigin UnixOutputStreamFdPropertyInfo = UnixOutputStream
    attrGet = getUnixOutputStreamFd
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructUnixOutputStreamFd
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixOutputStream.fd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixOutputStream.html#g:attr:fd"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixOutputStream
type instance O.AttributeList UnixOutputStream = UnixOutputStreamAttributeList
type UnixOutputStreamAttributeList = ('[ '("closeFd", UnixOutputStreamCloseFdPropertyInfo), '("fd", UnixOutputStreamFdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
unixOutputStreamCloseFd :: AttrLabelProxy "closeFd"
unixOutputStreamCloseFd = AttrLabelProxy

unixOutputStreamFd :: AttrLabelProxy "fd"
unixOutputStreamFd = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixOutputStream = UnixOutputStreamSignalList
type UnixOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixOutputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UNIX file descriptor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "close_fd"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to close the file descriptor when done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_output_stream_new" g_unix_output_stream_new :: 
    Int32 ->                                -- fd : TBasicType TInt
    CInt ->                                 -- close_fd : TBasicType TBoolean
    IO (Ptr UnixOutputStream)

-- | Creates a new t'GI.Gio.Objects.UnixOutputStream.UnixOutputStream' for the given /@fd@/.
-- 
-- If /@closeFd@/, is 'P.True', the file descriptor will be closed when
-- the output stream is destroyed.
unixOutputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: a UNIX file descriptor
    -> Bool
    -- ^ /@closeFd@/: 'P.True' to close the file descriptor when done
    -> m UnixOutputStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.OutputStream.OutputStream'
unixOutputStreamNew fd closeFd = liftIO $ do
    let closeFd' = (P.fromIntegral . P.fromEnum) closeFd
    result <- g_unix_output_stream_new fd closeFd'
    checkUnexpectedReturnNULL "unixOutputStreamNew" result
    result' <- (wrapObject UnixOutputStream) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixOutputStream::get_close_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_output_stream_get_close_fd" g_unix_output_stream_get_close_fd :: 
    Ptr UnixOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "UnixOutputStream"})
    IO CInt

-- | Returns whether the file descriptor of /@stream@/ will be
-- closed when the stream is closed.
-- 
-- /Since: 2.20/
unixOutputStreamGetCloseFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixOutputStream.UnixOutputStream'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the file descriptor is closed when done
unixOutputStreamGetCloseFd stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_unix_output_stream_get_close_fd stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data UnixOutputStreamGetCloseFdMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsUnixOutputStream a) => O.OverloadedMethod UnixOutputStreamGetCloseFdMethodInfo a signature where
    overloadedMethod = unixOutputStreamGetCloseFd

instance O.OverloadedMethodInfo UnixOutputStreamGetCloseFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixOutputStream.unixOutputStreamGetCloseFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixOutputStream.html#v:unixOutputStreamGetCloseFd"
        })


#endif

-- method UnixOutputStream::get_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_output_stream_get_fd" g_unix_output_stream_get_fd :: 
    Ptr UnixOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "UnixOutputStream"})
    IO Int32

-- | Return the UNIX file descriptor that the stream writes to.
-- 
-- /Since: 2.20/
unixOutputStreamGetFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixOutputStream.UnixOutputStream'
    -> m Int32
    -- ^ __Returns:__ The file descriptor of /@stream@/
unixOutputStreamGetFd stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_unix_output_stream_get_fd stream'
    touchManagedPtr stream
    return result

#if defined(ENABLE_OVERLOADING)
data UnixOutputStreamGetFdMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsUnixOutputStream a) => O.OverloadedMethod UnixOutputStreamGetFdMethodInfo a signature where
    overloadedMethod = unixOutputStreamGetFd

instance O.OverloadedMethodInfo UnixOutputStreamGetFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixOutputStream.unixOutputStreamGetFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixOutputStream.html#v:unixOutputStreamGetFd"
        })


#endif

-- method UnixOutputStream::set_close_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "close_fd"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to close the file descriptor when done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_output_stream_set_close_fd" g_unix_output_stream_set_close_fd :: 
    Ptr UnixOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "UnixOutputStream"})
    CInt ->                                 -- close_fd : TBasicType TBoolean
    IO ()

-- | Sets whether the file descriptor of /@stream@/ shall be closed
-- when the stream is closed.
-- 
-- /Since: 2.20/
unixOutputStreamSetCloseFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixOutputStream.UnixOutputStream'
    -> Bool
    -- ^ /@closeFd@/: 'P.True' to close the file descriptor when done
    -> m ()
unixOutputStreamSetCloseFd stream closeFd = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    let closeFd' = (P.fromIntegral . P.fromEnum) closeFd
    g_unix_output_stream_set_close_fd stream' closeFd'
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data UnixOutputStreamSetCloseFdMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsUnixOutputStream a) => O.OverloadedMethod UnixOutputStreamSetCloseFdMethodInfo a signature where
    overloadedMethod = unixOutputStreamSetCloseFd

instance O.OverloadedMethodInfo UnixOutputStreamSetCloseFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixOutputStream.unixOutputStreamSetCloseFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixOutputStream.html#v:unixOutputStreamSetCloseFd"
        })


#endif


