{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Watches for changes to the set of mount entries and mount points in the
-- system.
-- 
-- Connect to the @/GioUnix.MountMonitor::mounts-changed/@ signal to be
-- notified of changes to the [struct/@gioUnix@/.MountEntry] list.
-- 
-- Connect to the @/GioUnix.MountMonitor::mountpoints-changed/@ signal to
-- be notified of changes to the [struct/@gioUnix@/.MountPoint] list.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixMountMonitor
    ( 

-- * Exported types
    UnixMountMonitor(..)                    ,
    IsUnixMountMonitor                      ,
    toUnixMountMonitor                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRateLimit]("GI.Gio.Objects.UnixMountMonitor#g:method:setRateLimit").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixMountMonitorMethod           ,
#endif

-- ** get #method:get#

    unixMountMonitorGet                     ,


-- ** new #method:new#

    unixMountMonitorNew                     ,


-- ** setRateLimit #method:setRateLimit#

#if defined(ENABLE_OVERLOADING)
    UnixMountMonitorSetRateLimitMethodInfo  ,
#endif
    unixMountMonitorSetRateLimit            ,




 -- * Signals


-- ** mountpointsChanged #signal:mountpointsChanged#

    UnixMountMonitorMountpointsChangedCallback,
#if defined(ENABLE_OVERLOADING)
    UnixMountMonitorMountpointsChangedSignalInfo,
#endif
    afterUnixMountMonitorMountpointsChanged ,
    onUnixMountMonitorMountpointsChanged    ,


-- ** mountsChanged #signal:mountsChanged#

    UnixMountMonitorMountsChangedCallback   ,
#if defined(ENABLE_OVERLOADING)
    UnixMountMonitorMountsChangedSignalInfo ,
#endif
    afterUnixMountMonitorMountsChanged      ,
    onUnixMountMonitorMountsChanged         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype UnixMountMonitor = UnixMountMonitor (SP.ManagedPtr UnixMountMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixMountMonitor where
    toManagedPtr (UnixMountMonitor p) = p

foreign import ccall "g_unix_mount_monitor_get_type"
    c_g_unix_mount_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixMountMonitor where
    glibType = c_g_unix_mount_monitor_get_type

instance B.Types.GObject UnixMountMonitor

-- | Type class for types which can be safely cast to `UnixMountMonitor`, for instance with `toUnixMountMonitor`.
class (SP.GObject o, O.IsDescendantOf UnixMountMonitor o) => IsUnixMountMonitor o
instance (SP.GObject o, O.IsDescendantOf UnixMountMonitor o) => IsUnixMountMonitor o

instance O.HasParentTypes UnixMountMonitor
type instance O.ParentTypes UnixMountMonitor = '[GObject.Object.Object]

-- | Cast to `UnixMountMonitor`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toUnixMountMonitor :: (MIO.MonadIO m, IsUnixMountMonitor o) => o -> m UnixMountMonitor
toUnixMountMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixMountMonitor

-- | Convert 'UnixMountMonitor' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixMountMonitor) where
    gvalueGType_ = c_g_unix_mount_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixMountMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixMountMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixMountMonitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixMountMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixMountMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixMountMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixMountMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixMountMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixMountMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixMountMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixMountMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixMountMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixMountMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixMountMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixMountMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixMountMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixMountMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixMountMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixMountMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixMountMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixMountMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixMountMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixMountMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixMountMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixMountMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixMountMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixMountMonitorMethod "setRateLimit" o = UnixMountMonitorSetRateLimitMethodInfo
    ResolveUnixMountMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixMountMonitorMethod t UnixMountMonitor, O.OverloadedMethod info UnixMountMonitor p) => OL.IsLabel t (UnixMountMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixMountMonitorMethod t UnixMountMonitor, O.OverloadedMethod info UnixMountMonitor p, R.HasField t UnixMountMonitor p) => R.HasField t UnixMountMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixMountMonitorMethod t UnixMountMonitor, O.OverloadedMethodInfo info UnixMountMonitor) => OL.IsLabel t (O.MethodProxy info UnixMountMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal UnixMountMonitor::mountpoints-changed
-- | Emitted when the Unix mount points have changed.
type UnixMountMonitorMountpointsChangedCallback =
    IO ()

type C_UnixMountMonitorMountpointsChangedCallback =
    Ptr UnixMountMonitor ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_UnixMountMonitorMountpointsChangedCallback`.
foreign import ccall "wrapper"
    mk_UnixMountMonitorMountpointsChangedCallback :: C_UnixMountMonitorMountpointsChangedCallback -> IO (FunPtr C_UnixMountMonitorMountpointsChangedCallback)

wrap_UnixMountMonitorMountpointsChangedCallback :: 
    GObject a => (a -> UnixMountMonitorMountpointsChangedCallback) ->
    C_UnixMountMonitorMountpointsChangedCallback
wrap_UnixMountMonitorMountpointsChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [mountpointsChanged](#signal:mountpointsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' unixMountMonitor #mountpointsChanged callback
-- @
-- 
-- 
onUnixMountMonitorMountpointsChanged :: (IsUnixMountMonitor a, MonadIO m) => a -> ((?self :: a) => UnixMountMonitorMountpointsChangedCallback) -> m SignalHandlerId
onUnixMountMonitorMountpointsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_UnixMountMonitorMountpointsChangedCallback wrapped
    wrapped'' <- mk_UnixMountMonitorMountpointsChangedCallback wrapped'
    connectSignalFunPtr obj "mountpoints-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountpointsChanged](#signal:mountpointsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' unixMountMonitor #mountpointsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterUnixMountMonitorMountpointsChanged :: (IsUnixMountMonitor a, MonadIO m) => a -> ((?self :: a) => UnixMountMonitorMountpointsChangedCallback) -> m SignalHandlerId
afterUnixMountMonitorMountpointsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_UnixMountMonitorMountpointsChangedCallback wrapped
    wrapped'' <- mk_UnixMountMonitorMountpointsChangedCallback wrapped'
    connectSignalFunPtr obj "mountpoints-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data UnixMountMonitorMountpointsChangedSignalInfo
instance SignalInfo UnixMountMonitorMountpointsChangedSignalInfo where
    type HaskellCallbackType UnixMountMonitorMountpointsChangedSignalInfo = UnixMountMonitorMountpointsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_UnixMountMonitorMountpointsChangedCallback cb
        cb'' <- mk_UnixMountMonitorMountpointsChangedCallback cb'
        connectSignalFunPtr obj "mountpoints-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixMountMonitor::mountpoints-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixMountMonitor.html#g:signal:mountpointsChanged"})

#endif

-- signal UnixMountMonitor::mounts-changed
-- | Emitted when the Unix mount entries have changed.
type UnixMountMonitorMountsChangedCallback =
    IO ()

type C_UnixMountMonitorMountsChangedCallback =
    Ptr UnixMountMonitor ->                 -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_UnixMountMonitorMountsChangedCallback`.
foreign import ccall "wrapper"
    mk_UnixMountMonitorMountsChangedCallback :: C_UnixMountMonitorMountsChangedCallback -> IO (FunPtr C_UnixMountMonitorMountsChangedCallback)

wrap_UnixMountMonitorMountsChangedCallback :: 
    GObject a => (a -> UnixMountMonitorMountsChangedCallback) ->
    C_UnixMountMonitorMountsChangedCallback
wrap_UnixMountMonitorMountsChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [mountsChanged](#signal:mountsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' unixMountMonitor #mountsChanged callback
-- @
-- 
-- 
onUnixMountMonitorMountsChanged :: (IsUnixMountMonitor a, MonadIO m) => a -> ((?self :: a) => UnixMountMonitorMountsChangedCallback) -> m SignalHandlerId
onUnixMountMonitorMountsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_UnixMountMonitorMountsChangedCallback wrapped
    wrapped'' <- mk_UnixMountMonitorMountsChangedCallback wrapped'
    connectSignalFunPtr obj "mounts-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [mountsChanged](#signal:mountsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' unixMountMonitor #mountsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterUnixMountMonitorMountsChanged :: (IsUnixMountMonitor a, MonadIO m) => a -> ((?self :: a) => UnixMountMonitorMountsChangedCallback) -> m SignalHandlerId
afterUnixMountMonitorMountsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_UnixMountMonitorMountsChangedCallback wrapped
    wrapped'' <- mk_UnixMountMonitorMountsChangedCallback wrapped'
    connectSignalFunPtr obj "mounts-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data UnixMountMonitorMountsChangedSignalInfo
instance SignalInfo UnixMountMonitorMountsChangedSignalInfo where
    type HaskellCallbackType UnixMountMonitorMountsChangedSignalInfo = UnixMountMonitorMountsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_UnixMountMonitorMountsChangedCallback cb
        cb'' <- mk_UnixMountMonitorMountsChangedCallback cb'
        connectSignalFunPtr obj "mounts-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixMountMonitor::mounts-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixMountMonitor.html#g:signal:mountsChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixMountMonitor
type instance O.AttributeList UnixMountMonitor = UnixMountMonitorAttributeList
type UnixMountMonitorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixMountMonitor = UnixMountMonitorSignalList
type UnixMountMonitorSignalList = ('[ '("mountpointsChanged", UnixMountMonitorMountpointsChangedSignalInfo), '("mountsChanged", UnixMountMonitorMountsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixMountMonitor::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixMountMonitor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_monitor_new" g_unix_mount_monitor_new :: 
    IO (Ptr UnixMountMonitor)

{-# DEPRECATED unixMountMonitorNew ["(Since version 2.44)","Use [func/@gioUnix@/.MountMonitor.get] instead."] #-}
-- | Deprecated alias for [func/@gioUnix@/.MountMonitor.get].
-- 
-- This function was never a true constructor, which is why it was
-- renamed.
unixMountMonitorNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m UnixMountMonitor
    -- ^ __Returns:__ a @/GioUnix.MountMonitor/@
unixMountMonitorNew  = liftIO $ do
    result <- g_unix_mount_monitor_new
    checkUnexpectedReturnNULL "unixMountMonitorNew" result
    result' <- (wrapObject UnixMountMonitor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixMountMonitor::set_rate_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount_monitor"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@GioUnix.MountMonitor]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "limit_msec"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a integer with the limit (in milliseconds) to poll for changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_monitor_set_rate_limit" g_unix_mount_monitor_set_rate_limit :: 
    Ptr UnixMountMonitor ->                 -- mount_monitor : TInterface (Name {namespace = "Gio", name = "UnixMountMonitor"})
    Int32 ->                                -- limit_msec : TBasicType TInt
    IO ()

{-# DEPRECATED unixMountMonitorSetRateLimit ["(Since version 2.44)","This function does nothing. Don\8217t call it."] #-}
-- | This function does nothing.
-- 
-- Before 2.44, this was a partially-effective way of controlling the
-- rate at which events would be reported under some uncommon
-- circumstances.  Since /@mountMonitor@/ is a singleton, it also meant
-- that calling this function would have side effects for other users of
-- the monitor.
-- 
-- /Since: 2.18/
unixMountMonitorSetRateLimit ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixMountMonitor a) =>
    a
    -- ^ /@mountMonitor@/: a @/GioUnix.MountMonitor/@
    -> Int32
    -- ^ /@limitMsec@/: a integer with the limit (in milliseconds) to poll for changes
    -> m ()
unixMountMonitorSetRateLimit mountMonitor limitMsec = liftIO $ do
    mountMonitor' <- unsafeManagedPtrCastPtr mountMonitor
    g_unix_mount_monitor_set_rate_limit mountMonitor' limitMsec
    touchManagedPtr mountMonitor
    return ()

#if defined(ENABLE_OVERLOADING)
data UnixMountMonitorSetRateLimitMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsUnixMountMonitor a) => O.OverloadedMethod UnixMountMonitorSetRateLimitMethodInfo a signature where
    overloadedMethod = unixMountMonitorSetRateLimit

instance O.OverloadedMethodInfo UnixMountMonitorSetRateLimitMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixMountMonitor.unixMountMonitorSetRateLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixMountMonitor.html#v:unixMountMonitorSetRateLimit"
        })


#endif

-- method UnixMountMonitor::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixMountMonitor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_monitor_get" g_unix_mount_monitor_get :: 
    IO (Ptr UnixMountMonitor)

-- | Gets the @/GioUnix.MountMonitor/@ for the current thread-default main
-- context.
-- 
-- The mount monitor can be used to monitor for changes to the list of
-- mounted filesystems as well as the list of mount points (ie: fstab
-- entries).
-- 
-- You must only call 'GI.GObject.Objects.Object.objectUnref' on the return value from
-- under the same main context as you called this function.
-- 
-- /Since: 2.44/
unixMountMonitorGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m UnixMountMonitor
    -- ^ __Returns:__ the @/GioUnix.MountMonitor/@
unixMountMonitorGet  = liftIO $ do
    result <- g_unix_mount_monitor_get
    checkUnexpectedReturnNULL "unixMountMonitorGet" result
    result' <- (wrapObject UnixMountMonitor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


