{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GUnixInputStream@ implements t'GI.Gio.Objects.InputStream.InputStream' for reading from a UNIX
-- file descriptor, including asynchronous operations. (If the file
-- descriptor refers to a socket or pipe, this will use @poll()@ to do
-- asynchronous I\/O. If it refers to a regular file, it will fall back
-- to doing asynchronous I\/O in another thread.)
-- 
-- Note that @\<gio\/gunixinputstream.h>@ belongs to the UNIX-specific GIO
-- interfaces, thus you have to use the @gio-unix-2.0.pc@ pkg-config
-- file or the @GioUnix-2.0@ GIR namespace when using it.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixInputStream
    ( 

-- * Exported types
    UnixInputStream(..)                     ,
    IsUnixInputStream                       ,
    toUnixInputStream                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableInputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.InputStream#g:method:clearPending"), [close]("GI.Gio.Objects.InputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.InputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.InputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableInputStream#g:method:createSource"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.InputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.InputStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isReadable]("GI.Gio.Interfaces.PollableInputStream#g:method:isReadable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [read]("GI.Gio.Objects.InputStream#g:method:read"), [readAll]("GI.Gio.Objects.InputStream#g:method:readAll"), [readAllAsync]("GI.Gio.Objects.InputStream#g:method:readAllAsync"), [readAllFinish]("GI.Gio.Objects.InputStream#g:method:readAllFinish"), [readAsync]("GI.Gio.Objects.InputStream#g:method:readAsync"), [readBytes]("GI.Gio.Objects.InputStream#g:method:readBytes"), [readBytesAsync]("GI.Gio.Objects.InputStream#g:method:readBytesAsync"), [readBytesFinish]("GI.Gio.Objects.InputStream#g:method:readBytesFinish"), [readFinish]("GI.Gio.Objects.InputStream#g:method:readFinish"), [readNonblocking]("GI.Gio.Interfaces.PollableInputStream#g:method:readNonblocking"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [skip]("GI.Gio.Objects.InputStream#g:method:skip"), [skipAsync]("GI.Gio.Objects.InputStream#g:method:skipAsync"), [skipFinish]("GI.Gio.Objects.InputStream#g:method:skipFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCloseFd]("GI.Gio.Objects.UnixInputStream#g:method:getCloseFd"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFd]("GI.Gio.Objects.UnixInputStream#g:method:getFd"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCloseFd]("GI.Gio.Objects.UnixInputStream#g:method:setCloseFd"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.InputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixInputStreamMethod            ,
#endif

-- ** getCloseFd #method:getCloseFd#

#if defined(ENABLE_OVERLOADING)
    UnixInputStreamGetCloseFdMethodInfo     ,
#endif
    unixInputStreamGetCloseFd               ,


-- ** getFd #method:getFd#

#if defined(ENABLE_OVERLOADING)
    UnixInputStreamGetFdMethodInfo          ,
#endif
    unixInputStreamGetFd                    ,


-- ** new #method:new#

    unixInputStreamNew                      ,


-- ** setCloseFd #method:setCloseFd#

#if defined(ENABLE_OVERLOADING)
    UnixInputStreamSetCloseFdMethodInfo     ,
#endif
    unixInputStreamSetCloseFd               ,




 -- * Properties


-- ** closeFd #attr:closeFd#
-- | Whether to close the file descriptor when the stream is closed.
-- 
-- /Since: 2.20/

#if defined(ENABLE_OVERLOADING)
    UnixInputStreamCloseFdPropertyInfo      ,
#endif
    constructUnixInputStreamCloseFd         ,
    getUnixInputStreamCloseFd               ,
    setUnixInputStreamCloseFd               ,
#if defined(ENABLE_OVERLOADING)
    unixInputStreamCloseFd                  ,
#endif


-- ** fd #attr:fd#
-- | The file descriptor that the stream reads from.
-- 
-- /Since: 2.20/

#if defined(ENABLE_OVERLOADING)
    UnixInputStreamFdPropertyInfo           ,
#endif
    constructUnixInputStreamFd              ,
    getUnixInputStreamFd                    ,
#if defined(ENABLE_OVERLOADING)
    unixInputStreamFd                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.FileDescriptorBased as Gio.FileDescriptorBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.FileDescriptorBased as Gio.FileDescriptorBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype UnixInputStream = UnixInputStream (SP.ManagedPtr UnixInputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixInputStream where
    toManagedPtr (UnixInputStream p) = p

foreign import ccall "g_unix_input_stream_get_type"
    c_g_unix_input_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixInputStream where
    glibType = c_g_unix_input_stream_get_type

instance B.Types.GObject UnixInputStream

-- | Type class for types which can be safely cast to `UnixInputStream`, for instance with `toUnixInputStream`.
class (SP.GObject o, O.IsDescendantOf UnixInputStream o) => IsUnixInputStream o
instance (SP.GObject o, O.IsDescendantOf UnixInputStream o) => IsUnixInputStream o

instance O.HasParentTypes UnixInputStream
type instance O.ParentTypes UnixInputStream = '[Gio.InputStream.InputStream, GObject.Object.Object, Gio.FileDescriptorBased.FileDescriptorBased, Gio.PollableInputStream.PollableInputStream]

-- | Cast to `UnixInputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toUnixInputStream :: (MIO.MonadIO m, IsUnixInputStream o) => o -> m UnixInputStream
toUnixInputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixInputStream

-- | Convert 'UnixInputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixInputStream) where
    gvalueGType_ = c_g_unix_input_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixInputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixInputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixInputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixInputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixInputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixInputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixInputStreamMethod "canPoll" o = Gio.PollableInputStream.PollableInputStreamCanPollMethodInfo
    ResolveUnixInputStreamMethod "clearPending" o = Gio.InputStream.InputStreamClearPendingMethodInfo
    ResolveUnixInputStreamMethod "close" o = Gio.InputStream.InputStreamCloseMethodInfo
    ResolveUnixInputStreamMethod "closeAsync" o = Gio.InputStream.InputStreamCloseAsyncMethodInfo
    ResolveUnixInputStreamMethod "closeFinish" o = Gio.InputStream.InputStreamCloseFinishMethodInfo
    ResolveUnixInputStreamMethod "createSource" o = Gio.PollableInputStream.PollableInputStreamCreateSourceMethodInfo
    ResolveUnixInputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixInputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixInputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixInputStreamMethod "hasPending" o = Gio.InputStream.InputStreamHasPendingMethodInfo
    ResolveUnixInputStreamMethod "isClosed" o = Gio.InputStream.InputStreamIsClosedMethodInfo
    ResolveUnixInputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixInputStreamMethod "isReadable" o = Gio.PollableInputStream.PollableInputStreamIsReadableMethodInfo
    ResolveUnixInputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixInputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixInputStreamMethod "read" o = Gio.InputStream.InputStreamReadMethodInfo
    ResolveUnixInputStreamMethod "readAll" o = Gio.InputStream.InputStreamReadAllMethodInfo
    ResolveUnixInputStreamMethod "readAllAsync" o = Gio.InputStream.InputStreamReadAllAsyncMethodInfo
    ResolveUnixInputStreamMethod "readAllFinish" o = Gio.InputStream.InputStreamReadAllFinishMethodInfo
    ResolveUnixInputStreamMethod "readAsync" o = Gio.InputStream.InputStreamReadAsyncMethodInfo
    ResolveUnixInputStreamMethod "readBytes" o = Gio.InputStream.InputStreamReadBytesMethodInfo
    ResolveUnixInputStreamMethod "readBytesAsync" o = Gio.InputStream.InputStreamReadBytesAsyncMethodInfo
    ResolveUnixInputStreamMethod "readBytesFinish" o = Gio.InputStream.InputStreamReadBytesFinishMethodInfo
    ResolveUnixInputStreamMethod "readFinish" o = Gio.InputStream.InputStreamReadFinishMethodInfo
    ResolveUnixInputStreamMethod "readNonblocking" o = Gio.PollableInputStream.PollableInputStreamReadNonblockingMethodInfo
    ResolveUnixInputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixInputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixInputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixInputStreamMethod "skip" o = Gio.InputStream.InputStreamSkipMethodInfo
    ResolveUnixInputStreamMethod "skipAsync" o = Gio.InputStream.InputStreamSkipAsyncMethodInfo
    ResolveUnixInputStreamMethod "skipFinish" o = Gio.InputStream.InputStreamSkipFinishMethodInfo
    ResolveUnixInputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixInputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixInputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixInputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixInputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixInputStreamMethod "getCloseFd" o = UnixInputStreamGetCloseFdMethodInfo
    ResolveUnixInputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixInputStreamMethod "getFd" o = UnixInputStreamGetFdMethodInfo
    ResolveUnixInputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixInputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixInputStreamMethod "setCloseFd" o = UnixInputStreamSetCloseFdMethodInfo
    ResolveUnixInputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixInputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixInputStreamMethod "setPending" o = Gio.InputStream.InputStreamSetPendingMethodInfo
    ResolveUnixInputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixInputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixInputStreamMethod t UnixInputStream, O.OverloadedMethod info UnixInputStream p) => OL.IsLabel t (UnixInputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixInputStreamMethod t UnixInputStream, O.OverloadedMethod info UnixInputStream p, R.HasField t UnixInputStream p) => R.HasField t UnixInputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixInputStreamMethod t UnixInputStream, O.OverloadedMethodInfo info UnixInputStream) => OL.IsLabel t (O.MethodProxy info UnixInputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "close-fd"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@close-fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' unixInputStream #closeFd
-- @
getUnixInputStreamCloseFd :: (MonadIO m, IsUnixInputStream o) => o -> m Bool
getUnixInputStreamCloseFd obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "close-fd"

-- | Set the value of the “@close-fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' unixInputStream [ #closeFd 'Data.GI.Base.Attributes.:=' value ]
-- @
setUnixInputStreamCloseFd :: (MonadIO m, IsUnixInputStream o) => o -> Bool -> m ()
setUnixInputStreamCloseFd obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "close-fd" val

-- | Construct a `GValueConstruct` with valid value for the “@close-fd@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUnixInputStreamCloseFd :: (IsUnixInputStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructUnixInputStreamCloseFd val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "close-fd" val

#if defined(ENABLE_OVERLOADING)
data UnixInputStreamCloseFdPropertyInfo
instance AttrInfo UnixInputStreamCloseFdPropertyInfo where
    type AttrAllowedOps UnixInputStreamCloseFdPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint UnixInputStreamCloseFdPropertyInfo = IsUnixInputStream
    type AttrSetTypeConstraint UnixInputStreamCloseFdPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint UnixInputStreamCloseFdPropertyInfo = (~) Bool
    type AttrTransferType UnixInputStreamCloseFdPropertyInfo = Bool
    type AttrGetType UnixInputStreamCloseFdPropertyInfo = Bool
    type AttrLabel UnixInputStreamCloseFdPropertyInfo = "close-fd"
    type AttrOrigin UnixInputStreamCloseFdPropertyInfo = UnixInputStream
    attrGet = getUnixInputStreamCloseFd
    attrSet = setUnixInputStreamCloseFd
    attrTransfer _ v = do
        return v
    attrConstruct = constructUnixInputStreamCloseFd
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixInputStream.closeFd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixInputStream.html#g:attr:closeFd"
        })
#endif

-- VVV Prop "fd"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@fd@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' unixInputStream #fd
-- @
getUnixInputStreamFd :: (MonadIO m, IsUnixInputStream o) => o -> m Int32
getUnixInputStreamFd obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "fd"

-- | Construct a `GValueConstruct` with valid value for the “@fd@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUnixInputStreamFd :: (IsUnixInputStream o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructUnixInputStreamFd val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "fd" val

#if defined(ENABLE_OVERLOADING)
data UnixInputStreamFdPropertyInfo
instance AttrInfo UnixInputStreamFdPropertyInfo where
    type AttrAllowedOps UnixInputStreamFdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint UnixInputStreamFdPropertyInfo = IsUnixInputStream
    type AttrSetTypeConstraint UnixInputStreamFdPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint UnixInputStreamFdPropertyInfo = (~) Int32
    type AttrTransferType UnixInputStreamFdPropertyInfo = Int32
    type AttrGetType UnixInputStreamFdPropertyInfo = Int32
    type AttrLabel UnixInputStreamFdPropertyInfo = "fd"
    type AttrOrigin UnixInputStreamFdPropertyInfo = UnixInputStream
    attrGet = getUnixInputStreamFd
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructUnixInputStreamFd
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixInputStream.fd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixInputStream.html#g:attr:fd"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixInputStream
type instance O.AttributeList UnixInputStream = UnixInputStreamAttributeList
type UnixInputStreamAttributeList = ('[ '("closeFd", UnixInputStreamCloseFdPropertyInfo), '("fd", UnixInputStreamFdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
unixInputStreamCloseFd :: AttrLabelProxy "closeFd"
unixInputStreamCloseFd = AttrLabelProxy

unixInputStreamFd :: AttrLabelProxy "fd"
unixInputStreamFd = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixInputStream = UnixInputStreamSignalList
type UnixInputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixInputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UNIX file descriptor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "close_fd"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to close the file descriptor when done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_input_stream_new" g_unix_input_stream_new :: 
    Int32 ->                                -- fd : TBasicType TInt
    CInt ->                                 -- close_fd : TBasicType TBoolean
    IO (Ptr UnixInputStream)

-- | Creates a new t'GI.Gio.Objects.UnixInputStream.UnixInputStream' for the given /@fd@/.
-- 
-- If /@closeFd@/ is 'P.True', the file descriptor will be closed
-- when the stream is closed.
unixInputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@fd@/: a UNIX file descriptor
    -> Bool
    -- ^ /@closeFd@/: 'P.True' to close the file descriptor when done
    -> m UnixInputStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.UnixInputStream.UnixInputStream'
unixInputStreamNew fd closeFd = liftIO $ do
    let closeFd' = (P.fromIntegral . P.fromEnum) closeFd
    result <- g_unix_input_stream_new fd closeFd'
    checkUnexpectedReturnNULL "unixInputStreamNew" result
    result' <- (wrapObject UnixInputStream) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixInputStream::get_close_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_input_stream_get_close_fd" g_unix_input_stream_get_close_fd :: 
    Ptr UnixInputStream ->                  -- stream : TInterface (Name {namespace = "Gio", name = "UnixInputStream"})
    IO CInt

-- | Returns whether the file descriptor of /@stream@/ will be
-- closed when the stream is closed.
-- 
-- /Since: 2.20/
unixInputStreamGetCloseFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixInputStream.UnixInputStream'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the file descriptor is closed when done
unixInputStreamGetCloseFd stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_unix_input_stream_get_close_fd stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data UnixInputStreamGetCloseFdMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsUnixInputStream a) => O.OverloadedMethod UnixInputStreamGetCloseFdMethodInfo a signature where
    overloadedMethod = unixInputStreamGetCloseFd

instance O.OverloadedMethodInfo UnixInputStreamGetCloseFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixInputStream.unixInputStreamGetCloseFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixInputStream.html#v:unixInputStreamGetCloseFd"
        })


#endif

-- method UnixInputStream::get_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_input_stream_get_fd" g_unix_input_stream_get_fd :: 
    Ptr UnixInputStream ->                  -- stream : TInterface (Name {namespace = "Gio", name = "UnixInputStream"})
    IO Int32

-- | Return the UNIX file descriptor that the stream reads from.
-- 
-- /Since: 2.20/
unixInputStreamGetFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixInputStream.UnixInputStream'
    -> m Int32
    -- ^ __Returns:__ The file descriptor of /@stream@/
unixInputStreamGetFd stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_unix_input_stream_get_fd stream'
    touchManagedPtr stream
    return result

#if defined(ENABLE_OVERLOADING)
data UnixInputStreamGetFdMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsUnixInputStream a) => O.OverloadedMethod UnixInputStreamGetFdMethodInfo a signature where
    overloadedMethod = unixInputStreamGetFd

instance O.OverloadedMethodInfo UnixInputStreamGetFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixInputStream.unixInputStreamGetFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixInputStream.html#v:unixInputStreamGetFd"
        })


#endif

-- method UnixInputStream::set_close_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "close_fd"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to close the file descriptor when done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_input_stream_set_close_fd" g_unix_input_stream_set_close_fd :: 
    Ptr UnixInputStream ->                  -- stream : TInterface (Name {namespace = "Gio", name = "UnixInputStream"})
    CInt ->                                 -- close_fd : TBasicType TBoolean
    IO ()

-- | Sets whether the file descriptor of /@stream@/ shall be closed
-- when the stream is closed.
-- 
-- /Since: 2.20/
unixInputStreamSetCloseFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.UnixInputStream.UnixInputStream'
    -> Bool
    -- ^ /@closeFd@/: 'P.True' to close the file descriptor when done
    -> m ()
unixInputStreamSetCloseFd stream closeFd = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    let closeFd' = (P.fromIntegral . P.fromEnum) closeFd
    g_unix_input_stream_set_close_fd stream' closeFd'
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data UnixInputStreamSetCloseFdMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsUnixInputStream a) => O.OverloadedMethod UnixInputStreamSetCloseFdMethodInfo a signature where
    overloadedMethod = unixInputStreamSetCloseFd

instance O.OverloadedMethodInfo UnixInputStreamSetCloseFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixInputStream.unixInputStreamSetCloseFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-UnixInputStream.html#v:unixInputStreamSetCloseFd"
        })


#endif


