{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An abstract interface representing a password used in TLS. Often used in
-- user interaction such as unlocking a key storage token.
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.TlsPassword
    ( 

-- * Exported types
    TlsPassword(..)                         ,
    IsTlsPassword                           ,
    toTlsPassword                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Gio.Objects.TlsPassword#g:method:getDescription"), [getFlags]("GI.Gio.Objects.TlsPassword#g:method:getFlags"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWarning]("GI.Gio.Objects.TlsPassword#g:method:getWarning").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Gio.Objects.TlsPassword#g:method:setDescription"), [setFlags]("GI.Gio.Objects.TlsPassword#g:method:setFlags"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setValue]("GI.Gio.Objects.TlsPassword#g:method:setValue"), [setValueFull]("GI.Gio.Objects.TlsPassword#g:method:setValueFull"), [setWarning]("GI.Gio.Objects.TlsPassword#g:method:setWarning").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsPasswordMethod                ,
#endif

-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordGetDescriptionMethodInfo     ,
#endif
    tlsPasswordGetDescription               ,


-- ** getFlags #method:getFlags#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordGetFlagsMethodInfo           ,
#endif
    tlsPasswordGetFlags                     ,


-- ** getWarning #method:getWarning#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordGetWarningMethodInfo         ,
#endif
    tlsPasswordGetWarning                   ,


-- ** new #method:new#

    tlsPasswordNew                          ,


-- ** setDescription #method:setDescription#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordSetDescriptionMethodInfo     ,
#endif
    tlsPasswordSetDescription               ,


-- ** setFlags #method:setFlags#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordSetFlagsMethodInfo           ,
#endif
    tlsPasswordSetFlags                     ,


-- ** setValue #method:setValue#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordSetValueMethodInfo           ,
#endif
    tlsPasswordSetValue                     ,


-- ** setValueFull #method:setValueFull#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordSetValueFullMethodInfo       ,
#endif
    tlsPasswordSetValueFull                 ,


-- ** setWarning #method:setWarning#

#if defined(ENABLE_OVERLOADING)
    TlsPasswordSetWarningMethodInfo         ,
#endif
    tlsPasswordSetWarning                   ,




 -- * Properties


-- ** description #attr:description#
-- | Description of what the password is for.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsPasswordDescriptionPropertyInfo      ,
#endif
    constructTlsPasswordDescription         ,
    getTlsPasswordDescription               ,
    setTlsPasswordDescription               ,
#if defined(ENABLE_OVERLOADING)
    tlsPasswordDescription                  ,
#endif


-- ** flags #attr:flags#
-- | Flags about the password.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsPasswordFlagsPropertyInfo            ,
#endif
    constructTlsPasswordFlags               ,
    getTlsPasswordFlags                     ,
    setTlsPasswordFlags                     ,
#if defined(ENABLE_OVERLOADING)
    tlsPasswordFlags                        ,
#endif


-- ** warning #attr:warning#
-- | Warning about the password.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsPasswordWarningPropertyInfo          ,
#endif
    constructTlsPasswordWarning             ,
    getTlsPasswordWarning                   ,
    setTlsPasswordWarning                   ,
#if defined(ENABLE_OVERLOADING)
    tlsPasswordWarning                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags

#endif

-- | Memory-managed wrapper type.
newtype TlsPassword = TlsPassword (SP.ManagedPtr TlsPassword)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsPassword where
    toManagedPtr (TlsPassword p) = p

foreign import ccall "g_tls_password_get_type"
    c_g_tls_password_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsPassword where
    glibType = c_g_tls_password_get_type

instance B.Types.GObject TlsPassword

-- | Type class for types which can be safely cast to `TlsPassword`, for instance with `toTlsPassword`.
class (SP.GObject o, O.IsDescendantOf TlsPassword o) => IsTlsPassword o
instance (SP.GObject o, O.IsDescendantOf TlsPassword o) => IsTlsPassword o

instance O.HasParentTypes TlsPassword
type instance O.ParentTypes TlsPassword = '[GObject.Object.Object]

-- | Cast to `TlsPassword`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTlsPassword :: (MIO.MonadIO m, IsTlsPassword o) => o -> m TlsPassword
toTlsPassword = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsPassword

-- | Convert 'TlsPassword' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsPassword) where
    gvalueGType_ = c_g_tls_password_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsPassword)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsPassword)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsPassword ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsPasswordMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsPasswordMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsPasswordMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsPasswordMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsPasswordMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsPasswordMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsPasswordMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsPasswordMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsPasswordMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsPasswordMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsPasswordMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsPasswordMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsPasswordMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsPasswordMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsPasswordMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsPasswordMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsPasswordMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsPasswordMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsPasswordMethod "getDescription" o = TlsPasswordGetDescriptionMethodInfo
    ResolveTlsPasswordMethod "getFlags" o = TlsPasswordGetFlagsMethodInfo
    ResolveTlsPasswordMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsPasswordMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsPasswordMethod "getWarning" o = TlsPasswordGetWarningMethodInfo
    ResolveTlsPasswordMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsPasswordMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsPasswordMethod "setDescription" o = TlsPasswordSetDescriptionMethodInfo
    ResolveTlsPasswordMethod "setFlags" o = TlsPasswordSetFlagsMethodInfo
    ResolveTlsPasswordMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsPasswordMethod "setValue" o = TlsPasswordSetValueMethodInfo
    ResolveTlsPasswordMethod "setValueFull" o = TlsPasswordSetValueFullMethodInfo
    ResolveTlsPasswordMethod "setWarning" o = TlsPasswordSetWarningMethodInfo
    ResolveTlsPasswordMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsPasswordMethod t TlsPassword, O.OverloadedMethod info TlsPassword p) => OL.IsLabel t (TlsPassword -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsPasswordMethod t TlsPassword, O.OverloadedMethod info TlsPassword p, R.HasField t TlsPassword p) => R.HasField t TlsPassword p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsPasswordMethod t TlsPassword, O.OverloadedMethodInfo info TlsPassword) => OL.IsLabel t (O.MethodProxy info TlsPassword) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "description"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsPassword #description
-- @
getTlsPasswordDescription :: (MonadIO m, IsTlsPassword o) => o -> m T.Text
getTlsPasswordDescription obj = MIO.liftIO $ checkUnexpectedNothing "getTlsPasswordDescription" $ B.Properties.getObjectPropertyString obj "description"

-- | Set the value of the “@description@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsPassword [ #description 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsPasswordDescription :: (MonadIO m, IsTlsPassword o) => o -> T.Text -> m ()
setTlsPasswordDescription obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "description" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@description@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsPasswordDescription :: (IsTlsPassword o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsPasswordDescription val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "description" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsPasswordDescriptionPropertyInfo
instance AttrInfo TlsPasswordDescriptionPropertyInfo where
    type AttrAllowedOps TlsPasswordDescriptionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsPasswordDescriptionPropertyInfo = IsTlsPassword
    type AttrSetTypeConstraint TlsPasswordDescriptionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsPasswordDescriptionPropertyInfo = (~) T.Text
    type AttrTransferType TlsPasswordDescriptionPropertyInfo = T.Text
    type AttrGetType TlsPasswordDescriptionPropertyInfo = T.Text
    type AttrLabel TlsPasswordDescriptionPropertyInfo = "description"
    type AttrOrigin TlsPasswordDescriptionPropertyInfo = TlsPassword
    attrGet = getTlsPasswordDescription
    attrSet = setTlsPasswordDescription
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsPasswordDescription
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.description"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#g:attr:description"
        })
#endif

-- VVV Prop "flags"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsPasswordFlags"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsPassword #flags
-- @
getTlsPasswordFlags :: (MonadIO m, IsTlsPassword o) => o -> m [Gio.Flags.TlsPasswordFlags]
getTlsPasswordFlags obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "flags"

-- | Set the value of the “@flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsPassword [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsPasswordFlags :: (MonadIO m, IsTlsPassword o) => o -> [Gio.Flags.TlsPasswordFlags] -> m ()
setTlsPasswordFlags obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "flags" val

-- | Construct a `GValueConstruct` with valid value for the “@flags@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsPasswordFlags :: (IsTlsPassword o, MIO.MonadIO m) => [Gio.Flags.TlsPasswordFlags] -> m (GValueConstruct o)
constructTlsPasswordFlags val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "flags" val

#if defined(ENABLE_OVERLOADING)
data TlsPasswordFlagsPropertyInfo
instance AttrInfo TlsPasswordFlagsPropertyInfo where
    type AttrAllowedOps TlsPasswordFlagsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsPasswordFlagsPropertyInfo = IsTlsPassword
    type AttrSetTypeConstraint TlsPasswordFlagsPropertyInfo = (~) [Gio.Flags.TlsPasswordFlags]
    type AttrTransferTypeConstraint TlsPasswordFlagsPropertyInfo = (~) [Gio.Flags.TlsPasswordFlags]
    type AttrTransferType TlsPasswordFlagsPropertyInfo = [Gio.Flags.TlsPasswordFlags]
    type AttrGetType TlsPasswordFlagsPropertyInfo = [Gio.Flags.TlsPasswordFlags]
    type AttrLabel TlsPasswordFlagsPropertyInfo = "flags"
    type AttrOrigin TlsPasswordFlagsPropertyInfo = TlsPassword
    attrGet = getTlsPasswordFlags
    attrSet = setTlsPasswordFlags
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsPasswordFlags
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#g:attr:flags"
        })
#endif

-- VVV Prop "warning"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@warning@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsPassword #warning
-- @
getTlsPasswordWarning :: (MonadIO m, IsTlsPassword o) => o -> m T.Text
getTlsPasswordWarning obj = MIO.liftIO $ checkUnexpectedNothing "getTlsPasswordWarning" $ B.Properties.getObjectPropertyString obj "warning"

-- | Set the value of the “@warning@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsPassword [ #warning 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsPasswordWarning :: (MonadIO m, IsTlsPassword o) => o -> T.Text -> m ()
setTlsPasswordWarning obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "warning" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@warning@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsPasswordWarning :: (IsTlsPassword o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsPasswordWarning val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "warning" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsPasswordWarningPropertyInfo
instance AttrInfo TlsPasswordWarningPropertyInfo where
    type AttrAllowedOps TlsPasswordWarningPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsPasswordWarningPropertyInfo = IsTlsPassword
    type AttrSetTypeConstraint TlsPasswordWarningPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsPasswordWarningPropertyInfo = (~) T.Text
    type AttrTransferType TlsPasswordWarningPropertyInfo = T.Text
    type AttrGetType TlsPasswordWarningPropertyInfo = T.Text
    type AttrLabel TlsPasswordWarningPropertyInfo = "warning"
    type AttrOrigin TlsPasswordWarningPropertyInfo = TlsPassword
    attrGet = getTlsPasswordWarning
    attrSet = setTlsPasswordWarning
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsPasswordWarning
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.warning"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#g:attr:warning"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsPassword
type instance O.AttributeList TlsPassword = TlsPasswordAttributeList
type TlsPasswordAttributeList = ('[ '("description", TlsPasswordDescriptionPropertyInfo), '("flags", TlsPasswordFlagsPropertyInfo), '("warning", TlsPasswordWarningPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsPasswordDescription :: AttrLabelProxy "description"
tlsPasswordDescription = AttrLabelProxy

tlsPasswordFlags :: AttrLabelProxy "flags"
tlsPasswordFlags = AttrLabelProxy

tlsPasswordWarning :: AttrLabelProxy "warning"
tlsPasswordWarning = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsPassword = TlsPasswordSignalList
type TlsPasswordSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TlsPassword::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPasswordFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the password flags" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "description of what the password is for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "TlsPassword" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_new" g_tls_password_new :: 
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "TlsPasswordFlags"})
    CString ->                              -- description : TBasicType TUTF8
    IO (Ptr TlsPassword)

-- | Create a new t'GI.Gio.Objects.TlsPassword.TlsPassword' object.
tlsPasswordNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Gio.Flags.TlsPasswordFlags]
    -- ^ /@flags@/: the password flags
    -> T.Text
    -- ^ /@description@/: description of what the password is for
    -> m TlsPassword
    -- ^ __Returns:__ The newly allocated password object
tlsPasswordNew flags description = liftIO $ do
    let flags' = gflagsToWord flags
    description' <- textToCString description
    result <- g_tls_password_new flags' description'
    checkUnexpectedReturnNULL "tlsPasswordNew" result
    result' <- (wrapObject TlsPassword) result
    freeMem description'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsPassword::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_get_description" g_tls_password_get_description :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    IO CString

-- | Get a description string about what the password will be used for.
-- 
-- /Since: 2.30/
tlsPasswordGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> m T.Text
    -- ^ __Returns:__ The description of the password.
tlsPasswordGetDescription password = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    result <- g_tls_password_get_description password'
    checkUnexpectedReturnNULL "tlsPasswordGetDescription" result
    result' <- cstringToText result
    touchManagedPtr password
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsPasswordGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordGetDescriptionMethodInfo a signature where
    overloadedMethod = tlsPasswordGetDescription

instance O.OverloadedMethodInfo TlsPasswordGetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordGetDescription"
        })


#endif

-- method TlsPassword::get_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsPasswordFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_get_flags" g_tls_password_get_flags :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    IO CUInt

-- | Get flags about the password.
-- 
-- /Since: 2.30/
tlsPasswordGetFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> m [Gio.Flags.TlsPasswordFlags]
    -- ^ __Returns:__ The flags about the password.
tlsPasswordGetFlags password = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    result <- g_tls_password_get_flags password'
    let result' = wordToGFlags result
    touchManagedPtr password
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsPasswordGetFlagsMethodInfo
instance (signature ~ (m [Gio.Flags.TlsPasswordFlags]), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordGetFlagsMethodInfo a signature where
    overloadedMethod = tlsPasswordGetFlags

instance O.OverloadedMethodInfo TlsPasswordGetFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordGetFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordGetFlags"
        })


#endif

-- method TlsPassword::get_warning
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_get_warning" g_tls_password_get_warning :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    IO CString

-- | Get a user readable translated warning. Usually this warning is a
-- representation of the password flags returned from
-- 'GI.Gio.Objects.TlsPassword.tlsPasswordGetFlags'.
-- 
-- /Since: 2.30/
tlsPasswordGetWarning ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> m T.Text
    -- ^ __Returns:__ The warning.
tlsPasswordGetWarning password = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    result <- g_tls_password_get_warning password'
    checkUnexpectedReturnNULL "tlsPasswordGetWarning" result
    result' <- cstringToText result
    touchManagedPtr password
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsPasswordGetWarningMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordGetWarningMethodInfo a signature where
    overloadedMethod = tlsPasswordGetWarning

instance O.OverloadedMethodInfo TlsPasswordGetWarningMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordGetWarning",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordGetWarning"
        })


#endif

-- method TlsPassword::set_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The description of the password"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_set_description" g_tls_password_set_description :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    CString ->                              -- description : TBasicType TUTF8
    IO ()

-- | Set a description string about what the password will be used for.
-- 
-- /Since: 2.30/
tlsPasswordSetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> T.Text
    -- ^ /@description@/: The description of the password
    -> m ()
tlsPasswordSetDescription password description = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    description' <- textToCString description
    g_tls_password_set_description password' description'
    touchManagedPtr password
    freeMem description'
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsPasswordSetDescriptionMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordSetDescriptionMethodInfo a signature where
    overloadedMethod = tlsPasswordSetDescription

instance O.OverloadedMethodInfo TlsPasswordSetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordSetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordSetDescription"
        })


#endif

-- method TlsPassword::set_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPasswordFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The flags about the password"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_set_flags" g_tls_password_set_flags :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "TlsPasswordFlags"})
    IO ()

-- | Set flags about the password.
-- 
-- /Since: 2.30/
tlsPasswordSetFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> [Gio.Flags.TlsPasswordFlags]
    -- ^ /@flags@/: The flags about the password
    -> m ()
tlsPasswordSetFlags password flags = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    let flags' = gflagsToWord flags
    g_tls_password_set_flags password' flags'
    touchManagedPtr password
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsPasswordSetFlagsMethodInfo
instance (signature ~ ([Gio.Flags.TlsPasswordFlags] -> m ()), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordSetFlagsMethodInfo a signature where
    overloadedMethod = tlsPasswordSetFlags

instance O.OverloadedMethodInfo TlsPasswordSetFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordSetFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordSetFlags"
        })


#endif

-- method TlsPassword::set_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new password value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the password, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of the password, or -1"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_set_value" g_tls_password_set_value :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    Ptr Word8 ->                            -- value : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- length : TBasicType TSSize
    IO ()

-- | Set the value for this password. The /@value@/ will be copied by the password
-- object.
-- 
-- Specify the /@length@/, for a non-nul-terminated password. Pass -1 as
-- /@length@/ if using a nul-terminated password, and /@length@/ will be
-- calculated automatically. (Note that the terminating nul is not
-- considered part of the password in this case.)
-- 
-- /Since: 2.30/
tlsPasswordSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> ByteString
    -- ^ /@value@/: the new password value
    -> m ()
tlsPasswordSetValue password value = liftIO $ do
    let length_ = fromIntegral $ B.length value
    password' <- unsafeManagedPtrCastPtr password
    value' <- packByteString value
    g_tls_password_set_value password' value' length_
    touchManagedPtr password
    freeMem value'
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsPasswordSetValueMethodInfo
instance (signature ~ (ByteString -> m ()), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordSetValueMethodInfo a signature where
    overloadedMethod = tlsPasswordSetValue

instance O.OverloadedMethodInfo TlsPasswordSetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordSetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordSetValue"
        })


#endif

-- method TlsPassword::set_value_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value for the password"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the password, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a function to use to free the password."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of the password, or -1"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_set_value_full" g_tls_password_set_value_full :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    Ptr Word8 ->                            -- value : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- length : TBasicType TSSize
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Provide the value for this password.
-- 
-- The /@value@/ will be owned by the password object, and later freed using
-- the /@destroy@/ function callback.
-- 
-- Specify the /@length@/, for a non-nul-terminated password. Pass -1 as
-- /@length@/ if using a nul-terminated password, and /@length@/ will be
-- calculated automatically. (Note that the terminating nul is not
-- considered part of the password in this case.)
-- 
-- /Since: 2.30/
tlsPasswordSetValueFull ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> ByteString
    -- ^ /@value@/: the value for the password
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroy@/: a function to use to free the password.
    -> m ()
tlsPasswordSetValueFull password value destroy = liftIO $ do
    let length_ = fromIntegral $ B.length value
    password' <- unsafeManagedPtrCastPtr password
    value' <- packByteString value
    maybeDestroy <- case destroy of
        Nothing -> return FP.nullFunPtr
        Just jDestroy -> do
            ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) (GLib.Callbacks.drop_closures_DestroyNotify jDestroy))
            poke ptrdestroy jDestroy'
            return jDestroy'
    g_tls_password_set_value_full password' value' length_ maybeDestroy
    touchManagedPtr password
    freeMem value'
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsPasswordSetValueFullMethodInfo
instance (signature ~ (ByteString -> Maybe (GLib.Callbacks.DestroyNotify) -> m ()), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordSetValueFullMethodInfo a signature where
    overloadedMethod = tlsPasswordSetValueFull

instance O.OverloadedMethodInfo TlsPasswordSetValueFullMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordSetValueFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordSetValueFull"
        })


#endif

-- method TlsPassword::set_warning
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "password"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsPassword" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsPassword object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "warning"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The user readable warning"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_password_set_warning" g_tls_password_set_warning :: 
    Ptr TlsPassword ->                      -- password : TInterface (Name {namespace = "Gio", name = "TlsPassword"})
    CString ->                              -- warning : TBasicType TUTF8
    IO ()

-- | Set a user readable translated warning. Usually this warning is a
-- representation of the password flags returned from
-- 'GI.Gio.Objects.TlsPassword.tlsPasswordGetFlags'.
-- 
-- /Since: 2.30/
tlsPasswordSetWarning ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsPassword a) =>
    a
    -- ^ /@password@/: a t'GI.Gio.Objects.TlsPassword.TlsPassword' object
    -> T.Text
    -- ^ /@warning@/: The user readable warning
    -> m ()
tlsPasswordSetWarning password warning = liftIO $ do
    password' <- unsafeManagedPtrCastPtr password
    warning' <- textToCString warning
    g_tls_password_set_warning password' warning'
    touchManagedPtr password
    freeMem warning'
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsPasswordSetWarningMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsTlsPassword a) => O.OverloadedMethod TlsPasswordSetWarningMethodInfo a signature where
    overloadedMethod = tlsPasswordSetWarning

instance O.OverloadedMethodInfo TlsPasswordSetWarningMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsPassword.tlsPasswordSetWarning",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsPassword.html#v:tlsPasswordSetWarning"
        })


#endif


