{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A certificate used for TLS authentication and encryption.
-- This can represent either a certificate only (eg, the certificate
-- received by a client from a server), or the combination of
-- a certificate and a private key (which is needed when acting as a
-- t'GI.Gio.Interfaces.TlsServerConnection.TlsServerConnection').
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.TlsCertificate
    ( 

-- * Exported types
    TlsCertificate(..)                      ,
    IsTlsCertificate                        ,
    toTlsCertificate                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSame]("GI.Gio.Objects.TlsCertificate#g:method:isSame"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [verify]("GI.Gio.Objects.TlsCertificate#g:method:verify"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDnsNames]("GI.Gio.Objects.TlsCertificate#g:method:getDnsNames"), [getIpAddresses]("GI.Gio.Objects.TlsCertificate#g:method:getIpAddresses"), [getIssuer]("GI.Gio.Objects.TlsCertificate#g:method:getIssuer"), [getIssuerName]("GI.Gio.Objects.TlsCertificate#g:method:getIssuerName"), [getNotValidAfter]("GI.Gio.Objects.TlsCertificate#g:method:getNotValidAfter"), [getNotValidBefore]("GI.Gio.Objects.TlsCertificate#g:method:getNotValidBefore"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSubjectName]("GI.Gio.Objects.TlsCertificate#g:method:getSubjectName").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsCertificateMethod             ,
#endif

-- ** getDnsNames #method:getDnsNames#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetDnsNamesMethodInfo     ,
#endif
    tlsCertificateGetDnsNames               ,


-- ** getIpAddresses #method:getIpAddresses#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetIpAddressesMethodInfo  ,
#endif
    tlsCertificateGetIpAddresses            ,


-- ** getIssuer #method:getIssuer#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetIssuerMethodInfo       ,
#endif
    tlsCertificateGetIssuer                 ,


-- ** getIssuerName #method:getIssuerName#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetIssuerNameMethodInfo   ,
#endif
    tlsCertificateGetIssuerName             ,


-- ** getNotValidAfter #method:getNotValidAfter#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetNotValidAfterMethodInfo,
#endif
    tlsCertificateGetNotValidAfter          ,


-- ** getNotValidBefore #method:getNotValidBefore#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetNotValidBeforeMethodInfo,
#endif
    tlsCertificateGetNotValidBefore         ,


-- ** getSubjectName #method:getSubjectName#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateGetSubjectNameMethodInfo  ,
#endif
    tlsCertificateGetSubjectName            ,


-- ** isSame #method:isSame#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateIsSameMethodInfo          ,
#endif
    tlsCertificateIsSame                    ,


-- ** listNewFromFile #method:listNewFromFile#

    tlsCertificateListNewFromFile           ,


-- ** newFromFile #method:newFromFile#

    tlsCertificateNewFromFile               ,


-- ** newFromFileWithPassword #method:newFromFileWithPassword#

    tlsCertificateNewFromFileWithPassword   ,


-- ** newFromFiles #method:newFromFiles#

    tlsCertificateNewFromFiles              ,


-- ** newFromPem #method:newFromPem#

    tlsCertificateNewFromPem                ,


-- ** newFromPkcs11Uris #method:newFromPkcs11Uris#

    tlsCertificateNewFromPkcs11Uris         ,


-- ** newFromPkcs12 #method:newFromPkcs12#

    tlsCertificateNewFromPkcs12             ,


-- ** verify #method:verify#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateVerifyMethodInfo          ,
#endif
    tlsCertificateVerify                    ,




 -- * Properties


-- ** certificate #attr:certificate#
-- | The DER (binary) encoded representation of the certificate.
-- This property and the [TlsCertificate:certificatePem]("GI.Gio.Objects.TlsCertificate#g:attr:certificatePem") property
-- represent the same data, just in different forms.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateCertificatePropertyInfo   ,
#endif
    constructTlsCertificateCertificate      ,
    getTlsCertificateCertificate            ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateCertificate               ,
#endif


-- ** certificatePem #attr:certificatePem#
-- | The PEM (ASCII) encoded representation of the certificate.
-- This property and the [TlsCertificate:certificate]("GI.Gio.Objects.TlsCertificate#g:attr:certificate")
-- property represent the same data, just in different forms.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateCertificatePemPropertyInfo,
#endif
    constructTlsCertificateCertificatePem   ,
    getTlsCertificateCertificatePem         ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateCertificatePem            ,
#endif


-- ** dnsNames #attr:dnsNames#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateDnsNamesPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    tlsCertificateDnsNames                  ,
#endif


-- ** ipAddresses #attr:ipAddresses#

#if defined(ENABLE_OVERLOADING)
    TlsCertificateIpAddressesPropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    tlsCertificateIpAddresses               ,
#endif


-- ** issuer #attr:issuer#
-- | A t'GI.Gio.Objects.TlsCertificate.TlsCertificate' representing the entity that issued this
-- certificate. If 'P.Nothing', this means that the certificate is either
-- self-signed, or else the certificate of the issuer is not
-- available.
-- 
-- Beware the issuer certificate may not be the same as the
-- certificate that would actually be used to construct a valid
-- certification path during certificate verification.
-- <https://datatracker.ietf.org/doc/html/rfc4158 RFC 4158> explains
-- why an issuer certificate cannot be naively assumed to be part of the
-- the certification path (though GLib\'s TLS backends may not follow the
-- path building strategies outlined in this RFC). Due to the complexity
-- of certification path building, GLib does not provide any way to know
-- which certification path will actually be used. Accordingly, this
-- property cannot be used to make security-related decisions. Only
-- GLib itself should make security decisions about TLS certificates.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateIssuerPropertyInfo        ,
#endif
    constructTlsCertificateIssuer           ,
    getTlsCertificateIssuer                 ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateIssuer                    ,
#endif


-- ** issuerName #attr:issuerName#
-- | The issuer from the certificate,
-- 'P.Nothing' if unavailable.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateIssuerNamePropertyInfo    ,
#endif
    getTlsCertificateIssuerName             ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateIssuerName                ,
#endif


-- ** notValidAfter #attr:notValidAfter#
-- | The time at which this cert is no longer valid,
-- 'P.Nothing' if unavailable.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateNotValidAfterPropertyInfo ,
#endif
    getTlsCertificateNotValidAfter          ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateNotValidAfter             ,
#endif


-- ** notValidBefore #attr:notValidBefore#
-- | The time at which this cert is considered to be valid,
-- 'P.Nothing' if unavailable.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateNotValidBeforePropertyInfo,
#endif
    getTlsCertificateNotValidBefore         ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateNotValidBefore            ,
#endif


-- ** password #attr:password#
-- | An optional password used when constructed with GTlsCertificate:pkcs12-data.
-- 
-- /Since: 2.72/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePasswordPropertyInfo      ,
#endif
    constructTlsCertificatePassword         ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePassword                  ,
#endif


-- ** pkcs11Uri #attr:pkcs11Uri#
-- | A URI referencing the <https://docs.oasis-open.org/pkcs11/pkcs11-base/v3.0/os/pkcs11-base-v3.0-os.html PKCS \#11>
-- objects containing an X.509 certificate and optionally a private key.
-- 
-- If 'P.Nothing', the certificate is either not backed by PKCS #11 or the
-- t'GI.Gio.Interfaces.TlsBackend.TlsBackend' does not support PKCS #11.
-- 
-- /Since: 2.68/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePkcs11UriPropertyInfo     ,
#endif
    constructTlsCertificatePkcs11Uri        ,
    getTlsCertificatePkcs11Uri              ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePkcs11Uri                 ,
#endif


-- ** pkcs12Data #attr:pkcs12Data#
-- | The PKCS @/12/@ formatted data used to construct the object.
-- 
-- See also: 'GI.Gio.Objects.TlsCertificate.tlsCertificateNewFromPkcs12'
-- 
-- /Since: 2.72/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePkcs12DataPropertyInfo    ,
#endif
    constructTlsCertificatePkcs12Data       ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePkcs12Data                ,
#endif


-- ** privateKey #attr:privateKey#
-- | The DER (binary) encoded representation of the certificate\'s
-- private key, in either <https://datatracker.ietf.org/doc/html/rfc8017 PKCS \#1 format>
-- or unencrypted <https://datatracker.ietf.org/doc/html/rfc5208 PKCS \#8 format.>
-- PKCS #8 format is supported since 2.32; earlier releases only
-- support PKCS #1. You can use the @openssl rsa@ tool to convert
-- PKCS #8 keys to PKCS #1.
-- 
-- This property (or the [TlsCertificate:privateKeyPem]("GI.Gio.Objects.TlsCertificate#g:attr:privateKeyPem") property)
-- can be set when constructing a key (for example, from a file).
-- Since GLib 2.70, it is now also readable; however, be aware that if
-- the private key is backed by a PKCS #11 URI – for example, if it
-- is stored on a smartcard – then this property will be 'P.Nothing'. If so,
-- the private key must be referenced via its PKCS #11 URI,
-- [TlsCertificate:privateKeyPkcs11Uri]("GI.Gio.Objects.TlsCertificate#g:attr:privateKeyPkcs11Uri"). You must check both
-- properties to see if the certificate really has a private key.
-- When this property is read, the output format will be unencrypted
-- PKCS #8.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePrivateKeyPropertyInfo    ,
#endif
    constructTlsCertificatePrivateKey       ,
    getTlsCertificatePrivateKey             ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePrivateKey                ,
#endif


-- ** privateKeyPem #attr:privateKeyPem#
-- | The PEM (ASCII) encoded representation of the certificate\'s
-- private key in either <https://datatracker.ietf.org/doc/html/rfc8017 PKCS \#1 format>
-- (\"@BEGIN RSA PRIVATE KEY@\") or unencrypted
-- <https://datatracker.ietf.org/doc/html/rfc5208 PKCS \#8 format>
-- (\"@BEGIN PRIVATE KEY@\"). PKCS #8 format is supported since 2.32;
-- earlier releases only support PKCS #1. You can use the @openssl rsa@
-- tool to convert PKCS #8 keys to PKCS #1.
-- 
-- This property (or the [TlsCertificate:privateKey]("GI.Gio.Objects.TlsCertificate#g:attr:privateKey") property)
-- can be set when constructing a key (for example, from a file).
-- Since GLib 2.70, it is now also readable; however, be aware that if
-- the private key is backed by a PKCS #11 URI - for example, if it
-- is stored on a smartcard - then this property will be 'P.Nothing'. If so,
-- the private key must be referenced via its PKCS #11 URI,
-- [TlsCertificate:privateKeyPkcs11Uri]("GI.Gio.Objects.TlsCertificate#g:attr:privateKeyPkcs11Uri"). You must check both
-- properties to see if the certificate really has a private key.
-- When this property is read, the output format will be unencrypted
-- PKCS #8.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePrivateKeyPemPropertyInfo ,
#endif
    constructTlsCertificatePrivateKeyPem    ,
    getTlsCertificatePrivateKeyPem          ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePrivateKeyPem             ,
#endif


-- ** privateKeyPkcs11Uri #attr:privateKeyPkcs11Uri#
-- | A URI referencing a <https://docs.oasis-open.org/pkcs11/pkcs11-base/v3.0/os/pkcs11-base-v3.0-os.html PKCS \#11>
-- object containing a private key.
-- 
-- /Since: 2.68/

#if defined(ENABLE_OVERLOADING)
    TlsCertificatePrivateKeyPkcs11UriPropertyInfo,
#endif
    constructTlsCertificatePrivateKeyPkcs11Uri,
    getTlsCertificatePrivateKeyPkcs11Uri    ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificatePrivateKeyPkcs11Uri       ,
#endif


-- ** subjectName #attr:subjectName#
-- | The subject from the cert,
-- 'P.Nothing' if unavailable.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    TlsCertificateSubjectNamePropertyInfo   ,
#endif
    getTlsCertificateSubjectName            ,
#if defined(ENABLE_OVERLOADING)
    tlsCertificateSubjectName               ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress

#endif

-- | Memory-managed wrapper type.
newtype TlsCertificate = TlsCertificate (SP.ManagedPtr TlsCertificate)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsCertificate where
    toManagedPtr (TlsCertificate p) = p

foreign import ccall "g_tls_certificate_get_type"
    c_g_tls_certificate_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsCertificate where
    glibType = c_g_tls_certificate_get_type

instance B.Types.GObject TlsCertificate

-- | Type class for types which can be safely cast to `TlsCertificate`, for instance with `toTlsCertificate`.
class (SP.GObject o, O.IsDescendantOf TlsCertificate o) => IsTlsCertificate o
instance (SP.GObject o, O.IsDescendantOf TlsCertificate o) => IsTlsCertificate o

instance O.HasParentTypes TlsCertificate
type instance O.ParentTypes TlsCertificate = '[GObject.Object.Object]

-- | Cast to `TlsCertificate`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTlsCertificate :: (MIO.MonadIO m, IsTlsCertificate o) => o -> m TlsCertificate
toTlsCertificate = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsCertificate

-- | Convert 'TlsCertificate' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsCertificate) where
    gvalueGType_ = c_g_tls_certificate_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsCertificate)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsCertificate)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsCertificate ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsCertificateMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsCertificateMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsCertificateMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsCertificateMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsCertificateMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsCertificateMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsCertificateMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsCertificateMethod "isSame" o = TlsCertificateIsSameMethodInfo
    ResolveTlsCertificateMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsCertificateMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsCertificateMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsCertificateMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsCertificateMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsCertificateMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsCertificateMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsCertificateMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsCertificateMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsCertificateMethod "verify" o = TlsCertificateVerifyMethodInfo
    ResolveTlsCertificateMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsCertificateMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsCertificateMethod "getDnsNames" o = TlsCertificateGetDnsNamesMethodInfo
    ResolveTlsCertificateMethod "getIpAddresses" o = TlsCertificateGetIpAddressesMethodInfo
    ResolveTlsCertificateMethod "getIssuer" o = TlsCertificateGetIssuerMethodInfo
    ResolveTlsCertificateMethod "getIssuerName" o = TlsCertificateGetIssuerNameMethodInfo
    ResolveTlsCertificateMethod "getNotValidAfter" o = TlsCertificateGetNotValidAfterMethodInfo
    ResolveTlsCertificateMethod "getNotValidBefore" o = TlsCertificateGetNotValidBeforeMethodInfo
    ResolveTlsCertificateMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsCertificateMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsCertificateMethod "getSubjectName" o = TlsCertificateGetSubjectNameMethodInfo
    ResolveTlsCertificateMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsCertificateMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsCertificateMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsCertificateMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsCertificateMethod t TlsCertificate, O.OverloadedMethod info TlsCertificate p) => OL.IsLabel t (TlsCertificate -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsCertificateMethod t TlsCertificate, O.OverloadedMethod info TlsCertificate p, R.HasField t TlsCertificate p) => R.HasField t TlsCertificate p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsCertificateMethod t TlsCertificate, O.OverloadedMethodInfo info TlsCertificate) => OL.IsLabel t (O.MethodProxy info TlsCertificate) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "certificate"
   -- Type: TByteArray
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@certificate@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #certificate
-- @
getTlsCertificateCertificate :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe ByteString)
getTlsCertificateCertificate obj = MIO.liftIO $ B.Properties.getObjectPropertyByteArray obj "certificate"

-- | Construct a `GValueConstruct` with valid value for the “@certificate@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificateCertificate :: (IsTlsCertificate o, MIO.MonadIO m) => ByteString -> m (GValueConstruct o)
constructTlsCertificateCertificate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyByteArray "certificate" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificateCertificatePropertyInfo
instance AttrInfo TlsCertificateCertificatePropertyInfo where
    type AttrAllowedOps TlsCertificateCertificatePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateCertificatePropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateCertificatePropertyInfo = (~) ByteString
    type AttrTransferTypeConstraint TlsCertificateCertificatePropertyInfo = (~) ByteString
    type AttrTransferType TlsCertificateCertificatePropertyInfo = ByteString
    type AttrGetType TlsCertificateCertificatePropertyInfo = (Maybe ByteString)
    type AttrLabel TlsCertificateCertificatePropertyInfo = "certificate"
    type AttrOrigin TlsCertificateCertificatePropertyInfo = TlsCertificate
    attrGet = getTlsCertificateCertificate
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificateCertificate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.certificate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:certificate"
        })
#endif

-- VVV Prop "certificate-pem"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@certificate-pem@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #certificatePem
-- @
getTlsCertificateCertificatePem :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificateCertificatePem obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "certificate-pem"

-- | Construct a `GValueConstruct` with valid value for the “@certificate-pem@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificateCertificatePem :: (IsTlsCertificate o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsCertificateCertificatePem val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "certificate-pem" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificateCertificatePemPropertyInfo
instance AttrInfo TlsCertificateCertificatePemPropertyInfo where
    type AttrAllowedOps TlsCertificateCertificatePemPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateCertificatePemPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateCertificatePemPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsCertificateCertificatePemPropertyInfo = (~) T.Text
    type AttrTransferType TlsCertificateCertificatePemPropertyInfo = T.Text
    type AttrGetType TlsCertificateCertificatePemPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificateCertificatePemPropertyInfo = "certificate-pem"
    type AttrOrigin TlsCertificateCertificatePemPropertyInfo = TlsCertificate
    attrGet = getTlsCertificateCertificatePem
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificateCertificatePem
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.certificatePem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:certificatePem"
        })
#endif

-- XXX Generation of property "dns-names" of object "TlsCertificate" failed.
-- Not implemented: Property TlsCertificateDnsNames has unsupported transfer type TransferContainer
#if defined(ENABLE_OVERLOADING)
-- XXX Placeholder
data TlsCertificateDnsNamesPropertyInfo
instance AttrInfo TlsCertificateDnsNamesPropertyInfo where
    type AttrAllowedOps TlsCertificateDnsNamesPropertyInfo = '[]
    type AttrSetTypeConstraint TlsCertificateDnsNamesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateDnsNamesPropertyInfo = (~) ()
    type AttrTransferType TlsCertificateDnsNamesPropertyInfo = ()
    type AttrBaseTypeConstraint TlsCertificateDnsNamesPropertyInfo = (~) ()
    type AttrGetType TlsCertificateDnsNamesPropertyInfo = ()
    type AttrLabel TlsCertificateDnsNamesPropertyInfo = ""
    type AttrOrigin TlsCertificateDnsNamesPropertyInfo = TlsCertificate
    attrGet = undefined
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
#endif

-- XXX Generation of property "ip-addresses" of object "TlsCertificate" failed.
-- Not implemented: Property TlsCertificateIpAddresses has unsupported transfer type TransferContainer
#if defined(ENABLE_OVERLOADING)
-- XXX Placeholder
data TlsCertificateIpAddressesPropertyInfo
instance AttrInfo TlsCertificateIpAddressesPropertyInfo where
    type AttrAllowedOps TlsCertificateIpAddressesPropertyInfo = '[]
    type AttrSetTypeConstraint TlsCertificateIpAddressesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateIpAddressesPropertyInfo = (~) ()
    type AttrTransferType TlsCertificateIpAddressesPropertyInfo = ()
    type AttrBaseTypeConstraint TlsCertificateIpAddressesPropertyInfo = (~) ()
    type AttrGetType TlsCertificateIpAddressesPropertyInfo = ()
    type AttrLabel TlsCertificateIpAddressesPropertyInfo = ""
    type AttrOrigin TlsCertificateIpAddressesPropertyInfo = TlsCertificate
    attrGet = undefined
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
#endif

-- VVV Prop "issuer"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@issuer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #issuer
-- @
getTlsCertificateIssuer :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe TlsCertificate)
getTlsCertificateIssuer obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "issuer" TlsCertificate

-- | Construct a `GValueConstruct` with valid value for the “@issuer@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificateIssuer :: (IsTlsCertificate o, MIO.MonadIO m, IsTlsCertificate a) => a -> m (GValueConstruct o)
constructTlsCertificateIssuer val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "issuer" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificateIssuerPropertyInfo
instance AttrInfo TlsCertificateIssuerPropertyInfo where
    type AttrAllowedOps TlsCertificateIssuerPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateIssuerPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateIssuerPropertyInfo = IsTlsCertificate
    type AttrTransferTypeConstraint TlsCertificateIssuerPropertyInfo = IsTlsCertificate
    type AttrTransferType TlsCertificateIssuerPropertyInfo = TlsCertificate
    type AttrGetType TlsCertificateIssuerPropertyInfo = (Maybe TlsCertificate)
    type AttrLabel TlsCertificateIssuerPropertyInfo = "issuer"
    type AttrOrigin TlsCertificateIssuerPropertyInfo = TlsCertificate
    attrGet = getTlsCertificateIssuer
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo TlsCertificate v
    attrConstruct = constructTlsCertificateIssuer
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.issuer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:issuer"
        })
#endif

-- VVV Prop "issuer-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@issuer-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #issuerName
-- @
getTlsCertificateIssuerName :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificateIssuerName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "issuer-name"

#if defined(ENABLE_OVERLOADING)
data TlsCertificateIssuerNamePropertyInfo
instance AttrInfo TlsCertificateIssuerNamePropertyInfo where
    type AttrAllowedOps TlsCertificateIssuerNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateIssuerNamePropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateIssuerNamePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateIssuerNamePropertyInfo = (~) ()
    type AttrTransferType TlsCertificateIssuerNamePropertyInfo = ()
    type AttrGetType TlsCertificateIssuerNamePropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificateIssuerNamePropertyInfo = "issuer-name"
    type AttrOrigin TlsCertificateIssuerNamePropertyInfo = TlsCertificate
    attrGet = getTlsCertificateIssuerName
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.issuerName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:issuerName"
        })
#endif

-- VVV Prop "not-valid-after"
   -- Type: TInterface (Name {namespace = "GLib", name = "DateTime"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@not-valid-after@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #notValidAfter
-- @
getTlsCertificateNotValidAfter :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe GLib.DateTime.DateTime)
getTlsCertificateNotValidAfter obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "not-valid-after" GLib.DateTime.DateTime

#if defined(ENABLE_OVERLOADING)
data TlsCertificateNotValidAfterPropertyInfo
instance AttrInfo TlsCertificateNotValidAfterPropertyInfo where
    type AttrAllowedOps TlsCertificateNotValidAfterPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateNotValidAfterPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateNotValidAfterPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateNotValidAfterPropertyInfo = (~) ()
    type AttrTransferType TlsCertificateNotValidAfterPropertyInfo = ()
    type AttrGetType TlsCertificateNotValidAfterPropertyInfo = (Maybe GLib.DateTime.DateTime)
    type AttrLabel TlsCertificateNotValidAfterPropertyInfo = "not-valid-after"
    type AttrOrigin TlsCertificateNotValidAfterPropertyInfo = TlsCertificate
    attrGet = getTlsCertificateNotValidAfter
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.notValidAfter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:notValidAfter"
        })
#endif

-- VVV Prop "not-valid-before"
   -- Type: TInterface (Name {namespace = "GLib", name = "DateTime"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@not-valid-before@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #notValidBefore
-- @
getTlsCertificateNotValidBefore :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe GLib.DateTime.DateTime)
getTlsCertificateNotValidBefore obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "not-valid-before" GLib.DateTime.DateTime

#if defined(ENABLE_OVERLOADING)
data TlsCertificateNotValidBeforePropertyInfo
instance AttrInfo TlsCertificateNotValidBeforePropertyInfo where
    type AttrAllowedOps TlsCertificateNotValidBeforePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateNotValidBeforePropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateNotValidBeforePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateNotValidBeforePropertyInfo = (~) ()
    type AttrTransferType TlsCertificateNotValidBeforePropertyInfo = ()
    type AttrGetType TlsCertificateNotValidBeforePropertyInfo = (Maybe GLib.DateTime.DateTime)
    type AttrLabel TlsCertificateNotValidBeforePropertyInfo = "not-valid-before"
    type AttrOrigin TlsCertificateNotValidBeforePropertyInfo = TlsCertificate
    attrGet = getTlsCertificateNotValidBefore
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.notValidBefore"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:notValidBefore"
        })
#endif

-- VVV Prop "password"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Construct a `GValueConstruct` with valid value for the “@password@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePassword :: (IsTlsCertificate o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsCertificatePassword val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "password" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePasswordPropertyInfo
instance AttrInfo TlsCertificatePasswordPropertyInfo where
    type AttrAllowedOps TlsCertificatePasswordPropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePasswordPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePasswordPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsCertificatePasswordPropertyInfo = (~) T.Text
    type AttrTransferType TlsCertificatePasswordPropertyInfo = T.Text
    type AttrGetType TlsCertificatePasswordPropertyInfo = ()
    type AttrLabel TlsCertificatePasswordPropertyInfo = "password"
    type AttrOrigin TlsCertificatePasswordPropertyInfo = TlsCertificate
    attrGet = undefined
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePassword
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.password"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:password"
        })
#endif

-- VVV Prop "pkcs11-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pkcs11-uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #pkcs11Uri
-- @
getTlsCertificatePkcs11Uri :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificatePkcs11Uri obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "pkcs11-uri"

-- | Construct a `GValueConstruct` with valid value for the “@pkcs11-uri@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePkcs11Uri :: (IsTlsCertificate o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsCertificatePkcs11Uri val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "pkcs11-uri" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePkcs11UriPropertyInfo
instance AttrInfo TlsCertificatePkcs11UriPropertyInfo where
    type AttrAllowedOps TlsCertificatePkcs11UriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePkcs11UriPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePkcs11UriPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsCertificatePkcs11UriPropertyInfo = (~) T.Text
    type AttrTransferType TlsCertificatePkcs11UriPropertyInfo = T.Text
    type AttrGetType TlsCertificatePkcs11UriPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificatePkcs11UriPropertyInfo = "pkcs11-uri"
    type AttrOrigin TlsCertificatePkcs11UriPropertyInfo = TlsCertificate
    attrGet = getTlsCertificatePkcs11Uri
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePkcs11Uri
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.pkcs11Uri"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:pkcs11Uri"
        })
#endif

-- VVV Prop "pkcs12-data"
   -- Type: TByteArray
   -- Flags: [PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Construct a `GValueConstruct` with valid value for the “@pkcs12-data@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePkcs12Data :: (IsTlsCertificate o, MIO.MonadIO m) => ByteString -> m (GValueConstruct o)
constructTlsCertificatePkcs12Data val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyByteArray "pkcs12-data" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePkcs12DataPropertyInfo
instance AttrInfo TlsCertificatePkcs12DataPropertyInfo where
    type AttrAllowedOps TlsCertificatePkcs12DataPropertyInfo = '[ 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePkcs12DataPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePkcs12DataPropertyInfo = (~) ByteString
    type AttrTransferTypeConstraint TlsCertificatePkcs12DataPropertyInfo = (~) ByteString
    type AttrTransferType TlsCertificatePkcs12DataPropertyInfo = ByteString
    type AttrGetType TlsCertificatePkcs12DataPropertyInfo = ()
    type AttrLabel TlsCertificatePkcs12DataPropertyInfo = "pkcs12-data"
    type AttrOrigin TlsCertificatePkcs12DataPropertyInfo = TlsCertificate
    attrGet = undefined
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePkcs12Data
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.pkcs12Data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:pkcs12Data"
        })
#endif

-- VVV Prop "private-key"
   -- Type: TByteArray
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@private-key@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #privateKey
-- @
getTlsCertificatePrivateKey :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe ByteString)
getTlsCertificatePrivateKey obj = MIO.liftIO $ B.Properties.getObjectPropertyByteArray obj "private-key"

-- | Construct a `GValueConstruct` with valid value for the “@private-key@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePrivateKey :: (IsTlsCertificate o, MIO.MonadIO m) => ByteString -> m (GValueConstruct o)
constructTlsCertificatePrivateKey val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyByteArray "private-key" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePrivateKeyPropertyInfo
instance AttrInfo TlsCertificatePrivateKeyPropertyInfo where
    type AttrAllowedOps TlsCertificatePrivateKeyPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePrivateKeyPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePrivateKeyPropertyInfo = (~) ByteString
    type AttrTransferTypeConstraint TlsCertificatePrivateKeyPropertyInfo = (~) ByteString
    type AttrTransferType TlsCertificatePrivateKeyPropertyInfo = ByteString
    type AttrGetType TlsCertificatePrivateKeyPropertyInfo = (Maybe ByteString)
    type AttrLabel TlsCertificatePrivateKeyPropertyInfo = "private-key"
    type AttrOrigin TlsCertificatePrivateKeyPropertyInfo = TlsCertificate
    attrGet = getTlsCertificatePrivateKey
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePrivateKey
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.privateKey"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:privateKey"
        })
#endif

-- VVV Prop "private-key-pem"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@private-key-pem@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #privateKeyPem
-- @
getTlsCertificatePrivateKeyPem :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificatePrivateKeyPem obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "private-key-pem"

-- | Construct a `GValueConstruct` with valid value for the “@private-key-pem@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePrivateKeyPem :: (IsTlsCertificate o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsCertificatePrivateKeyPem val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "private-key-pem" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePrivateKeyPemPropertyInfo
instance AttrInfo TlsCertificatePrivateKeyPemPropertyInfo where
    type AttrAllowedOps TlsCertificatePrivateKeyPemPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePrivateKeyPemPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePrivateKeyPemPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsCertificatePrivateKeyPemPropertyInfo = (~) T.Text
    type AttrTransferType TlsCertificatePrivateKeyPemPropertyInfo = T.Text
    type AttrGetType TlsCertificatePrivateKeyPemPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificatePrivateKeyPemPropertyInfo = "private-key-pem"
    type AttrOrigin TlsCertificatePrivateKeyPemPropertyInfo = TlsCertificate
    attrGet = getTlsCertificatePrivateKeyPem
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePrivateKeyPem
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.privateKeyPem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:privateKeyPem"
        })
#endif

-- VVV Prop "private-key-pkcs11-uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@private-key-pkcs11-uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #privateKeyPkcs11Uri
-- @
getTlsCertificatePrivateKeyPkcs11Uri :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificatePrivateKeyPkcs11Uri obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "private-key-pkcs11-uri"

-- | Construct a `GValueConstruct` with valid value for the “@private-key-pkcs11-uri@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsCertificatePrivateKeyPkcs11Uri :: (IsTlsCertificate o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsCertificatePrivateKeyPkcs11Uri val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "private-key-pkcs11-uri" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsCertificatePrivateKeyPkcs11UriPropertyInfo
instance AttrInfo TlsCertificatePrivateKeyPkcs11UriPropertyInfo where
    type AttrAllowedOps TlsCertificatePrivateKeyPkcs11UriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificatePrivateKeyPkcs11UriPropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificatePrivateKeyPkcs11UriPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsCertificatePrivateKeyPkcs11UriPropertyInfo = (~) T.Text
    type AttrTransferType TlsCertificatePrivateKeyPkcs11UriPropertyInfo = T.Text
    type AttrGetType TlsCertificatePrivateKeyPkcs11UriPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificatePrivateKeyPkcs11UriPropertyInfo = "private-key-pkcs11-uri"
    type AttrOrigin TlsCertificatePrivateKeyPkcs11UriPropertyInfo = TlsCertificate
    attrGet = getTlsCertificatePrivateKeyPkcs11Uri
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsCertificatePrivateKeyPkcs11Uri
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.privateKeyPkcs11Uri"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:privateKeyPkcs11Uri"
        })
#endif

-- VVV Prop "subject-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@subject-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsCertificate #subjectName
-- @
getTlsCertificateSubjectName :: (MonadIO m, IsTlsCertificate o) => o -> m (Maybe T.Text)
getTlsCertificateSubjectName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "subject-name"

#if defined(ENABLE_OVERLOADING)
data TlsCertificateSubjectNamePropertyInfo
instance AttrInfo TlsCertificateSubjectNamePropertyInfo where
    type AttrAllowedOps TlsCertificateSubjectNamePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsCertificateSubjectNamePropertyInfo = IsTlsCertificate
    type AttrSetTypeConstraint TlsCertificateSubjectNamePropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsCertificateSubjectNamePropertyInfo = (~) ()
    type AttrTransferType TlsCertificateSubjectNamePropertyInfo = ()
    type AttrGetType TlsCertificateSubjectNamePropertyInfo = (Maybe T.Text)
    type AttrLabel TlsCertificateSubjectNamePropertyInfo = "subject-name"
    type AttrOrigin TlsCertificateSubjectNamePropertyInfo = TlsCertificate
    attrGet = getTlsCertificateSubjectName
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.subjectName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#g:attr:subjectName"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsCertificate
type instance O.AttributeList TlsCertificate = TlsCertificateAttributeList
type TlsCertificateAttributeList = ('[ '("certificate", TlsCertificateCertificatePropertyInfo), '("certificatePem", TlsCertificateCertificatePemPropertyInfo), '("dnsNames", TlsCertificateDnsNamesPropertyInfo), '("ipAddresses", TlsCertificateIpAddressesPropertyInfo), '("issuer", TlsCertificateIssuerPropertyInfo), '("issuerName", TlsCertificateIssuerNamePropertyInfo), '("notValidAfter", TlsCertificateNotValidAfterPropertyInfo), '("notValidBefore", TlsCertificateNotValidBeforePropertyInfo), '("password", TlsCertificatePasswordPropertyInfo), '("pkcs11Uri", TlsCertificatePkcs11UriPropertyInfo), '("pkcs12Data", TlsCertificatePkcs12DataPropertyInfo), '("privateKey", TlsCertificatePrivateKeyPropertyInfo), '("privateKeyPem", TlsCertificatePrivateKeyPemPropertyInfo), '("privateKeyPkcs11Uri", TlsCertificatePrivateKeyPkcs11UriPropertyInfo), '("subjectName", TlsCertificateSubjectNamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsCertificateCertificate :: AttrLabelProxy "certificate"
tlsCertificateCertificate = AttrLabelProxy

tlsCertificateCertificatePem :: AttrLabelProxy "certificatePem"
tlsCertificateCertificatePem = AttrLabelProxy

tlsCertificateDnsNames :: AttrLabelProxy "dnsNames"
tlsCertificateDnsNames = AttrLabelProxy

tlsCertificateIpAddresses :: AttrLabelProxy "ipAddresses"
tlsCertificateIpAddresses = AttrLabelProxy

tlsCertificateIssuer :: AttrLabelProxy "issuer"
tlsCertificateIssuer = AttrLabelProxy

tlsCertificateIssuerName :: AttrLabelProxy "issuerName"
tlsCertificateIssuerName = AttrLabelProxy

tlsCertificateNotValidAfter :: AttrLabelProxy "notValidAfter"
tlsCertificateNotValidAfter = AttrLabelProxy

tlsCertificateNotValidBefore :: AttrLabelProxy "notValidBefore"
tlsCertificateNotValidBefore = AttrLabelProxy

tlsCertificatePassword :: AttrLabelProxy "password"
tlsCertificatePassword = AttrLabelProxy

tlsCertificatePkcs11Uri :: AttrLabelProxy "pkcs11Uri"
tlsCertificatePkcs11Uri = AttrLabelProxy

tlsCertificatePkcs12Data :: AttrLabelProxy "pkcs12Data"
tlsCertificatePkcs12Data = AttrLabelProxy

tlsCertificatePrivateKey :: AttrLabelProxy "privateKey"
tlsCertificatePrivateKey = AttrLabelProxy

tlsCertificatePrivateKeyPem :: AttrLabelProxy "privateKeyPem"
tlsCertificatePrivateKeyPem = AttrLabelProxy

tlsCertificatePrivateKeyPkcs11Uri :: AttrLabelProxy "privateKeyPkcs11Uri"
tlsCertificatePrivateKeyPkcs11Uri = AttrLabelProxy

tlsCertificateSubjectName :: AttrLabelProxy "subjectName"
tlsCertificateSubjectName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsCertificate = TlsCertificateSignalList
type TlsCertificateSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TlsCertificate::new_from_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "file containing a certificate to import"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_file" g_tls_certificate_new_from_file :: 
    CString ->                              -- file : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from the data in /@file@/.
-- 
-- As of 2.72, if the filename ends in @.p12@ or @.pfx@ the data is loaded by
-- 'GI.Gio.Objects.TlsCertificate.tlsCertificateNewFromPkcs12' otherwise it is loaded by
-- 'GI.Gio.Objects.TlsCertificate.tlsCertificateNewFromPem'. See those functions for
-- exact details.
-- 
-- If /@file@/ cannot be read or parsed, the function will return 'P.Nothing' and
-- set /@error@/.
-- 
-- /Since: 2.28/
tlsCertificateNewFromFile ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@file@/: file containing a certificate to import
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromFile file = liftIO $ do
    file' <- stringToCString file
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_file file'
        checkUnexpectedReturnNULL "tlsCertificateNewFromFile" result
        result' <- (wrapObject TlsCertificate) result
        freeMem file'
        return result'
     ) (do
        freeMem file'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::new_from_file_with_password
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "file containing a certificate to import"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "password"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "password for PKCS #12 files"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_file_with_password" g_tls_certificate_new_from_file_with_password :: 
    CString ->                              -- file : TBasicType TFileName
    CString ->                              -- password : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from the data in /@file@/.
-- 
-- If /@file@/ cannot be read or parsed, the function will return 'P.Nothing' and
-- set /@error@/.
-- 
-- Any unknown file types will error with 'GI.Gio.Enums.IOErrorEnumNotSupported'.
-- Currently only @.p12@ and @.pfx@ files are supported.
-- See 'GI.Gio.Objects.TlsCertificate.tlsCertificateNewFromPkcs12' for more details.
-- 
-- /Since: 2.72/
tlsCertificateNewFromFileWithPassword ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@file@/: file containing a certificate to import
    -> T.Text
    -- ^ /@password@/: password for PKCS @/12/@ files
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromFileWithPassword file password = liftIO $ do
    file' <- stringToCString file
    password' <- textToCString password
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_file_with_password file' password'
        checkUnexpectedReturnNULL "tlsCertificateNewFromFileWithPassword" result
        result' <- (wrapObject TlsCertificate) result
        freeMem file'
        freeMem password'
        return result'
     ) (do
        freeMem file'
        freeMem password'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::new_from_files
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "cert_file"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "file containing one or more PEM-encoded\n    certificates to import"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key_file"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file containing a PEM-encoded private key\n    to import"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_files" g_tls_certificate_new_from_files :: 
    CString ->                              -- cert_file : TBasicType TFileName
    CString ->                              -- key_file : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from the PEM-encoded data in /@certFile@/
-- and /@keyFile@/. The returned certificate will be the first certificate
-- found in /@certFile@/. As of GLib 2.44, if /@certFile@/ contains more
-- certificates it will try to load a certificate chain. All
-- certificates will be verified in the order found (top-level
-- certificate should be the last one in the file) and the
-- [TlsCertificate:issuer]("GI.Gio.Objects.TlsCertificate#g:attr:issuer") property of each certificate will be set
-- accordingly if the verification succeeds. If any certificate in the
-- chain cannot be verified, the first certificate in the file will
-- still be returned.
-- 
-- If either file cannot be read or parsed, the function will return
-- 'P.Nothing' and set /@error@/. Otherwise, this behaves like
-- 'GI.Gio.Objects.TlsCertificate.tlsCertificateNewFromPem'.
-- 
-- /Since: 2.28/
tlsCertificateNewFromFiles ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@certFile@/: file containing one or more PEM-encoded
    --     certificates to import
    -> [Char]
    -- ^ /@keyFile@/: file containing a PEM-encoded private key
    --     to import
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromFiles certFile keyFile = liftIO $ do
    certFile' <- stringToCString certFile
    keyFile' <- stringToCString keyFile
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_files certFile' keyFile'
        checkUnexpectedReturnNULL "tlsCertificateNewFromFiles" result
        result' <- (wrapObject TlsCertificate) result
        freeMem certFile'
        freeMem keyFile'
        return result'
     ) (do
        freeMem certFile'
        freeMem keyFile'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::new_from_pem
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "PEM-encoded certificate data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the length of @data, or -1 if it's 0-terminated."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_pem" g_tls_certificate_new_from_pem :: 
    CString ->                              -- data : TBasicType TUTF8
    DI.Int64 ->                             -- length : TBasicType TSSize
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from the PEM-encoded data in /@data@/. If
-- /@data@/ includes both a certificate and a private key, then the
-- returned certificate will include the private key data as well. (See
-- the [TlsCertificate:privateKeyPem]("GI.Gio.Objects.TlsCertificate#g:attr:privateKeyPem") property for information about
-- supported formats.)
-- 
-- The returned certificate will be the first certificate found in
-- /@data@/. As of GLib 2.44, if /@data@/ contains more certificates it will
-- try to load a certificate chain. All certificates will be verified in
-- the order found (top-level certificate should be the last one in the
-- file) and the [TlsCertificate:issuer]("GI.Gio.Objects.TlsCertificate#g:attr:issuer") property of each certificate
-- will be set accordingly if the verification succeeds. If any
-- certificate in the chain cannot be verified, the first certificate in
-- the file will still be returned.
-- 
-- /Since: 2.28/
tlsCertificateNewFromPem ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@data@/: PEM-encoded certificate data
    -> DI.Int64
    -- ^ /@length@/: the length of /@data@/, or -1 if it\'s 0-terminated.
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' if /@data@/ is invalid /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromPem data_ length_ = liftIO $ do
    data_' <- textToCString data_
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_pem data_' length_
        checkUnexpectedReturnNULL "tlsCertificateNewFromPem" result
        result' <- (wrapObject TlsCertificate) result
        freeMem data_'
        return result'
     ) (do
        freeMem data_'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::new_from_pkcs11_uris
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "pkcs11_uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A PKCS \\#11 URI" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "private_key_pkcs11_uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A PKCS \\#11 URI" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_pkcs11_uris" g_tls_certificate_new_from_pkcs11_uris :: 
    CString ->                              -- pkcs11_uri : TBasicType TUTF8
    CString ->                              -- private_key_pkcs11_uri : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from a
-- <https://docs.oasis-open.org/pkcs11/pkcs11-base/v3.0/os/pkcs11-base-v3.0-os.html PKCS \#11> URI.
-- 
-- An example /@pkcs11Uri@/ would be @pkcs11:model=Model;manufacturer=Manufacture;serial=1;token=My%20Client%20Certificate;id=%01@
-- 
-- Where the token’s layout is:
-- 
-- >
-- >Object 0:
-- >  URL: pkcs11:model=Model;manufacturer=Manufacture;serial=1;token=My%20Client%20Certificate;id=%01;object=private%20key;type=private
-- >  Type: Private key (RSA-2048)
-- >  ID: 01
-- >
-- >Object 1:
-- >  URL: pkcs11:model=Model;manufacturer=Manufacture;serial=1;token=My%20Client%20Certificate;id=%01;object=Certificate%20for%20Authentication;type=cert
-- >  Type: X.509 Certificate (RSA-2048)
-- >  ID: 01
-- 
-- 
-- In this case the certificate and private key would both be detected and used as expected.
-- /@pkcsUri@/ may also just reference an X.509 certificate object and then optionally
-- /@privateKeyPkcs11Uri@/ allows using a private key exposed under a different URI.
-- 
-- Note that the private key is not accessed until usage and may fail or require a PIN later.
-- 
-- /Since: 2.68/
tlsCertificateNewFromPkcs11Uris ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@pkcs11Uri@/: A PKCS #11 URI
    -> Maybe (T.Text)
    -- ^ /@privateKeyPkcs11Uri@/: A PKCS #11 URI
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromPkcs11Uris pkcs11Uri privateKeyPkcs11Uri = liftIO $ do
    pkcs11Uri' <- textToCString pkcs11Uri
    maybePrivateKeyPkcs11Uri <- case privateKeyPkcs11Uri of
        Nothing -> return FP.nullPtr
        Just jPrivateKeyPkcs11Uri -> do
            jPrivateKeyPkcs11Uri' <- textToCString jPrivateKeyPkcs11Uri
            return jPrivateKeyPkcs11Uri'
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_pkcs11_uris pkcs11Uri' maybePrivateKeyPkcs11Uri
        checkUnexpectedReturnNULL "tlsCertificateNewFromPkcs11Uris" result
        result' <- (wrapObject TlsCertificate) result
        freeMem pkcs11Uri'
        freeMem maybePrivateKeyPkcs11Uri
        return result'
     ) (do
        freeMem pkcs11Uri'
        freeMem maybePrivateKeyPkcs11Uri
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::new_from_pkcs12
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "DER-encoded PKCS #12 format certificate data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of @data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "password"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional password for encrypted certificate data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of @data"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_new_from_pkcs12" g_tls_certificate_new_from_pkcs12 :: 
    Ptr Word8 ->                            -- data : TCArray False (-1) 1 (TBasicType TUInt8)
    FCT.CSize ->                            -- length : TBasicType TSize
    CString ->                              -- password : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsCertificate)

-- | Creates a t'GI.Gio.Objects.TlsCertificate.TlsCertificate' from the data in /@data@/. It must contain
-- a certificate and matching private key.
-- 
-- If extra certificates are included they will be verified as a chain
-- and the [TlsCertificate:issuer]("GI.Gio.Objects.TlsCertificate#g:attr:issuer") property will be set.
-- All other data will be ignored.
-- 
-- You can pass as single password for all of the data which will be
-- used both for the PKCS @/12/@ container as well as encrypted
-- private keys. If decryption fails it will error with
-- 'GI.Gio.Enums.TlsErrorBadCertificatePassword'.
-- 
-- This constructor requires support in the current t'GI.Gio.Interfaces.TlsBackend.TlsBackend'.
-- If support is missing it will error with
-- 'GI.Gio.Enums.IOErrorEnumNotSupported'.
-- 
-- Other parsing failures will error with 'GI.Gio.Enums.TlsErrorBadCertificate'.
-- 
-- /Since: 2.72/
tlsCertificateNewFromPkcs12 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@data@/: DER-encoded PKCS @/12/@ format certificate data
    -> Maybe (T.Text)
    -- ^ /@password@/: optional password for encrypted certificate data
    -> m TlsCertificate
    -- ^ __Returns:__ the new certificate, or 'P.Nothing' if /@data@/ is invalid /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateNewFromPkcs12 data_ password = liftIO $ do
    let length_ = fromIntegral $ B.length data_
    data_' <- packByteString data_
    maybePassword <- case password of
        Nothing -> return FP.nullPtr
        Just jPassword -> do
            jPassword' <- textToCString jPassword
            return jPassword'
    onException (do
        result <- propagateGError $ g_tls_certificate_new_from_pkcs12 data_' length_ maybePassword
        checkUnexpectedReturnNULL "tlsCertificateNewFromPkcs12" result
        result' <- (wrapObject TlsCertificate) result
        freeMem data_'
        freeMem maybePassword
        return result'
     ) (do
        freeMem data_'
        freeMem maybePassword
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method TlsCertificate::get_dns_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TPtrArray
--                  (TInterface Name { namespace = "GLib" , name = "Bytes" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_dns_names" g_tls_certificate_get_dns_names :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO (Ptr (GPtrArray (Ptr GLib.Bytes.Bytes)))

-- | Gets the value of [TlsCertificate:dnsNames]("GI.Gio.Objects.TlsCertificate#g:attr:dnsNames").
-- 
-- /Since: 2.70/
tlsCertificateGetDnsNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe [GLib.Bytes.Bytes])
    -- ^ __Returns:__ A t'GI.GLib.Structs.PtrArray.PtrArray' of
    -- t'GI.GLib.Structs.Bytes.Bytes' elements, or 'P.Nothing' if it\'s not available.
tlsCertificateGetDnsNames cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_dns_names cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackGPtrArray result'
        result''' <- mapM (newBoxed GLib.Bytes.Bytes) result''
        unrefPtrArray result'
        return result'''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetDnsNamesMethodInfo
instance (signature ~ (m (Maybe [GLib.Bytes.Bytes])), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetDnsNamesMethodInfo a signature where
    overloadedMethod = tlsCertificateGetDnsNames

instance O.OverloadedMethodInfo TlsCertificateGetDnsNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetDnsNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetDnsNames"
        })


#endif

-- method TlsCertificate::get_ip_addresses
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TPtrArray
--                  (TInterface Name { namespace = "Gio" , name = "InetAddress" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_ip_addresses" g_tls_certificate_get_ip_addresses :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO (Ptr (GPtrArray (Ptr Gio.InetAddress.InetAddress)))

-- | Gets the value of [TlsCertificate:ipAddresses]("GI.Gio.Objects.TlsCertificate#g:attr:ipAddresses").
-- 
-- /Since: 2.70/
tlsCertificateGetIpAddresses ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe [Gio.InetAddress.InetAddress])
    -- ^ __Returns:__ A t'GI.GLib.Structs.PtrArray.PtrArray'
    -- of t'GI.Gio.Objects.InetAddress.InetAddress' elements, or 'P.Nothing' if it\'s not available.
tlsCertificateGetIpAddresses cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_ip_addresses cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackGPtrArray result'
        result''' <- mapM (newObject Gio.InetAddress.InetAddress) result''
        unrefPtrArray result'
        return result'''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetIpAddressesMethodInfo
instance (signature ~ (m (Maybe [Gio.InetAddress.InetAddress])), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetIpAddressesMethodInfo a signature where
    overloadedMethod = tlsCertificateGetIpAddresses

instance O.OverloadedMethodInfo TlsCertificateGetIpAddressesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetIpAddresses",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetIpAddresses"
        })


#endif

-- method TlsCertificate::get_issuer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsCertificate" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_issuer" g_tls_certificate_get_issuer :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO (Ptr TlsCertificate)

-- | Gets the t'GI.Gio.Objects.TlsCertificate.TlsCertificate' representing /@cert@/\'s issuer, if known
-- 
-- /Since: 2.28/
tlsCertificateGetIssuer ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe TlsCertificate)
    -- ^ __Returns:__ The certificate of /@cert@/\'s issuer,
    -- or 'P.Nothing' if /@cert@/ is self-signed or signed with an unknown
    -- certificate.
tlsCertificateGetIssuer cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_issuer cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject TlsCertificate) result'
        return result''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetIssuerMethodInfo
instance (signature ~ (m (Maybe TlsCertificate)), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetIssuerMethodInfo a signature where
    overloadedMethod = tlsCertificateGetIssuer

instance O.OverloadedMethodInfo TlsCertificateGetIssuerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetIssuer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetIssuer"
        })


#endif

-- method TlsCertificate::get_issuer_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_issuer_name" g_tls_certificate_get_issuer_name :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO CString

-- | Returns the issuer name from the certificate.
-- 
-- /Since: 2.70/
tlsCertificateGetIssuerName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The issuer name, or 'P.Nothing' if it\'s not available.
tlsCertificateGetIssuerName cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_issuer_name cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetIssuerNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetIssuerNameMethodInfo a signature where
    overloadedMethod = tlsCertificateGetIssuerName

instance O.OverloadedMethodInfo TlsCertificateGetIssuerNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetIssuerName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetIssuerName"
        })


#endif

-- method TlsCertificate::get_not_valid_after
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "DateTime" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_not_valid_after" g_tls_certificate_get_not_valid_after :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO (Ptr GLib.DateTime.DateTime)

-- | Returns the time at which the certificate became or will become invalid.
-- 
-- /Since: 2.70/
tlsCertificateGetNotValidAfter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe GLib.DateTime.DateTime)
    -- ^ __Returns:__ The not-valid-after date, or 'P.Nothing' if it\'s not available.
tlsCertificateGetNotValidAfter cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_not_valid_after cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GLib.DateTime.DateTime) result'
        return result''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetNotValidAfterMethodInfo
instance (signature ~ (m (Maybe GLib.DateTime.DateTime)), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetNotValidAfterMethodInfo a signature where
    overloadedMethod = tlsCertificateGetNotValidAfter

instance O.OverloadedMethodInfo TlsCertificateGetNotValidAfterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetNotValidAfter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetNotValidAfter"
        })


#endif

-- method TlsCertificate::get_not_valid_before
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "DateTime" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_not_valid_before" g_tls_certificate_get_not_valid_before :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO (Ptr GLib.DateTime.DateTime)

-- | Returns the time at which the certificate became or will become valid.
-- 
-- /Since: 2.70/
tlsCertificateGetNotValidBefore ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe GLib.DateTime.DateTime)
    -- ^ __Returns:__ The not-valid-before date, or 'P.Nothing' if it\'s not available.
tlsCertificateGetNotValidBefore cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_not_valid_before cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GLib.DateTime.DateTime) result'
        return result''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetNotValidBeforeMethodInfo
instance (signature ~ (m (Maybe GLib.DateTime.DateTime)), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetNotValidBeforeMethodInfo a signature where
    overloadedMethod = tlsCertificateGetNotValidBefore

instance O.OverloadedMethodInfo TlsCertificateGetNotValidBeforeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetNotValidBefore",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetNotValidBefore"
        })


#endif

-- method TlsCertificate::get_subject_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_get_subject_name" g_tls_certificate_get_subject_name :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO CString

-- | Returns the subject name from the certificate.
-- 
-- /Since: 2.70/
tlsCertificateGetSubjectName ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The subject name, or 'P.Nothing' if it\'s not available.
tlsCertificateGetSubjectName cert = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    result <- g_tls_certificate_get_subject_name cert'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr cert
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsCertificateGetSubjectNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsTlsCertificate a) => O.OverloadedMethod TlsCertificateGetSubjectNameMethodInfo a signature where
    overloadedMethod = tlsCertificateGetSubjectName

instance O.OverloadedMethodInfo TlsCertificateGetSubjectNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateGetSubjectName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateGetSubjectName"
        })


#endif

-- method TlsCertificate::is_same
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert_one"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first certificate to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cert_two"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second certificate to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_is_same" g_tls_certificate_is_same :: 
    Ptr TlsCertificate ->                   -- cert_one : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    Ptr TlsCertificate ->                   -- cert_two : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO CInt

-- | Check if two t'GI.Gio.Objects.TlsCertificate.TlsCertificate' objects represent the same certificate.
-- The raw DER byte data of the two certificates are checked for equality.
-- This has the effect that two certificates may compare equal even if
-- their [TlsCertificate:issuer]("GI.Gio.Objects.TlsCertificate#g:attr:issuer"), [TlsCertificate:privateKey]("GI.Gio.Objects.TlsCertificate#g:attr:privateKey"), or
-- [TlsCertificate:privateKeyPem]("GI.Gio.Objects.TlsCertificate#g:attr:privateKeyPem") properties differ.
-- 
-- /Since: 2.34/
tlsCertificateIsSame ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a, IsTlsCertificate b) =>
    a
    -- ^ /@certOne@/: first certificate to compare
    -> b
    -- ^ /@certTwo@/: second certificate to compare
    -> m Bool
    -- ^ __Returns:__ whether the same or not
tlsCertificateIsSame certOne certTwo = liftIO $ do
    certOne' <- unsafeManagedPtrCastPtr certOne
    certTwo' <- unsafeManagedPtrCastPtr certTwo
    result <- g_tls_certificate_is_same certOne' certTwo'
    let result' = (/= 0) result
    touchManagedPtr certOne
    touchManagedPtr certTwo
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsCertificateIsSameMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsTlsCertificate a, IsTlsCertificate b) => O.OverloadedMethod TlsCertificateIsSameMethodInfo a signature where
    overloadedMethod = tlsCertificateIsSame

instance O.OverloadedMethodInfo TlsCertificateIsSameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateIsSame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateIsSame"
        })


#endif

-- method TlsCertificate::verify
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cert"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsCertificate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "identity"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expected peer identity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trusted_ca"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TlsCertificate" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the certificate of a trusted authority"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsCertificateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_certificate_verify" g_tls_certificate_verify :: 
    Ptr TlsCertificate ->                   -- cert : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- identity : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    Ptr TlsCertificate ->                   -- trusted_ca : TInterface (Name {namespace = "Gio", name = "TlsCertificate"})
    IO CUInt

-- | This verifies /@cert@/ and returns a set of t'GI.Gio.Flags.TlsCertificateFlags'
-- indicating any problems found with it. This can be used to verify a
-- certificate outside the context of making a connection, or to
-- check a certificate against a CA that is not part of the system
-- CA database.
-- 
-- If /@cert@/ is valid, 'GI.Gio.Flags.TlsCertificateFlagsNoFlags' is returned.
-- 
-- If /@identity@/ is not 'P.Nothing', /@cert@/\'s name(s) will be compared against
-- it, and 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' will be set in the return
-- value if it does not match. If /@identity@/ is 'P.Nothing', that bit will
-- never be set in the return value.
-- 
-- If /@trustedCa@/ is not 'P.Nothing', then /@cert@/ (or one of the certificates
-- in its chain) must be signed by it, or else
-- 'GI.Gio.Flags.TlsCertificateFlagsUnknownCa' will be set in the return value. If
-- /@trustedCa@/ is 'P.Nothing', that bit will never be set in the return
-- value.
-- 
-- GLib guarantees that if certificate verification fails, at least one
-- error will be set in the return value, but it does not guarantee
-- that all possible errors will be set. Accordingly, you may not safely
-- decide to ignore any particular type of error. For example, it would
-- be incorrect to mask 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow
-- expired certificates, because this could potentially be the only
-- error flag set even if other problems exist with the certificate.
-- 
-- Because TLS session context is not used, t'GI.Gio.Objects.TlsCertificate.TlsCertificate' may not
-- perform as many checks on the certificates as t'GI.Gio.Objects.TlsConnection.TlsConnection' would.
-- For example, certificate constraints may not be honored, and
-- revocation checks may not be performed. The best way to verify TLS
-- certificates used by a TLS connection is to let t'GI.Gio.Objects.TlsConnection.TlsConnection'
-- handle the verification.
-- 
-- /Since: 2.28/
tlsCertificateVerify ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsCertificate a, Gio.SocketConnectable.IsSocketConnectable b, IsTlsCertificate c) =>
    a
    -- ^ /@cert@/: a t'GI.Gio.Objects.TlsCertificate.TlsCertificate'
    -> Maybe (b)
    -- ^ /@identity@/: the expected peer identity
    -> Maybe (c)
    -- ^ /@trustedCa@/: the certificate of a trusted authority
    -> m [Gio.Flags.TlsCertificateFlags]
    -- ^ __Returns:__ the appropriate t'GI.Gio.Flags.TlsCertificateFlags'
tlsCertificateVerify cert identity trustedCa = liftIO $ do
    cert' <- unsafeManagedPtrCastPtr cert
    maybeIdentity <- case identity of
        Nothing -> return FP.nullPtr
        Just jIdentity -> do
            jIdentity' <- unsafeManagedPtrCastPtr jIdentity
            return jIdentity'
    maybeTrustedCa <- case trustedCa of
        Nothing -> return FP.nullPtr
        Just jTrustedCa -> do
            jTrustedCa' <- unsafeManagedPtrCastPtr jTrustedCa
            return jTrustedCa'
    result <- g_tls_certificate_verify cert' maybeIdentity maybeTrustedCa
    let result' = wordToGFlags result
    touchManagedPtr cert
    whenJust identity touchManagedPtr
    whenJust trustedCa touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsCertificateVerifyMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (c) -> m [Gio.Flags.TlsCertificateFlags]), MonadIO m, IsTlsCertificate a, Gio.SocketConnectable.IsSocketConnectable b, IsTlsCertificate c) => O.OverloadedMethod TlsCertificateVerifyMethodInfo a signature where
    overloadedMethod = tlsCertificateVerify

instance O.OverloadedMethodInfo TlsCertificateVerifyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TlsCertificate.tlsCertificateVerify",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TlsCertificate.html#v:tlsCertificateVerify"
        })


#endif

-- method TlsCertificate::list_new_from_file
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "file containing PEM-encoded certificates to import"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "TlsCertificate" }))
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_certificate_list_new_from_file" g_tls_certificate_list_new_from_file :: 
    CString ->                              -- file : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr (GList (Ptr TlsCertificate)))

-- | Creates one or more @/GTlsCertificates/@ from the PEM-encoded
-- data in /@file@/. If /@file@/ cannot be read or parsed, the function will
-- return 'P.Nothing' and set /@error@/. If /@file@/ does not contain any
-- PEM-encoded certificates, this will return an empty list and not
-- set /@error@/.
-- 
-- /Since: 2.28/
tlsCertificateListNewFromFile ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@file@/: file containing PEM-encoded certificates to import
    -> m [TlsCertificate]
    -- ^ __Returns:__ a
    -- t'GI.GLib.Structs.List.List' containing t'GI.Gio.Objects.TlsCertificate.TlsCertificate' objects. You must free the list
    -- and its contents when you are done with it. /(Can throw 'Data.GI.Base.GError.GError')/
tlsCertificateListNewFromFile file = liftIO $ do
    file' <- stringToCString file
    onException (do
        result <- propagateGError $ g_tls_certificate_list_new_from_file file'
        result' <- unpackGList result
        result'' <- mapM (wrapObject TlsCertificate) result'
        g_list_free result
        freeMem file'
        return result''
     ) (do
        freeMem file'
     )

#if defined(ENABLE_OVERLOADING)
#endif


