{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GThreadedSocketService@ is a simple subclass of t'GI.Gio.Objects.SocketService.SocketService'
-- that handles incoming connections by creating a worker thread and
-- dispatching the connection to it by emitting the
-- [signal/@gio@/.ThreadedSocketService[run](#g:signal:run) signal] in the new thread.
-- 
-- The signal handler may perform blocking I\/O and need not return
-- until the connection is closed.
-- 
-- The service is implemented using a thread pool, so there is a
-- limited amount of threads available to serve incoming requests.
-- The service automatically stops the t'GI.Gio.Objects.SocketService.SocketService' from accepting
-- new connections when all threads are busy.
-- 
-- As with t'GI.Gio.Objects.SocketService.SocketService', you may connect to
-- [ThreadedSocketService::run]("GI.Gio.Objects.ThreadedSocketService#g:signal:run"), or subclass and override the default
-- handler.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ThreadedSocketService
    ( 

-- * Exported types
    ThreadedSocketService(..)               ,
    IsThreadedSocketService                 ,
    toThreadedSocketService                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [accept]("GI.Gio.Objects.SocketListener#g:method:accept"), [acceptAsync]("GI.Gio.Objects.SocketListener#g:method:acceptAsync"), [acceptFinish]("GI.Gio.Objects.SocketListener#g:method:acceptFinish"), [acceptSocket]("GI.Gio.Objects.SocketListener#g:method:acceptSocket"), [acceptSocketAsync]("GI.Gio.Objects.SocketListener#g:method:acceptSocketAsync"), [acceptSocketFinish]("GI.Gio.Objects.SocketListener#g:method:acceptSocketFinish"), [addAddress]("GI.Gio.Objects.SocketListener#g:method:addAddress"), [addAnyInetPort]("GI.Gio.Objects.SocketListener#g:method:addAnyInetPort"), [addInetPort]("GI.Gio.Objects.SocketListener#g:method:addInetPort"), [addSocket]("GI.Gio.Objects.SocketListener#g:method:addSocket"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gio.Objects.SocketListener#g:method:close"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isActive]("GI.Gio.Objects.SocketService#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [start]("GI.Gio.Objects.SocketService#g:method:start"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stop]("GI.Gio.Objects.SocketService#g:method:stop"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setBacklog]("GI.Gio.Objects.SocketListener#g:method:setBacklog"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveThreadedSocketServiceMethod      ,
#endif

-- ** new #method:new#

    threadedSocketServiceNew                ,




 -- * Properties


-- ** maxThreads #attr:maxThreads#
-- | The maximum number of threads handling clients for this service.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    ThreadedSocketServiceMaxThreadsPropertyInfo,
#endif
    constructThreadedSocketServiceMaxThreads,
    getThreadedSocketServiceMaxThreads      ,
#if defined(ENABLE_OVERLOADING)
    threadedSocketServiceMaxThreads         ,
#endif




 -- * Signals


-- ** run #signal:run#

    ThreadedSocketServiceRunCallback        ,
#if defined(ENABLE_OVERLOADING)
    ThreadedSocketServiceRunSignalInfo      ,
#endif
    afterThreadedSocketServiceRun           ,
    onThreadedSocketServiceRun              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketListener as Gio.SocketListener
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketService as Gio.SocketService
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketListener as Gio.SocketListener
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketService as Gio.SocketService

#endif

-- | Memory-managed wrapper type.
newtype ThreadedSocketService = ThreadedSocketService (SP.ManagedPtr ThreadedSocketService)
    deriving (Eq)

instance SP.ManagedPtrNewtype ThreadedSocketService where
    toManagedPtr (ThreadedSocketService p) = p

foreign import ccall "g_threaded_socket_service_get_type"
    c_g_threaded_socket_service_get_type :: IO B.Types.GType

instance B.Types.TypedObject ThreadedSocketService where
    glibType = c_g_threaded_socket_service_get_type

instance B.Types.GObject ThreadedSocketService

-- | Type class for types which can be safely cast to `ThreadedSocketService`, for instance with `toThreadedSocketService`.
class (SP.GObject o, O.IsDescendantOf ThreadedSocketService o) => IsThreadedSocketService o
instance (SP.GObject o, O.IsDescendantOf ThreadedSocketService o) => IsThreadedSocketService o

instance O.HasParentTypes ThreadedSocketService
type instance O.ParentTypes ThreadedSocketService = '[Gio.SocketService.SocketService, Gio.SocketListener.SocketListener, GObject.Object.Object]

-- | Cast to `ThreadedSocketService`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toThreadedSocketService :: (MIO.MonadIO m, IsThreadedSocketService o) => o -> m ThreadedSocketService
toThreadedSocketService = MIO.liftIO . B.ManagedPtr.unsafeCastTo ThreadedSocketService

-- | Convert 'ThreadedSocketService' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ThreadedSocketService) where
    gvalueGType_ = c_g_threaded_socket_service_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ThreadedSocketService)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ThreadedSocketService)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ThreadedSocketService ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveThreadedSocketServiceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveThreadedSocketServiceMethod "accept" o = Gio.SocketListener.SocketListenerAcceptMethodInfo
    ResolveThreadedSocketServiceMethod "acceptAsync" o = Gio.SocketListener.SocketListenerAcceptAsyncMethodInfo
    ResolveThreadedSocketServiceMethod "acceptFinish" o = Gio.SocketListener.SocketListenerAcceptFinishMethodInfo
    ResolveThreadedSocketServiceMethod "acceptSocket" o = Gio.SocketListener.SocketListenerAcceptSocketMethodInfo
    ResolveThreadedSocketServiceMethod "acceptSocketAsync" o = Gio.SocketListener.SocketListenerAcceptSocketAsyncMethodInfo
    ResolveThreadedSocketServiceMethod "acceptSocketFinish" o = Gio.SocketListener.SocketListenerAcceptSocketFinishMethodInfo
    ResolveThreadedSocketServiceMethod "addAddress" o = Gio.SocketListener.SocketListenerAddAddressMethodInfo
    ResolveThreadedSocketServiceMethod "addAnyInetPort" o = Gio.SocketListener.SocketListenerAddAnyInetPortMethodInfo
    ResolveThreadedSocketServiceMethod "addInetPort" o = Gio.SocketListener.SocketListenerAddInetPortMethodInfo
    ResolveThreadedSocketServiceMethod "addSocket" o = Gio.SocketListener.SocketListenerAddSocketMethodInfo
    ResolveThreadedSocketServiceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveThreadedSocketServiceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveThreadedSocketServiceMethod "close" o = Gio.SocketListener.SocketListenerCloseMethodInfo
    ResolveThreadedSocketServiceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveThreadedSocketServiceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveThreadedSocketServiceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveThreadedSocketServiceMethod "isActive" o = Gio.SocketService.SocketServiceIsActiveMethodInfo
    ResolveThreadedSocketServiceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveThreadedSocketServiceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveThreadedSocketServiceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveThreadedSocketServiceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveThreadedSocketServiceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveThreadedSocketServiceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveThreadedSocketServiceMethod "start" o = Gio.SocketService.SocketServiceStartMethodInfo
    ResolveThreadedSocketServiceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveThreadedSocketServiceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveThreadedSocketServiceMethod "stop" o = Gio.SocketService.SocketServiceStopMethodInfo
    ResolveThreadedSocketServiceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveThreadedSocketServiceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveThreadedSocketServiceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveThreadedSocketServiceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveThreadedSocketServiceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveThreadedSocketServiceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveThreadedSocketServiceMethod "setBacklog" o = Gio.SocketListener.SocketListenerSetBacklogMethodInfo
    ResolveThreadedSocketServiceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveThreadedSocketServiceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveThreadedSocketServiceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveThreadedSocketServiceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveThreadedSocketServiceMethod t ThreadedSocketService, O.OverloadedMethod info ThreadedSocketService p) => OL.IsLabel t (ThreadedSocketService -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveThreadedSocketServiceMethod t ThreadedSocketService, O.OverloadedMethod info ThreadedSocketService p, R.HasField t ThreadedSocketService p) => R.HasField t ThreadedSocketService p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveThreadedSocketServiceMethod t ThreadedSocketService, O.OverloadedMethodInfo info ThreadedSocketService) => OL.IsLabel t (O.MethodProxy info ThreadedSocketService) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ThreadedSocketService::run
-- | The [run](#g:signal:run) signal is emitted in a worker thread in response to an
-- incoming connection. This thread is dedicated to handling
-- /@connection@/ and may perform blocking IO. The signal handler need
-- not return until the connection is closed.
type ThreadedSocketServiceRunCallback =
    Gio.SocketConnection.SocketConnection
    -- ^ /@connection@/: a new t'GI.Gio.Objects.SocketConnection.SocketConnection' object.
    -> Maybe GObject.Object.Object
    -- ^ /@sourceObject@/: the source_object passed to 'GI.Gio.Objects.SocketListener.socketListenerAddAddress'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop further signal handlers from being called

type C_ThreadedSocketServiceRunCallback =
    Ptr ThreadedSocketService ->            -- object
    Ptr Gio.SocketConnection.SocketConnection ->
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_ThreadedSocketServiceRunCallback`.
foreign import ccall "wrapper"
    mk_ThreadedSocketServiceRunCallback :: C_ThreadedSocketServiceRunCallback -> IO (FunPtr C_ThreadedSocketServiceRunCallback)

wrap_ThreadedSocketServiceRunCallback :: 
    GObject a => (a -> ThreadedSocketServiceRunCallback) ->
    C_ThreadedSocketServiceRunCallback
wrap_ThreadedSocketServiceRunCallback gi'cb gi'selfPtr connection sourceObject _ = do
    connection' <- (newObject Gio.SocketConnection.SocketConnection) connection
    maybeSourceObject <-
        if sourceObject == FP.nullPtr
        then return Nothing
        else do
            sourceObject' <- (newObject GObject.Object.Object) sourceObject
            return $ Just sourceObject'
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  connection' maybeSourceObject
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [run](#signal:run) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' threadedSocketService #run callback
-- @
-- 
-- 
onThreadedSocketServiceRun :: (IsThreadedSocketService a, MonadIO m) => a -> ((?self :: a) => ThreadedSocketServiceRunCallback) -> m SignalHandlerId
onThreadedSocketServiceRun obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ThreadedSocketServiceRunCallback wrapped
    wrapped'' <- mk_ThreadedSocketServiceRunCallback wrapped'
    connectSignalFunPtr obj "run" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [run](#signal:run) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' threadedSocketService #run callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterThreadedSocketServiceRun :: (IsThreadedSocketService a, MonadIO m) => a -> ((?self :: a) => ThreadedSocketServiceRunCallback) -> m SignalHandlerId
afterThreadedSocketServiceRun obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ThreadedSocketServiceRunCallback wrapped
    wrapped'' <- mk_ThreadedSocketServiceRunCallback wrapped'
    connectSignalFunPtr obj "run" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ThreadedSocketServiceRunSignalInfo
instance SignalInfo ThreadedSocketServiceRunSignalInfo where
    type HaskellCallbackType ThreadedSocketServiceRunSignalInfo = ThreadedSocketServiceRunCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ThreadedSocketServiceRunCallback cb
        cb'' <- mk_ThreadedSocketServiceRunCallback cb'
        connectSignalFunPtr obj "run" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThreadedSocketService::run"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ThreadedSocketService.html#g:signal:run"})

#endif

-- VVV Prop "max-threads"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@max-threads@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' threadedSocketService #maxThreads
-- @
getThreadedSocketServiceMaxThreads :: (MonadIO m, IsThreadedSocketService o) => o -> m Int32
getThreadedSocketServiceMaxThreads obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "max-threads"

-- | Construct a `GValueConstruct` with valid value for the “@max-threads@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructThreadedSocketServiceMaxThreads :: (IsThreadedSocketService o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructThreadedSocketServiceMaxThreads val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "max-threads" val

#if defined(ENABLE_OVERLOADING)
data ThreadedSocketServiceMaxThreadsPropertyInfo
instance AttrInfo ThreadedSocketServiceMaxThreadsPropertyInfo where
    type AttrAllowedOps ThreadedSocketServiceMaxThreadsPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ThreadedSocketServiceMaxThreadsPropertyInfo = IsThreadedSocketService
    type AttrSetTypeConstraint ThreadedSocketServiceMaxThreadsPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ThreadedSocketServiceMaxThreadsPropertyInfo = (~) Int32
    type AttrTransferType ThreadedSocketServiceMaxThreadsPropertyInfo = Int32
    type AttrGetType ThreadedSocketServiceMaxThreadsPropertyInfo = Int32
    type AttrLabel ThreadedSocketServiceMaxThreadsPropertyInfo = "max-threads"
    type AttrOrigin ThreadedSocketServiceMaxThreadsPropertyInfo = ThreadedSocketService
    attrGet = getThreadedSocketServiceMaxThreads
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructThreadedSocketServiceMaxThreads
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ThreadedSocketService.maxThreads"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ThreadedSocketService.html#g:attr:maxThreads"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ThreadedSocketService
type instance O.AttributeList ThreadedSocketService = ThreadedSocketServiceAttributeList
type ThreadedSocketServiceAttributeList = ('[ '("active", Gio.SocketService.SocketServiceActivePropertyInfo), '("listenBacklog", Gio.SocketListener.SocketListenerListenBacklogPropertyInfo), '("maxThreads", ThreadedSocketServiceMaxThreadsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
threadedSocketServiceMaxThreads :: AttrLabelProxy "maxThreads"
threadedSocketServiceMaxThreads = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ThreadedSocketService = ThreadedSocketServiceSignalList
type ThreadedSocketServiceSignalList = ('[ '("event", Gio.SocketListener.SocketListenerEventSignalInfo), '("incoming", Gio.SocketService.SocketServiceIncomingSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("run", ThreadedSocketServiceRunSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ThreadedSocketService::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "max_threads"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximal number of threads to execute concurrently\n  handling incoming clients, -1 means no limit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "ThreadedSocketService" })
-- throws : False
-- Skip return : False

foreign import ccall "g_threaded_socket_service_new" g_threaded_socket_service_new :: 
    Int32 ->                                -- max_threads : TBasicType TInt
    IO (Ptr ThreadedSocketService)

-- | Creates a new t'GI.Gio.Objects.ThreadedSocketService.ThreadedSocketService' with no listeners. Listeners
-- must be added with one of the t'GI.Gio.Objects.SocketListener.SocketListener' \"add\" methods.
-- 
-- /Since: 2.22/
threadedSocketServiceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@maxThreads@/: the maximal number of threads to execute concurrently
    --   handling incoming clients, -1 means no limit
    -> m ThreadedSocketService
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SocketService.SocketService'.
threadedSocketServiceNew maxThreads = liftIO $ do
    result <- g_threaded_socket_service_new maxThreads
    checkUnexpectedReturnNULL "threadedSocketServiceNew" result
    result' <- (wrapObject ThreadedSocketService) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


