{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Objects.ThreadedResolver.ThreadedResolver' is an implementation of t'GI.Gio.Objects.Resolver.Resolver' which calls the libc
-- lookup functions in threads to allow them to run asynchronously.
-- 
-- /Since: 2.20/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ThreadedResolver
    ( 

-- * Exported types
    ThreadedResolver(..)                    ,
    IsThreadedResolver                      ,
    toThreadedResolver                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lookupByAddress]("GI.Gio.Objects.Resolver#g:method:lookupByAddress"), [lookupByAddressAsync]("GI.Gio.Objects.Resolver#g:method:lookupByAddressAsync"), [lookupByAddressFinish]("GI.Gio.Objects.Resolver#g:method:lookupByAddressFinish"), [lookupByName]("GI.Gio.Objects.Resolver#g:method:lookupByName"), [lookupByNameAsync]("GI.Gio.Objects.Resolver#g:method:lookupByNameAsync"), [lookupByNameFinish]("GI.Gio.Objects.Resolver#g:method:lookupByNameFinish"), [lookupByNameWithFlags]("GI.Gio.Objects.Resolver#g:method:lookupByNameWithFlags"), [lookupByNameWithFlagsAsync]("GI.Gio.Objects.Resolver#g:method:lookupByNameWithFlagsAsync"), [lookupByNameWithFlagsFinish]("GI.Gio.Objects.Resolver#g:method:lookupByNameWithFlagsFinish"), [lookupRecords]("GI.Gio.Objects.Resolver#g:method:lookupRecords"), [lookupRecordsAsync]("GI.Gio.Objects.Resolver#g:method:lookupRecordsAsync"), [lookupRecordsFinish]("GI.Gio.Objects.Resolver#g:method:lookupRecordsFinish"), [lookupService]("GI.Gio.Objects.Resolver#g:method:lookupService"), [lookupServiceAsync]("GI.Gio.Objects.Resolver#g:method:lookupServiceAsync"), [lookupServiceFinish]("GI.Gio.Objects.Resolver#g:method:lookupServiceFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTimeout]("GI.Gio.Objects.Resolver#g:method:getTimeout").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefault]("GI.Gio.Objects.Resolver#g:method:setDefault"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTimeout]("GI.Gio.Objects.Resolver#g:method:setTimeout").

#if defined(ENABLE_OVERLOADING)
    ResolveThreadedResolverMethod           ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.Resolver as Gio.Resolver
import {-# SOURCE #-} qualified GI.Gio.Structs.SrvTarget as Gio.SrvTarget

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.Resolver as Gio.Resolver

#endif

-- | Memory-managed wrapper type.
newtype ThreadedResolver = ThreadedResolver (SP.ManagedPtr ThreadedResolver)
    deriving (Eq)

instance SP.ManagedPtrNewtype ThreadedResolver where
    toManagedPtr (ThreadedResolver p) = p

foreign import ccall "g_threaded_resolver_get_type"
    c_g_threaded_resolver_get_type :: IO B.Types.GType

instance B.Types.TypedObject ThreadedResolver where
    glibType = c_g_threaded_resolver_get_type

instance B.Types.GObject ThreadedResolver

-- | Type class for types which can be safely cast to `ThreadedResolver`, for instance with `toThreadedResolver`.
class (SP.GObject o, O.IsDescendantOf ThreadedResolver o) => IsThreadedResolver o
instance (SP.GObject o, O.IsDescendantOf ThreadedResolver o) => IsThreadedResolver o

instance O.HasParentTypes ThreadedResolver
type instance O.ParentTypes ThreadedResolver = '[Gio.Resolver.Resolver, GObject.Object.Object]

-- | Cast to `ThreadedResolver`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toThreadedResolver :: (MIO.MonadIO m, IsThreadedResolver o) => o -> m ThreadedResolver
toThreadedResolver = MIO.liftIO . B.ManagedPtr.unsafeCastTo ThreadedResolver

-- | Convert 'ThreadedResolver' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ThreadedResolver) where
    gvalueGType_ = c_g_threaded_resolver_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ThreadedResolver)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ThreadedResolver)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ThreadedResolver ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveThreadedResolverMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveThreadedResolverMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveThreadedResolverMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveThreadedResolverMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveThreadedResolverMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveThreadedResolverMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveThreadedResolverMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveThreadedResolverMethod "lookupByAddress" o = Gio.Resolver.ResolverLookupByAddressMethodInfo
    ResolveThreadedResolverMethod "lookupByAddressAsync" o = Gio.Resolver.ResolverLookupByAddressAsyncMethodInfo
    ResolveThreadedResolverMethod "lookupByAddressFinish" o = Gio.Resolver.ResolverLookupByAddressFinishMethodInfo
    ResolveThreadedResolverMethod "lookupByName" o = Gio.Resolver.ResolverLookupByNameMethodInfo
    ResolveThreadedResolverMethod "lookupByNameAsync" o = Gio.Resolver.ResolverLookupByNameAsyncMethodInfo
    ResolveThreadedResolverMethod "lookupByNameFinish" o = Gio.Resolver.ResolverLookupByNameFinishMethodInfo
    ResolveThreadedResolverMethod "lookupByNameWithFlags" o = Gio.Resolver.ResolverLookupByNameWithFlagsMethodInfo
    ResolveThreadedResolverMethod "lookupByNameWithFlagsAsync" o = Gio.Resolver.ResolverLookupByNameWithFlagsAsyncMethodInfo
    ResolveThreadedResolverMethod "lookupByNameWithFlagsFinish" o = Gio.Resolver.ResolverLookupByNameWithFlagsFinishMethodInfo
    ResolveThreadedResolverMethod "lookupRecords" o = Gio.Resolver.ResolverLookupRecordsMethodInfo
    ResolveThreadedResolverMethod "lookupRecordsAsync" o = Gio.Resolver.ResolverLookupRecordsAsyncMethodInfo
    ResolveThreadedResolverMethod "lookupRecordsFinish" o = Gio.Resolver.ResolverLookupRecordsFinishMethodInfo
    ResolveThreadedResolverMethod "lookupService" o = Gio.Resolver.ResolverLookupServiceMethodInfo
    ResolveThreadedResolverMethod "lookupServiceAsync" o = Gio.Resolver.ResolverLookupServiceAsyncMethodInfo
    ResolveThreadedResolverMethod "lookupServiceFinish" o = Gio.Resolver.ResolverLookupServiceFinishMethodInfo
    ResolveThreadedResolverMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveThreadedResolverMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveThreadedResolverMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveThreadedResolverMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveThreadedResolverMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveThreadedResolverMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveThreadedResolverMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveThreadedResolverMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveThreadedResolverMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveThreadedResolverMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveThreadedResolverMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveThreadedResolverMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveThreadedResolverMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveThreadedResolverMethod "getTimeout" o = Gio.Resolver.ResolverGetTimeoutMethodInfo
    ResolveThreadedResolverMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveThreadedResolverMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveThreadedResolverMethod "setDefault" o = Gio.Resolver.ResolverSetDefaultMethodInfo
    ResolveThreadedResolverMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveThreadedResolverMethod "setTimeout" o = Gio.Resolver.ResolverSetTimeoutMethodInfo
    ResolveThreadedResolverMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveThreadedResolverMethod t ThreadedResolver, O.OverloadedMethod info ThreadedResolver p) => OL.IsLabel t (ThreadedResolver -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveThreadedResolverMethod t ThreadedResolver, O.OverloadedMethod info ThreadedResolver p, R.HasField t ThreadedResolver p) => R.HasField t ThreadedResolver p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveThreadedResolverMethod t ThreadedResolver, O.OverloadedMethodInfo info ThreadedResolver) => OL.IsLabel t (O.MethodProxy info ThreadedResolver) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ThreadedResolver
type instance O.AttributeList ThreadedResolver = ThreadedResolverAttributeList
type ThreadedResolverAttributeList = ('[ '("timeout", Gio.Resolver.ResolverTimeoutPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ThreadedResolver = ThreadedResolverSignalList
type ThreadedResolverSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo), '("reload", Gio.Resolver.ResolverReloadSignalInfo)] :: [(Symbol, DK.Type)])

#endif


