{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This is the subclass of t'GI.Gio.Objects.SocketConnection.SocketConnection' that is created
-- for TCP\/IP sockets.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.TcpConnection
    ( 

-- * Exported types
    TcpConnection(..)                       ,
    IsTcpConnection                         ,
    toTcpConnection                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [connect]("GI.Gio.Objects.SocketConnection#g:method:connect"), [connectAsync]("GI.Gio.Objects.SocketConnection#g:method:connectAsync"), [connectFinish]("GI.Gio.Objects.SocketConnection#g:method:connectFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isConnected]("GI.Gio.Objects.SocketConnection#g:method:isConnected"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getGracefulDisconnect]("GI.Gio.Objects.TcpConnection#g:method:getGracefulDisconnect"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getLocalAddress]("GI.Gio.Objects.SocketConnection#g:method:getLocalAddress"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRemoteAddress]("GI.Gio.Objects.SocketConnection#g:method:getRemoteAddress"), [getSocket]("GI.Gio.Objects.SocketConnection#g:method:getSocket").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setGracefulDisconnect]("GI.Gio.Objects.TcpConnection#g:method:setGracefulDisconnect"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTcpConnectionMethod              ,
#endif

-- ** getGracefulDisconnect #method:getGracefulDisconnect#

#if defined(ENABLE_OVERLOADING)
    TcpConnectionGetGracefulDisconnectMethodInfo,
#endif
    tcpConnectionGetGracefulDisconnect      ,


-- ** setGracefulDisconnect #method:setGracefulDisconnect#

#if defined(ENABLE_OVERLOADING)
    TcpConnectionSetGracefulDisconnectMethodInfo,
#endif
    tcpConnectionSetGracefulDisconnect      ,




 -- * Properties


-- ** gracefulDisconnect #attr:gracefulDisconnect#
-- | Whether 'GI.Gio.Objects.IOStream.iOStreamClose' does a graceful disconnect.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    TcpConnectionGracefulDisconnectPropertyInfo,
#endif
    constructTcpConnectionGracefulDisconnect,
    getTcpConnectionGracefulDisconnect      ,
    setTcpConnectionGracefulDisconnect      ,
#if defined(ENABLE_OVERLOADING)
    tcpConnectionGracefulDisconnect         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection

#endif

-- | Memory-managed wrapper type.
newtype TcpConnection = TcpConnection (SP.ManagedPtr TcpConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TcpConnection where
    toManagedPtr (TcpConnection p) = p

foreign import ccall "g_tcp_connection_get_type"
    c_g_tcp_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject TcpConnection where
    glibType = c_g_tcp_connection_get_type

instance B.Types.GObject TcpConnection

-- | Type class for types which can be safely cast to `TcpConnection`, for instance with `toTcpConnection`.
class (SP.GObject o, O.IsDescendantOf TcpConnection o) => IsTcpConnection o
instance (SP.GObject o, O.IsDescendantOf TcpConnection o) => IsTcpConnection o

instance O.HasParentTypes TcpConnection
type instance O.ParentTypes TcpConnection = '[Gio.SocketConnection.SocketConnection, Gio.IOStream.IOStream, GObject.Object.Object]

-- | Cast to `TcpConnection`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTcpConnection :: (MIO.MonadIO m, IsTcpConnection o) => o -> m TcpConnection
toTcpConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo TcpConnection

-- | Convert 'TcpConnection' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TcpConnection) where
    gvalueGType_ = c_g_tcp_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TcpConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TcpConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TcpConnection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTcpConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTcpConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTcpConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTcpConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveTcpConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveTcpConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveTcpConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveTcpConnectionMethod "connect" o = Gio.SocketConnection.SocketConnectionConnectMethodInfo
    ResolveTcpConnectionMethod "connectAsync" o = Gio.SocketConnection.SocketConnectionConnectAsyncMethodInfo
    ResolveTcpConnectionMethod "connectFinish" o = Gio.SocketConnection.SocketConnectionConnectFinishMethodInfo
    ResolveTcpConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTcpConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTcpConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTcpConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveTcpConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveTcpConnectionMethod "isConnected" o = Gio.SocketConnection.SocketConnectionIsConnectedMethodInfo
    ResolveTcpConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTcpConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTcpConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTcpConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTcpConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTcpConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTcpConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveTcpConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTcpConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTcpConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTcpConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTcpConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTcpConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTcpConnectionMethod "getGracefulDisconnect" o = TcpConnectionGetGracefulDisconnectMethodInfo
    ResolveTcpConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveTcpConnectionMethod "getLocalAddress" o = Gio.SocketConnection.SocketConnectionGetLocalAddressMethodInfo
    ResolveTcpConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveTcpConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTcpConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTcpConnectionMethod "getRemoteAddress" o = Gio.SocketConnection.SocketConnectionGetRemoteAddressMethodInfo
    ResolveTcpConnectionMethod "getSocket" o = Gio.SocketConnection.SocketConnectionGetSocketMethodInfo
    ResolveTcpConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTcpConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTcpConnectionMethod "setGracefulDisconnect" o = TcpConnectionSetGracefulDisconnectMethodInfo
    ResolveTcpConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveTcpConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTcpConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTcpConnectionMethod t TcpConnection, O.OverloadedMethod info TcpConnection p) => OL.IsLabel t (TcpConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTcpConnectionMethod t TcpConnection, O.OverloadedMethod info TcpConnection p, R.HasField t TcpConnection p) => R.HasField t TcpConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTcpConnectionMethod t TcpConnection, O.OverloadedMethodInfo info TcpConnection) => OL.IsLabel t (O.MethodProxy info TcpConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "graceful-disconnect"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@graceful-disconnect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tcpConnection #gracefulDisconnect
-- @
getTcpConnectionGracefulDisconnect :: (MonadIO m, IsTcpConnection o) => o -> m Bool
getTcpConnectionGracefulDisconnect obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "graceful-disconnect"

-- | Set the value of the “@graceful-disconnect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tcpConnection [ #gracefulDisconnect 'Data.GI.Base.Attributes.:=' value ]
-- @
setTcpConnectionGracefulDisconnect :: (MonadIO m, IsTcpConnection o) => o -> Bool -> m ()
setTcpConnectionGracefulDisconnect obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "graceful-disconnect" val

-- | Construct a `GValueConstruct` with valid value for the “@graceful-disconnect@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTcpConnectionGracefulDisconnect :: (IsTcpConnection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTcpConnectionGracefulDisconnect val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "graceful-disconnect" val

#if defined(ENABLE_OVERLOADING)
data TcpConnectionGracefulDisconnectPropertyInfo
instance AttrInfo TcpConnectionGracefulDisconnectPropertyInfo where
    type AttrAllowedOps TcpConnectionGracefulDisconnectPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TcpConnectionGracefulDisconnectPropertyInfo = IsTcpConnection
    type AttrSetTypeConstraint TcpConnectionGracefulDisconnectPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TcpConnectionGracefulDisconnectPropertyInfo = (~) Bool
    type AttrTransferType TcpConnectionGracefulDisconnectPropertyInfo = Bool
    type AttrGetType TcpConnectionGracefulDisconnectPropertyInfo = Bool
    type AttrLabel TcpConnectionGracefulDisconnectPropertyInfo = "graceful-disconnect"
    type AttrOrigin TcpConnectionGracefulDisconnectPropertyInfo = TcpConnection
    attrGet = getTcpConnectionGracefulDisconnect
    attrSet = setTcpConnectionGracefulDisconnect
    attrTransfer _ v = do
        return v
    attrConstruct = constructTcpConnectionGracefulDisconnect
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TcpConnection.gracefulDisconnect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TcpConnection.html#g:attr:gracefulDisconnect"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TcpConnection
type instance O.AttributeList TcpConnection = TcpConnectionAttributeList
type TcpConnectionAttributeList = ('[ '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("gracefulDisconnect", TcpConnectionGracefulDisconnectPropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("socket", Gio.SocketConnection.SocketConnectionSocketPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tcpConnectionGracefulDisconnect :: AttrLabelProxy "gracefulDisconnect"
tcpConnectionGracefulDisconnect = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TcpConnection = TcpConnectionSignalList
type TcpConnectionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TcpConnection::get_graceful_disconnect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TcpConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTcpConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tcp_connection_get_graceful_disconnect" g_tcp_connection_get_graceful_disconnect :: 
    Ptr TcpConnection ->                    -- connection : TInterface (Name {namespace = "Gio", name = "TcpConnection"})
    IO CInt

-- | Checks if graceful disconnects are used. See
-- 'GI.Gio.Objects.TcpConnection.tcpConnectionSetGracefulDisconnect'.
-- 
-- /Since: 2.22/
tcpConnectionGetGracefulDisconnect ::
    (B.CallStack.HasCallStack, MonadIO m, IsTcpConnection a) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.TcpConnection.TcpConnection'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if graceful disconnect is used on close, 'P.False' otherwise
tcpConnectionGetGracefulDisconnect connection = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    result <- g_tcp_connection_get_graceful_disconnect connection'
    let result' = (/= 0) result
    touchManagedPtr connection
    return result'

#if defined(ENABLE_OVERLOADING)
data TcpConnectionGetGracefulDisconnectMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTcpConnection a) => O.OverloadedMethod TcpConnectionGetGracefulDisconnectMethodInfo a signature where
    overloadedMethod = tcpConnectionGetGracefulDisconnect

instance O.OverloadedMethodInfo TcpConnectionGetGracefulDisconnectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TcpConnection.tcpConnectionGetGracefulDisconnect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TcpConnection.html#v:tcpConnectionGetGracefulDisconnect"
        })


#endif

-- method TcpConnection::set_graceful_disconnect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "TcpConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTcpConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "graceful_disconnect"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Whether to do graceful disconnects or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tcp_connection_set_graceful_disconnect" g_tcp_connection_set_graceful_disconnect :: 
    Ptr TcpConnection ->                    -- connection : TInterface (Name {namespace = "Gio", name = "TcpConnection"})
    CInt ->                                 -- graceful_disconnect : TBasicType TBoolean
    IO ()

-- | This enables graceful disconnects on close. A graceful disconnect
-- means that we signal the receiving end that the connection is terminated
-- and wait for it to close the connection before closing the connection.
-- 
-- A graceful disconnect means that we can be sure that we successfully sent
-- all the outstanding data to the other end, or get an error reported.
-- However, it also means we have to wait for all the data to reach the
-- other side and for it to acknowledge this by closing the socket, which may
-- take a while. For this reason it is disabled by default.
-- 
-- /Since: 2.22/
tcpConnectionSetGracefulDisconnect ::
    (B.CallStack.HasCallStack, MonadIO m, IsTcpConnection a) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.TcpConnection.TcpConnection'
    -> Bool
    -- ^ /@gracefulDisconnect@/: Whether to do graceful disconnects or not
    -> m ()
tcpConnectionSetGracefulDisconnect connection gracefulDisconnect = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    let gracefulDisconnect' = (P.fromIntegral . P.fromEnum) gracefulDisconnect
    g_tcp_connection_set_graceful_disconnect connection' gracefulDisconnect'
    touchManagedPtr connection
    return ()

#if defined(ENABLE_OVERLOADING)
data TcpConnectionSetGracefulDisconnectMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTcpConnection a) => O.OverloadedMethod TcpConnectionSetGracefulDisconnectMethodInfo a signature where
    overloadedMethod = tcpConnectionSetGracefulDisconnect

instance O.OverloadedMethodInfo TcpConnectionSetGracefulDisconnectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TcpConnection.tcpConnectionSetGracefulDisconnect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-TcpConnection.html#v:tcpConnectionSetGracefulDisconnect"
        })


#endif


