{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GSocketService@ is an object that represents a service that
-- is provided to the network or over local sockets.  When a new
-- connection is made to the service the [SocketService::incoming]("GI.Gio.Objects.SocketService#g:signal:incoming")
-- signal is emitted.
-- 
-- A @GSocketService@ is a subclass of t'GI.Gio.Objects.SocketListener.SocketListener' and you need
-- to add the addresses you want to accept connections on with the
-- t'GI.Gio.Objects.SocketListener.SocketListener' APIs.
-- 
-- There are two options for implementing a network service based on
-- @GSocketService@. The first is to create the service using
-- 'GI.Gio.Objects.SocketService.socketServiceNew' and to connect to the
-- [SocketService::incoming]("GI.Gio.Objects.SocketService#g:signal:incoming") signal. The second is to subclass
-- @GSocketService@ and override the default signal handler implementation.
-- 
-- In either case, the handler must immediately return, or else it
-- will block additional incoming connections from being serviced.
-- If you are interested in writing connection handlers that contain
-- blocking code then see t'GI.Gio.Objects.ThreadedSocketService.ThreadedSocketService'.
-- 
-- The socket service runs on the main loop of the
-- thread-default context (see
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault') of the thread it is
-- created in, and is not threadsafe in general. However, the calls to start and
-- stop the service are thread-safe so these can be used from threads that
-- handle incoming clients.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketService
    ( 

-- * Exported types
    SocketService(..)                       ,
    IsSocketService                         ,
    toSocketService                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [accept]("GI.Gio.Objects.SocketListener#g:method:accept"), [acceptAsync]("GI.Gio.Objects.SocketListener#g:method:acceptAsync"), [acceptFinish]("GI.Gio.Objects.SocketListener#g:method:acceptFinish"), [acceptSocket]("GI.Gio.Objects.SocketListener#g:method:acceptSocket"), [acceptSocketAsync]("GI.Gio.Objects.SocketListener#g:method:acceptSocketAsync"), [acceptSocketFinish]("GI.Gio.Objects.SocketListener#g:method:acceptSocketFinish"), [addAddress]("GI.Gio.Objects.SocketListener#g:method:addAddress"), [addAnyInetPort]("GI.Gio.Objects.SocketListener#g:method:addAnyInetPort"), [addInetPort]("GI.Gio.Objects.SocketListener#g:method:addInetPort"), [addSocket]("GI.Gio.Objects.SocketListener#g:method:addSocket"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gio.Objects.SocketListener#g:method:close"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isActive]("GI.Gio.Objects.SocketService#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [start]("GI.Gio.Objects.SocketService#g:method:start"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stop]("GI.Gio.Objects.SocketService#g:method:stop"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setBacklog]("GI.Gio.Objects.SocketListener#g:method:setBacklog"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketServiceMethod              ,
#endif

-- ** isActive #method:isActive#

#if defined(ENABLE_OVERLOADING)
    SocketServiceIsActiveMethodInfo         ,
#endif
    socketServiceIsActive                   ,


-- ** new #method:new#

    socketServiceNew                        ,


-- ** start #method:start#

#if defined(ENABLE_OVERLOADING)
    SocketServiceStartMethodInfo            ,
#endif
    socketServiceStart                      ,


-- ** stop #method:stop#

#if defined(ENABLE_OVERLOADING)
    SocketServiceStopMethodInfo             ,
#endif
    socketServiceStop                       ,




 -- * Properties


-- ** active #attr:active#
-- | Whether the service is currently accepting connections.
-- 
-- /Since: 2.46/

#if defined(ENABLE_OVERLOADING)
    SocketServiceActivePropertyInfo         ,
#endif
    constructSocketServiceActive            ,
    getSocketServiceActive                  ,
    setSocketServiceActive                  ,
#if defined(ENABLE_OVERLOADING)
    socketServiceActive                     ,
#endif




 -- * Signals


-- ** incoming #signal:incoming#

    SocketServiceIncomingCallback           ,
#if defined(ENABLE_OVERLOADING)
    SocketServiceIncomingSignalInfo         ,
#endif
    afterSocketServiceIncoming              ,
    onSocketServiceIncoming                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketListener as Gio.SocketListener
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketListener as Gio.SocketListener

#endif

-- | Memory-managed wrapper type.
newtype SocketService = SocketService (SP.ManagedPtr SocketService)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketService where
    toManagedPtr (SocketService p) = p

foreign import ccall "g_socket_service_get_type"
    c_g_socket_service_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketService where
    glibType = c_g_socket_service_get_type

instance B.Types.GObject SocketService

-- | Type class for types which can be safely cast to `SocketService`, for instance with `toSocketService`.
class (SP.GObject o, O.IsDescendantOf SocketService o) => IsSocketService o
instance (SP.GObject o, O.IsDescendantOf SocketService o) => IsSocketService o

instance O.HasParentTypes SocketService
type instance O.ParentTypes SocketService = '[Gio.SocketListener.SocketListener, GObject.Object.Object]

-- | Cast to `SocketService`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSocketService :: (MIO.MonadIO m, IsSocketService o) => o -> m SocketService
toSocketService = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketService

-- | Convert 'SocketService' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketService) where
    gvalueGType_ = c_g_socket_service_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketService)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketService)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketService ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketServiceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketServiceMethod "accept" o = Gio.SocketListener.SocketListenerAcceptMethodInfo
    ResolveSocketServiceMethod "acceptAsync" o = Gio.SocketListener.SocketListenerAcceptAsyncMethodInfo
    ResolveSocketServiceMethod "acceptFinish" o = Gio.SocketListener.SocketListenerAcceptFinishMethodInfo
    ResolveSocketServiceMethod "acceptSocket" o = Gio.SocketListener.SocketListenerAcceptSocketMethodInfo
    ResolveSocketServiceMethod "acceptSocketAsync" o = Gio.SocketListener.SocketListenerAcceptSocketAsyncMethodInfo
    ResolveSocketServiceMethod "acceptSocketFinish" o = Gio.SocketListener.SocketListenerAcceptSocketFinishMethodInfo
    ResolveSocketServiceMethod "addAddress" o = Gio.SocketListener.SocketListenerAddAddressMethodInfo
    ResolveSocketServiceMethod "addAnyInetPort" o = Gio.SocketListener.SocketListenerAddAnyInetPortMethodInfo
    ResolveSocketServiceMethod "addInetPort" o = Gio.SocketListener.SocketListenerAddInetPortMethodInfo
    ResolveSocketServiceMethod "addSocket" o = Gio.SocketListener.SocketListenerAddSocketMethodInfo
    ResolveSocketServiceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketServiceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketServiceMethod "close" o = Gio.SocketListener.SocketListenerCloseMethodInfo
    ResolveSocketServiceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketServiceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketServiceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketServiceMethod "isActive" o = SocketServiceIsActiveMethodInfo
    ResolveSocketServiceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketServiceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketServiceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketServiceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketServiceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketServiceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketServiceMethod "start" o = SocketServiceStartMethodInfo
    ResolveSocketServiceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketServiceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketServiceMethod "stop" o = SocketServiceStopMethodInfo
    ResolveSocketServiceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketServiceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketServiceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketServiceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketServiceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketServiceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketServiceMethod "setBacklog" o = Gio.SocketListener.SocketListenerSetBacklogMethodInfo
    ResolveSocketServiceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketServiceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketServiceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketServiceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketServiceMethod t SocketService, O.OverloadedMethod info SocketService p) => OL.IsLabel t (SocketService -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketServiceMethod t SocketService, O.OverloadedMethod info SocketService p, R.HasField t SocketService p) => R.HasField t SocketService p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketServiceMethod t SocketService, O.OverloadedMethodInfo info SocketService) => OL.IsLabel t (O.MethodProxy info SocketService) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SocketService::incoming
-- | The [incoming](#g:signal:incoming) signal is emitted when a new incoming connection
-- to /@service@/ needs to be handled. The handler must initiate the
-- handling of /@connection@/, but may not block; in essence,
-- asynchronous operations must be used.
-- 
-- /@connection@/ will be unreffed once the signal handler returns,
-- so you need to ref it yourself if you are planning to use it.
-- 
-- /Since: 2.22/
type SocketServiceIncomingCallback =
    Gio.SocketConnection.SocketConnection
    -- ^ /@connection@/: a new t'GI.Gio.Objects.SocketConnection.SocketConnection' object
    -> Maybe GObject.Object.Object
    -- ^ /@sourceObject@/: the source_object passed to
    --     'GI.Gio.Objects.SocketListener.socketListenerAddAddress'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop other handlers from being called

type C_SocketServiceIncomingCallback =
    Ptr SocketService ->                    -- object
    Ptr Gio.SocketConnection.SocketConnection ->
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_SocketServiceIncomingCallback`.
foreign import ccall "wrapper"
    mk_SocketServiceIncomingCallback :: C_SocketServiceIncomingCallback -> IO (FunPtr C_SocketServiceIncomingCallback)

wrap_SocketServiceIncomingCallback :: 
    GObject a => (a -> SocketServiceIncomingCallback) ->
    C_SocketServiceIncomingCallback
wrap_SocketServiceIncomingCallback gi'cb gi'selfPtr connection sourceObject _ = do
    connection' <- (newObject Gio.SocketConnection.SocketConnection) connection
    maybeSourceObject <-
        if sourceObject == FP.nullPtr
        then return Nothing
        else do
            sourceObject' <- (newObject GObject.Object.Object) sourceObject
            return $ Just sourceObject'
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  connection' maybeSourceObject
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [incoming](#signal:incoming) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' socketService #incoming callback
-- @
-- 
-- 
onSocketServiceIncoming :: (IsSocketService a, MonadIO m) => a -> ((?self :: a) => SocketServiceIncomingCallback) -> m SignalHandlerId
onSocketServiceIncoming obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketServiceIncomingCallback wrapped
    wrapped'' <- mk_SocketServiceIncomingCallback wrapped'
    connectSignalFunPtr obj "incoming" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [incoming](#signal:incoming) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' socketService #incoming callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSocketServiceIncoming :: (IsSocketService a, MonadIO m) => a -> ((?self :: a) => SocketServiceIncomingCallback) -> m SignalHandlerId
afterSocketServiceIncoming obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketServiceIncomingCallback wrapped
    wrapped'' <- mk_SocketServiceIncomingCallback wrapped'
    connectSignalFunPtr obj "incoming" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SocketServiceIncomingSignalInfo
instance SignalInfo SocketServiceIncomingSignalInfo where
    type HaskellCallbackType SocketServiceIncomingSignalInfo = SocketServiceIncomingCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SocketServiceIncomingCallback cb
        cb'' <- mk_SocketServiceIncomingCallback cb'
        connectSignalFunPtr obj "incoming" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketService::incoming"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketService.html#g:signal:incoming"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketService #active
-- @
getSocketServiceActive :: (MonadIO m, IsSocketService o) => o -> m Bool
getSocketServiceActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "active"

-- | Set the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketService [ #active 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketServiceActive :: (MonadIO m, IsSocketService o) => o -> Bool -> m ()
setSocketServiceActive obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "active" val

-- | Construct a `GValueConstruct` with valid value for the “@active@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketServiceActive :: (IsSocketService o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSocketServiceActive val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "active" val

#if defined(ENABLE_OVERLOADING)
data SocketServiceActivePropertyInfo
instance AttrInfo SocketServiceActivePropertyInfo where
    type AttrAllowedOps SocketServiceActivePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketServiceActivePropertyInfo = IsSocketService
    type AttrSetTypeConstraint SocketServiceActivePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SocketServiceActivePropertyInfo = (~) Bool
    type AttrTransferType SocketServiceActivePropertyInfo = Bool
    type AttrGetType SocketServiceActivePropertyInfo = Bool
    type AttrLabel SocketServiceActivePropertyInfo = "active"
    type AttrOrigin SocketServiceActivePropertyInfo = SocketService
    attrGet = getSocketServiceActive
    attrSet = setSocketServiceActive
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketServiceActive
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketService.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketService.html#g:attr:active"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketService
type instance O.AttributeList SocketService = SocketServiceAttributeList
type SocketServiceAttributeList = ('[ '("active", SocketServiceActivePropertyInfo), '("listenBacklog", Gio.SocketListener.SocketListenerListenBacklogPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
socketServiceActive :: AttrLabelProxy "active"
socketServiceActive = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketService = SocketServiceSignalList
type SocketServiceSignalList = ('[ '("event", Gio.SocketListener.SocketListenerEventSignalInfo), '("incoming", SocketServiceIncomingSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketService::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketService" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_service_new" g_socket_service_new :: 
    IO (Ptr SocketService)

-- | Creates a new t'GI.Gio.Objects.SocketService.SocketService' with no sockets to listen for.
-- New listeners can be added with e.g. 'GI.Gio.Objects.SocketListener.socketListenerAddAddress'
-- or 'GI.Gio.Objects.SocketListener.socketListenerAddInetPort'.
-- 
-- New services are created active, there is no need to call
-- 'GI.Gio.Objects.SocketService.socketServiceStart', unless 'GI.Gio.Objects.SocketService.socketServiceStop' has been
-- called before.
-- 
-- /Since: 2.22/
socketServiceNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SocketService
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SocketService.SocketService'.
socketServiceNew  = liftIO $ do
    result <- g_socket_service_new
    checkUnexpectedReturnNULL "socketServiceNew" result
    result' <- (wrapObject SocketService) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SocketService::is_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "service"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketService" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketService" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_service_is_active" g_socket_service_is_active :: 
    Ptr SocketService ->                    -- service : TInterface (Name {namespace = "Gio", name = "SocketService"})
    IO CInt

-- | Check whether the service is active or not. An active
-- service will accept new clients that connect, while
-- a non-active service will let connecting clients queue
-- up until the service is started.
-- 
-- /Since: 2.22/
socketServiceIsActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketService a) =>
    a
    -- ^ /@service@/: a t'GI.Gio.Objects.SocketService.SocketService'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the service is active, 'P.False' otherwise
socketServiceIsActive service = liftIO $ do
    service' <- unsafeManagedPtrCastPtr service
    result <- g_socket_service_is_active service'
    let result' = (/= 0) result
    touchManagedPtr service
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketServiceIsActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSocketService a) => O.OverloadedMethod SocketServiceIsActiveMethodInfo a signature where
    overloadedMethod = socketServiceIsActive

instance O.OverloadedMethodInfo SocketServiceIsActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketService.socketServiceIsActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketService.html#v:socketServiceIsActive"
        })


#endif

-- method SocketService::start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "service"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketService" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketService" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_service_start" g_socket_service_start :: 
    Ptr SocketService ->                    -- service : TInterface (Name {namespace = "Gio", name = "SocketService"})
    IO ()

-- | Restarts the service, i.e. start accepting connections
-- from the added sockets when the mainloop runs. This only needs
-- to be called after the service has been stopped from
-- 'GI.Gio.Objects.SocketService.socketServiceStop'.
-- 
-- This call is thread-safe, so it may be called from a thread
-- handling an incoming client request.
-- 
-- /Since: 2.22/
socketServiceStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketService a) =>
    a
    -- ^ /@service@/: a t'GI.Gio.Objects.SocketService.SocketService'
    -> m ()
socketServiceStart service = liftIO $ do
    service' <- unsafeManagedPtrCastPtr service
    g_socket_service_start service'
    touchManagedPtr service
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketServiceStartMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSocketService a) => O.OverloadedMethod SocketServiceStartMethodInfo a signature where
    overloadedMethod = socketServiceStart

instance O.OverloadedMethodInfo SocketServiceStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketService.socketServiceStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketService.html#v:socketServiceStart"
        })


#endif

-- method SocketService::stop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "service"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketService" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketService" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_service_stop" g_socket_service_stop :: 
    Ptr SocketService ->                    -- service : TInterface (Name {namespace = "Gio", name = "SocketService"})
    IO ()

-- | Stops the service, i.e. stops accepting connections
-- from the added sockets when the mainloop runs.
-- 
-- This call is thread-safe, so it may be called from a thread
-- handling an incoming client request.
-- 
-- Note that this only stops accepting new connections; it does not
-- close the listening sockets, and you can call
-- 'GI.Gio.Objects.SocketService.socketServiceStart' again later to begin listening again. To
-- close the listening sockets, call 'GI.Gio.Objects.SocketListener.socketListenerClose'. (This
-- will happen automatically when the t'GI.Gio.Objects.SocketService.SocketService' is finalized.)
-- 
-- This must be called before calling 'GI.Gio.Objects.SocketListener.socketListenerClose' as
-- the socket service will start accepting connections immediately
-- when a new socket is added.
-- 
-- /Since: 2.22/
socketServiceStop ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketService a) =>
    a
    -- ^ /@service@/: a t'GI.Gio.Objects.SocketService.SocketService'
    -> m ()
socketServiceStop service = liftIO $ do
    service' <- unsafeManagedPtrCastPtr service
    g_socket_service_stop service'
    touchManagedPtr service
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketServiceStopMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSocketService a) => O.OverloadedMethod SocketServiceStopMethodInfo a signature where
    overloadedMethod = socketServiceStop

instance O.OverloadedMethodInfo SocketServiceStopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketService.socketServiceStop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketService.html#v:socketServiceStop"
        })


#endif


